#
# Copyright (C) 2009  Robert Millan
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

SHELL = bash

override_file ?= /dev/null

INDEXES = \
	$(foreach arch, $(arches), dists/$(release)/main/binary-$(arch)/Release) \
	$(foreach p, Packages Packages.gz Packages.bz2 Packages.lzma, \
		$(foreach arch, $(arches), dists/$(release)/main/binary-$(arch)/$(p)) \
	) \
	$(foreach arch, $(arches), dists/$(release)/main/debian-installer/binary-$(arch)/Release) \
	$(foreach p, Packages Packages.gz Packages.bz2 Packages.lzma, \
		$(foreach arch, $(arches), dists/$(release)/main/debian-installer/binary-$(arch)/$(p)) \
	) \
	$(foreach arch, $(arches), dists/$(release)/main/source/Release) \
	$(foreach s, Sources Sources.gz Sources.bz2 Sources.lzma, \
		$(foreach arch, $(arches), dists/$(release)/main/source/$(s)) \
	) \
	$(NULL)

dists: dists/$(release)/Release dists/$(release)/Release.gpg archive-key.asc $(INDEXES)

$(foreach arch, $(arches), dists/%/main/binary-$(arch)/Packages): $(pkgdir)
	base=`echo $@ | sed -e s,/binary-.*,,g` ; \
	for arch in $(arches) ; do \
		mkdir -p $$base/binary-$$arch ; \
		dpkg-scanpackages -a $$arch $^ $(override_file) > $$base/binary-$$arch/Packages ; \
	done

$(foreach arch, $(arches), dists/%/main/debian-installer/binary-$(arch)/Packages): $(pkgdir)
	base=`echo $@ | sed -e s,/binary-.*,,g` ; \
	for arch in $(arches) ; do \
		mkdir -p $$base/binary-$$arch ; \
		dpkg-scanpackages -u -a $$arch $^ $(override_file) > $$base/binary-$$arch/Packages ; \
	done

dists/%/main/source/Sources: $(pkgdir)
	mkdir -p `dirname $@`
	dpkg-scansources $^ $(override_file) > $@

%.gz: %
	gzip -9 -n < $^ > $@

%.bz2: %
	bzip2 -9 < $^ > $@

%.lzma: %
	lzma -9 < $^ > $@

dists/%/Release: $(INDEXES)
	mkdir -p `dirname $@`

	# FIXME: some of these still need to be made configurable, but which
	# ones actually matter?
	(echo "Origin: Debian" ; \
	echo "Label: Debian" ; \
	echo "Suite: stable" ; \
	echo "Codename: $(release)" ; \
	echo "Date: Fri, 09 Jan 2009 08:32:38 UTC" ; \
	echo "Valid-Until: Fri, 16 Jan 2099 08:32:38 UTC" ; \
	echo "Architectures: $(arches)" ; \
	echo "Components: main" ; \
	echo "Description: $(description)") > $@

	echo "MD5Sum:" >> $@
	for i in $^ ; do \
		echo " `md5sum $$i | sed -e "s/ .*//g"` `wc -c < $$i` `echo $$i | sed -e "s,^dists/[^/]*/,,g"`" ; \
	done >> $@
	echo "SHA1:" >> $@
	for i in $^ ; do \
		echo " `sha1sum $$i | sed -e "s/ .*//g"` `wc -c < $$i` `echo $$i | sed -e "s,^dists/[^/]*/,,g"`" ; \
	done >> $@
	if which sha256sum > /dev/null ; then \
		echo "SHA256:" >> $@ ; \
		for i in $^ ; do \
			echo " `sha256sum $$i | sed -e "s/ .*//g"` `wc -c < $$i` `echo $$i | sed -e "s,^dists/[^/]*/,,g"`" ; \
		done >> $@ ; \
	else \
		echo "WARNING: sha256sum not found, won't include SHA256 hash" >&2 ; \
	fi

$(foreach arch, $(arches), dists/$(release)/main/binary-$(arch)/Release dists/$(release)/main/debian-installer/binary-$(arch)/Release):
	for arch in $(arches) ; do \
		mkdir -p dists/$(release)/main/{debian-installer/,}binary-$$arch ; \
		(echo "Archive: stable" ; \
		echo "Version: 5.0" ; \
		echo "Component: main" ; \
		echo "Origin: Debian" ; \
		echo "Label: Debian" ; \
		echo "Architecture: $$arch") \
		| tee dists/$(release)/main/binary-$$arch/Release \
		> dists/$(release)/main/debian-installer/binary-$$arch/Release ; \
	done

dists/$(release)/main/source/Release:
	mkdir -p `dirname $@`
	(echo "Archive: stable" ; \
	echo "Version: 5.0" ; \
	echo "Component: main" ; \
	echo "Origin: Debian" ; \
	echo "Label: Debian" ; \
	echo "Architecture: source") \
	> dists/$(release)/main/source/Release

dists/%/Release.gpg: dists/%/Release
	gpg --default-key $(key) --detach-sign -a < $< > $@

archive-key.asc:
	gpg --export -a $(key) > $@
