# vsdump: test program to dump and parse content of vsd file
#
# Copyright (C) 2006-2007	Valek Filippov (frob@df.ru)
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 3 or later of the GNU General Public
# License as published by the Free Software Foundation.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301
# USA
import vsdoc
import inflate
import struct
import gsf
import tree
import chunks

streamtype = {0x14:'Trailer', 0x15:'Page', 0x16:'Colors', 0x18:'Fonts', 0x1a:'Styles',\
                        0x1d:'Stencil', 0x23:'Icon', 0x31:'Document',0xd7:'FontFace',0xd8:'FontFaces'}

def ptr_search(res, ptrs, shift,model, parent):
    [offset] = struct.unpack('<L', res[shift:shift+4])
    offset = offset + shift
##    print 'Offset: %x Len: %x'%(offset,len(res))
    size = 18*ord(res[offset])
##    print 'res[offset]: %x'%ord(res[offset])
    offset = offset + 8
    j = 1
    for i in range(offset, offset+size, 18):
       [data] = struct.unpack('<L', res[i:i+4])
       if data:
            pntr = vsdoc.pointer()
            pntr.type = data
            [pntr.address] = struct.unpack('<L', res[i+4:i+8])
            [pntr.offset] = struct.unpack('<L', res[i+8:i+12])
            [pntr.length] = struct.unpack('<L', res[i+12:i+16])
            [pntr.format] = struct.unpack('<h', res[i+16:i+18])
            pntr.path = parent
            itername = 'T/A/O/L/F: %02x \t%07x \t%04x \t%04x \t%02x'%(pntr.type,pntr.address,pntr.offset,pntr.length,pntr.format)
            if streamtype.has_key(pntr.type):
##                itername = streamtype[pntr.type]+' \t(Size: %x)'%pntr.length
                itername = streamtype[pntr.type]+' %x \tA/O/L/F: %07x \t%04x \t%04x \t%02x'%(j,pntr.address,pntr.offset,pntr.length,pntr.format)
            iter = tree.tree_append(model, pntr, itername)
            j+=1
            pntr.path = iter
            ptrs.append(pntr)


def vsdopen(fname,model):
    src = gsf.InputStdio(fname)
    infile = gsf.InfileMSOle(src)
    vsd = None
    for i in range(infile.num_children()):
        infchild = infile.child_by_index(i)
        infname = infile.name_by_index(i)
        if ord(infname[0]) == 5: 
            infname = infname[1:]
        pntr = vsdoc.pointer()
        pntr.length = infchild.size()
        pntr.path = None
        itername = infname + ' \t(Size: %x)'%pntr.length
        iter = tree.tree_append(model, pntr, itername)
        if infname == 'VisioDocument':
            vsd = iter
        pntr.data = infchild.read(pntr.length)
        pntr.path = iter
    return vsd
   
def vsdparse(vsdpntr, model,cr):
    doc = vsdoc.vsdoc()
    ver_offset = 0x1a
    size_offset = 0x1c
    trlr_offset = 0x24
    vsd = vsdpntr.data
    doc.version = ord(vsd[ver_offset])
    
    pntr = vsdoc.pointer()
    ptrs = doc.pntrs 
    [pntr.type] = struct.unpack('<L', vsd[trlr_offset:trlr_offset+4])
    [pntr.address] = struct.unpack('<L', vsd[trlr_offset+4:trlr_offset+8])
    [pntr.offset] = struct.unpack('<L', vsd[trlr_offset+8:trlr_offset+12])
    [pntr.length] = struct.unpack('<L', vsd[trlr_offset+12:trlr_offset+16])
    [pntr.format] = struct.unpack('<h', vsd[trlr_offset+16:trlr_offset+18])
    pntr.path = vsdpntr.path
    itername = 'T/A/O/L/F: %02x \t%07x \t%04x \t%04x \t%02x'%(pntr.type,pntr.address,pntr.offset,pntr.length,pntr.format)
    if streamtype.has_key(pntr.type):
##        itername = streamtype[pntr.type]+' \t(Size: %x)'%pntr.length
        itername = streamtype[pntr.type]+' \tA/O/L/F: \t%07x \t%04x \t%04x \t%02x'%(pntr.address,pntr.offset,pntr.length,pntr.format)
    iter = tree.tree_append(model, pntr, itername)
    pntr.path = iter
##    print 'T/A/O/L/F: %02x \t%07x \t%04x \t%04x \t%02x'%(pntr.type,pntr.address,pntr.offset,pntr.length,pntr.format),pntr.path
    ptrs.append(pntr)
    
    i = 0
    while i < len(ptrs):
        pntr = ptrs[i]
        i = i + 1
##        print 'T/A/O/L/F: %02x \t%07x \t%04x \t%04x \t%02x'%(pntr.type,pntr.address,pntr.offset,pntr.length,pntr.format)
        if pntr.format>>4 == 5 and pntr.type != 0x16:
            if pntr.format&2 == 2 : #compressed
                res = inflate.inflate(pntr, vsd)
                shift = 4
            else:
                res = vsd[pntr.offset:pntr.offset+pntr.length]
                shift = 0
            pntr.data = res
            ptr_search(res, ptrs, shift,model,pntr.path)

    i = 0
    while i < len(ptrs):
        pntr = ptrs[i]
        i = i + 1
        if len(pntr.data) == 0:
            if pntr.format&2 == 2 : #compressed
                res = inflate.inflate(pntr, vsd)
            else:
                res = vsd[pntr.offset:pntr.offset+pntr.length]
            pntr.data = res
        if pntr.format>>4 == 0xd:
##            print 'T/A/O/L/F: %02x \t%07x \t%04x \t%04x \t%02x'%(pntr.type,pntr.address,pntr.offset,pntr.length,pntr.format)
            chunks.parse(pntr,model,doc.version,cr)
    return doc

def getpagenum(doc):
    pnum = 0
    for i in range(len(doc.pntrs)):
        pntr = doc.pntrs[i]
        if pntr.type == 0x15:
            pnum = pnum + 1
            ptr = pntr
    return ptr,pnum
    
def getcolors(doc):
    colors = doc.colors
    for i in range(len(doc.pntrs)):
        pntr = doc.pntrs[i]
        if pntr.type == 0x16:
            break
    
##    print 'Type: %02x\tAddr: %08x\tOffs: %04x\tLen: %x  \tFrmt: %x'%(pntr.type,pntr.address,pntr.offset,pntr.length,pntr.format)
    res = pntr.data
    clrnum = ord(res[6])
##    print 'Num of colors: %u'%clrnum
    for i in range(clrnum):
        clr = vsdoc.color()
        clr.r = ord(res[8+i*4])
        clr.g = ord(res[9+i*4])
        clr.b = ord(res[10+i*4])
        colors.append(clr)
    
##    for i in range(len(colors)):
##        clr = colors[i]
##        print 'ColorEntry IX=%u  RGB=#%02x%02x%02x'%(i, clr.r,clr.g,clr.b)

    
    
    
