#!/bin/sh
# Various function used by the install scripts

source /etc/vservers.conf

USR_LIB_VSERVER=/usr/lib/vserver
ETC_VSERVERS=/etc/vservers

# checkargs script-name script arguments
checkargs(){
	if [ $# -lt 2 ] ; then
		echo $1 vserver-id [ type ]
		echo type minimum means, minimum package for a server
		echo type large means, all packages on the first CD
		exit 1
	fi
}

# Read the configuration file if exist
readconf(){
	if [ -f $ETC_VSERVERS/$1.conf ] ; then
		eval `$USR_LIB_VSERVER/printconf.sh --quote $1`
		VROOT=$VSERVERDIR
	else
		VROOT=$VSERVERS_ROOT/$1
	fi
}

# Check if the vserver is already installed
checkexist(){
	if [ -d $VROOT/var/lib/rpm ] ; then
		echo $VROOT already exist
		exit 1
	fi
}
# Check if the RPMs are available
checkrpms(){
	if [ ! -d $1 ] ; then
		echo No rpms in $1. Is the CD mounted \?
		exit 1
	fi
}

