/* (C) 1998 Justin Schoeman */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>                     
#include <string.h>                     
#include <stdio.h>
#include <stdlib.h>

struct jfs_cmd
{
 char cmd[256];
 unsigned int len;
};

struct jfs_cmd jfs_cmd_tab[256]; /* Maximum 256 commands */  

int jfs_stream[256][256];
unsigned int jfs_first[256];
unsigned int jfs_size=-1;
unsigned char *sframe, *tframe;
int jfs_width, jfs_height;

void jfs_getit(int group, unsigned int frame)
{  
 unsigned char t1, t2;
 int file=0, i;
 unsigned int thisframe;

 frame=(frame<<1)+jfs_first[group];
 read(jfs_stream[group][file], &thisframe, sizeof(thisframe));
 lseek(jfs_stream[group][file], -sizeof(thisframe), SEEK_CUR);
 if(frame>thisframe) /* search forwards */
 {
  while(frame>thisframe)
  {
   if(jfs_stream[group][++file]==-1)
   {
    for(file--; file>=0; file--)
     lseek(jfs_stream[group][file], jfs_size+sizeof(thisframe), SEEK_CUR);
    file++;
   }
   read(jfs_stream[group][file], &thisframe, sizeof(thisframe));
   lseek(jfs_stream[group][file], -sizeof(thisframe), SEEK_CUR);
  }
  if(thisframe!=frame) /* forward too far - go back 1 */
  {
   if(file==0)
    while(jfs_stream[group][file]!=-1)
     lseek(jfs_stream[group][file++], -(jfs_size+sizeof(thisframe)), SEEK_CUR);
   file--;
   read(jfs_stream[group][file], &thisframe, sizeof(thisframe));
   lseek(jfs_stream[group][file], -sizeof(thisframe), SEEK_CUR);
  }
 } else if(frame<thisframe)
 {
  while(frame<thisframe) /* search backward */
  {
   if(file==0)
    while(jfs_stream[group][file]!=-1)
     lseek(jfs_stream[group][file++], -(jfs_size+sizeof(thisframe)), SEEK_CUR);
   file--;
   read(jfs_stream[group][file], &thisframe, sizeof(thisframe));
   lseek(jfs_stream[group][file], -sizeof(thisframe), SEEK_CUR);
  }
 }
 lseek(jfs_stream[group][file], sizeof(thisframe), SEEK_CUR);
 fprintf(stderr,"Frame requested: %u  Frame retrieved: %u\n", frame, thisframe);
 for (i=0; i<(jfs_size>>1); i++)
 {
  read(jfs_stream[group][file], &t1, sizeof(t1));
  read(jfs_stream[group][file], &t2, sizeof(t2));
  sframe[i*3]=t2&0xf8;
  sframe[(i*3)+1]=((t2<<5)&0xe0)|((t1>>3)&0x1c);
  sframe[(i*3)+2]=(t1<<3)&0xf8;
 }
 lseek(jfs_stream[group][file], -(sizeof(thisframe)+jfs_size), SEEK_CUR); /* lets keep our file pointers nice and orderly */
}

unsigned char *getframe(char *fname)
{
 char name[1024], junk[1024];
 unsigned int newframe, bmark;
 int i,j,k,l,m;
 FILE *cliptab;
 
 for(i=0; fname[i]!=':'; i++)name[i]=fname[i];
 name[i]=(char)0;
 newframe=(unsigned int)atoi(&fname[i+1]);
 if(jfs_size==-1) /* First time - open file and get details */
 {
  fprintf(stderr, "INITIALISING VIDEO FILES\n");
  sprintf(&(name[i]), ":cliptab");
  cliptab=fopen(name, "r");
  if(!cliptab)
  {
   perror("open cliptab");
   exit(-1);
  }
  i=0;
  while(strcmp(fgets(name, 1024, cliptab),"*\n")!=0)
  {
   strcpy(&(name[strlen(name)])," !!END!! ");
   fprintf(stderr, "group %d: ", i);
   j=0;
   sscanf(name, "%s %1024c", junk, name);
   while(strcmp(junk,"!!END!!")!=0)
   {
    if(j==0)j++; /* skip audio file */
     else
    {
     fprintf(stderr, "[%s]", junk);
     jfs_stream[i][j-1]=open(junk, O_RDONLY);
     if(jfs_stream[i][j-1]<=0)
     {
      perror("open video file");
      exit(-1);
     }
     j++;
    }
    sscanf(name, "%s %1024c", junk, name);
   } 
   jfs_stream[i][j-1]=-1;
   fprintf(stderr,"\n");
   read(jfs_stream[i][0], &jfs_width, sizeof(jfs_width)); /* width */
   read(jfs_stream[i][0], &jfs_height, sizeof(jfs_height)); /* height */
   read(jfs_stream[i][0], &jfs_first[i], sizeof(jfs_first[i])); /* dummy for lastfield */
   read(jfs_stream[i][0], &jfs_first[i], sizeof(jfs_first[i]));
   lseek(jfs_stream[i][0], -sizeof(jfs_first[i]), SEEK_CUR);
   i++;
  }
  jfs_size=jfs_width*jfs_height*2;
  sframe=(unsigned char*)malloc(jfs_width*jfs_height*3);
  if(sframe==NULL)
  {
   fprintf(stderr,"Couldn't allocate storage for sframe\n");
   exit(-1);
  }
  tframe=(unsigned char*)malloc(jfs_width*jfs_height*3);
  if(tframe==NULL)
  {
   fprintf(stderr,"Couldn't allocate storage for tframe\n");
   exit(-1);
  }
 
 
  i=0;
  
  while(fgets(&(jfs_cmd_tab[i].cmd[0]), 256, cliptab))
  {
   switch(jfs_cmd_tab[i].cmd[0])
   {
    case 'B': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d", &(junk[0]), &j, &k, &(jfs_cmd_tab[i].len));
              fprintf(stderr, "Block group %u start %u length %u\n", j, k, jfs_cmd_tab[i].len);
              break;
    case 'F': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d", &(junk[0]), &j, &k, &(jfs_cmd_tab[i].len));
              fprintf(stderr, "Block group %u start %u length %u (fade to black)\n", j, k, jfs_cmd_tab[i].len);
              break;
    case 'f': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d", &(junk[0]), &j, &k, &(jfs_cmd_tab[i].len));
              fprintf(stderr, "Block group %u start %u length %u (fade from black)\n", j, k, jfs_cmd_tab[i].len);
              break;
    case 'O': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d %d %d", &(junk[0]), &j, &k, &(jfs_cmd_tab[i].len), &l, &m);
              fprintf(stderr, "Block group %u start %u length %u (OV group %u start %u)\n", j, k, jfs_cmd_tab[i].len, l, m);
              break;
    case 'X': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d %d %d", &(junk[0]), &j, &k, &(jfs_cmd_tab[i].len), &l, &m);
              fprintf(stderr, "Block group %u start %u length %u (mix to group %u start %u)\n", j, k, jfs_cmd_tab[i].len, l, m);
              break;
    default: fprintf(stderr, "Unknown edit command\n");
    	     exit(-1);
   }
   i++;
  }
 }
 fprintf(stderr, "Fetching frame %u = ", newframe);
 bmark=0;
 i=0;
 while(newframe>=(bmark+=jfs_cmd_tab[i].len))i++;
 switch(jfs_cmd_tab[i].cmd[0])
 {
  case 'B': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d", &(junk[0]), &j, &k, (int *)&(junk[0]));
            newframe=(newframe-bmark)+k+jfs_cmd_tab[i].len;
            fprintf(stderr, "%u of group %d.\n", newframe, j);
            jfs_getit(j, newframe);
            break;
  case 'F': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d", &(junk[0]), &j, &k, (int *)&(junk[0]));
            newframe=(newframe-bmark)+k+jfs_cmd_tab[i].len;
            fprintf(stderr, "%u of group %d (fade %f).\n", newframe, j,(1-(float)(newframe-k)/(float)jfs_cmd_tab[i].len));
            jfs_getit(j, newframe);
            for(j=0; j<(jfs_width*jfs_height*3); j++)
             sframe[j]=sframe[j]*(1-(float)((float)(newframe-k)/(float)(jfs_cmd_tab[i].len)));
            break;
  case 'f': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d", &(junk[0]), &j, &k, (int *)&(junk[0]));
            newframe=(newframe-bmark)+k+jfs_cmd_tab[i].len;
            fprintf(stderr, "%u of group %d (fade %f).\n", newframe, j,(float)(newframe-k)/(float)jfs_cmd_tab[i].len);
            jfs_getit(j, newframe);
            for(j=0; j<(jfs_width*jfs_height*3); j++)
             sframe[j]=sframe[j]*((float)((float)(newframe-k)/(float)(jfs_cmd_tab[i].len)));
            break;
  case 'X': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d %d %d", &(junk[0]), &j, &k, (int *)&(junk[0]), &l, &m);
            newframe=(newframe-bmark)+k+jfs_cmd_tab[i].len;
            fprintf(stderr, "%u of group %d.\n", newframe, j);
            jfs_getit(j, newframe);
            bcopy(sframe, tframe, (jfs_width*jfs_height*3));
            newframe=(newframe-k)+m;
            fprintf(stderr, "Mix to = %u of group %d.\n", newframe, l);
            jfs_getit(l, newframe);
            for(j=0; j<(jfs_width*jfs_height*3); j++)
             sframe[j]=tframe[j]*(1-((float)(newframe-m)/(float)(jfs_cmd_tab[i].len)))+sframe[j]*((float)(newframe-m)/(float)(jfs_cmd_tab[i].len));
            break;
  case 'O': sscanf(jfs_cmd_tab[i].cmd, "%c %d %d %d %d %d", &(junk[0]), &j, &k, (int *)&(junk[0]), &l, &m);
            newframe=(newframe-bmark)+k+jfs_cmd_tab[i].len;
            fprintf(stderr, "%u of group %d.\n", newframe, j);
            jfs_getit(j, newframe);
            bcopy(sframe, tframe, (jfs_width*jfs_height*3));
            newframe=(newframe-k)+m;
            fprintf(stderr, "Overlay = %u of group %d.\n", newframe, l);
            jfs_getit(l, newframe);
            for(i=0; i<(jfs_width*jfs_height); i++)
             if((sframe[i*3]==0)&(sframe[(i*3)+1]==0)&(sframe[(i*3)+2]==0))
             {
              sframe[i*3]=tframe[i*3];
              sframe[(i*3)+1]=tframe[(i*3)+1];
              sframe[(i*3)+2]=tframe[(i*3)+2];
             }
            break;
  default: fprintf(stderr, "Unknown edit command\n");
    	   exit(-1);
 }
 
 
 
 return sframe; 
}
