/* (C) 1998 Justin Schoeman */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>

extern unsigned char *getframe(char *fname);

void usage(void)
{
 printf("Usage:\n\n");
 printf(" str2ppm [-str <output stream 1> [-str <...>]] <parameter file>\n\n");
 exit(0);
}


int main(int argc, char** argv)
{
 FILE* out;
 FILE* par;
 int width, height; 
 char fname[256], fstr[256], tmp[256];
 unsigned int maxframe, i;
 unsigned char *sframe, *oframe;
 int ostr[256], ostrnum, ostrcur=0, temp, p;
 
 for(i=1; (i<argc)&&(argv[i][0]=='-'); i++)
 {
  if(strcmp(argv[i],"-str")==0)
  {
   if(argc<(i+2))usage();
   ostr[ostrcur]=open(argv[++i], O_RDWR|O_TRUNC|O_CREAT, S_IRUSR|S_IWUSR);
   fprintf(stderr, "Adding output stream %s.\n", argv[i]);
   if(ostr[ostrcur++]<0)
   {
    perror("opening out stream");
    exit(-1);
   }
  }
 }
 ostrnum=ostrcur;
 ostrcur=0;
 if(argc<(i+1))usage();
 par=fopen(argv[i],"r");
 fgets(tmp, 256, par);
 fgets(fstr, 256, par);
 fstr[strlen(fstr)-1]='\0';
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 sscanf(tmp, "%u", &maxframe);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 fgets(tmp, 256, par);
 sscanf(tmp, "%u", &width);
 fgets(tmp, 256, par);
 sscanf(tmp, "%u", &height);
 fclose(par);

 oframe=(unsigned char *)malloc(width*height*2);
 if(!oframe)
 {
  perror("allocating output buffer");
  exit(-1);
 }
 
 if(ostrnum!=0)
 {
  write(ostr[0], &width, sizeof(width));
  write(ostr[0], &height, sizeof(height));
  maxframe=maxframe*2;
  write(ostr[0], &maxframe, sizeof(maxframe));
  maxframe=maxframe/2;
 }
 
 for(i=0; i<maxframe; i++)
 {
  sprintf(fname, fstr, i);
  sframe=getframe(fname);
  if(ostrnum==0)
  {
   sprintf(tmp,"%s.ppm", fname);
   out=fopen(tmp,"w");
   fprintf(out, "P6\n%d %d\n255\n", width, height);
   fwrite(sframe, width*height*3, 1, out);
   fclose(out);
  } else
  {
   i=i*2;
   write(ostr[ostrcur], &i, sizeof(i));
   i=i/2;
   for(p=0; p<(width*height); p++)
   {
    temp = (int)((int)sframe[(p*3)+2] >> 3);
    temp |= (int)(((int)sframe[(p*3)+1] >> 2) << 5);
    temp |= (int)(((int)sframe[(p*3)+0] >> 3) << 11);
    oframe[p*2]=(unsigned char)temp&0xff;
    oframe[(p*2)+1]=(unsigned char)(temp>>8);
   }
   write(ostr[ostrcur], oframe, width*height*2);
   if(++ostrcur==ostrnum)ostrcur=0;
  }
 }
 return 0;
}
