/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkIOStreamFwd.h,v $
  Language:  C++
  Date:      $Date: 2002/12/13 22:22:24 $
  Version:   $Revision: 1.3 $

  Copyright (c) 1993-2002 Ken Martin, Will Schroeder, Bill Lorensen 
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even 
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
// .NAME vtkIOStreamFwd - Forward-declare C++ iostreams as used by VTK.
// .SECTION Description
// VTK supports both ANSI and old-style streams.  This header
// forward-declares the proper streams according to
// VTK_USE_ANSI_STDLIB.

#ifndef __vtkIOStreamFwd_h
#define __vtkIOStreamFwd_h

#include "vtkConfigure.h"

#ifdef VTK_USE_ANSI_STDLIB

// Forward-declare ansi streams.
# include <iosfwd>
using std::ios;
using std::streambuf;
using std::istream;
using std::ostream;
using std::iostream;
using std::filebuf;
using std::ifstream;
using std::ofstream;
using std::fstream;
#else
# ifdef __BORLANDC__
#  include <iosfwd.h>
# else

// Forward-declare non-ansi streams.
class ios;
class streambuf;
class istream;
class ostream;
class iostream;
class filebuf;
class ifstream;
class ofstream;
class fstream;
# endif

#endif


#endif // __vtkIOStreamFwd_h
