/*=========================================================================

  Program:   Visualization Toolkit
  Module:    $RCSfile: vtkPainterDeviceAdapter.cxx,v $

  Copyright (c) Ken Martin, Will Schroeder, Bill Lorensen
  All rights reserved.
  See Copyright.txt or http://www.kitware.com/Copyright.htm for details.

     This software is distributed WITHOUT ANY WARRANTY; without even
     the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
     PURPOSE.  See the above copyright notice for more information.

=========================================================================*/
/*
 * Copyright 2004 Sandia Corporation.
 * Under the terms of Contract DE-AC04-94AL85000, there is a non-exclusive
 * license for use of this work by or on behalf of the
 * U.S. Government. Redistribution and use in source and binary forms, with
 * or without modification, are permitted provided that this Notice and any
 * statement of authorship are reproduced on all copies.
 */

#include "vtkPainterDeviceAdapter.h"

#include "vtkGraphicsFactory.h"
#include "vtkObjectFactory.h"

// Needed when we don't use the vtkStandardNewMacro.
vtkInstantiatorNewMacro(vtkPainterDeviceAdapter);
vtkCxxRevisionMacro(vtkPainterDeviceAdapter, "$Revision: 1.5 $");

//-----------------------------------------------------------------------------
vtkPainterDeviceAdapter::vtkPainterDeviceAdapter()
{
}

//-----------------------------------------------------------------------------
vtkPainterDeviceAdapter::~vtkPainterDeviceAdapter()
{
}

//-----------------------------------------------------------------------------
vtkPainterDeviceAdapter* vtkPainterDeviceAdapter::New()
{
  vtkObject* ret = vtkGraphicsFactory::CreateInstance("vtkPainterDeviceAdapter");
  return static_cast<vtkPainterDeviceAdapter *>(ret);
}

#ifndef VTK_LEGACY_REMOVE
// ----------------------------------------------------------------------------
void vtkPainterDeviceAdapter::MakeVertexEmphasisWithStencilCheck(
  int vtkNotUsed(mode))
{
}
#endif

//-----------------------------------------------------------------------------
void vtkPainterDeviceAdapter::PrintSelf(ostream &os, vtkIndent indent)
{
  this->Superclass::PrintSelf(os, indent);
}
