/*
 * Decompiled with CFR 0.152.
 */
package org.web3d.vrml.renderer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.web3d.util.DefaultErrorReporter;
import org.web3d.util.ErrorReporter;
import org.web3d.util.IntHashMap;
import org.web3d.vrml.lang.BasicScene;
import org.web3d.vrml.lang.FieldExistsException;
import org.web3d.vrml.lang.InvalidFieldException;
import org.web3d.vrml.lang.InvalidFieldValueException;
import org.web3d.vrml.lang.TypeConstants;
import org.web3d.vrml.lang.VRMLFieldDeclaration;
import org.web3d.vrml.nodes.FrameStateManager;
import org.web3d.vrml.nodes.NodeListenerMulticaster;
import org.web3d.vrml.nodes.VRMLFieldData;
import org.web3d.vrml.nodes.VRMLMetadataObjectNodeType;
import org.web3d.vrml.nodes.VRMLNodeListener;
import org.web3d.vrml.nodes.VRMLNodeType;
import org.web3d.vrml.nodes.VRMLProtoInstance;
import org.web3d.vrml.nodes.proto.ProtoFieldInfo;
import org.web3d.vrml.nodes.proto.ProtoScene;

public class CRProtoInstance
implements VRMLProtoInstance,
VRMLNodeType {
    private static final Integer ZERO_SIZE = new Integer(0);
    private static final Integer SINGLE_SIZE = new Integer(1);
    private static final String SET_PREFIX = "set_";
    private static final String CHANGE_SUFFIX = "_changed";
    protected static final String BAD_NODE_MSG = "The supplied node cannot be copied as it's type is wrong. The type supplied is ";
    protected static final String METADATA_PROTO_MSG = "Proto does not describe a Metadata object";
    protected static final String METADATA_NODE_MSG = "Node does not describe a Metadata object";
    protected static final String VRML97_FIELD_MSG = "Field type not supported in VRML97: ";
    protected static final String FIELD_CLASH_MSG = "The same field has been declared twice in this node, but the data types or access types are different.";
    private static final String NO_LAYER_REF_MSG = "An attempt was made to decrement a reference count to a layer that is not currently referencing this node. Layer ID is ";
    protected ErrorReporter errorReporter;
    protected boolean isStatic;
    protected int vrmlMajorVersion;
    protected int vrmlMinorVersion;
    protected Map fieldIndexMap;
    protected Map uniqueFieldIndexMap;
    protected List fieldDeclList;
    protected final String nodeName;
    protected final int FIELD_METADATA;
    protected final VRMLFieldData fieldData;
    private final IntHashMap userData;
    private VRMLNodeListener nodeListener;
    protected VRMLNodeType[] bodyNodes;
    protected int bodyNodeCount;
    protected VRMLNodeType rootNode;
    protected ProtoScene sceneInfo;
    protected FrameStateManager stateManager;
    protected HashMap proxyNodeMap;
    protected final IntHashMap isMap;
    protected final IntHashMap fieldValueMap;
    protected final IntHashMap fieldSizeMap;
    protected final IntHashMap fieldChangedMap;
    protected boolean isDEF;
    protected boolean inSetup;
    protected boolean isVrml97;
    private boolean backFill;
    protected int lastFieldIndex;
    protected int[] isListEntry;
    protected int[] refCounts;
    protected int[] layerIds;
    private int[] secondaryType;
    protected boolean completeBody;
    private IntHashMap lostList;
    private boolean delayedAdd;
    private boolean propogated;
    private boolean exposedEvent;
    private int[] nodeFields;
    protected VRMLNodeType vfMetadata;
    protected VRMLProtoInstance pMetadata;
    private boolean bodyNotCounted;
    private boolean resendingIS;

    protected CRProtoInstance(String string, boolean bl, VRMLFieldDeclaration[] vRMLFieldDeclarationArray, int n) {
        this.nodeName = string;
        this.lastFieldIndex = vRMLFieldDeclarationArray.length;
        this.isVrml97 = bl;
        this.secondaryType = TypeConstants.NO_SECONDARY_TYPE;
        this.propogated = false;
        this.bodyNotCounted = false;
        this.resendingIS = false;
        this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        this.fieldIndexMap = new HashMap(this.lastFieldIndex, 1.0f);
        this.uniqueFieldIndexMap = new HashMap(this.lastFieldIndex, 1.0f);
        this.fieldDeclList = new ArrayList(this.lastFieldIndex);
        this.userData = new IntHashMap(this.lastFieldIndex);
        this.bodyNodes = new VRMLNodeType[n];
        this.fieldData = new VRMLFieldData();
        for (int i = 0; i < vRMLFieldDeclarationArray.length; ++i) {
            this.fieldDeclList.add(vRMLFieldDeclarationArray[i]);
            if (vRMLFieldDeclarationArray[i] == null) continue;
            String string2 = vRMLFieldDeclarationArray[i].getName();
            Integer n2 = new Integer(i);
            this.fieldIndexMap.put(string2, n2);
            this.uniqueFieldIndexMap.put(string2, n2);
            if (vRMLFieldDeclarationArray[i].getAccessType() != 3) continue;
            if (!string2.startsWith(SET_PREFIX)) {
                this.fieldIndexMap.put(SET_PREFIX + string2, n2);
            }
            if (string2.endsWith(CHANGE_SUFFIX)) continue;
            this.fieldIndexMap.put(string2 + CHANGE_SUFFIX, n2);
        }
        this.isDEF = false;
        this.inSetup = true;
        this.backFill = false;
        this.isMap = new IntHashMap(vRMLFieldDeclarationArray.length);
        this.fieldValueMap = new IntHashMap(vRMLFieldDeclarationArray.length);
        this.fieldSizeMap = new IntHashMap(vRMLFieldDeclarationArray.length);
        this.fieldChangedMap = new IntHashMap(vRMLFieldDeclarationArray.length);
        this.completeBody = false;
        this.lostList = new IntHashMap();
        this.proxyNodeMap = new HashMap();
        this.delayedAdd = false;
        this.exposedEvent = false;
        this.FIELD_METADATA = this.getFieldIndex("metadata");
    }

    public VRMLNodeType getImplementationNode() {
        if (!this.completeBody) {
            return null;
        }
        if (this.rootNode == null && this.bodyNodeCount != 0) {
            this.rootNode = this.bodyNodes[0];
            int n = this.rootNode.getPrimaryType();
            this.secondaryType = n == 38 ? this.rootNode.getSecondaryType() : new int[]{n};
        }
        return this.rootNode;
    }

    public int getFieldCount() {
        return this.fieldDeclList.size();
    }

    public List getAllFields() {
        return this.fieldDeclList;
    }

    public int getRefCount(int n) {
        if (this.layerIds == null) {
            return 0;
        }
        int n2 = 0;
        for (int i = 0; i < this.layerIds.length; ++i) {
            if (this.layerIds[i] != n) continue;
            n2 = this.refCounts[i];
            break;
        }
        return n2;
    }

    public synchronized void updateRefCount(int n, boolean bl) {
        int n2;
        if (this.layerIds != null) {
            n2 = -1;
            for (int i = 0; i < this.layerIds.length; ++i) {
                if (this.layerIds[i] != n) continue;
                n2 = i;
                break;
            }
            if (n2 == -1) {
                if (!bl) {
                    throw new IllegalStateException(NO_LAYER_REF_MSG + n);
                }
                int[] nArray = new int[this.layerIds.length + 1];
                System.arraycopy(this.layerIds, 0, nArray, 0, this.layerIds.length);
                nArray[this.layerIds.length] = n;
                this.layerIds = nArray;
                nArray = new int[this.refCounts.length + 1];
                System.arraycopy(this.refCounts, 0, nArray, 0, this.refCounts.length);
                nArray[this.refCounts.length] = 1;
                this.refCounts = nArray;
            } else if (bl) {
                int n3 = n2;
                this.refCounts[n3] = this.refCounts[n3] + 1;
            } else {
                int n4 = n2;
                this.refCounts[n4] = this.refCounts[n4] - 1;
                if (this.refCounts[n2] <= 0) {
                    int n5;
                    int[] nArray = new int[this.refCounts.length - 1];
                    int[] nArray2 = new int[this.refCounts.length - 1];
                    for (n5 = 0; n5 < n2; ++n5) {
                        nArray[n5] = this.refCounts[n5];
                        nArray2[n5] = this.layerIds[n5];
                    }
                    for (n5 = n2 + 1; n5 < this.refCounts.length; ++n5) {
                        nArray[n5 - 1] = this.refCounts[n5];
                        nArray2[n5 - 1] = this.layerIds[n5];
                    }
                    this.refCounts = nArray;
                    this.layerIds = nArray2;
                }
                if (this.refCounts.length == 1 && this.refCounts[0] == 0) {
                    this.refCounts = null;
                    this.layerIds = null;
                }
            }
        } else {
            if (!bl) {
                throw new IllegalStateException(NO_LAYER_REF_MSG + n);
            }
            this.layerIds = new int[]{n};
            this.refCounts = new int[]{1};
        }
        if (this.bodyNodes.length == 0) {
            this.bodyNotCounted = true;
        } else {
            for (n2 = 0; n2 < this.bodyNodes.length; ++n2) {
                this.bodyNodes[n2].updateRefCount(n, bl);
            }
        }
    }

    public int[] getLayerIds() {
        return this.layerIds;
    }

    public void setMetadataObject(VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (vRMLNodeType == null) {
            this.fieldValueMap.put(this.FIELD_METADATA, null);
        } else if (vRMLNodeType instanceof VRMLMetadataObjectNodeType) {
            this.fieldValueMap.put(this.FIELD_METADATA, vRMLNodeType);
        } else if (vRMLNodeType instanceof VRMLProtoInstance) {
            VRMLProtoInstance vRMLProtoInstance = (VRMLProtoInstance)vRMLNodeType;
            VRMLNodeType vRMLNodeType2 = vRMLProtoInstance.getImplementationNode();
            if (!(vRMLNodeType2 instanceof VRMLMetadataObjectNodeType)) {
                throw new InvalidFieldValueException(METADATA_PROTO_MSG);
            }
            this.fieldValueMap.put(this.FIELD_METADATA, vRMLNodeType);
            this.fieldSizeMap.put(this.FIELD_METADATA, SINGLE_SIZE);
        } else {
            throw new InvalidFieldValueException(METADATA_NODE_MSG);
        }
        if (!this.inSetup) {
            this.fieldChangedMap.put(this.FIELD_METADATA, Boolean.TRUE);
            this.fireFieldChanged(this.FIELD_METADATA);
        }
    }

    public VRMLNodeType getMetadataObject() {
        return (VRMLNodeType)this.fieldValueMap.get(this.FIELD_METADATA);
    }

    public boolean isSetupFinished() {
        return !this.inSetup;
    }

    public void setupFinished() {
        int n;
        Object object;
        int n2;
        if (!this.inSetup) {
            return;
        }
        if (this.nodeFields == null) {
            int n3;
            int n4 = this.fieldDeclList.size();
            n2 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                object = (VRMLFieldDeclaration)this.fieldDeclList.get(n3);
                n = ((VRMLFieldDeclaration)object).getFieldType();
                if (n != 12 && n != 11) continue;
                ++n2;
            }
            if (n2 == 0) {
                return;
            }
            this.nodeFields = new int[n2];
            n2 = 0;
            for (n3 = 0; n3 < n4; ++n3) {
                object = (VRMLFieldDeclaration)this.fieldDeclList.get(n3);
                n = ((VRMLFieldDeclaration)object).getFieldType();
                if (n != 12 && n != 11) continue;
                this.nodeFields[n2++] = this.getFieldIndex(((VRMLFieldDeclaration)object).getName());
            }
        }
        if (!this.completeBody) {
            return;
        }
        this.inSetup = false;
        int[] nArray = this.lostList.keySet();
        for (n = 0; n < nArray.length; ++n) {
            object = (ArrayList)this.lostList.get(nArray[n]);
            for (n2 = 0; n2 < ((ArrayList)object).size(); ++n2) {
                VRMLNodeType vRMLNodeType = (VRMLNodeType)((ArrayList)object).get(n2);
                ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(nArray[n]);
                if (protoFieldInfoArray == null) continue;
                for (int i = 0; i < protoFieldInfoArray.length; ++i) {
                    protoFieldInfoArray[i].node.notifyExternProtoLoaded(protoFieldInfoArray[i].field, vRMLNodeType);
                }
            }
            ((ArrayList)object).clear();
        }
        this.lostList.clear();
        this.lostList = null;
        if (this.stateManager == null) {
            this.delayedAdd = true;
        }
        this.isListEntry = new int[this.lastFieldIndex];
        this.propagateSetupFinished();
    }

    public void setFrameStateManager(FrameStateManager frameStateManager) {
        this.stateManager = frameStateManager;
        if (this.delayedAdd) {
            this.stateManager.registerAddedScene(this);
            this.delayedAdd = false;
        }
    }

    public void allEventsComplete() {
    }

    public void setErrorReporter(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        if (errorReporter == null) {
            this.errorReporter = DefaultErrorReporter.getDefaultReporter();
        }
    }

    public String getVRMLNodeName() {
        return this.nodeName;
    }

    public void setVersion(int n, int n2, boolean bl) {
        this.vrmlMajorVersion = n;
        this.vrmlMinorVersion = n2;
        this.isStatic = bl;
    }

    public void setDEF() {
        if (!this.inSetup) {
            throw new IllegalStateException("Can't set DEF now");
        }
        this.isDEF = true;
    }

    public boolean isDEF() {
        return this.isDEF;
    }

    public int getFieldIndex(String string) {
        Integer n = (Integer)this.fieldIndexMap.get(string);
        return n == null ? -1 : n;
    }

    public int[] getNodeFieldIndices() {
        return this.nodeFields;
    }

    public VRMLFieldDeclaration getFieldDeclaration(int n) {
        return (VRMLFieldDeclaration)this.fieldDeclList.get(n);
    }

    public int getNumFields() {
        return this.fieldDeclList.size();
    }

    public void addNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.add(this.nodeListener, vRMLNodeListener);
    }

    public void removeNodeListener(VRMLNodeListener vRMLNodeListener) {
        this.nodeListener = NodeListenerMulticaster.remove(this.nodeListener, vRMLNodeListener);
    }

    public boolean hasFieldChanged(int n) {
        Boolean bl;
        if (this.inSetup) {
            return false;
        }
        boolean bl2 = false;
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray != null) {
            for (int i = 0; i < protoFieldInfoArray.length; ++i) {
                bl2 = protoFieldInfoArray[i].node.hasFieldChanged(protoFieldInfoArray[i].field);
                if (!bl2) continue;
                this.isListEntry[n] = i;
                return true;
            }
        }
        if ((bl = (Boolean)this.fieldChangedMap.get(n)) != null && (bl2 = bl.booleanValue())) {
            this.fieldChangedMap.put(n, Boolean.FALSE);
        }
        return bl2;
    }

    public VRMLFieldData getFieldValue(int n) throws InvalidFieldException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(this.nodeName, n);
        }
        Object object = this.fieldValueMap.get(n);
        Integer n2 = (Integer)this.fieldSizeMap.get(n);
        this.fieldData.numElements = n2 != null ? n2 : 0;
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                this.fieldData.intValue = object == null ? 0 : (Integer)object;
                this.fieldData.dataType = (short)2;
                break;
            }
            case 4: {
                this.fieldData.intArrayValue = (int[])object;
                this.fieldData.dataType = (short)9;
                break;
            }
            case 5: {
                this.fieldData.floatValue = object == null ? 0.0f : ((Float)object).floatValue();
                this.fieldData.dataType = (short)4;
                break;
            }
            case 6: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.dataType = (short)11;
                break;
            }
            case 7: {
                this.fieldData.doubleValue = object == null ? 0.0 : (Double)object;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 8: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 31: {
                this.fieldData.longValue = object == null ? 0L : (Long)object;
                this.fieldData.dataType = (short)3;
                break;
            }
            case 32: {
                this.fieldData.longArrayValue = (long[])object;
                this.fieldData.dataType = (short)10;
                break;
            }
            case 1: {
                this.fieldData.booleanValue = object == null ? false : (Boolean)object;
                this.fieldData.dataType = 1;
                break;
            }
            case 2: {
                this.fieldData.booleanArrayValue = (boolean[])object;
                this.fieldData.dataType = (short)8;
                break;
            }
            case 9: {
                this.fieldData.doubleValue = object == null ? -1.0 : (Double)object;
                this.fieldData.dataType = (short)5;
                break;
            }
            case 10: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.dataType = (short)12;
                break;
            }
            case 27: {
                this.fieldData.stringValue = (String)object;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 28: {
                if (object instanceof String[]) {
                    this.fieldData.stringArrayValue = (String[])object;
                    this.fieldData.dataType = (short)14;
                    break;
                }
                this.fieldData.stringValue = (String)object;
                this.fieldData.dataType = (short)6;
                break;
            }
            case 11: {
                this.fieldData.nodeValue = (VRMLNodeType)object;
                this.fieldData.dataType = (short)7;
                break;
            }
            case 12: {
                if (object instanceof VRMLNodeType) {
                    this.fieldData.nodeArrayValue = new VRMLNodeType[1];
                    this.fieldData.nodeArrayValue[0] = (VRMLNodeType)object;
                } else {
                    this.fieldData.nodeArrayValue = (VRMLNodeType[])object;
                }
                this.fieldData.dataType = (short)13;
                break;
            }
            case 13: 
            case 14: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements /= 2;
                break;
            }
            case 15: 
            case 16: 
            case 21: 
            case 22: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements /= 3;
                break;
            }
            case 19: 
            case 20: 
            case 23: 
            case 24: 
            case 33: 
            case 34: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements /= 4;
                break;
            }
            case 17: 
            case 18: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements /= 3;
                break;
            }
            case 35: 
            case 36: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements /= 4;
                break;
            }
            case 37: 
            case 38: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements /= 9;
                break;
            }
            case 41: 
            case 42: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements /= 9;
                break;
            }
            case 39: 
            case 40: {
                this.fieldData.floatArrayValue = (float[])object;
                this.fieldData.dataType = (short)11;
                this.fieldData.numElements /= 16;
                break;
            }
            case 43: 
            case 44: {
                this.fieldData.doubleArrayValue = (double[])object;
                this.fieldData.dataType = (short)12;
                this.fieldData.numElements /= 16;
                break;
            }
            case 25: 
            case 26: {
                this.fieldData.intArrayValue = (int[])object;
                this.fieldData.dataType = (short)9;
            }
        }
        return this.fieldData;
    }

    public int getPrimaryType() {
        return 38;
    }

    public int[] getSecondaryType() {
        return this.secondaryType;
    }

    public void notifyExternProtoLoaded(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldValueException {
        if (this.inSetup) {
            ArrayList<VRMLNodeType> arrayList = (ArrayList<VRMLNodeType>)this.lostList.get(n);
            if (arrayList == null) {
                arrayList = new ArrayList<VRMLNodeType>();
                arrayList.add(vRMLNodeType);
                this.lostList.put(n, arrayList);
            } else {
                arrayList.add(vRMLNodeType);
            }
            return;
        }
        ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        for (int i = 0; i < protoFieldInfoArray.length; ++i) {
            protoFieldInfoArray[i].node.notifyExternProtoLoaded(protoFieldInfoArray[i].field, vRMLNodeType);
        }
    }

    public void sendRoute(double d, int n, VRMLNodeType vRMLNodeType, int n2) {
        Object object = this.fieldValueMap.get(n);
        if (object == null) {
            int n3 = this.isListEntry[n];
            ProtoFieldInfo[] protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
            if (protoFieldInfoArray != null) {
                VRMLFieldData vRMLFieldData = protoFieldInfoArray[this.isListEntry[n3]].node.getFieldValue(protoFieldInfoArray[n3].field);
                switch (vRMLFieldData.dataType) {
                    case 1: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.booleanValue);
                        break;
                    }
                    case 8: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.booleanArrayValue, vRMLFieldData.numElements);
                        break;
                    }
                    case 2: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.intValue);
                        break;
                    }
                    case 9: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.intArrayValue, vRMLFieldData.numElements);
                        break;
                    }
                    case 3: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.longValue);
                        break;
                    }
                    case 10: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.longArrayValue, vRMLFieldData.numElements);
                        break;
                    }
                    case 4: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.floatValue);
                        break;
                    }
                    case 11: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.floatArrayValue, vRMLFieldData.numElements);
                        break;
                    }
                    case 5: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.doubleValue);
                        break;
                    }
                    case 12: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.doubleArrayValue, vRMLFieldData.numElements);
                        break;
                    }
                    case 6: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.stringValue);
                        break;
                    }
                    case 14: {
                        vRMLNodeType.setValue(n2, vRMLFieldData.stringArrayValue, vRMLFieldData.numElements);
                        break;
                    }
                    case 7: {
                        vRMLNodeType.setValue(n2, (VRMLNodeType)vRMLFieldData.nodeValue);
                        break;
                    }
                    case 13: {
                        vRMLNodeType.setValue(n2, (VRMLNodeType[])vRMLFieldData.nodeArrayValue, vRMLFieldData.numElements);
                    }
                }
            }
            return;
        }
        try {
            Integer n4 = (Integer)this.fieldSizeMap.get(n);
            this.sendValue(vRMLNodeType, n2, object, n4);
        }
        catch (InvalidFieldException invalidFieldException) {
            System.err.println("Route to invalid event: " + invalidFieldException.getFieldName());
        }
        catch (InvalidFieldValueException invalidFieldValueException) {
            System.err.println("Route sending out of range values " + invalidFieldValueException.getFieldName());
        }
    }

    public void setValue(int n, int n2) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                n2 = (Integer)protoFieldInfoArray;
            } else {
                this.fieldValueMap.put(n, new Integer(n2));
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            this.fieldValueMap.put(n, new Integer(n2));
            this.fieldSizeMap.put(n, SINGLE_SIZE);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < protoFieldInfoArray.length; ++i) {
            protoFieldInfoArray[i].node.setValue(protoFieldInfoArray[i].field, n2);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, int[] nArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                nArray = (int[])object;
                n2 = (Integer)this.fieldSizeMap.get(n);
            } else {
                this.fieldSizeMap.put(n, new Integer(n2));
                this.fieldValueMap.put(n, nArray);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            object = (Integer)this.fieldSizeMap.get(n);
            if (object == null || object.intValue() != n2) {
                this.fieldSizeMap.put(n, new Integer(n2));
            }
            this.fieldValueMap.put(n, nArray);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, nArray, n2);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, long l) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                l = (Long)protoFieldInfoArray;
            } else {
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldValueMap.put(n, new Long(l));
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            this.fieldSizeMap.put(n, SINGLE_SIZE);
            this.fieldValueMap.put(n, new Long(l));
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < protoFieldInfoArray.length; ++i) {
            protoFieldInfoArray[i].node.setValue(protoFieldInfoArray[i].field, l);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, long[] lArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                lArray = (long[])object;
                n2 = (Integer)this.fieldSizeMap.get(n);
            } else {
                this.fieldSizeMap.put(n, new Integer(n2));
                this.fieldValueMap.put(n, lArray);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            object = (Integer)this.fieldSizeMap.get(n);
            if (object == null || object.intValue() != n2) {
                this.fieldSizeMap.put(n, new Integer(n2));
            }
            this.fieldValueMap.put(n, lArray);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, lArray, n2);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, boolean bl) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                bl = (Boolean)protoFieldInfoArray;
            } else {
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldValueMap.put(n, bl);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            this.fieldSizeMap.put(n, SINGLE_SIZE);
            this.fieldValueMap.put(n, new Boolean(bl));
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < protoFieldInfoArray.length; ++i) {
            protoFieldInfoArray[i].node.setValue(protoFieldInfoArray[i].field, bl);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, boolean[] blArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                blArray = (boolean[])object;
                n2 = (Integer)this.fieldSizeMap.get(n);
            } else {
                this.fieldSizeMap.put(n, new Integer(n2));
                this.fieldValueMap.put(n, blArray);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            object = (Integer)this.fieldSizeMap.get(n);
            if (object == null || object.intValue() != n2) {
                this.fieldSizeMap.put(n, new Integer(n2));
            }
            this.fieldValueMap.put(n, blArray);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, blArray, n2);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, float f) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                f = ((Float)protoFieldInfoArray).floatValue();
            } else {
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldValueMap.put(n, new Float(f));
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            this.fieldSizeMap.put(n, SINGLE_SIZE);
            this.fieldValueMap.put(n, new Float(f));
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < protoFieldInfoArray.length; ++i) {
            protoFieldInfoArray[i].node.setValue(protoFieldInfoArray[i].field, f);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, float[] fArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                fArray = (float[])object;
                n2 = (Integer)this.fieldSizeMap.get(n);
            } else {
                this.fieldSizeMap.put(n, new Integer(n2));
                this.fieldValueMap.put(n, fArray);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            object = (Integer)this.fieldSizeMap.get(n);
            if (object == null || object.intValue() != n2) {
                this.fieldSizeMap.put(n, new Integer(n2));
            }
            this.fieldValueMap.put(n, fArray);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, fArray, n2);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, double d) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                d = (Double)protoFieldInfoArray;
            } else {
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldValueMap.put(n, new Double(d));
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            this.fieldSizeMap.put(n, SINGLE_SIZE);
            this.fieldValueMap.put(n, new Double(d));
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < protoFieldInfoArray.length; ++i) {
            protoFieldInfoArray[i].node.setValue(protoFieldInfoArray[i].field, d);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, double[] dArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                dArray = (double[])object;
                n2 = (Integer)this.fieldSizeMap.get(n);
            } else {
                this.fieldSizeMap.put(n, new Integer(n2));
                this.fieldValueMap.put(n, dArray);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            object = (Integer)this.fieldSizeMap.get(n);
            if (object == null || object.intValue() != n2) {
                this.fieldSizeMap.put(n, new Integer(n2));
            }
            this.fieldValueMap.put(n, dArray);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, dArray, n2);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, String string) throws InvalidFieldException, InvalidFieldValueException {
        ProtoFieldInfo[] protoFieldInfoArray;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            protoFieldInfoArray = this.fieldValueMap.get(n);
            if (protoFieldInfoArray != null) {
                string = (String)protoFieldInfoArray;
            } else {
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldValueMap.put(n, string);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            this.fieldSizeMap.put(n, SINGLE_SIZE);
            this.fieldValueMap.put(n, string);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n);
        if (protoFieldInfoArray == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < protoFieldInfoArray.length; ++i) {
            protoFieldInfoArray[i].node.setValue(protoFieldInfoArray[i].field, string);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, String[] stringArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                stringArray = object instanceof String ? new String[]{(String)object} : (String[])object;
                n2 = (Integer)this.fieldSizeMap.get(n);
            } else {
                this.fieldSizeMap.put(n, new Integer(n2));
                this.fieldValueMap.put(n, stringArray);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            object = (Integer)this.fieldSizeMap.get(n);
            if (object == null || object.intValue() != n2) {
                this.fieldSizeMap.put(n, new Integer(n2));
            }
            this.fieldValueMap.put(n, stringArray);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, stringArray, n2);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, VRMLNodeType vRMLNodeType) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                vRMLNodeType = (VRMLNodeType)object;
            } else {
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldValueMap.put(n, vRMLNodeType);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            if (vRMLFieldDeclaration.getFieldType() == 12 && this.inSetup && !this.resendingIS) {
                object = this.fieldValueMap.get(n);
                if (object == null) {
                    this.fieldValueMap.put(n, vRMLNodeType);
                    this.fieldSizeMap.put(n, SINGLE_SIZE);
                } else {
                    VRMLNodeType[] vRMLNodeTypeArray;
                    if (object instanceof VRMLNodeType) {
                        vRMLNodeTypeArray = new VRMLNodeType[]{(VRMLNodeType)object, vRMLNodeType};
                    } else {
                        VRMLNodeType[] vRMLNodeTypeArray2 = (VRMLNodeType[])object;
                        int n2 = vRMLNodeTypeArray2.length;
                        vRMLNodeTypeArray = new VRMLNodeType[n2 + 1];
                        for (int i = 0; i < n2; ++i) {
                            vRMLNodeTypeArray[i] = vRMLNodeTypeArray2[i];
                        }
                        vRMLNodeTypeArray[n2] = vRMLNodeType;
                    }
                    this.fieldValueMap.put(n, vRMLNodeTypeArray);
                    this.fieldSizeMap.put(n, new Integer(vRMLNodeTypeArray.length));
                }
            } else {
                this.fieldSizeMap.put(n, SINGLE_SIZE);
                this.fieldValueMap.put(n, vRMLNodeType);
            }
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, vRMLNodeType);
        }
        this.exposedEvent = false;
    }

    public void setValue(int n, VRMLNodeType[] vRMLNodeTypeArray, int n2) throws InvalidFieldException, InvalidFieldValueException {
        Object object;
        if (this.fieldDeclList.get(n) == null) {
            throw new InvalidFieldException("Unknown field index");
        }
        if (this.backFill) {
            object = this.fieldValueMap.get(n);
            if (object != null) {
                vRMLNodeTypeArray = (VRMLNodeType[])object;
                n2 = (Integer)this.fieldSizeMap.get(n);
            } else {
                this.fieldSizeMap.put(n, new Integer(n2));
                this.fieldValueMap.put(n, vRMLNodeTypeArray);
                this.fieldChangedMap.put(n, Boolean.TRUE);
                this.fireFieldChanged(n);
            }
        } else {
            object = (Integer)this.fieldSizeMap.get(n);
            if (object == null || object.intValue() != n2) {
                this.fieldSizeMap.put(n, new Integer(n2));
            }
            this.fieldValueMap.put(n, vRMLNodeTypeArray);
            this.fieldChangedMap.put(n, Boolean.TRUE);
            this.fireFieldChanged(n);
        }
        object = (ProtoFieldInfo[])this.isMap.get(n);
        if (object == null) {
            return;
        }
        this.exposedEvent = true;
        for (int i = 0; i < ((ProtoFieldInfo[])object).length; ++i) {
            object[i].node.setValue(object[i].field, vRMLNodeTypeArray, n2);
        }
        this.exposedEvent = false;
    }

    public BasicScene getContainedScene() {
        return this.sceneInfo;
    }

    protected int appendField(VRMLFieldDeclaration vRMLFieldDeclaration) throws FieldExistsException {
        String string = vRMLFieldDeclaration.getName();
        Integer n = (Integer)this.fieldIndexMap.get(string);
        if (n != null) {
            VRMLFieldDeclaration vRMLFieldDeclaration2 = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
            if (vRMLFieldDeclaration.getFieldType() != vRMLFieldDeclaration2.getFieldType() || vRMLFieldDeclaration.getAccessType() != vRMLFieldDeclaration.getAccessType()) {
                throw new FieldExistsException(FIELD_CLASH_MSG, string);
            }
        }
        this.fieldIndexMap.put(string, new Integer(this.lastFieldIndex));
        this.fieldDeclList.add(vRMLFieldDeclaration);
        return this.lastFieldIndex++;
    }

    void addBodyChild(VRMLNodeType vRMLNodeType) {
        this.bodyNodes[this.bodyNodeCount] = vRMLNodeType;
        ++this.bodyNodeCount;
    }

    void setNumBodyNodes(int n) {
        if (this.bodyNodeCount != 0) {
            throw new IllegalStateException("Cannot set numBodyCount after adding children to " + this.getVRMLNodeName());
        }
        this.bodyNodes = new VRMLNodeType[n];
    }

    void setImports(Map map) {
        this.proxyNodeMap.putAll(map);
    }

    void setBackFill(boolean bl) {
        this.backFill = bl;
    }

    public void setComplete() {
        if (this.bodyNotCounted) {
            this.bodyNotCounted = false;
            for (int i = 0; i < this.layerIds.length; ++i) {
                for (int j = 0; j < this.bodyNodes.length; ++j) {
                    this.bodyNodes[j].updateRefCount(i, true);
                }
            }
        }
        this.completeBody = true;
    }

    public boolean getComplete() {
        return this.completeBody;
    }

    void setIsMapping(int n, List list) {
        int n2 = list.size();
        ProtoFieldInfo[] protoFieldInfoArray = new ProtoFieldInfo[n2];
        list.toArray(protoFieldInfoArray);
        this.isMap.put(n, protoFieldInfoArray);
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        int n3 = vRMLFieldDeclaration.getAccessType();
        if (n3 == 3 || n3 == 4) {
            for (int i = 0; i < n2; ++i) {
                ISFieldAdapter iSFieldAdapter = new ISFieldAdapter(n, protoFieldInfoArray[i].node, protoFieldInfoArray[i].field);
                protoFieldInfoArray[i].node.addNodeListener(iSFieldAdapter);
            }
        }
    }

    void resendIS() {
        Iterator iterator = this.uniqueFieldIndexMap.values().iterator();
        this.resendingIS = true;
        while (iterator.hasNext()) {
            Object object;
            ProtoFieldInfo[] protoFieldInfoArray;
            int n = (Integer)iterator.next();
            VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
            int n2 = vRMLFieldDeclaration.getAccessType();
            if (n2 == 1 || n2 == 4 || (protoFieldInfoArray = (ProtoFieldInfo[])this.isMap.get(n)) == null || (object = this.fieldValueMap.get(n)) == null) continue;
            Integer n3 = (Integer)this.fieldSizeMap.get(n);
            try {
                this.sendValue(this, n, object, n3);
            }
            catch (InvalidFieldValueException invalidFieldValueException) {
                invalidFieldValueException.printStackTrace();
            }
            catch (InvalidFieldException invalidFieldException) {
                invalidFieldException.printStackTrace();
            }
        }
        this.uniqueFieldIndexMap = null;
        this.resendingIS = false;
    }

    void setContainedScene(ProtoScene protoScene) {
        this.sceneInfo = protoScene;
        if (this.rootNode == null && this.bodyNodeCount != 0) {
            this.rootNode = this.bodyNodes[0];
            int n = this.rootNode.getPrimaryType();
            this.secondaryType = n == 38 ? this.rootNode.getSecondaryType() : new int[]{n};
        }
        if (this.isDEF && this.rootNode != null) {
            this.rootNode.setDEF();
        }
    }

    void propagateSetupFinished() {
        int n;
        if (this.propogated || !this.completeBody || this.rootNode == null) {
            return;
        }
        this.propogated = true;
        int n2 = this.getFieldCount();
        for (n = 0; n < n2; ++n) {
            VRMLNodeType[] vRMLNodeTypeArray;
            int n3;
            VRMLFieldDeclaration vRMLFieldDeclaration = (VRMLFieldDeclaration)this.fieldDeclList.get(n);
            int n4 = vRMLFieldDeclaration.getAccessType();
            if (n4 == 1 || n4 == 4 || (n3 = vRMLFieldDeclaration.getFieldType()) != 12 || n3 != 11) continue;
            Object object = this.fieldValueMap.get(n);
            if (object instanceof VRMLNodeType) {
                vRMLNodeTypeArray = (VRMLNodeType[])object;
                vRMLNodeTypeArray.setupFinished();
                continue;
            }
            if (!(object instanceof VRMLNodeType[])) continue;
            vRMLNodeTypeArray = (VRMLNodeType[])object;
            for (int i = 0; i < vRMLNodeTypeArray.length; ++i) {
                vRMLNodeTypeArray[n].setupFinished();
            }
        }
        for (n = 0; n < this.bodyNodes.length; ++n) {
            this.bodyNodes[n].setupFinished();
        }
        if (this.stateManager == null) {
            this.delayedAdd = true;
        }
    }

    void sendUpdateMessage() {
        if (this.stateManager != null) {
            this.stateManager.registerAddedScene(this);
            this.delayedAdd = false;
        } else {
            this.delayedAdd = true;
        }
    }

    private void sendValue(VRMLNodeType vRMLNodeType, int n, Object object, int n2) throws InvalidFieldException, InvalidFieldValueException {
        VRMLFieldDeclaration vRMLFieldDeclaration = vRMLNodeType.getFieldDeclaration(n);
        switch (vRMLFieldDeclaration.getFieldType()) {
            case 3: {
                vRMLNodeType.setValue(n, (Integer)object);
                break;
            }
            case 4: 
            case 25: 
            case 26: {
                vRMLNodeType.setValue(n, (int[])object, n2);
                break;
            }
            case 5: {
                vRMLNodeType.setValue(n, ((Float)object).floatValue());
                break;
            }
            case 7: 
            case 9: {
                vRMLNodeType.setValue(n, (Double)object);
                break;
            }
            case 8: 
            case 10: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            case 31: {
                vRMLNodeType.setValue(n, (Long)object);
                break;
            }
            case 32: {
                vRMLNodeType.setValue(n, (long[])object, n2);
                break;
            }
            case 1: {
                vRMLNodeType.setValue(n, (Boolean)object);
                break;
            }
            case 2: {
                vRMLNodeType.setValue(n, (boolean[])object, n2);
                break;
            }
            case 11: {
                vRMLNodeType.setValue(n, (VRMLNodeType)object);
                break;
            }
            case 12: {
                if (object instanceof VRMLNodeType) {
                    vRMLNodeType.setValue(n, (VRMLNodeType)object);
                    break;
                }
                vRMLNodeType.setValue(n, (VRMLNodeType[])object, n2);
                break;
            }
            case 6: 
            case 13: 
            case 15: 
            case 19: 
            case 21: 
            case 23: 
            case 33: 
            case 37: 
            case 39: {
                vRMLNodeType.setValue(n, (float[])object, n2);
                break;
            }
            case 14: 
            case 16: 
            case 20: 
            case 22: 
            case 24: 
            case 34: 
            case 38: 
            case 40: {
                vRMLNodeType.setValue(n, (float[])object, n2);
                break;
            }
            case 17: 
            case 35: 
            case 41: 
            case 43: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            case 18: 
            case 36: 
            case 42: 
            case 44: {
                vRMLNodeType.setValue(n, (double[])object, n2);
                break;
            }
            case 28: {
                vRMLNodeType.setValue(n, (String[])object, n2);
                break;
            }
            case 27: {
                vRMLNodeType.setValue(n, (String)object);
                break;
            }
            default: {
                System.out.println("Unhandled case in CRProtoInstance.sendValue: " + vRMLFieldDeclaration.getFieldTypeString());
            }
        }
    }

    public void setUserData(int n, Object object) throws InvalidFieldException {
        if (n < 0 || n > this.lastFieldIndex) {
            throw new InvalidFieldException("Invalid index in getUserData");
        }
        this.userData.put(n, object);
    }

    public Object getUserData(int n) throws InvalidFieldException {
        if (n < 0 || n > this.lastFieldIndex) {
            throw new InvalidFieldException("Invalid index in getUserData");
        }
        return this.userData.get(n);
    }

    public boolean isDefaultValue(int n) throws InvalidFieldException {
        VRMLFieldDeclaration vRMLFieldDeclaration = this.getFieldDeclaration(n);
        if (vRMLFieldDeclaration == null) {
            throw new InvalidFieldException(this.nodeName, n);
        }
        Object object = this.fieldValueMap.get(n);
        return object == null;
    }

    protected void fireFieldChanged(int n) {
        if (this.nodeListener != null) {
            try {
                this.nodeListener.fieldChanged(n);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private class ISFieldAdapter
    implements VRMLNodeListener {
        private int isFieldIndex;
        private int sourceIndex;
        private VRMLNodeType sourceNode;

        ISFieldAdapter(int n, VRMLNodeType vRMLNodeType, int n2) {
            this.isFieldIndex = n;
            this.sourceIndex = n2;
            this.sourceNode = vRMLNodeType;
        }

        public void fieldChanged(int n) {
            if (n != this.sourceIndex || CRProtoInstance.this.exposedEvent) {
                return;
            }
            CRProtoInstance.this.fieldChangedMap.put(n, Boolean.TRUE);
            VRMLFieldData vRMLFieldData = this.sourceNode.getFieldValue(n);
            Integer n2 = (Integer)CRProtoInstance.this.fieldSizeMap.get(this.isFieldIndex);
            if (n2 == null || n2 != vRMLFieldData.numElements) {
                VRMLFieldDeclaration vRMLFieldDeclaration = CRProtoInstance.this.getFieldDeclaration(this.isFieldIndex);
                int n3 = vRMLFieldDeclaration.getFieldSize();
                CRProtoInstance.this.fieldSizeMap.put(this.isFieldIndex, new Integer(vRMLFieldData.numElements * n3));
            }
            switch (vRMLFieldData.dataType) {
                case 1: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.booleanValue);
                    break;
                }
                case 2: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, new Integer(vRMLFieldData.intValue));
                    break;
                }
                case 3: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, new Long(vRMLFieldData.longValue));
                    break;
                }
                case 4: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, new Float(vRMLFieldData.floatValue));
                    break;
                }
                case 5: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, new Double(vRMLFieldData.doubleValue));
                    break;
                }
                case 6: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.stringValue);
                    break;
                }
                case 7: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.nodeValue);
                    break;
                }
                case 8: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.booleanArrayValue);
                    break;
                }
                case 9: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.intArrayValue);
                    break;
                }
                case 10: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.longArrayValue);
                    break;
                }
                case 11: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.floatArrayValue);
                    break;
                }
                case 12: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.doubleArrayValue);
                    break;
                }
                case 13: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.nodeArrayValue);
                    break;
                }
                case 14: {
                    CRProtoInstance.this.fieldValueMap.put(this.isFieldIndex, vRMLFieldData.stringArrayValue);
                    break;
                }
                default: {
                    System.out.println("WAAAAAAH! Unknown data type to copy!");
                }
            }
            CRProtoInstance.this.fireFieldChanged(this.isFieldIndex);
        }
    }
}

