/*
 * Decompiled with CFR 0.152.
 */
package org.ietf.uri;

import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import org.ietf.uri.MalformedURNException;
import org.ietf.uri.RDSManager;
import org.ietf.uri.ResourceConnection;
import org.ietf.uri.URC;
import org.ietf.uri.URI;
import org.ietf.uri.URL;
import org.ietf.uri.URNResolverService;
import org.ietf.uri.UnsupportedServiceException;

public final class URN
extends URI {
    private final String urn;
    private String namespace;
    private String reference;

    public URN(String string) throws MalformedURNException {
        this(string, false);
    }

    public URN(String string, boolean bl) throws MalformedURNException {
        this.urn = string.trim();
        try {
            if (!this.urn.regionMatches(true, 0, "urn:", 0, 4)) {
                throw new MalformedURNException("URN does not start with \"urn:\".");
            }
            int n = this.urn.indexOf(58, 4);
            this.namespace = this.urn.substring(4, n);
            this.reference = this.urn.substring(n + 1);
        }
        catch (NoSuchElementException noSuchElementException) {
            throw new MalformedURNException("Incomplete URN specified.");
        }
    }

    public URN(String string, String string2) {
        if (string == null || string2 == null) {
            throw new NullPointerException("Null portion of URN supplied");
        }
        this.namespace = string;
        this.reference = string2;
        this.urn = "urn:" + string + ':' + string2;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getNSS() {
        return this.reference;
    }

    public URL getURL() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService = RDSManager.getFirstResolver(this.namespace, 1);
        if (uRNResolverService == null) {
            throw new UnsupportedServiceException("No URL resolution is available");
        }
        return (URL)uRNResolverService.decode(this, 1);
    }

    public URL[] getURLList() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService;
        Enumeration enumeration = RDSManager.getAllResolvers(this.namespace, 2);
        boolean bl = enumeration != null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object[] objectArray = uRNResolverService.decodeList(this, 2);
                if (objectArray == null) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    if (hashMap.containsKey(objectArray[i].toString())) continue;
                    linkedList.add(objectArray[i]);
                    hashMap.put(objectArray[i].toString(), objectArray[i]);
                }
            }
            catch (UnsupportedServiceException unsupportedServiceException) {
            }
        }
        if ((enumeration = RDSManager.getAllResolvers(this.namespace, 1)) == null && !bl) {
            throw new UnsupportedServiceException("URL lists are not available");
        }
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object object = uRNResolverService.decode(this, 1);
                if (object == null || hashMap.containsKey(object.toString())) continue;
                linkedList.add(object);
                hashMap.put(object.toString(), object);
            }
            catch (UnsupportedServiceException unsupportedServiceException) {}
        }
        URL[] uRLArray = new URL[linkedList.size()];
        linkedList.toArray(uRLArray);
        return uRLArray;
    }

    public URC getURC() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService = RDSManager.getFirstResolver(this.namespace, 5);
        if (uRNResolverService == null) {
            throw new UnsupportedServiceException("No URL resolution is available");
        }
        return (URC)uRNResolverService.decode(this, 5);
    }

    public URC[] getURCList() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService;
        Enumeration enumeration = RDSManager.getAllResolvers(this.namespace, 6);
        boolean bl = enumeration != null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object[] objectArray = uRNResolverService.decodeList(this, 6);
                if (objectArray == null) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    linkedList.add(objectArray[i]);
                }
            }
            catch (UnsupportedServiceException unsupportedServiceException) {
            }
        }
        if ((enumeration = RDSManager.getAllResolvers(this.namespace, 5)) == null && !bl) {
            throw new UnsupportedServiceException("URC lists are not available");
        }
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object object = uRNResolverService.decode(this, 5);
                if (object == null || linkedList.contains(object)) continue;
                linkedList.add(object);
            }
            catch (UnsupportedServiceException unsupportedServiceException) {}
        }
        URC[] uRCArray = new URC[linkedList.size()];
        linkedList.toArray(uRCArray);
        return uRCArray;
    }

    public URN getURN() throws UnsupportedServiceException, IOException {
        return this;
    }

    public URN[] getURNList() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService;
        Enumeration enumeration = RDSManager.getAllResolvers(this.namespace, 8);
        boolean bl = enumeration != null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object[] objectArray = uRNResolverService.decodeList(this, 8);
                if (objectArray == null) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    linkedList.add(objectArray[i]);
                }
            }
            catch (UnsupportedServiceException unsupportedServiceException) {
            }
        }
        if ((enumeration = RDSManager.getAllResolvers(this.namespace, 7)) == null && !bl) {
            throw new UnsupportedServiceException("URN lists are not available");
        }
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object object = uRNResolverService.decode(this, 7);
                if (object == null) continue;
                linkedList.add(object);
            }
            catch (UnsupportedServiceException unsupportedServiceException) {}
        }
        URN[] uRNArray = new URN[linkedList.size()];
        linkedList.toArray(uRNArray);
        return uRNArray;
    }

    public ResourceConnection getResource() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService = RDSManager.getFirstResolver(this.namespace, 3);
        if (uRNResolverService == null) {
            throw new UnsupportedServiceException("No URL resolution is available");
        }
        return (ResourceConnection)uRNResolverService.decode(this, 3);
    }

    public ResourceConnection[] getResourceList() throws UnsupportedServiceException, IOException {
        URNResolverService uRNResolverService;
        Enumeration enumeration = RDSManager.getAllResolvers(this.namespace, 4);
        boolean bl = enumeration != null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object[] objectArray = uRNResolverService.decodeList(this, 4);
                if (objectArray == null) continue;
                for (int i = 0; i < objectArray.length; ++i) {
                    linkedList.add(objectArray[i]);
                }
            }
            catch (UnsupportedServiceException unsupportedServiceException) {
            }
        }
        if ((enumeration = RDSManager.getAllResolvers(this.namespace, 3)) == null && !bl) {
            throw new UnsupportedServiceException("Resource lists are not available");
        }
        while (enumeration.hasMoreElements()) {
            try {
                uRNResolverService = (URNResolverService)enumeration.nextElement();
            }
            catch (NoSuchElementException noSuchElementException) {
                break;
            }
            try {
                Object object = uRNResolverService.decode(this, 3);
                if (object == null) continue;
                linkedList.add(object);
            }
            catch (UnsupportedServiceException unsupportedServiceException) {}
        }
        ResourceConnection[] resourceConnectionArray = new ResourceConnection[linkedList.size()];
        linkedList.toArray(resourceConnectionArray);
        return resourceConnectionArray;
    }

    public String toExternalForm() {
        return this.urn;
    }

    public boolean equals(Object object) {
        if (object instanceof URI) {
            return this.equals((URI)object);
        }
        return false;
    }

    public boolean equals(URI uRI) {
        if (!(uRI instanceof URN)) {
            return false;
        }
        URN uRN = (URN)uRI;
        return uRN.namespace.equals(this.namespace) && uRN.reference.equals(this.reference);
    }

    public String toString() {
        return this.toExternalForm();
    }

    public static void addResolver(URNResolverService uRNResolverService) {
        RDSManager.addURNResolver(uRNResolverService);
    }

    public static void removeResolver(URNResolverService uRNResolverService) {
        RDSManager.removeURNResolver(uRNResolverService);
    }
}

