#ifndef FLAGOBJ_H
#define FLAGOBJ_H


#include <qcanvas.h>
#include <qaction.h>

#include "mapobj.h"
#include "imageobj.h"

/////////////////////////////////////////////////////////////////////////////
class FlagObj:public MapObj {
public:
    FlagObj ();
    FlagObj (QCanvas*);
    FlagObj (FlagObj*);
    ~FlagObj ();
    virtual void init ();
    virtual void copy (FlagObj*);
    virtual void move (double x,double y);      // move to absolute Position
    virtual void moveBy (double x,double y);    // move to relative Position
    virtual void setVisibility(bool);
	void load (const QString&);
	void load (const QPixmap&);
	void setName (const QString&);
	const QString getName ();
	void setGroup (const QString&);
	const QString getGroup();
	void setToolTip(const QString&);
	const QString getToolTip();
	void setButton (QAction*);
	void updateButton ();
	QPixmap getPixmap();
	bool isActive();
	void toggle();
	void activate();
	void deactivate();
	void setEnabled (bool);
	void setUsed (bool);
	bool isUsed();
	void saveToDir (const QString&, const QString&);
	
protected:	
	QString name;
	QString group;
	QString tooltip;
	bool state;
	bool used;
    virtual void positionBBox();
    virtual void calcBBoxSize();
private:
	ImageObj* icon;
	QAction* button;
};

#endif
