#include "mapobj.h"
#include "misc.h"

/////////////////////////////////////////////////////////////////
// MapObj
/////////////////////////////////////////////////////////////////
MapObj::MapObj ()
{
	//qWarning ( "Const MapObj (): Please set canvas somehow!!!");
	canvas=NULL;
    init ();
}

MapObj::MapObj (QCanvas* c)
{
//  cout << "Const MapObj\n";
    canvas=c;
    init ();
}


MapObj::MapObj (MapObj* mo)
{
//    cout << "CopyConst MapObj\n";
    copy (mo);
}

MapObj::~MapObj ()
{
//    cout << "Destr MapObj\n";
}

void MapObj::init ()
{
    absPos=QPoint(0,0);
    visible=true;
}

void MapObj::copy(MapObj* other)
{
//    canvas=other->canvas;	// already set in constr. of child, use that one...
    absPos=other->absPos;
	bbox.setX (other->bbox.x() );
	bbox.setY (other->bbox.y() );
	bbox.setSize (QSize(other->bbox.width(), other->bbox.height() ) );
}

QCanvas* MapObj::getCanvas()
{
	return canvas;
}

int MapObj::x() 
{
    return absPos.x();
}

int MapObj::y() 
{
    return absPos.y();
}

int MapObj::width() 
{
    return bbox.width();
}

int MapObj::height() 
{
    return bbox.height();
}

QPoint MapObj::getAbsPos() 
{
    return absPos;
}

QString MapObj::getPos()
{
	return qpointToString(absPos);
}

void MapObj::move (double x, double y) 
{
    int xi=static_cast <int> (x);
    int yi=static_cast <int> (y);
    absPos.setX( xi);
    absPos.setY( yi);
    bbox.moveTopLeft(QPoint(xi,yi));
    clickBox.moveTopLeft(QPoint(xi,yi));
}

void MapObj::moveBy (double x, double y) 
{
	int ix=(int)x;
	int iy=(int)y;
    MapObj::move (x+absPos.x(),y+absPos.y() );
	bbox.moveBy (ix,iy);
	clickBox.moveBy (ix,iy);
}

bool MapObj::inBox(const QPoint &p)
{
    if (p.x() >= clickBox.left() && p.x() <= clickBox.right()  
	&& p.y() <= clickBox.bottom() && p.y() >= clickBox.top() )
		return true;
    return false;	
}

QRect MapObj::getBBox()
{
    return bbox;
}

QRect MapObj::addBBox(QRect r1, QRect r2)
{	
	// Find smallest QRect containing given rectangles

	QRect n;
	// Set left border
	if (r1.left() <= r2.left() )
		n.setLeft(r1.left() );
	else
		n.setLeft(r2.left() );
		
	// Set top border		
	if (r1.top() <= r2.top() )
		n.setTop(r1.top() );
	else
		n.setTop(r2.top() );
		
	// Set right border
	if (r1.right() <= r2.right() )
		n.setRight(r2.right() );
	else
		n.setRight(r1.right() );
		
	// Set bottom 
	if (r1.bottom() <= r2.bottom() )
		n.setBottom(r2.bottom() );
	else
		n.setBottom(r1.bottom() );
	return n;
}

QSize MapObj::getSize()
{
    return bbox.size();
}


bool MapObj::isVisibleObj()
{
    return visible;
}

void MapObj::setVisibility(bool v)
{
    visible=v;
}

