#
# WAJIG - Debian Package Management Front End
#
# Copyright (c) Graham.Williams@togaware.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

#------------------------------------------------------------------------
#
# Standard python modules
#
#------------------------------------------------------------------------
import os
pause = False

setroot = "/bin/su"
if os.path.exists("/usr/bin/sudo"):
    setroot = "/usr/bin/sudo"
    #
    # In case someone is using the non-default install of sudo on
    # Debian (the default install uses a default root path for sudo
    # which includes sbin) or have added this user to the sudo group
    # (which has the effect of also using the user's path rather than
    # the root path), add the sbin directories to the PATH.
    #
    os.environ['PATH'] = os.environ['PATH'] + ":/sbin:/usr/sbin"

#------------------------------------------------------------------------
#
# Interface Variables
#
#------------------------------------------------------------------------

quiet = ""

def set_quiet():
    global quiet
    quiet = "> /dev/null"

simulate = 0
teaching = 0

def set_teaching_level(new_level):
    global teaching
    teaching = new_level

def set_simulate_level(new_level):
    global simulate
    simulate = new_level

#------------------------------------------------------------------------
#
# concat
#
#------------------------------------------------------------------------
def concat(args):
    result = ""
    for a in args:
        result = result + "'" + a + "' "
    return result

#------------------------------------------------------------------------
#
# EXECUTE
#
#------------------------------------------------------------------------
def execute(command, root=0, noquiet=0, display=1, pipe=0):
    """Ask the operating system to perform a command.

    Arguments:
    
    COMMAND     A string containing the command and command line options
    ROOT        If non-zero then root access is required to execute command
    NOQUIET     Suppress the use of quiet (in case command has a redirect)
    PIPE        If True then return a file-like object.

    Returns:
    
    Returns either the status of the command or a file-like object
    if PIPE is True.

    Note that the PIPE option was added as a minor modification and has not
    been fully tested, but is extremely useful in avoiding temporary files."""

    if teaching > 0:
        print "Performing: " + command
    elif simulate > 0 and display == 1:
        print command
    if root > 0:
        if setroot == "/usr/bin/sudo":
            # If the command contains a pipe, and requires root,
            # each part must be sudo.
            command = setroot + " " + command.replace("|", "| %s " % setroot)
        else:
            if quiet == "" and os.getenv("USER") != "root":
                print """
Using `su' and requiring root password. Install `sudo' to support user
passwords. See wajig documentation (wajig doc) for details.
"""
            command = setroot + " -c '" + command + "'"
    if noquiet > 0:
      command = command
    else:
      command = command + quiet
    command = "LC_ALL=C; export LC_ALL; set -o noglob; " + command
    if simulate == 0:
        if pipe == 0:
            #if pause:
            #    command += " | /usr/bin/pager"
            return os.system(command)
        else:
            return os.popen(command)
    return 0
