/*Wallch - WallpaperChanger
A tool for changing Desktop Wallpapers automatically
with lots of features
Copyright © 2011 by Alex Solanos and Leon Vytanos

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 3
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.*/

#include "extras.h"
#include "ui_extras.h"

#include "glob.h"

#include <QSettings>
#include <QFileDialog>
#include <QMessageBox>

#include <iostream>
#include <fstream>
using namespace std;

Extras::Extras(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Extras)
{
    ui->setupUi(this);
    ui->toolBox->setItemIcon(0, QIcon::fromTheme("emblem-web"));
    if(_live_earth_running_)
        ui->pushButton_6->setEnabled(false);
    else
        ui->pushButton_7->setEnabled(false);
}

Extras::~Extras()
{
    delete ui;
}

void Extras::closeEvent( QCloseEvent * )
{

}

void Extras::on_closeButton_clicked()
{
    close();
}

void Extras::on_pushButton_6_clicked()
{
    if(_start_running_){
    //Start is running, in order to avoid conflicts display an error message!
        QMessageBox msgBox;
        msgBox.setWindowTitle(tr("Live Earth Wallpaper"));
        msgBox.setText(tr("Please stop the current process and try again."));
            msgBox.setIconPixmap(QIcon(":/icons/Pictures/earth.png").pixmap(QSize(100,100)));
            msgBox.setWindowIcon(QIcon(":/icons/Pictures/wallch.png"));
            msgBox.exec();
            return;
    }
    Q_EMIT start_live_earth();
    ui->pushButton_7->setEnabled(true);
    ui->pushButton_6->setEnabled(false);

}

void Extras::on_pushButton_7_clicked()
{
    _live_earth_running_=0;
    Q_EMIT stop_live_earth();
    ui->pushButton_7->setEnabled(false); ui->pushButton_6->setEnabled(true);
}

void Extras::fix_buttons(){
    ui->pushButton_6->setEnabled(false);
    ui->pushButton_7->setEnabled(true);
}
