/*-----------------------------------------------------------------------------
 *  FILE: Template.cc
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Class to manage gnome's wallpaper list.
 *
 *-----------------------------------------------------------------------------
 */

#include "GnomeWPList.hh"
#include <iostream>
#include <fstream>
#include <glibmm.h>

/** @defgroup WPTray WPTray
 * WPTray contains classes used in the Wallpaper Tray program.
 */

//------------------------------------------------------------------------
/**
<GnomeWPList::GnomeWPList>
@brief Construct a GnomeWPList object.

@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
GnomeWPList::GnomeWPList
(
) :
	m_bIncomingFileName(false),
	m_bIncomingOptions(false),
	m_bIgnoreIncoming(false)
{
	std::string sz_Path = Glib::get_home_dir() + "/.gnome2/backgrounds.xml";

	std::ifstream ifile(sz_Path.c_str());

	if(ifile.good())
	{
		parse_file(sz_Path);
	}// end if
}// end GnomeWPList::GnomeWPList

//------------------------------------------------------------------------
/**
<GnomeWPList::~GnomeWPList>
@brief Destroy a GnomeWPList object.

@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
GnomeWPList::~GnomeWPList
(
)
{
	// ...
}// end GnomeWPList::~GnomeWPList

//------------------------------------------------------------------------
/**
<GnomeWPList::GetFileList>
@brief Destroy a GnomeWPList object.

@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
const std::list<Glib::ustring> & GnomeWPList::GetFileList
(
) const
{
	return m_FileList;
}// end GnomeWPList::GetFileList

//------------------------------------------------------------------------
/**
<GnomeWPList::on_start_document>
@brief Override of the sax parser method.

@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_start_document
(
)
{
	// ...
}// end GnomeWPList::on_start_document

//------------------------------------------------------------------------
/**
<GnomeWPList::on_end_document>
@brief Override of the sax parser method.

@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_end_document()
{
	// ...
}// end GnomeWPList::on_end_document


//------------------------------------------------------------------------
/**
<GnomeWPList::on_start_element>
@brief Override of the sax parser method.

@param _szName The name of the element.
@param _Properties Element attributes.
@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_start_element
(
	const Glib::ustring &			_szName,
	const AttributeList &			_Properties
)
{
	m_bIncomingFileName	= (_szName == "filename");
	m_bIncomingOptions	= (_szName == "options");
}// end GnomeWPList::on_start_element

//------------------------------------------------------------------------
/**
<GnomeWPList::on_end_element>
@brief Override of the sax parser method.

@param _szName Name of the element that has ended.
@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_end_element
(
	const Glib::ustring &			_szName
)
{
	if(!m_bIgnoreIncoming && _szName == "wallpaper")
	{
		m_FileList.push_back(m_szIncomingFileName);
	}// end if
}// end GnomeWPList::on_end_element

//------------------------------------------------------------------------
/**
<GnomeWPList::on_characters>
@brief Override of the sax parser method.

@param _szCharacters Used to capture the text of an element.
@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_characters
(
	const Glib::ustring &			_szCharacters
)
{
	if(m_bIncomingFileName && _szCharacters != "(none)")
	{
		m_szIncomingFileName = _szCharacters;
	}// end if
	else
	if(m_bIncomingOptions)
	{
		m_bIgnoreIncoming = (_szCharacters == "wallpaper");	// seems to mean tiled wp, ignore
	}// end if

	m_bIncomingFileName	= false;
	m_bIncomingOptions	= false;
}// end GnomeWPList::on_characters

//------------------------------------------------------------------------
/**
<GnomeWPList::on_comment>
@brief Override of the sax parser method.

@param _szName Name of the element that has ended.
@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_comment
(
	const Glib::ustring &			_szText
)
{
	// who cares!
}// end GnomeWPList::on_comment

//------------------------------------------------------------------------
/**
<GnomeWPList::on_warning>
@brief Override of the sax parser method.

@param _szText Text involved in the warning.
@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_warning
(
	const Glib::ustring &			_szText
)
{
	// ...
}// end GnomeWPList::on_warning

//------------------------------------------------------------------------
/**
<GnomeWPList::on_error>
@brief Override of the sax parser method.

@param _szText Text involved in the error.
@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_error
(
	const Glib::ustring &			_szText
)
{
	// ...
}// end GnomeWPList::on_error

//------------------------------------------------------------------------
/**
<GnomeWPList::on_fatal_error>
@brief Override of the sax parser method.

@param _szText Text involved in the error.
@date 12-11-2006 GAF Written
**/
//------------------------------------------------------------------------
void GnomeWPList::on_fatal_error
(
	const Glib::ustring &			_szText
)
{
	// TODO: we should really do something here ...???
}// end GnomeWPList::on_fatal_error
