/*-----------------------------------------------------------------------------
 *  FILE: Template.hh
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Class to manage gnome's wallpaper list.
 *
 *-----------------------------------------------------------------------------
 */

#ifndef _GNOMEWPLIST_GF_12112006
#define _GNOMEWPLIST_GF_12112006

#include <libxml++/libxml++.h>
#include <glibmm/ustring.h>

//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Class to manage gnome's wallpaper list.

@author Gareth Foster
@date 12/11/2006
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class GnomeWPList : public xmlpp::SaxParser
{
public:
	// public class methods
	GnomeWPList();
	virtual ~GnomeWPList();

	const std::list<Glib::ustring> & GetFileList() const;

private:
	// private class methods
	virtual void on_start_document();
	virtual void on_end_document();
	virtual void on_start_element(const Glib::ustring& name, const AttributeList& properties);
	virtual void on_end_element(const Glib::ustring& name);
	virtual void on_characters(const Glib::ustring& characters);
	virtual void on_comment(const Glib::ustring& text);
	virtual void on_warning(const Glib::ustring& text);
	virtual void on_error(const Glib::ustring& text);
	virtual void on_fatal_error(const Glib::ustring& text);

private:
	// private class data
	bool						m_bIncomingFileName;
	bool						m_bIncomingOptions;
	bool						m_bIgnoreIncoming;
	Glib::ustring				m_szIncomingFileName;

	std::list<Glib::ustring>	m_FileList;

};// end class GnomeWPList

#endif	// end _GNOMEWPLIST_GF_12112006
