/*-----------------------------------------------------------------------------
 *  FILE: PreferencesDialog.hh
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Dialog derivation that implements Wallpaper Tray preferences.
 *
 *-----------------------------------------------------------------------------
 */

#include <gtkmm.h>
#include <libglademm.h>
#include <gconfmm-2.6/gconfmm.h>
#include <list>

#ifndef _PREFERENCES_DIALOG_GF_12112006
#define _PREFERENCES_DIALOG_GF_12112006

//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Defines the columns to be used in the preferences dialog tree model.

@author Gareth Foster
@date 05/09/2005
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class PreferencesDialogModelColumns : public Gtk::TreeModel::ColumnRecord
{
	public:
		Gtk::TreeModelColumn<Glib::ustring>                m_DirectoryName;
		
		PreferencesDialogModelColumns()
		{
			add(m_DirectoryName);
		}// end PreferencesDialogModelColumns
};// end class PreferencesDialogModelColumns

//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Dialog derivation that implements Wallpaper Tray preferences.

@author Gareth Foster
@date 05/09/2005
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class PreferencesDialog : public Gtk::Dialog
{
public:
	// public class interface
	PreferencesDialog(BaseObjectType * _pWindow, const Glib::RefPtr<Gnome::Glade::Xml> & _pGlade);
	virtual ~PreferencesDialog();

	void OnButtonCloseClick();
	void OnButtonApplyClick();
	void OnButtonAddDirClick();
	void OnButtonRemDirClick();
	void OnEntryTimeChanged();

private:
	// private class interface
	void GetSettingsInGconf();
	void SetSettingsInGconf();

private:
	// private class members
	const Glib::RefPtr<Gnome::Glade::Xml>		m_pGlade;
	Glib::RefPtr<Gnome::Conf::Client>			m_pGconfClient;

	Gtk::Button *								m_pButtonClose;
	Gtk::Button	*								m_pButtonApply;
	Gtk::Button	*								m_pButtonAddDir;
	Gtk::Button	*								m_pButtonRemDir;
	Gtk::Entry *								m_pEntryTime;
	Gtk::Entry *								m_pEntryMode;
	Gtk::Entry *								m_pEntrySelectionMode;

	Gtk::CheckButton *							m_pCheckButtonTimeout;
	Gtk::CheckButton *							m_pCheckButtonLogonNew;
	Gtk::CheckButton *							m_pCheckButtonImageCheck;
	Gtk::CheckButton *							m_pCheckButtonFollowLinks;
	Gtk::CheckButton *							m_pCheckButtonNotifications;
	Gtk::TreeView *								m_pTreeView;

	PreferencesDialogModelColumns				m_Model;
	Glib::RefPtr<Gtk::ListStore>				m_pListstore;

	std::list<Glib::ustring>					m_lsWpDir;

	int											m_nTimeout;
	bool										m_bTimeout;
	bool										m_bWpLogon;
	bool										m_bImgCheck;
	bool										m_bFollowLinks;
	bool										m_bNotifications;
	Glib::ustring								m_szPictureOptions;

};// end class PreferencesDialog

#endif	// _PREFERENCES_DIALOG_GF_12112006
