/*-----------------------------------------------------------------------------
 *  FILE: SearchDialog.hh
 *
 *      Copyright(c) 2006 Gareth Foster.
 *
 *      Dialog derivation that implements Wallpaper Tray search tool.
 *
 *-----------------------------------------------------------------------------
 */

#include <gtkmm.h>
#include <libglademm.h>
#include <libgnomeuimm/druid.h>
#include <libgnomeuimm/druid-page-standard.h>
#include <gconfmm-2.6/gconfmm.h>
#include <boost/filesystem/operations.hpp>
#include <boost/filesystem/fstream.hpp>
#include <boost/regex.hpp>

#ifndef _SEARCH_DIALOG_GF_12112006
#define _SEARCH_DIALOG_GF_12112006

namespace fs = boost::filesystem;

//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Defines the columns to be used in the search tool dialog tree model.

@author Gareth Foster
@date 05/09/2005
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class SearchDialogModelColumns : public Gtk::TreeModel::ColumnRecord
{
public:
	Gtk::TreeModelColumn<Glib::ustring>	m_FilePath;
		
	SearchDialogModelColumns()
	{
		add(m_FilePath);
	}// end SearchDialogModelColumns

};// end class SearchDialogModelColumns

//-----------------------------------------------------------------------------
/** @ingroup WPTray
@brief Dialog derivation that implements Wallpaper Tray search tool.

@author Gareth Foster
@date 05/09/2005
@remark Copyright(c) 2006 Gareth Foster.
**/
//-----------------------------------------------------------------------------
class SearchDialog : public Gtk::Dialog
{
public:
	// public class methods
	SearchDialog(BaseObjectType * _pDialog, const Glib::RefPtr<Gnome::Glade::Xml> & _pGlade);
	virtual ~SearchDialog();

private:
	// private class methods
	bool OnButtonNextClick(Gtk::Widget & _refWidget);
	void OnButtonApplyClick(Gtk::Widget & _refWidget);
	void OnButtonCancelClick();
	void OnShow();

	void WallpaperSearch(fs::path _pathCurrent, const boost::regex & _refRegex, std::list<Glib::ustring> & _reflsResults);

private:
	// private class members
	const Glib::RefPtr<Gnome::Glade::Xml>		m_pGlade;
	Glib::RefPtr<Gnome::Conf::Client>			m_pGconfClient;

	Gnome::UI::Druid *							m_pDruid;
	Gnome::UI::DruidPage *						m_pDruidPageStdStart;
	Gnome::UI::DruidPage *						m_pDruidPageStdSearchString;
	Gnome::UI::DruidPage *						m_pDruidPageFinish;
		
	Gtk::Entry *								m_pEntrySearchString;

	Gtk::TreeView *								m_pTreeView;
	SearchDialogModelColumns					m_Model;
	Glib::RefPtr<Gtk::ListStore>				m_pListStore;

	Gtk::RadioButton *							m_pRadioButtonSelect;
	Gtk::RadioButton *							m_pRadioButtonDelete;

};// end class SearchDialog

#endif	// _SEARCH_DIALOG_GF_12112006
