#include <QtDebug>
#include <QObject>
#include <QDir>
#include <QFileSystemWatcher>
#include <QImageReader>
#include <QPainter>
#include <QWidget>
#include <QLabel>
#include <QFileInfo>
#include <QFile>
#include <QTextStream>
#include <QTimer>

#include "../include/defs.h"
#include "wallyplugin.h"
#include "wallypluginexport.h"

WallyPlugin::WallyPlugin(QObject *parent, const QVariantList &args)
    : Plasma::Wallpaper(parent,args)
{
  QDir(QDir::homePath()).mkdir(TEMP_PATH);

  timerStarted = false;

  QFileSystemWatcher *watcher = new QFileSystemWatcher(this);
  timer = new QTimer(this);
  timer->setSingleShot(true);
  timer->setInterval(10000);

  connect(timer,SIGNAL(timeout()),this,SLOT(reReadWallpaperFromFileName()));
  connect(watcher,SIGNAL(directoryChanged(const QString &)),this,SLOT(readWallpaperFromFileName()));
  watcher->addPath(QDir::homePath() + "/" + TEMP_PATH);
}

void WallyPlugin::paint(QPainter *painter, const QRectF &exposedRect)
{
  painter->save();

  if (painter->worldMatrix() == QMatrix())
    painter->resetTransform();

  painter->setCompositionMode(QPainter::CompositionMode_Source);
  if (!pixmap.isNull())
    painter->drawPixmap(exposedRect,pixmap,exposedRect);
  else
    painter->fillRect(exposedRect,Qt::black);

  painter->restore();
}

void WallyPlugin::loadWallpaper()
{
  if (!wallpaper.isEmpty())
  {
    pixmap.load(wallpaper);
    emit update(boundingRect());
  }
}

void WallyPlugin::init(const KConfigGroup & /* config */)
{
  timerStarted = true;
  readWallpaperFromFileName();
  timerStarted = false;
}

void WallyPlugin::setWallpaper(const QString &fileName)
{
  if (QImageReader(fileName).canRead())
  {
    wallpaper = fileName;
    loadWallpaper();
  }
}

void WallyPlugin::reReadWallpaperFromFileName()
{
  readWallpaperFromFileName();
  timerStarted = false;
}

void WallyPlugin::readWallpaperFromFileName()
{
  QString fileName;
  QFile file(QDir::homePath() + "/" + TEMP_PATH + "/wallykde4.img");
  QTextStream text(&file);

  file.open(QIODevice::ReadOnly);
  fileName = text.readLine();

  if (!fileName.isEmpty() && (fileName != wallpaper))
    setWallpaper(fileName);
  file.close();

  if (!timerStarted)
  {
    timerStarted = true;
    timer->start();
  }
}

#include "wallyplugin.moc"
