#ifndef GVT_MANAGER_H
#define GVT_MANAGER_H

// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include "warped.h"
#include "CommunicatingEntity.h"
#include "Configurable.h"

/** The GVTManager abstract base class.

    This is the abstract base class for the various GVT
    Estimation Algorithm implementations in the Simulation kernel.

*/
class GVTManager : virtual public CommunicatingEntity,
		   virtual public Configurable {
public:
   
  /**@name Public Class Methods of GVTManager. */
  //@{

  /// Destructor
  virtual ~GVTManager(){};

  /// is it time to start a GVT estimation cycle
  virtual bool checkGVTPeriod() = 0;
   
  /// return the GVT value to the caller
  virtual const VTime &getGVT() = 0;
   
  /// Calculate any gvt manager specific info. 
  virtual void calculateGVTInfo() = 0;

  /// Get any gvt manager specific info.
  virtual const string getGVTInfo( unsigned int srcSimMgr,
				   unsigned int destSimMgr,
				   const VTime &sendTime ) = 0;
   
  /// update this simulation manager's record of events it sent out 
  virtual void updateEventRecord( const string &infoStream,
				  unsigned int srcSimMgr ) = 0;
   
  /** Calculate the actual value of GVT.
       
  This function should only be called in the function that is
  responsible for the calculation of the "real" gVT.  It is
  assumed that simulation manager 0 is responsible for gVT
  calculation.
       
  */
  virtual void calculateGVT() = 0;
   
  /// update everybody in the simulation with the new GVT value
  virtual void sendGVTUpdate() = 0;

  virtual void registerWithCommunicationManager() = 0;

  //@} // End of Public Class Methods of GVTManager.

protected:
   
  /**@name Protected Class Methods of GVTManager. */
  //@{
   
  GVTManager(){};
   
  //@} // End of Protected Class Methods of GVTManager.
};
#endif

