// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: GVTManagerFactory.cpp
// 
//---------------------------------------------------------------------------

#include "GVTManagerFactory.h"
#include "MatternGVTManager.h"
#include "SimulationConfiguration.h"
#include "TimeWarpConfigurationManager.h"
#include <clutils/ConfigurationScope.h>
#include <clutils/Debug.h>
#include <clutils/StringUtilities.h>

GVTManagerFactory::GVTManagerFactory(){}

GVTManagerFactory::~GVTManagerFactory(){
  // myGVTManager will be deleted by the end user - the
  // TimeWarpSimulationManager
}

Configurable *
GVTManagerFactory::allocate( SimulationConfiguration &configuration,
			     Configurable *parent ) const {
  Configurable *retval = 0;
  TimeWarpSimulationManager *mySimulationManager 
    = dynamic_cast<TimeWarpSimulationManager *>(parent);
  ASSERT( mySimulationManager != NULL );
  // the following cases are possible:

  // (1) GVTManager is Mattern. In this is the case, we need to find
  //     a GVT estimation period (if any; defaults to 1). Then
  //     instantiate the MatternGVTStateManager with a state period (if
  //     one is found).
  
  
  if( configuration.gvtManagerTypeIs( "MATTERN" ) ){
    unsigned int gvtPeriod = 1;
    configuration.getGVTPeriod( gvtPeriod );
    retval = new MatternGVTManager( mySimulationManager,
				    gvtPeriod );
    clutils::debug 
      << "(" << mySimulationManager->getSimulationManagerID() 
      << ") configured a Mattern GVT Manager with period = " 
      << gvtPeriod << endl;
  }
  else {
    mySimulationManager->shutdown( "Unknown GVTManager choice \"" +
				   configuration.getGVTManagerType() +
				   "\"" );
  }

  return retval;
}

const GVTManagerFactory *
GVTManagerFactory::instance(){
  static GVTManagerFactory *singleton = new GVTManagerFactory();

  return singleton;
}

