#ifndef IN_FILE_QUEUE_H
#define IN_FILE_QUEUE_H

// Copyright (c) The University of Cincinnati.
// All Rights Reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

#include <fstream>
#include "warped.h"
#include "InFileData.h"
#include <set>
#include <string>

using std::string;
using std::multiset;
using std::ifstream;

/** The InFileQueue class.

    The InFileQueue class represents a queue of file position records
    at different time instances so that during rollback we can
    correctly seek to the correct position in a file we are currently
    reading.

*/
class InFileQueue : public multiset< InFileData > {
public:

   /**@name Public Class Methods of InFileQueue. */
   //@{

   /// Default Constructor that takes a file name
   InFileQueue(const string &fileName);

   /// Destructor
   ~InFileQueue();

   /// Open a particular file
   void open(const string &fileName);

   /// garbage collect everything earlier than garbage collect time
   void garbageCollect(const VTime &garbageCollectTime);

   /// rollback to the rollback time
   void rollbackTo(const VTime &rollbackTime);

   /// store the current position at the current time
   void storePos(const VTime &time);

   /// close the file queue
   void close();

   /// get a handle to the file stream
   ifstream& access() {
      return inFile;
   };

   //@} // End of Public Class Methods of InFileQueue.
  
private:

   /**@name Private Class Attributes of InFileQueue. */
   //@{

   /// name of the file
   string inFileName;

   /// the file stream
   ifstream inFile;

   //@} // End of Private Class Attributes of InFileQueue.
};
#endif

