// Copyright (c) The University of Cincinnati.  
// All rights reserved.

// UC MAKES NO REPRESENTATIONS OR WARRANTIES ABOUT THE SUITABILITY OF 
// THE SOFTWARE, EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED
// TO THE IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
// PARTICULAR PURPOSE, OR NON-INFRINGEMENT.  UC SHALL NOT BE LIABLE
// FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF USING,
// RESULT OF USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
// DERIVATIVES.

// By using or copying this Software, Licensee agrees to abide by the
// intellectual property laws, and all other applicable laws of the
// U.S., and the terms of this license.

// Authors: Malolan Chetlur             mal@ececs.uc.edu
//          Jorgen Dahl                 dahlj@ececs.uc.edu
//          Dale E. Martin              dmartin@cliftonlabs.com
//          Radharamanan Radhakrishnan  ramanan@ececs.uc.edu
//          Dhananjai Madhava Rao       dmadhava@ececs.uc.edu
//          Philip A. Wilsey            phil.wilsey@uc.edu

//---------------------------------------------------------------------------
// 
// $Id: SourceObject.cpp
// 
//---------------------------------------------------------------------------

#include "SourceObject.h"
using std::cerr;
using std::endl;

SourceObject::SourceObject(const VTime& starttime):startTime(starttime),sourceFinished(false){}

SourceObject::~SourceObject(){}

bool
SourceObject::amIDone(){
  if(!sourceFinished){
    return false;
  }
  else {
    return true;
  }
}
void
SourceObject::iAmFinished(){
  sourceFinished = true;
}

const int* 
SourceObject::getFanouts(){
  cerr << "Error: SourceObject::getFanouts called\n";
  return NULL;
}

void
SourceObject::sendEvent(const Event* event){
  cerr << "Error: SourceObject::sendEvent called\n";
  cerr << "Event is " << event << endl;
}

const Event* 
SourceObject::getEvent(){
  cerr << "Error: SourceObject::getEvent called\n";
  return NULL;
}

bool
SourceObject::haveMoreEvents(){
  cerr << "Error: SourceObject::haveMoreEvents called\n";
  return false;
}


