#ifndef _SHA1LIB_H_
#define _SHA1LIB_H_

#include <stdint.h>
#include <endian.h>

typedef struct {
  uint32_t state[5];
  uint32_t count[2];
  unsigned char buffer[64];
} SHA1_CTX;

void SHA1Init(SHA1_CTX* context);
void SHA1Update(SHA1_CTX* context, unsigned char* data, uint32_t len);	/* JHB */
void SHA1Final(unsigned char digest[20], SHA1_CTX* context);

#endif
