module Main where
import System.IO
import System.Process
import System.Environment
import GHC.Paths
import System.Exit
import System.Directory

-- in the past this was a shell script
-- I didn't know how to get the installation path from Cabal - so I rewrite it
-- as Haskell application

main = do
  -- custom addiotional arguments:
  args <- getArgs


  case args of
    [] -> do
      n <- getProgName
      putStrLn $ "usage: " ++ n ++ " --make Main.hs"
      putStrLn $ "where Main.hs is a file such as the first hello world example found on "
      putStrLn $ "http://haskell.org/haskellwiki/WASH"

    _ -> do

      mwash2hs <- findExecutable "wash2hs"

      case mwash2hs of

        Nothing -> error "wash2hs not found in PATH"

        Just wash2hs -> do
              n <- getProgName
              let allArgs = ["-pgmF", wash2hs, "-F", "-package", "WashNGo" {- TODO: add version ? -}]
                            ++ args

              p <- runProcess GHC.Paths.ghc allArgs Nothing Nothing Nothing Nothing Nothing
              ec <- waitForProcess p
              exitWith ec
