module DiskImages where
import CGITypes
allImages = [cooked_peter_gabriel, cooked_blues_brothers, cooked_chaka_khan, cooked_die_fantastischen_vier, cooked_elvis_presley, cooked_stanley_clarke, cooked_zz_top]

data DiskDesc = DiskDesc {diskInStock :: Int, diskImage :: FreeForm, diskPrice :: Integer}
inventory =
	[ DiskDesc 1  cooked_peter_gabriel 995
	, DiskDesc 4  cooked_blues_brothers 695
	, DiskDesc 2  cooked_chaka_khan 995
	, DiskDesc 1  cooked_die_fantastischen_vier 1395
	, DiskDesc 99 cooked_elvis_presley 695
	, DiskDesc 1  cooked_stanley_clarke 1395
	, DiskDesc 4  cooked_zz_top 695
	]

raw_blues_brothers = "\255\216\255\224\NUL\DLEJFIF\NUL\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\255\219\NULC\NUL\b\ACK\ACK\a\ACK\ENQ\b\a\a\a\t\t\b\n\f\DC4\r\f\v\v\f\EM\DC2\DC3\SI\DC4\GS\SUB\US\RS\GS\SUB\FS\FS $.' \",#\FS\FS(7),01444\US'9=82<.342\255\219\NULC\SOH\t\t\t\f\v\f\CAN\r\r\CAN2!\FS!22222222222222222222222222222222222222222222222222\255\192\NUL\DC1\b\NUL\150\NUL\150\ETX\SOH\"\NUL\STX\DC1\SOH\ETX\DC1\SOH\255\196\NUL\US\NUL\NUL\SOH\ENQ\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DLE\NUL\STX\SOH\ETX\ETX\STX\EOT\ETX\ENQ\ENQ\EOT\EOT\NUL\NUL\SOH}\SOH\STX\ETX\NUL\EOT\DC1\ENQ\DC2!1A\ACK\DC3Qa\a\"q\DC42\129\145\161\b#B\177\193\NAKR\209\240$3br\130\t\n\SYN\ETB\CAN\EM\SUB%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\225\226\227\228\229\230\231\232\233\234\241\242\243\244\245\246\247\248\249\250\255\196\NUL\US\SOH\NUL\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DC1\NUL\STX\SOH\STX\EOT\EOT\ETX\EOT\a\ENQ\EOT\EOT\NUL\SOH\STXw\NUL\SOH\STX\ETX\DC1\EOT\ENQ!1\ACK\DC2AQ\aaq\DC3\"2\129\b\DC4B\145\161\177\193\t#3R\240\NAKbr\209\n\SYN$4\225%\241\ETB\CAN\EM\SUB&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\130\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\226\227\228\229\230\231\232\233\234\242\243\244\245\246\247\248\249\250\255\218\NUL\f\ETX\SOH\NUL\STX\DC1\ETX\DC1\NUL?\NUL\241\251\187\187\159\182\207\254\145/\250\198\254\&3\235]\GS\189\150\155q\225\171\253]n5b,\228\142\&2\159iU\243\v\DLE3\247N\222\189\&9\174V\243\254?\167\255\NUL\174\141\252\235R\207^\138\215\195\&7\186\&3Y3\139\183Y\RSo;\ENQJ\156\174\ETBoN9\231\159j\235\197B\164\163\USe{\221^\221\175\175\224g\ACK\175\169\208C\225\196\190\210\244\155\251\tuic\188\187he\RSp&(\195\NAK\221\194\245\232\DEL?\173X\159\194\208\161\215\210\v\141Nyt\201aH\208\\\168\243D\128u;x\199\&5\207'\137\163M'H\176\&6\f\DEL\179n>\208\143\231\227y\221\184\130\&6\240?\151\189]\185\241\172W\139\172$\218S\DC4\213Z&\152-\214\&6\236\ETX\ESC~On\249\175\&6T\179\SOm/k\190\171ne\231\252\183\236j\157;\DEL]\191\204w\135t\136\245\175\DC4^\233s\\j\DLE\199\n\200\201\182q\185J\DLE\n\177\193\a\175Q\142\149\175\a\132\173\164\179Y\229\187\213!v\210\228\191\242L\224\237(G\203\187n\b9\207\168\239\214\185\141\ETB\196\209\232\186\244\250\148\SUBpd\146\DC3\DC2\194f?(8\201,A$\156g\183'\240\173;\SI\RS\157?H]&\GS/6Ko$\NUL=\198_\247\135,Km\252\128\NUL\SI~\207\NAKK\RS\231z7\182\157W\157\250\250\DEL\152A\211\183\188S\130\197%\240=\214\180\215w\162\234\ESC\165\183T\DC3\r\135 \FS\227\EM\232}\DEL\194\175h\SUB=\190\176\NAKZ\227P\DC2\GS:[\188-\200\EMtr\155FW\128q\248{\213\b|Qk\SYN\143q\163\DELd)\211g*\229\ENQ\193\243D\128\253\253\251pz\SOH\141\184\192\RS\249\143K\241:iwr\203\RS\158\RS\SYN\180k4\136\204F\216\217\183\&1-\142X\146y\224s\211\160\173\234C\ETB(ME4\239u\170\219M7\254\187\146\156\DC3F\214\159\225\169\181\&8\174\141\167\218\154\250\221b-`\247\203\184\135\ENQ\139\135\198\b\193\\\fpI\207@\r}\ETXGMC\198\146h\151\175\169C\US\207\128\211\ENQ\146=\160\183\205\193\a\129\219\234+\ETB\251^\197cX\225\210\218\US,\134\138h\174\138\206\172\&3\146_n\b<q\129\140\fw\205\171?\ETB\221[\248\174_\DLE\207o\FS\247N\b\bX\170\174Wo\185\&8^?ZN\150\&3\150\162Ou\167t\244\183W\167\245\168sCC\170\177\240\133\173\219\216\249\147\234H\215\&6r\206\209\164\225\130\&20\NUL\a\v\131\187\&9\199QU/\252&\150zD\154\163^\222\167\217\237#\154\230\193\230\253\228r\185\SOHT\182\&8\GSO#<{\228f\216x\246m2\194;\v}6\US\178\"H\161\RSF,K\156\177-\199\169\ETX\NULu\239J\223\DLEn\166\181\SYN\247\&6\DLEL\143o\246[\146\206\192\207\CAN\206\210H\232\195'\230\247<W\"\161\153\169\222\250_\186\218\239\244\249\222\218\238_5+\SO\146\195O_\SOYk\169.\162\241\\I\246i-\190\212\SOH\142Pz\238\218r\164\STXq\140\242\&9\171\243h\154\\~<\RS\ESC\243\&5L\ETB\v\231}\172\FS\143,\177\227o\FS\227\215\189rR\235e\237-,R\220%\133\180\173\&0\132\185%\220\255\NUL\DC37\EM8\192\224\SO>\185\171\147x\194\226O\SYN\167\136\218\206\221n\151\147\CAN-\176\157\187s\215==\235\166Xl^\182oi[^\183\247~\228J\148?/\248&\197\206\135\NAK\150\129\172\234\DC3Itd\178\188\DLE\194\171x\CAN4e\192\249\177\146\SO>\159J\181\169xz\215O\241\DC4V9\189{If\183\133%\ETB\234d\ACKNNT\f\129\128\216\&8\FS\129\215<`[\235W\215\150\SUB\158\159o\163}\162=N\227\237\DC2\b\150F`\192\134\194\227\182~\189j\230\171\175\234\SYN\218\244:\182\167\225\200\237\175\152F\241y\235*\f!\CAN!I\246\193?\203\173g\236q\188\206\237\245\235\229\ESCu\239q\243@\213\191\240\189\141\163\129u\168_i\234\218\159\217bi\167\220'\132\DC1\151\FS\fc'\158\149\139\226}\DC3P\208\160\142Ic\158\&4yJ\164\241]\EM\"\145q\199\184n\SI^\189\186S.\188sq{o4\ETBZm\148\241=\215\218\145$\220Dn~\240\FS\253\211\147\199\251G\219\CAN\247:\204\178\233CK\134\&1\r\144\152\207\229\239-\243\227\GSO`;{\243\154\211\vG\ESC\EME\213~\190\158Z\254w\249\nR\131Z\GS\159\194+\137\228\241u\210\188\210\&0\251\ETX\156\&3\DC3\255\NUL-#\162\161\248=\255\NUL#\133\215\253x?\254\140\142\138\236\173\241\144\182\&8{\207\248\253\159\254\186\&7\243\168j{\191\248\253\184\255\NUL\174\141\252\235G@\208\255\NUL\183.\164\132]\199\NUL\140\ACK`F\233\EM{\148L\141\228q\144\SOq\208\FS\SUB\235rQWf{\152\244\184\175c\209\254\n\233\154\149\178\\\143\DC2\181\204D\225\190\205n\ETB\RS\199,H>\196f\186[O\130^\ETB\131i\153\245\v\146:\137'\n\SI\253\242\160\254\181\155\175\SOH\242\179\231|R\240+\234\ESC_\134\RS\SO\179\218WC\134B;\204\239'\232\196\138\214\177\208\188=m\206\159\166i\168c;wC\STXeN3\140\129\158\132~u?X]\DLEr\159'\219\216\221\221\176[kY\231c\208E\EMb\DEL*\217\181\240/\138o\STX\152\&4\rC\r\208\201\t\140~m\129_U\172aT\"\140/`:Px\CAN\169x\135\209\ENQ\143\155-\190\DC2x\194|\ETB\176\134\220\RS\243\\'\US\130\146\DELJ\165\175\248!\188*\150\231[\213mby\201\219\r\170\&4\210`ul\GS\163\US\141{\183\142\252E?\134\252'{\169\219D$\158\&0\171\CAN\DEL\186\v0\\\159\166k\231yu\ENQ\241-\196\250\151\136uwk\160\NUL\NUL)\CANQ\208\NUL\ETB\NULd\244\247\172\231\137\148Qt\233\243\&3\190\208>\DC2\233:\206\157\ACK\161\ETB\136\228\185\182\148d\CAN-\194\US\167$\224\142\224\138\233\237~\rx^\r\166f\191\184#\168\146`\160\255\NUL\223 \US\214\188\163\194^1\186\240\158\183\FS6W-q\164\207*\153ae\235\158\v\SIF\RS\221q\205}%\FS\196\142i\198\172\166\174L\227\202\236s\246\DEL\r\188\USk\183n\137\ETX\145\222gi3\248\&1#\244\173\171_\SIh\182;~\203\164X@W\163Gn\138G\226\ACKj\192\144\210\249\212;\178I\242\168\187W\128;\SO\ENQx\223\199\&8\SOH\254\196\185\a\254{F\DEL\241\194?\173z\209\148\177\"\188\231\227-\183\155\225\ESCY\251\197z\185\227\177V\US\225UMZHg\132\209A\235Eu\129\232\US\a\191\228o\186\255\NUL\175\a\255\NUL\209\145\209G\193\239\249\FS.\191\235\193\255\NUL\244dtW\NAKo\140\181\177\195\222\DEL\199\237\199\253to\231[:5\137m\RS\243W\138\&3)\211\231\136O\CAN\207\250\153\ETX\STXx\198\&9\CAN\227\156\145\138\198\187\255\NUL\143\219\143\250\232\223\206\187\207\133w:g\218u\221\&3Y\186\130\218\198\250\192\163\180\206\DLE\DC2\CANc\EOT\145\200\f\196}+\162\178\189\&2\"\245:\169\214\246=z\223Z\209\181K\135h\226W\184\r0\149L \225\SOHp\bd,pw30\ESC\143\ESCq^\195cy\SYN\161a\ENQ\228\a1O\SUB\200\185\235\130\&3\207\189x_\129\&5\216\206\137\170\232\255\NULj\129w\177\128\220\227{\180;v\166# \179\168\EM\224\f\140\156\226\189\ESC\192\SUB\138\170^hr_\v\187\139Y\SUBO;#\231\f\199q\227\143\189\243c\176\145GQ\\\b\213\156\199\199}ST\178\210\&4\203{9\164\134\206\230I\SYN\225\163b\v\DLE\ETBj\146;\FS\177\199|{W\147\248\&7\197z\239\134/\212\233\ENQ\231\133\220\EM\173\b%$\237\248\USq\237\215\165{\207\196\239\t\234\190-\209\225\181\176\186\130\&8!c4\176\188yyX\SI\151cv<\145\142\&3\158\181\243\238\159\161$\215\173m-\241\182x\US\247\185S\219\145\232A\246<\138\137\203\151R\225\SOgd})\224\DEL\DC3\201\226\157\EM\239.!\182\182\152HG\217\226\184\DC2\180j\t\NUL\190\a\EOT\144\216\RS\130\186GR\231\165y\167\194\217t-'N\187\133&\138\218\242\230pY%\151o\152\NUL;|\181c\146\188\183\230}\171\189\143_\210e\191\SYNQ\234vovs\136\SYNu.q\237\156\213FWW3\156\FSd\209\SO\175\164\219\234\250]\206\159t\133\160\184\140\198\254\160\DC1\212{\142\163\233_=\207\164\217\232\ETBS\233\147\172\&1\220D<\155\207\&1\241\231\168 \130\160\142\SOH\192\&9\CAN\235^\241\226\191\ETB\233^\DC2\211M\222\161.Y\242\"\129\&0d\148\250\SOH\252\201\224W\135j7C\226\SO\167\ACK\177%\191\145\&4\247\139c\GS\188D1(\ETBv\237\196\128H\EM\244\207\NULT\213\\\200\210\131\229fM\188\154[\248\215Kh\218\222\v\vVY\ESC\205p\170\STX\177l\DC2z\147\197{\158\149\226\GS7R\SOHm5\v[\135\198v\197*\179~C\154\249\151Vh[U\186\251\&0an$e\136\&1\201\216\SO\ACK}\241F\153{&\155\169\218_DN\251yV@\DC4\224\156\FS\145\159~\149T\223\"\176\170{\242l\250\207%\151\173\&8\SO\228\254\NAK\204\232^!\131^\211b\189\179\145\154';H#\ENQH\234\167\222\183#\220W,\199\138\233F%\166`\163\229\174+\226k$\222\EOT\191Wp\184\&1\149\207r$\FS\DEL:\234\153\190\232\201\252\ENQq\191\DC2 i<\USs\180\144\NAK\149\136\207Q\207\245\197;\219PJ\250\RS\bz\210R\158\180\149\214#\208~\SI\255\NUL\200\223u\255\NUL^\SI\255\NUL\163#\162\143\131\223\242\&7\221\DEL\215\131\255\NUL\232\200\232\174*\223\EMkc\135\187\255\NUL\143\217\255\NUL\235\163\DEL:\233>\GS\220\189\191\141-\NAK&\138/9^\"d$+er\ETB \130\&2@\231\&5\205\221\255\NUL\199\237\199\253to\231Z^\NAK\186k?\NAKi\147\172\194\SYN[\133\RSaM\219rpN23\214\186\228\175\DC3>\167}\172XX\248{\196\240\235\SYN\144ZI\167\181\223\217o\DLE\167\238\149\153REm\163wB\231\161?\234\253\rmY\204t\239\CAN\SI\DC4\199w=\198\159\DC3\v\EM]\177\128q\186E\207%\149\DLEg$\231r\133\246\GS\ACK\165c\SI\137\147U\209n'\138y\174\236#\145$U\194y\136\205\135\a'\140\178\131\220\SOH\220b\188\251N\212\155R\240r\232\215\205x\151\&6\242K\DC3$\NUL\133g\EOT\179\EM29l\237a\243d\183\203\128\t\175\&1\155\163\232?1v\231\140u\205|\253\241\a^\240\255\NUL\139|R\"\210L\137{m\FS\138\215j>K\157\128\182\193\142s\193\195t9\199L\SUB\179\168x\250\250\247\225\195h\214!\DEL\180!\181a}(o\150+`B\140\DC3\252L\EMW\a\156\238\207\&8\175 \DC2H\140$F*\192\240E'\174\129\ETBgss\197\246\214\246\186\149\164v\237\&3\171X\195)i\155,\197\198\239R\a\EOTp=+\SUB\206\238[\v\200.\237\156\164\246\242\t#q\217\129\200\169o\238\205\208\180\220\th\173\214\DC2O}\164\129\250`~\NAKMrN\ENQ$\134\221\221\206\135\199\RS!\RS'\241M\198\166\153\DC1<q\172hO\221\SOH\ACKG\183\&9\166xsX\251\EOT\150\200G\250\155\232\174\149\191\187\140\169\252\242\191\149`\200\184\&9\197#+#\NAKa\130(b\DLE\146\196\146rOZA\214\138Q\193\160\SO\159\192\186\229\206\143\226\139T\142W\SYN\247R,3F\SOCn\224\FSz\130A\175\160\244\251\145\&5\156r1,J\141\195\142\189\250W\204\218&\161\SYN\145\174\218j\DC2\219\139\132\183\144I\229\SYN\219\146:s\236p\DEL\n\244\b\254+\201\246\&7\DLEi\240!Rv\172\179\DC2NI\232\STX\227\245\173!+n&\174{\ETX\\\ETX\194\131\143\202\185\207\ETB<r\248v\246\ACKa\189\144\&2\131\236\194\188\217\254)\235\ESC\155\202KO\155\CANS\EM!\SO;r\t\252k\SIP\241n\175\169\222\v\185d\140K\229\&4#d`\r\141\213y\a\235\214\170U\DC3VA\CAN\180\204\ACK\CAN8\244\226\155NrK\177l\228\156\156\211k\208\139\186\185\153\232?\a\191\228o\186\255\NUL\175\a\255\NUL\209\145\209G\193\239\249\ESC\238\191\235\193\255\NUL\244dtW\GSo\140\165\177\195\221\255\NUL\199\237\199\253to\231Q\199#\195*K\EM*\232\193\149\135b:\SUB\146\239\254?n?\235\163\DEL:\128\215gC3\208c\248\145\170Awiw&\163\167\207r\177\148iV\213\221\246\144\SO\214\229s\130\163\CAN8\228\154]B]sI\241\175\153\SYN\164-f\214\DLE\EMe\130\216\196\142\196n\194o\245$|\217\FS\177\233\205q\214\243\249h\166\r&\217\176\171\151\157\153\247\&0 \231\EM\ETX\a\EOTc\GS\207\182\SYN\235P\191\212t\203{K\203\210\233\a\250\180|\GS\160g\FS\158{\145\143Lzq\229\&6n\145V\230O%e\242\167}\247E\188\248\246\NUL\STX\134\ENQFry\200\201\ETX\167\FS\158k??&3Wn\129\142\r\134w|\182\237\187\178\&3\207'\212\245\252\234\156%\EOT\209\153\DC1\157\&7\r\202\167\EOT\143L\210\184\236Y\180\211\174\245\ESC\149\138\210\t%f!~E$\SI\174+n\255\NUL\193\247\250v\158\247)43\180i\230O\DC2\134W\141s\130\192\&0\EMQ\145\146?\144$z\158\151{i\164\232\203n\145Z[\128\165\228Hx\nzc'\150 \144\185'$\254C\205\252a\226\t\229\241\ENQ\208\179\157\226\242\DC3\200,\141\130A\200q\199Q\243c\240\174x\213\148\231d\180:'F0\133\222\231\RSO\207\156du\197[\185\149o\160\&3\136\150\&9\162\192p\131\130\167\191\231\199\227T\149\138\176`pEJ\210\135\150V\t\176H>\234\158\a\DEL\230+\160\230\EM\DC4O4\171\FSjY\216\128\ENQz\190\169\226\b|)\225{\ESC+;D\186\134E1\188\&7p\161\nq\215\140\228\228\231\154\243}\DLE\DC1\170+\132\222cR\222\195\ETX\147\248\f\214\135\137\181?\183Ek\SYN\224\fe\139 9\228\227\a\250~\NAK\148\238\230\151C\162\n*\147\151S\158\235\147J\156H\167\208\230\144t5\175\160\173\155I?\218\227V\SOHA\ENQ\142\NUL\245\254\149\174\231:+\137\144\147\148\219G\154\NUL\US1\235\210\186E\210\244\187\165\DC2C\STX\DC4n\132H\216\254u\NAK\198\133l\NUL\251=\177$\245\204\132\129O\144\173Nm\219s\177\RS\189\134)\184\171W\214\141i>\198\143`a\144\t\205V\175N\151\192\140\RS\231\160|\RS\255\NUL\145\190\235\254\188\US\255\NULFGE\US\a\191\228p\186\255\NUL\175\a\255\NUL\209\145\209\\\213\190\&2\150\199\DC1w\255\NUL\US\179\255\NUL\215F\254u\a\235S\221\255\NUL\199\236\255\NUL\245\209\191\153\168+\179\161\145\&5\186\239\&8\146GX\253Uwc\240\200\161\166H\212g\EOT\250\n\170\236G\202\ESC\142\181\t\206\a5\229\212V\155F\233\232u\158\FS\240\216\241E\189\252\222q\132\219\168X\212\SI\188\196\RS\190\220\SI\206\185ic\150\214\225\162\145\nK\DC3\DLE\192\246\"\187\SI\EOTk)\167\197qo\230\170I#\228\229\DEL\135\CAN\235\\\230\167'\219.\EOT\165Y'\ETXd\217\FS\DC2\188\STX>\162\185\227):\141=\142\137\194*\156d\183-\203\226I\229\130\&0P\151\SO\142\229\142C\EOT\251\163\233\184\177?Z\199Y\SUBI%gbY\193,Os\215\250R?\FSz\n!\EOT\202\160\STXrpq\239\197h\162\150\198R\156\165\184\195\140\241@4v\197(Fa\144\164\143Zd\134z\224\145\154CW\237\172m\140\182\226\238\229\162\138C\150t]\216\EM\231\RS\254\212\237Z-\RS\ETB\t\165Oy>\SI/q\SUB\160#\216\STXi\216\f\224\&84)\218\192\142\163\154\&7q\138s(L\DLE\234\217\235\142\212\128\191\167\234\210Yy\138\168\172\174w\DLEI\235\237[']\141QX8\EOT\140\227\191\233\\\165)%\143\169\233T\164\208\238kj:\144\212%B\t;\SOH\228\128:\213\SUBjD\234rP\168\198\&9\167b\187\232;\192\202[\158\131\240{\254F\251\175\250\240\DEL\253\EM\GS\DC4|\RS\255\NUL\145\190\235\254\188\US\255\NULFGEa[\227\SUB\216\226.\255\NUL\227\246\DEL\250\232\223\206\171\212\247\159\241\251?\253to\231PWa\153\FS\152\a\159Jj`\186\159|\211\228\232\r\b\bP\199\185\226\188\250\234\213\EM\172v$\222\NAK\178\&2\b\233\138k6\227\206Ny$\210I\145\158\189{\210\SO\n\228u\253k\DC2\136\155\EOT\154\158\201!iX\207+F\170\164\128\169\184\177\244\234?:\137\241\185\202\143\151'\EM\244\171\&6\t\ETX\197r\211L\209\178\160\&1\168\\\239l\244\255\NUL\245P\ACK\244\SYNz\ETX\200\144Cm{uq+\252\172fX\212\SI\247U\\\245\247\252*\206\173\165\207\164\163(\211lDK\181ZX\166iJg\215\247\135\EM\200\236:\214V\138ck\233\227\146\EM\GS\SUB&\EOT\194\187\153z6@=G\203\131\142pMv\SUB\246\187\163x\130\210\218\ESC}6;&\129v\180\168\164nE\US*\243\140\146q\207nO\177E\238q\154v\147%\225y\131\vxw\236\&9\206\ETX\SO\163<\227\175\DELZ\213\185\240\141\188V^{\\\US\151,\236\147$\128\SI\247Tq\248\154v\149s\243I\230N\208\204\197\140\136\179J\128\229\137\251\177'N{\159\196T\154\204\&1\\C\134\141\149\246\252\174\208JA\255\NUL\129O&\DEL\DLE*y\157\236>Uc\139h\176\206\ETX\f.z\144\&2(Y\EMS`<\RS\216\171F3\FS\165\SOHV%?\229\155\161\207\253\242\SI\248\213i\224kyLo\144\216\a\149#\US\152\ACK\172\204\208\183\183H\224>}\148\171(\195e\200U#\254\ENQS\179\168\148\136\163\129X\156\254\236\239$}\DC3*i\144 hA\ACK\NAK\ENQ\NUL\230\&4\a>\191\196\DEL\RS\ri\197\164]_F\RS(\238&L\f\225Y\192?\136U\239\232\DEL\SUB,\202\&1\166\207\150T\177$s\142\ACK:\DEL\b\206?\DC2*\181v\163\193\218\137\210\174g6\233\fI\vI\151\147q\224\DC3\192\\(?\134k\138\&5\221\134\210-\EMOs\208>\SI\DEL\200\225u\255\NUL^\SI\255\NUL\163#\162\147\224\247\252\141\247_\245\224\255\NUL\250\&2:+:\223\CAN-\142&\240\DEL\166O\255\NUL]\ESC\249\154\175V.\255\NUL\227\246\DEL\250\232\223\206\171\154\237\232f1\193\199\RS\181\"g*\160\STXq\142\184\&4\199\US)\164\218\&8;\129\174\fJ\247\238k\r\135\&2\229OL}j<\156\175\248\208p\SOH\164\229\221@\252+\156\161vr\ETX\146\170y\221\140\212\246\DC1\249\151&2\CAN\238S\128\&1\130}\242@\197Ip\205,\DC1#2\254\229\&6 \ETX\FSd\159\199\146jm\FSi\240\221$\218\141\204\177\194\&2\nA\RS\249\SI\211\&8P=\243\248P3r\198\221m\237\156yvq\220;\134\DC3\188\178\&3\168\GS\NAKB\r\191\\\159N\149nKioJ\229\174ga\192\DLE[\164G\143\246\190r~\167\154?\225\&3\240\253\152\219\167\248zk\135\FS\t/.:\255\NUL\192\DC4c\245\169.<q\227\v\200\214;+X\244\248[\238,P\ENQ\233\232_?\165+w*\235\160\248<#\170\204J\165\155F\SO[\ETB\DC39c\199\247A\250\DEL\rU\212|/s\167E\186Y,#\NUL`\171\DC4\133\135\253\246\ETX\SUB\193\212ou\169\239^\rWT\187\149\148n?\191.\ACKFF2\216\239Y\198\222 pI,{\239\EOT\ETX\255\NUL\SOH\a#\233N\232F\138\173\140WH\215\243\239\132\&6$[i\131\&9\RS\199\145U\181\198\210\159PC\164=\195[yc&\224\NUL\219\185\207N\221*\172\214\229W\"&^N~S\211\183Z\129\183\r\185\NULq\199\CAN\160L\236<;\227;\US\SIX\136\147D\142\246\232\224\249\179m\ESCx\232\&0\164\159\196\211\239\254#k\ETBc)iml\b\192e\f\SO=3\145\159\198\185\CANFc \206\145\174\DEL\137\143\242\NUL\210\179@\SO|\198c\254\202c\245<\211\187\STX\222\161\172j\154\170\159\182^K\"\SO\145\131\181\a\224\&0*\175j\132\203\206Uq\232O&\164C\148\EOT\215N\NAK\234\209\DC3=\v\224\247\252\142\ETB_\245\224\255\NUL\250\&2:(\248=\255\NUL#}\215\253x?\254\140\142\138u\190\&1-\142\RS\243\254?g\255\NUL\174\141\252\234\ETXS\221\255\NUL\199\236\255\NUL\245\209\191\157Bk\175\161\152\210\&2\b\164n\b\227\181:\151\a\NUL\146:W.%l\203\129\t\232x\162\&7\242\220\&6\222qR\DC1\199o\194\147i,\rs*s{\"\238\134<\165\179\145\248V\254\141k\163\157\RS{\219\248\228\154u\151\203\142\&5l\SI\187\156\158G\249\250\214\RS\193\207\ETX\158\158\213~\199P6V\179[\152\"\153$u\DEL\159vT\174z`\143Z\181Bo\160s\163C\237\169\DC4\143\DC4\DC1\249\&1\SYN8\242\240\164\SO\&H\ENQ\148\STXz\250\250zUH\229\151k2\202c,\187Y\129\219\184g\185\235\218\162\184\212\167\184U\ESCb\136\ENQ \152\163\n['9>\167\222\168\149Rry\250\156\213}VB\246\136\179\169]b\248I\EOT\170\231\203Uf\ETXp\200\RS\245]\181\ESC\247\ENQ~\213\&0S\213U\136\a\240\NAK\180\SI\134\196Q\254\226\251x+\230r\184a\143\155\RS\156\242\&3\154I\US\195\230{s\FSW\190H\148\EM\195\DC1\184\166\ACKB\243\193\206\238\190\222\245\154\131{\197\253\223\240F\229\230s\237\231Hr\229\216\255\NUL\180sI\229\&6zWJ$\240\201E\221\ACK\162\ESCjn\n\203\128\217\249\241\158\216\198\&3PF\250\b\146\DEL6\ESC\210\133\191u\181\134@\216z\251\238\219\248f\169F6\248e\248\n\254f\ETB\148\222\162\148C\254\213o\143\248G\222\247\229\131Pko(|\168W~\252\140\159\166\&3\252\253\170o\179\232\133\248\176\213\136*F\STX\143\189\187\131\238\&1\129\142\185\238j\185\169\199x?\235\230\SUB\247\&9\177\DC2\251\211\192\NUL`t\174\132C\161H\147\ENQ\180\213\SOH\b\219\\(;N\DC4\STXG\166w\255\NUL\227\190\244\217`\208\213f+m\170 \DC1\DC2\165\208|\142H\219\187\253\156q\234z\251U\198\188\SYN\208k\250\245\ETB+\238t_\a\191\228o\186\255\NUL\175\a\255\NUL\209\145\209G\193\239\249\ESC\238\191\235\193\255\NUL\244dtR\173\241\130\216\154\227\225\ETB\136d\185\149\214\239L\195\&9#2\201\235\254\229D~\SI\248\139\254~\244\191\251\251'\255\NUL\DC1E\NAK\170\156\137\178\SI\248S\254\"\255\NUL\159\189/\254\254\201\255\NUL\196Q\255\NUL\n\DEL\196_\243\247\165\255\NUL\223\217?\248\138(\167\207 \178\SOH\240\DEL\196_\243\247\165\255\NUL\223\217?\248\138?\225O\248\139\254~\244\191\251\251'\255\NUL\DC1E\DC4s\200,\131\254\DC4\255\NUL\136\DEL\231\239K\255\NUL\191\178\DEL\241\DC4\DEL\194\159\241\SI\252\253\233\DEL\247\246O\254\"\138(\231\144Y\a\252)\255\NUL\DLE\255\NUL\207\222\151\255\NUL\DELd\255\NUL\226)\DEL\225Px\135\254~\244\191\251\251'\255\NUL\DC1E\DC4s\200,\131\254\NAK\a\136\DEL\231\239K\255\NUL\191\178\DEL\241\DC4\159\240\167\252E\255\NUL?z_\253\253\147\255\NUL\136\162\138\&9\228\SYNA\255\NUL\n\DEL\196_\243\247\165\255\NUL\223\217?\248\138O\248S\222\"\255\NUL\159\205/\254\254\201\255\NUL\196QE\FS\242\v\SOO\132\158%\136\159.\255\NULML\140\GS\179\200\&2:\255\NULs\218\164_\133~+F\ENQuK\NULT`b\230^\a_\238QECw\220b\159\133\158,''T\177$\r\185\&72\244\244\251\157)\167\225O\138Lm\EM\212\180\242\141\128\202n%\193\199\182\202(\160\SO\167\225\207\195\173c@\241\DC4\247WW\SYN\SO\143h\209\129\DC4\142NK\161\238\131\208\209E\NAK\148\219oR\145\255\217"
cooked_blues_brothers =  FreeForm "blues-brothers.jpg" "image/jpeg" raw_blues_brothers

raw_chaka_khan = "\255\216\255\224\NUL\DLEJFIF\NUL\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\255\219\NULC\NUL\b\ACK\ACK\a\ACK\ENQ\b\a\a\a\t\t\b\n\f\DC4\r\f\v\v\f\EM\DC2\DC3\SI\DC4\GS\SUB\US\RS\GS\SUB\FS\FS $.' \",#\FS\FS(7),01444\US'9=82<.342\255\219\NULC\SOH\t\t\t\f\v\f\CAN\r\r\CAN2!\FS!22222222222222222222222222222222222222222222222222\255\192\NUL\DC1\b\NUL\150\NUL\150\ETX\SOH\"\NUL\STX\DC1\SOH\ETX\DC1\SOH\255\196\NUL\US\NUL\NUL\SOH\ENQ\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DLE\NUL\STX\SOH\ETX\ETX\STX\EOT\ETX\ENQ\ENQ\EOT\EOT\NUL\NUL\SOH}\SOH\STX\ETX\NUL\EOT\DC1\ENQ\DC2!1A\ACK\DC3Qa\a\"q\DC42\129\145\161\b#B\177\193\NAKR\209\240$3br\130\t\n\SYN\ETB\CAN\EM\SUB%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\225\226\227\228\229\230\231\232\233\234\241\242\243\244\245\246\247\248\249\250\255\196\NUL\US\SOH\NUL\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DC1\NUL\STX\SOH\STX\EOT\EOT\ETX\EOT\a\ENQ\EOT\EOT\NUL\SOH\STXw\NUL\SOH\STX\ETX\DC1\EOT\ENQ!1\ACK\DC2AQ\aaq\DC3\"2\129\b\DC4B\145\161\177\193\t#3R\240\NAKbr\209\n\SYN$4\225%\241\ETB\CAN\EM\SUB&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\130\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\226\227\228\229\230\231\232\233\234\242\243\244\245\246\247\248\249\250\255\218\NUL\f\ETX\SOH\NUL\STX\DC1\ETX\DC1\NUL?\NUL\241+\219\235\175\183\220\129u0\196\172?\214\&7\169\168\ENQ\245\222\&9\186\159\254\254\SUBK\238\&5\ESC\142\DEL\229\171\DEL3P\SOH\198})\SYNY\ETB\183aI7s\255\NUL\223\211\254\&4\141}w\156\253\174ny\226B*\ETX\150\193\ETX\DC4\226\DC4\227\167L\227=h\STXS}w\129\254\149>\DEL\235\161\163\237\215y\226\234\DEL\251\248j\191C\199\"\156\DC4\224\DC2\220v\160\v\r}u\144\ENQ\204\255\NUL\247\241\169\ENQ\237\222q\246\185\191\239\225\168\194\133c\185\129>\222\191\133\f\203\230n@@\245\164\ENQ\134\188\185U\255\NUL\143\201\143\167\239\SI\248\210}\186\232\129\254\149>}\164\&5\\\SOH\229\228\147\156\244\160`\244 c\165\&1\150\224\151Q\159\DEL\149%\212\133\DC4\179\EOTf8\ETX\169\166\181\237\224\&9\251D\224\RS\254a\173\205\SOH\156\248\DELT\DLEJ#\185\DC3\192w\RS\162=\147\135'\253\158T\US\168\172\169Q[O\129\182\242J\128}\137jM\151\bs_\200\136^\221\187\FSO9=N$<\SI\206\147\237\183D\144.\166\227\254\154\SUB\182\176 \213\f@pb<v<\DEL\141VKq\246)\229*7\131\242\227\168\228\DEL\141.cGBK\241\252\tm\142\169v\204\182\191l\156\130\&2\176\238b2@\GS=I\ETX\234j?\182]!;\174'<\224\157\237\214\186_\SOHA\231E\175B\155\133\196\150\";b?\231\177\145\STX\SI\197\176\a\185\a\181s\145\162\190\155\&1e\251\173\145\236r?\198\155v3\132y\155Df\250\224\168\197\204\217\255\NUL\174\134\148^\221\FS\DEL\164\205\156\255\NUL\207CR\253\157\ENQ\197\162\148\CANp7\142pzT\DC3\160I\216\SOH\133\EOTp\aN)\\\169\210qW~\135\161|\US\186\158O\ETB\221\171\207#\SOHb\252\&3\146?\214GEE\240t\SOH\227+\175\251\a\191\DEL\250i\GS\DC4\204\EM\231\151\184\&7\215=\207\154\199\245\&5_9\200\FS\212\247\231\&7\247?\245\213\255\NUL\153\168\ETB\EM\228\254B\152\197\&9\192\244\237RG\f\142~P\t\233\212\SO\162\157\DC2&\ESC~\t\ETX\128=k\187\240\&6\137\166\248\138\194k9\173\216\221\156\136\200}\170\231*9'8o\152c\141\190\188\156\132\217Q\139n\200\243\214\245\167 \249\138\158\191Z\232\188K\225\193\162^\b\EM\228l\198$Wp>e<\SO3\193\GS\n\243\130\rg\233\154K\234z\149\157\140M\151\184\144 \218\164\227=N;\247\252\168\184Y\222\197\203_\bkW\218l\154\141\189\140\237d\152&U\140\156\241\158?\f\159\242+\RSX\204`duP\220\RS\198\190\144\154Y,\173u++\DC3\178\218\210\DC3\f!y\196\144\130C/\171\EMw/\251@.}\241u_\130\182/\173\&8\135_\130\202\EM\CAN\180v\237k\191\203\221\206\221\219\134q\158\t\246\169rQ\214L\183M\171y\234x0\EM!N\a\167j@>c\147\249\215\170\248\171\225S\232\140\150vW\173\168^\136\SUB\229\224\138\223\203gL\252\197\ACKHm\184\251\160\231\144zW\151\&4Ad\216\234\203\143\188\b\193\170\185\152\223\152\SO\EM\190a\130\a\EM\RS\244\244\SO\196\"\130x\233O\137\226G\ESC\193d\GS\186f\186;O\SYNC\167!\SYNz5\134\224\tYf\143{\DEL\227\196\174\DEL\n\137\202K\225W*)ufM\150\143\171_\144\246v7S`\FS\152\162g\198\&9\236\&1Z\201\224\US\NAK\205\a\152\154-\208B3\243aO\228N\DEL\198\175\159\USj\215j\203w\171\\y8 Cf\EOT_\168\FSt\RS\189OJ\150\207\198\183\182\146\253\166\209n\139\DLEq\246\139\242r;\157\167\142\222\149\203\&9\226W\195\NAK\253}\199DaM\239+\CANR\248W\196Zj\180\146\233\151\241(\US{\203`29\234?\207\229X\206\179\141\193\201\RS\160\183\&5\233\176|X\212!\157E\202\NAK\NUL`\240\167\US\167?\165[\187\241V\141\226\181H\167\211t\251\153\199\202\EOT\155\161\144\159\246_\158z|\184\&5\v\DC3^?\196\167\167\151\245\250\151\245x\191\130W\254\188\236y\SO\231\227\f\220t\246\167e\203|\196\146O_Z\220\215t\219{i\132v\182\243\194\196\228\199>\tS\207\SOH\135\f:s\129\244\239X\219G\202G<Wt&\166\174\142i\194P|\178;\255\NUL\131\223\242\&7\220\250\253\129\243\199\253\&4\142\138>\SO`x\194\235\168\US`~?\237\164tU\EM3\207/Fu\ESC\145\146?z\249\199\214\181\188;\225\155\255\NUL\DC1\223\155[\CAN\240\DC3\153\166s\242B\190\164\255\NULJ\130+\ESC\141K]k\ESCT\221=\197\193\141\ETB\182Ku>\195\GSk\190\215\245\187\US\b\232k\225\253\DC4\239\147n\233g#\RSc\255\NUL|\250\244\224};\SOyq5\167\SYN\169\210W\147\252<\217\189\SUBJW\148\180H\228\&5\221+M\208\228\184\183[\145wv\220&\206\NAK\ACKyc\211\147\253\222\217\234x'\164\248lI\136\200\160\169\142G\140:\245\201\SOH\198G\210\&3\143\199\174x\225\134\159}s\EOT\218\143\151+@\143\137g=\ETX\USs\212\215\DEL\240\220\SYN\211\167\&8U\219v\131\133\EM\199\217\174\DEL\194\182\130\180l\221\217T\228\189\170iYi\249\150>,i\217{k\176Y_\237\DC2\198x8 \133\152\159o\245\199\143oz\205\248k\ETX\GSf\239\\,\n\216D\242F\132ct\185P\131\166\NUL.\200?\USj\232\190()\255\NUL\132u\134]\202\220\195\&8}\131\n\SUB\US,\STXz\242\"\250q\244\166\248\DC3H\146\223\195\218|J\FS=\244\166\234D-\144B\DC2\169\199`X\231\215\&0\213\130\167z\156\167\161h\154t\DEL\241+\182g\222\&7\253\166VnI\134\f`\159s/\149\232N\210j\GSB\236\223_Kp\224\252\204H\a\176\237W\227o+L\213oP\240\242\174\157n}c\132\144\236\&9\239!\151\242\NAK\153km%\220\203\fx\201\228\147\192P:\146{\fW\147\152\212nJ\156N\236-\164\229U\237\211\209\DC3\\\207\SO\171\167\165\142\162\179\&8\137\252\203k\152d\219=\188\131\163#\255\NUL\143\a\165rz\223\132\174\181\&5\SIyo\166\235l\DC4\132\185Y>\193w\219\239\140\CAN\220\140z\138\233\"\190\147\207\DC3\233\141\139e&(eh\129\&7.\192\225\176z \ESC\155\220.\227\158\ENQs\158\&4\241\164>\FS\153\172t\248\227\185\213_\156?)m\159\186Xwn\225zt\207\165iK\235\&4\249a\187\DEL\129\141h\209m\202\214\253~G=u\240\177\215l\137\164\235\209\171\128S\230\180\145s\142\205\230\140\244=\133b\222x#\251>\196\220\222n\179\133\221\210\ETB\188\187\137\v\148m\173\133M\236H9\RS\131\214\185\205V\242\254\250c}\169_Ksr\199;\164|\159\195\208{\SO\149\233\154/\135\228\241\207\130\DC3P\185\142{\163\DC4\174\178Il\ETX\220B\231\ENQ\156)\199\152\141\212\174w\ACK,Fwb\189IA\199G\185\192\153\192\v\GS.\206I\b\188{\199\198\213KK~\t\207$3\243\142\a;{\215c\166iZ\148\186l\150\241\220i\154\DC4\DC3\168\f\177\194g\184u=\158C\156z\224\DLE;`W-\168\248:\246\222\237\150\194\242\218\240d\159\146\224G \231\248\163}\174\SO}\171:\219F\215\164lAk~\219\&8\STX%f\NUL\158\220V\NAKc9+BV~\134\180\220\DC3\247\149\215\169\214\220|5y\b6\154\245\133\198\SOH\216\178\169\139=}x\FS\255\NUL?j\197\213|\ETX\226\r-|\199\178ya\US\242\218\f\184\199\252\a&\161\182Mv\v\146&\191[VbAk\155\161\242\227\174Te\143~\213\179g\227;\237\SYN`\209\234\&1^E\184\238kp\200=\190\240\ESC\184\a\170\215\&5\177P\217\169~\aG\251<\251\175\235\250\232c\217kKunt\221\\\239\139\CAN\138b>t?\215\252?*\196\242\226\r \222w\ETX\193\237\142\198\189I\226\240\239\142l%r\209\217_\145\184\222\198\&0\172\195\254z\167\245\US^\149\230\218\214\145}\161jR\216_FRE\227?\194\235\158\n\158\224\226\175\rV\DC2m%\202\250\162k\169\164\148\181]\US\145\217|\RSV\143\198WJ\199\159\236\247\252G\153\GS\DC4\159\ax\241\141\215?\243\SI\DEL\253\EM\GS\NAK\216qKs\v\195\247\223\217z\174\165z\145\249\183Xk{e\GSC\187u\US\240\GS\195\241\&5\209\\i\154\ETB\134\244\228\213<B\223n\214n\a\153\r\145b\ETB\159\226p?\135\131\129\198G\FS\231\ETX;\194\SYNv\171\168\234z\197\252e\173\172\f\143\207C\140\146>\167*\191\240#U\181\CANb\146\254MW\197R\\\189\245\201\243R\194\208\170\200\169\140\130\229\179\229\174\&1\133\193\&8\244\175>\167\191]\164\236\150\246\221\249zw;S\229\162\149\181z\255\NUL\193\&0umj\247Z\145^\229\192U\255\NULW\DC2.\200\226_EQ\192\NAK\216|5w\243\174\"\NUL|\210#\241\193\225\GS?\246\168\252\171?\196\222\DC2\182\208\167\181{Iexn\DLE\183\149)\249\215\228\223\131\244\a\a\220{\215]\240\247KE\146B\195\DC2\194\187\166\192'n\216\219~}\247<\v\245\a\142+\170\148\225('\r\140\185e\EM\251\219\232uZ\159\133n<acq\166@\241\197#\219[\200\140\204v\GS\146L\ESC8\238\SYN@~\184\167i\133m\ACK\161\169ZB\141\ENQ\156~M\138\NULHp\185H@\245\SI#\SYN\RS\161\197h\218]\219\165\147\163\195)\153\225\146\DLE\241\203\179\228b\164\140\245\ETX\228\FS\130:\159\173Ie\228\ESC4\133\246[\180w0\220+\CAN\242\132D\225\182`t\FSp@\192=\184\173\142\201\208\169\aRv\244\249\157=\206\157\165\232\190\SI\182\182\212\238\146(,\226U{\134\234\205\142O\187\&1\201\199RMp\247\";\216\165\&2\164\182\218\&2\149\221\v\f\203p[\160p8''\229\136u8\206O\vsP\150}oW\154\238\238\228}\154\220\ETBE\149vEm\CAN\asc\169\&8\206X\243\142\ACK\a\NAK\183\164hl\250t\154\197\205\187+\172.\218}\182\236\CAN\212\166\ETX\191\253\&5a\255\NUL|\131\180\DEL\DC11\236\224\231\207mNv\158\RS\SYN\155\213\244\237\234y\231\139<O\ETB\132vE\n\197?\136\230M\177\219\ACK\223\GS\138\146\&0\ESC\251\207\156\DC3\234Tg\133P|\146\242\232\197\&4\210\222L\211\222Lw\201+\156\177'\146\DEL2\DEL:\217\143\195:\217\189\223yi'\219\239\174^\218\212H1\186]\217rNF\NUL\235\159\175\210\179n|!\171&\181\&6\151\GS\177\213/L\139\229\220i\210\137\227\219\206\238\159\135R\184\199#\154\214\154\141?}n\206Y\201\207vs\211\220\180\231\GS\189=k\235\US\133>\FSo\nx2\218\218\245\194_]\226\226H\216\224\174\225\194\227\216\SI\231\\\150\139\224\251\141S\197px\131\196V\246PMj\170\150\154u\162\175\151\b^\133\200\CANf\201'\235\236\NUL\173\SI\CAN\221\202\218\227e\216\152\209@9\233\244\252\235\207\196\230*\SUB\199Vu\225p2\173.K\216\232>!j\150\&1\198\154t\235f\CANB\215w77\SYN\235\&1\182\128\DLE\185E`Avf\n\185\227\169=0~g\212\181h/\167\251-\157\165\189\141\163>\ACK\197\203\156\227\239\185\229\186g\211\158\NUL\224\SI[\214\196\218\206\159{\168^9\SYN\243\217Gaut\177\151\&02I\230F\238\a%\ESC%N:\NAK\EOT\215\143_h7v\146K\177>\211\EOTm\134\158\219\247\145\f\128q\188q\156\DLE}\171\170\157EV*kfa:N\140\220%\186;\157oD\211\252\&7\225\139-CM\211#\212Y\139%\221\205\202\153<\166\227\ETXh8PI<\243\219\158k\STX=W\195z\142\"\213\&4\211i!\ETX\ETBvR6W\167TbA\ETX\219\RS\213\171\225O\EM-\156\DC1\233\186\131D!d\n|\241\152\166Q\208>z\RS:\255\NUL*\217\185\240o\134u\161\230Y\201&\145;\143\224\"kv\252\249\US\158\&8\175\&1T\246O\151\DC1{\244j\231d\168\185\174j:\174\221Q\200\234Z>\163\225\ESC\251mB\SYN\142\234\202\224\ETX\ENQ\212@\249s\169\USt\142\199\GS\170\236\178\GS[\225\164\247WjL\182\ETB\226;Y\t\206\216\156\STXc\207\160$}8\STX\186;h\244/\rh\151\154'\136\245\248u+2\202\208\217A\f\155\163n\185W\207\NUL\250\SO3\158z\230\143\196\v(\162\240\238\158\218\DC2A\255\NUL\b\246\f\139\228\177\&9\148\156\SYN|\242OnO\US\202\163_\154q\140\183\190\146\217\&5\254}\f\\ekt]\n\191\bv\159\SUB]\237\251\191`\144\143\251\249\US\165\DC4\159\a\249\241\149\214F?\226^\227\255\NUL\"GEz\168\227\150\230\199\128\238\&4\209\161\248\130+\153\160\136\171\&2\200\215@yA\156\182\220\250\143\148q\237\\\213\141\182\135\163\204\218\150\171\DEL\ACK\175\168\SYN&+x>h\203g\134f8\221\143B\NUL\254Tx\162\221\&4\173\SYN\ESC[g\220\&5\ESC\185/\GSI\201UE\b\131\243w?\135\181q\130\240\194\210yaK\179gq\NUL\244\231\211\142}?Z\243\233a\249\220\234);I\157\149*r5\EM+\181\161\216\207\171\\\221\185\241&\177\177\149\247-\149\163\140\249\174\b\203\SO>\234\144\164\158\&7\DLE\DC4q\156zg\135\236\206\155\225\233\NAK\228\243.\174!\183i\228<\151y\ETX\204\217\207|I\CAN\207}\163\210\188n\202\210\243X\190\179\211\223\&2]\220\200\136\165\249,X\128\139\199@\DC4\231\241\198\&8\175p\184\185\182\150\255\NULQ\SYN\179,\145%\241\141Y9\SOHc\138(\192\USB\141]\176\140b\185b\180EaS\169\136\139~\164;\153X\NUL\223\129\171p\220J\144\242\161\163\193\192=0\DEL\151 \154\165\156\243\213\249\200\171\&6\136^TP2\165\192l\159\DEL\240\170G\189Q.[\179kS\211\RS\226\210T,b[\152\158)\FS\174v\231\161 u\193\FS\142\132\SIz\209\155\199\DC2[\145\ESC\232\178\\q\130\214\247\DC1\237\255\NUL\199\246\159\210\179\160\211\239Z\238\198\US\182\159\&2\241\137\133a\133wC\STXu\145\153\247\fr\163\238\228\150\GS9#u\252\EM\FS\136RMoUe\206\229\n\241G\183\156\240R0}\170\143\158\175R\147\157\167wo\145\143}\173\232\SUB\181\180I\169xr\241\163@\216Ra!w\253\239\187&y\231<t'\212\211\"\213\146\244\ESC\ESC1-\157\164k\242\198-\SUB(\148c\129\184\r\163\243\235Uu\219f\209`i\160k\215(p\203&\161\&9\250tq\252\171\155\178\213\DC3Q\144y\144\151h\206T\203\&4\147l>\171\189\155\a\220W\157^\181:\145k_\200\218\141\ESC{\208_~\191\161\221il\138\178s\146;\251W\v\226\v\193\DEL\172O*\224\174\237\170Gp8\173\167\158F\180\153\"b\EM\198\&9\239\237\\\196\182\239\FS\172\GSY\EM{\RS3^%Ii\202{x:IM\212oS\173\240\155\220i^\SYN\241\ACK\179\STX+I\f\SO\200\173\209\138!o\231^7\226;\139\157\RS\234\222\GS&\DC3\CAN\138\198\t.n-\195\198e\150D\222\210\&6\210?\231\167\EM\236\a\210\189\183\195z\133\181\142\141\DEL\NAK\234\143\177%\156\146\204\b\200*\SOH-\199|\130k\203\174\225\190\213\252'.\141p\143\253\191o\SUB\136\160\f\132Ok\CAN?*\NAK\US<\138B\238\US{\228\192\198\b\175{\ETX\252\EOT\145\224c\155\150&R}N\"\243\196\210j\DC1D.%\159\206\128~\233\223k\ETX\199F\249r\217\233\206z\156\214\212V\146\190\140\186\247\134\165\146\&8\225`o\172a%\140\r\253\229S\157\200y\235\208pz\DC3\\\165\150\158og1\163\194\173\252+4\171\RS\238\131\NUL\177\RS\181\163\166j\SUB\191\131\&5\193p\145I\EOT\202\&6\201\f\200B\200\135\168#\184=s\248\214\181\163u\238o\219\185\132$\226\238g\223\234\ETBW\179y\151\ETB->>\238\254\128\241\156/@?\n\236\188\ETX\170\199}k{\225\155\225\190;\160\210\219\231\180\128|\203\248\174\DEL\DC1\239Q\234\250\ACK\159\175\233\243x\139\195\CAN\DC1\133\243/t\242G\153nz\146\163\186\241\254\RS\131\144\179\184\154\194\246+\203Fd\154\221\132\136\223\221 \241\253+9(b)8\173\SUB\252\EMq\148\161>{\220\244O\134\SYNf\195\199\218\133\171\ETX\251\187\&9\ETB>\191\188\143\a\241\FS\254\&4V\239\132\214'\248\145\&5\228\NULy\ETBZQ\149?\239\226\SI\228\ENQ\NAK\209JnPM\238gZ*5\SUBG\159x\174\242Y\"\210\166\138B\DC4[\188\\\FSr\175\207\235\252\171\151\130\&4VYL^a_\155\r\156\US\175N8=\SOkv+\168\238\SUB]6\228\DC2\194\235\205\183\147\EM\216rA\EOTw\EOT\SOH]/\131|\EM\253\175\168\222o\150Y\226\134\&34f\212m\ETB,\184\220\168\237\242\134\231 \US\211\168\154~\234\229*\167\190\249\203\159\r|1<\215i\172\220}\168+,\203jb\ETX\204\145\246a\164RH\n\170[;\137\NUL\DLE\a$\226\187\136\228Y\237\161\133\173E\158\161\DC4`OnH\196\196(\RSdd\DC2\172\b^\128\228`\241\138\185\NAK\229\188:e\181\141\150\147\170\217\v\ENQ{v\200\183\149\246\182\214a$!\242\193\176\172\n\242q\242\156Vo\246\180bR\172\147\253\152\228\137\DC3O\184\t\158p\SUB6RS\161\NUL\130\195\175 \241Z\216\215\r>I\243^\221\187\DC2*0\145Tpx\STX\186\GS.\202+\177\FS;A\243$\222\\uU\CAN\221\147\237\156\DEL\158h\139\207\237&\136}\141\225@\219\153\254\207*dv 8\GS};\230\180d\182\150y\ETB\195\214\197\133\229\236{\175eC\131ij~\247n\GS\241\181G^\173\218\154G\161\138\197/gu\185\187\225u\ETB\255\NULi\215\217p/HKQ\217mP\145\RS?\222\201\DEL\248\CAN\GS\171\162\166C\DC4pB\144\194\139\FSQ\168TE\CAN\n\a\NUL\SOH\233O\170<\ETX#X\209F\166\140\191.\FSa\179\235\\d)\r\173\181\197\180\&0\161\129\129H\228W;\221\179\141\219q\192\244\&9\201\246\GSl\248\178M3J\213a\187\254\210\154\208\199 g\142)\CAN.\236\228\130\SOH\193\207\160\a\175=y\231\174o.u\DC3%\198\147`mm\166r~\209\&9o,\SYN\235\176\DC1\153\SI\160\ETX\234;\143\"\188`\228\249V\191\214\167\175\134\167S\145\&9?w\238\254\190F\178i2\146\219\174\173\161\NULd\172\146\NULTz\159N\157\235\&3P\140\&2C\137\SYNh\159-\DC4\170\&8`\t\EM\RS\163\143\198\170G7\135\244\149\"\230y\181+\247`\162K\237\173\EOT<\242\222X,2=\243V'\212.\245y\162\185\186\SOHO\148\bP0\STX\146J\140}\b\174IS\166\150\154\179\190\213S\191OK\SUBZ4\DC1]]\253\146\224\a\183\185F\130D=\209\148\169\US\145\175\&0\182\180\188\213\245\239\DLE\182\151a>\163-\149\193\243|\189\172\179`\149Y\130\134WW%\vn\140\158N0\SOH\174\231P\212\174t\173\&2I\236b\243\&5\v\134[K%\245\158O\149N;\227\150\255\NUL\128\214\138YX\248/\197^\DC3\184\177e\251$\177\157\n\237\241\203\185\249\209\143bK\131\207\189z8\r!\175Vy8\215\251\205:#\203\\.\165?\217\&5i\161X\247 \205\250\170K\US\251-0\143r\158?\141@\198y=ie\130\251I\181\251:-\190\189\161\162\EM\SUB\214{\171y$\133y\fc)#2\145\156\228\SO=+\219\254$i\218E\214\153i.\160\"Y\197\194F\172G-\v\US\223\ETX\223h\143{\251\NAK\a\168\NAK\226v?\f5\rbe\185\138H\236\236]\219\200k\150\196\210 \206\214\218\a\166:\227\185\233]\NAK\229J\DC1\253\235\208\231\166\156\182\&9\219D\185\183\185\155[\240\171\220C\r\171|\203#\163K\CAN8\200e\USy;n#\GS3\131\214\142\171\169>\173rnR\210\ESCy\EMv\188p\STX\NAK\143B@\237\252\187V\254\169\225\189W\192\250\148z\141\163\203'\149\203JS\FS\RS\be\201\202\156\245\232j\191\136\244\251E\180\179\215\&4\212\&0\233\250\138\146!V\200\130e\251\201\244\207Oc\237YS\169NRR\142\183\217\254\140\210P\148=\214u\159\f\238E\198\191fK\ACKd\209\228C\206q\182d\US\210\138\203\248A!>/\186\CAN\199\250\EOT\135\174\DEL\229\164tWTc\202\172\140jO\154W*xo\194\SUB\150\185\172\\:X\EM\173!\144\151\185\144\236\133Td\156\185\227\161\250\215\168\153\238\165\211\226\210\180\173F\b\252;\179\DC3J\214;!\157\179\204\&0\148*\206\135\144\207\233\129\184\228\213\223\178A\185b\214\238R\244+\150\SUBe\168\242\236\145\179\156\&8\251\210\182{\182FOJ\175yyq{0\251A?/\b\184\198\209\216\SIAOmN\220>\SOuZ\231\210?\137.\187s.\164\139+\233p\165\253\186yp\221i\215\&1\149)\253\201#\155\203\202{\ETX\145\206\b\172\203\t5)#\DEL\182\216-\166\226F\213\186I|\193\207%T\146\a\177\207^\166\167\ENQ\227q\180\224\131\199\GS\235P;i\250L\186\191\146g\145O\151i\ACK\DEL\214\206\196,h\ACKG\241\RSO`3Os\177\209XH\243);v%\178\138\246{\143\236\205\&5P\234(\160\207<\171\152\172\193<\SYN\US\199!\NUL\NAKL\251\156\fg\182\209\180[m\SYN\213\162\133\164\150i[\204\184\185\152\230I\223\187\&1\253\&08\ETX\NUL\NUL\ENQE\225\189\CANhZ\FS\SYNm!\150\224\230[\153\155\172\179\&7.\199\234I\252\&0;V\181R<Z\181eVNL\204\212\245\203m\RS\230\209/RH\173\238[\203\ETBd\SI*7\227j\185\207\203\187\177#\EM\227\&9#:u\NAK\205\180\ETB\182\178\218\221B\147A*\148\146\&7\\\171)\234\b\174V\ESCmc\193\238\177Z\164\250\190\129\187\v\b;\174\172\199\251$\159\222\198=>\240\GS7b\131#\v\198S\175\134\175>\209o\163\205u+.\228\188\150\&0\201\DC3\DC2s\131\130\SOH\201\233\129\201=s\\u\141\246\173{\r\205\202hms+\146\207wp[\202D\239\184\177\SOH\136\255\NULh\159LW\187Z]\193}j\151\&6\207\190'\232pA\244 \131\200 \240A\228S\174m\163\187\181\150\218Q\152\229R\140=\136\174)\224\211m\167\167c\213\163\153*t\212\\.\251\221\158\tc\165C5\223\219/\164[\185s\144\138\187b\207\175m\195\219\NUL}k\162H\222{\140a\153\220\242=Mu\241h6:|\134\DC1\SUB\151^\ETX0\201>\245\207k\145\193\CAN\159O\182\186\242\167o\150\238\228\&7\252y\198\221\DEL\237\171\SO\NAKz\140\238\&8\ETX\159\&7\217Jr\229\218\223\129\215S\ESC\207\171\215\177\149\164\168\191\212g\241\ETX\144\218~\158^\211L\a?\189\159\164\147\SI`2\171\248\158)\254\"\146\ESC\191\SOH_Z;\145y5\220\ETXO\199'\237;\178\184=\184\a$\244\EM\250T\179\\\219\188P[Y\194 \177\181A\NAK\188\v\209\DC4\DELS\235Y~ \f4\171+\208\199\236\218}\252s\221m\200+\DC3\ACK\140\184\199?.\240s\219\175j\222\156\211\196EGe\161\205R\155T$\229\187\212\227|W\227k\189CS\154;\169\ENQ\211\tDO)\ESC\ETX(\193(\139\159\145\ETX\SO\249-\212\158\ACK\219\158;i\245\DEL\SO\232\250\214\154\236\208Y\175\148\254Y9\140\156a\253\179\128\&3\216\224W\SOH\174\233\183Zv\165=\181\212\&2D\209\177\249\US'\143P{\131\199\225\138\208\240\191\139\174\188\&9$\145\176\251E\171\r\173\v\f\140\RS\163\a\168\246\255\NUL'\171\DC1FR\148j\195W\RS\157\206ZS\138N\156\180L\236|'\227%\212\157\&4\US\DC21\154\&9\DELu\ENQ\219\253\224O\ESC_\212\RS\156\254>\162\142\167\166>\151\225O\DC3i\179\171\164V\154\156\DC2Z\ETBB\SOH-\184\GS\185\FS\252\152?\128\&5X\235\254\ETB\243L\179\232N\193\155;\173.\nC'9\251\140\t\140\241\252'\215\181o|I\186\155Y\240\213\150\161\f\140\145[J\209]Zn\220#\144\143\149\179\198A\EM\193\255\NULht9\174\&5\USgYr\199\149K\DELU\174\158\187\ETB&\229\r\239c\US\224\251g\198\&7|s\246\a\235\255\NUL]#\162\147\224\247\252\142Wy\235\246\t:\DEL\215H\232\175a\FS/s\209X\144\236}\207\243\165/\191\EM\224\128\a\RS\212\226\160H\193\190nOC\239I\DC1T\149|\193\149\207 T\159^\158\132\182\236\158g\239\DC4\178\253k\162\177\180[\207\NAKi\186p\NUL\219\232\214\223m\185S\158ne\ENQc\207\184Q!\199\251KT\244\155[i\181T\n\ETXD\153v'\248T\DLEN}\177\237\214\175\252\&6\221\169Xj~(\153H\151[\188iP\DC2x\129?w\DLE\193\FSp\t\247\205R<L\206\183\&3PGmE\DC4U\RSHQE\DC4\NULUk\187YnB\249W\215\SYN\164u0\132\&9\250\239V\NAKf\138\NUL\228\252Icwe\163\207w\253\161\168\223:\128\171\ESCJ\176\170\228\227q0\170\&1\235\211\&5\229\158d\204\234\142\219V\"v\162\168T\\\245!G\FS\245'\191Z\247\201bI\225x\164P\200\227\f\SIq^-\226\ESC\a\176\212\166\143\251\142G\166Gc\\8\181$\215fzX\a\GSU\181\vw\220\188\FS\182;\246\173+\EM\"I\213nPIo'\238\230F\232\200x \214=\139\128\196n\228\255\NUL:\211\\2\253+\204i\197\232z-)+3\156\241v\129m\225\237F\207\195\186\170]\234:e\210\180\154]\229\178o\186\181U\198ba\255\NUL-\DC1F\b\238\a\229^\DELs\225\151a4\154t\241\\\192\172\DLEy2e\135\US\196\159xt\231*:\254^\231\227\EM\192\209<)\226<\229\180\173R\NAK\149\201\198\"\DEL\145\243\255\NUL\142\215[\169\248\DC3\194\218\197\203\220\223\232\150\147M'/&\205\164\158y\200\199<\245\235\211\210\189\216\181\&8\169.\167\132\219\131qg\201\131B\212\&0Ymf#\156\US-\176\216\244\227\154\239\&4%mCA\186\210%r\230x\f\n\196c\230\\\188-\207\251@\129\245\173\US\NAK\218xV\199\237\&3\216\195}m\162G#\193\228\219_\184\251|\128\225\216\ACK\220\162\&5#npw\RS:\SOH\156M\SI]\142\247S.\139*\236H\228A,\205\&3b3\146Ku\RS\152\NUL\NUL\ACK+\151\ETB\a*w[\163\171\f\211\151-\180c~\DLE\r\190\&4\188\a<X?\EOTc\254ZGEh\252\&9\180[O\137z\188\nx\142\222t\207\210X\197\NAK\215\ETBt\153\197%fw\t/\149\&2\201\212\171\150\EOT}zQp\177I1\242\155\128:\158(\136~\245\149\219lN\248r9\199=}\234\221\174\151\&5\237\250\219\163\134fm\190`\EM\RS\231\242\160\250\151(\199\222lv\182\243i\191\SO\239$\180P\218\134\173\"i\246\192\RS\166F\217\199\225\184\254\NAK\232\186e\132:V\151i\167\219\168Xm\162X\144\SOH\142\DC4b\184\143\DLE\203h<e\164Z\220.4\239\SIY\201\171]\DC4\\\128\216)\DLE\192\231?}\135\210\186o\248KtU\212n,e\190\138\EM\160\145a\DEL9\130\r\236\SOH\n3\212\144kE\SYN\246>^\181Oi7'\212\219\162\176&\241\166\131\DC4\SI:\223$\209#\"\151\139\230\\\190\240\ACK\238\159\192\221\248\197X\255\NUL\132\159Fx\229h5\b.\RS(\222S\DC4\SO\GS\202\175-\133\FS\154|\146\236etk\209X\214\222+\208\174\226\SI\RS\169l\185]\193^@\173\183\ENQ\129\193\231\ENQF\225\237\131[4\154kq\133\DC4QH\STX\184\159\RSi\STXh\163\212\DC13\180l\147\US\161\255\NUL>\213\219T\ETB\150\201yg-\188\159vE*}\171:\208\231\131\137\173\SUB\158\206jG\134\199\152\167\193\\c\165l\219\184\217\140rj[\223\SO\223C~\203\246y\t^2\160\156\251\143Z\213\178\240\198\165\"\ETX\228l\a\156?\203\197x\206\156\158\200\246\221X%v\202\186\149\186\234\223\r<G\166l\220\235j\247\DC1}S\230\US\170\143\206\173j\254'\159P\240&\133ie9\138\251[\179F\150p1\246x\STX\ETX<\190\216\a\ETX\220\140WG\164\248z[Fss\"\148\145\n4k\208\130\&1^)l\183Z\a\195\221_P\188}\211+\182\135\167\169#\STX\DC4\148\180\140\&99\203g\159a\218\189<2\148iZJ\199\147\136q\149V\226\244\&8\SI\DC1\234\171\168^\CAN\224\220- U\138\214\&3\252\DC1(\249F=q\215\212\228\212\222\SIp<Cn]KoY\DC4\224\245\249{\214##\DC1\200\NUL\RS\213\210x\SYN\209\238\252Qn\140\ESC\203\138)%l\142\156q\215\212\237\NAKU\151\238\228\188\152\232\187U\139\243G\161\232\SYN\159e\248\203\226\bFI\242\GS\249\ETX's\196\220\227\234?\194\138\217\211\237\ENQ\191\198\237iM\190Y\180\229bKc'\247\&9 zg?\149\NAKt\238\162\147\&1\150\172\234m<14:\163G;\197-\163\177\EOT\ACK!\176s\131\140c#>\181\208h\250[\217\200\205\&3#I\EM(\172\189\215\222\138+C\183\DC3Vr\142\175\162(h\186\b\184\186\241\NAK\246\171\FS36\171pb(\164\149\SYN\241\141\136\135 s\247\137\247j\212\184\240\230\143v\204\211\233\240\200\205\&8\184%\135Y\STX\133\207\228\NUL\199J(\170M\173\143\&5\161\144x_D\182\138\&8\161\211\161D\141\210E\ETX<2\SYN*z\246\220\216\250\212\214:\SO\149\166\188\207ga\f/0\196\140\171\203\SO\195>\131\&8\ETX\160\FS\n(\163\153\247\NAK\145U\252!\225\249\GS\GS\180\168\v\"\170\174s\192\v\180\SO\189\&6\128\SI\168\ETX9\192\173\186(\161\182\247\CANQE\DC4\128(\162\138\NUL0(\162\138\NUL\171\169<\241\233wojP\\\172.b/\157\161\246\156g\GS\179\138\242?\SUB|;\188\186\210\244=#M\154\221-l !\132\178\178\249\146\&1\203>\STX\158I\201\205\DC4T\200\210\158\231\EM\US\193\221o\230-s\167\DC1\131\143\223?^\199\253]zG\195\239\132\208xp\182\163\168\220-\197\228\169\181DY\216\169\144q\200\201\&9\ETX\158(\162\166\201\232\202ri]\GS\236\190\US\211\165\212\142\160!\242\238\217\n4\201\195\&2\146\&8'\211\129E\DC4V\134\&7?\255\217"
cooked_chaka_khan =  FreeForm "chaka-khan.jpg" "image/jpeg" raw_chaka_khan

raw_die_fantastischen_vier = "\255\216\255\224\NUL\DLEJFIF\NUL\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\255\219\NULC\NUL\b\ACK\ACK\a\ACK\ENQ\b\a\a\a\t\t\b\n\f\DC4\r\f\v\v\f\EM\DC2\DC3\SI\DC4\GS\SUB\US\RS\GS\SUB\FS\FS $.' \",#\FS\FS(7),01444\US'9=82<.342\255\219\NULC\SOH\t\t\t\f\v\f\CAN\r\r\CAN2!\FS!22222222222222222222222222222222222222222222222222\255\192\NUL\DC1\b\NUL\150\NUL\150\ETX\SOH\"\NUL\STX\DC1\SOH\ETX\DC1\SOH\255\196\NUL\US\NUL\NUL\SOH\ENQ\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DLE\NUL\STX\SOH\ETX\ETX\STX\EOT\ETX\ENQ\ENQ\EOT\EOT\NUL\NUL\SOH}\SOH\STX\ETX\NUL\EOT\DC1\ENQ\DC2!1A\ACK\DC3Qa\a\"q\DC42\129\145\161\b#B\177\193\NAKR\209\240$3br\130\t\n\SYN\ETB\CAN\EM\SUB%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\225\226\227\228\229\230\231\232\233\234\241\242\243\244\245\246\247\248\249\250\255\196\NUL\US\SOH\NUL\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DC1\NUL\STX\SOH\STX\EOT\EOT\ETX\EOT\a\ENQ\EOT\EOT\NUL\SOH\STXw\NUL\SOH\STX\ETX\DC1\EOT\ENQ!1\ACK\DC2AQ\aaq\DC3\"2\129\b\DC4B\145\161\177\193\t#3R\240\NAKbr\209\n\SYN$4\225%\241\ETB\CAN\EM\SUB&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\130\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\226\227\228\229\230\231\232\233\234\242\243\244\245\246\247\248\249\250\255\218\NUL\f\ETX\SOH\NUL\STX\DC1\ETX\DC1\NUL?\NUL\234e\210\172.\172\166\154ig\129\DELy*`\ETX\180\SO\167\EOT\227\158H\201\239\138\230\&4\155\137\225\141\244\185\175%ux\182.\233Yr\133\192\&8\CAN\SOHr[#\169\193\&9\233\138\221\150\218!,\SI\165\\2\249j\ENQ\204d\177\206z\r\175\201$\168;}\189\rR\184\138[9/\USUV\188,\ny\174v\172*Nr\163\158G\205\140r=9\174)I\222\200V*\232\246Z\173\130^\v\153eIs\229$\145I\230\EMpX\240\&9\218B\227'\GS\254\149z-6\241\237\227\214.\201\STXe#))Q7\204\&2I<\255\NUL\b\247\231\218\176\ENQ\236cPy\212'\146\248U,\205\146\188`\146\&00y\EM\231\CAN\168O\140\181-3\200\129\239f\146\221# \230P2\SI=\193\231\184'9\253)\198Z\220v=f\215]3\233\239,A\132@\254\233\165\&9,O`s\216\131\219<\214V\165\227\184\&4\169\"\142i\146\236\203\243\196\240\202P\243\217\151\ESC\176?\175|W\DC3i\230\234\SUB0\152\219\180\204\215A\198\STX\174\208\204\SI\206\SOH\194\174:w\CAN>\167\EM\SUB\173\213\157\180\229\157\136\185\137\EMd\142\&0\RS(d*v\133$\242\167'>\135\215\STX\181M\136\244\215\241\157\151\148\177\234\&73A\191\&1\249\177\&2\228\147\128H#\156s\199\GS\141q\ETB\250\237\228\209\CAN\236\230\&2\219\150\ENQd\242\215\205\192$\140\250\129\180\241\207 W)\170\222\192\205\FS\246R\199\230\178\SYN\242@\198\aF\201\227'\140\227\ETX\175z\199\254\211\242r\175\EM\145rB3t\207~;s\253hi\244\ETX\217,u(\228\240\130G\FS\177\180\174\&7\a\219\184\168\220\&0\185\227\145\156t\236{V\199\133\162\185\190\211g\181\187\190\158\v\216\176\SO\n\157\163\177\250\245\235\235^C\ETXK\246\EM\175-\154\&0\168\ACK\208\179\f\179t#\GSI\RS\128\SO1]O\132\245W\130\218Ig\157Z7\140\203,C\134`\164\130C\DELC\143\212f\"\154\149\216\153\236\154qso\182I\150F\FS\GS\160\142}y\246\199\GS\168\213\&5\ESC]#M\184\212/\167\DLE\218\219\161y\GS\187\n\198\179\197\137\182\158Y\157\f\176\134\192PW;Wv{\246\a?^\213\175\169\216\199\171\232\247\154{;\b\238\161x\GS\211\168\f\n\146\&3\223\154\221\&0F\GS\183\143\&4k\223\SI.\183d\183\215\&6\143+D\130\ESCWwfQ\184\252\163\167N3\142q\235O\185\241\166\149i\nK<z\146\ab\187N\159\&99\n\CAN\131\132=\152s\211\175\161\174~\211\225\214\167\167Z\195ak\172\223\DELgA\RS\200\225\254\209d\EOTn\221\202\172<s\232rzf\173C\224\b\145\&1uc\165\223\&3s#\222\137'w# \DC2\196\227\128\196}\220\227\189\&0\208\232.u\251[x!\153\206\EOT\227t1\188\177\194\236\&1\146v\202\200F\SOH\228u\NAKY\252Si\DC4BIm\239\130\FSa\146\US4`\244\&9\140\176\193\245\170K\224M)m\230O\236{\DC4\146]\249\149frP\176*JoV\193\193<t\245\174j\207\225U\236\STXCq\172Z<\171l\209\194\241i\232\132\202w\ENQ\150N~b\170\229@\CAN\232=\242\197duqx\191I\185\149\226\133\175$x\216\171\133\179\152\236#\168'n\a\227Z+vg\n\203\NAK\192C\209\138\DLE+\137\190\248ist\STX\v\189\&1c\242\NAKX\174\156\129\222\\(\146F~I\220W\160\199oC\153l~\CANC\ACK\183\NAK\228\183\163\236\209-\187\165\188\bP\137b\239\184\146B\146X\149\CAN\206G<P\SYNG{a\159\180\159\247\SI\243\DC4T\150J\SYN\225\191\221?\204QL\DC1\229\SUB\222\187\DC4\186\162\195i\GS\156\247\RSa\255\NULK\141Y\STX\240\b\n\196\156\227'=\134=zE$\179\172\&3\t\153Y\247\SI/n\231\224\DLEJ\142\164\241\142s\223\174zc\216\222\181\148\r\FSwK%\203\200\215\DC2D\241\&1\219\252Gw\240\176#\161\198\&8\199~=\ETXKw\142\&33Y\219\177fh\227y\148\174\248\250\174\210O\\\156c\143\195\&5\195(\221\234hy\214\168nB\v\232\f\162\EOT\US.\223\188\DC4\FS\DC1\200\246\a\218\177f\"(\173\174\SUBi\150V\a(\237\182E\195\NAK\218\&1\200\CAN\192\200\227\175Lq\215\223\223\216K\NAK\197\130\195\134P\208\204\NAK9g$\SIq\242\227#\142\&0z\215\EM\168\218[\195=\219Y\175\154\136]\247)\222\209\NUL@\195\DC1\208\156\156\131\250S\138\210\224t\218\SYN\166|3\225\197\150\214\EMdg\NUL\206\146\f*9b\DC4\142\&3\200\192\227\131\131\211\CAN\174cW\187\138\234\254W\154\&0\145JJ'\206BBHRH\FS\244\238\&9\239\138}\157\229\213\221\186\DC4\138\&4x\215\204\192`\204\192\FSc\159\148c\GS\193\&8\246\170\203\165\219\&6\177\GS\189\252\179El\255\NUL1y~\249'\185\207\CAN\247\RS\231\NAK\180_qX\167om>\DC2Tu\148\178\200\fa\138\249cgV\232\&0rF3\245\199v}\158)\195eT\206\\\130\136\SOW\144:t\238x\199\CAN\FS\246\173\169\151P\240\227\192\250R=\172\168\SYN)\174\SOH2Gv\220\224\128\195\ESCN0=\205R\212\151\251>\226\222\CAN\228\142\237V5yH\131f\209\252C\EM\EM`{\131\208u\173\NUL\207\130\234\230\198iV\216\184\DC1\253\246N\ACK\211\200\200\FSzq\207\&8\173=\ETB[\187\211Q\175\SYN%\152\DEL\170\148\&2\130\165\&8\235\239\208~5\131wt\242\221Iqy\230\189\196\196\&0\222\&2\CANc\131\207'\143\243\197M\v$\247\171\246\153<\136\216\128\228\DC2\219\&8\198{\146\DEL\207\&4\154\184\143`\240.\188\&5\157Fq{\ESC<\144\134\154\NAK\223\134X\136\229\NUL\RS\131\a\176=\177^\173h\176E\DC2M\ETXJc\147\NUL\a\145\136\250\252\198\188;\192\ETBV\211J\247\&7\179\198nm\DC4yrG V+\243\FS\143\239`\145\156\242\&8\232\&8\175V\208Z\192\233\208\238vR\248Y\DC1\190C\FS\153\&9\EM\CAN\200\206x\231\183j\157\132uX\207\255\NUL\174\147n\DEL\253t\170F\197\217\140`c\a\181/=3V21\RS\227\205\&5\227\NUL\212\221\SI\DC4\132\n\STX\197VN{f\162e\171l\131\181D\201N\228\216\142\208b\224\255\NUL\186\DEL\152\162\164\183\US\191?\238\255\NULQE1\163\228\232\175#\133\238\147\237\151\&1\204%\220\130\NAK \SOy\232\&3\156\SYN\GS\197i\167\138\245\171]([Yj\179\218ZDH\216\NAKA\206s\128\192d\227=\255\NUL:\204\211\224Ig\187W\184H\DC1\153\247H\193\152\161\201\232\&1\223\167\NAK\183\r\174\153 \142\210\216\239\184\185tP\147\NUL\168\ESC<\143\151\&8S\193=\255\NUL\175,\157\153\162#\142\207Gh^\230\246\254\226k\189\235&\209\DC4\152\149O\204U\155\130\t\EM\228~\NAK\218\232\&76\SI\161\201\ACK\157g\r\201/\136<\152\247\ESC1\201\203\134\229\134q\206\&9\224\RSk:\207\195z\198\153y\ENQ\158\162\134\214\222P\252\a\ENQ\STX\228\ETX\142\185\237\254@\173+\230\209\154\231\251\&8$\DC2\192\139\181dt\f>\153\234\a\208\212\221\222\197(6\174\140\237n\194\210(\167\196\150b\225e\r\139v\CANc\180\SI,/PF\238\221\135\231\141q`\154\234\219-\160\151\205\132,2o\144\201#\243\128G\247x\237\194\241\154\246\143\SOA\DC4V\175\NAK\186\193\251\180V\r\128\204\CAN\243\199\ETXo'\129\140u\166\219\233\ACK\211U[\249\160E\185\191c\DC4\206\141\202\&0\\\174\220\SO\156\&7\224z\214\145\190\228\158%\175K\226h#\158\214\225.>\201n\130\NUL\SUB%\218S\248\SOHQ\199Q\239\130N=\242\239\180\187\255\NUL\"[\153\136!\163;G\152\EM\217\ETB\USx\STXJ\224\DLE0px\199Q^\221q\163\157[\195\151vP\206\243\197,\173\CANY#\EM\ENQ[\130\ESC\EM<\STX\ACKO\182k\ACK?\fE\NAK\218[\203\166\159*TY\ETXK\NUL,\204I\221\CAN \140d\SO\231\177\231\166/\154\200V<|I\v2[\222F\DC1Q\157K*|\232{\253\NUL\253\&2j\132\200m\222h\158\&2\172\220\128\189\&1\212\DELJ\245\164\248_4\176\222\221J\255\NUL5\196\146\249\\\134t`\165\151<z\fd\RS\190\189j\229\255\NUL\195\148\DC3\193\DELk\DC4\147y\205\DC1\ESCv\237\t\183\144\170\SI\EM#\215\191\CAN\235MH\SI(\209.\202\\$\f\145\149\154EW\220\163\240\&9$c\159z\246;?\DC3]\201ko\SO\141\SOH\146\229\SI\157\&3D\138\DC1\182(\\u\228u\EM<\240\SI5\138>\EM;\181\156\145-\212Kz\229\f}|\184\202\231\159`qZ~\t\208o\252\&1\226\246\211n\SYN\233\225\144\&8Y\163\143*x\EOT\254\CAN\218\b\233\156\USJRw\NAK\143`\178\154K\139\&8f\150\&3\DC3\186\ACKd=T\227\145\248\SUB\176s\215\NAK\FSI\229\174\220\SOH\236\163\165\&9\157W\239\DLE>\181@;\233M<\154\175q\168ZZ\168\&3\221C\CAN?\222`+\RS\227\198\154$\fP\\\180\172\&9\"4$\254\180\210oa\ESC\199\173F\192\SUB\229[\226\ACK\159&D\DC1J\206\SIC\140c\167PN*9<yk\f\205\NAK\213\148\241\&8\192\198\225\215\140\250\RS\244-@\235\160\US\190?\238\209X\218\&7\138,u)\221\DC2;\136\216)#\204\140\224\128@8##\189\DC4\245\ETX\229\232n\175\228\212.\224\183\131\237\132\179\238\n[\140\250\145\233\131\248\253j\CAN\245k\219i2\141\228\200\164\237\145\DLE\STX\SO0q\249}zsV\236\190\207\155\196d\n\242\179\169}\153\200\207\&8\244\237\233\250\212\214\182\146\205r\208\164\216O\187\178C\145\211\143\231\235\\\178\154M\221\ETBc\163\215\245Ma<+\162\222\205\171\249\215\&23\198\209.\210B\NUL\n\146G~\157G\231\214\185\205;S\187y\154$\131\fs\183y\234\222\245c\196\182\209iZT6\239 y\159\160\a$\SOH\213\136\237\233\255\NUL\234\174r\v\245,\145\187\EOT*\217\203S\133\167\ESC\164t\211ih\207\169\252\v\EOT\a\195\150\215\190B%\212\203\137\216\DC3\243\NAK8\GS}\177[\183\215\218}\154\161\189\185\183\128g(ep\188\251g\235^7\224\239\SUB^>\156m4\235\144\205\ETX\NAK\216\232\STX\182{\130z\215\&1\226\157f\251U\241-\236\186\153y\226\136\b\146\&4\254\FS\SO\&H\FSq\156\254uQ\168\155\229\234c\236\219\145\236\222\&2\241U\190\137\164\194l\RS\222If\201\140\169\EOT \FSn\GS\171*_\136vRE\DLE{qq(}\232\200\140\136\NUL\255\NULh\142\185\US\136\175.\211\188;s\170\217\185\211\156G\t\151\DC2\t\217\134\b\GS\a\168\228V%\180\215\144\222\220[\201\169yJ\146\149v*\bL\FS\DC1\156w\161\205;\217\236R\166\174\211>\143\184\241^\140\&4h\174\154e\156>\221\176\169\ENQ\243\215\167\183\175\181bj^4\209\180\173\ACK\ESC{$2J\196\164\&0I\252\ETX\174s\232+\129\135\195\179\221\US6\194\234\216\186\DLE\192\153\252\221\203\143oQ\244\172?\DC3\232\183\208\219Dn]cV\204`\198\249\218x9\231\167\ETX\249\214^\219\153\216\152B\236\238\&4\207\136\218\188:\130\GSV\210\222{rB)\135\229\217\158:b\186/\248X\SUBt\246\254tVE\206rK7\176\FS\DC1\200<\SIJ\241}\SYN\222\247T\187\130\222\218b\200N\199\ESC\t-\254\209\233\140~\\WWa\224\237GE\134Q\ETX\180\197\177\130z\ETX\235\140\243M\213\133\&7\171\GSHk\162;=O\226\r\210\196\235\DC41\194\CAN|\175\156\176\254\153\252+\205\245O\NAKjW\ETB/3\220\200\216\201%\143\US\151\212\214\233\240\221\252\214\170.\146\&9d9\SO\135\NUL}y\250U)<#pdEHm\252\165 \182\240\&2\192\253I5\151\214 \229vg\202\204\189?]\150\246\&6\135\230gS\184\177=\177\223\241\171o|\226\220\162\EOT\141O&F|\ETB'\174\&3\206\&9\254U\160|\r7\148\222\\\208\249lG\202\ETB\US\135\184\193\170\240x*\253\GS\154K\232\144\EOTe\137\NAKH\v\159\240\231\241\170\150*\234\209v@\160R\158\&9\158\232\202&X\225Q\183\174\CAN\147\212R,BWv\181\141p3\153\221\254o|c\167\&9\173D\240M\204\144\203\FS\218\160>j\133c\DC4X#\241<\231\222\174A\225\b,t\228\181\134\241\176\185,]rO\249\&8\172\GSd\150\140\165\DC2\199\128n\NUL\241\FS\246f\225\238\GSm\164rO8\249\163\RS\191J*\247\131\188\&2\182Z\252\183_og\221n\232\DLEC\140\STX\200}}\168\174\186\&5\"\225{\137\196\240\166\184\134;\217W\201f\147\204`0\221\201\167\217\234\&26\160\161]T\FS\177\219\144\t\ETX\143\229U$\ETX\237\215R\128\&7,\140\&9>\245P\177\142\ETBl\253\226s\142\163\252\230\182pLI\151/\181)uQ\f\249\"\238\ENQ*\249\&9\220:\228~g5F+\140\180\142bC\129\144:m>\213\\3$\170\196\178\176\&9\220:\253j\200\152\205\230\&4p*\135\CANfc\128\DEL\194\169EEX\215\154\230\150\149\171O\167\220[j\RSaX\237X,q\131\143\&0\227\159\192\243\147\239V\245\GS`\220_Kz\CAN\148\159,\229\aF=\DELZ\203s+C\246\153R2\136<\184V>\153\198w~\US\207\NAK@\253\213\228\160a\187h<q\199\244\165\CAN&\238>~]N\162?\RS\234\SYN\186ki\246ea\136\156\137\128\"C\248\231\142\157\170\142\159\166\221k\DC1\\<\ENQ|\195\133\ACK@W\204=v\134\233\158;\227\173`\200\155\CANs\156\243]\SO\129}sf\211\218\176u\r\135\nx\249\135\255\NULX\138\181N1\189\145\nM\203S\167\240\254\151ekp\146\223\205t\247\209\168A\FSRmT\192\199$rO\208\138\220\215\174\226\212\180\129n\201)\152I\185\EM\CAN\145\159\239g\145\234\&1\\\\\151\141\r\200b\174\224\185 \ACK\193?\141u\218u\204w\208\133rD\152\228\&1\201\US__\198\187#J\SIK\DC1{j\138\190\DC4\191\187\209\245\ETB&\223t/\152\196\142\185\228{\SOv\241\130\DEL\194\189\SI\251m\SOKH\DC1Tg\230\254\149\197Z\183\217\230\150\220)b3&\220g\142\&3\143\199\249\214_\139\181\&6\183\130\209\161\157C\177pP\131\211\143\254\184\174lF\SO\DC2\166\249V\160\230\219\185\223\220\248\182\198\DC4\r\188\&0'\ab\158\rW\147\198\182Q\161\DC2H\133p0z\228\145\237^45ige\137\228\199#\EM'\ACK\166,\211D\210\ACKUT\NUL\146O\NUL\SOH^g\212\172\236\216\249\143a_\CANi\163\228\&7\136\ESC\162\ACK\FS\FS\143j\148x\155Mm\197\238\226e\\\131\147\140\SUB\240\187\141Y\252\168\162\132\EOT/\130\239\252X\236\&3\219\215\241\168\225\213\EM'\STXE\220\160\SOrs\159Z\183\151\171_\152\&9\153\239\209j\150\178\225\226\147r\156\147\198;\241N7qL\193\148\228\FS\DC2T\243^A\ACK\177r\163\&1\205\"#\162\228\DC2}:\142\&8\173\237\RS\243So3d\168\209\175'y\EOT\147\245\ETX\240\231\214\185'\135qW\185JW={\195N\159\218\146|\199\253I\198}7-\NAK\206x\SUB\227R}v_\181\NUL\160\218\177 \FS\224\238^?*+\162\132m\SOH=\207\v\188H\226m\235)2<\210\238B8\198H\US\215\244\167\165\237\164v\237\DC4\214\130@G\f@\EOT\231\168\a\181R\185]\250\133\192\227\"C\140\156w=\233\230\ACKS\177\227\201Q\146\152\232\&1\146\DEL\157v\180\186\144\158\165\SYNU|\136\213\138\ETX\242\231\175\227\218\156\241J\b7$\133\FS\ENQ\a\159\192T\205\ACK\248\188\204\151pq\183\GS}1\237\254\DC4\236An\203\246\148y% \SYNA\242\140\RS\217\237\218\170\229\\\149ey\ETB\204\DC1G\STXF\185\140\143\239\FSu=\207\242\165\139M[\155\SYN\146\222R\210\131\151\141\192\201\&8\236i\136\DC2\234PM\187\b\212\228F\140p\a\169\207AZ\242\CAN\163x\228@\203\&8S\185\215\US7\GS\b\164\174\182*\233\238a\255\NULe_|\165l\238\vu$Fk[N\211'\183\188\&77X\140\133\249c-\150'\232+u&K\184\182g'\NUL\147\EM'on\248\205e\207l\230\225\DLE\237\236Y\138\253\214\199\175&\173\&6\208\180Z\148\SYN\238k\155\196\ACK0\DLEH\ETX\DLE:\231\&8\255\NUL\SUB\234l\128/\FSj\239\150\&8\ETX\FS\SI\203\167\231XO\165\207\FS\172\210\167?\242\206\&1\211\167\a\142\220\245\174\167M\178\153\227I\164y\212\148\200\NUL\DLE\204\SI\a\FS\DEL\159\194\181\167POqg\186\b\128\199\&3\SYN_\151t\141\142=s\156\254\NAK\230\186\133\236\183\183\146J\238\204\v\GS\187\143A\216W}\170\233\236\233=\184\179\185ir\DLE\144\132\176\235\158\191N\245\142>\RS\235\179\175\153k\166^:\140\FSIn\200y\247\233\250\211\156\249\180B\208\228\227\148\140\ACK'\RS\221EKp\242\&2\174X\178Wk\a\194\159\DLE\206W\253\RS\CAN3\212Ip\156~D\154\151[\248a\174x{F:\140\205o4*@\145b,J\169\238r\a\US\227I'\212Z\RS}\243\202\193T\DC2\216\224R\194\174\193\128V w\244\173\b-\"[\180}\225p~\233\234?\250\212\151\DLE\187]3FY]rp\163\191\181d\221\152\199Y_\205m Q&UxP\205\144?\n\219\182\212\238\229\155z\187G\DC2uU8\GSEsLU\228\253\226\145'\241\DEL\SI\231ZvS\159(@\224\174rP\227\175j\202\164\DC3W\176\211\212\245/\134\250\197\205\207\139g\138I\EM\215\236N\216\221\208\135\140\DELZ*\167\194\192\US\197\151\SO\t.l_v;|\241\209S\b\197-\132\239s\138\214\244\251[)n-\237\209&\186i\ESC\206\146I\SO\DLE\243\242\174\&0\t\255\NUL\RS+>\224\b\f\144\224\NAK8\\\238\193=\206\&9\245\168\238\231\184\138\226\234\&9\GS\198\249X\237.@8b3\250S\154\224\200$\146f\151\&9,\ACK\243\233\233\244\EM\162\205n\ETB\ESCm\SUB\172\129\RS'\SOH\135\EOT\177\&5%\247\151=\226\147o\SUB8DNs\128\STX\129\220\144zT\150\&7f9\163\"i\DC4\177\202\243\143\235Z\173;\146\173f\242\t\149\138\137\DLE\146]z\227\233\142\&1\244<\243I\201\169\b\191\167\248\ETBX\212\161\138t\181e\141\208\&2\151\153#V\247\229\179\250\n\233l>\SI\234\247\209\133\184\188\180\139\r\158\EM\223\249.?Z\236t\137\160\151D\141V0\210\198\STXK\"\128\&9#\EM\ETX\NUL\DC1\223'\142\181\212\217[,xI\237\252\197\234\172z\143\195\165k\DC13\147\211\254\nX\199\SYN.56c\199\250\184\177\143\204\214\155\252\&0\208-\139\a[\185\137\ETX\248\194\142\199\210\187X.U6a\243\DC3|\188\177\200\&5GZ\185hn\DC2%\144\131\"\231\239\&0?\165\\U\216\FS\210xSG\179\137U4\245uC\144&\145\137S\143\174\ENQoi\182\154Z\196\SI\216m\154T\227\"5\206?\SUB\200\185H\228\198\240\GS\143B\220\228\254\181kB\185e\186\154\220f7U\206wp{\130\a\161\193\252\170\165\202\130\218\ESCS[\205\&3\198m\230\DLE!\229\148G\187p\250\142\148\251\155H\228\136nL\157\192\f\143\243\219\&4\199\187m\141\186G8\228\f\227\249T\150\247\171ql\217\r\242u$\254#\174))\t\174\165\DC3\166\198:3\f\246\220q\249U[\152\128\137\224x\163\&0H\n0e\249\\\RS\b8\245\247\171\215w\145\171\148\f\165\134w\NUL\192\231\GS\191Z\161q\172Z\164\DEL3\168$\DEL\DC1\197_2b\179>x\241\231\132\219\195\250\177\150\NUL\239a9&'\234S\156\148>\227#\240\193\174a\167x\238\182J\SOHpp\252u\237\145\248s^\223\226\237SI\184\208\174-\230\242\229\243\ESCr\131(\f\173\209H\FS\158\&1\220\f\143\173x]\201_>B@\aq \SI\173D\236]\244\212l\158\\\133\219\EOT\158\141\158{\250\211\195\128\STX\246C\184\FSr3L\133\208\128\174\SOH9;OL\159CQ\249\160\&1\GS9\193\169\176\155=3\225\NAK\195\201\226\203\148|\DLE,d#\130\&1\251\200\232\170\191\b2|ct\v)\STX\194L\DEL\223\200\232\161E\ENQ\206\"\228\163\222\204\243\DC2\DELz\252\231\223\167\210\166Ky\144\238\153\210\&5+\188>Cd\227?\159lv\231\&5\167\166\193\165Ow{\RS\162\171\188;<o\188\174\&1\212\FSWM\163\232Zn\161\164C=\212\ENQ\139\174_\247\140\ACKy\193\192=x\197rV\196*{\133\206)\149\161\191\183\181\&0\135\144\133\148\201\195\238\EOT\ACK\227\GS\177\255\NUL\215\233Z::\190\163\171[\218\180\203\243\202\NUL\147<(\250\128q\129\205M1\141\181(\172-\163\ETX6\209\168`0\220\198\&0\185\238\&9\USR\ENQEo\162j\150\&7[\254\192f,\191\&88\\\RS\184\FS\245\193\235\235U\207\RS\165=\SI_2]ip\162jp\178+\ACK\182\&7\n\202\v\246\231\EOT\224\231?7O\165t\246\250\218\139t\n\CAN\NAK\194\DC1p\225\SIN\185\231\131\207'\252k\193.n\181\232l\157\SUB\221!\183\f\SYNB\203\DLE\221\147\128r}\207\173Y\178\184\213\158\193g\242\139*\NUL\219\247\SI\153}z\246\254T\249\212U\211\SYN\140\247;]f\218\210\229\164\190G\219\203$\137\247Fy;\137\192\227\215\167\&5\ENQ\215\137\160\187kK\155ym\158\EM\SOHUY\174UYO'\EOT)\207\232\SIN\181\226\178\roXH\174\147\205\DLE\176 \ACKo\152q\193\EM<\253z\US\231a\180-Y\"t) DE\f\EM\148\238b\t'\142\217\254T\158\"+\169I&z\244\186\214\148 \243/5\v\NAKb7\ENQI\GS\253zn`;\US\202\176\165\241\222\147f\226\DEL>g\150!\178\&6\141T&\222\&2\185\201\200\252+\201\231\210\&5mBc}o\EOT\230\226\&6\SOHH\SOHP\DC1\193\198s\158\&1S\\xkZ\184\138 \150\&2\"\"\225>e#\233\156\146\163\174\NUL\245\169uc}d\135h\158\186\159\DC1`\184\154\b\144I\EMu\206\217\FS\STX}\ACK\NUL\RS\255\NUL\161\226\179\238<d\255\NULj\145\EOTJ\160\174H\192 \142\153S\147\187\EOT\245\GS\135\181r~\ETB\240\228\ETXH\251F\163n\226\233\157\149\142\230\252\136\207\191\185\252\&8\170\151\SUBv\163q\EOT\201ei$\177y\167\201q\149\200\EOT\140rGn\224sX<D\\\154Oa\167\DC3~\235\197\183\158]\194\195s3\SYN_\221\238~\DC3'\219\143\255\NULUs\183\186\173\252\232~\221 G\242\247-\194\145\149~x\235\200\207\175\175Z\202\138\199Y\131R\141`\179\149\230T\RSb\DLE6\168\198q\237\207\255\NULZ\160\155O\214&\188\139\205\176\146\EMy?'\220q\158x\207PO\173k\EM\171\238\r\164c\234w,\178\231k\r\217\&9-\156\228\250\247\250\214T\146\179\228\DC2y9\235\212\215Uc\167m\212\f:\166\149,\208\180lR8\153U\134\b\249\186\129\222\172\199\225;[\205[0\218\207\GS\146E\189\214G\SOH\203\DC2@\a\147\142\135\242\173\189\188c\185\147wg\SUB\165\158D;FI\NUL\228qWcE\184\138m\233\243\CAN\203\SYN\GS\136\231?\136\ACK\186=c\195\EOTO\STXXZ4$\242\243\&3\144\129}\t$\146\DEL\n\173{\165&\143\EOT2FZWbU\228\192U\fp\NUL\ETX\175v\235B\175\tZ\221AI3s\224\242\145\227+\181\234\ENQ\140\152#\167\250\200\248\162\153\240~Vo\EM]\146I\STX\194L\SO\195\247\145\244\162\186\DLE\FS\131\161\243\174\&6\186\255\NUL\173f#\128O\183\191\249\&5\233\190\RS\149f\240\236Q\198\172#\b\204\DC4\142\131q\255\NUL\245\215\152\187\162\220\220\134*\173\230\157\187\185\224\231?\200\DEL\156\215\160\248{R\211\236\180kx\238\175m\SYN\225#*b\DC2\141\196\STXz\243\129\199\243\175;\ESC\a(\233\220L\198\209.\221\245\168f\251/\155q\196*Km!\STX\246\227\176\STX\183o-\245\233!\137\196\150\214\130\&6.\216b\219\243\140\SI\187\197R\154M\SIM\187\179\186\180\154\b\255\NULz\SOHU\148\187\ENQ(Fq\147\142qK\174I\165j\240\198\239\170dC\151\DC1F\202\230N8\NULg\131\199^\220\214\DC3\247\164\154Zz\\Rwc<W\184hW\b\SO\210\197\NUL\RS\163p\226\166\211\SO\207\fFX\FS-\185\239\219\a4\235\166\209\245\141\&9\163:\173\178\197&\b*\248e \131\223\233\222\156.\180\187K%\133/-\220\165\190\213Ie\SOH\137\219\140\DC1\215\168\228RW\228Q\183Rl\236\&2\194\227_\147M\181T\138\202\DC4\242@\137\203\&6\240\160pq\143\199\154\232\&4\246\184\183\211\139^N$\159\ENQ\167\145\&8\\{\241\219\214\177\161\188\179\189\209\FSI{\DC4\SI$\SOH?\214*\186\177\CAN=\251sPYh\218\&7\246x\251^\160gO\226\149\174\143\205\248+`\247\CAN\169\148\DC4\175um{\SISOH\212\DC14X<\174T\198[q\GS\ACKN+\SIE\241\134w\157A\165\157\203eJ\162\224\f\SO:\142\254\213cE\191\210\151KKX\174\"\RSH`D\174\DC4\142O\ETX=x\197>\210\223O\240\252\&3\"\221\196\233#\239\DC2L\202\&20:\US\203\165\SO\156W2q\213\141>\231G\160]G\DELiqr\140\178F\247/\176\182r\163j\241\128p;\247\166h\250\131]jw\232\238vB\248U\218\&6\170\228\142?.\253\250V\ACK\153\226M9\225\184\152]\195\DC3}\161\254Vp\164\175\CAN|\US\165W\240\246\173j5-V\226\226\230%\141\228\ACK9\EM\192\203no\207\255\NUL\174+)a\229i\187\SUB)-N\214\202C\RS\167z\237\247\SOH\140(#\ETX\140\243\252\133q\255\NUL\218\179\183\141\174\172\RS]\214\202\160\198\152\227\&8\a?\\\147\249\213\195\226[H\245\155\152\231\188\142\&8e\138\&3\ESC\134\202\145\150'\159_\152~UO\203\210e\215\205\245\149\192\154y\DC3i\141[*0\NUL-\145\211\166?:)Sq\191\&2\232L\152\251\135\r\175B\SOH\EM\SYN\242\DLE}\139'\NAKT\207\&2x\155\202\138B\177\189\153,\163\141\216r\a\243?\157K\168^A\ACK\177o%\211\197\STX\253\157\215{\GS\161\155rq\207\210\178\223P\177>!I\133\244\RSX\180+\184\184\ETX;\250f\186a\SYN\214\221\f\139WW\147\175\137--\EOT\167\201xY\153\&0\b'\230\231={\n\203\241\141\196\176\197k\FSm\251\167\222\206\164\SO\171\140\DELZ[\173Z\201<Ya:\220D\241$L\158b0!X\238\198H\250\138\173\226\185-n\173\226\154\ESC\200\164x\216\168\141\CAN1 \247\235\237]\DC4\225iGN\131KTm|\US\192\241\165\224\GSE\140\131\143\250\233\GS\NAK'\194Ky-\252ks\230+.\253\&9\136\200\235\243\197Ew\173\141\t\166\248K\226\DC1u4\209]iyrG\205,\156\f\159\250g\244\170\171\240s\196a\183}\183K\243\vu\243\164\255\NUL\227tQJ\192J\159\a\252F\247\NUL\189\246\154\161\176\CAN\172\178g\EM\207\US\187\171#\225/\136R\a\183\130\231K\140\179\US\222y\242\DC3\143O\245tQJ\200es\240\DEL\196!\246-\230\156\145\145\134\vq'>\191\242\206\139\159\132\RS\"wV[\205\&1Yr2'\147\167_\238u\206h\162\157\181\SOH\131\225\US\137\194\128/4\156\131\156\249\210\SI\253\146\150\DEL\132^)\152\134\146\255\NULK8\224\SI6@\ACK=\NUL\143\STX\138)\217\b\177m\240\191\197\DLEK\DC3\155\141\SUBQ\DC2\148\DC1\201$\133H9\234\&6s\215\&56\167\240\215\197\186\162B\147\221h\171\FS_qcy\ETB\US\248\229\DC4T\242F\247\176\EM\163\224\223\136\135\221\187\210\243\254\212\210\FS\DEL\228:\158\SI\132~%\136\252\183\186`\193\207\DC3I\215\254\253\209E6\144\205]/\225\255\NUL\138\244\212\144%\198\140\228\237\229\228\144\244\207\251\RS\245\DEL\254\DC1\DEL\SUBD\177\CAN\165\208w\168<\187\202p{c\229\237\154(\172\165F\155z\161X\198\189\248i\226\205F\231\207\189\188\210&\249\EM6\153$\NUL\ETX\233\251\190\SI\189f\SI\131~\"\DC1\DLE\215\154Y\244\253\244\159\252n\138+U\DC4\149\144\250\SYNS\224\150\190\214>j_i\130@\249\193\146L\DC1\219\157\159^\213\DLE\248\&1\175#\171\155\173-\139\231\131\&4\152\ETX\254\248\235E\DC4\144\206\207\225\215\128\188A\160\248\142\230{\219\187\t\225kV\141\NAK\GS\137\az\RS\232\&8\192\&4QEZbg\255\217"
cooked_die_fantastischen_vier =  FreeForm "die-fantastischen-vier.jpg" "image/jpeg" raw_die_fantastischen_vier

raw_elvis_presley = "\255\216\255\224\NUL\DLEJFIF\NUL\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\255\219\NULC\NUL\b\ACK\ACK\a\ACK\ENQ\b\a\a\a\t\t\b\n\f\DC4\r\f\v\v\f\EM\DC2\DC3\SI\DC4\GS\SUB\US\RS\GS\SUB\FS\FS $.' \",#\FS\FS(7),01444\US'9=82<.342\255\219\NULC\SOH\t\t\t\f\v\f\CAN\r\r\CAN2!\FS!22222222222222222222222222222222222222222222222222\255\192\NUL\DC1\b\NUL\150\NUL\150\ETX\SOH\"\NUL\STX\DC1\SOH\ETX\DC1\SOH\255\196\NUL\US\NUL\NUL\SOH\ENQ\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DLE\NUL\STX\SOH\ETX\ETX\STX\EOT\ETX\ENQ\ENQ\EOT\EOT\NUL\NUL\SOH}\SOH\STX\ETX\NUL\EOT\DC1\ENQ\DC2!1A\ACK\DC3Qa\a\"q\DC42\129\145\161\b#B\177\193\NAKR\209\240$3br\130\t\n\SYN\ETB\CAN\EM\SUB%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\225\226\227\228\229\230\231\232\233\234\241\242\243\244\245\246\247\248\249\250\255\196\NUL\US\SOH\NUL\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DC1\NUL\STX\SOH\STX\EOT\EOT\ETX\EOT\a\ENQ\EOT\EOT\NUL\SOH\STXw\NUL\SOH\STX\ETX\DC1\EOT\ENQ!1\ACK\DC2AQ\aaq\DC3\"2\129\b\DC4B\145\161\177\193\t#3R\240\NAKbr\209\n\SYN$4\225%\241\ETB\CAN\EM\SUB&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\130\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\226\227\228\229\230\231\232\233\234\242\243\244\245\246\247\248\249\250\255\218\NUL\f\ETX\SOH\NUL\STX\DC1\ETX\DC1\NUL?\NUL\244\189f\vi\238l,\230\182\130X\FS\200v:\STX\SOH\NUL`\128~\181W\254\DC1\221\ETB\254\129V_\247\225\DEL\194\166\213\219\SUB\246\142\t\NULl\185\207\228\149\146\254&2jf\214\217\NAK`\NUL\254\253\136\193 g\129\158\149\241\217\188\&151MQn\201&\245;\240\212\220\169\221+\216\210\255\NUL\132\DELG\US\243\v\178\255\NUL\191\v\254\DC4\225\161i\ETX\166\151e\255\NUL~\ETB\252*\221\164\198\230\210)\138\133.\160\144\SOF{\213=_]\176\209\160\243.\165\249\177\242\198\163,\223\135\248\215\133M\226\170\212T\169\182\229\219SG\202\149\222\195\191\177\180\144q\253\155d\SI\253pO\240\172\233\163\210O\217^\210\198\202Tk\175%\202\192\152\238\SIn\199\NAK\137a\169\201\226y\174\SUB\EMZ\218\228\FS\196\225C\EOT\\r\167\251\217\170\225\239t\189\&9&\253\211\188w\165\214\DC28g\nK19\239\158\157\177^\148pUa'Ns|\247\181\132\221\151\&2Z\GS\184\210\180\225\255\NUL0\251O\251\240\191\225N\254\205\176\GS,m\DEL\239\202\255\NUL\133s\254\FS\241T\186\238\169,B\209\163\131\203,\174[\142\&01\211\147\147]Uy\184\186x\156-OeU\180\253G\tBk\154;\NAK\133\133\152\255\NUL\151;\DEL\251\244\191\225K\246+A\210\214\SOH\255\NULl\151\252*\197&k\151\218\212\254g\247\151dC\246;a\210\222\DC1\255\NULl\199\248R\253\154\SOH\210\CAN\199\252\NULR\189\196\&1\186$\146\162\187\156*\179\NUL[\232;\212k\168Y\187\236[\184\EM\199\ESCD\128\159\202\173:\207]\DEL\DLE\178\NAK\226\137\n\254\234>X\SI\186*O*?\238/\253\242*\ESC\194@\139\FS\DC2\255\NUL\208\213\144\&8\250Rs\154[\176\178\EM\229\168\232\163\242\164(\163\176\252\170JN\181>\210}\193\DC1\236\RS\148m\169\&0)\r\RS\210}\217Z\CAN\ETB\SI \241\181\130\a`\159\217\215\a\EM\227>d4R\221\fx\215Oo\250\135\\\143\252\137\ENQ\NAK\250\ACKL\239\130\166\223\159\230\207\&2\191\241\EM\165\171\224\235\250@#\140\\\143\252v:\224.lL\190'\159N\142=\233\135\145\NULf\220\&6\231\ETX'\233^\131\171\ETX\253\185\164\159O\180\DEL\232)\\\ACK\161s.\139\171\234z\150\236\206\242\DC4\132\169\236G_\200\212j\241\181#\ETB\171\130Iy\183\250\GS8yMAr\187.\190\134\142\171\171\220\216\149\209m\152\196\197\NUL\v\NUL-&H\228\fz\DC3\214\170\234\RS\SYN\189\158\196jW\172#\146\&4\n\208\135\203\&2\244\203\&6q\158\153\STX\183\252>\"\176\180\183\251A\140\222\221\SI2Iz\177'\144\&2y\233\197n\\H\177\175\206C\197&Q\195`\129\193\253+\231\229\152\207\r%N\130\181\183}\251\157R\156e\NAK\DC4\149\151\222\253O?\210\174na\157\140rGogi\EM\184ep>b\SOH\225@\253i^W\212\252=\246\136\DC4+\139\169\FS\131\238\163\US\225V\188\152\181P\150\DLE\194!&)\DELz[\134%\130\142\195\RS\148\228\180\183\240\252\ACK\221.c\187t\217+\198P\168R\CANu\247\203\SI\202\189GV\151\199o\222\221Yyu\191\169\157J\202S\148\229\164m\232\253\ETB\200\231tw\188\210n\229\151\201\251\&4\232\155ZV\235\183\RS\135\240\&9\246\247\174\174\215\196\SO\154:\234R\220<\224\204\177\147\184\r\170s\201\USQ\143\198\176\201\184\212n\222I\227K\169.\156\169P6\f\240\NUL\RS\159v\145me\180\210J\197\EOT\190[[\171\&8e\220\160\177\EOT\231\220\FSb\181\199J\142+\223\171\NAK\206\223M\173\219]}\SO*<\177|\170\246\254\172zr8\146\&5\144t`\b\252k\129\248\141\227\212\240\229\179i\214\SI\157RU\234?\229\138\159\226>\254\131\241\174\216\207\GS\165\164^k`\133\ETXos\197|\175\173]Mw\173\223\\\\\204\210\204\243\185gn\167\147^.G\151\195\DC3^S\169\240\199\167sz\245\\#\166\236\142\239R\189\190\155\206\186\186\154i2N\231rNO&\171\STX\ve\179\248\SUB\145-\228\145\192\nG|\145\138l\145<2\152\217J\176\224\131_w\CAN\193h\143\&9\185=\205\v]sU\178\145\SUB\219R\187\143i\202\133\153\128\US\134q_Cx\ETB\197K\226\173\SOHn\GSJ\221\192DW\NUL\244-\143\188=\143_j\249\239O\240\238\173\169\204\177\218\216M!`J\252\184\a\ETX\154\245\207\131\209%\158\139z\242nYf\156\134\r\198\&6q\143\204\154\249\252\254\133\t\225\156\210\247\147[\GSxg5+=\143O\207\&8\205%f\173\234\178\t\228\SOHT\159\148\134\231\242\173*\248yA\199s\188\&1\154nisJj@\195\187\US\241W\233\231\254\156.\DEL\244d\DC4S\174\198<U\167\159\250r\185\255\NUL\208\224\162\191A\201\DEL\220i\252\255\NUL6y\181\215\239\EMk^\128\220\234\SUBt>cDdY\193t<\143\145:W\v\172\218\CAN\238\174\173\237\231dx\162\&2\188\210\146\198B8\224~\159\141w\186\168#_\210=?\210\a\254\&8\149\198x\211\&6\154\130\202\135\DC1\202\132\186/\241c\218\184\241\DC2\155\204\185#\189\180\&7\165'\SUBw\181\255\NUL\175\208\202mN\255\NULD\137S2l\b\172C`\131\158\224\250s\252\186Wd\186\212\&7\218\FSw\136\193\146U\193\193\229_\161\a\241\&5\139\NAK\180Z\158\129j\185\221(\137X\ETB\245\199#\232zVE\179.\153!F\196v\173)R\b##8\EOT\143\195\249\214\SO\149<dyT\DELx\159\222\134\148\211\238\158\190\133\215\151l\226\239O\185D\158H\SI\153 S\189yA\202\244\US^\167\143\173R\212.\205\182\203\139\149i\140\191)\220\216\&2`|\196\158\252\226\141.\236\220M2\\\249q\186\196P\243\141\205\185y\253\&1\249\154\205\191\188\142K\184g\137ZkY\SOH\136+\156u\198\236zr\217\NAK\236\225\&0\171\235\RS\198\178\186\143\227\165\210\185\&5d\190\175\US\230\190\246\249-?3kI\149ex\231\133\176`\rs\229\US\188B\228\241\235\202\227\219\&5n\239\\\211a[;\EM\173<\201\218\&8\148\176'\fp\b\220\SOH\228\STX{\215\&7d\SUB\ESC\136\241\&9\ENQ \153\ETBo%\206\\v\227\184\239H-E\207\141mc\v\230Fe\140(\206\SOH\NUL\SO\255\NULZ\198\174]F\173YM7\202\162\229\247_@nT\161\204\227\171iyt;\201\SUB{\185\&3\176\150\236\160p+\194/D6^<\156M\NULx\162\212\ESC|G\144@~\149\244CO%\187\DC4H\194)\FSw\199\255\NUL^\188\139T\179\176\183\248\163cu\DC4\194\225'\188?iB3\229\203\193#\223\239\ETX\249\250W\153\146U\180\166\173\165\138\196F\234>\167\167G\161K{gr-V\b\131\157\209*\160PT\142\142\&1\207\255\NULZ\177\244\175\132\246\210\235\242\234\SUB\171\tQJ\237\132G\177r=\135\ESCx\ETX\NAK\169\173j>4\210\181H\215F\208\173o\236dPRP\196\&7NU\137`\ENQo\248wX\241\SO\161q$\SUB\207\135\191\179\182.|\229\184Y\DC1\207\160\197z\CANzs\140y\155\220*\213RvKcf;(-\227\196\&1\"\ENQ\a\SOHT\n\225\&4\203O\"Y\227E\b\205=\211\182;\254\246C\252\128\171:\158\143\227\175\DLE]J\141\171[\232\218ql$V\185iYwug\227\a\FS\224\RS\188{\212\177\189\181\157\246\213,b\133\229\141\137\228\147\189\193\250\215\RSm\RSZK\151\168\168\182\219\185%\189\189\132q\199<\151\ENQ\156\NUL\197\SOH\GS}1[\128\228\STX;\243X\214\182\182\DC3K\186)%b\159\&1\SO8\STX\173\255\NULi\163;\164i\149N\173\159\210\190Z\172\\\222\135R/t\162\168\DELhg\NUL\141\185\&8\233VT\143q\235\205`\224\214\227\&3\174\255\NUL\228e\176?\244\231s\255\NUL\161\193E-\215>!\176>\150\183#\255\NUL\US\134\138\251\252\151\253\198\US?\205\158}o\141\151\181a\255\NUL\DC3\189,\246\223\&0\255\NUL\200c\252+\207\252s\170\201\SYN\182m\STXDbX\192>d`\146NO\EOT\253Ez\SYN\172?\226q\166\159Id\US\249\b\255\NUL\133ej\154-\129\188\254\212uct\163\135,x\227\ETX\ETX\252\247\174:\248\202\&8<\207\218V\135\&7\187\162\243*1\169*v\167+;\152z;Ft}<F\174\164F7o\238\DEL\194\176|c\f\208_\NUL#\219\t \239\236X\140\255\NUL\141uv\241\129\"(\FSd\NUL=\235SS\182\179\184P\179+\EM1\129\176\224\138\243\176y\159\212\241\138\186\141\247\211\212\232\156%*N\t\218\250\RS\DEL\174I\SUBY\173\236R\239o%cRQW\147\247\177\140g\EOT\245>\181\131\DC4Mq\162\&4\137\150X\166\198@\200\EM\US\253\DEL\210\189V\211\194zR\183\154\214\217=\ACK\230<{\213\255\NUL\248G\244\191\179\180\USc\140F\199,\NUL\198~\184\174\204?\DC1\211\195Y(\183i^\255\NUL\161\207W\r*\151\230\151K\RSIo\ESC\216[[\220\237\243\DC2Db=\142\252\DC1\250V\205\157\183\153\174X_D\195h\184T>\231\219\243\174\238_\nh\242\192\144\ESCU\DC1\169\200Q\208Sl\252\&1ea|\183\&1\133!?\213\161@6}*\177<KN\173\&9(G\150N\235\213>\135U5(\209\246\DC2\213io&\186\148\252]\168\199\161x~\243QvR\209&\"\r\140\179\158\DC4c\191=}\179_8-\253\215\246\136\190\&31\184\&2\249\166By-\156\230\189\SI\227-\244\195\196\SYN\250z\182-\132\v9Q\221\203\&0\201\252+\204\179\131]\249\RS\NAKS\194\169\189\229\175\200\225\196\212nv\236}{\225[\231\189\209\160\&3\NAK\243\130.\237\167 \228d\DLE{\130+F\251T\176\211\165\133oom\237\140\173\182?:@\187\207\160\207S\200\175\r\248m\241\SUB\223N\182\135J\213\228*\";m\231\236\DLE\255\NUL\ETX\USA\216\215\175\234\203s\DEL\167\&2\181\157\190\161i/X>\206\178\238\RS\167t\138\181\209\ESC\195\220\146\ACK\148\189\228k\v\235V\180\146\234\&9\145\160M\217\145NW\142\188\247\239^a\167x\139O\241\DC4\146\201g&\217\131\DC2\246\237\128\235\239\142\227\220S\190!\248\136\248s\194\214\250XV\142K\229\242\150\205U\DC3\201\183\FS66d/\US(\228\245>\149\147\163\248_K\187\SYN\194\206(\229iTJ\215\235q'\155\ACK\ACK09\SOHH<t#\128\SIZ\199\ETB\134\133z.\165G\202\163\176\161Q\211\154\138\214\231_l\146-\156\236\170w9\216\ACK?\207\173=#[x\182\147\211\151#\158j\252\184K\\.\NUL,z~\NAK\149x$\192^v\250\SO\245\241q\151;=\"{i\150\227v\NUL\EOT\RS\135\210\166\212$\146\CAN\162\149\ESC\149n}\235>\214\222\\\165\192\226\&0p[=*\241\219s\FS\150\221\b\EM\\\154%\DC4\165~\131\EM,\190f\191fGCi9\a\254\ENQ\b\254\148Th\133u{\"z\139Y\193\255\NUL\190\227\162\190\211&\178\193\193/?\204\243\235\255\NUL\DC1\155\218\177\ETXS\211\242\160\147\&3\128}?v\199\250U\GSa\FS\194\184'gq\244\171\186\192\255\NUL\137\150\154p\DEL\215\190O\167\238\158\171\221\202\146[\157\163p\206\SOH\245\&5\243\185\238\152\228\252\151\234o\135\248\f\219(\214\&8|\230\251\221V\146\DLE\215w\161\DC4\247\203\&1\169n\129\142\NAKH\212\158\139\197\&3L\221\ENQ\246\215B20s\219\189y\173\251\174]N\131r4\242\163T\206p94\237\192\247\163#\EM\234*7uD,\216E\ETX$\147\140W\ACK\173\140~Eq\RS:\248\129k\225\171Y--$\142mY\134\SYN>\162,\255\NUL\DC3\DEL\133ax\183\226\213\189\166\251O\SI\132\184\156d5\211\140\198\167\253\145\252_^\159Z\241\187\155\153\175ne\185\184v\146YX\187\187\RSI=M}FU\145JmU\196\171.\139\191\169\201[\DC2\163\164\&7%\212u+\173V\237\174o&i\165<\SYNs\147\254s\154\164\195\154~\221\188\237\&4\222\157\171\236\162\148U\145\231\&6\219\187\FS\146\200\140\172\164\252\189;\143\202\186]\US\226\SI\137\244+\DC1e\167\234\178%\184\251\177\186+\132\250n\a\ETX\218\185\158;\n\DC4)8$\129\131C\138{\130mlhjZ\206\165\172j?\218\SUB\149\212\151\&7-\143\158C\216\RS\NUL\ETX\160\235\192\175P\248g\170%\222\155\DELg\SYN\DC2\233\167\DC2\180K\247v\DLE\NUL\219\156\156ds\159oZ\242U@bV\SOH\183\DC2@9\227\142O\243\NAK\179\224\237hh>%\181\188v\219\t&9\191\220n\SI\229\193\252+\143\&0\161\237\176\210\132}~\227Z2\229\154l\250\&6H\132\&60F\SOz\156\212\r'\202\ETXF\173\129\140\145S\188\169,V\161Heh\247\134\a\130\&1\197\&2\b\210F(\217\206\&8\197~y\178\212\245I\n\133\211\152\NUL\aB\NUL\252*\154\160Y<\224@;J\159sZS&\219\&6\FS\227\129\192\207\160\170\DELg\253\217enq\197M9nQ\ETB?\218\150y\FS\253\158\DEL\253\n*)\236\191\233\246\132\142|\137G\235\GS\NAK\246\249\&4\191\216\227\243\252\207>\191\241\EM\165\175\ak\205.5r\161\238\CAN6;\175\149!\199\233K\flcB\227\a$\149=\185\163\\\200\212\244\DEL\250\249\DEL\253\DC3%L~\239\225_=\196R\182)/%\250\155\225\190\ETX6\246P\147\FS1\US(\224w\172\223\182Hw.0\ESC\176\235W\246\137u\ETX\DC3\158:\253qV\162\183\182\DC2\178\b\193\&8\231<\215\148\167\CANGUs\164\173\EOT\210[C\RSX\186\158p{\n\225~,\248\142K=\n\ESC\vI\130\&5\235\&2\200G\222\&1\129\200\246\201#\240\205w\215\209\186\252\224e1\143\165xg\197\135\a\196\182\233\230d\173\178\229?\187\150c\250\215\167\146\209\133l\\d\214\218\152\226$\227M\216\225\139\DC3\212\244\233\138\215\176\210<\180\182\190\191\n-\US2\128\FSfES\130\ACK2T\228`d\DEL\245\241j\223\218\EOTBE\128\186\171\168^O8\200'\167\184\NAK\247\186\158A\221j\237\162k\246\&7\154|I\GS\173\214\157+\199\166\204\ETB\STX\226 \237\132\144\244\206:1\239\128z\215\157\178\148m\172\b#\130\SIQV\236o>\205{\EOT\178)\146\&4uf@pH\a=GC\239Rk\151\DLE\221\235\186\133\197\186\149\134k\135\145\DC4\246\f\196\227\245\160e\f\140\240\&8\247\167\DC2\b\US(\EOTu>\180\220}(\226\152\139\SYN\179\136\165\f\192\DLE\161\153F8\221\142\t\252qM\147c;4jU3\192\235\143j\140/C\145\207\CAN\167+\DLE1\199\&4\134}\v\224\184\175\237\252\US\167&\162\232\242\CANA\136\169\201\DLE\158T\DC3\235\131\249`v\174\138\223\137\t\255\NUL8\174;\225\246\178/|+e\FS\196\179@\r\185=\198\211\149\255\NUL\199H\174\194E1\192pz\176\228w\NAK\249\214>.8\137\169wg\175M\222(v\169?\145e\vg\n\210\NUL\220\144\&9\a\EM\199\&8\206\&3X\176\222\221=\194D?\179\159q?\234\150V#\n['8\244\ETX\241\171\158,\145\160\210`*\193H\157FL{\241\195\DEL\SIz\231\172\181+\166\147\202\138\238\&3\184\128\FSY\198\187\&9\231\229\207\205F\SYN\151\&5\RSkw\ACK\253\227\165Q/\219 \243|\162\194\&9\NUL\242\131\SOH\140\199\235E\DC14\142\246\134C\185\140.Kl\b\SI)\218\138\250\188\159\253\210>\175\243\&8\235\252l\215\215\SOH:\142\142{}\165\255\NUL\244D\181!\251\173\244\168\181\179\155\237\CAN\131\214\233\191\244D\181)\EMS\239_9\196\159\239k\209~\167N\ESC\224(K\229\199v\178\146C\SOH\233R[\200<\254\160\130x\NULt\168/F'\245\200\DC4\216%Qy\SUB`d\156\158s\208W\145k\196\232\&5X\ACKR\b\200=\171\229\255\NUL\SUBj\t\169x\199S\158\&6\221\DLE\152\199\EM\206r\171\242\131\250f\190\135\241f\172\&4_\n\234:\130\182\RS8O\150\DEL\219n\ETB\245\"\190Zf9\231\147\239_M\194\244\US\191Y\250~\172\225\197\203E\DLE\198M'\173(r\DC4\142\198\144\RS:W\215\FS 9\DC4\172I<\245\165\142\&6\145\213F2x\EM\163\a\255\NUL\175\154\ACK'z;\230\158\145<\140\NAK\DC1\153\155\160U$\154I#xdh\229VI\DC4\224\171.\b>\224\208!\191\197F)3\207J\\\241@\207k\240%\152\180\240}\148\157\238L\147\US\251\232\175\242Q]\246\159(\154\200\135\EM+\242\215\GS\225\DC2\242x#E\222\187H\133\128\ETX\184\222\216?\141u\186lF(Y\159\143\&0\128\163\214\191=\204\155\149Y\183\189\223\230z\212\213\162\145_\197\251\255\NUL\178\162\216\204\164N\167(\219Xpz\US^\DEL\157s60\220\&5\220M\230^aW\EOT4\167\158\SI'\228\254\181\211\248\186A\RS\157\b\232\198a\181\183\237\219\193\&9\206\SIoj\228\237\162{\171\165\205\196D\145\214T\a\143\198\&1W\130\191\213\190\241K\226;UGYm\213\148\r\177\&0\250\242\180U[\ESC\t\160\212RF\150\DC2\190S\174#\141\148\245N\185\&8\253(\175\163\202\DC4~\168\181\239\249\156\181\190\&6mk\128\v\237\ESC\143\249z`?\239\196\213\&8\GS>\181[\\$\205\162\&6\SI\252~s\199O\220MVq\210\190{\137\DEL\222\215\167\234\206\140\&7\192c\234\DC2\177\185d\140s\208\156t\168,\STX\165\232b\249a\207\215\215\244\167\220j\ne\144\CAN\ETX\f\224\231\173Gm,r^D\DC2\223\ENQ\155\143\154\188\200\166\161k\GS\a\EM\241\155\\\130\r\RS\219CGcq3\172\206\163\160\141r\ACK~\167\249W\137c'\ETX\NAK\208\248\231X:\223\140u\ESC\160\217\137d\242\162\255\NULq>Q\249\224\159\198\185\245R\205\133\228\250f\190\255\NUL*\194\253[\v\CANu\221\250\179\202\173>y\182!\226\140\230\131\149$\DLEA\GS\141>\ETB\141%V\146?1\a\222L\145\145\245\GS+\209\&2\176#4gtnT\144A\199\FS\RS\181mnZ9-\221\226\181\149a\232\155@\f3\159\155n\t\235\250\n|v\150\183\&0\187\192\242#\175\204K\r\202\a\251@\f\175\215\145\244\170s\193\&5\187\133\149q\158U\129\202\176\245\EOTp\DEL\n\EOTi\205\175\206T\139hc\182,\STX\147\CAN\228\128\&8\172\189\251\217\218R]\219\146\236rsMV\SOHH\198Oj\213\211t\139K\204\249\250\156\&1\200G\201\n\130Y\143\212\128\160}Z\141\195c#\173:\150]\129\192@B\251\243M\CAN\227\154\ACKz\247\195MF\242\227\195\147\219\202\196\195k0\DLE\147\216\&0\201_\160<\255\NUL\192\171\188\129\221v9' \228f\188\159\225\133\252\169=\246\158\206\190CG\231*\158\165\178\a\US\135\242\NAK\234\145\200\&6.H\201\RS\181\241\EM\189>\\L\180\220\244\232;\211E/\NAK\220\ESC\219\b\188\203v\145D\203\251\164<\183\ACK\170i\150\235%\220\"T#\EOT`H\243|\191\157O\175G\230\233\226\&2\DC4\131*\228\&3\ENQ\a\241=+;I\183\133\245\b\NAKLbE\ESCUV\224\177\235\232\FSg\189eE%\135\178\211q\181\239\GS\212h\171q\EM\a'c\DEL\DC1=\215\214\138t(\226X\131\DC3\196m\219\221}\205\NAK\236d\207\253\145z\191\204\230\174\189\242\230\182\164\201\166\DEL\179y\147\255\NUL~e\US\214\149\164\242\225g\198J\140\224w\169\181hD\171j\DEL\185p\ESC\255\NUL\FSq\253j\a%b\251\173\233\211\167\189x\252G\SYN\241Q\211\167\234\205\240\223\SOH\203HIr[;\137\201\207\173Cu<\150\SUB}\205\242\163\DC3o\EOT\146\130\a\EMU$~\162\182\215Gc>\249\153\218\&2rp\135&\166\214m^\239C\191\182H\156y\150\178\162\142\153%H\NAK\195\n\150\156U\180\208\222OC\228\246$\146I\201=M]\176\182\178\185\153c\185\189\146\220\DC3\247\214\SI0\SOH\220\159\152\US\200\SUB\163\131\154\191\r\149\181\204D\199t\177I\211l\228\ENQ?\240,\231\244\199\189~\147\208\241\203z6\159aq\226{;+\235\176\246\146\202\DC1\229\139+\215\167Q\199\&8\207\227Z\255\NUL\DC2t\184\180\175\CAN\207\NAK\180q\197\ETXC\DC3\162'\NUL\r\160~<\131T\188\EM\225\153\252E\226Xl\227+\228\196\222d\242)\200T\a\156z\231\160\250\215W\241\170\&8\215[\211\bLJm\155-\158\171\184\224c\219\159\206\188\202\152\132\179\CANROx\187\174\222f\234\US\185l\243X\166xdYa\145\163\149\SOU\148\224\143\161\171_\218.\225\131m\141\156\252\251Tl\DELvN\153\247\ETX\252j\142>ZL\SUB\245\SO{\ESCV\145\217\205\&4k=\140\142\ETXfF\130m\170\235\145\211 \237\224\&7=9\FS\fV\239\136\"\208\237\180\232.\180\&6H\DLE\144\179Y\220I\186p\195\157\217\199+\239\197q \149\232q\248\210`\231\173R\149\174'\ESC\142f\249\143\&4\160\ft\166\241\223\EM\167\f\227\154\146\145\191\225\141Y,5\205\&4\186\164Q\199)\SI7;\138\182F\SI8\199>\149\237\129\178\a\210\190y\146%M\133eW\f\160\157\189\184\228\SUB\250+\194\250s\191\134\180\199\212\ETX}\164\219\161|\RSO\FSw\235\140W\204\231\240\140\DC4*\252\191S\187\n\239t\202\250\176i\180\245\t\179&D\206\252\237<\247\199j\165\167\152\196\177\136\238\180d\220x\DLE\140g\235\130+\163\213mbM1`\133Hg\153\&6\200NJ\156\231<u\199\167~\149\135\167\t\229\189+\GS\198\244\217\185\166\251\NUL\136G\130;\NAK\249\179\232+\197\161'*/\230o$\185\142\163O\182\144\\G!\154\"\fL1\DLE`:\175\171\SUB*m.9~\208<\201L\160F\195\152\188\188r\189\187\209^\246Q'\245U\175VsV^\249\210\220\216\220In\194\ETB\137&\FS\199#\174\224\141\140g\GS\248'\243\174~]\ETB\198\163>V\191\167\231<n\180\DC4Q^\205HE\187\180eOTV\151D\248\132H\242\188C\165\227\253\171_\254\198\163>\US\248\140\219s\226],g\175\250(8\255\NUL\199(\162\133N=\135-\EM\193\US\217\239Ty^G\214\172\242I \EOTlu\250T\135\246z\188b\\\235\150\225\137\201Q\t\218>\148QZ\144\146f\174\131\240o]\240\229\227\221i\158%\130\EM$O-\201\182\222\n\228\RS\135\232)u\255\NUL\131\154\239\137n\"\159U\241L\DC2\201\DC2lM\182A@\EM\207@E\DC4VN\149\&5?k\202\185\187\245\GS\223\195\208\200?\179\181\199o\DC1E\248\219\US\254*\151\254\EM\218c\215\196q\255\NUL\224!\255\NUL\226\168\162\182L\129?\225\157f\255\NUL\161\146?\252\EOT?\252]<~\206\175\223\196\139\248Z\DEL\246tQL\a\DEL\195;\SO?\226\164?\248\t\255\NUL\217\211\199\236\239\RS~o\DC1\183\225i\255\NUL\217\209E\STX\RS\191\179\196\NUL\228\248\142O\252\EOT\US\252]uq|=\241\DC40\172K\227\237D*\128\163\SYN\201\192\252\232\162\162Q\140\190%q\166\DC3|8\214nP-\199\142uW\nC\fF\131\EOT\FS\130=(\255\NUL\133m\170\GS\187\188q\173\176S\144\v/\a\242\162\138\159e\SO\200\\\204\218\208\252!}\165]\180\211\248\155S\190S\EMA\NAK\193B\160\228\FS\143\151\&9\227\US\141\DC4QW\SUBqJ\201\ENQ\217\255\217"
cooked_elvis_presley =  FreeForm "elvis-presley.jpg" "image/jpeg" raw_elvis_presley

raw_peter_gabriel = "\255\216\255\224\NUL\DLEJFIF\NUL\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\255\219\NULC\NUL\b\ACK\ACK\a\ACK\ENQ\b\a\a\a\t\t\b\n\f\DC4\r\f\v\v\f\EM\DC2\DC3\SI\DC4\GS\SUB\US\RS\GS\SUB\FS\FS $.' \",#\FS\FS(7),01444\US'9=82<.342\255\219\NULC\SOH\t\t\t\f\v\f\CAN\r\r\CAN2!\FS!22222222222222222222222222222222222222222222222222\255\192\NUL\DC1\b\NUL\138\NUL\150\ETX\SOH\"\NUL\STX\DC1\SOH\ETX\DC1\SOH\255\196\NUL\US\NUL\NUL\SOH\ENQ\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DLE\NUL\STX\SOH\ETX\ETX\STX\EOT\ETX\ENQ\ENQ\EOT\EOT\NUL\NUL\SOH}\SOH\STX\ETX\NUL\EOT\DC1\ENQ\DC2!1A\ACK\DC3Qa\a\"q\DC42\129\145\161\b#B\177\193\NAKR\209\240$3br\130\t\n\SYN\ETB\CAN\EM\SUB%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\225\226\227\228\229\230\231\232\233\234\241\242\243\244\245\246\247\248\249\250\255\196\NUL\US\SOH\NUL\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DC1\NUL\STX\SOH\STX\EOT\EOT\ETX\EOT\a\ENQ\EOT\EOT\NUL\SOH\STXw\NUL\SOH\STX\ETX\DC1\EOT\ENQ!1\ACK\DC2AQ\aaq\DC3\"2\129\b\DC4B\145\161\177\193\t#3R\240\NAKbr\209\n\SYN$4\225%\241\ETB\CAN\EM\SUB&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\130\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\226\227\228\229\230\231\232\233\234\242\243\244\245\246\247\248\249\250\255\218\NUL\f\ETX\SOH\NUL\STX\DC1\ETX\DC1\NUL?\NUL\240X\173.'\NUL\197\f\178\STXp6\161\&9<z\DEL\188?1\235]\ETB\132!x\245K\168\228FGX\240\202\195\EOT\FS\142\162\180\252\US\226\212\209\180\197\180]6\226\234\226\EM\222e1\183\203\181\158\217\155#\EM\227\236\192\SI\247\207\167\&1x{R\185\214\188I}}w\183\206\146\NAK\EOT(\192\SOHv\168\US\144\GSy\167n\163\179J\231R\173\DC4 <\206\145\174@\203\144\ACKkv\210 @#\144y\ACK\178\"\129?\181l\174.#2\193\SYN\239\147\176s\128\167\USM\192z\SYN\ACK\159\165\&4\218'\137\142\141u:=\173\210\188\182D\143\153N\238P\159l\RS?\SIjB:\152\161\192\233Nx\184\171h\156R:q@\CAN\215\&1\128\reM\242\230\183.\215\131X\183\by\160\ne\249\163x\168d}\167\DC4\221\224u\235@\SIi\b9\NAK=\181\241F\EM5U\185\EM\US\149Wv\193\200\160\SO\222\194\248\&8\FS\214\228\&2\134\STX\188\243O\189*\192f\186\237>\240:\142h\ETXw\173!ZdR\ACK\NAK>(\STX\DC3\197 <\211\221x\168\241\138\NUL\148\SUB*0h\160\SI\157\180I\238b\211\152Gu\r\156fo\245\164\STX\206\216\CAN_\160\254\181\175\225\179+\248\158\252\204\145\164\134 XG\247I\200\228}z\254\&5\202Z][\219\195\243\195\230\200[\163t\v\237\239]7\130LRkw\134 \194?$`7Q\200\226\182\157K\211Q;\171VR\195\198\157\246\243\DEL\150\223w\204\236\181\EOT\144i\ETB\SI\n\ETB\150\&5\DC2*\142\164\169\f1\239\197E\226\235\221?S\240\235_Aw\ESC8\DEL\181\217\220'\f\143\156\178\USC\159\243\154\218\182NEV\184\240\&6\135\169H^H$\139snt\134B\170\199\212\142\153\172N\DC3{\195\151\211j\158\US\177\189\157B\205,@\184\GS3\208\159\199\EM\173\&6^),\237\162\181\181\138\222\EOT\DC1\197\DC2\132E\GS\NUL\FS\SOHN\145f3!R\158V\211\184\DC1\201=\177@\EM\183I\193\172i\227\201\&5>\191\175\197a1\179\181\183\146\246\252\227\247\&1\240\DC3=\v\183E\174j\SI\DLE\201&\167ki$\214\179\207\&4\133%\138\220\US\220\225I?1'v\SI\RS\157h\STX\236\182\191\&85]\172\217\154\182\158,\211\150,\142Fh\ETX!mJ\142j\132\241\148\174\137\208\227\CAN\197f^F1\210\128\&1\209\204o\145[\186n\160T\128Md\180\&9\169aB\142\b\160\SI@\177\186\243\DC4\FS\214\170>V\185=*S\128+\162\133\248\160\v\132\212m\138M\217\164\205\NUL\EM\197\DC4\211\214\138\NUL\249Z\187/\135C:\181\223\253p\255\NUL\217\133q\181\218\252\&6\EM\213\239?\235\135\254\204(\ETX\211\160^kV\SO\NUL\170\&0\165hB:P\ENQ\200\205\&3Q\153\237t\171\187\136\151|\145B\238\171\215$) S\146\167\192e*\192\DLEx \208\a\rm\169[\166\153gi\167\222\218\207ss\SOH\216\215\a\230\146V\229\142\227\206r\221\&1\198N;\212\RS\ESC\240X\208\DC2K\139\151I\175e\234\234\&8A\220\f\215Kc\225\GS\SIK\191\&7\182v\t\GS\199\&8l\147\183=p\t\192\252+BT\200\160\fG\143\DC4\208\202\ACK\rhI\SI^*\148\176\226\128+HF\SO+>\226\&3&kG\202\201\197;\236\227\GS(\ETX\EOT\192\203\212S\226\143-\210\180\230\131\175\NAK\fp\DLE\212\SOH~\193\&6\145[\208\158+*\206\DC21\197kF0(\STXqO\NAK\SUB\154x4\NUL\164QKE\NUL|\167]\199\195!\157b\243\254\189\255\NUL\246a\\=w?\f\ACKu\155\207\250\247\255\NUL\217\133\NULz\188+\210\175F\181V\NAK\171\168(\STXU\169\SOH\197\&4\SO)q@\SO\206EF\226\157Mc\197\NULc\235\151\178i\186d\151\DLE[\155\137\247,qD\SO7;0P3\245\&5\207\203m\226\134)\190\254\218;\147\203[\165\184*\189\241\146rx\174\166\238\221.\237\158\v\129\185X\255\NUL\t \142r\b=\136\224\231\214\168=\169MQo#\147b,l\190X\201%\138\144\CAN\177$\240H>\248\197\NULsz\\\190,\133I\213,\173\228Fl\171d\169Q\245PEn\217^\193\168Z%\196\EOT\236l\140\RS\160\131\130*-b\ESC\232\208.\139w\n\128\&0\EOT\177\148\235\215!r\SI\215\138\139I\176\254\204\211 \179\SOd1\175\204\231\248\137\228\154\NUL\190\209\238\237O\134\215-\210\159\DC2\SYN\198j\252\&1\133\DC4\NUL\177B\DC4t\169\186P[\STX\170\205p\SYN\128-\239\RS\180\224\245\143\246\240\SIZ\154;\213=\197\NULj\134\162\170$\224\142\180P\a\204\&5\221\252-\EM\214\175\DEL\235\223\255\NULf\NAK\194W{\240\175\254Cw\191\245\239\255\NUL\179\n\NUL\245\232\151\138\180\130\171\197\210\172\ETX\138\NUL\146\140\129L/M/@\SIf\NAK\v=G$\219ER\146\232\SO\244\SOHbG\170\142\217\168\154\231=\234\DC36OZ\NUL\148\242iI\142\DC4i%\145cE\EMfs\128?\SUBdg&\184\255\NUL\137V\247\210\232\246\210A\188\218\198\228\206\ETB\240\218O\183_\206\128;\187+\155[\180-kq\DC4\192pLn\ESC\US\149^\221\180W\141\248\DC2\v\189\&6\228j\243\"\197b\251b\DC21\193bdU\224w\234z\255\NULJ\245\169%\199z\NUL\150Y\176\166\178\174ef\205L\242n8\205D\201\144M\NULfK#\f\156\213a\168\152\219\EOT\213\203\152\178qX\151\164\198N\209@\ESC\246\250\168+\247\168\174R;\150\EOT\231\&4P\a\152\215y\240\176\227Z\189\255\NUL\175\DEL\253\152W\NAK\ENQ\156\183!\140f/\151\174\249U?\153\NAK\217\252\&3\ACK-n\245I\EM\DLEc\131\159\226\DC4\SOH\236\DC1\183\189N\166\168\194\245q\SOE\NULI\138k}\218x\166\190\&1@\EM\215O\128k&Y\185\173+\210\NUL5\129;\254\243\173\NULO\230\DC3R\198\v\SUB\175\ETB\204Ei[C\184\142(\STXX\"&\159}g\246\189\&2\234\212\129\251\232^>}\193\NAKr(v\142\148\231\249E\NULp^&\241\ENQ\172~\DC2\139N\176\145b\187\156\198\134\CAN\144nC\209\212\142\163\a\245\197t\230W\242\211\204?>\ACK\236z\247\166]YYIx\183ok\t\185A\133\148\160\220?\SUBc\FS\154\NULxl\154\147y#\NAK\DC2\169\167\&1 P\EOTR\NULI\RS\181\151sh$'\"\180\\\230\163-\193\200\205\NUL`=\150\214\226\138\208\159qoAE\NULy~\132\229g\156\"\238f\133\149\148\184P\202H\EOTs]\SI\128ec\175\223\200\199\230h\201?\247\208\244\172\r\SOH\194\205*\186\r\142\155w\DC3\183\158\184-\216pO\225[\254\v$\248\143R<\231ku\CAN?\DEL\189\NULzlW\NAKz+\129\235XA\200\169c\184 \245\160\SO\133g\CAN\235I$\227\GSk!n[\GSi\254y=\232\SOH\183\210\156\SUB\192\154L\189j]\202\n\SUB\194v&J\NUL\213\178\249\152WKi\b\n\SO+\155\211\b\220\181\213\219\145\176P\EOT\219@\NAKR\225\176*\211\184\STX\179nd\201\&4\SOHFRY\141\&1\DC35 \\\147SF\152\235@\fT\226\146E\226\160\214\&5k]\DC3N{\219\166\249\ETB\133Q\213\219\176\NAK\193\199\170\235\222.\212\DC4D$\178\210\206C\NAK\200\CAN\255\NUL{\130O\233@\GS\196\202T\242\b>\245X\189Q\211 \138\ESC\153!\179\189\184\188\182\141q$\243J\\<\156`)\233\192\FS\227\215\218\175:s@\NAK\165a\154)eZ(\ETX\201\180\191=\252\248\226\149\DLE*y\167|>`\227\191\221\&8\192'\154\233|\STX\174u\187\255\NUL0\146\226#\184\156\228\157\195=k\ETX@\EOT\205v\NAKK?\217\216\128\CAN\r\192\DC1\149\193V\201\&5\209\248\b\159\248Hu,\144O\150rCd\US\156w\239@\GS\209Z@\184\230\167+\154P\153\DC4\NUL\145\158@\169\138\146)\129\&0zT\241\156\240h\STX\148\233\242\156\214,\235\181\141t\183\DC1d\FS\n\198\158\212\238'\DC4\NUL\150\DC3\NAKa]-\181\224*9\174Z8\204mZ\DLE\202F(\ETX}\238w\SO\181Y\137cU\226b\213m\DC2\128\CAN\145\243S\SOH\138v\192)\166\128\&3u\157\&6\195S\134(u;9nl\242C\249\EOT\137!$q\"\227\239c\161^\225\143p*\v\203g\186\211SL\179\143\236\214aDf}\187X\199\221Uq\144O\169\237\235Z\197\170\188\178\SIZ\NUL\167\ENQ\180\&6V\201o\STX\EOT\137\ACK\NUL\NAK\f\178\ENQ\205I<\225A\230\177\174\239\NUL\207\&4\SOH$\247\ETXwZ+\158\186\212\STX\191-E\NULqvZ\139YE4B\b\165I\176\CANH[\208\143\225#\215\191p+\168\248twj\247\164\NUL?q\208v\249\133qU\219\252\&3\255\NUL\144\181\239\253{\255\NUL\236\194\128=\NAK2\SO*\194\167\EM\168\DEL\138\172\197@\NULL\246\165\DC1\237\&9\197H)\198\128\CAN\199#\ACK\171\203\b \212\237Q=\NULf\188?1\165T\197N\253MG\222\128.\219\SOHZ\n\ACK*\133\183J\188\157(\SOH\\\241P;b\165j\169-\NUL6I}\234\141\197\192Py\169\166\251\166\177\239\t\199Z\NUL\171{}\128y\174j\255\NULS\b\SI<\213\203\226py5\201\234\fw7&\128\"\185\190y$\235EQ\239E\NUL\DEL\255\217"
cooked_peter_gabriel =  FreeForm "peter-gabriel.jpg" "image/jpeg" raw_peter_gabriel

raw_stanley_clarke = "\255\216\255\224\NUL\DLEJFIF\NUL\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\255\219\NULC\NUL\b\ACK\ACK\a\ACK\ENQ\b\a\a\a\t\t\b\n\f\DC4\r\f\v\v\f\EM\DC2\DC3\SI\DC4\GS\SUB\US\RS\GS\SUB\FS\FS $.' \",#\FS\FS(7),01444\US'9=82<.342\255\219\NULC\SOH\t\t\t\f\v\f\CAN\r\r\CAN2!\FS!22222222222222222222222222222222222222222222222222\255\192\NUL\DC1\b\NUL\150\NUL\145\ETX\SOH\"\NUL\STX\DC1\SOH\ETX\DC1\SOH\255\196\NUL\US\NUL\NUL\SOH\ENQ\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DLE\NUL\STX\SOH\ETX\ETX\STX\EOT\ETX\ENQ\ENQ\EOT\EOT\NUL\NUL\SOH}\SOH\STX\ETX\NUL\EOT\DC1\ENQ\DC2!1A\ACK\DC3Qa\a\"q\DC42\129\145\161\b#B\177\193\NAKR\209\240$3br\130\t\n\SYN\ETB\CAN\EM\SUB%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\225\226\227\228\229\230\231\232\233\234\241\242\243\244\245\246\247\248\249\250\255\196\NUL\US\SOH\NUL\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DC1\NUL\STX\SOH\STX\EOT\EOT\ETX\EOT\a\ENQ\EOT\EOT\NUL\SOH\STXw\NUL\SOH\STX\ETX\DC1\EOT\ENQ!1\ACK\DC2AQ\aaq\DC3\"2\129\b\DC4B\145\161\177\193\t#3R\240\NAKbr\209\n\SYN$4\225%\241\ETB\CAN\EM\SUB&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\130\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\226\227\228\229\230\231\232\233\234\242\243\244\245\246\247\248\249\250\255\218\NUL\f\ETX\SOH\NUL\STX\DC1\ETX\DC1\NUL?\NUL\230@\163\NAK\235>\NAK\240\SO\133\170\248j\202\250\234)\140\242\169,VR\a\fGO\194\182\135\195\US\r\DEL\207\188\255\NUL\247\248\215\ETB\177\147W>\154Y\165\bI\197\167\161\225\152\163\NAK\238\159\240\172\252\&3\255\NUL>\179\US\251l\212\239\248V\190\CAN\US\242\231)\255\NUL\182\237\254\&4{\t\139\251_\SI\217\255\NUL_3\194v\209\138\247q\240\219\195\US\243\227!\255\NUL\182\239\254\&4\191\240\173\252/\255\NUL>\DC2\DEL\223\247\255\NUL\SUB>\175\&0\254\216\195\246\DEL\215\204\240m\181\191i\165Y\\\217\&4\146]\195k20\SOH$R\219\215h$\227p\231\147\245\237\210\189h|7\240\191\253\ETX\223\254\255\NUL\191\255\NUL\NAKO\US\SO\252\&08\254\207\DEL\252\b\147\255\NUL\138\173i\211pwi3\159\DC1\153R\170\146\131\148\DEL\175S\201\159G\177\130\238\NAK}F\218h\GS\194\179E\DC1\EOT\frO\204q\143\165H\250\r\138\196\FSk\SYN\140w\FS\198\182\228\144\&3\215\151\250q\239^\173\255\NUL\n\247\195 \US\248\151\&7\254\EOTI\255\NUL\197R\255\NUL\194\190\240\192\255\NUL\152a\255\NUL\191\242\DEL\241U\182\159\200\191\175\145\201\245\181\255\NUL?%\253|\207#\185\209\237`Dx\239m\238I\145T\198\144\144pX\ETX\206\227\208s\154\231\177^\251\255\NUL\n\251\194\255\NUL\244\v\255\NUL\200\242\DEL\241T\DEL\194\190\240\191\253\STXG\253\254\DEL\254*\176\169I\205\221$\142\172>eN\146jNR\251\191\204\240\FSQ\182\189\255\NUL\254\NAK\255\NUL\133\243\255\NUL \149\255\NUL\191\175\255\NUL\197R\255\NUL\194\191\240\191\253\STXS\254\254\191\255\NUL\NAKS\236$t\DELlP\254W\248\DEL\153\224\SOHkGO\208u-P\143\178Z\179\130q\184\144\171\208\158\167\ETX\162\159\202\189'Z\240\198\138\154\180v\150\SUBl1-\186\249\215\SO\242\&7\205\232\156\183\FSe\137\193\199\EM\226\169\205\175]\201#Gc(\181\178\139\"\ah\215\&2\DC3\221A\227\US{\RS\205\140\SO\148J\DLE\164\185\170\&3X\227g_J\DC1\251\206\SO\243\195\218\157\132/5\197\171$i\183sd\DLE\t\206\a\a\175\ACK\179\b\193\175I\185\185\212\219l\DC2\201\246\235f!\220H\129\&3\142\128\&2\140\231\234\SIOAY\158%\209\237.\244\216\245}5\SYN4\242\247\200\172\202\152\NUL\132\n\168;\140\FS\242~\166\148}\157X\243SeG\DC1R\DC2Q\172\149\159Tq8\162\151\154*\SO\253\SI\160|\ENQ\255\NUL\"N\155\254\235\DEL\232m]%q\222\v\213\180\219/\ACK\233\145]\234\SYN\182\242\DC4r\SYNY\149\t\ESC\219\156\DC3\236kw\254\DC2=\v\254\131Z\DEL\254\ENQ'\248\215l~\DC4|^#\248\210\245\DEL\153\169HzV_\252$\154\ETB_\237\173?\US\245\244\159\227I\255\NUL\t.\129\131\255\NUL\DC3\189;\255\NUL\STX\211\252i\152\154\180\181\144|O\225\240Fu\205;\255\NUL\STX\211\252h\255\NUL\132\171\195\223\244\FS\211\DEL\240)?\198\152\SUB\221\169k2\SI\DLEh\183S\164\SYN\250\181\140\211\&9\194\199\GS\194\179\&1\246\NUL\214\150\ENQ\NUL'cKA\ETX\ACK\142(\SOHi;Q\197\FSb\128\SYN\147\185\163\ETX\210\128\a<R\ETX\202\188C\168O\r\223\137Q!r\234\227t\139(O\145\145Tdc-\129\146\&0x\170\RSE\188\&6R\222\tZW\146\&0N\211\242+\SI\DEL\\\240=3]G\139\236\ESCO\212\206\178\"\243,.\162\251=\250`\156\f\DLE\174q\219\a\EM\237\239\\\132\182\ETB\150\SYN\222\\0\189\254\153'1K\NUL\222q\212\ACK\v\206G\168\174\\m\tU\140\\:\USA\150\215\132\NAK\164\236\157\191\225\139\144\182\219c*G#\"\ENQ\216\&0p\202\&3\156{\157\185\199\160\RS\166\169\190\161\&46\186\191\217\161\130KX\198\246yc\\\171H\152*2s\219\160=\249\205\&3\237\151\215io\NAK\181\148\171\184\136\209\228\143\202\143q\227\150=x\CAN\199\181Q\214\174\DC3O\210\SO\149m(\156\180\129\239'A\242\151\234\ETB=\250}\ACK>\181\150\a\SI:Ru*i\253\DEL_y\209\138\156*\218\156\GS\219g9\154*-\212V\156\199u\142\173\188\&8\250\237\142\140-\225\150YV\205\137\b\DEL\132M'\245\"\162\DEL\135\215\209I\FSm\167\\o\144\144\128\176\249\184\201\253+\162\208\245#e\164h\171\DC4Nfx\200\223\CAN \237\243\165\220\t\a$p\SO+\165\SUB\210I\226\239:Ho\SUB\206?\245syrm\\\198\ACK6c\215<\227\189z\244U\169\175u=\SI\138\197?\223\207^\172\242\211\225 ,\228\187\&0K\228F\254S>\254\ETXz~\181z\207\225\213\245\253\162\220\219\216H\208\176\200-(R\195\216\DC3]\214\165\173Z?\135.\DC2]#\200\255\NULI\EOT\192\177\&2,\171\199\205\187n\SOH?\159\NAK\209\233Z\173\190\175\166\192\&4\233\150\EMbA\152\FSc\NUL\f`\143OqZTj0\191\179[\152\173]\174x\237\183\129.\175\EOT\159g\211\167w\138M\146\STX\248\218}\b&\164\185\248u\168\219\219I3\233\147*F\165\217\140\171\128\NUL\228\245\250\215j\254#\212\236<@l^\DC4\130W\185E\152\168\EOT88\EM\206\&9\200\199<V\143\141<Ey\163\221\165\189\185\ENQ%\131%H\CAN\201$\RS\217\233\232E>V\228\162\160\181\v\249\158a\225KX\237> \232\241\196\139\143\&0\FS\151\231\161\175\161\t\198\&3\138\241\221\SI^\134_\CAN\233\150gK\211\163\146I\DC4\172\162\&6\DC2(\231\167n\221O\173{\RS=\235\138\162\180\218\181\141V\192s\131Fh$z\212sM\FS\n\SUBY\NAK\ETB8\201\&8\172\199k\146s\154\&9\199J\171wq\229YI4n\191w!\139\NUL\a\190O\NAK\152\154\164\236c\220\225\NAK\201\249\217\n\129\158\131q\CAN?\157L\166\147\177\164)JJ\232\221\231=\a\231HN\208I\192\ETX\222\161\150\230\&8\155k\ETB'\EM\194\161o\228+\195\190(x\182\235P\215$\210\173\229t\177\182\n\EM\ACKG\152\228\STXI\RS\217\198\SI\165;\171\216\207\149\218\231\186~\238x\136\249$\141\134\b\206A\174Z\227\192v\209\220<\250E\245\206\150\239\247\146\"\SUB3\255\NUL\SOH5\227\158\DC3\188\215\180\171\180\212\244\241!\130\DC2\166X\183`H\133\130\227o~\189\DEL\194\190\144\FS\247\167\EMv)JP\216\226O\128&\189\218\186\174\189uu\n\158#\138\&5\132\US\174\&3X\191\DC2\244\187=\US\194\186u\173\141\186A\n\220\253\213\238v\158I\238k\212\aN\181\231\159\ETB\DEL\228\SOHc\255\NUL__\251+TUo\146\199^\SO\164\165\136\133\223S\199(\165\230\138\228>\164\237\236\175'\177\211\180K\155i\nM\GS\188\133[h \US6Q\208\213\243\227\141|\ETX\155\226H\255\NUL\166)\255\NUL\196\211t\175\NUL\207\226\175\SOiW\145\234\198\205b\137\226\217\229\SYN\207\239\\\231\239\SI\239c\240\167O\240r\250\&8\v\197\226\ACK\150A\209<\130\&3\159}\255\NUL\141{\DC4q0\141\&8\169B\246G\197\226\169\183^m>\172\171\168x\151U\213-\RS\218\246\233\164\132\144\197Dj?P+\167\210\252k\163\219Y[\172\218kG=\178l\143\202@G\190\t9\EM\172Q\240u\196\162\&3\226\150\223\142\159f9\255\NUL\209\149J\247\225\156V3\249\&3x\150\228\190\SOH\249l\207\233\153\&9\252)\212\197\209q\179\141\151\169\156(NN\209\213\140\190\214\155P\241\b\213$B\159\191W\b\SI\240\174\&0>\184\NAK\169\172x\151N\213\181\152.\238\236${hc1\188;\240X\242A\200\250\212S| Kx|\233\188S\"\199\215&\215\255\NUL\179\168&\248W\DC4V\169:x\130\226\225\CAN\224l\183\ETX\249\191J\169ci\171{\187.\225\SUB\DC2\150\221L}\NAK\212\252I\210\n\239U2\130\171\140\224e\187\215\176\248\139S\182\211\227\182Y\146Y$y2\137\DC2\229\142?\253u\194h?\SI\160\210\174m\181\167\214\231o\178\183\152\208\152\&2x\250\&5vih\150s\218\153\230\v\182)\SI\153'\a\150S\235\250d\215\159^\175;mu:\240\244\148e\239\244\233\223B\220+nm\155Q\tr\129\DC3q\138A\180\252\188\227\USRj\140?l\213\252\185u;D\132#\135\133\"\147,W\223\EM\246\244\173\v\164\132\233\&72G!t0\177\EOT\US\151\167`8\170:L\247W\ETBL\254m\185\211\215\228\141\DC1[y#\191\FSc\243\172d\245Q5\135\193)\174\158\183^HO\179\234\DC2k\188\\\152\173 E+\SOH\219\207P:\231\158:\214\149\236\179\DELg\204\166\DLE\192!\201\206s\255\NUL\142\227\244\168.\181\b\244\235\155\153\164Ivl\140a\DC3'\171v\FS\212\211\204.4\185\FS\FS\135\132\144\164\144FGq\138\DC3\178j\228\205\202N2q\211B;qwen\210\220Ld\196|\135n8\GSzW\144\248\207D\147P\241\ESCj\210\198\177[\220\194\178I\182@YH\NULt\235\211\US\173v\190-\241T\214Z_\148\150\190T\151\nUX\187\DLE\160`\RS\b\ETX<\143Q^g.\165/\SO\238Y\241\247\152\228\212\&7/\178\204j\213PmJ7\145\208\248\&2M;R\241\GS\173\172v\144\143 \134fR\197\152 \EOT\USN\160{W\176\190\165i\FS\222[\202\NAK\188\179!\200\198\DC4u5\226\RS\DC3\215$\182\241\DC4R\STX\145\168S\230\&6\222J\241\199\RS\248\175d\186\152\223\232o.\159\&0,Sr\DC2s\200\231\a\249U\194\\\169\165\190\227\188\170\165\&9\171-\141(g\142x\132\145\&8t=\b5\193|]\255\NUL\145v\203\254\190\191\246F\174\155\195N\210XH\197\178\187\240\a\167\STX\185\175\139\191\242.Y\255\NUL\215\216\255\NUL\208\SUB\173\207\158\151\&1\190\SYN\FS\152\184\199\179<j\138(\174s\234Ox\248y\159\248A\172\136\201 \201\208\255\NUL\182\213\190/Udhn\EMb\145S\DEL' \174q\156\215\&9\240\249\246x\RS\209\130\151!\164\194\134\193?9\252+Z\ESCk\137\239f\189\154D\134F\140E\fj\219\202.rI\236I\173\238\210V>R\172\DC3\171\&7.\239\243\GS\169^Aey\FS\178+H\225w`\US\186:g\EM\231\169\233\239P[jVz\149\226\198\DC2U\150@N$V\GS\a\166\239\175\228j\198\177.\162\145Dt\244,\229\176\227n~\\\RSy\USJ\172\208\234e\179\148\b\FS\159\152\177\200\206Go\195\245\168m\243i\177P\140]4\222\254\191\165\139\215\t3\222\219\218\141\134\223c3\141\128\244\192\ETX\147\239\250Tw-mh\SYN\SYN\139p\234\DC4\176\n\184\255\NULd\DEL\135\243\169\188\153Z\241\165\242\228\198\192\SOH\200\245>\164\255\NUL*\138\228\173\163\EM\158,\187\NUL\185\nXc\223\CAN\STX\173\222\215\&2\139\213!\186\148\138\250\&5\212P\168\207\148\195j\SO\156\DEL\158\213\NAK\245\156\SUB\140\144\219\221 \145Y\ESC+\147\193\202\255\NULw\252j\221\131\201y\ETX}\162\217\145\&9\CAN$ma\236\&8\227\234*\255\NUL\148\158b\190\208\n\130\a\176\&8\255\NUL\n|\156\218\139\218:n\203us\157\184\209\133\166\143s\CAN\185\184[h\227v\DC1\ETBTA\193?\194\&2G\212\213\152um) \142\&4\190\136\"\140\EOT\128`~\149\182\202\GSJ\176\EOT\DC1\130\SIz\STX\133\NUL*\128\a\165?eg\238\131\196s\171O_\235\208\200\211\166\178\189\189\187\146\219\SO\170\168\164\149#\159\155\214\172\182\158\236\165\r\245\199\148\DEL\128m\FSzg\EM\254\181x\f1\226\151\181R\130KS9T|\215\143\249\158_\241\&6+t\177\180\138$\195B\199n=\t\EM\254@\215\152\202r\160W\172\234\240[\235\158\&7\SUBU\195\149@\142\n\145\212\236\200\199\243\252+\202&\133\225\153\226u\249\227b\172=\193\197s\194\238\237\247\SYN&\n./\186;\191\134\SUB%\166\171\SO\177\246\164\201\STX$F\USy3\184\228\US\192WQse\172xu\GS\162\DEL\180Y\DLEAx\215\f\131\220\DELZ\195\248G#-\230\167\DC1\CAN\SI\SUB?\228H\254\181\234\213r\163\SUB\138\251\&1\208\196J\154\182\235\177\207\248D\249\154KL\SOH\DC1\188\135f{\128\NUL\207\231\159\202\185\255\NUL\139\DEL\242,\218\DEL\215\216\255\NUL\208\SUB\187\250\224~-\255\NUL\200\177k\255\NUL_k\255\NUL\160\&5S\135%.^\199N\SYN\163\169\139\140\159Vx\205\DC4c\222\138\231>\168\247o\134\192\US\ENQZ\240\&8\146O\253\b\215]\\\143\195_\249\DC2\173\191\235\164\159\250\NAKu\216\174\200|(\248\236W\241\167\234\197\170\DC3\233p\220Jd\146II#\CAN-\144>\158\149~\146\169\165-\204\163'\GSP\216\227\DC1 E'\ETX\212\228\211\169i8\166H\180QE \n(\164\160\ENQ\164\162\140P\a\SOH\227\GS:\230\211\197:>\181f\133\139\220G\f\128w9\192\252\193\199\225]\ETB\252!\158\FS\201'H\182$\245\249kZ\238\DC14J\165A\218\232\224\USU`\DEL\165\DLE\\,\140S\144\195\156\DC1\142*\DC4Rl\185\&7$\175\208\169\167x\DELJ\210gy\172,\227\183\145\215k\DC4'\145\156\244\173.\244\180\159\133^\196\SOH\232k\130\248\180?\226\150\182\255\NUL\175\197\255\NUL\208\RS\187\223\194\184?\139#\254)[\DEL\250\252_\253\ENQ\235:\191\ETX:\176?\239\DLE\245<Z\138Z+\148\250\227\221\190\SUB\DEL\200\151o\255\NUL]d\254u\215\215\US\240\204\255\NUL\197\EM\a\253u\DEL\231]\133v\195\225G\199b\191\141?V\DC4QEQ\128QEr\RS/\212\181k\ESC\203u\211\229\149\DC1\163%\130F\ESC\156\251\131S)$\174\&4\175\161\212\219K4\171!\150\DC1\SYN$eA\187;\148\RS\ESC\167\EM\244\169\170\150\145,\211h\246r\220\DC2fxQ\156\145\130[\FS\213\218b\n(\164\160\ENQ\162\138(\SOH\SIj\165tY/ \145A\192l1\250\240\a\245\252*\237U\152y\151\DC1\ETX\247Cp?\\\254\148\152\209n\147\156\208\189)j\132\NAK\193\252Y\255\NUL\145R\SI\250\252_\253\ENQ\235\187\174\ETB\226\191\252\138p\255\NUL\215\218\DEL\232-Y\213\248\EM\213\129\255\NULx\135\169\226\212QEr\US^z\247\130<G\167h\190\DC1\181\142\242GV\146I\EMv\161n3\237]\a\252'\154\ETB\252\246\155\254\253\SUB\242\168\219\RS\GS\211~\178\255\NUL\232U\\I\130y\235Z\170\146I#\228\177\&0^\218^\172\245\239\248N\244\&3\210i\DEL\239\217\173\189>\254\rN\202;\187bL2gi#\a\130A\254U\224\187\205u\SUBO\142o\180\141\&2\ESC\CANmm\221#\221\134|\228\228\147\216\251\213\198\167s\158P\236z\229\NAK\229\255\NUL\240\179\&5O\249\242\179\a\254\ENQ\254\&5\DC3|O\213\212\224Y\217\DEL\223/\255\NUL\197V\158\210$\242\&3\213h\175(?\DC45p\SI\250%\143\253\242\255\NUL\252U4|Q\214O\252\186X\DEL\223\SI\255\NUL\197R\231A\200\207Y\162\188\152\252O\214{[X\DEL\223\183\255\NUL\226\169\167\226\142\181\207\250\&5\135\253\251\DEL\254*\159:\SOFz\221\NAK\227\255\NUL\240\180\245\204\241oc\244\242\219\255\NUL\138\169\ESC\226f\190\141\181\237l\145\186\149x\\\US\203u\FS\232V=l\245\NAK\t\140\253\169[\141\160\DC2>\181\197\248\&3\198\SUB\159\136\&5\185\237/c\182X\227\128\200<\164 \231r\142\228\250\214\239\139\&5[\157\ETBFk\219@\134Uu_\222)#\EOT\251\DC1E\213\174\SYN6\227`\219\128\CAN*\216\&4\250\230\188\ESC\174M\175i\243\220\\\249b\226\&9v8\140`\DC1\128A\198~\163\240\171\158(\190\190\211\&4I/l|\189\241\&2\151\DC2.ARp{\251\138|\202\215\DC1\179\\\US\197a\255\NUL\DC4\156D\159\249zN?\224/Xq\252A\215\228\157\"AhY\216*\254\232\245'\ETX\189\&3\198w\250\197\215\134\174 \213\214\ENQ\150\ESC\152\EM\EOTC\179,\158\254\213\141J\177k\151\169\215\130\139X\136?3\205\168\166\230\138\192\250\211\172\130\EMe\240\246\158cB\192<\185\199\212Uv\178\185\201>[V\190\143\FS\207\225\155\&3\DC4N\248\150Q\242\169?\221\171\USe\187+\147\EOT\199\211\228\&5H\249lW\241\165\234s\191e\187\220\DELt\199\&8\255\NUL\nSow\199\238_\242\173\243ow\156\139i\191\239\131P\181\181\233l\139Y\243\254\227U\\\231\&1\r\189\215x\155\242\168$\182\187f\255\NULT\245\208\ESC[\236\DEL\199\165\199\253\251jh\180\191\255\NUL\159+\129\255\NULl\154\152\244\&9\246\178\187\193\253\211\fR\v\ESC\209\130!n\181\209\155+\227\210\210\227\254\253\&59mo\193\230\202\228\255\NUL\219&\255\NUL\nwb\178\&9\193cxzB\223\165\&4\233\247\131\US\185o\204WN-/\249\255\NULB\185\255\NUL\191M\254\DC4\243c\168\&6\SI\216\174\DEL\239\211\DEL\133\ETBads6\150\147Gw\ETXM\SYN\212\DC2\166\226\216\198\&2:\215i\226\r\no\DC1\248\145n\180\180\141\&4\195\DC2\169\187#l@\174s\131\223\240\172\246\211/\228B\173au\207\164M\254\NAK?\216\181W\180\251\&9\182\188\DC1\fb5\133\149I\192\EM \SOO\STX\170\250jM\181-|=\133\172\188oyl\238\142E\179\168d9\r\134^G\181v\158\&2V\159\195\ETB\138\138\167\133\251\222\204\t#\242\174;C\138\243L\214!\212\SO\153v\198\&4d*\177\&0$\DC1\211\167\174*\255\NUL\138\&5\rc_\211\219O\183\211n\173m\228\192\149\196l]\198s\180\FSp(\186\229\179%\173J\223\SO\231\146\211^\185\178\144m[\136<\197\201\234T\241\143\192\154\244[\235H\181\ESC\t\237%'\203\153\n1S\206\ry\150\153\167^\233\215\&6\DC3\174\159v~\199\247q\ESC\STXF0Fq\233]\ENQ\255\NUL\136\181\233m\154-;I\158\221\200\255\NUL]$E\200\250\r\160g\235\159\165\DLE\154Q\179\t-t8I4{\205?\\KiS\152\174Uw\228r7\f\FS{\140\SUB\232\190$\196R\206\253\182\128\165\237q\143\164\181\131\SI\134\181\182\214?\180/\191\180.f$\150\&2F\199w\CAN\231\138\185\226Hn\162\240\149\217\185\134h\243s\SO\223\&5H'\SOH\253z\214\&2:\240\139\247\240\245<\235\DC4R\209P}^\133\203}N\254\214/.\222\246\230\CAN\243\157\177\202\202\&3\244\ACK\165\254\219\213O\252\196\239\DEL\240!\191\198\138*[drE\244\DLE\235:\161\255\NUL\152\149\231\253\255\NULo\241\164\254\216\212\255\NUL\232#y\255\NUL\DEL\219\252h\162\139\177\251\&8vA\253\175\169\DEL\208F\239\254\255\NUL\183\248\209\253\175\169\DEL\208B\239\254\255\NUL\183\248\209E+\177\170p\236'\246\182\163\255\NUL?\247_\247\249\191\198\147\251SP\255\NUL\159\235\175\251\252\223\227E\DC4]\135\179\143a\DEL\180\245\SI\249\254\185\255\NUL\191\173\254\&4\159\218W\255\NUL\243\253s\255\NUL\DEL[\252h\162\139\176\228\143a\SO\163}\255\NUL?\151\US\247\245\191\198\147\251B\247\254\DEL.?\239\233\255\NUL\SUB(\167v5\b\246\DC3\237\247\159\243\247?\253\252\&4\ESC\235\179\255\NUL/S\DEL\223\195E\DC4\211\US${\t\246\219\175\249\249\155\254\254\SUBCws\255\NUL?\DC2\255\NUL\223f\138(\"\203\176\159j\184\255\NUL\158\242\255\NUL\223f\154\243\203\"\225\229v\EM\232[\"\138)\220vH\138\138(\160\SI\255\217"
cooked_stanley_clarke =  FreeForm "stanley-clarke.jpg" "image/jpeg" raw_stanley_clarke

raw_zz_top = "\255\216\255\224\NUL\DLEJFIF\NUL\SOH\SOH\NUL\NUL\SOH\NUL\SOH\NUL\NUL\255\219\NULC\NUL\b\ACK\ACK\a\ACK\ENQ\b\a\a\a\t\t\b\n\f\DC4\r\f\v\v\f\EM\DC2\DC3\SI\DC4\GS\SUB\US\RS\GS\SUB\FS\FS $.' \",#\FS\FS(7),01444\US'9=82<.342\255\219\NULC\SOH\t\t\t\f\v\f\CAN\r\r\CAN2!\FS!22222222222222222222222222222222222222222222222222\255\192\NUL\DC1\b\NUL\150\NUL\150\ETX\SOH\"\NUL\STX\DC1\SOH\ETX\DC1\SOH\255\196\NUL\US\NUL\NUL\SOH\ENQ\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DLE\NUL\STX\SOH\ETX\ETX\STX\EOT\ETX\ENQ\ENQ\EOT\EOT\NUL\NUL\SOH}\SOH\STX\ETX\NUL\EOT\DC1\ENQ\DC2!1A\ACK\DC3Qa\a\"q\DC42\129\145\161\b#B\177\193\NAKR\209\240$3br\130\t\n\SYN\ETB\CAN\EM\SUB%&'()*456789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\225\226\227\228\229\230\231\232\233\234\241\242\243\244\245\246\247\248\249\250\255\196\NUL\US\SOH\NUL\ETX\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\SOH\NUL\NUL\NUL\NUL\NUL\NUL\SOH\STX\ETX\EOT\ENQ\ACK\a\b\t\n\v\255\196\NUL\181\DC1\NUL\STX\SOH\STX\EOT\EOT\ETX\EOT\a\ENQ\EOT\EOT\NUL\SOH\STXw\NUL\SOH\STX\ETX\DC1\EOT\ENQ!1\ACK\DC2AQ\aaq\DC3\"2\129\b\DC4B\145\161\177\193\t#3R\240\NAKbr\209\n\SYN$4\225%\241\ETB\CAN\EM\SUB&'()*56789:CDEFGHIJSTUVWXYZcdefghijstuvwxyz\130\131\132\133\134\135\136\137\138\146\147\148\149\150\151\152\153\154\162\163\164\165\166\167\168\169\170\178\179\180\181\182\183\184\185\186\194\195\196\197\198\199\200\201\202\210\211\212\213\214\215\216\217\218\226\227\228\229\230\231\232\233\234\242\243\244\245\246\247\248\249\250\255\218\NUL\f\ETX\SOH\NUL\STX\DC1\ETX\DC1\NUL?\NUL\241\ESC\203\219\195\168\220*\220\206I\149\128\STXC\235[6\222\NAK\241\133\224\204\SYN\215O\244\184_\254*\185\235\210F\163rA\193\DC2\183\243\&5sI\241\SYN\167\162L\210\216\206\DC2F\CAN,\200\FS\227\208g\165\&5n\165;\244\&4&\240\247\138\173\220\164\208\220\163\SO\160\220\SI\254*\132\240\247\138\156\225b\184?\246\242\191\252Uk\233> \241\143\139\245\&4\178\182\158\&7p7<\130\221\DC4F\131\169b\a\255\NUL\174\187d\DC3i\238\"\149\203\149\251\206\224\STX\199\215\138\222\157(\205is\158\165Y\195{\RScu\160x\166\200)\185\142\230=\255\NULw7\NUL\231\242j\168\214Z\234\f\179\\\143\251m\255\NUL\215\175dmh\192\129bA-\195\156(#<\250\213{\171(\175.c\183H\EOT\215\140\187\167fbD\DEL\239\DC1\252\135\208V\209\194\199\173\200\250\204\186\RS>`\214\151\171\\\255\NUL\223\223\254\189\&4\166\176:\201s\255\NUL\DELO\248\215\166\220\233\246\241\200a\251\&8\220\188\STXO-\234z\240+6\234=>4!\NAK\GS\135\161<\159\229\138\211\234P\238\195\235\&2\236pD\234\163\172\183?\247\244\255\NUL\141\&4\203\169\SI\249mq\255\NUL\DEL\SI\248\215M,(I\194\138\165,+\233I\224\226\186\150\171\183\208\195\&7W\227\173\197\199\253\252?\227L\251m\239\252\253\\\DEL\223\195ZRD\185<Ug\133s\247k\ta\173\179\&5\141K\149\190\221y\255\NUL?S\255\NUL\223\195G\219\175?\231\238\DEL\251\248\DEL\198\158\209(\237Q\148\RS\149\139\164\209|\194\253\190\243\254~\231\255\NUL\191\134\129}xN\ENQ\212\255\NUL\247\240\212{9\198*\245\157\145\149\192U\228\209\nNN\194rI\SYN\244\216\239\174\229T[\139\134$\255\NUL}\141v\208\192\246V\197|\215.>\251o'\RS\212\186n\151\253\143g\187\NUL\\\186\229\201\US\234W\211\234{\254^\181V\230r\DLE\134%S\EM\201\FS\177\174\232\197EY\CAN\183}\206\179\225\213\203\191\138\231O1\138\253\137\207'\191\153\US4UO\134l\205\226\235\142\b\255\NULB~?\224q\245\162\185\235|EEhx\229\247\252\132.\DEL\235\171\DEL3U\234\197\247\252\132.\DEL\235\171\DEL3U\235\144\216\234<7\227K\191\SO\162Ao\ENQ\178\196[2\184\140\151\DELs\243\f\159A\192\174\175P\248\145\162\222\168\"\210\245$=IT\235\255\NUL}W\150\246\164\173#VQ\216\137R\140\183=R\GSS\237\144\195<:]\203G(%\CAN\172cp\USV\246\239Z\182\186\140*\172e\208\157\194\242\252@p=y\DELz\242\197\241\&6\176\136\168\183\174\DC1\NULUP\171\133\NUL`\NUL1\199\DC4\159\240\146\235\US6o\164;\215kd\ETX\145\233\211\216WO\214SZ\223\240\&0\250\187OK\RS\171s5\132\156\166\137<e\134~\236\FS\fg\254zp1X\183\ESCTn\SUBL\192g\ETX\">x\a\179s\193\NAK\196\159\SYN\235\165@\254\208a\129\128\202\138\ESC\166:\129\158\148\217<S\173J\187d\191v\239\146\139\158\128u\198z\SOHN8\164\187\254\ETXt\EM\211\187\ACK\SOF\157 \nH9\b0\DEL\239\175z\167\"\238?\241\225 \252\DC3\233\235\\\251x\135U`A\187#=v\162\140\247\236=\170?\237\173G9\251K\DEL\223#\252*\254\185\SI?\192J\132\141\167U\EM\197\169\199\252\ETX\252j\164\141\DC1\255\NUL\150\f?\224#\252k4\234\183\167\173\195~\NUL\n\136\222\\\RS\178\US\200T\188T<\255\NUL\STX\213)\ETB\220\167h\159\242\US\227U\229e\254\225\US\128\170\230\234c\255\NUL-?AK\DC1\146i0[\"\179u\148\180E\168[r{xL\174\&0\SOOj\239\252\&9\164-\149\176\191\157\&2\255\NUL\242\197H\234\DEL\189\248Vo\133\244\US\182M\230\202\&6\193\CAN\221!<q\233\248\215Ay)y6\177\219\SUB\140`q\129\216{g\249WDc\202\173\212\205\187\234Gqt\ESCqy\NUL\136e\143r\199\219\249\SI\255\NUL]e2\203uq\192>f\236\237<\136\199\248\212\222\\\247\DC2\135\133Iv \160^q\216c\249WA\GS\164:\RS\157\230J\162K\147\201\249\184\207\191\249\250S\147Q\DC2\212\215\248yh,\188E\"\156\130\214nI\199$\239\143\&9\255\NUL\n*O\SOHEus\226\185\174n]S\SYNN\139\DC2\175\221\ESC\208\228\250\SUB+\142\167\196j\143\EOT\190\255\NUL\144\133\207\253uo\230j\189X\190\255\NUL\144\133\207\253uo\230j\189s\154\ENQMk2\219]G3D\146\132`J?F\246\&5\r\DC4\f|\210\tgy\STX*\ACKbv\175A\237L\160Q@\SOH\199\CAN\252h\162\138\NUL\\\240\a\FSS\146\"\200\\\156(\239O\182\183k\137B\142\as\232*y\162y\156Eo\EM1\167\RS\217\165}K\141\&6\227r\149(\EM8\254\181ut\187\130\&9(\SI\166i\146\233\151Q!\DEL/z\142\165\SOqB\146c\149\SUB\145Wqv*\SOH\147\138\222\209t\199\185\157\DC1T\150b\NUL\ETX\185\172\187;s,\131\138\245\SI\ni\209\216X\182\161*ns\148\133{\147\208\159\233\249\215n\RS\157\151;9jK\236\163O\236\233\165\233Km\RS\n\167\&2\DEL\211G=\a\249\236=\235\EM\209\238nY\v\SYN\v\150\144\175\175~\159\149_\158\230I\157v\178\182\210Q9\192\&2\US\188\DEL\250\254\194\186=\USJ\130\209AF\DC2H~w\144\STX\a\174\DC4z\SO?J\213\203\145]\238f\149\244*i\186a\176\182\SI\"*\206\248m\185\206\220\142\a\229\249\SI\169\205-B@\211\249Q~\241\212\141\236FN}\135\175\242\252\235\164\191\178\184ky$B\168B\146\EM\207\DEL\254\183\244\NAK\231\243jV\246\146l\181\144\207/9\144\244.}\ACK3\199\&5\157\&4\229\169M\219C\189\240\f-\253\187+}\223\244V\224\DC1\142Y=?\157\DC4\239\EOT;C\172,\SO\223\&8\179b}\190t\255\NUL\SUB+\EM\223\152\180|\237}\255\NUL!\v\159\250\234\223\204\213z\177}\255\NUL!\v\159\250\234\223\204\213z\192\208(\162\138\ACK\DC4\170O \NULr1N\142\&2\231\218\173\197jO;\DEL\SUBM\216\168\194R\216\167\177\189)\209\193$\142\168\138K1\192\STX\182\160\210\154@Y\142\216\199\222o\240\173F\SYN^\USU\SI\t\146\245\212\US,\159\184?\218=\190\131\154\202U\146\210:\179\178\&8\EM%\205Q\242\196e\142\140\241\219\249k\RSOWc\211>\153\169d\211d\132r\NUL\ETX\219\STX\164:\157\229\212Jc\145\163M\163\v\ETB\202\&1\248U_\180O\ESCdJ\224\250\134?\206\185\DC3\155z\179\219P\132 \148\SYN\130\155)q\184\r\203\234\167\&5V\225n\211\RSB+ \228\141\196\&5^\143Q&P\178\170\187\US\227\US+\143\196u\252k\215\DEL\225ZZ\220h1\220\217\221\153\166\146\&1&J\128\ESC\140\241\138\215\153\199[\FS\149\167\vr\202VO\169\227ZDv\183W\209\164\140!gp\172\204\&1\140\250\142\199\249\253z\247:\165\226D\EOT\SYN\203\181!\SOH\DC3\a\161\245\250\129\\\182\169\162\186]M\DC4\138`\184\135\169q\128\195\211\223\233\249z\EM\180\139\169'\144Y\206?~\156.\227\212\RSI\206y\200\NULg\184\"\189\\.!M$\207\DC3\ETB\133t\221\209\212\216il\"\ETBw\ETX\SYN\246\249;q\247\136\228\143\211\US\133u\250\f2\205a\DC3\204?z\231s\241\211\156\227\240\233\248TV\246\160,V\185\ESC@\ETX\156r\a$\254&\183m\EM\SYN\217\&6\NAK\229r\r:\181/\185\205\CANX\200\241E\228v\SUBU\204\135\133\142>2z\158\223\174?:\241\221\SIt\250\188rm\220#\203\SOH\234@\239]w\196=T\221<vQ\DC3\228\171e\200\232\205\233\248\DEL\158\149\205\248i\214\222gb\SO\231\RSZ\254\&5\181\&85\STX\ESC\212\239~\US4\151\RS.\186\149\213\182\139G\ETX\254\251N(\171>\STX\153%\241\FS\138\132\236K7POs\189(\174z\155\234h\143\159\239\191\228!s\255\NUL][\249\154\175V\181\STX\191o\184\218\&9\243[?\153\168Dj@&T\RS\220\255\NUL\133s\154\162:P2qS\bb=n\DLE\DEL\192MJ\144\218)\201\185'\254\SOHJ\229\170m\246\251\209\&5\164Y#\142+\173\211t7\186\141J\175\204zW7mqe\ETXg\205-\207\166+\161\180\241\162X\198\SYN\CAN\227$t,I\255\NUL\n\227\196{Y/\221\163\219\193:4\161\239I\\\210\213!\139A\134)\229Ue\136f4\237$\157\179\237\220\251\fW\SOHst\243L\243L\229\229\145\183\&3\147\212\154\185\173k\183:\205\215\155<\133\182\143\151\176\USAX\236rk\\5'N7\150\231\ACK?\NAK\237\167h\236\142\163\195:\213\181\156\160\\\198\146`\NAK\242\220\227p>\135\212T\183o\FS\178\179\198\&0\167\144+\144\167$\210'\221\145\135\208\211\149\EOT\229\204\139\163\152\202\DLE\228\146\185\208:e\f\200H\146\&1\149#\219\159\229\159\210\187\SI\SO|V\213t\ESC1\tT\158\217\DEL\129\251}=+\130\211\239\196\140m\238\b\STXN\ETX\250\RS\217\166\197n^\241-\216c\231\218G\189S\166\158\228N\186\147\188z\244\243=n\235\196\SUB\ETB\141\172\179sn\171\&9\FS\171\f0=\240k\138\150\202m*\246\&7\181\DEL9\224p\208\177\251\220\FS\237>\160\255\NUL\158\166\180\175\244x4\US\SO\197t\210)\158S\136\211#\175s\248Vw\133b\212u\173z;x\209\174\DC1\SOH\146B9 \SI\241\168\133\&9G\222\139\208\GSZk\221\146\212\245qp<\136\216nGh\138\159^MZ7`@\145D\191\&8\224\DC3\208\SISYR\228|\174\nH\156\DLEj\156\250\151\145m \200\f\249\228\246\NAK\232(9\216\243[H\228\252Ur\151\SUB\176\141\b\219\DLE\219\248\142\166\179t\252\164m(\206\NUL\218\158\236\DEL\250\223\210\163\184\144\207t\236\SO3\145\158\226\165\DC3\172n\138\163)\SIA\239\235^\138\141\163c\151\155S\188\248{6\207\DC4In\165\188\197\178s!\ETX\169\223\GS\NAKW\225f[\197\ETBr\200N\230\180~=~t\255\NUL?\141\NAK\197_I\154\199Tx\189\247\252\132.\DEL\235\171\DEL3U\234\197\247\252\132.\DEL\235\171\DEL3U\235\140\220)\193I\166\212\145\FS?4\fz\195\158\181 \134\180\173`\134`2?\DC1Z\208\248t\\(1L\185=\156\DELZ\194u\227\GS\207J\158]9\199\153jr\254V\r4\197]|\254\SI\212-\224\243\158\NULb\254\250\176\"\179$\210\164_\224\&4\163\136\132\182`\242\249\244\&9\246\140\212db\182%\177a\219\244\170\146[\DLEy\NAK\178\154g%L4\225\186(\214\206\155?\153u\GS\196\135&2\v\251\227\191\242\172\227\ACK;R\192\242[\185d\FS\144A\RS\212\222\171B \249%\239\SUB\186\165\245\206\179t\t,\200\163lj:\SOH]\199\194\253`\248SQ\158[\152\213\173\231@\172\NAK\215p\231\168\EM\175<\139S\185\128\DC1\FSP\175\213\&7\DEL:\145\&5Y\GS\255\NUL}\SUB\128{\160#\244\172\167\EM\181e\177\215M\225\155\247\219\187\251\143~\213\181m\DC3\197\DC3\179\233w`\\D\SOHl\141\165\191:\225\181\177sf\EMfRG@\195\165r\SUB}\243Y\234\DLE\207\DC3\149<\140\142\252WI/\137Zx\140W\145\137Q\186\DC1\212Wv\SOSk\208\227\199Q\133\&9Z=L\US\227\249MZ6\230+34\131\ENQ\241\176\DC1\215\223\244\171v\218b\221\220\a\181!\193\&9*N\SO)\154\172\254u\230\192N\200\248\EM\246\226\189%+\232\143;\150\218\157G\194\228\146O\DC4\206\DC4\DC2\SYN\197\250{\188tV\199\194\171t\183\188\154b\DELy4\fz\246\f\184\255\NUL>\226\138\224\196?|\218\ESC\RS\ENQ}\255\NUL!\v\159\250\234\223\204\213z\219\184\182\145o\174\v\149*dc\133\231\185\170\DC3F\SOH\224\n\230\229:-\161N\148\FS\SUBVR)\181 jY\\\NUL@\174\187H\185P@/\159j\224\DC2B\135\138\211\180\213\SUB&\ESC\156\SOH\237\214\185\171\209\231Z\RS\182_\142T\189\217\236{N\151,\DC3C\229JAC\193R{U\251\159\SOHKp\162{\EOTY-\156d38\ESC}s^e\165k\164\178\237l\SIRy\175S\240\247\137\EM\244{\139b\216;w\NUL\SI\\W\137:r\163/{c\215\170\230\227\237(;\152:\135\195\251\216\209^;s4l2\RS5\200\ACK\176\238\190\US\220l\207\153\fo\140\237f9\252x\175K\187\241 ].\vx\221\131:\151c\211\140\240+\147\185\212\164\150B\160\243K\235\DC3\139\\\140\154q\169U~\241#\206\175\252'\168\219\&1\253\206\252wC\159\210\185\235\139\&9\237\155\DC3D\232\DEL\218R+\214&c\183t\175\143j\205\157\141\228\169\SOH*cc\129\140\227\245\175K\v\137\169Q\242\181s\143\EM\133\165\CAN\243\&7c\205\162\158H\FS2\224\224\231\145]5\142\175\163_\196\182\250\166\157n\146\SO\147\196\155\&3\254\246\220~u\212G\225\221\"x\\\205i\DC30b\t\EMS\215\219\NAK\131\171xkL\183\255\NULP\242\198H\206\ETXn\US\173z\240\165&\244<9UIY\234\138\247Z}\141\187\169\182\220W\168]\217\DC4\203[Yn\238\209\DC26|\176\FS\SO3\239\237K\167i\174\210\173\188r3\STXrY\186\SOH\215\138\236\136\135J\210C\168\b\219@\ETX\NUL\SYN$\FS\158\aZ\238\186\167\DC4\146\213\156\142\242woDf\\\132\177\184d\180}\215\ESCV!\180`\SO\128\254$\214e\217\ACK\225\227#>P\218Xz\247\169\174\SUBK\DC3\SO\252\253\161\135\154\193\186\140\143\148~\185\252jt\211\138i{\223;\217|\199'\169'\160\254\181\180tWfM\220\237\254\CAN\194_U\147/\132\142\208\174Gv,\135\244\DC4T\223\SI!k}K\236\252\140Z\187>\SI\241\SYNO\228\&8\162\184k\235\&3X\232\143\US\189\DC2\ESC\169\137\NUL\r\231\140\243\214\179\164\133\217\SO@\164\189\191\144^\206\DC4F1#\SO\156\245\170\135P\152\158X\US\195\NAK\157\210:\156\174E<L\135\ENQMV=kM/\195\fJ\128\143Z\220\240\198\149\167k\186\253\189\172\234\EOT8g\144\SO2\NUL\206?\DC3\129\248\210qOTA\202Em=\192&\CAN$\147\GSv!8\252\169\143\ESC\198\216te>\132b\189'\198\186\132V\128\216\217\199\DC40\160\218V \DC4{\128\an+\205\156\146\198\166QQAr\197\157\201\134PI\224W{\225\157p\249\170\&7\240\223)\252x\175\&8\171\154}\252\150\&7\v\"\159\151\184\174Z\244\NAKX\216\244\&0X\215A\242\191\133\158\151\226\rx\218\\\ENQV\200_\148g\208\SO+\SYN\203[\155P\191\138\NAK;K8\EM\USZ\199\215\174~\223\EOT7Q>\224\220\&6;\FSV\151\129m\ETX\234i+\SI\184\t\EM\252\191\173F\ESC\ETX\a\GSV\167F/2\169\EM\242\193\232o\203\188\220\"9$\239\n3\245\255\NUL\245\213\189\&2\DC3qsh\239\194\179\183\NUL\253E>d\ACKh\216s\243\134\206=\ETX7\245\NAK%\136h,\237$#\229\ESC\155\143M\213\223\FS<i\199DyU1\DC2\171+\201\139\137\173\166\156\152\201Gf\FS\245\206?\250\199\242\172\185l\238/\222F\216\161\129\n\171\211\&9'\244\226\186\251\155}\210|\216T\224\177\EOTe\198?\159\&5\ETB\217QY\204a\145\ACK\b\220\221\&6\142?\SOs[S\169oS\t\192\203\179\211E\162\141\171\185\198UO\247\142q\159\231TuG[\157R;s\150\130\SI\154C\234\&3\205m\222\222%\173\187\220c\v\179j+\DEL:\227\&7\181\195m\201\ACKbZB?\184+zi\183\204\204\164\237\162$\181W\214\181\245yy\DC2\190\227\254\239\167\228+\180\186\179I\FS+\DLE\176\161\243_\GS\207o\232+'J\211\141\159\145+\157\146\205\130\au\GS\191O\235V\238ev\145\142\236\a*\DC4z\SI\241\233T\239'\160-\SYN\167I\224\168\219\254\DC2;\132\\\237[f\201\245%\146\138\135\193\242\172^%\146\216\US\152Z37\215r\DEL\141\NAK\205Y{\197E\159;\223\255\NUL\200B\231\254\186\191\243\&5\ENQ]\213\173f\182\212g\DC2\161]\210\&3\f\140pNj\149r\155\142RA\198\226+WG\191\155L\212!\186P]W!\128\234T\140\SUB\200\EM\169\146WN\245Q`t>%\156^\206\183J\251\163\144ep\DELOj\229\207Z\208[\176\233\178@\b5\EM\181\137\219\228\144\140\250\140\213\205sj\132\180)\212\134\EMW\172n?\224\&5ym\SYN\DLE$G\222\227\156\DC1N7\238>W\237\216\212\170}\199r\173\172\204\135\202?u\186\131^\139\224\187p\150\243\202\SOH\249@\237\248\255\NULJ\224\209\SYNY\ETX/\229^\145\225uD\210X0\198\226s\249\SI\254\189uR\133\162\204\167+\178\205\203fE\218\&1\203\SI\166\ENQ]\211\nK\167[\151\233\185\227?\142T~\184\170\DC2\225\164\SOHy\EOT\190\a\215\"\164\211\GS\164\211\165\182RA\EOT\DLE}\SI\\\214\147\142\132'\169h\234\179i\241,3[K:\129\251\169T\158T\f\SOH\245\FS\138\142]P\203\SO\249\DC3\201\133O\n~\243}}\169T\253\164\EM\161\184\SYN\228\144dV\USu\143\\~\"\168\&5\165\154){\219\151\149\138\229#Q\128x\239\222\165(\245Z\141\182Q\186\184\159Y\153\201\249`\137}>\152\STX\174\233Zz\169\150\242u\STX3\149Q\219h\235\249\244\252\rZ\211\163:\140\132\b\188\155h\240[\ETX\128\&3\208{\154\213\150(\230U\ESC\NUL\134<\179(\GS\199A\244\173%/\178\136K\169^9\f\215\RSk\140\150S\183#\238\175s\249qT\231\159\204\188\146A\194Fs\140q\158\213-\229\217>`P71\244\232\aj\196\190\186\DLE\219\CANP\228\158X\143Z\184\198\194l\232~\RS\220\&5\199\141.\155\&9\USb\DEL\253\SO:*\159\195\a-\226\235\128;X\201\159\251\249\GS\NAK\205_\227*\ESC\EM\154\159\194\DEL\DC3_\221\188\143}\165\145\184\227t\178g\GS\191\130\168\159\131\RS\"\255\NUL\159\205+\254\254\201\255\NUL\196QEq\179\160Q\240g\196C\254_4\188\255\NUL\215Y?\248\138C\240g\196g\173\238\151\255\NUL\DELd\255\NUL\226(\162\144\NUL\248\&3\226?\249\253\210\255\NUL\239\236\159\252E=~\SOx\140t\190\210\255\NUL\239\236\159\252E\DC4S\STXA\240\139\196\192c\237\186W\253\253\147\255\NUL\136\167\DEL\194\160\241\DC3\140=\214\146\DEL\237\164\159\252E\DC4U)1\DC3A\240\135_\141\129\251N\150>\147I\255\NUL\196Wc\167\252?\214-\180\244\136\207c\184\ETX\156H\248'?\238QEu\194O\148\202[\143o\NUL\234\251\148\137\172r\167#\247\175\234O\247)4\207\NUL\235\SYN\243\201\230ObU\143\CAN\145\248\255\NUL\199(\162\173\201\216\133\185f\235\225\213\245\220\129\254\211m\DC1l\DC2Q\143?Q\183\245\168\237\254\CAN\\F\225\228\185\134M\184\&8\243\CANn?\247\207\DC4QX\251Iw4\178\&6a\240e\246\221\174\246\137\RSX\132\137\216\SO\221x\231\165\&2\247\193\250\130\217\249V\239i\185\137;\157\219\255\NUL\137\162\138#'\204K\216\193\147\192:\210\161\219=\129b:\153_\255\NUL\136\172{\143\134\158 \144\159\244\157\&79=f\147\255\NUL\136\162\138\232\231\145\SYNF\247\128<\ETX\171\232\190 \154\234\234{\SYN\141\173Z0\"\145\201\201t=\212z\SUB(\162\185kI\243\SUB\197h\DEL\255\217"
cooked_zz_top =  FreeForm "zz-top.jpg" "image/jpeg" raw_zz_top
