--  2002 Peter Thiemann
module Main where

import Prelude hiding (head, div, span, map)

import Auxiliary
import CGI
import qualified Cookie as C
import qualified Persistent2 as P

theFlag :: String -> CGI (C.T Bool)
theFlag ttl = C.initExpiring ("voted for "++ttl) 1440 False

voteCounter :: String -> CGI (P.T (Int, Int))
voteCounter ttl = P.init ("votes for "++ttl) (0,0)

main = 
  do pathInfo <- protectedGetEnv "PATH_INFO" "/"
     run $ overview (tail pathInfo)

showBool True = "for"
showBool False = "against"

overview ttl = once (
  do votedHandle <- theFlag ttl
     counterHandle <- voteCounter ttl
     (pro, contra) <- P.get counterHandle
     let doVote ans = do mvoted <- C.get votedHandle
			 case mvoted of
			   Nothing ->
			     problem ttl
			   Just voted ->
			     do C.set votedHandle True
				if voted then sorry ttl
			                 else acknowledge ttl ans
     standardQuery ("Voting for "++ ttl) $ do
       p_T (text_S "Votes for " ## text ttl ## text_S ": " ## text (show pro))
       p_T (text_S "Votes against " ## text ttl ## text_S ": " ## text (show contra))
       p_T (text_S "I'm " ##
          activate doVote (selectSingle showBool Nothing [True, False]) empty ## 
	  text_S " " ##
	  text ttl))
  >> overview ttl

problem ttl =
  standardQuery ("Problem with voting on topic " ++ ttl)
    (text_S "Reload this URL to try again.")

sorry ttl =
  standardQuery ("Sorry, you voted before on topic " ++ ttl)
    (submit0 finish (fieldVALUE "CONTINUE"))

acknowledge ttl ans = 
  do counterHandle <- voteCounter ttl
     (pro, contra) <- P.get counterHandle
     let (newpro, newcontra) | ans = (pro+1, contra)
                             | otherwise = (pro, contra+1)
     P.set counterHandle (newpro, newcontra)
     standardQuery ("Acknowledged vote "++ showBool ans ++ " " ++ ttl) 
       (submit0 finish (fieldVALUE "CONTINUE"))

finish = return ()
