/*
 * Decompiled with CFR 0.152.
 */
package us.k5n.webcalendar;

import java.util.Calendar;
import java.util.Vector;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import us.k5n.webcalendar.Participant;
import us.k5n.webcalendar.Utils;
import us.k5n.webcalendar.WebCalendarParseException;

public class Event {
    public String id = null;
    public String name = null;
    public String description = null;
    public String url = null;
    String dateFormatted = null;
    String timeFormatted = null;
    String date = null;
    Calendar dateCalendar;
    String time = null;
    String duration = null;
    String priority = null;
    String access = null;
    String createdBy = null;
    String updateDate = null;
    String updateTime = null;
    Vector siteExtras = null;
    Vector participants = new Vector();
    public static int UNTIMED = -1;
    public static int ALL_DAY = -2;

    public Event(Node node) throws WebCalendarParseException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if ("name".equals(string)) {
                this.name = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("id".equals(string)) {
                this.id = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("description".equals(string)) {
                this.description = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("url".equals(string)) {
                this.url = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("dateFormatted".equals(string)) {
                this.dateFormatted = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("date".equals(string)) {
                this.date = Utils.xmlNodeGetValue(node2);
                this.dateCalendar = Utils.YYYYMMDDToCalendar(this.date);
                continue;
            }
            if ("time".equals(string)) {
                this.time = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("timeFormatted".equals(string)) {
                this.timeFormatted = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("duration".equals(string)) {
                this.duration = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("priority".equals(string)) {
                this.priority = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("access".equals(string)) {
                this.access = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("createdBy".equals(string)) {
                this.createdBy = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("updateDate".equals(string)) {
                this.updateDate = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("updateTime".equals(string)) {
                this.updateTime = Utils.xmlNodeGetValue(node2);
                continue;
            }
            if ("siteExtras".equals(string)) continue;
            if ("participants".equals(string)) {
                this.parseParticipants(node2);
                continue;
            }
            System.err.println("Not sure what to do with <" + string + "> tag (ignoring)");
        }
    }

    private void parseParticipants(Node node) throws WebCalendarParseException {
        NodeList nodeList = node.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string = node2.getNodeName();
            if ("participant".equals(string)) {
                Participant participant = new Participant(node2);
                this.participants.addElement(participant);
                continue;
            }
            System.err.println("Not sure what to do with <" + string + "> tag (ignoring) inside <participants>");
        }
    }

    public boolean dateMatches(Calendar calendar) {
        if (this.dateCalendar == null) {
            return false;
        }
        if (this.dateCalendar.get(5) != calendar.get(5)) {
            return false;
        }
        if (this.dateCalendar.get(2) != calendar.get(2)) {
            return false;
        }
        return this.dateCalendar.get(1) == calendar.get(1);
    }

    public String getAccess() {
        return this.access;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public String getDate() {
        return this.date;
    }

    public Calendar getDateCalendar() {
        return this.dateCalendar;
    }

    public String getDateFormatted() {
        return this.dateFormatted;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDuration() {
        return this.duration;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Vector getParticipants() {
        return this.participants;
    }

    public String getPriority() {
        return this.priority;
    }

    public Vector getSiteExtras() {
        return this.siteExtras;
    }

    public String getTime() {
        return this.time;
    }

    public String getTimeFormatted() {
        return this.timeFormatted;
    }

    public String getUpdateDate() {
        return this.updateDate;
    }

    public String getUpdateTime() {
        return this.updateTime;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.name != null) {
            stringBuffer.append(this.name);
            stringBuffer.append("\n");
        }
        if (!(this.description == null || this.name != null && this.name.equals(this.description))) {
            stringBuffer.append("Description: ");
            String string = this.description.replaceAll("<br/>", "\n    ");
            string = string.replaceAll("\\n", "\n    ");
            stringBuffer.append(string);
            stringBuffer.append("\n");
        }
        if (this.dateFormatted != null) {
            stringBuffer.append("Date: ");
            stringBuffer.append(this.dateFormatted);
            stringBuffer.append("\n");
        }
        if (this.timeFormatted != null) {
            stringBuffer.append("Time: ");
            stringBuffer.append(this.timeFormatted);
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }
}

