// Initializes the resize dialog
function webdeveloper_initializeResize()
{
    document.getElementById("webdeveloper-resize-width").value = window.arguments[0];
    document.getElementById("webdeveloper-resize-height").value = window.arguments[1];
}

// Resizes the parent window to the given width and height
function webdeveloper_resizeParentWindow()
{
    var height = document.getElementById("webdeveloper-resize-height").value.trim();
    var width  = document.getElementById("webdeveloper-resize-width").value.trim();

    // If the width and height are valid
    if(width && height && (width == "*" || (parseInt(width) == width && width > 0)) && (height == "*" || (parseInt(height) == height && height > 0)))
    {
        var contentWindow = window.opener.content;
        var windowX       = window.opener.screenX;
        var windowY       = window.opener.screenY;

        // If resizing the view port
        if(document.getElementById("webdeveloper-resize-viewport").checked)
        {
            // If the width is not a wildcard
            if(width != "*")
            {
                contentWindow.innerWidth  = width;
            }

            // If the height is not a wildcard
            if(height != "*")
            {
                contentWindow.innerHeight = height;
            }
        }
        else
        {
            // If the width is a wildcard
            if(width == "*")
            {
                width = contentWindow.outerWidth;
            }

            // If the height is a wildcard
            if(height == "*")
            {
                height = contentWindow.outerHeight;
            }

            window.opener.resizeTo(width, height);
        }

        window.opener.screenX = windowX;
        window.opener.screenY = windowY;
    }
}
