package WebGUI::i18n::English::Asset_EventManagementSystem;
use strict;

our $I18N = {
    'expire ems cart items' => {
        message     => q|Expire EMS Cart Items|,
        lastUpdated    => 0,
        context        => q|workflow activity title|,
    },

    'item expiration time' => {
        message     => q|Item Expiration Time|,
        lastUpdated    => 0,
        context        => q|a workflow activity field label|,
    },

    'item expiration time help' => {
        message     => q|How long should EMS items be allowed to sit in a cart before they are expired to be freed up for someone else to purchase?|,
        lastUpdated    => 0,
        context        => q|help for a workflow activity field label|,
    },

    'user' => {
        message     => q|User|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'badge number' => {
        message     => q|Badge #|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'percentage discount' => {
        message     => q|Percentage Discount|,
        lastUpdated    => 0,
        context        => q|a ribbon property label|,
    },

    'percentage discount help' => {
        message     => q|What percentage discount will be applied to the tickets if the user purchases this ribbon?|,
        lastUpdated    => 0,
        context        => q|help for a ribbon property label|,
    },

    'badge group name' => {
        message     => q|Badge Group Name|,
        lastUpdated    => 0,
        context        => q|a badge group property label|,
    },

    'badge group name help' => {
        message     => q|This name will be used to refer to all the badges in this group, together.|,
        lastUpdated    => 0,
        context        => q|help for a badge group property label|,
    },

    'badge groups' => {
        message     => q|Badge Groups|,
        lastUpdated    => 0,
        context        => q|a header label|,
    },

    'hours' => {
        message     => q|Hours|,
        lastUpdated    => 0,
        context        => q|subtext for the duration form field|,
    },

    'add a badge group' => {
        message     => q|Add A Badge Group|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'add an event meta field' => {
        message     => q|Add An Event Meta Field|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'view tickets' => {
        message     => q|View Tickets|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'view badges' => {
        message     => q|View Badges|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'view badge template' => {
        message     => q|EMS Badge Template|,
        lastUpdated    => 0,
        context        => q|Edit EMS Badge Template form field|,
    },

    'view badge template help' => {
        message     => q|The template used to display a form where the user enters badge information.|,
        lastUpdated    => 0,
        context        => q|Edit EMS Badge Template form field hover help|,
    },

    'ems view badge error' => {
        message     => q|Any errors from trying to add this badge to the user's cart.|,
        lastUpdated    => 0,
        context        => q|Edit EMS Badge Template form field help|,
    },

    'addressBook' => {
        message     => q|A button to fetch an address from the user's address book.|,
        lastUpdated    => 0,
        context        => q|Edit EMS Badge Template form field help|,
    },

    'formHeader' => {
        message     => q|Form header for the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|Edit EMS Badge Template form field help|,
    },

    'formFooter' => {
        message     => q|Form footer for the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|Edit EMS Badge Template form field help|,
    },

    'ems view badge name' => {
        message     => q|Form for the user's name in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge organization' => {
        message     => q|Form for the user's organization in the EMS View Badge template|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge address1' => {
        message     => q|Form for the first address field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge address2' => {
        message     => q|Form for the second address field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge address3' => {
        message     => q|Form for the third address field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge city' => {
        message     => q|Form for the city field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge state' => {
        message     => q|Form for the state field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge zipcode' => {
        message     => q|Form for the zipcode field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge country' => {
        message     => q|Form for the country field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge phone' => {
        message     => q|Form for the phone field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge email' => {
        message     => q|Form for the email field in the EMS View Badge template.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge submitAddress' => {
        message     => q|Button to submit the address data.|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge title' => {
        message     => q|The title of the EMS Badge|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'ems view badge description' => {
        message     => q|The description of the EMS Badge|,
        lastUpdated    => 0,
        context        => q|View EMS Badge Template form field help|,
    },

    'buy badge' => {
        message     => q|Buy A Badge|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'switch to badge for' => {
        message     => q|Switch To '%s' Badge|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'lookup badge' => {
        message     => q|Look Up A Badge|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'remove' => {
        message     => q|Remove|,
        lastUpdated    => 0,
        context        => q|a link label, as in "remove from cart"|,
    },

    'import' => {
        message     => q|Import|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'export' => {
        message     => q|Export|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'meta fields' => {
        message     => q|Meta Fields|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'add a badge' => {
        message     => q|Add a badge|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'add a token' => {
        message     => q|Add a token|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'add a ticket' => {
        message     => q|Add a ticket|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'add a ribbon' => {
        message     => q|Add a ribbon|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'sold out' => {
        message     => q|Sold Out|,
        lastUpdated    => 0,
        context        => q|a message telling the user there are none left to buy|,
    },

    'manage' => {
        message     => q|Manage|,
        lastUpdated    => 0,
        context        => q|a column label in the badge builder|,
    },

    'quantity available' => {
        message     => q|# Available|,
        lastUpdated    => 0,
        context        => q|a column label in the badge builder|,
    },

    'buy' => {
        message     => q|Buy|,
        lastUpdated    => 0,
        context        => q|a button label in the badge builder|,
    },

    'delete' => {
        message     => q|Delete|,
        lastUpdated    => 0,
        context        => q|a button label in the badge builder|,
    },

    'edit' => {
        message     => q|Edit|,
        lastUpdated    => 0,
        context        => q|a button label in the badge builder|,
    },

    'search' => {
        message     => q|Search|,
        lastUpdated    => 0,
        context        => q|a button label in the badge builder|,
    },

    'tickets' => {
        message     => q|Tickets|,
        lastUpdated    => 0,
        context        => q|a template label a tab in the badge builder|,
    },

    'ribbons' => {
        message     => q|Ribbons|,
        lastUpdated    => 0,
        context        => q|a template label a tab in the badge builder|,
    },

    'tokens' => {
        message     => q|Tokens|,
        lastUpdated    => 0,
        context        => q|a template label a tab in the badge builder|,
    },

    'lookup registrant template' => {
        message     => q|Lookup Registrant Template|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'lookup registrant template help' => {
        message     => q|Which template would you like to use for the lookup registrant screen?|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'buyBadgeUrl' => {
        message     => q|URL to buy a badge.|,
        lastUpdated    => 0,
        context        => q|template variable for the lookup registrant template|,
    },

    'viewEventsUrl' => {
        message     => q|URL to view tickets.|,
        lastUpdated    => 0,
        context        => q|template variable for the lookup registrant template|,
    },

    'getRegistrantsUrl' => {
        message     => q|URL to get registrant information as JSON.|,
        lastUpdated    => 0,
        context        => q|template variable for the lookup registrant template|,
    },

    'isRegistrationStaff' => {
        message     => q|A conditional variable that is true if the current user is in the configured registration staff group for this Event Management System.|,
        lastUpdated    => 0,
        context        => q|template variable for the lookup registrant template|,
    },

    'print badge template' => {
        message     => q|Print Badge Template|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'print badge template help' => {
        message     => q|Which template would you like to use for printing badges?|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'badgeTitle' => {
        message     => q|The title of the badge to be printed.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'ticketTitle' => {
        message     => q|The title of the ticket to be printed.|,
        lastUpdated    => 0,
        context        => q|template variable for the print ticket screen|,
    },

    'ticketStart' => {
        message     => q|The start date of the ticket.|,
        lastUpdated    => 0,
        context        => q|template variable for the print ticket screen|,
    },

    'ticketDuration' => {
        message     => q|How long the ticket lasts.|,
        lastUpdated    => 0,
        context        => q|template variable for the print ticket screen|,
    },

    'ticketLocation' => {
        message     => q|Where the ticket is good for.|,
        lastUpdated    => 0,
        context        => q|template variable for the print ticket screen|,
    },

    'ticketEventNumber' => {
        message     => q|The event number for the ticket.|,
        lastUpdated    => 0,
        context        => q|template variable for the print ticket screen|,
    },

    'userId' => {
        message     => q|The badge user's userId.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'badgeNumber' => {
        message     => q|The number of this badge.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'badgeAssetId' => {
        message     => q|The Asset ID of this badge.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'emsAssetId' => {
        message     => q|The Asset ID of Event Management System containing the badge.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'name' => {
        message     => q|The badge user's name.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'address1' => {
        message     => q|Address line 1 of the badge user's address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'address2' => {
        message     => q|Address line 2 of the badge user's address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'address3' => {
        message     => q|Address line 3 of the badge user's address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'city' => {
        message     => q|The city from the badge user's address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'state' => {
        message     => q|The state from the badge user's address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'zipcode' => {
        message     => q|The zipcode from the badge user's address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'country' => {
        message     => q|The country from the badge user's address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'phoneNumber' => {
        message     => q|The badge user's phone number.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'organization' => {
        message     => q|The badge user's organization, typically where they work or volunteer.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'email' => {
        message     => q|The badge user's email address.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'notes' => {
        message     => q|Notes about this user's badge.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'purchaseComplete' => {
        message     => q|A conditional variable that is true if the purchase of the badge is completed.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'hasCheckedIn' => {
        message     => q|A conditional variable that is true if the user has checked in to the Event.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'transactionItemId' => {
        message     => q|The unique identifier for the transaction item for this badge, useful for internal tracking purposes.|,
        lastUpdated    => 0,
        context        => q|template variable for the print badge screen|,
    },

    'print ticket template' => {
        message     => q|Print Ticket Template|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'print ticket template help' => {
        message     => q|Which template would you like to use for printing tickets?|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'badge builder template' => {
        message     => q|Badge Builder Template|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'badge builder template help' => {
        message     => q|Which template would you like to use for the badge builder screen?|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'addTicketUrl' => {
        message     => q|The URL to add a ticket to a badge.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'addRibbonUrl' => {
        message     => q|The URL to add a ribbon to a badge.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'addTokenUrl' => {
        message     => q|The URL to add a token to a badge.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'importTicketsUrl' => {
        message     => q|The URL to import tickets.  Currently not implemented.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'exportTicketsUrl' => {
        message     => q|The URL to export tickets.  Currently not implemented.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'getTicketsUrl' => {
        message     => q|The URL to get ticket information as JSON.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'getRibbonsUrl' => {
        message     => q|The URL to get ribbon information as JSON.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'getTokensUrl' => {
        message     => q|The URL to get token information as JSON.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'hasBadge' => {
        message     => q|A conditional that shows whether or not the current user has a badge.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'badgeId' => {
        message     => q|The ID of the current user's badge.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'whichTab' => {
        message     => q|The currently selected tab in the badge builder screen.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'url' => {
        message     => q|The URL to this Event Management System.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'viewCartUrl' => {
        message     => q|A URL to take the user to the View Cart screen.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'customRequestUrl' => {
        message     => q|A URL for the YUI to lookup information about the current badge.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'manageEventMetaFieldsUrl' => {
        message     => q|The URL to the Manage Event Metadata screen.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'otherBadgesInCart' => {
        message     => q|A loop containing links and labels for other badges that are in this user's cart.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'badgeUrl' => {
        message     => q|The URL to add another badge in the user's cart.|,
        lastUpdated    => 1216654838,
        context        => q|badge builder template variable|,
    },

    'badgeLabel' => {
        message     => q|An internationalized, personalized label to go with this other badge in the user's cart.|,
        lastUpdated    => 0,
        context        => q|badge builder template variable|,
    },

    'main template' => {
        message     => q|Main Template|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'main template help' => {
        message     => q|Which template would you like to use for the main screen that lists the badges for purchase?|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'location' => {
        message     => q|Location|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'location help' => {
        message     => q|In what room or location will this event be held?|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'event number' => {
        message     => q|Event #|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'event number help' => {
        message     => q|A number that represents the event, which is easily referenceable for things like event catalogs.|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'badge instructions' => {
        message     => q|Badge Instructions|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'badge instructions help' => {
        message     => q|Give the user some help on what to do with a badge.|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'default badge instructions' => {
        message     => q|You need a badge to attend this convention. Choose a badge that meets your needs and budget.|,
        lastUpdated    => 0,
        context        => q|the default value for a property|,
    },

    'ticket instructions' => {
        message     => q|Ticket Instructions|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'ticket instructions help' => {
        message     => q|Give the user some help on what to do with a ticket.|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'default ticket instructions' => {
        message     => q|Tickets allow you to reserve a seat at events that are going on at the convention. Add tickets to your badge for any events you plan to attend.|,
        lastUpdated    => 0,
        context        => q|the default value for a property|,
    },

    'ribbon instructions' => {
        message     => q|Ribbon Instructions|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'print' => {
        message     => q|Print|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'checked in' => {
        message     => q|Checked In|,
        lastUpdated    => 0,
        context        => q|used in registration management to alert staff whether user has already picked up badge|,
    },

    'not checked in' => {
        message     => q|Not Checked In|,
        lastUpdated    => 0,
        context        => q|used in registration management to alert staff whether user has already picked up badge|,
    },

    'mark as not checked in' => {
        message     => q|Mark As Not Checked In|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'mark as checked in' => {
        message     => q|Mark As Checked In|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'refund' => {
        message     => q|Refund|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'add more items' => {
        message     => q|Add More Items|,
        lastUpdated    => 0,
        context        => q|a link label|,
    },

    'notes' => {
        message     => q|Notes|,
        lastUpdated    => 0,
        context        => q|a property label for registrant notes|,
    },

    'ribbon instructions help' => {
        message     => q|Give the user some help on what to do with a ribbon.|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

    'default ribbon instructions' => {
        message     => q|Ribbons give you discounts on a group of related events. You may add one ore more ribbons to your badge to give you discounts on related events.|,
        lastUpdated    => 0,
        context        => q|the default value for a property|,
    },

    'token instructions' => {
        message     => q|Token Instructions|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'token instructions help' => {
        message     => q|Give the user some help on what to do with a token.|,
        lastUpdated    => 1215445816,
        context        => q|help for a property label|,
    },

    'default token instructions' => {
        message     => q|Tokens are like convention currency. They allow you to purchase events and other items without buying a specific ticket.|,
        lastUpdated    => 0,
        context        => q|the default value for a property|,
    },

    'assetName' => {
        message     => q|Event Manager|,
        lastUpdated => 1211045812,
        context        => q|name of asset|,
    },

    'you do not have any metadata fields to display' => {
        message => q|You do not have any metadata fields to display.|,
        lastUpdated => 1145396293,
    },

    'label' => {
        message     => q|Label|,
        lastUpdated => 0,
        context     => q|meta field label|,
    },

    'label help' => {
        message     => q|The label for the field that the user will read to know what the field is for.|,
        lastUpdated => 0,
        context     => q|meta field label help|,
    },

    'ems badge' => {
        message     => q|Event Manager Badge|,
        lastUpdated => 0,
        context        => q|name of asset|,
    },

    'ems ticket' => {
        message     => q|Event Manager Ticket|,
        lastUpdated => 0,
        context        => q|name of asset|,
    },

    'ems ribbon' => {
        message     => q|Event Manager Ribbon|,
        lastUpdated => 0,
        context        => q|name of asset|,
    },

    'ems token' => {
        message     => q|Event Manager Token|,
        lastUpdated => 0,
        context        => q|name of asset|,
    },

    'is required' => {
        message     => q|%s is required.|,
        lastUpdated    => 0,
        context        => q|used in an error message|,
    },

    'email address' => {
        message     => q|Email Address|,
        lastUpdated    => 0,
        context        => q|form label|,
    },

    'organization' => {
        message     => q|Organization|,
        lastUpdated    => 0,
        context        => q|form label for company/school/etc|,
    },

    'badge holder information' => {
        message     => q|Badge Holder Information|,
        lastUpdated    => 0,
        context        => q|heading on add badge to cart screen|,
    },

    'no more available' => {
        message     => q|Error: No more items available for purchase.|,
        lastUpdated    => 1222876439,
    },

    'add to cart' => {
        message     => q|Add To Cart|,
        lastUpdated    => 0,
        context        => q|a button on the add badge to cart screen|,
    },

    'populate from address book' => {
        message     => q|Populate From Address Book|,
        lastUpdated    => 0,
        context        => q|a button on the add badge to cart screen|,
    },

    'registration staff group' => {
        message     => q|Registration Staff Group|,
        lastUpdated    => 0,
        context        => q|an ems property label|,
    },

    'registration staff group help' => {
        message     => q|Pick a group of users that will handle registration. These users will be able to look up and manage badge registrations for any attendee.|,
        lastUpdated    => 0,
        context        => q|help for an ems property label|,
    },

    'related badge groups' => {
        message     => q|Related Badge Groups|,
        lastUpdated    => 0,
        context        => q|a ticket property label|,
    },

    'related badge groups ticket help' => {
        message     => q|Check the badge groups that can act as a prerequisite to being able to attend this event. If none are checked, then any badge will do.|,
        lastUpdated    => 0,
        context        => q|help for a ticket property label|,
    },

    'related badge groups badge help' => {
        message     => q|Check the badge groups that related to this badge, so that tickets can be assigned prerequisite badges.|,
        lastUpdated    => 0,
        context        => q|help for a ticket property label|,
    },

    'related ribbons' => {
        message     => q|Related Ribbons|,
        lastUpdated    => 0,
        context        => q|a ribbon ticket label|,
    },

    'related ribbons help' => {
        message     => q|Check the ribbons that can provide a discount for this ticket.|,
        lastUpdated    => 0,
        context        => q|help for a ticket property label|,
    },

    'time zone' => {
        message     => q|Time Zone|,
        lastUpdated    => 0,
        context        => q|a property label|,
    },

    'time zone help' => {
        message     => q|Select the time zone that this event will be taking place in.|,
        lastUpdated    => 0,
        context        => q|help for a property label|,
    },

     'add/edit event start date' => {
        message     => q|Start|,
        lastUpdated => 0,
        context     => q|Event start date field label|
    },

     'add/edit event end date' => {
        message     => q|End|,
        lastUpdated => 0,
        context     => q|Event end date field label|
    },

    'add/edit event start date help' => {
        message     => q|The time and date when the event starts.|,
        lastUpdated => 0,
        context     => q|hover help for Event Start Date field|
    },

    'duration' => {
        message     => q|Duration|,
        lastUpdated => 0,
        context     => q|duration field label|
    },

    'duration help' => {
        message     => q|How long does this event last?|,
        lastUpdated => 0,
        context     => q|hover help for duration field|
    },

    'cancel registration' => {
        message => q|Cancel Registration|,
        lastUpdated => 0,
        context => q|Label for hyperlink asking user if they wish to cancel the registration process during checkout.|,
    },

    'add/edit event title' => {
        message => q|Event Title|,
        lastUpdated => 1138312761,
    },

    'add/edit event title description' => {
        message => q|Enter the name or title of your event.|,
        lastUpdated => 1138312761,
    },

    'add/edit event image' => {
        message => q|Event Image|,
        lastUpdated => 1145636759,
    },

    'add/edit event image description' => {
        message => q|An image representing your event for display to site visitors.|,
        lastUpdated => 1145636774,
    },

    'add/edit event description' => {
        message => q|Description|,
        lastUpdated => 1138312761,
    },

    'add/edit event description description' => {
        message => q|The details of your event, such as location, time, and what the event is about.|,
        lastUpdated => 1138312761,
    },

    'add/edit event maximum attendees' => {
        message => q|Description|,
        lastUpdated => 1138312761,
    },

    'pre registration price' => {
        message     => q|Pre-Registration Price|,
        lastUpdated => 0,
        context        => q|field label|,
    },

    'pre registration price help' => {
        message        => q|The special price of this badge if the user orders insanely early.|,
        lastUpdated    => 0,
        context        => q|field label help|,
    },

    'pre registration price end date' => {
        message     => q|Pre-Registration Price End Date|,
        lastUpdated => 0,
        context        => q|field label|,
    },

    'pre registration price end date help' => {
        message        => q|The date that the pre-registration price is replaced by the early bird price.|,
        lastUpdated    => 0,
        context        => q|field label help|,
    },

    'price' => {
        message     => q|Full Price|,
        lastUpdated => 1221590520,
        context        => q|field label|,
    },

    'price help' => {
        message        => q|The regular price of this badge.|,
        lastUpdated    => 1221590773,
        context        => q|field label help|,
    },

    'early bird price' => {
        message     => q|Early Bird Price|,
        lastUpdated => 1221590520,
        context        => q|field label|,
    },

    'early bird price help' => {
        message        => q|The special price of this badge if the user orders early.|,
        lastUpdated    => 0,
        context        => q|field label help|,
    },

    'early bird price end date' => {
        message     => q|Early Bird Price End Date|,
        lastUpdated => 0,
        context        => q|field label|,
    },

    'early bird price end date help' => {
        message        => q|The date that the early bird price is replaced by the full price.|,
        lastUpdated    => 0,
        context        => q|field label help|,
    },

    'add/edit event price description' => {
        message => q|The cost to attend the event.|,
        lastUpdated => 1138312761,
    },

    'price must be greater than zero' => {
        message     => q|Price must be greater than 0|,
        lastUpdated => 1213318055,
        context        => q|field label|,
    },

    'add/edit useSalesTax' => {
        message => q|Use Sales Tax?|,
        lastUpdated => 1160109884,
    },

    'add/edit useSalesTax description' => {
        message => q|Should this event have sales tax applied to it?|,
        lastUpdated => 1160109886,
    },

    'add/edit approve event' => {
        message => q|Approve Event|,
        lastUpdated => 1138312761,
        context => q|URL to approve an event in the Add/Edit Event form|,
    },

    'add/edit event required events' => {
        message => q|Required Events|,
        lastUpdated => 1138902214,
        context => q|form field in add/edit event|,
    },

    'add/edit event required events description' => {
        message => q|You can require that the user be registered for certain events before being allowed to register for this event.|,
        lastUpdated => 1138899055,
        context => q|hover help for required event field|,
    },

    'add/edit event operator' => {
        message => q|Operator|,
        lastUpdated => 1138902214,
        context => q|form field in add/edit event|,
    },

    'add/edit event operator description' => {
        message => q|As required events are added to this event, you can specify that all of the events must required (And) or that any of the events are required (Or)|,
        lastUpdated => 1138899055,
        context => q|hover help for operator field|,
    },

    'check required fields' => {
        message => q|You did not include these required fields: |,
        lastUpdated => 0,
        context => q|Require that the user include all required fields in their import|,
    },

    'import blank line' => {
        message => q|Record %d was blank (skipped).|,
        lastUpdated => 0,
        context => q|Report which lines were blank.|,
    },

    'import other line' => {
        message => q|Record %d was %s.|,
        lastUpdated => 0,
        context => q|Report which lines were skipped or overwritten.|,
    },

    'import record parse error' => {
        message => q|There was an error processing record %d: '%s'|,
        lastUpdated => 0,
        context => q|Couldn't parse a line of the import file|,
    },

    'import line parse error' => {
        message => q|There was an error processing this input, '%s', on line %d.|,
        lastUpdated => 0,
        context => q|Couldn't parse a line of the import file|,
    },

    'no import took place' => {
        message => q|No records were imported. There were errors in the input:|,
        lastUpdated => 0,
        context => q|Let the user know that we didn't partially import their bad data|,
    },

    'export error' => {
        message => q|There was an error in the export procedure.|,
        lastUpdated => 0,
        context => q|generic export error|,
    },

    'import form header' => {
        message => q|Using this form you can import data directly into this EMS. Be sure that your fields are specified in the order shown below.|,
        lastUpdated => 0,
        context => q|header to the import form...|,
    },

    'import need dup key' => {
        message => q|You must check at least one duplicate key checkbox.|,
        lastUpdated => 0,
        context => q|When importing, we need at least one field to tell record apart|,
    },

    'import invalid status' => {
        message => q|Record %d has an invalid Status value (%s). Valid values are: Approved, Cancelled, Denied, Pending.|,
        lastUpdated => 0,
        context => q|There are only a few valid valued for the event status (approved) field|,
    },

    'import invalid prereq' => {
        message => q|Record %d has an invalid Prerequisite Set Name value (%s). You need to create the relevant Prerequisite Sets prior to import.|,
        lastUpdated => 0,
        context => q|The prereq import field is a EMS_prereqs.name; we need it to store the id in EMS_products.prerequisiteId|,
    },

    'import invalid template' => {
        message => q|Record %d has an invalid Event Template Name value (%s). You need to create the relevant Event Template prior to import.|,
        lastUpdated => 0,
        context => q|The templateId import field is an assetData.title; we need it to store the assetId in EMS_products.templateId|,
    },

    'import missing required' => {
        message => q|Record %d did not have %s, a required field, filled.|,
        lastUpdated => 0,
        context => q|Import records need to have required fields filled|,
    },

    'field count mismatch' => {
        message => q|Record %d has %d fields, not %d as indicated by the checkboxes you clicked.|,
        lastUpdated => 0,
        context => q|Import records need to have the right number of fields|,
    },

    'import ok' => {
        message => q|All %d records were successfully processed. %d created, %d blank lines, %d duplicates %s.|,
        lastUpdated => 0,
        context => q|Let the user know that the importing of events was successful|,
    },

    'skipped' => {
        message => q|skipped|,
        lastUpdated => 0,
        context => q|What did we do with duplicates (skipped/overwritten)?|,
    },

    'overwritten' => {
        message => q|overwritten|,
        lastUpdated => 0,
        context => q|What did we do with duplicates (skipped/overwritten)?|,
    },

    'meta hover help' => {
        message => q|This is a custom field. Please ask your administrator for guidance.|,
        lastUpdated => 0,
        context => q|What's this meta field for?|,
    },

    'import hoverhelp file' => {
        message => q|Upload a comma-seperated values (CSV) file for importing events. (Spreadsheet applications can output this format.) The fields must be comma-delimited, with double-quotes (") around field values which contain commas. Embedded double quotes are escaped with another double-quote (""). Your file will be checked for field count and required fields before any import takes place. If errors are found, then you are notified of the errors and no import takes place. This checking does not include checking whether or not LDAP, database links, or templates are valid. The format of special fields is as it is for exporting, so if you have a question as to how to format a given field for importing, look at how that information is exported and format your data accordingly. List fields with multiple values should be joined in the same CSV field by a semi-colon (;).|,
        lastUpdated => 0,
        context => q|What's the file field for?|,
    },

    'import hoverhelp dups' => {
        message => q|The system will use whatever fields you specify under 'Field Is Duplicate Key' as the fields to use to identify duplicate event records. When a duplicate is found, this pulldown will determine what we do with the duplicate event record - either skip the incoming record or overwrite the old record with the new one. Note that all fields in overwritten records are overwritten, regardless of whether they're present in the incoming record or not.|,
        lastUpdated => 0,
        context => q|What's the duplicates field for?|,
    },

    'import hoverhelp first line' => {
        message => q|If the first line of your import file contains field names instead of an event record, check yes. Otherwise, check no.|,
        lastUpdated => 0,
        context => q|What's the first line field for?|,
    },

    'import file contains field title' => {
        message => q|File Contains Field|,
        lastUpdated => 0,
        context => q|What's "file contains field" mean?|,
    },

    'import file contains field description' => {
        message => q|Check the checkboxes next to the fields which are included in your imput file. Please note that the fields must be in the order shown, and all required fields must be checked and filled in order for the import to proceed.|,
        lastUpdated => 0,
        context => q|What's "file contains field" mean?|,
    },

    'import field is duplicate key title' => {
        message => q|Field Is Duplicate Key|,
        lastUpdated => 0,
        context => q|What's "field is dup key" mean?|,
    },

    'import field is duplicate key description' => {
        message => q|In order to handle duplicate event records intelligently, the system needs to be able to identify a record as a duplicate. By checking these checkboxes, you're letting the system know what fields it needs to consider when trying to find an already-existing record for the event record being imported. For example, if you check Event Title and Event Start Date as the only fields which are duplicate keys, then if the incoming Event Title and Event Start Date match those of an existing event record, then the incoming record will be considered a duplicate of the already existing record. In that case, the system will either skip the incoming record, or overwrite the existing record.|,
        lastUpdated => 0,
        context => q|What's "field is dup key" mean?|,
    },

    'null field error recnum' => {
        message => q|The %s field cannot be blank (record %d).|,
        lastUpdated => 1179563424,
        context => q|When a required field is empty/blank, then this message is used in sprintf to tell the user which field it is and that it cannot be blank - it also shows the relevant import file record number|,
    },

    'null field error' => {
        message => q|The %s field cannot be blank.|,
        lastUpdated => 1138908251,
        context => q|When a required field is empty/blank, then this message is used in sprintf to tell the user which field it is and that it cannot be blank|,
    },

    'add to badge' => {
        message => q|Add To Badge|,
        lastUpdated => 1140466438,
        context => q|Label to invite the user to purchase this event and add it to their shopping cart.|,
    },

    'allowed sub events' => {
        message => q|You may also attend the following sub-events based on the events currently in your shopping cart.<br />|,
        lastUpdated => 1140469381,
    },

    'scheduling conflict message' => {
        message => q|You have a scheduling conflict.  Please remove one of the events below from your cart to resolve the problem.|,
        lastUpdated => 1142362442,
    },

    'scheduling conflict continue' => {
        message => q|Click here to continue|,
        lastUpdated => 1142362439,
    },

    'main template help title' => {
        message => q|Event Management System Main Template|,
        lastUpdated => 1215212860,
    },

    'main template help body' => {
        message => q|This template uses YUI to do most of the display work.  Please change the CSS in order to make display or style changes.|,
        lastUpdated => 1215212860,
    },

    'addBadgeUrl' => {
        message => q|URL to add a badge to the system.|,
        lastUpdated => 1215213297,
    },

    'buildBadgeUrl' => {
        message => q|URL to display information about the current badge.|,
        lastUpdated => 1215213340,
    },

    'manageBadgeGroupsUrl' => {
        message => q|URL to display a list of badge groups.|,
        lastUpdated => 1215213347,
    },

    'getBadgesUrl' => {
        message => q|URL to return badge information as JSON for the YUI datatable.|,
        lastUpdated => 1215212860,
    },

    'canEdit' => {
        message => q|A conditional indicating whether or not the current user can edit the Event Management System.|,
        lastUpdated => 1215213833,
    },

    'lookupRegistrantUrl' => {
        message => q|URL to get information about the badges for the current user, or for all users if the current user is part of the registration staff.|,
        lastUpdated => 1215213901,
    },

    'event template help title' => {
        message => q|Event Management System Event Template|,
        lastUpdated => 1140465899,
    },

    'short title' => {
        message => q|Title|,
        lastUpdated => 1149828404,
    },

    'title.url' => {
        message => q|A URL to display a list of events that contain this event|,
        lastUpdated => 1165513731,
    },

    'image' => {
        message => q|The image assigned to represent this event.|,
        lastUpdated => 1149828404,
    },

    'purchase.message' => {
        message => q|A message to ask the user whether or not they'd like to see subevents for this event.
If the event is full, this variable will be blank.|,
        lastUpdated => 1149828404,
    },

    'purchase.wantToSearch.url' => {
        message => q|A URL to search for events that are requirements for this event.
If the event is full, this variable will be blank.|,
        lastUpdated => 1149828404,
    },

    'purchase.wantToContinue.url' => {
        message => q|A URL to add this event to the cart.
If the event is full, this variable will be blank.|,
        lastUpdated => 1149828404,
    },

    'purchase.label' => {
        message => q|The internationalized label "Add To Cart".
If the event is full, this variable will be blank.|,
        lastUpdated => 1149828404,
    },

    'canReturnTransaction' => {
        message => q|A boolean that is true if any purchase can be returned.|,
        lastUpdated => 1149828601,
    },

    'transactionId' => {
        message => q|The unique identifier for this transaction in the database.|,
        lastUpdated => 1149828601,
    },

    'add/edit event template' => {
        message => q|Event Management System Event Template|,
        lastUpdated => 1140465899,
    },

    'type name here' => {
        message => q|Type Name Here|,
        lastUpdated => 1140469381,
    },

    'type label here' => {
        message => q|Type Label Here|,
        lastUpdated => 1140469381,
    },

    'sold out' => {
        message => q|Sold Out|,
        lastUpdated => 1140469381,
    },

    'confirm delete event metadata' => {
        message => q|Are you certain you want to delete this metadata field?  The metadata values for this field will be deleted from all events.|,
        lastUpdated => 1205860492,
    },

    'manage purchases' => {
        message => q|Manage Purchases|,
        lastUpdated => 1145396293,
    },

    'manage event metadata' => {
        message => q|Manage Event Metadata|,
        lastUpdated => 1213317997,
    },

    'view purchase' => {
        message => q|View Purchase|,
        lastUpdated => 1145396293,
    },

    'refresh events list' => {
        message => q|Refresh Events List|,
        lastUpdated => 1145396293,
    },

    'you' => {
        message => q|you|,
        lastUpdated => 1145396293,
        context => q|Second person pronoun|,
    },

    'create a badge for myself' => {
        message => q|Create a badge for myself|,
        lastUpdated => 1145396293,
    },

    'create a badge for someone else' => {
        message => q|Create a badge for someone else|,
        lastUpdated => 1145396293,
    },

    'select one' => {
        message => q|Select One|,
        lastUpdated => 1145400186,
        context => q|Label to indicate that the user should pick one thing from a list of options|,
    },

    'select one or more' => {
        message => q|Select one or more|,
        lastUpdated => 1147293240,
        context => q|Label to indicate that the user should pick one or more things from a list of options|,
    },

    'seats available' => {
        message     => q|Seats Available|,
        lastUpdated => 1145400186,
        context        => q|field label|,
    },

    'seats available help' => {
        message     => q|How many people may purchase this item before you run out of room?|,
        lastUpdated => 0,
        context        => q|field label help|,
    },

    'missing prerequisites message' => {
        message => q|Some of the events you have selected require attendance of another event.  Please satisfy prerequisites from the list below.|,
        lastUpdated => 1145402683,
    },

    'checkout' => {
        message => q|Checkout|,
        lastUpdated => 1145402683,
    },

    'filter' => {
        message => q|Filter|,
        lastUpdated => 1145402683,
        context => q|Button in search form to limit displayed eveed events based on user criteria|,
    },

    'managePrereqsMessage' => {
        message => q|Use the form below to add prerequisite assignments to %s.|,
        lastUpdated => 1145653451,
        context => q|Message for search form, that is passed to sprintf to fill in the name|,
    },

    'Admin manage sub events small resultset' => {
        message => q|You may manage the events below.  You can narrow the list of events displayed using the basic or advanced filter options above.|,
        lastUpdated => 1145653452,
    },

    'User sub events small resultset' => {
        message => q|You may also choose from the following sub-events.  You can narrow the list of sub-events by using the basic or advanced filter options above.|,
        lastUpdated => 1145653452,
    },

    'Admin manage sub events large resultset' => {
        message => q|You may manage the events below.  Due to the large number of sub-events available none are currently displayed, please narrow the results using the basic or advanced filter options above.|,
        lastUpdated => 1145653452,
    },

    'User sub events large resultset' => {
        message => q|You may also choose from the following sub-events.  Due to the large number of sub-events available none are currently displayed, please narrow the results using the basic or advanced filter options above.|,
        lastUpdated => 1145653452,
    },

    'option to narrow' => {
        message => q|You can narrow the list of prerequisites displayed using the basic or advanced filter options above.|,
        lastUpdated => 1145653452,
    },

    'forced narrowing' => {
        message => q|Due to the large number of prerequisites available none are currently displayed, please narrow the results using the basic or advanced filter options above.|,
        lastUpdated => 1145653452,
    },

    'first name' => {
        message => q|First Name|,
        lastUpdated => 1145743634,
        context => q|Given name|,
    },

    'last name' => {
        message => q|Last Name|,
        lastUpdated => 1145743634,
        context => q|Family name|,
    },

    'address' => {
        message => q|Address|,
        lastUpdated => 1145743634,
    },

    'city' => {
        message => q|City|,
        lastUpdated => 1145743634,
    },

    'state' => {
        message => q|State|,
        lastUpdated => 1145743634,
    },

    'zip code' => {
        message => q|Zip Code|,
        lastUpdated => 1145743634,
    },

    'country' => {
        message => q|Country|,
        lastUpdated => 1145743634,
    },

    'phone number' => {
        message => q|Phone Number|,
        lastUpdated => 1145743634,
    },

    'email address' => {
        message => q|Email Address|,
        lastUpdated => 1145743634,
    },

    'which badge' => {
        message => q|Which Badge|,
        lastUpdated => 1145743634,
    },

    'registration info message' => {
        message => q|<p>Enter Badge/Contact information for the series of events you are currently adding to the cart.</p>
<p>If you are logged in, you can choose to update your own user profile with this information by choosing your name from the drop-down box, or if your name is not listed, choose the option "Create badge for myself".</p>
<p>If you are making a purchase for someone else, select their name or select the "Create New for someone else" option from the drop-down box.  If you are adding items to a previous purchase, that badge is already selected, and cannot be changed.  If you make changes to the fields in this form for a badge that already exists, their information will be updated.</p>|,
        lastUpdated => 1146074906,
    },

    'manage prerequisites' => {
        message => q|Manage Prerequisites for this event|,
        lastUpdated => 1146075135,
    },

    'add to badge message' => {
        message => q|%s was added to your badge successfully.|,
        lastUpdated => 1146075135,
    },

    'sku template' => {
        message => q|SKU Template|,
        lastUpdated => 1146170715,
        context => q|The label for the sku template field in the edit product screen.|
    },

    'weight' => {
        message => q|Weight|,
        lastUpdated => 1146170737,
        context => q|Describing the physical weight of an object.|
    },

        'weight description' => {
                message => q|The weight of anything that may be associated with your event.|,
                lastUpdated => 1120449422,
        },

    'sku' => {
        message => q|SKU|,
        lastUpdated => 1146170838,
        context => q|The form label for the SKU (Stock Keeping Unit) field|
    },

    'sku description' => {
        message => q|A SKU Number to assign to the event.  A Globaly Unique Identifier is generated by default.|,
        lastUpdated => 1146170838,
    },

    'sku template' => {
        message => q|SKU Template|,
        lastUpdated => 1146170932,
        context => q|The label for the sku template field in the edit event screen.|
    },

    'sku template description' => {
        message => q|This field defines how the SKU for each
product variant will be composed. The syntax is the same as that of
normal templates.|,
        lastUpdated => 1146170930,
    },

    'error no colon' => {
        message => q|Error|,
        lastUpdated => 0,
    },

    'error' => {
        message => q|Error:|,
        lastUpdated => 1146170930,
    },

    'manage prerequisite sets' => {
        message => q|Manage Prerequisite Sets|,
        lastUpdated => 1147050475,
    },

    'export events' => {
        message => q|Export Events|,
        lastUpdated => 1179341015,
    },

    'import events' => {
        message => q|Import Events|,
        lastUpdated => 1179341015,
    },

    'enter import file' => {
        message => q|Please enter a file to import|,
        lastUpdated => 1179341015,
    },

    'manage discount passes' => {
        message => q|Manage Discount Passes|,
        lastUpdated => 1147050958,
    },

    'manage events' => {
        message => q|Manage Events|,
        lastUpdated => 1147050958,
    },

    'badge id' => {
        message => q|badgeId|,
        lastUpdated => 1147050958,
    },

    'choose a file to import' => {
        message => q|Choose a file to import|,
        lastUpdated => 0,        
    },

    'what about duplicates' => {
        message => q|What about duplicates?|,
        lastUpdated => 0,
        context => q|Import EMS data form|,
    },

    'ignore first line' => {
        message => q|Ignore first line?|,
        lastUpdated => 0,
        context => q|Import EMS data form|,
    },

    'yes' => {
        message => q|yes|,
        lastUpdated => 0,
    },

    'no' => {
        message => q|no|,
        lastUpdated => 0,
    },

    'skip' => {
        message => q|Skip|,
        lastUpdated => 0,
    },

    'overwrite' => {
        message => q|Overwrite|,
        lastUpdated => 0,
    },

    'status' => {
        message => q|Status|,
        lastUpdated => 0,
    },

    'ems asset template variables' => {
        message => q|Event Management System Asset Template Variables|,
        lastUpdated => 0,
    },

    'timezone help' => {
        message => q|The time zone that this event is configured to be in.|,
        lastUpdated => 0,
    },

    'templateId help' => {
        message => q|The ID of the template for the main Event Management System screen.|,
        lastUpdated => 0,
    },

    'badgeBuilderTemplateId help' => {
        message => q|The ID of the template for the badge builder screen.|,
        lastUpdated => 0,
    },

    'lookupRegistrantTemplateId help' => {
        message => q|The ID of the template for the lookup registrant screen.|,
        lastUpdated => 0,
    },

    'printBadgeTemplateId help' => {
        message => q|The ID of the template for printing a badge.|,
        lastUpdated => 0,
    },

    'printTicketTemplateId help' => {
        message => q|The ID of the template for printing a ticket.|,
        lastUpdated => 0,
    },

    'badgeInstructions help' => {
        message => q|Instructions to the user for what to do with a badge.|,
        lastUpdated => 0,
    },

    'ticketInstructions help' => {
        message => q|Instructions to the user for what to do with a ticket.|,
        lastUpdated => 0,
    },

    'ribbonInstructions help' => {
        message => q|Instructions to the user for what to do with a ribbon.|,
        lastUpdated => 0,
    },

    'tokenInstructions help' => {
        message => q|Instructions to the user for what to do with a token.|,
        lastUpdated => 0,
    },

    'registrationStaffGroupId help' => {
        message => q|The ID of the group set up to handle registration.|,
        lastUpdated => 0,
    },

    'registrationStaffGroupId help' => {
        message => q|The ID of the group set up to handle registration.|,
        lastUpdated => 0,
    },

     'event start date' => {
        message     => q|Start Date|,
        lastUpdated => 0,
        context     => q|Event start date field label in the badge builder screen|
    },

    'Event Number' => {
        message => q|Event Number|,
        lastUpdated => 1147058499,
        context => q|Synonym for SKU|,
    },

    'prereq set name field label' => {
        message => q|Prerequisite Set Name|,
        lastUpdated => 1147050475,
        context => q|Event data field|,
    },

};

1;
