SET @OLD_CHARACTER_SET_CLIENT       = @@CHARACTER_SET_CLIENT;
SET @OLD_CHARACTER_SET_RESULTS      = @@CHARACTER_SET_RESULTS;
SET @OLD_CHARACTER_SET_CONNECTION   = @@CHARACTER_SET_CONNECTION;
SET @OLD_COLLATION_CONNECTION       = @@COLLATION_CONNECTION;
SET @OLD_TIME_ZONE                  = @@TIME_ZONE;
SET @OLD_UNIQUE_CHECKS              = @@UNIQUE_CHECKS;
SET @OLD_FOREIGN_KEY_CHECKS         = @@FOREIGN_KEY_CHECKS;
SET @OLD_SQL_MODE                   = @@SQL_MODE;
SET @OLD_SQL_NOTES                  = @@SQL_NOTES;

SET CHARACTER_SET_CLIENT            = 'utf8';
SET CHARACTER_SET_RESULTS           = 'utf8';
SET CHARACTER_SET_CONNECTION        = 'utf8';
SET TIME_ZONE                       = '+00:00';
SET UNIQUE_CHECKS                   = 0;
SET FOREIGN_KEY_CHECKS              = 0;
SET SQL_MODE                        = 'NO_AUTO_VALUE_ON_ZERO';
SET SQL_NOTES                       = 0;
CREATE TABLE `AdSku` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `purchaseTemplate` char(22) binary NOT NULL,
  `manageTemplate` char(22) binary NOT NULL,
  `adSpace` char(22) binary NOT NULL,
  `priority` int(11) DEFAULT '1',
  `pricePerClick` float DEFAULT '0',
  `pricePerImpression` float DEFAULT '0',
  `clickDiscounts` char(22) DEFAULT NULL,
  `impressionDiscounts` char(22) DEFAULT NULL,
  `karma` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Article` (
  `linkTitle` char(255) DEFAULT NULL,
  `linkURL` text,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `storageId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `AssetReport` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `settings` mediumtext,
  `templateId` char(22) binary DEFAULT NULL,
  `paginateAfter` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Calendar` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `defaultDate` enum('current','first','last') DEFAULT 'current',
  `defaultView` enum('month','week','day','list') DEFAULT 'month',
  `visitorCacheTimeout` int(11) unsigned DEFAULT NULL,
  `templateIdMonth` char(22) binary DEFAULT 'CalendarMonth000000001',
  `templateIdWeek` char(22) binary DEFAULT 'CalendarWeek0000000001',
  `templateIdDay` char(22) binary DEFAULT 'CalendarDay00000000001',
  `templateIdEvent` char(22) binary DEFAULT 'CalendarEvent000000001',
  `templateIdEventEdit` char(22) binary DEFAULT 'CalendarEventEdit00001',
  `templateIdSearch` char(22) binary DEFAULT 'CalendarSearch00000001',
  `templateIdPrintMonth` char(22) binary DEFAULT 'CalendarPrintMonth0001',
  `templateIdPrintWeek` char(22) binary DEFAULT 'CalendarPrintWeek00001',
  `templateIdPrintDay` char(22) binary DEFAULT 'CalendarPrintDay000001',
  `templateIdPrintEvent` char(22) binary DEFAULT 'CalendarPrintEvent0001',
  `groupIdEventEdit` char(22) binary DEFAULT '3',
  `groupIdSubscribed` char(22) binary DEFAULT NULL,
  `subscriberNotifyOffset` int(11) DEFAULT NULL,
  `sortEventsBy` enum('time','sequencenumber') DEFAULT 'time',
  `listViewPageInterval` bigint(20) DEFAULT NULL,
  `templateIdList` char(22) binary DEFAULT NULL,
  `templateIdPrintList` char(22) binary DEFAULT NULL,
  `icalInterval` bigint(20) DEFAULT NULL,
  `workflowIdCommit` char(22) binary DEFAULT NULL,
  `icalFeeds` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Carousel` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `items` mediumtext,
  `templateId` char(22) binary DEFAULT NULL,
  `slideWidth` int(11) DEFAULT NULL,
  `slideHeight` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Collaboration` (
  `assetId` char(22) binary NOT NULL,
  `postGroupId` char(22) binary NOT NULL DEFAULT '2',
  `canStartThreadGroupId` char(22) binary NOT NULL DEFAULT '2',
  `karmaPerPost` int(11) NOT NULL DEFAULT '0',
  `collaborationTemplateId` char(22) binary NOT NULL,
  `threadTemplateId` char(22) binary NOT NULL,
  `postFormTemplateId` char(22) binary NOT NULL,
  `searchTemplateId` char(22) binary NOT NULL,
  `notificationTemplateId` char(22) binary NOT NULL,
  `sortBy` char(35) NOT NULL DEFAULT 'assetData.revisionDate',
  `sortOrder` char(4) NOT NULL DEFAULT 'desc',
  `usePreview` int(11) NOT NULL DEFAULT '1',
  `addEditStampToPosts` int(11) NOT NULL DEFAULT '0',
  `editTimeout` int(11) NOT NULL DEFAULT '3600',
  `attachmentsPerPost` int(11) NOT NULL DEFAULT '0',
  `filterCode` char(30) NOT NULL DEFAULT 'javascript',
  `useContentFilter` int(11) NOT NULL DEFAULT '1',
  `threads` int(11) NOT NULL DEFAULT '0',
  `views` int(11) NOT NULL DEFAULT '0',
  `replies` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `lastPostId` char(22) binary DEFAULT NULL,
  `lastPostDate` bigint(20) DEFAULT NULL,
  `archiveAfter` int(11) NOT NULL DEFAULT '31536000',
  `postsPerPage` int(11) NOT NULL DEFAULT '10',
  `threadsPerPage` int(11) NOT NULL DEFAULT '30',
  `subscriptionGroupId` char(22) binary DEFAULT NULL,
  `allowReplies` int(11) NOT NULL DEFAULT '0',
  `displayLastReply` int(11) NOT NULL DEFAULT '0',
  `richEditor` char(22) binary NOT NULL DEFAULT 'PBrichedit000000000002',
  `karmaRatingMultiplier` int(11) NOT NULL DEFAULT '0',
  `karmaSpentToRate` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `avatarsEnabled` int(11) NOT NULL DEFAULT '0',
  `approvalWorkflow` char(22) binary NOT NULL DEFAULT 'pbworkflow000000000003',
  `threadApprovalWorkflow` char(22) binary NOT NULL DEFAULT 'pbworkflow000000000003',
  `defaultKarmaScale` int(11) NOT NULL DEFAULT '1',
  `mailServer` char(255) DEFAULT NULL,
  `mailAccount` char(255) DEFAULT NULL,
  `mailPassword` char(255) DEFAULT NULL,
  `mailAddress` char(255) DEFAULT NULL,
  `mailPrefix` char(255) DEFAULT NULL,
  `getMail` int(11) NOT NULL DEFAULT '0',
  `getMailInterval` int(11) NOT NULL DEFAULT '300',
  `getMailCronId` char(22) binary DEFAULT NULL,
  `visitorCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `autoSubscribeToThread` int(11) NOT NULL DEFAULT '1',
  `requireSubscriptionForEmailPosting` int(11) NOT NULL DEFAULT '1',
  `thumbnailSize` int(11) NOT NULL DEFAULT '0',
  `maxImageSize` int(11) NOT NULL DEFAULT '0',
  `enablePostMetaData` int(11) NOT NULL DEFAULT '0',
  `useCaptcha` int(11) NOT NULL DEFAULT '0',
  `groupToEditPost` char(22) binary NOT NULL,
  `archiveEnabled` int(1) DEFAULT '1',
  `postReceivedTemplateId` char(22) binary DEFAULT 'default_post_received1',
  `replyRichEditor` char(22) binary DEFAULT 'PBrichedit000000000002',
  `replyFilterCode` char(30) binary DEFAULT 'javascript',
  `unsubscribeTemplateId` char(22) NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Dashboard` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `adminsGroupId` char(22) binary NOT NULL DEFAULT '4',
  `usersGroupId` char(22) binary NOT NULL DEFAULT '2',
  `templateId` char(22) binary NOT NULL DEFAULT 'DashboardViewTmpl00001',
  `isInitialized` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `assetsToHide` text,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `DataForm` (
  `acknowledgement` text,
  `mailData` int(11) NOT NULL DEFAULT '1',
  `emailTemplateId` char(22) binary NOT NULL,
  `acknowlegementTemplateId` char(22) binary NOT NULL,
  `listTemplateId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `defaultView` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `groupToViewEntries` char(22) binary NOT NULL DEFAULT '7',
  `mailAttachments` int(11) DEFAULT '0',
  `useCaptcha` int(1) DEFAULT '0',
  `storeData` int(1) DEFAULT '1',
  `fieldConfiguration` longtext,
  `tabConfiguration` longtext,
  `workflowIdAddEntry` char(22) binary DEFAULT NULL,
  `htmlAreaRichEditor` char(22) binary DEFAULT '**Use_Default_Editor**',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `DataForm_entry` (
  `DataForm_entryId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `username` char(255) DEFAULT NULL,
  `ipAddress` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `entryData` longtext,
  `submissionDate` datetime DEFAULT NULL,
  PRIMARY KEY (`DataForm_entryId`),
  KEY `assetId` (`assetId`),
  KEY `assetId_submissionDate` (`assetId`,`submissionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `DataTable` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `data` longtext,
  `templateId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSBadge` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL DEFAULT '0',
  `seatsAvailable` int(11) NOT NULL DEFAULT '100',
  `relatedBadgeGroups` mediumtext,
  `templateId` char(22) binary NOT NULL,
  `earlyBirdPrice` float NOT NULL DEFAULT '0',
  `earlyBirdPriceEndDate` bigint(20) DEFAULT NULL,
  `preRegistrationPrice` float NOT NULL DEFAULT '0',
  `preRegistrationPriceEndDate` bigint(20) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSBadgeGroup` (
  `badgeGroupId` char(22) binary NOT NULL,
  `emsAssetId` char(22) binary NOT NULL,
  `name` char(100) DEFAULT NULL,
  PRIMARY KEY (`badgeGroupId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSEventMetaField` (
  `fieldId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `label` char(100) DEFAULT NULL,
  `dataType` char(20) DEFAULT NULL,
  `visible` tinyint(4) DEFAULT '0',
  `required` tinyint(4) DEFAULT '0',
  `possibleValues` text,
  `defaultValues` text,
  `sequenceNumber` int(5) DEFAULT NULL,
  `helpText` mediumtext,
  PRIMARY KEY (`fieldId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSRegistrant` (
  `badgeId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `badgeNumber` int(11) NOT NULL AUTO_INCREMENT,
  `badgeAssetId` char(22) binary NOT NULL,
  `emsAssetId` char(22) binary NOT NULL,
  `name` char(35) NOT NULL,
  `address1` char(35) DEFAULT NULL,
  `address2` char(35) DEFAULT NULL,
  `address3` char(35) DEFAULT NULL,
  `city` char(35) DEFAULT NULL,
  `state` char(35) DEFAULT NULL,
  `zipcode` char(35) DEFAULT NULL,
  `country` char(35) DEFAULT NULL,
  `phoneNumber` char(35) DEFAULT NULL,
  `organization` char(35) DEFAULT NULL,
  `email` char(255) DEFAULT NULL,
  `notes` mediumtext,
  `purchaseComplete` tinyint(1) DEFAULT NULL,
  `hasCheckedIn` tinyint(1) DEFAULT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`badgeId`),
  UNIQUE KEY `badgeNumber` (`badgeNumber`),
  KEY `badgeAssetId_purchaseComplete` (`badgeAssetId`,`purchaseComplete`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSRegistrantRibbon` (
  `badgeId` char(22) binary NOT NULL,
  `ribbonAssetId` char(22) binary NOT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`badgeId`,`ribbonAssetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSRegistrantTicket` (
  `badgeId` char(22) binary NOT NULL,
  `ticketAssetId` char(22) binary NOT NULL,
  `purchaseComplete` tinyint(1) DEFAULT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`badgeId`,`ticketAssetId`),
  KEY `ticketAssetId_purchaseComplete` (`ticketAssetId`,`purchaseComplete`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSRegistrantToken` (
  `badgeId` char(22) binary NOT NULL,
  `tokenAssetId` char(22) binary NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `transactionItemIds` text,
  PRIMARY KEY (`badgeId`,`tokenAssetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSRibbon` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `percentageDiscount` float NOT NULL DEFAULT '10',
  `price` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSSubmission` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `submissionId` int(11) NOT NULL,
  `submissionStatus` char(30) DEFAULT NULL,
  `ticketId` char(22) binary DEFAULT NULL,
  `description` mediumtext,
  `sku` char(35) DEFAULT NULL,
  `vendorId` char(22) binary DEFAULT NULL,
  `displayTitle` tinyint(1) DEFAULT NULL,
  `shipsSeparately` tinyint(1) DEFAULT NULL,
  `price` float DEFAULT NULL,
  `seatsAvailable` int(11) DEFAULT NULL,
  `startDate` datetime DEFAULT NULL,
  `duration` float DEFAULT NULL,
  `eventNumber` int(11) DEFAULT NULL,
  `location` char(100) DEFAULT NULL,
  `relatedBadgeGroups` mediumtext,
  `relatedRibbons` mediumtext,
  `eventMetaData` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSSubmissionForm` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `canSubmitGroupId` char(22) binary DEFAULT NULL,
  `daysBeforeCleanup` int(11) DEFAULT NULL,
  `deleteCreatedItems` int(1) DEFAULT NULL,
  `formDescription` text,
  `submissionDeadline` date DEFAULT NULL,
  `pastDeadlineMessage` text,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSTicket` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL DEFAULT '0',
  `seatsAvailable` int(11) NOT NULL DEFAULT '100',
  `startDate` datetime DEFAULT NULL,
  `duration` float NOT NULL DEFAULT '1',
  `eventNumber` int(11) DEFAULT NULL,
  `location` char(100) DEFAULT NULL,
  `relatedBadgeGroups` mediumtext,
  `relatedRibbons` mediumtext,
  `eventMetaData` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EMSToken` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `price` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Event` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `feedId` char(22) binary DEFAULT NULL,
  `feedUid` char(255) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `recurId` char(22) binary DEFAULT NULL,
  `description` longtext,
  `startTime` time DEFAULT NULL,
  `endTime` time DEFAULT NULL,
  `relatedLinks` longtext,
  `location` char(255) DEFAULT NULL,
  `storageId` char(22) binary NOT NULL,
  `timeZone` char(255) DEFAULT 'America/Chicago',
  `sequenceNumber` bigint(20) DEFAULT NULL,
  `iCalSequenceNumber` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `EventManagementSystem` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `timezone` char(30) NOT NULL DEFAULT 'America/Chicago',
  `templateId` char(22) binary NOT NULL DEFAULT '2rC4ErZ3c77OJzJm7O5s3w',
  `badgeBuilderTemplateId` char(22) binary NOT NULL DEFAULT 'BMybD3cEnmXVk2wQ_qEsRQ',
  `lookupRegistrantTemplateId` char(22) binary NOT NULL DEFAULT 'OOyMH33plAy6oCj_QWrxtg',
  `printBadgeTemplateId` char(22) binary NOT NULL DEFAULT 'PsFn7dJt4wMwBa8hiE3hOA',
  `printTicketTemplateId` char(22) binary NOT NULL DEFAULT 'yBwydfooiLvhEFawJb0VTQ',
  `printRemainingTicketsTemplateId` char(22) NOT NULL DEFAULT 'hreA_bgxiTX-EzWCSZCZJw',
  `badgeInstructions` mediumtext,
  `ribbonInstructions` mediumtext,
  `ticketInstructions` mediumtext,
  `tokenInstructions` mediumtext,
  `registrationStaffGroupId` char(22) binary NOT NULL,
  `scheduleTemplateId` char(22) binary DEFAULT NULL,
  `scheduleColumnsPerPage` int(11) DEFAULT NULL,
  `eventSubmissionTemplateId` char(22) binary DEFAULT NULL,
  `eventSubmissionQueueTemplateId` char(22) binary DEFAULT NULL,
  `eventSubmissionMainTemplateId` char(22) binary DEFAULT NULL,
  `eventSubmissionGroups` mediumtext,
  `submittedLocationsList` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Event_recur` (
  `recurId` char(22) binary NOT NULL,
  `recurType` char(16) DEFAULT NULL,
  `pattern` char(255) DEFAULT NULL,
  `startDate` date DEFAULT NULL,
  `endDate` char(10) DEFAULT NULL,
  PRIMARY KEY (`recurId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Event_relatedlink` (
  `eventlinkId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `linkURL` tinytext,
  `linktext` char(80) DEFAULT NULL,
  `groupIdView` char(22) binary NOT NULL,
  `sequenceNumber` bigint(20) DEFAULT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `FileAsset` (
  `assetId` char(22) binary NOT NULL,
  `storageId` char(22) binary NOT NULL,
  `filename` char(255) NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `FlatDiscount` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT '63ix2-hU0FchXGIWkG3tow',
  `mustSpend` float NOT NULL DEFAULT '0',
  `percentageDiscount` int(3) NOT NULL DEFAULT '0',
  `priceDiscount` float NOT NULL DEFAULT '0',
  `thankYouMessage` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Folder` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `visitorCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `sortAlphabetically` int(11) NOT NULL DEFAULT '0',
  `sortOrder` enum('ASC','DESC') DEFAULT 'ASC',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Gallery` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupIdAddComment` char(22) binary DEFAULT NULL,
  `groupIdAddFile` char(22) binary DEFAULT NULL,
  `imageResolutions` text,
  `imageViewSize` int(11) DEFAULT NULL,
  `imageThumbnailSize` int(11) DEFAULT NULL,
  `maxSpacePerUser` char(20) DEFAULT NULL,
  `richEditIdComment` char(22) binary DEFAULT NULL,
  `templateIdAddArchive` char(22) binary DEFAULT NULL,
  `templateIdDeleteAlbum` char(22) binary DEFAULT NULL,
  `templateIdDeleteFile` char(22) binary DEFAULT NULL,
  `templateIdEditAlbum` char(22) binary DEFAULT NULL,
  `templateIdEditFile` char(22) binary DEFAULT NULL,
  `templateIdListAlbums` char(22) binary DEFAULT NULL,
  `templateIdListAlbumsRss` char(22) binary DEFAULT NULL,
  `templateIdListFilesForUser` char(22) binary DEFAULT NULL,
  `templateIdListFilesForUserRss` char(22) binary DEFAULT NULL,
  `templateIdMakeShortcut` char(22) binary DEFAULT NULL,
  `templateIdSearch` char(22) binary DEFAULT NULL,
  `templateIdViewSlideshow` char(22) binary DEFAULT NULL,
  `templateIdViewThumbnails` char(22) binary DEFAULT NULL,
  `templateIdViewAlbum` char(22) binary DEFAULT NULL,
  `templateIdViewAlbumRss` char(22) binary DEFAULT NULL,
  `templateIdViewFile` char(22) binary DEFAULT NULL,
  `viewAlbumAssetId` char(22) binary DEFAULT NULL,
  `viewDefault` enum('album','list') DEFAULT NULL,
  `viewListOrderBy` char(40) DEFAULT NULL,
  `viewListOrderDirection` enum('ASC','DESC') DEFAULT NULL,
  `workflowIdCommit` char(22) binary DEFAULT NULL,
  `templateIdEditComment` char(22) binary DEFAULT NULL,
  `richEditIdAlbum` char(22) binary DEFAULT NULL,
  `richEditIdFile` char(22) binary DEFAULT NULL,
  `defaultFilesPerPage` int(11) DEFAULT NULL,
  `imageDensity` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `GalleryAlbum` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `allowComments` int(11) DEFAULT NULL,
  `assetIdThumbnail` char(22) binary DEFAULT NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `othersCanAdd` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `GalleryFile` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `userDefined1` longtext,
  `userDefined2` longtext,
  `userDefined3` longtext,
  `userDefined4` longtext,
  `userDefined5` longtext,
  `views` bigint(20) DEFAULT '0',
  `friendsOnly` int(1) DEFAULT '0',
  `rating` int(1) DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `GalleryFile_comment` (
  `assetId` char(22) binary NOT NULL,
  `commentId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `visitorIp` char(255) DEFAULT NULL,
  `creationDate` datetime DEFAULT NULL,
  `bodyText` longtext,
  PRIMARY KEY (`assetId`,`commentId`),
  KEY `commentId` (`commentId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `HttpProxy` (
  `proxiedUrl` text,
  `timeout` int(11) DEFAULT NULL,
  `removeStyle` int(11) DEFAULT NULL,
  `filterHtml` char(30) DEFAULT NULL,
  `followExternal` int(11) DEFAULT NULL,
  `followRedirect` int(11) DEFAULT NULL,
  `cacheHttp` int(11) DEFAULT '0',
  `useCache` int(11) DEFAULT '0',
  `debug` int(11) DEFAULT '0',
  `rewriteUrls` int(11) DEFAULT NULL,
  `searchFor` char(255) DEFAULT NULL,
  `stopAt` char(255) DEFAULT NULL,
  `cookieJarStorageId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '0',
  `useAmpersand` int(11) NOT NULL DEFAULT '0',
  `urlPatternFilter` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `ImageAsset` (
  `assetId` char(22) binary NOT NULL,
  `thumbnailSize` int(11) NOT NULL DEFAULT '50',
  `parameters` text,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `annotations` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `InOutBoard` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `statusList` text,
  `reportViewerGroup` char(22) binary NOT NULL DEFAULT '3',
  `inOutGroup` char(22) binary NOT NULL DEFAULT '2',
  `inOutTemplateId` char(22) binary NOT NULL DEFAULT 'IOB0000000000000000001',
  `reportTemplateId` char(22) binary NOT NULL DEFAULT 'IOB0000000000000000002',
  `paginateAfter` int(11) NOT NULL DEFAULT '50',
  `reportPaginateAfter` int(11) NOT NULL DEFAULT '50',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `InOutBoard_delegates` (
  `userId` char(22) binary NOT NULL,
  `delegateUserId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `InOutBoard_status` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `status` char(255) DEFAULT NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `InOutBoard_statusLog` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `status` char(255) DEFAULT NULL,
  `dateStamp` int(11) NOT NULL,
  `message` text,
  `createdBy` char(22) binary DEFAULT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Layout` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `contentPositions` text,
  `assetsToHide` text,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `assetOrder` char(20) DEFAULT 'asc',
  `mobileTemplateId` char(22) binary DEFAULT 'PBtmpl0000000000000054',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Map` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupIdAddPoint` char(22) binary DEFAULT NULL,
  `mapApiKey` text,
  `mapHeight` char(12) DEFAULT NULL,
  `mapWidth` char(12) DEFAULT NULL,
  `startLatitude` float DEFAULT NULL,
  `startLongitude` float DEFAULT NULL,
  `startZoom` tinyint(3) unsigned DEFAULT NULL,
  `templateIdEditPoint` char(22) binary DEFAULT NULL,
  `templateIdView` char(22) binary DEFAULT NULL,
  `templateIdViewPoint` char(22) binary DEFAULT NULL,
  `workflowIdPoint` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `MapPoint` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `latitude` float DEFAULT NULL,
  `longitude` float DEFAULT NULL,
  `website` char(255) DEFAULT NULL,
  `address1` char(35) DEFAULT NULL,
  `address2` char(35) DEFAULT NULL,
  `city` char(35) DEFAULT NULL,
  `region` char(35) DEFAULT NULL,
  `zipCode` char(35) DEFAULT NULL,
  `country` char(35) DEFAULT NULL,
  `phone` char(22) binary DEFAULT NULL,
  `fax` char(22) binary DEFAULT NULL,
  `email` char(35) DEFAULT NULL,
  `storageIdPhoto` char(22) binary DEFAULT NULL,
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Matrix` (
  `detailTemplateId` char(22) binary DEFAULT NULL,
  `compareTemplateId` char(22) binary DEFAULT NULL,
  `searchTemplateId` char(22) binary DEFAULT NULL,
  `categories` text,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `maxComparisons` int(11) NOT NULL DEFAULT '10',
  `maxComparisonsPrivileged` int(11) NOT NULL DEFAULT '10',
  `defaultSort` char(22) binary NOT NULL DEFAULT 'score',
  `compareColorNo` char(22) binary DEFAULT '#ffaaaa',
  `compareColorLimited` char(22) binary NOT NULL DEFAULT '#ffffaa',
  `compareColorCostsExtra` char(22) binary NOT NULL DEFAULT '#ffffaa',
  `compareColorFreeAddOn` char(22) binary NOT NULL DEFAULT '#ffffaa',
  `compareColorYes` char(22) binary NOT NULL DEFAULT '#aaffaa',
  `submissionApprovalWorkflowId` char(22) binary NOT NULL,
  `ratingsDuration` int(11) NOT NULL DEFAULT '7776000',
  `editListingTemplateId` char(22) binary DEFAULT NULL,
  `groupToAdd` char(22) binary DEFAULT '2',
  `screenshotsConfigTemplateId` char(22) binary DEFAULT NULL,
  `screenshotsTemplateId` char(22) binary DEFAULT NULL,
  `statisticsCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `maxScreenshotWidth` int(11) DEFAULT NULL,
  `maxScreenshotHeight` int(11) DEFAULT NULL,
  `listingsCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `maxComparisonsGroup` char(22) binary DEFAULT NULL,
  `maxComparisonsGroupInt` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `MatrixListing` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `screenshots` char(22) binary DEFAULT NULL,
  `description` text,
  `version` char(255) DEFAULT NULL,
  `views` int(11) DEFAULT NULL,
  `compares` int(11) DEFAULT NULL,
  `clicks` int(11) DEFAULT NULL,
  `viewsLastIp` char(255) DEFAULT NULL,
  `comparesLastIp` char(255) DEFAULT NULL,
  `clicksLastIp` char(255) DEFAULT NULL,
  `lastUpdated` int(11) DEFAULT NULL,
  `maintainer` char(22) binary DEFAULT NULL,
  `manufacturerName` char(255) DEFAULT NULL,
  `manufacturerURL` char(255) DEFAULT NULL,
  `productURL` char(255) DEFAULT NULL,
  `score` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `MatrixListing_attribute` (
  `matrixId` char(22) binary NOT NULL,
  `matrixListingId` char(22) binary NOT NULL,
  `attributeId` char(22) binary NOT NULL,
  `value` char(255) DEFAULT NULL,
  PRIMARY KEY (`attributeId`,`matrixListingId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `MatrixListing_rating` (
  `timeStamp` int(11) NOT NULL DEFAULT '0',
  `category` char(255) DEFAULT NULL,
  `rating` int(11) NOT NULL DEFAULT '1',
  `listingId` char(22) binary NOT NULL,
  `ipAddress` char(15) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `MatrixListing_ratingSummary` (
  `listingId` char(22) binary NOT NULL,
  `category` char(255) NOT NULL,
  `meanValue` decimal(3,2) DEFAULT NULL,
  `medianValue` int(11) DEFAULT NULL,
  `countValue` int(11) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  PRIMARY KEY (`listingId`,`category`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Matrix_attribute` (
  `attributeId` char(22) binary NOT NULL,
  `category` char(255) NOT NULL,
  `name` char(255) DEFAULT NULL,
  `description` text,
  `fieldType` char(255) NOT NULL DEFAULT 'MatrixCompare',
  `defaultValue` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `options` text,
  PRIMARY KEY (`attributeId`),
  KEY `categoryIndex` (`category`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `MessageBoard` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `visitorCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `MultiSearch` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT 'MultiSearchTmpl0000001',
  `predefinedSearches` text,
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Navigation` (
  `assetId` char(22) binary NOT NULL,
  `assetsToInclude` text,
  `startType` char(35) DEFAULT NULL,
  `startPoint` char(255) DEFAULT NULL,
  `descendantEndPoint` int(11) NOT NULL DEFAULT '55',
  `showSystemPages` int(11) NOT NULL DEFAULT '0',
  `showHiddenPages` int(11) NOT NULL DEFAULT '0',
  `showUnprivilegedPages` int(11) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL,
  `ancestorEndPoint` int(11) NOT NULL DEFAULT '55',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `mimeType` char(50) DEFAULT 'text/html',
  `reversePageLoop` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Newsletter` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `newsletterTemplateId` char(22) binary NOT NULL DEFAULT 'newsletter000000000001',
  `mySubscriptionsTemplateId` char(22) binary NOT NULL DEFAULT 'newslettersubscrip0001',
  `newsletterHeader` mediumtext,
  `newsletterFooter` mediumtext,
  `newsletterCategories` text,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Newsletter_subscriptions` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `subscriptions` text,
  `lastTimeSent` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`userId`),
  KEY `lastTimeSent_assetId_userId` (`lastTimeSent`,`assetId`,`userId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `PM_project` (
  `projectId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `name` char(255) NOT NULL,
  `description` text,
  `startDate` bigint(20) DEFAULT NULL,
  `endDate` bigint(20) DEFAULT NULL,
  `projectManager` char(22) binary DEFAULT NULL,
  `durationUnits` enum('hours','days') DEFAULT 'hours',
  `hoursPerDay` float DEFAULT NULL,
  `targetBudget` float(15,2) DEFAULT '0.00',
  `percentComplete` float NOT NULL DEFAULT '0',
  `parentId` char(22) binary DEFAULT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `projectObserver` char(22) binary DEFAULT '7',
  PRIMARY KEY (`projectId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `PM_task` (
  `taskId` char(22) binary NOT NULL,
  `projectId` char(22) binary NOT NULL,
  `taskName` char(255) NOT NULL,
  `duration` float DEFAULT NULL,
  `startDate` bigint(20) DEFAULT NULL,
  `endDate` bigint(20) DEFAULT NULL,
  `dependants` char(50) DEFAULT NULL,
  `parentId` char(22) binary DEFAULT NULL,
  `percentComplete` float DEFAULT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  `lagTime` bigint(20) DEFAULT '0',
  `taskType` enum('timed','progressive','milestone') NOT NULL DEFAULT 'timed',
  PRIMARY KEY (`taskId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `PM_taskResource` (
  `taskResourceId` char(22) binary NOT NULL,
  `taskId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL,
  `resourceKind` enum('user','group') NOT NULL,
  `resourceId` char(22) binary NOT NULL,
  PRIMARY KEY (`taskResourceId`),
  UNIQUE KEY `taskId` (`taskId`,`resourceKind`,`resourceId`),
  UNIQUE KEY `taskId_2` (`taskId`,`sequenceNumber`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `PM_wobject` (
  `assetId` char(22) binary NOT NULL,
  `projectDashboardTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0001',
  `projectDisplayTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0002',
  `ganttChartTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0003',
  `editTaskTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0004',
  `groupToAdd` char(22) binary NOT NULL DEFAULT '3',
  `revisionDate` bigint(20) NOT NULL,
  `resourcePopupTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0005',
  `resourceListTemplateId` char(22) binary NOT NULL DEFAULT 'ProjectManagerTMPL0006',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Photo` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `exifData` longtext,
  `location` char(255) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Photo_rating` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `visitorIp` char(255) DEFAULT NULL,
  `rating` int(11) DEFAULT NULL,
  KEY `assetId` (`assetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Poll` (
  `active` int(11) NOT NULL DEFAULT '1',
  `graphWidth` int(11) NOT NULL DEFAULT '150',
  `voteGroup` char(22) binary DEFAULT NULL,
  `question` char(255) DEFAULT NULL,
  `a1` char(255) DEFAULT NULL,
  `a2` char(255) DEFAULT NULL,
  `a3` char(255) DEFAULT NULL,
  `a4` char(255) DEFAULT NULL,
  `a5` char(255) DEFAULT NULL,
  `a6` char(255) DEFAULT NULL,
  `a7` char(255) DEFAULT NULL,
  `a8` char(255) DEFAULT NULL,
  `a9` char(255) DEFAULT NULL,
  `a10` char(255) DEFAULT NULL,
  `a11` char(255) DEFAULT NULL,
  `a12` char(255) DEFAULT NULL,
  `a13` char(255) DEFAULT NULL,
  `a14` char(255) DEFAULT NULL,
  `a15` char(255) DEFAULT NULL,
  `a16` char(255) DEFAULT NULL,
  `a17` char(255) DEFAULT NULL,
  `a18` char(255) DEFAULT NULL,
  `a19` char(255) DEFAULT NULL,
  `a20` char(255) DEFAULT NULL,
  `karmaPerVote` int(11) NOT NULL DEFAULT '0',
  `randomizeAnswers` int(11) NOT NULL DEFAULT '0',
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `graphConfiguration` blob,
  `generateGraph` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Poll_answer` (
  `answer` char(3) DEFAULT NULL,
  `userId` char(22) binary NOT NULL,
  `ipAddress` char(50) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Post` (
  `assetId` char(22) binary NOT NULL,
  `threadId` char(22) binary NOT NULL,
  `username` char(30) DEFAULT NULL,
  `content` mediumtext,
  `views` int(11) NOT NULL DEFAULT '0',
  `contentType` char(35) NOT NULL DEFAULT 'mixed',
  `userDefined1` text,
  `userDefined2` text,
  `userDefined3` text,
  `userDefined4` text,
  `userDefined5` text,
  `storageId` char(22) binary NOT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `originalEmail` mediumtext,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `threadId_rating` (`threadId`,`rating`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Post_rating` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `ipAddress` char(15) NOT NULL,
  `dateOfRating` bigint(20) DEFAULT NULL,
  `rating` int(11) NOT NULL DEFAULT '0',
  KEY `assetId_userId` (`assetId`,`userId`),
  KEY `assetId_ipAddress` (`assetId`,`ipAddress`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Product` (
  `image1` char(255) DEFAULT NULL,
  `image2` char(255) DEFAULT NULL,
  `image3` char(255) DEFAULT NULL,
  `brochure` char(255) DEFAULT NULL,
  `manual` char(255) DEFAULT NULL,
  `warranty` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `thankYouMessage` mediumtext,
  `accessoryJSON` longtext,
  `benefitJSON` longtext,
  `featureJSON` longtext,
  `relatedJSON` longtext,
  `specificationJSON` longtext,
  `variantsJSON` longtext,
  `isShippingRequired` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `RichEdit` (
  `assetId` char(22) binary NOT NULL,
  `askAboutRichEdit` int(11) NOT NULL DEFAULT '0',
  `preformatted` int(11) NOT NULL DEFAULT '0',
  `editorWidth` int(11) NOT NULL DEFAULT '0',
  `editorHeight` int(11) NOT NULL DEFAULT '0',
  `sourceEditorWidth` int(11) NOT NULL DEFAULT '0',
  `sourceEditorHeight` int(11) NOT NULL DEFAULT '0',
  `useBr` int(11) NOT NULL DEFAULT '0',
  `nowrap` int(11) NOT NULL DEFAULT '0',
  `removeLineBreaks` int(11) NOT NULL DEFAULT '0',
  `npwrap` int(11) NOT NULL DEFAULT '0',
  `directionality` char(3) NOT NULL DEFAULT 'ltr',
  `toolbarLocation` char(6) NOT NULL DEFAULT 'bottom',
  `cssFile` char(255) DEFAULT NULL,
  `validElements` mediumtext,
  `toolbarRow1` text,
  `toolbarRow2` text,
  `toolbarRow3` text,
  `enableContextMenu` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `disableRichEditor` int(11) DEFAULT '0',
  `inlinePopups` int(11) NOT NULL DEFAULT '0',
  `allowMedia` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `SQLReport` (
  `dbQuery1` text,
  `paginateAfter` int(11) NOT NULL DEFAULT '50',
  `preprocessMacros1` int(11) DEFAULT '0',
  `debugMode` int(11) NOT NULL DEFAULT '0',
  `databaseLinkId1` char(22) binary NOT NULL,
  `placeholderParams1` text,
  `preprocessMacros2` int(11) DEFAULT '0',
  `dbQuery2` text,
  `placeholderParams2` text,
  `databaseLinkId2` char(22) binary NOT NULL,
  `preprocessMacros3` int(11) DEFAULT '0',
  `dbQuery3` text,
  `placeholderParams3` text,
  `databaseLinkId3` char(22) binary NOT NULL,
  `preprocessMacros4` int(11) DEFAULT '0',
  `dbQuery4` text,
  `placeholderParams4` text,
  `databaseLinkId4` char(22) binary NOT NULL,
  `preprocessMacros5` int(11) DEFAULT '0',
  `dbQuery5` text,
  `placeholderParams5` text,
  `databaseLinkId5` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '0',
  `prequeryStatements1` text,
  `prequeryStatements2` text,
  `prequeryStatements3` text,
  `prequeryStatements4` text,
  `prequeryStatements5` text,
  `downloadType` char(255) DEFAULT NULL,
  `downloadFilename` char(255) DEFAULT NULL,
  `downloadTemplateId` char(22) binary DEFAULT NULL,
  `downloadMimeType` char(255) DEFAULT NULL,
  `downloadUserGroup` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Shelf` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT 'nFen0xjkZn8WkpM93C9ceQ',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Shortcut` (
  `overrideTitle` int(11) NOT NULL DEFAULT '0',
  `overrideDescription` int(11) NOT NULL DEFAULT '0',
  `overrideTemplate` int(11) NOT NULL DEFAULT '0',
  `overrideDisplayTitle` int(11) NOT NULL DEFAULT '0',
  `overrideTemplateId` char(22) binary NOT NULL,
  `shortcutByCriteria` int(11) NOT NULL DEFAULT '0',
  `resolveMultiples` char(30) DEFAULT 'mostRecent',
  `shortcutCriteria` text NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `shortcutToAssetId` char(22) binary NOT NULL,
  `disableContentLock` int(11) NOT NULL DEFAULT '0',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `prefFieldsToShow` text,
  `prefFieldsToImport` text,
  `showReloadIcon` tinyint(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Shortcut_overrides` (
  `assetId` char(22) binary NOT NULL,
  `fieldName` char(255) NOT NULL,
  `newValue` text,
  PRIMARY KEY (`assetId`,`fieldName`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `StockData` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL DEFAULT 'StockListTMPL000000001',
  `displayTemplateId` char(22) binary NOT NULL DEFAULT 'StockListTMPL000000002',
  `defaultStocks` text,
  `source` char(50) DEFAULT 'usa',
  `failover` int(11) DEFAULT '1',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Story` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `headline` char(255) DEFAULT NULL,
  `subtitle` char(255) DEFAULT NULL,
  `byline` char(255) DEFAULT NULL,
  `location` char(255) DEFAULT NULL,
  `highlights` text,
  `story` mediumtext,
  `photo` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `StoryArchive` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `storiesPerPage` int(11) DEFAULT NULL,
  `groupToPost` char(22) binary DEFAULT NULL,
  `templateId` char(22) binary DEFAULT NULL,
  `storyTemplateId` char(22) binary DEFAULT NULL,
  `editStoryTemplateId` char(22) binary DEFAULT NULL,
  `keywordListTemplateId` char(22) binary DEFAULT NULL,
  `archiveAfter` int(11) DEFAULT NULL,
  `richEditorId` char(22) binary DEFAULT NULL,
  `approvalWorkflowId` char(22) binary DEFAULT 'pbworkflow000000000003',
  `photoWidth` int(11) DEFAULT NULL,
  `storySortOrder` char(22) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `StoryTopic` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `storiesPer` int(11) DEFAULT NULL,
  `storiesShort` int(11) DEFAULT NULL,
  `templateId` char(22) binary DEFAULT NULL,
  `storyTemplateId` char(22) binary DEFAULT NULL,
  `storySortOrder` char(22) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Subscription` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `thankYouMessage` mediumtext,
  `price` float NOT NULL DEFAULT '0',
  `subscriptionGroup` char(22) binary NOT NULL DEFAULT '2',
  `duration` char(12) NOT NULL DEFAULT 'Monthly',
  `executeOnSubscription` char(255) DEFAULT NULL,
  `karma` int(6) DEFAULT '0',
  `recurringSubscription` tinyint(1) NOT NULL DEFAULT '1',
  `redeemSubscriptionCodeTemplateId` char(22) binary NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Subscription_code` (
  `code` char(64) NOT NULL,
  `batchId` char(22) binary NOT NULL,
  `status` char(10) NOT NULL DEFAULT 'Unused',
  `dateUsed` bigint(20) DEFAULT NULL,
  `usedBy` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`code`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Subscription_codeBatch` (
  `batchId` char(22) binary NOT NULL,
  `name` char(255) DEFAULT NULL,
  `description` mediumtext,
  `subscriptionId` char(22) binary NOT NULL,
  `expirationDate` bigint(20) NOT NULL,
  `dateCreated` bigint(20) NOT NULL,
  PRIMARY KEY (`batchId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Survey` (
  `groupToTakeSurvey` char(22) binary NOT NULL DEFAULT '2',
  `groupToEditSurvey` char(22) binary NOT NULL DEFAULT '3',
  `groupToViewReports` char(22) binary NOT NULL DEFAULT '3',
  `overviewTemplateId` char(22) binary NOT NULL,
  `maxResponsesPerUser` int(11) NOT NULL DEFAULT '1',
  `gradebookTemplateId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `surveyEditTemplateId` char(22) binary DEFAULT NULL,
  `answerEditTemplateId` char(22) binary DEFAULT NULL,
  `questionEditTemplateId` char(22) binary DEFAULT NULL,
  `sectionEditTemplateId` char(22) binary DEFAULT NULL,
  `surveyTakeTemplateId` char(22) binary DEFAULT NULL,
  `surveyQuestionsId` char(22) binary DEFAULT NULL,
  `exitURL` text,
  `surveyJSON` longtext,
  `timeLimit` mediumint(8) unsigned NOT NULL,
  `showProgress` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `showTimeLimit` tinyint(3) unsigned NOT NULL DEFAULT '0',
  `doAfterTimeLimit` char(22) binary DEFAULT NULL,
  `onSurveyEndWorkflowId` char(22) binary DEFAULT NULL,
  `quizModeSummary` tinyint(3) DEFAULT NULL,
  `surveySummaryTemplateId` char(22) binary DEFAULT NULL,
  `allowBackBtn` tinyint(3) DEFAULT NULL,
  `feedbackTemplateId` char(22) binary DEFAULT NULL,
  `testResultsTemplateId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Survey_questionTypes` (
  `questionType` char(56) NOT NULL,
  `answers` text NOT NULL,
  PRIMARY KEY (`questionType`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Survey_response` (
  `assetId` char(22) binary NOT NULL,
  `Survey_responseId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `username` char(255) DEFAULT NULL,
  `ipAddress` char(15) DEFAULT NULL,
  `startDate` bigint(20) NOT NULL DEFAULT '0',
  `endDate` bigint(20) NOT NULL DEFAULT '0',
  `isComplete` int(11) NOT NULL DEFAULT '0',
  `anonId` char(255) DEFAULT NULL,
  `responseJSON` longtext,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`Survey_responseId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Survey_tempReport` (
  `assetId` char(22) binary NOT NULL,
  `Survey_responseId` char(22) binary NOT NULL,
  `order` smallint(5) unsigned NOT NULL,
  `sectionNumber` smallint(5) unsigned NOT NULL,
  `sectionName` text,
  `questionNumber` smallint(5) unsigned NOT NULL,
  `questionName` text,
  `questionComment` mediumtext,
  `answerNumber` smallint(5) unsigned DEFAULT NULL,
  `answerValue` mediumtext,
  `answerComment` mediumtext,
  `entryDate` bigint(20) unsigned NOT NULL COMMENT 'UTC Unix Time',
  `isCorrect` tinyint(3) unsigned DEFAULT NULL,
  `value` int(11) DEFAULT NULL,
  `fileStoreageId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`Survey_responseId`,`order`),
  KEY `assetId` (`assetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Survey_test` (
  `testId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `assetId` char(255) DEFAULT NULL,
  `name` char(255) DEFAULT NULL,
  `test` mediumtext NOT NULL,
  PRIMARY KEY (`testId`),
  KEY `assetId` (`assetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `SyndicatedContent` (
  `rssUrl` text,
  `maxHeadlines` int(11) NOT NULL DEFAULT '0',
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `hasTerms` char(255) NOT NULL,
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `processMacroInRssUrl` int(11) DEFAULT '0',
  `sortItems` char(255) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `TT_projectList` (
  `projectId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `projectName` char(255) NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL,
  PRIMARY KEY (`projectId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `TT_projectResourceList` (
  `projectId` char(22) binary NOT NULL,
  `resourceId` char(22) binary NOT NULL,
  PRIMARY KEY (`projectId`,`resourceId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `TT_projectTasks` (
  `taskId` char(22) binary NOT NULL,
  `projectId` char(22) binary NOT NULL,
  `taskName` char(255) NOT NULL,
  PRIMARY KEY (`taskId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `TT_report` (
  `reportId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `startDate` char(10) NOT NULL,
  `endDate` char(10) NOT NULL,
  `reportComplete` int(11) NOT NULL DEFAULT '0',
  `resourceId` char(22) binary NOT NULL,
  `creationDate` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `lastUpdatedBy` char(22) binary NOT NULL,
  `lastUpdateDate` bigint(20) NOT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `TT_timeEntry` (
  `entryId` char(22) binary NOT NULL,
  `projectId` char(22) binary NOT NULL,
  `taskId` char(22) binary NOT NULL,
  `taskDate` char(10) NOT NULL,
  `hours` float DEFAULT '0',
  `comments` text,
  `reportId` char(22) binary NOT NULL,
  PRIMARY KEY (`entryId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `TT_wobject` (
  `assetId` char(22) binary NOT NULL,
  `userViewTemplateId` char(22) binary NOT NULL DEFAULT 'TimeTrackingTMPL000001',
  `managerViewTemplateId` char(22) binary NOT NULL DEFAULT 'TimeTrackingTMPL000002',
  `timeRowTemplateId` char(22) binary NOT NULL DEFAULT 'TimeTrackingTMPL000003',
  `pmAssetId` char(22) binary DEFAULT NULL,
  `groupToManage` char(22) binary NOT NULL DEFAULT '3',
  `revisionDate` bigint(20) NOT NULL,
  `pmIntegration` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Thingy` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `defaultThingId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `ThingyRecord` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `templateIdView` char(22) binary DEFAULT NULL,
  `thingId` char(22) binary DEFAULT NULL,
  `thingFields` longtext,
  `thankYouText` longtext,
  `price` float DEFAULT NULL,
  `duration` bigint(20) DEFAULT NULL,
  `fieldPrice` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `ThingyRecord_record` (
  `recordId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `transactionId` char(255) DEFAULT NULL,
  `assetId` char(255) DEFAULT NULL,
  `expires` bigint(20) NOT NULL DEFAULT '0',
  `userId` char(255) DEFAULT NULL,
  `fields` longtext,
  `isHidden` tinyint(1) NOT NULL DEFAULT '0',
  `sentExpiresNotice` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`recordId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Thingy_fields` (
  `assetId` char(22) binary NOT NULL,
  `thingId` char(22) binary NOT NULL,
  `fieldId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL,
  `dateCreated` bigint(20) NOT NULL,
  `createdBy` char(22) binary NOT NULL,
  `dateUpdated` bigint(20) NOT NULL,
  `updatedBy` char(22) binary NOT NULL,
  `label` char(255) NOT NULL,
  `fieldType` char(255) NOT NULL,
  `defaultValue` longtext,
  `possibleValues` text,
  `subtext` char(255) DEFAULT NULL,
  `status` char(255) NOT NULL,
  `width` int(11) DEFAULT NULL,
  `height` int(11) DEFAULT NULL,
  `vertical` smallint(1) DEFAULT NULL,
  `extras` char(255) DEFAULT NULL,
  `display` int(11) DEFAULT NULL,
  `viewScreenTitle` int(11) DEFAULT NULL,
  `displayInSearch` int(11) DEFAULT NULL,
  `searchIn` int(11) DEFAULT NULL,
  `fieldInOtherThingId` char(22) binary DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  `pretext` char(255) DEFAULT NULL,
  PRIMARY KEY (`fieldId`,`thingId`,`assetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Thingy_things` (
  `assetId` char(22) binary NOT NULL,
  `thingId` char(22) binary NOT NULL,
  `label` char(255) NOT NULL,
  `editScreenTitle` char(255) NOT NULL,
  `editInstructions` text,
  `groupIdAdd` char(22) binary NOT NULL,
  `groupIdEdit` char(22) binary NOT NULL,
  `saveButtonLabel` char(255) NOT NULL,
  `afterSave` char(255) NOT NULL,
  `editTemplateId` char(22) binary NOT NULL,
  `onAddWorkflowId` char(22) binary DEFAULT NULL,
  `onEditWorkflowId` char(22) binary DEFAULT NULL,
  `onDeleteWorkflowId` char(22) binary DEFAULT NULL,
  `groupIdView` char(22) binary NOT NULL,
  `viewTemplateId` char(22) binary NOT NULL,
  `defaultView` char(255) NOT NULL,
  `searchScreenTitle` char(255) NOT NULL,
  `searchDescription` text,
  `groupIdSearch` char(22) binary NOT NULL,
  `groupIdImport` char(22) binary NOT NULL,
  `groupIdExport` char(22) binary NOT NULL,
  `searchTemplateId` char(22) binary NOT NULL,
  `thingsPerPage` int(11) NOT NULL DEFAULT '25',
  `sortBy` char(22) binary DEFAULT NULL,
  `display` int(11) DEFAULT NULL,
  `exportMetaData` int(11) DEFAULT NULL,
  `maxEntriesPerUser` int(11) DEFAULT NULL,
  PRIMARY KEY (`thingId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Thread` (
  `assetId` char(22) binary NOT NULL,
  `replies` int(11) NOT NULL DEFAULT '0',
  `lastPostId` char(22) binary NOT NULL,
  `lastPostDate` bigint(20) DEFAULT NULL,
  `isLocked` int(11) NOT NULL DEFAULT '0',
  `isSticky` int(11) NOT NULL DEFAULT '0',
  `subscriptionGroupId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `karma` int(11) NOT NULL DEFAULT '0',
  `karmaScale` int(11) NOT NULL DEFAULT '1',
  `karmaRank` float(11,6) DEFAULT NULL,
  `threadRating` int(11) DEFAULT '0',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Thread_read` (
  `threadId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  KEY `threadId_userId` (`threadId`,`userId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `UserList` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `templateId` char(22) binary DEFAULT NULL,
  `showGroupId` char(22) binary DEFAULT NULL,
  `hideGroupId` char(22) binary DEFAULT NULL,
  `usersPerPage` int(11) DEFAULT NULL,
  `alphabet` text,
  `alphabetSearchField` char(128) DEFAULT NULL,
  `showOnlyVisibleAsNamed` int(11) DEFAULT NULL,
  `sortBy` char(128) DEFAULT NULL,
  `sortOrder` char(4) DEFAULT NULL,
  `overridePublicEmail` int(11) DEFAULT NULL,
  `overridePublicProfile` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WeatherData` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) unsigned NOT NULL DEFAULT '0',
  `templateId` char(22) binary NOT NULL DEFAULT 'WeatherDataTmpl0000001',
  `locations` text,
  `partnerId` char(100) DEFAULT NULL,
  `licenseKey` char(100) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WikiMaster` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `groupToEditPages` char(22) binary NOT NULL DEFAULT '2',
  `groupToAdminister` char(22) binary NOT NULL DEFAULT '3',
  `richEditor` char(22) binary NOT NULL DEFAULT 'PBrichedit000000000002',
  `frontPageTemplateId` char(22) binary NOT NULL DEFAULT 'WikiFrontTmpl000000001',
  `pageTemplateId` char(22) binary NOT NULL DEFAULT 'WikiPageTmpl0000000001',
  `pageEditTemplateId` char(22) binary NOT NULL DEFAULT 'WikiPageEditTmpl000001',
  `recentChangesTemplateId` char(22) binary NOT NULL DEFAULT 'WikiRCTmpl000000000001',
  `mostPopularTemplateId` char(22) binary NOT NULL DEFAULT 'WikiMPTmpl000000000001',
  `pageHistoryTemplateId` char(22) binary NOT NULL DEFAULT 'WikiPHTmpl000000000001',
  `searchTemplateId` char(22) binary NOT NULL DEFAULT 'WikiSearchTmpl00000001',
  `recentChangesCount` int(11) NOT NULL DEFAULT '50',
  `recentChangesCountFront` int(11) NOT NULL DEFAULT '10',
  `mostPopularCount` int(11) NOT NULL DEFAULT '50',
  `mostPopularCountFront` int(11) NOT NULL DEFAULT '10',
  `thumbnailSize` int(11) NOT NULL DEFAULT '0',
  `maxImageSize` int(11) NOT NULL DEFAULT '0',
  `approvalWorkflow` char(22) binary NOT NULL DEFAULT 'pbworkflow000000000003',
  `useContentFilter` int(11) DEFAULT '0',
  `filterCode` char(30) DEFAULT 'javascript',
  `byKeywordTemplateId` char(22) binary NOT NULL DEFAULT 'WikiKeyword00000000001',
  `allowAttachments` int(11) NOT NULL DEFAULT '0',
  `topLevelKeywords` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WikiMasterKeywords` (
  `assetId` char(22) binary NOT NULL,
  `keyword` char(64) NOT NULL,
  `subKeyword` char(64) NOT NULL DEFAULT '',
  PRIMARY KEY (`assetId`,`keyword`,`subKeyword`),
  KEY `assetId` (`assetId`),
  KEY `keyword` (`keyword`),
  KEY `subKeyword` (`subKeyword`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WikiPage` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `content` mediumtext,
  `views` bigint(20) NOT NULL DEFAULT '0',
  `isProtected` int(11) NOT NULL DEFAULT '0',
  `actionTaken` char(35) NOT NULL,
  `actionTakenBy` char(22) binary NOT NULL,
  `isFeatured` int(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `Workflow` (
  `workflowId` char(22) binary NOT NULL,
  `title` char(255) NOT NULL DEFAULT 'Untitled',
  `description` text,
  `enabled` int(11) NOT NULL DEFAULT '0',
  `type` char(255) NOT NULL DEFAULT 'None',
  `mode` char(20) NOT NULL DEFAULT 'parallel',
  PRIMARY KEY (`workflowId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WorkflowActivity` (
  `activityId` char(22) binary NOT NULL,
  `workflowId` char(22) binary NOT NULL,
  `title` char(255) NOT NULL DEFAULT 'Untitled',
  `description` text,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `className` char(255) DEFAULT NULL,
  PRIMARY KEY (`activityId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WorkflowActivityData` (
  `activityId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`activityId`,`name`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WorkflowInstance` (
  `instanceId` char(22) binary NOT NULL,
  `workflowId` char(22) binary NOT NULL,
  `currentActivityId` char(22) binary NOT NULL,
  `priority` int(11) NOT NULL DEFAULT '2',
  `className` char(255) DEFAULT NULL,
  `methodName` char(255) DEFAULT NULL,
  `parameters` longtext,
  `runningSince` bigint(20) DEFAULT NULL,
  `lastUpdate` bigint(20) DEFAULT NULL,
  `lastStatus` char(15) DEFAULT NULL,
  `noSession` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`instanceId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WorkflowInstanceScratch` (
  `instanceId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`instanceId`,`name`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `WorkflowSchedule` (
  `taskId` char(22) binary NOT NULL,
  `title` char(255) NOT NULL DEFAULT 'Untitled',
  `enabled` int(11) NOT NULL DEFAULT '0',
  `runOnce` int(11) NOT NULL DEFAULT '0',
  `minuteOfHour` char(255) NOT NULL DEFAULT '0',
  `hourOfDay` char(255) NOT NULL DEFAULT '*',
  `dayOfMonth` char(255) NOT NULL DEFAULT '*',
  `monthOfYear` char(255) NOT NULL DEFAULT '*',
  `dayOfWeek` char(255) NOT NULL DEFAULT '*',
  `workflowId` char(22) binary NOT NULL,
  `className` char(255) DEFAULT NULL,
  `methodName` char(255) DEFAULT NULL,
  `priority` int(11) NOT NULL DEFAULT '2',
  `parameters` longtext,
  PRIMARY KEY (`taskId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `ZipArchiveAsset` (
  `assetId` char(22) binary NOT NULL,
  `templateId` char(22) binary NOT NULL,
  `showPage` char(255) NOT NULL DEFAULT 'index.html',
  `revisionDate` bigint(20) NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `adSkuPurchase` (
  `adSkuPurchaseId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `isDeleted` tinyint(1) NOT NULL DEFAULT '0',
  `clicksPurchased` bigint(20) DEFAULT NULL,
  `dateOfPurchase` bigint(20) DEFAULT NULL,
  `impressionsPurchased` bigint(20) DEFAULT NULL,
  `transactionItemId` char(22) binary DEFAULT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `adId` char(22) binary DEFAULT NULL,
  `storedImage` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`adSkuPurchaseId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `adSpace` (
  `adSpaceId` char(22) binary NOT NULL,
  `name` char(35) NOT NULL,
  `title` char(255) NOT NULL,
  `description` text,
  `minimumImpressions` int(11) NOT NULL DEFAULT '1000',
  `minimumClicks` int(11) NOT NULL DEFAULT '1000',
  `width` int(11) NOT NULL DEFAULT '468',
  `height` int(11) NOT NULL DEFAULT '60',
  PRIMARY KEY (`adSpaceId`),
  UNIQUE KEY `name` (`name`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `address` (
  `addressId` char(22) binary NOT NULL,
  `addressBookId` char(22) binary NOT NULL,
  `label` char(35) DEFAULT NULL,
  `firstName` char(35) DEFAULT NULL,
  `lastName` char(35) DEFAULT NULL,
  `address1` char(35) DEFAULT NULL,
  `address2` char(35) DEFAULT NULL,
  `address3` char(35) DEFAULT NULL,
  `city` char(35) DEFAULT NULL,
  `state` char(35) DEFAULT NULL,
  `country` char(35) DEFAULT NULL,
  `code` char(35) DEFAULT NULL,
  `phoneNumber` char(35) DEFAULT NULL,
  `organization` char(255) DEFAULT NULL,
  `email` char(255) DEFAULT NULL,
  PRIMARY KEY (`addressId`),
  KEY `addressBookId_addressId` (`addressBookId`,`addressId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `addressBook` (
  `addressBookId` char(22) binary NOT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `defaultAddressId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`addressBookId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `advertisement` (
  `adId` char(22) binary NOT NULL,
  `adSpaceId` char(22) binary NOT NULL,
  `ownerUserId` char(22) binary NOT NULL,
  `isActive` int(11) NOT NULL DEFAULT '0',
  `title` char(255) NOT NULL,
  `type` char(15) NOT NULL DEFAULT 'text',
  `storageId` char(22) binary DEFAULT NULL,
  `adText` char(255) DEFAULT NULL,
  `url` text,
  `richMedia` text,
  `borderColor` char(7) NOT NULL DEFAULT '#000000',
  `textColor` char(7) NOT NULL DEFAULT '#000000',
  `backgroundColor` char(7) NOT NULL DEFAULT '#ffffff',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clicksBought` int(11) NOT NULL DEFAULT '0',
  `impressions` int(11) NOT NULL DEFAULT '0',
  `impressionsBought` int(11) NOT NULL DEFAULT '0',
  `priority` int(11) NOT NULL DEFAULT '0',
  `nextInPriority` bigint(20) NOT NULL DEFAULT '0',
  `renderedAd` text,
  PRIMARY KEY (`adId`),
  KEY `adSpaceId_isActive` (`adSpaceId`,`isActive`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `analyticRule` (
  `ruleId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `bucketName` char(255) DEFAULT NULL,
  `regexp` char(255) NOT NULL DEFAULT '.+',
  PRIMARY KEY (`ruleId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `asset` (
  `assetId` char(22) binary NOT NULL,
  `parentId` char(22) binary NOT NULL,
  `lineage` char(255) NOT NULL,
  `state` char(35) NOT NULL,
  `className` char(255) NOT NULL,
  `creationDate` bigint(20) NOT NULL DEFAULT '997995720',
  `createdBy` char(22) binary NOT NULL DEFAULT '3',
  `stateChanged` char(22) binary NOT NULL DEFAULT '997995720',
  `stateChangedBy` char(22) binary NOT NULL DEFAULT '3',
  `isLockedBy` char(22) binary DEFAULT NULL,
  `isSystem` int(11) NOT NULL DEFAULT '0',
  `lastExportedAs` char(255) DEFAULT NULL,
  PRIMARY KEY (`assetId`),
  UNIQUE KEY `lineage` (`lineage`),
  KEY `parentId` (`parentId`),
  KEY `state_parentId_lineage` (`state`,`parentId`,`lineage`),
  KEY `isPrototype_className_assetId` (`className`,`assetId`),
  KEY `className_assetId_state` (`className`,`assetId`,`state`),
  KEY `state_lineage` (`state`,`lineage`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetAspectComments` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `comments` longtext,
  `averageCommentRating` int(11) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetAspectRssFeed` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `itemsPerFeed` int(11) DEFAULT '25',
  `feedCopyright` text,
  `feedTitle` text,
  `feedDescription` mediumtext,
  `feedImage` char(22) binary DEFAULT NULL,
  `feedImageLink` text,
  `feedImageDescription` mediumtext,
  `feedHeaderLinks` char(32) DEFAULT 'rss\natom',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetAspect_Subscribable` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `subscriptionGroupId` char(22) binary DEFAULT NULL,
  `subscriptionTemplateId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetData` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `revisedBy` char(22) binary NOT NULL,
  `tagId` char(22) binary NOT NULL,
  `status` char(35) NOT NULL DEFAULT 'pending',
  `title` char(255) NOT NULL DEFAULT 'untitled',
  `menuTitle` char(255) NOT NULL DEFAULT 'untitled',
  `url` char(255) NOT NULL,
  `ownerUserId` char(22) binary NOT NULL,
  `groupIdView` char(22) binary NOT NULL,
  `groupIdEdit` char(22) binary NOT NULL,
  `synopsis` text,
  `newWindow` int(11) NOT NULL DEFAULT '0',
  `isHidden` int(11) NOT NULL DEFAULT '0',
  `isPackage` int(11) NOT NULL DEFAULT '0',
  `isPrototype` int(11) NOT NULL DEFAULT '0',
  `encryptPage` int(11) NOT NULL DEFAULT '0',
  `assetSize` int(11) NOT NULL DEFAULT '0',
  `extraHeadTags` text,
  `skipNotification` int(11) NOT NULL DEFAULT '0',
  `isExportable` int(11) NOT NULL DEFAULT '1',
  `inheritUrlFromParent` int(11) NOT NULL DEFAULT '0',
  `lastModified` bigint(20) DEFAULT NULL,
  `extraHeadTagsPacked` longtext,
  `usePackedHeadTags` int(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `assetId_url` (`assetId`,`url`),
  KEY `assetId_revisionDate_status_tagId` (`assetId`,`revisionDate`,`status`,`tagId`),
  KEY `url` (`url`),
  KEY `assetId_status_tagId_revisionDate` (`assetId`,`status`,`tagId`,`revisionDate`),
  KEY `assetId_status` (`assetId`,`status`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetHistory` (
  `assetId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `dateStamp` bigint(20) NOT NULL DEFAULT '0',
  `actionTaken` char(255) NOT NULL,
  `url` char(255) DEFAULT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetIndex` (
  `assetId` char(22) binary NOT NULL,
  `title` char(255) DEFAULT NULL,
  `synopsis` text,
  `url` char(255) DEFAULT NULL,
  `creationDate` bigint(20) DEFAULT NULL,
  `revisionDate` bigint(20) DEFAULT NULL,
  `ownerUserId` char(22) binary DEFAULT NULL,
  `groupIdView` char(22) binary DEFAULT NULL,
  `groupIdEdit` char(22) binary DEFAULT NULL,
  `className` char(255) DEFAULT NULL,
  `isPublic` int(11) NOT NULL DEFAULT '1',
  `keywords` mediumtext,
  `lineage` char(255) DEFAULT NULL,
  PRIMARY KEY (`assetId`),
  FULLTEXT KEY `keywords` (`keywords`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetKeyword` (
  `keyword` char(64) NOT NULL,
  `assetId` char(22) binary NOT NULL,
  PRIMARY KEY (`keyword`,`assetId`),
  KEY `keyword` (`keyword`),
  KEY `assetId` (`assetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `assetVersionTag` (
  `tagId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `isCommitted` int(11) NOT NULL DEFAULT '0',
  `creationDate` bigint(20) NOT NULL DEFAULT '0',
  `createdBy` char(22) binary NOT NULL,
  `commitDate` bigint(20) NOT NULL DEFAULT '0',
  `committedBy` char(22) binary NOT NULL,
  `isLocked` int(11) NOT NULL DEFAULT '0',
  `lockedBy` char(22) binary NOT NULL,
  `groupToUse` char(22) binary NOT NULL,
  `workflowId` char(22) binary NOT NULL,
  `workflowInstanceId` char(22) binary DEFAULT NULL,
  `comments` text,
  `startTime` datetime DEFAULT NULL,
  `endTime` datetime DEFAULT NULL,
  `isSiteWide` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`tagId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `authentication` (
  `userId` char(22) binary NOT NULL,
  `authMethod` char(30) NOT NULL,
  `fieldName` char(128) NOT NULL,
  `fieldData` text,
  PRIMARY KEY (`userId`,`authMethod`,`fieldName`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `bucketLog` (
  `userId` char(22) binary NOT NULL,
  `Bucket` char(22) binary NOT NULL,
  `duration` int(11) DEFAULT NULL,
  `timeStamp` datetime DEFAULT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `cache` (
  `namespace` char(128) NOT NULL,
  `cachekey` char(128) NOT NULL,
  `expires` bigint(20) NOT NULL,
  `size` int(11) NOT NULL,
  `content` mediumblob,
  PRIMARY KEY (`namespace`,`cachekey`),
  KEY `namespace_cachekey_size` (`namespace`,`cachekey`,`expires`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `cart` (
  `cartId` char(22) binary NOT NULL,
  `sessionId` char(22) binary NOT NULL,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `shipperId` char(22) binary DEFAULT NULL,
  `posUserId` char(22) binary DEFAULT NULL,
  `creationDate` int(20) DEFAULT NULL,
  `billingAddressId` char(22) DEFAULT NULL,
  `gatewayId` char(22) DEFAULT NULL,
  PRIMARY KEY (`cartId`),
  KEY `sessionId` (`sessionId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `cartItem` (
  `itemId` char(22) binary NOT NULL,
  `cartId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `dateAdded` datetime NOT NULL,
  `options` longtext,
  `configuredTitle` char(255) DEFAULT NULL,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`itemId`),
  KEY `cartId_assetId_dateAdded` (`cartId`,`assetId`,`dateAdded`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `databaseLink` (
  `databaseLinkId` char(22) binary NOT NULL,
  `title` char(255) DEFAULT NULL,
  `DSN` char(255) DEFAULT NULL,
  `username` char(255) DEFAULT NULL,
  `identifier` char(255) DEFAULT NULL,
  `allowedKeywords` text,
  `allowMacroAccess` int(11) NOT NULL DEFAULT '0',
  `additionalParameters` char(255) NOT NULL,
  PRIMARY KEY (`databaseLinkId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `deltaLog` (
  `userId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `delta` int(11) DEFAULT NULL,
  `timeStamp` bigint(20) DEFAULT NULL,
  `url` char(255) NOT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `donation` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `defaultPrice` float NOT NULL DEFAULT '100',
  `thankYouMessage` mediumtext,
  `templateId` char(22) binary NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `filePumpBundle` (
  `bundleId` char(22) binary NOT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `dateCreated` datetime DEFAULT NULL,
  `lastUpdated` datetime DEFAULT NULL,
  `bundleName` char(255) NOT NULL DEFAULT 'New bundle',
  `lastModified` bigint(20) NOT NULL DEFAULT '0',
  `lastBuild` bigint(20) NOT NULL DEFAULT '0',
  `jsFiles` longtext NOT NULL,
  `cssFiles` longtext NOT NULL,
  `otherFiles` longtext NOT NULL,
  PRIMARY KEY (`bundleId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `friendInvitations` (
  `inviteId` char(22) binary NOT NULL,
  `inviterId` char(22) binary NOT NULL,
  `friendId` char(22) binary NOT NULL,
  `dateSent` datetime NOT NULL,
  `comments` char(255) NOT NULL,
  `messageId` char(22) binary NOT NULL,
  PRIMARY KEY (`inviteId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `groupGroupings` (
  `groupId` char(22) binary NOT NULL,
  `inGroup` char(22) binary NOT NULL,
  PRIMARY KEY (`groupId`,`inGroup`),
  KEY `inGroup` (`inGroup`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `groupings` (
  `groupId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `expireDate` bigint(20) NOT NULL DEFAULT '2114402400',
  `groupAdmin` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`groupId`,`userId`),
  KEY `userId` (`userId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `groups` (
  `groupId` char(22) binary NOT NULL,
  `groupName` char(100) DEFAULT NULL,
  `description` char(255) DEFAULT NULL,
  `expireOffset` int(11) NOT NULL DEFAULT '314496000',
  `karmaThreshold` int(11) NOT NULL DEFAULT '1000000000',
  `ipFilter` text,
  `dateCreated` int(11) NOT NULL DEFAULT '997938000',
  `lastUpdated` int(11) NOT NULL DEFAULT '997938000',
  `deleteOffset` int(11) NOT NULL DEFAULT '14',
  `expireNotifyOffset` int(11) NOT NULL DEFAULT '-14',
  `expireNotifyMessage` text,
  `expireNotify` int(11) NOT NULL DEFAULT '0',
  `scratchFilter` text,
  `autoAdd` int(11) NOT NULL DEFAULT '0',
  `autoDelete` int(11) NOT NULL DEFAULT '0',
  `databaseLinkId` char(22) binary NOT NULL,
  `groupCacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `dbQuery` text,
  `isEditable` int(11) NOT NULL DEFAULT '1',
  `showInForms` int(11) NOT NULL DEFAULT '1',
  `ldapGroup` char(255) DEFAULT NULL,
  `ldapGroupProperty` char(255) DEFAULT NULL,
  `ldapRecursiveProperty` char(255) DEFAULT NULL,
  `ldapLinkId` char(22) binary DEFAULT NULL,
  `ldapRecursiveFilter` mediumtext,
  `isAdHocMailGroup` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`groupId`),
  KEY `groupName` (`groupName`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `imageColor` (
  `colorId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL DEFAULT 'untitled',
  `fillTriplet` char(7) NOT NULL DEFAULT '#000000',
  `fillAlpha` char(2) NOT NULL DEFAULT '00',
  `strokeTriplet` char(7) NOT NULL DEFAULT '#000000',
  `strokeAlpha` char(2) NOT NULL DEFAULT '00',
  PRIMARY KEY (`colorId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `imageFont` (
  `fontId` char(22) binary NOT NULL,
  `name` char(255) DEFAULT NULL,
  `storageId` char(22) binary DEFAULT NULL,
  `filename` char(255) DEFAULT NULL,
  PRIMARY KEY (`fontId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `imagePalette` (
  `paletteId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL DEFAULT 'untitled',
  PRIMARY KEY (`paletteId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `imagePaletteColors` (
  `paletteId` char(22) binary NOT NULL,
  `colorId` char(22) binary NOT NULL,
  `paletteOrder` int(11) NOT NULL,
  PRIMARY KEY (`paletteId`,`paletteOrder`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `inbox` (
  `messageId` char(22) binary NOT NULL,
  `status` char(15) NOT NULL DEFAULT 'pending',
  `dateStamp` bigint(20) NOT NULL,
  `completedOn` bigint(20) DEFAULT NULL,
  `completedBy` char(22) binary DEFAULT NULL,
  `userId` char(22) binary DEFAULT NULL,
  `groupId` char(22) binary DEFAULT NULL,
  `subject` char(255) NOT NULL DEFAULT 'No Subject',
  `message` mediumtext,
  `sentBy` char(22) binary NOT NULL DEFAULT '3',
  PRIMARY KEY (`messageId`),
  KEY `completedOn_dateStamp` (`completedOn`,`dateStamp`),
  KEY `pb_userId` (`userId`),
  KEY `pb_groupId` (`groupId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `inbox_messageState` (
  `messageId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `isRead` tinyint(4) NOT NULL DEFAULT '0',
  `repliedTo` tinyint(4) NOT NULL DEFAULT '0',
  `deleted` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`messageId`,`userId`),
  KEY `userId_deleted_isRead` (`userId`,`deleted`,`isRead`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `incrementer` (
  `incrementerId` char(50) NOT NULL,
  `nextValue` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`incrementerId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `karmaLog` (
  `userId` char(22) binary NOT NULL,
  `amount` int(11) NOT NULL DEFAULT '1',
  `source` char(255) DEFAULT NULL,
  `description` text,
  `dateModified` bigint(20) NOT NULL DEFAULT '0'
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `ldapLink` (
  `ldapLinkId` char(22) binary NOT NULL,
  `ldapLinkName` char(255) NOT NULL,
  `ldapUrl` char(255) NOT NULL,
  `connectDn` char(255) NOT NULL,
  `identifier` char(255) NOT NULL,
  `ldapUserRDN` char(255) DEFAULT NULL,
  `ldapIdentity` char(255) DEFAULT NULL,
  `ldapIdentityName` char(255) DEFAULT NULL,
  `ldapPasswordName` char(255) DEFAULT NULL,
  `ldapSendWelcomeMessage` char(2) DEFAULT NULL,
  `ldapWelcomeMessage` text,
  `ldapAccountTemplate` char(22) binary NOT NULL,
  `ldapCreateAccountTemplate` char(22) binary NOT NULL,
  `ldapLoginTemplate` char(22) binary NOT NULL,
  `ldapGlobalRecursiveFilter` mediumtext,
  `ldapDeactivateAccountTemplate` char(22) NOT NULL,
  PRIMARY KEY (`ldapLinkId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `mailQueue` (
  `messageId` char(22) binary NOT NULL,
  `message` mediumtext,
  `toGroup` char(22) binary DEFAULT NULL,
  `isInbox` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`messageId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `metaData_properties` (
  `fieldId` char(22) binary NOT NULL,
  `fieldName` char(100) NOT NULL,
  `description` mediumtext NOT NULL,
  `fieldType` char(30) DEFAULT NULL,
  `possibleValues` text,
  `defaultValue` char(255) DEFAULT NULL,
  PRIMARY KEY (`fieldId`),
  UNIQUE KEY `field_unique` (`fieldName`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `metaData_values` (
  `fieldId` char(22) binary NOT NULL,
  `value` char(255) DEFAULT NULL,
  `assetId` char(22) binary NOT NULL,
  PRIMARY KEY (`fieldId`,`assetId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `passiveAnalyticsStatus` (
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `running` int(2) DEFAULT '0',
  `userId` char(255) NOT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `passiveLog` (
  `userId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `sessionId` char(22) binary NOT NULL,
  `timeStamp` bigint(20) DEFAULT NULL,
  `url` char(255) NOT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `passiveProfileAOI` (
  `userId` char(22) binary NOT NULL,
  `fieldId` char(22) binary NOT NULL,
  `value` char(100) NOT NULL,
  `count` int(11) DEFAULT NULL,
  PRIMARY KEY (`userId`,`fieldId`,`value`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `passiveProfileLog` (
  `passiveProfileLogId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `sessionId` char(22) binary NOT NULL,
  `assetId` char(22) binary NOT NULL,
  `dateOfEntry` bigint(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`passiveProfileLogId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `paymentGateway` (
  `paymentGatewayId` char(22) binary NOT NULL,
  `className` char(255) DEFAULT NULL,
  `options` longtext,
  PRIMARY KEY (`paymentGatewayId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `redirect` (
  `assetId` char(22) binary NOT NULL,
  `redirectUrl` text,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `redirectType` int(11) NOT NULL DEFAULT '302',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `replacements` (
  `replacementId` char(22) binary NOT NULL,
  `searchFor` char(255) DEFAULT NULL,
  `replaceWith` text,
  PRIMARY KEY (`replacementId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `search` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `classLimiter` text,
  `searchRoot` char(22) binary NOT NULL DEFAULT 'PBasset000000000000001',
  `templateId` char(22) binary NOT NULL DEFAULT 'PBtmpl0000000000000200',
  `useContainers` int(11) NOT NULL DEFAULT '0',
  `paginateAfter` int(11) NOT NULL DEFAULT '25',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `settings` (
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`name`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `shipper` (
  `shipperId` char(22) binary NOT NULL,
  `className` char(255) DEFAULT NULL,
  `options` longtext,
  PRIMARY KEY (`shipperId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `shopCredit` (
  `creditId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `amount` float NOT NULL DEFAULT '0',
  `comment` text,
  `dateOfAdjustment` datetime DEFAULT NULL,
  PRIMARY KEY (`creditId`),
  KEY `userId` (`userId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `sku` (
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL,
  `description` mediumtext,
  `sku` char(35) NOT NULL,
  `vendorId` char(22) binary NOT NULL DEFAULT 'defaultvendor000000000',
  `displayTitle` tinyint(1) NOT NULL DEFAULT '1',
  `overrideTaxRate` tinyint(1) NOT NULL DEFAULT '0',
  `taxRateOverride` float NOT NULL DEFAULT '0',
  `taxConfiguration` longtext,
  `shipsSeparately` tinyint(1) NOT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `sku` (`sku`),
  KEY `vendorId` (`vendorId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `snippet` (
  `assetId` char(22) binary NOT NULL,
  `snippet` mediumtext,
  `processAsTemplate` int(11) NOT NULL DEFAULT '0',
  `mimeType` char(50) NOT NULL DEFAULT 'text/html',
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `cacheTimeout` int(11) NOT NULL DEFAULT '3600',
  `snippetPacked` longtext,
  `usePacked` int(1) DEFAULT NULL,
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `taxDriver` (
  `className` char(255) NOT NULL,
  `options` longtext,
  PRIMARY KEY (`className`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `tax_eu_vatNumbers` (
  `userId` char(22) binary NOT NULL,
  `countryCode` char(3) NOT NULL,
  `vatNumber` char(20) NOT NULL,
  `viesValidated` tinyint(1) DEFAULT NULL,
  `viesErrorCode` int(3) DEFAULT NULL,
  `approved` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`userId`,`vatNumber`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `tax_generic_rates` (
  `taxId` char(22) binary NOT NULL,
  `country` char(100) NOT NULL,
  `state` char(100) DEFAULT NULL,
  `city` char(100) DEFAULT NULL,
  `code` char(100) DEFAULT NULL,
  `taxRate` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`taxId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `template` (
  `template` mediumtext,
  `namespace` char(35) NOT NULL DEFAULT 'Page',
  `isEditable` int(11) NOT NULL DEFAULT '1',
  `showInForms` int(11) NOT NULL DEFAULT '1',
  `assetId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `parser` char(255) NOT NULL DEFAULT 'WebGUI::Asset::Template::HTMLTemplate',
  `isDefault` int(1) DEFAULT '0',
  `templatePacked` longtext,
  `usePacked` int(1) DEFAULT NULL,
  `storageIdExample` char(22) DEFAULT NULL,
  `attachmentsJson` longtext,
  PRIMARY KEY (`assetId`,`revisionDate`),
  KEY `namespace_showInForms` (`namespace`,`showInForms`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `transaction` (
  `transactionId` char(22) binary NOT NULL,
  `originatingTransactionId` char(22) binary DEFAULT NULL,
  `isSuccessful` tinyint(1) NOT NULL DEFAULT '0',
  `orderNumber` int(11) NOT NULL AUTO_INCREMENT,
  `transactionCode` char(100) DEFAULT NULL,
  `statusCode` char(35) DEFAULT NULL,
  `statusMessage` char(255) DEFAULT NULL,
  `userId` char(22) binary NOT NULL,
  `username` char(35) NOT NULL,
  `amount` float DEFAULT NULL,
  `shopCreditDeduction` float DEFAULT NULL,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `shippingAddressName` char(35) DEFAULT NULL,
  `shippingAddress1` char(35) DEFAULT NULL,
  `shippingAddress2` char(35) DEFAULT NULL,
  `shippingAddress3` char(35) DEFAULT NULL,
  `shippingCity` char(35) DEFAULT NULL,
  `shippingState` char(35) DEFAULT NULL,
  `shippingCountry` char(35) DEFAULT NULL,
  `shippingCode` char(35) DEFAULT NULL,
  `shippingPhoneNumber` char(35) DEFAULT NULL,
  `shippingDriverId` char(22) binary DEFAULT NULL,
  `shippingDriverLabel` char(35) DEFAULT NULL,
  `shippingPrice` float DEFAULT NULL,
  `paymentAddressId` char(22) binary DEFAULT NULL,
  `paymentAddressName` char(35) DEFAULT NULL,
  `paymentAddress1` char(35) DEFAULT NULL,
  `paymentAddress2` char(35) DEFAULT NULL,
  `paymentAddress3` char(35) DEFAULT NULL,
  `paymentCity` char(35) DEFAULT NULL,
  `paymentState` char(35) DEFAULT NULL,
  `paymentCountry` char(35) DEFAULT NULL,
  `paymentCode` char(35) DEFAULT NULL,
  `paymentPhoneNumber` char(35) DEFAULT NULL,
  `paymentDriverId` char(22) binary DEFAULT NULL,
  `paymentDriverLabel` char(35) DEFAULT NULL,
  `taxes` float DEFAULT NULL,
  `dateOfPurchase` datetime DEFAULT NULL,
  `isRecurring` tinyint(1) DEFAULT NULL,
  `notes` mediumtext,
  `cashierUserId` char(22) binary DEFAULT NULL,
  PRIMARY KEY (`transactionId`),
  UNIQUE KEY `orderNumber` (`orderNumber`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `transactionItem` (
  `itemId` char(22) binary NOT NULL,
  `transactionId` char(22) binary NOT NULL,
  `assetId` char(22) binary DEFAULT NULL,
  `configuredTitle` char(255) DEFAULT NULL,
  `options` longtext,
  `shippingAddressId` char(22) binary DEFAULT NULL,
  `shippingName` char(35) DEFAULT NULL,
  `shippingAddress1` char(35) DEFAULT NULL,
  `shippingAddress2` char(35) DEFAULT NULL,
  `shippingAddress3` char(35) DEFAULT NULL,
  `shippingCity` char(35) DEFAULT NULL,
  `shippingState` char(35) DEFAULT NULL,
  `shippingCountry` char(35) DEFAULT NULL,
  `shippingCode` char(35) DEFAULT NULL,
  `shippingPhoneNumber` char(35) DEFAULT NULL,
  `shippingTrackingNumber` char(255) DEFAULT NULL,
  `orderStatus` char(35) NOT NULL DEFAULT 'NotShipped',
  `lastUpdated` datetime DEFAULT NULL,
  `quantity` int(11) NOT NULL DEFAULT '1',
  `price` float DEFAULT NULL,
  `vendorId` char(22) binary NOT NULL DEFAULT 'defaultvendor000000000',
  `vendorPayoutStatus` char(10) DEFAULT 'NotPaid',
  `vendorPayoutAmount` decimal(8,2) DEFAULT '0.00',
  `taxRate` decimal(6,3) DEFAULT NULL,
  `taxConfiguration` longtext,
  PRIMARY KEY (`itemId`),
  KEY `transactionId` (`transactionId`),
  KEY `vendorId` (`vendorId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `userInvitations` (
  `inviteId` char(22) binary NOT NULL,
  `userId` char(22) binary NOT NULL,
  `dateSent` date DEFAULT NULL,
  `email` char(255) NOT NULL,
  `newUserId` char(22) binary DEFAULT NULL,
  `dateCreated` date DEFAULT NULL,
  PRIMARY KEY (`inviteId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `userLoginLog` (
  `userId` char(22) binary NOT NULL,
  `status` char(30) DEFAULT NULL,
  `timeStamp` int(11) DEFAULT NULL,
  `ipAddress` char(128) DEFAULT NULL,
  `userAgent` text,
  `sessionId` char(22) binary DEFAULT NULL,
  `lastPageViewed` int(11) DEFAULT NULL,
  KEY `sessionId` (`sessionId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `userProfileCategory` (
  `profileCategoryId` char(22) binary NOT NULL,
  `label` char(255) NOT NULL DEFAULT 'Undefined',
  `shortLabel` char(255) DEFAULT NULL,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `visible` int(11) NOT NULL DEFAULT '1',
  `editable` int(11) NOT NULL DEFAULT '1',
  `protected` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`profileCategoryId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `userProfileData` (
  `userId` char(22) binary NOT NULL,
  `email` char(255) DEFAULT NULL,
  `firstName` char(255) DEFAULT NULL,
  `middleName` char(255) DEFAULT NULL,
  `lastName` char(255) DEFAULT NULL,
  `icq` char(255) DEFAULT NULL,
  `aim` char(255) DEFAULT NULL,
  `msnIM` char(255) DEFAULT NULL,
  `yahooIM` char(255) DEFAULT NULL,
  `cellPhone` char(255) DEFAULT NULL,
  `pager` char(255) DEFAULT NULL,
  `emailToPager` char(255) DEFAULT NULL,
  `language` char(255) DEFAULT NULL,
  `homeAddress` char(255) DEFAULT NULL,
  `homeCity` char(255) DEFAULT NULL,
  `homeState` char(255) DEFAULT NULL,
  `homeZip` char(255) DEFAULT NULL,
  `homeCountry` char(255) DEFAULT NULL,
  `homePhone` char(255) DEFAULT NULL,
  `workAddress` char(255) DEFAULT NULL,
  `workCity` char(255) DEFAULT NULL,
  `workState` char(255) DEFAULT NULL,
  `workZip` char(255) DEFAULT NULL,
  `workCountry` char(255) DEFAULT NULL,
  `workPhone` char(255) DEFAULT NULL,
  `gender` char(255) DEFAULT NULL,
  `birthdate` bigint(20) DEFAULT NULL,
  `homeURL` char(255) DEFAULT NULL,
  `workURL` char(255) DEFAULT NULL,
  `workName` char(255) DEFAULT NULL,
  `timeZone` char(255) DEFAULT NULL,
  `dateFormat` char(255) DEFAULT NULL,
  `timeFormat` char(255) DEFAULT NULL,
  `discussionLayout` char(255) DEFAULT NULL,
  `firstDayOfWeek` char(255) DEFAULT NULL,
  `uiLevel` char(255) DEFAULT NULL,
  `alias` char(255) DEFAULT NULL,
  `signature` longtext,
  `publicProfile` longtext,
  `toolbar` char(255) DEFAULT NULL,
  `photo` char(22) binary DEFAULT NULL,
  `avatar` char(22) binary DEFAULT NULL,
  `department` char(255) DEFAULT NULL,
  `allowPrivateMessages` longtext,
  `ableToBeFriend` tinyint(4) DEFAULT NULL,
  `showMessageOnLoginSeen` bigint(20) DEFAULT NULL,
  `showOnline` tinyint(1) DEFAULT NULL,
  `versionTagMode` char(255) DEFAULT NULL,
  `wg_privacySettings` longtext,
  `receiveInboxEmailNotifications` tinyint(1) DEFAULT NULL,
  `receiveInboxSmsNotifications` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`userId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `userProfileField` (
  `fieldName` char(128) NOT NULL,
  `label` char(255) NOT NULL DEFAULT 'Undefined',
  `visible` int(11) NOT NULL DEFAULT '0',
  `required` int(11) NOT NULL DEFAULT '0',
  `fieldType` char(128) NOT NULL DEFAULT 'text',
  `possibleValues` text,
  `dataDefault` text,
  `sequenceNumber` int(11) NOT NULL DEFAULT '1',
  `profileCategoryId` char(22) binary NOT NULL,
  `protected` int(11) NOT NULL DEFAULT '0',
  `editable` int(11) NOT NULL DEFAULT '1',
  `forceImageOnly` int(11) DEFAULT '1',
  `showAtRegistration` int(11) NOT NULL DEFAULT '0',
  `requiredForPasswordRecovery` int(11) NOT NULL DEFAULT '0',
  `extras` text,
  `defaultPrivacySetting` char(128) DEFAULT NULL,
  PRIMARY KEY (`fieldName`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `userSession` (
  `sessionId` char(22) binary NOT NULL,
  `expires` int(11) DEFAULT NULL,
  `lastPageView` int(11) DEFAULT NULL,
  `adminOn` int(11) NOT NULL DEFAULT '0',
  `lastIP` char(50) DEFAULT NULL,
  `userId` char(22) binary NOT NULL,
  PRIMARY KEY (`sessionId`),
  KEY `expires` (`expires`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `userSessionScratch` (
  `sessionId` char(22) binary NOT NULL,
  `name` char(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`sessionId`,`name`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `users` (
  `userId` char(22) binary NOT NULL,
  `username` char(100) DEFAULT NULL,
  `authMethod` char(30) NOT NULL DEFAULT 'WebGUI',
  `dateCreated` int(11) NOT NULL DEFAULT '1019867418',
  `lastUpdated` int(11) NOT NULL DEFAULT '1019867418',
  `karma` int(11) NOT NULL DEFAULT '0',
  `status` char(35) NOT NULL DEFAULT 'Active',
  `referringAffiliate` char(22) binary NOT NULL,
  `friendsGroup` char(22) binary NOT NULL,
  PRIMARY KEY (`userId`),
  UNIQUE KEY `username_unique` (`username`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `vendor` (
  `vendorId` char(22) binary NOT NULL,
  `dateCreated` datetime DEFAULT NULL,
  `name` char(255) DEFAULT NULL,
  `userId` char(22) binary NOT NULL DEFAULT '3',
  `preferredPaymentType` char(255) DEFAULT NULL,
  `paymentInformation` text,
  `paymentAddressId` char(22) binary DEFAULT NULL,
  `url` text,
  PRIMARY KEY (`vendorId`),
  KEY `userId` (`userId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `vendorPayoutLog` (
  `payoutId` char(22) binary NOT NULL,
  `isSuccessful` tinyint(1) NOT NULL,
  `errorCode` char(10) DEFAULT NULL,
  `errorMessage` char(255) DEFAULT NULL,
  `paypalTimestamp` char(20) NOT NULL,
  `amount` decimal(7,2) NOT NULL,
  `currency` char(3) NOT NULL,
  `correlationId` char(13) NOT NULL,
  `paymentInformation` char(255) NOT NULL,
  PRIMARY KEY (`payoutId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `vendorPayoutLog_items` (
  `payoutId` char(22) binary NOT NULL,
  `transactionItemId` char(22) binary NOT NULL,
  `amount` decimal(7,2) NOT NULL,
  PRIMARY KEY (`payoutId`,`transactionItemId`)
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `webguiVersion` (
  `webguiVersion` char(10) DEFAULT NULL,
  `versionType` char(30) DEFAULT NULL,
  `dateApplied` int(11) DEFAULT NULL
) TYPE=MyISAM CHARSET=utf8;
CREATE TABLE `wobject` (
  `displayTitle` int(11) NOT NULL DEFAULT '1',
  `description` mediumtext,
  `assetId` char(22) binary NOT NULL,
  `styleTemplateId` char(22) binary NOT NULL,
  `printableStyleTemplateId` char(22) binary NOT NULL,
  `revisionDate` bigint(20) NOT NULL DEFAULT '0',
  `mobileStyleTemplateId` char(22) binary DEFAULT 'PBtmpl0000000000000060',
  PRIMARY KEY (`assetId`,`revisionDate`)
) TYPE=MyISAM CHARSET=utf8;
ALTER TABLE `Article` DISABLE KEYS;
INSERT INTO `Article` VALUES (NULL,NULL,'bX5rYxb6tZ9docY6sUhBlw','PBtmpl0000000000000002',1278013772,3600,'AHrUFHib-cqwIz1x7RI9sA'),(NULL,NULL,'NK8bqlwVRILJknqeCDPBHg','PBtmpl0000000000000002',1278013933,3600,'q2ZH670YnJBJ-D7W2cuPeg'),(NULL,NULL,'ix1p0AbwKAz8QWB-T-HHfg','PBtmpl0000000000000002',1271359087,3600,'VF2bqXTRUBoYb_u7dmH70w'),(NULL,NULL,'iCYOjohB9SKvAPr6bXElKA','PBtmpl0000000000000103',1271445525,3600,'TEXVtOhmF_RHM11-_xJLyw'),(NULL,NULL,'4Yfz9hqBqM8OYMGuQK8oLw','PBtmpl0000000000000002',1271352537,3600,'TngTkH6qB76os2nf2S9bDA'),(NULL,NULL,'Wl8WZ43g2rK5AYr9o4zY7w','PBtmpl0000000000000103',1271445539,3600,'HUItbZl7TpOPC06NlO62QA'),(NULL,NULL,'LBuiKzg2mWwmOPS9AgV3bg','PBtmpl0000000000000002',1271348789,3600,'6zKDCX1Jpqbi4banD1EFNQ'),(NULL,NULL,'jTNggl7AoVSUc_ZzrvuCmw','PBtmpl0000000000000002',1271348789,3600,'t_CTIcSnLSuqOumw7LwxFA'),(NULL,NULL,'j_1qEqM6iLfQLiR6VKy0aA','PBtmpl0000000000000002',1271349878,3600,'vClSjuxZGSkLT6ObFY0UUg'),(NULL,NULL,'diZvW4bSgZWwyyGP3qXi1g','PBtmpl0000000000000002',1271349814,3600,'p9BKPe1vVlrj-L9vcGUADQ'),(NULL,NULL,'k2Qj03FrAOXYra8kDJYYXw','PBtmpl0000000000000002',1271357513,3600,'aczyXjysDv66G-aO4HVA5g'),(NULL,NULL,'ksSfkZdsr0uC62NwIk6hFQ','PBtmpl0000000000000002',1271356973,3600,'eSxL8WkA97ifv3hpXE2bIA'),(NULL,NULL,'nWxS5jnA3o3DgPEwBeR7yQ','PBtmpl0000000000000002',1271357239,3600,'RrQNgmVkQhVKqY-uY5oJdg'),(NULL,NULL,'OhdaFLE7sXOzo_SIP2ZUgA','PBtmpl0000000000000002',1271445348,3600,'3g2hbILhcxQA_7UOep0B3Q'),(NULL,NULL,'IWFxZDyGhQ3-SLZhELa3qw','PBtmpl0000000000000002',1277737686,3600,'0MZ-Ua1Gcv25yT-3JxXX8A'),(NULL,NULL,'l0guT3vTR3B8cL6vtP-g3A','PBtmpl0000000000000002',1285733528,3600,'f_tiCektI5fa631VndCjnw');
ALTER TABLE `Article` ENABLE KEYS;
ALTER TABLE `Collaboration` DISABLE KEYS;
INSERT INTO `Collaboration` VALUES ('pbproto000000000000002','2','2',0,'PBtmpl0000000000000208','PBtmpl0000000000000209','PBtmpl0000000000000210','','','assetData.revisionDate','desc',0,0,3600,10,'javascript',1,0,0,0,0,NULL,NULL,2592000,10,30,NULL,1,0,'PBrichedit000000000002',0,0,1163019036,0,'pbworkflow000000000003','pbworkflow000000000003',100,NULL,NULL,NULL,NULL,NULL,0,300,'NpRVTSR-NX2sD52LUc520A',3600,1,1,0,0,0,0,'12',1,'default_post_received1','PBrichedit000000000002','javascript','default_CS_unsubscribe');
ALTER TABLE `Collaboration` ENABLE KEYS;
ALTER TABLE `FileAsset` DISABLE KEYS;
INSERT INTO `FileAsset` VALUES ('7-0-style0000000000002','_Vo1Pvl3sPPANyxz-IcCtA','body_bg.jpg','PBtmpl0000000000000088',1147642492,3600),('7-0-style0000000000004','Gemp7cEVjh2_M2IicUYs-g','gui_bottom.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000005','ry-yzLVH-vxn71H9byjGXA','header.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000006','VEPa65fhY3dok6vj-beFCA','main_bg.gif','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000007','Cfay1MNkC-73WKJ7fX_pVw','main_bg.jpg','PBtmpl0000000000000088',1147642493,3600),('7-0-style0000000000008','iEBE--vQb_lxuZd5AP8tuw','nav1_center_on.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000009','XR1Yjf3MkYA53TJlcpRBsw','nav1_off.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000010','sxvAS8na-QAdY_eycd2gKw','nav1_off_center.jpg','PBtmpl0000000000000088',1147642494,3600),('7-0-style0000000000011','2lhmrXW46ZMLvpbaaX2g7Q','nav1_off_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000012','sEoRwhmonl877RBgx2nE1w','nav1_off_right.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000013','AoSfRkPI3fl7vAooT4Fj_A','nav1_on.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000014','MgNDJRsghd_zQZ292hqVMQ','nav1_on_left.jpg','PBtmpl0000000000000088',1147642495,3600),('7-0-style0000000000015','aUG1FZaIqHaQHlieZ4_Mkg','nav1_on_right.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000016','HyhLnkaJMfr8eJsLIX8XeA','nav2_center_on.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000017','aledEnWoD-JVNURWSklfdg','nav2_off_center.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000018','Ffd33PToWon9X7mcKZqUAQ','nav2_off_left.jpg','PBtmpl0000000000000088',1147642496,3600),('7-0-style0000000000019','B3TTkcOlr-VzcxRwQXZmyg','nav2_off_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000020','RxGSyn-8W4p64SQ-NYzNOg','nav2_on_left.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000021','NciEByP8ssN6qDYyKcoGWw','nav2_on_right.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000022','9OVg_Nxo0gha5pWZsS_dmw','nav_bg.jpg','PBtmpl0000000000000088',1147642497,3600),('7-0-style0000000000023','VKtJGCmBtsMj8ZeAJ6ePNw','nav_on.jpg','PBtmpl0000000000000088',1147642498,3600),('7-0-style0000000000024','ryQb0A4YeEwYZo9hdgrCcw','orange_left01.jpg','PBtmpl0000000000000088',1147642498,3600),('7-0-style0000000000030','coew3C1i9AORof9ezjWLDg','webgui_btn.jpg','PBtmpl0000000000000088',1147642499,3600),('7-0-style0000000000032','HEySmh0CRxpkI-tjzgkDDw','context_bg.jpg','PBtmpl0000000000000088',1147642500,3600),('7-0-style0000000000034','HPn3mVDaMkn8Iu0GAq7cAw','leftCol_header.jpg','PBtmpl0000000000000088',1147642500,3600),('7-0-style0000000000035','IqaSdxJqqN_8C-7OWeyE2g','leftCol_header02.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000036','M0cIcS1GDFIV8lwAw3U2hA','main_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000037','77rakTqCXGBihEOXoh4ZXQ','nav_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000038','5najYvfJiZBBaiCVxaNkcQ','navbar_bg.jpg','PBtmpl0000000000000088',1147642501,3600),('7-0-style0000000000039','27XAOBKNfJ2euexImD73Aw','navbar_left.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000040','sgd1YdmVKj-n6IyIWJicXg','navbar_right.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000041','i1oJph6lb3hxEsTNu_3Y7g','page_title.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000042','qMwO_tp9KOya_N-kyIHDJQ','page_title_bg.jpg','PBtmpl0000000000000088',1147642502,3600),('7-0-style0000000000043','l5hF84u5R9MoqMvS9gpp6g','pb.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000044','Eh4IRmClOEzDAU1IVn5vHQ','pb_wg.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000045','e8yirsGt9FZEgzfeHLgRiw','pb_wg_bg.jpg','PBtmpl0000000000000088',1147642503,3600),('7-0-style0000000000046','hDmN6gu1w_jtrcxgTRN5OQ','rightCol_bg.jpg','PBtmpl0000000000000088',1147642504,3600),('7-0-style0000000000048','_QhSdbnBeA1zio6iAuGIag','wg.jpg','PBtmpl0000000000000088',1147642504,3600),('7-0-style0000000000052','VRqMCZ_-GgaJiDeOrnwlQg','footer_bg.jpg','PBtmpl0000000000000088',1147642505,3600),('7-0-style0000000000053','baxoDEB4C8eLjZbnENMs9w','footer_right.jpg','PBtmpl0000000000000088',1147642505,3600),('7-0-style0000000000054','FlivcrAW0pKW4q_2fvlVpw','header_bg.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000055','5hgdAMRWeSmHDrRFM_qbBw','header_left.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000056','lV6l3Sctxx8J1JmYlXwSDA','header_right.jpg','PBtmpl0000000000000088',1147642506,3600),('7-0-style0000000000057','FKGH2yiNQoC2E_FqbMYebw','main_bg.jpg','PBtmpl0000000000000088',1147642507,3600),('7-0-style0000000000058','UGtgwjDaqCtCPnEkuLPtIw','main_bottom.jpg','PBtmpl0000000000000088',1147642507,3600),('7-0-style0000000000060','XsuCCMz5vyyfC8Xr89pb1Q','main_top_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000061','is_6p2ROuy6AhCR1eJ8SdQ','nav_bg.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000062','3rpFbJWSV14AWeDZqqPSSw','nav_bg1.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000063','NcTFm_t9rn63ejwtBQnDQw','nav_bg1_on.jpg','PBtmpl0000000000000088',1147642508,3600),('7-0-style0000000000064','XLKBWi6Asbz5CtZdnwzZmg','nav_bg2.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000065','02cdKPH5-SyFEb_Zo_WL8A','nav_bg2_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000066','0QQpTB8bi6JZvFrW74SOWg','nav_bg_on.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000067','DdhQHfqGq-yC1ukTdlqoEg','pb.jpg','PBtmpl0000000000000088',1147642509,3600),('7-0-style0000000000068','Y4AWquISZVLcwVQLzd_u7w','spacer.gif','PBtmpl0000000000000088',1147642510,3600),('7-0-style0000000000071','mJOrQFemh2R3xn2HYviQlQ','wg.jpg','PBtmpl0000000000000088',1147642511,3600),('Vzv1pWpg_w6R_o-b0rM2qQ','PMKX5QYkNFvrCD15QVo8Tg','Tutorial.swf','pbtmpl0000000000000221',1147642515,3600),('_bZJ9LA_KNekZiFPaP2SeQ','RwcPC6VO-WH3HPaMNxQdxQ','shelf-titles.jpg','PBtmpl0000000000000088',1210777868,0),('hQ7z33_jOYkQ8WNX5xy9Sw','HCc0_yDJrhZIoKV__wiUDw','style-button.gif','PBtmpl0000000000000088',1209509455,0),('vWW_DcHiYSrKZOkkIfEfcQ','t_FrH8_ktSJtHQGQLDeudA','row-2.jpg','PBtmpl0000000000000088',1209509433,0),('_bPYzRA87NTAUIKlfrJMHg','EgZoQgSAhCrNP3sXjRDPkw','row-1.jpg','PBtmpl0000000000000088',1209509433,0),('nJjZHRwdDs5MAZYsAyioHw','edb4FERsJ0pU0mmnfsiCig','title-bg.jpg','PBtmpl0000000000000088',1209509433,0),('8hxfkrJPeFVRWF5piCNJ1A','hRM4w6S2cqFdDRPcUP6FIg','field-bg.jpg','PBtmpl0000000000000088',1209509433,0),('Osx7WN52iIKHZFT4vqUBHQ','Wa42mXdBWCT9B9kgqzh9CQ','search-btn.gif','PBtmpl0000000000000088',1209509433,0),('oWff8fGzRdHPyq5VNREe9Q','j-AYUZHpCRd0yYH2Youp4A','top-bg.jpg','PBtmpl0000000000000088',1209509433,0),('uqbkvb1b9443VvfkyRz95w','JXBzB0XDxTHC_KRk0jROGQ','save-button.gif','PBtmpl0000000000000088',1209509433,0),('8YiMkcz32xalkAn3WBLpag','3lttrXIB4qCFnsKxFTJoKw','go-btn.gif','PBtmpl0000000000000088',1210181860,0),('7-0-style0000000000059','QOhEl8bdecbSrml06V84iw','main_top.jpg','PBtmpl0000000000000088',1213386091,0),('o_pq_e4vRyhMOKFzs61eag','zTRhj1ZmjPc6b4ytLNIdLg','book-covers.jpg','PBtmpl0000000000000088',1215714957,0),('hBpisL-_URyZnh9clR5ohA','IYUoN4EWQWHZHQj-f5ex0g','no_photo.gif','PBtmpl0000000000000088',1227634417,0),('FOBV6KkifreXa4GmEAUU4A','69Zh__B-EI01IWjf9KBDrw','no_photo_sm.gif','PBtmpl0000000000000088',1227634447,0),('-0sK2rX1cwQt1ipUSqsiQQ','CamwRtlyRX-5BNkSNzDPIw','bg.gif','PBtmpl0000000000000088',1273032716,0),('hS_eOaVz9Qb5ixndK9EXAw','o7fDCt5nLymcuiTf2YCFSw','header.jpg','PBtmpl0000000000000088',1273032716,0),('k2p-Be8C98pf2cRq7E-JHg','67nNZ2B0A4lRzoqadwMgLQ','tab_link.gif','PBtmpl0000000000000088',1273032716,0),('aYG4fjbMPbC4LCuuMp4gGA','6spEu4jqWCkdMdyhArfS9A','tab_hover.gif','PBtmpl0000000000000088',1273032716,0),('F122Ey0NtVAw6Lfv1M6G_Q','jUsYsBXtuLJa8Onpi5HU3g','ico_archive.gif','PBtmpl0000000000000088',1273032716,0),('qmXHKrQ6EDLSOGkrEKRUDA','75kfvWZUedWHNdLfM-AtkQ','bg_page_in.jpg','PBtmpl0000000000000088',1273032716,0),('4qZgXjPPO4fwV879yu5XUg','ih2o91dTNCVJlenr9stdbw','bg_page.JPG','PBtmpl0000000000000088',1273032716,0),('mb-xeAugm5GJdvu-Wh0MtQ','8VCgTKlQwVGFKufySjaHNA','search_submit.gif','PBtmpl0000000000000088',1273032717,0),('84Y9CwgzP6eNU7wZnk019Q','QxrDfsAi4k7N-dH6_6Ha9A','ico_date.gif','PBtmpl0000000000000088',1273032717,0),('ikXTtJKZfHVxqw-47E4AQA','83muqXYuxwND5hFjjp-w6Q','ico_user.gif','PBtmpl0000000000000088',1273032717,0),('DhRWPTgzhvju_-TbMN3CwA','BxVwfcPeSjMPqBNal_E2QA','ico_comments.gif','PBtmpl0000000000000088',1273032717,0),('6njI-pZz2bwsjWh-Q1_11g','OFFn_bjzx1DJfXFo1OF1vw','ico_list.gif','PBtmpl0000000000000088',1273032717,0),('_Hz1Gnd3yEnJzVS7l7nJMQ','OYL4yTE8m7-C4dpnmcPtzw','content_all_bg.PNG','PBtmpl0000000000000088',1273032717,0),('VOOrXK5dFnkGih7aTkuDWA','Oung_80DQKn8roLpf_gczQ','search.PNG','PBtmpl0000000000000088',1273032717,0),('ruf-QejOkUHDRtfgakHlbA','k4TQ8lQX80BRB6DByAeOqw','col_title_bg_long.GIF','PBtmpl0000000000000088',1273032717,0),('FSHy5KjQjkt599PHS41seA','ttpOQyYPTtrc40m_3XD3qA','footer.jpg','PBtmpl0000000000000088',1273032717,0),('nuYYXAz4KNNxgfumfnpo_g','JQ6tIpLMOEeT-B3qgIO1tA','ico_top.gif','PBtmpl0000000000000088',1273032718,0),('Mr7ljjoy6n4fZojpQWajKQ','VtEeuhaJ9WqtHzKKiSapNQ','ico_links.gif','PBtmpl0000000000000088',1273032718,0),('ApkqpDOrJDxK3QrWBGSRIg','-pr99yzoIq1OWGE4nEc2AQ','ico_archive2.gif','PBtmpl0000000000000088',1273032718,0),('AzzTY0Lay1f_YGeQJFnQCA','YRAPgXl7Y0gbSKCiLnHetA','ico_list.gif','PBtmpl0000000000000088',1273032718,0),('A_5LVQQWR73QZR8FFbny_w','EhTwB4FAnLZPn-ftde39aA','bg.gif','PBtmpl0000000000000088',1273032719,0),('wywIfa_VuTsq0c5Ed-W-MA','vRNJdIZnq7p-HiE0L0xtng','bullet.gif','PBtmpl0000000000000088',1273032719,0),('xmykMFjri1O2NrYHbeToVQ','hDLGlqQr30t4eSzkVsZ70Q','footerbg.gif','PBtmpl0000000000000088',1273032719,0),('0IIGNBs_-INzqBC5VLeJgw','sw1Dzrtgwh_J65h1JjKFxg','headerbg.gif','PBtmpl0000000000000088',1273032719,0),('FXmePdyS0YKuZ1VCGGpK9w','sEZViIdlwRyLYlYYJBl1zg','quote.gif','PBtmpl0000000000000088',1273032719,0),('66qCywiE_fiL9u5YIaJhgw','3f4UAvd-KAnsR7w3BzXrRA','tableft.gif','PBtmpl0000000000000088',1273032719,0),('n5VpG4lFsOG1elaWDQbilw','h3rSYSpA57LA3YOGXyoXxg','tabright.gif','PBtmpl0000000000000088',1273032719,0),('pAXR7Kby4O-dSxOwLp1GaA','XEJSXwP-3ewf3RWNpYplUQ','top_mod.png','PBtmpl0000000000000088',1273032721,0),('TthzMLO4n3qxy59QZ5YBHg','pnAHCnmSYdV5oNTM0M9Dcw','menu_bg_dark.png','PBtmpl0000000000000088',1273032721,0),('3n31SQjYa150TBrRBgMPhA','Zh3MnwG0dPeCCjdj4DI2-g','menu_bg_light.png','PBtmpl0000000000000088',1273032721,0),('R4RxDufGbbIzEmpcoEcLrw','pxzCDlZfytwlzey0dPM1yg','logo_full.jpg','PBtmpl0000000000000088',1273032721,0),('bCGr7FRtZt-XYlBVUEJBjw','qxpFkNVhpNAeNODtKcXdWA','Getting_Started_doc.pdf','PBtmpl0000000000000088',1278013724,3600),('bANo8aiAPA7aY_oQZKxIWw','JpcppU2QVhwzkRQ_3cPrig','rss.gif','PBtmpl0000000000000088',1284523757,0),('2ci_v2d4x4uvyjTRlC49OA','AKxSROUAD512YVWMVnCFKA','moveDown.gif','PBtmpl0000000000000088',1284523757,0),('O-EsSzKgAk1KolFT-x_KsA','NMkjv95L4_2hAr24Zk6t_w','moveUp.gif','PBtmpl0000000000000088',1284523757,0),('fdd8tGExyVwHyrB8RBbKXg','UeHYn4prIObzFLOEKJCdJg','next.gif','PBtmpl0000000000000088',1284523757,0),('BpisgHl4ZDcSECJp6oib1w','fAKWhpZ8JjjUx7Mp9me0cg','play.gif','PBtmpl0000000000000088',1284523757,0),('zshreRgPAXtnF0DtVbQ1Yg','nqN_FI5RfUrj1jJvaR2Ejw','previous.gif','PBtmpl0000000000000088',1284523757,0),('POVcY79vIqAHR8OfGt36aw','_WafZBaw-va8uVngB-n1Cg','pagination_button.jpg','PBtmpl0000000000000088',1284523757,0),('hIB-z34r8Xl-vYVYCkKr-w','eMdb0POFC67cjHcfC8QV6w','bar-btn-r.jpg','PBtmpl0000000000000088',1284523758,0),('-mPUoFlYcjqjPUPRLAlxNQ','2kGHNiOCXpdjkNvGm7FckQ','search-field-r.jpg','PBtmpl0000000000000088',1284523758,0),('MDpUOR-N8KMyt1J7Hh_h4w','0FU2asON4Cpz84ZqVv2j0Q','bar-btn.jpg','PBtmpl0000000000000088',1284523758,0),('YfXKByTwDZVituMc4h13Dg','yNQIBSJTOyIELRMx8e1HFA','pagination_bg.jpg','PBtmpl0000000000000088',1284523758,0),('esko_HSU0Gh-uJZ1h3xRmQ','7AYtwHJ5ID67bh9USLisRA','search-field-l.jpg','PBtmpl0000000000000088',1284523758,0),('oSqpGswzpBG_ErdfYwIO8A','PEwj2Dax-ie0pFi3umQcCg','top_bg.jpg','PBtmpl0000000000000088',1284523758,0),('MXJklShZvLLB_DSnZQmXrQ','i3MwZiI6H2s4ch3o8qGzWg','title_bg.jpg','PBtmpl0000000000000088',1284523758,0),('BthxD5oJ0idmsyI3ioA2FA','E_Tdc6--HA70UcAgFqm5aA','bar-btn-l.jpg','PBtmpl0000000000000088',1284523758,0),('aZ-1HYQamkRHYXvzAra8WQ','JnwzFJWb00KcvD_Y0c-qNQ','search-field.jpg','PBtmpl0000000000000088',1284523758,0),('eRkb94OYcS5AdcrrerOP5Q','p1phyvMUP032yG2CZTFbXw','rss.gif','PBtmpl0000000000000088',1284523758,0),('TbnkjAJQEASORXIpYqDkcA','2tbRPmG1Bb1xg31inIP2Bw','blank-image.jpg','PBtmpl0000000000000088',1284523758,0),('er-3faBjY-hhlDcc5aKqdQ','sEeSjDgTnXyGFs0l3m0Gcg','top_bg.jpg','PBtmpl0000000000000088',1284523758,0),('8bFsu2FJUqHRUiHcozcVFw','WCHvuoJ0seQRBvhSHnZNuw','sub-btn-l.jpg','PBtmpl0000000000000088',1284523758,0),('34Aayx5eA320D8VfhdfDBw','bJRXXELPgng8Hmq3DbgX_w','sub-btn-r.jpg','PBtmpl0000000000000088',1284523758,0),('TlhKOVmWblZOsAdqmhEpeg','YWxgdQSbgXlybWHVGlkY0w','sub-btn.jpg','PBtmpl0000000000000088',1284523758,0),('Nx0ypjO3cN6QdZUBUEE0lA','WbdjhOE2fivqHkg1AtB0fQ','pic-title-bg.jpg','PBtmpl0000000000000088',1284523758,0),('CmFZLN7iPS7XXvUEsxKPKA','rPjoy1rPO4wSOTpCpD6rxw','row-2.jpg','PBtmpl0000000000000088',1284523758,0),('v_XBgwwZqgW1D5s4y05qfg','rY-oHSOhzmi6ChVqdK3aFQ','addtl-info.gif','PBtmpl0000000000000088',1284523759,0),('4TdAkKoQbSCvI7QWcW889A','HvuUzQX6jFB7Id5uiQSoJA','row-1.jpg','PBtmpl0000000000000088',1284523759,0),('SAgK6eDPCG1cgkJ59WapHQ','t5wGWmFsAU-gEZ9MKQVPUw','prev-btn.gif','PBtmpl0000000000000088',1284523759,0),('XJYLuvGy9ubF7JNKyINtpA','URLC12rdK3WJvZPMwMlPJQ','play-btn.gif','PBtmpl0000000000000088',1284523759,0),('RWj7hyv2SpZuXxwj1Wocug','oXNEUhS8kPMUgn_ffaOJ9w','next-btn.gif','PBtmpl0000000000000088',1284523759,0),('aq8QElnlm3YufAoxRz9Pcg','4Ch-mtMeddIHOcWbTd5vyA','data-bg.jpg','PBtmpl0000000000000088',1284523759,0),('i6-BofrJJYozovlzFBByXg','F-oeeyCC7F512RbX3b81-g','first-photo-button.png','PBtmpl0000000000000088',1284523759,0),('fU_OZCmtdFNJ8a6bMve8ng','zp7oWiWjlqLL0uFwffWwHg','previous-photo-button.png','PBtmpl0000000000000088',1284523759,0),('YXCtusAxb4vzZ5sTnUA5DA','3uzHqzlwqXOgOZgyH38bLQ','next-photo-button.png','PBtmpl0000000000000088',1284523759,0),('k_xuE82wwp8gFVl9aaaG8g','v-M0mgXsVNT5VnmAs7OOoQ','last-photo-button.png','PBtmpl0000000000000088',1284523759,0),('NPM_WItpM5IzLWBhWjYfCA','2ZVSz3SkLls8aeF6ap5EwA','photo-navigation-spacer.png','PBtmpl0000000000000088',1284523759,0),('2q5fxatSFLgIhXaUX-oSvg','vKJVExCJ-_aiusKZ1c3W8A','bottom-left.jpg','PBtmpl0000000000000088',1289360562,0),('_d5WTkKjnwct-_Dk7gZHvQ','PRo0-P374rcVix_ZT0slYw','bottom-right.jpg','PBtmpl0000000000000088',1289360562,0),('Iz2mUR3jCPKyemwAea4b2g','noGotj63jibLexrPAnO3Sw','input_bg.jpg','PBtmpl0000000000000088',1289360562,0),('JU9bjsLRoWj7GVHs__prig','wTkVCAcaFY78Tz0k9y3b2A','top-left.jpg','PBtmpl0000000000000088',1289360562,0),('noOlnjQGexHg8c4bGVUo9g','CmW_ow8QWvO6UDqzf_hjkA','top-right.jpg','PBtmpl0000000000000088',1289360562,0);
ALTER TABLE `FileAsset` ENABLE KEYS;
ALTER TABLE `Folder` DISABLE KEYS;
INSERT INTO `Folder` VALUES ('PBasset000000000000002','PBtmpl0000000000000078',1124395696,3600,0,'ASC'),('7-0-style0000000000001','PBtmpl0000000000000078',1147642492,3600,0,'ASC'),('7-0-style0000000000031','PBtmpl0000000000000078',1147642500,3600,0,'ASC'),('PBasset000000000000003','PBtmpl0000000000000078',1147642437,3600,0,'ASC'),('nbSrhXZQuxIjhWFaFPSuVA','PBtmpl0000000000000078',1147642465,3600,0,'ASC'),('S1A9iAwKcQQ6P20uTqw-Ew','PBtmpl0000000000000078',1147642468,3600,0,'ASC'),('N13SD1Fpqk00UgBt1Z8ivQ','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('-WM2dt0ZGpDasuL2wWocxg','PBtmpl0000000000000078',1222803056,3600,0,'ASC'),('3uuBf8cYuj1sew2OJXl9tg','PBtmpl0000000000000078',1147642470,3600,0,'ASC'),('2OcUWHVsu_L1sDFzIMWYqw','PBtmpl0000000000000078',1222803070,3600,0,'ASC'),('cj2y4papTVGZRFdwTI-_fw','PBtmpl0000000000000078',1147642475,3600,0,'ASC'),('bBzO4CWjqU_ile3gf5Iypw','PBtmpl0000000000000078',1147642475,3600,0,'ASC'),('Da6KWn805L4B5e4HFgQRQA','PBtmpl0000000000000078',1147642479,3600,0,'ASC'),('bbiA9Zq5Gy2oCFBlILO3QA','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('Efe2W0UgrSRDltNJ87jlfg','PBtmpl0000000000000078',1147642480,3600,0,'ASC'),('9wKWdum0_8z-OhhquWLtSQ','PBtmpl0000000000000078',1147642483,3600,0,'ASC'),('CSN-ZON7Uwv8kxf3F1fh5Q','PBtmpl0000000000000078',1147642484,3600,0,'ASC'),('TCtybxdqmdwdvRn555zpCQ','PBtmpl0000000000000078',1147642484,3600,0,'ASC'),('tempspace0000000000000','PBtmpl0000000000000078',1185754574,3600,0,'ASC'),('Tsg7xmPYv782j6IVz7yHFg','PBtmpl0000000000000078',1213244777,3600,0,'ASC'),('TYo2Bwl7aafzTtdHlS-arQ','PBtmpl0000000000000078',1211664878,3600,0,'ASC'),('6tK47xsaIH-ELw0IBo0uRQ','PBtmpl0000000000000078',1210777115,3600,0,'ASC'),('gbnRhcWNk1iQe32LFEB5eQ','PBtmpl0000000000000078',1212086102,3600,0,'ASC'),('6D4Z-oruXPS6OlH_Kx8pBg','PBtmpl0000000000000078',1209509389,3600,0,'ASC'),('C5fPz-Wg85vkYRvCdl-Xqw','PBtmpl0000000000000078',1212160830,3600,0,'ASC'),('jnYdqDkUR8x7Pv2eGR1qTA','PBtmpl0000000000000078',1216250666,3600,0,'ASC'),('zyWi26q9na-iiZqL4yedog','PBtmpl0000000000000078',1222803114,3600,0,'ASC'),('tBL7BWiQRZFed2Y-Zjo9tQ','PBtmpl0000000000000078',1222803200,3600,0,'ASC'),('GdkQpvjRtJqtzOUbwIIQRA','PBtmpl0000000000000078',1222803205,3600,0,'ASC'),('tnc5iYyynX2hfdEs9D3P8w','PBtmpl0000000000000078',1222803213,3600,0,'ASC'),('vgXdBcFTqU7h4wBG1ewdBw','PBtmpl0000000000000078',1222803217,3600,0,'ASC'),('hcFlqnXlsmC1ujN6Id0F0A','PBtmpl0000000000000078',1222803234,3600,0,'ASC'),('eRJR52fvlaxfetv3DQkQYw','PBtmpl0000000000000078',1222803238,3600,0,'ASC'),('5HIDHq5lAWHV5gpYGS0zLg','PBtmpl0000000000000078',1222803244,3600,0,'ASC'),('rYEFwXXo0tkGhQTcbDibvg','PBtmpl0000000000000078',1222803249,3600,0,'ASC'),('V3l5S5TtI7wMm1WpIMhvOA','PBtmpl0000000000000078',1222803253,3600,0,'ASC'),('nqNbSUAhk9Vd1zda2SCz9A','PBtmpl0000000000000078',1222803258,3600,0,'ASC'),('y8XkRdxIperLKkJ3bL5sSQ','PBtmpl0000000000000078',1222803264,3600,0,'ASC'),('vTymIDYL2YqEh6PV50F7ew','PBtmpl0000000000000078',1222803302,3600,0,'ASC'),('lo1ac3BsoJx3ijGQ3gR-bQ','PBtmpl0000000000000078',1222803309,3600,0,'ASC'),('huASapWvFDzqwOSbcN-JFQ','PBtmpl0000000000000078',1222803313,3600,0,'ASC'),('9A-mg2gwWmaYi9o_1C7ArQ','PBtmpl0000000000000078',1222803338,3600,0,'ASC'),('yD1SMHelczihzjEmx6eXBA','PBtmpl0000000000000078',1222803342,3600,0,'ASC'),('pV7GnZdpjR3XpZaSINIoeg','PBtmpl0000000000000078',1222803347,3600,0,'ASC'),('71e17KeduiXgODLMlUxiow','PBtmpl0000000000000078',1222803352,3600,0,'ASC'),('Ik9HHky10DIyFTKehUD1dw','PBtmpl0000000000000078',1222803478,3600,0,'ASC'),('NywJYmGWe1f6EBXJnWg9Xg','PBtmpl0000000000000078',1222803638,3600,0,'ASC'),('AgyFhx3eXlfZXNp2MkrsiQ','PBtmpl0000000000000078',1222803665,3600,0,'ASC'),('F7MAQ-cpuvQ1KuC7J4P5zQ','PBtmpl0000000000000078',1222803673,3600,0,'ASC'),('BmLaN4rmAANkCglXUViEbg','PBtmpl0000000000000078',1222803871,3600,0,'ASC'),('X7DrzUcj8pOKFa_6k9D5iw','PBtmpl0000000000000078',1222804045,3600,0,'ASC'),('UL-ItI4L1Z6-WSuhuXVvsQ','PBtmpl0000000000000078',1225139673,3600,0,'ASC'),('7-0-style0000000000049','PBtmpl0000000000000078',1224117144,3600,0,'ASC'),('QpmlAiYZz6VsKBM-_0wXaw','PBtmpl0000000000000078',1224616691,3600,0,'ASC'),('IZkrow_zwvbf4FCH-taVTQ','PBtmpl0000000000000078',1226011853,3600,0,'ASC'),('K0YjxqOqr7RupSo6sIdcAg','PBtmpl0000000000000078',1227074310,3600,0,'ASC'),('_ilRXNR3s8F2vGJ_k9ePcg','PBtmpl0000000000000078',1226643205,3600,0,'ASC'),('qaVcU0FFzzraMX_bzELqzw','PBtmpl0000000000000078',1227074362,3600,0,'ASC'),('QHn6T9rU7KsnS3Y70KCNTg','PBtmpl0000000000000078',1233173545,3600,0,'ASC'),('HW-sPoDDZR8wBZ0YgFgPtg','PBtmpl0000000000000078',1227634350,3600,0,'ASC'),('AOjPG2NHgfL9Cq6dDJ7mew','PBtmpl0000000000000078',1236960881,3600,0,'ASC'),('jmlI9IK-lV8n2WMYmmPhAA','PBtmpl0000000000000078',1238106173,3600,0,'ASC'),('6uvSLY-ak_w4p_wS8q33cA','PBtmpl0000000000000078',1239213092,3600,0,'ASC'),('GaBAW-2iVhLMJaZQzVLE5A','PBtmpl0000000000000078',1240103565,3600,0,'ASC'),('lo1rpxn3t8YPyKGers5eQg','PBtmpl0000000000000078',1238625621,3600,0,'ASC'),('aNNC62qLAS6TB-0_MCYjsw','PBtmpl0000000000000078',1246969327,3600,0,'ASC'),('BFfNj5wA9bDw8H3cnr8pTw','PBtmpl0000000000000078',1247046273,3600,0,'ASC'),('f_tn9FfoSfKWX43F83v_3w','PBtmpl0000000000000078',1247053009,3600,0,'ASC'),('oGfxez5sksyB_PcaAsEm_Q','PBtmpl0000000000000078',1247053097,3600,0,'ASC'),('tPagC0AQErZXjLFZQ6OI1g','PBtmpl0000000000000078',1246966459,3600,0,'ASC'),('GYaFxnMu9UsEG8oanwB6TA','PBtmpl0000000000000078',1246965871,3600,0,'ASC'),('VZK3CRgiMb8r4dBjUmCTgQ','PBtmpl0000000000000078',1247046242,3600,0,'ASC'),('tXwf1zaOXTvsqPn6yu-GSw','PBtmpl0000000000000078',1246965607,3600,0,'ASC'),('5bnNzteN7w3NnK9mF4XiCg','PBtmpl0000000000000078',1250243000,3600,0,'ASC'),('RSAMkc6WQmfRE3TOr1_3Mw','PBtmpl0000000000000078',1250243000,3600,0,'ASC'),('fowHfgOkJtAxdst7rugTog','PBtmpl0000000000000078',1252595993,3600,0,'ASC'),('TvOZs8U1kRXLtwtmyW75pg','PBtmpl0000000000000078',1256092368,3600,0,'ASC'),('brxm_faNdZX5tRo3p50g3g','PBtmpl0000000000000078',1256092368,3600,0,'ASC'),('4qh0kIsFUdd4Ox-Iu1JZgg','PBtmpl0000000000000078',1257311886,3600,0,'ASC'),('-K8Hj45mbelljN9-0CXZxg','PBtmpl0000000000000078',1257311887,3600,0,'ASC'),('P_4uog81vSUK4KxuW_4GUA','PBtmpl0000000000000078',1258524916,3600,0,'ASC'),('t87D1138NhPHhA23-hozBA','PBtmpl0000000000000078',1273032716,3600,0,'ASC'),('QtBumey5ffc-xffRp1-7Aw','PBtmpl0000000000000078',1273032716,3600,0,'ASC'),('CQp-RFA2pMh5lFSggPPPYg','PBtmpl0000000000000078',1273032719,3600,0,'ASC'),('_Mi_NTd3x8UB96LWezWHnw','PBtmpl0000000000000078',1273032719,3600,0,'ASC'),('g3JH1PRq6m6Bj_PnGpcrSQ','PBtmpl0000000000000078',1273032719,3600,0,'ASC'),('G0hl4VilbFKipToyxKqFrg','PBtmpl0000000000000078',1273032719,3600,0,'ASC'),('GWU2qZqe6yEuAKG-5HtBdg','PBtmpl0000000000000078',1273032719,3600,0,'ASC'),('AsfpsOpsGzZCb9m7MyxPuw','PBtmpl0000000000000078',1273032720,3600,0,'ASC'),('Q4uX_C557arTp6D_jwB1jQ','PBtmpl0000000000000078',1273032720,3600,0,'ASC'),('1qFjOEiILIwr1xB5_ebppQ','PBtmpl0000000000000078',1273032721,3600,0,'ASC'),('xD76UfQ_JnSgTLBNvytcpQ','PBtmpl0000000000000078',1273032721,3600,0,'ASC'),('G5DgNizuG3jXkjPp6UaGrA','PBtmpl0000000000000078',1273032722,3600,0,'ASC'),('GNOAsX98vCsl0JRwfwL-gg','PBtmpl0000000000000078',1277868921,3600,0,'ASC'),('LdiozcIUciWuvt3Z-na5Ww','PBtmpl0000000000000078',1281501162,3600,0,'ASC'),('AssetReportFolder00001','PBtmpl0000000000000078',1281501163,3600,0,'ASC'),('N7uMnnicbyTEulcuRi1sSg','PBtmpl0000000000000078',1284523698,3600,0,'ASC'),('gI_TxK-5S4DNuv42wpImmw','PBtmpl0000000000000078',1284523756,3600,0,'ASC'),('kaPRSaf8UKiskiGEgJgLAw','PBtmpl0000000000000078',1284523757,3600,0,'ASC'),('HPDOcsj4gBme8D4svHodBw','PBtmpl0000000000000078',1285733367,3600,0,'ASC'),('RrV4aAPnn4dM0ZcU3OXnlw','PBtmpl0000000000000078',1286941427,3600,0,'ASC'),('1z9J1O08n_7gVVlBwSRBJQ','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('xSmREZO3GNzK3M5PaueOOQ','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('0bx-xoL8TSXXubFuqKAoVQ','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('taX2UYkFF21ALpFZY2rhMw','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('K0q_N885Httqev1VCqUWxg','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('fq1ZkYhH24R5tb96kuT10Q','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('oHk7fAFhEEkB7dHzi0QOQA','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('9M-lrlPQWeeNWfvnDnK_Xg','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('_gBYAdTcbkiyamnqi2Xskg','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('0iMMbGN3BevuCBHjjLiQNA','PBtmpl0000000000000078',1288142106,3600,0,'ASC'),('6A4yIjWwJfIE0Ep-I0jutg','PBtmpl0000000000000078',1288142107,3600,0,'ASC'),('_cD6DLM_Fs5IlrLeWUjrjg','PBtmpl0000000000000078',1288142107,3600,0,'ASC'),('aNmgn0cd6tldmC1FpW4KbA','PBtmpl0000000000000078',1289360562,3600,0,'ASC'),('jEz8iTGNWEt2I05IhVV19Q','PBtmpl0000000000000078',1289360563,3600,0,'ASC');
ALTER TABLE `Folder` ENABLE KEYS;
ALTER TABLE `ImageAsset` DISABLE KEYS;
INSERT INTO `ImageAsset` VALUES ('7-0-style0000000000002',50,NULL,1147642492,NULL),('7-0-style0000000000004',50,NULL,1147642493,NULL),('7-0-style0000000000005',50,NULL,1147642493,NULL),('7-0-style0000000000006',50,NULL,1147642493,NULL),('7-0-style0000000000007',50,NULL,1147642493,NULL),('7-0-style0000000000008',50,NULL,1147642494,NULL),('7-0-style0000000000009',50,NULL,1147642494,NULL),('7-0-style0000000000010',50,NULL,1147642494,NULL),('7-0-style0000000000011',50,NULL,1147642495,NULL),('7-0-style0000000000012',50,NULL,1147642495,NULL),('7-0-style0000000000013',50,NULL,1147642495,NULL),('7-0-style0000000000014',50,NULL,1147642495,NULL),('7-0-style0000000000015',50,NULL,1147642496,NULL),('7-0-style0000000000016',50,NULL,1147642496,NULL),('7-0-style0000000000017',50,NULL,1147642496,NULL),('7-0-style0000000000018',50,NULL,1147642496,NULL),('7-0-style0000000000019',50,NULL,1147642497,NULL),('7-0-style0000000000020',50,NULL,1147642497,NULL),('7-0-style0000000000021',50,NULL,1147642497,NULL),('7-0-style0000000000022',50,NULL,1147642497,NULL),('7-0-style0000000000023',50,NULL,1147642498,NULL),('7-0-style0000000000024',50,NULL,1147642498,NULL),('7-0-style0000000000030',50,NULL,1147642499,NULL),('7-0-style0000000000032',50,NULL,1147642500,NULL),('7-0-style0000000000034',50,NULL,1147642500,NULL),('7-0-style0000000000035',50,NULL,1147642501,NULL),('7-0-style0000000000036',50,NULL,1147642501,NULL),('7-0-style0000000000037',50,NULL,1147642501,NULL),('7-0-style0000000000038',50,NULL,1147642501,NULL),('7-0-style0000000000039',50,NULL,1147642502,NULL),('7-0-style0000000000040',50,NULL,1147642502,NULL),('7-0-style0000000000041',50,NULL,1147642502,NULL),('7-0-style0000000000042',50,NULL,1147642502,NULL),('7-0-style0000000000043',50,NULL,1147642503,NULL),('7-0-style0000000000044',50,NULL,1147642503,NULL),('7-0-style0000000000045',50,NULL,1147642503,NULL),('7-0-style0000000000046',50,NULL,1147642504,NULL),('7-0-style0000000000048',50,NULL,1147642504,NULL),('7-0-style0000000000052',50,'style=\"border-style:none;\"',1147642505,NULL),('7-0-style0000000000053',50,'style=\"border-style:none;\"',1147642505,NULL),('7-0-style0000000000054',50,'style=\"border-style:none;\"',1147642506,NULL),('7-0-style0000000000055',50,'style=\"border-style:none;\"',1147642506,NULL),('7-0-style0000000000056',50,'style=\"border-style:none;\"',1147642506,NULL),('7-0-style0000000000057',50,'style=\"border-style:none;\"',1147642507,NULL),('7-0-style0000000000058',50,'style=\"border-style:none;\"',1147642507,NULL),('7-0-style0000000000060',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000061',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000062',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000063',50,'style=\"border-style:none;\"',1147642508,NULL),('7-0-style0000000000064',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000065',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000066',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000067',50,'style=\"border-style:none;\"',1147642509,NULL),('7-0-style0000000000068',50,'style=\"border-style:none;\"',1147642510,NULL),('7-0-style0000000000071',50,'style=\"border-style:none;\"',1147642511,NULL),('_bZJ9LA_KNekZiFPaP2SeQ',50,'style=\"border-style:none;\" alt=\"shelf-titles.jpg\"',1210777868,NULL),('hQ7z33_jOYkQ8WNX5xy9Sw',50,'style=\"border-style:none;\" alt=\"style-button.gif\"',1209509455,NULL),('vWW_DcHiYSrKZOkkIfEfcQ',50,'style=\"border-style:none;\" alt=\"row-2.jpg\"',1209509433,NULL),('_bPYzRA87NTAUIKlfrJMHg',50,'style=\"border-style:none;\" alt=\"row-1.jpg\"',1209509433,NULL),('nJjZHRwdDs5MAZYsAyioHw',50,'style=\"border-style:none;\" alt=\"title-bg.jpg\"',1209509433,NULL),('8hxfkrJPeFVRWF5piCNJ1A',50,'style=\"border-style:none;\" alt=\"field-bg.jpg\"',1209509433,NULL),('Osx7WN52iIKHZFT4vqUBHQ',50,'style=\"border-style:none;\" alt=\"search-btn.gif\"',1209509433,NULL),('oWff8fGzRdHPyq5VNREe9Q',50,'style=\"border-style:none;\" alt=\"top-bg.jpg\"',1209509433,NULL),('uqbkvb1b9443VvfkyRz95w',50,'style=\"border-style:none;\" alt=\"save-button.gif\"',1209509433,NULL),('8YiMkcz32xalkAn3WBLpag',50,'style=\"border-style:none;\" alt=\"go-btn.gif\"',1210181860,NULL),('7-0-style0000000000059',50,'alt=\"main_top.jpg\"',1213386091,NULL),('o_pq_e4vRyhMOKFzs61eag',50,'style=\"border-style:none;\" alt=\"book-covers.jpg\"',1215714957,''),('hBpisL-_URyZnh9clR5ohA',50,'style=\"border-style:none;\" alt=\"no_photo.gif\"',1227634417,''),('FOBV6KkifreXa4GmEAUU4A',50,'style=\"border-style:none;\" alt=\"no_photo_sm.gif\"',1227634447,''),('-0sK2rX1cwQt1ipUSqsiQQ',50,'style=\"border-style:none;\" alt=\"bg.gif\"',1273032716,''),('hS_eOaVz9Qb5ixndK9EXAw',50,'style=\"border-style:none;\" alt=\"header.jpg\"',1273032716,''),('k2p-Be8C98pf2cRq7E-JHg',50,'style=\"border-style:none;\" alt=\"tab_link.gif\"',1273032716,''),('aYG4fjbMPbC4LCuuMp4gGA',50,'style=\"border-style:none;\" alt=\"tab_hover.gif\"',1273032716,''),('F122Ey0NtVAw6Lfv1M6G_Q',50,'style=\"border-style:none;\" alt=\"ico_archive.gif\"',1273032716,''),('qmXHKrQ6EDLSOGkrEKRUDA',50,'style=\"border-style:none;\" alt=\"bg_page_in.jpg\"',1273032716,''),('4qZgXjPPO4fwV879yu5XUg',50,'style=\"border-style:none;\" alt=\"bg_page.JPG\"',1273032716,''),('mb-xeAugm5GJdvu-Wh0MtQ',50,'style=\"border-style:none;\" alt=\"search_submit.gif\"',1273032717,''),('84Y9CwgzP6eNU7wZnk019Q',50,'style=\"border-style:none;\" alt=\"ico_date.gif\"',1273032717,''),('ikXTtJKZfHVxqw-47E4AQA',50,'style=\"border-style:none;\" alt=\"ico_user.gif\"',1273032717,''),('DhRWPTgzhvju_-TbMN3CwA',50,'style=\"border-style:none;\" alt=\"ico_comments.gif\"',1273032717,''),('6njI-pZz2bwsjWh-Q1_11g',50,'style=\"border-style:none;\" alt=\"ico_list.gif\"',1273032717,''),('_Hz1Gnd3yEnJzVS7l7nJMQ',50,'style=\"border-style:none;\" alt=\"content_all_bg.PNG\"',1273032717,''),('VOOrXK5dFnkGih7aTkuDWA',50,'style=\"border-style:none;\" alt=\"search.PNG\"',1273032717,''),('ruf-QejOkUHDRtfgakHlbA',50,'style=\"border-style:none;\" alt=\"col_title_bg_long.GIF\"',1273032717,''),('FSHy5KjQjkt599PHS41seA',50,'style=\"border-style:none;\" alt=\"footer.jpg\"',1273032717,''),('nuYYXAz4KNNxgfumfnpo_g',50,'style=\"border-style:none;\" alt=\"ico_top.gif\"',1273032718,''),('Mr7ljjoy6n4fZojpQWajKQ',50,'style=\"border-style:none;\" alt=\"ico_links.gif\"',1273032718,''),('ApkqpDOrJDxK3QrWBGSRIg',50,'style=\"border-style:none;\" alt=\"ico_archive2.gif\"',1273032718,''),('AzzTY0Lay1f_YGeQJFnQCA',50,'style=\"border-style:none;\" alt=\"ico_list.gif\"',1273032718,''),('A_5LVQQWR73QZR8FFbny_w',50,'style=\"border-style:none;\" alt=\"bg.gif\"',1273032719,''),('wywIfa_VuTsq0c5Ed-W-MA',50,'style=\"border-style:none;\" alt=\"bullet.gif\"',1273032719,''),('xmykMFjri1O2NrYHbeToVQ',50,'style=\"border-style:none;\" alt=\"footerbg.gif\"',1273032719,''),('0IIGNBs_-INzqBC5VLeJgw',50,'style=\"border-style:none;\" alt=\"headerbg.gif\"',1273032719,''),('FXmePdyS0YKuZ1VCGGpK9w',50,'style=\"border-style:none;\" alt=\"quote.gif\"',1273032719,''),('66qCywiE_fiL9u5YIaJhgw',50,'style=\"border-style:none;\" alt=\"tableft.gif\"',1273032719,''),('n5VpG4lFsOG1elaWDQbilw',50,'style=\"border-style:none;\" alt=\"tabright.gif\"',1273032719,''),('pAXR7Kby4O-dSxOwLp1GaA',50,'style=\"border-style:none;\" alt=\"top_mod.png\"',1273032721,''),('TthzMLO4n3qxy59QZ5YBHg',50,'style=\"border-style:none;\" alt=\"menu_bg_dark.png\"',1273032721,''),('3n31SQjYa150TBrRBgMPhA',50,'style=\"border-style:none;\" alt=\"menu_bg_light.png\"',1273032721,''),('R4RxDufGbbIzEmpcoEcLrw',50,'style=\"border-style:none;\" alt=\"logo_full.jpg\"',1273032721,''),('bCGr7FRtZt-XYlBVUEJBjw',50,'style=\"border-style:none;\"',1278013724,''),('bANo8aiAPA7aY_oQZKxIWw',50,'style=\"border-style:none;\" alt=\"rss.gif\"',1284523757,''),('2ci_v2d4x4uvyjTRlC49OA',50,'style=\"border-style:none;\" alt=\"moveDown.gif\"',1284523757,''),('O-EsSzKgAk1KolFT-x_KsA',50,'style=\"border-style:none;\" alt=\"moveUp.gif\"',1284523757,''),('fdd8tGExyVwHyrB8RBbKXg',50,'style=\"border-style:none;\" alt=\"next.gif\"',1284523757,''),('BpisgHl4ZDcSECJp6oib1w',50,'style=\"border-style:none;\" alt=\"play.gif\"',1284523757,''),('zshreRgPAXtnF0DtVbQ1Yg',50,'style=\"border-style:none;\" alt=\"previous.gif\"',1284523757,''),('POVcY79vIqAHR8OfGt36aw',50,'style=\"border-style:none;\" alt=\"pagination_button.jpg\"',1284523757,''),('hIB-z34r8Xl-vYVYCkKr-w',50,'style=\"border-style:none;\" alt=\"bar-btn-r.jpg\"',1284523758,''),('-mPUoFlYcjqjPUPRLAlxNQ',50,'style=\"border-style:none;\" alt=\"search-field-r.jpg\"',1284523758,''),('MDpUOR-N8KMyt1J7Hh_h4w',50,'style=\"border-style:none;\" alt=\"bar-btn.jpg\"',1284523758,''),('YfXKByTwDZVituMc4h13Dg',50,'style=\"border-style:none;\" alt=\"pagination_bg.jpg\"',1284523758,''),('esko_HSU0Gh-uJZ1h3xRmQ',50,'style=\"border-style:none;\" alt=\"search-field-l.jpg\"',1284523758,''),('oSqpGswzpBG_ErdfYwIO8A',50,'style=\"border-style:none;\" alt=\"top_bg.jpg\"',1284523758,''),('MXJklShZvLLB_DSnZQmXrQ',50,'style=\"border-style:none;\" alt=\"title_bg.jpg\"',1284523758,''),('BthxD5oJ0idmsyI3ioA2FA',50,'style=\"border-style:none;\" alt=\"bar-btn-l.jpg\"',1284523758,''),('aZ-1HYQamkRHYXvzAra8WQ',50,'style=\"border-style:none;\" alt=\"search-field.jpg\"',1284523758,''),('eRkb94OYcS5AdcrrerOP5Q',50,'style=\"border-style:none;\" alt=\"rss.gif\"',1284523758,''),('TbnkjAJQEASORXIpYqDkcA',50,'style=\"border-style:none;\" alt=\"blank-image.jpg\"',1284523758,''),('er-3faBjY-hhlDcc5aKqdQ',50,'style=\"border-style:none;\" alt=\"top_bg.jpg\"',1284523758,''),('8bFsu2FJUqHRUiHcozcVFw',50,'style=\"border-style:none;\" alt=\"sub-btn-l.jpg\"',1284523758,''),('34Aayx5eA320D8VfhdfDBw',50,'style=\"border-style:none;\" alt=\"sub-btn-r.jpg\"',1284523758,''),('TlhKOVmWblZOsAdqmhEpeg',50,'style=\"border-style:none;\" alt=\"sub-btn.jpg\"',1284523758,''),('Nx0ypjO3cN6QdZUBUEE0lA',50,'style=\"border-style:none;\" alt=\"pic-title-bg.jpg\"',1284523758,''),('CmFZLN7iPS7XXvUEsxKPKA',50,'style=\"border-style:none;\" alt=\"row-2.jpg\"',1284523758,''),('v_XBgwwZqgW1D5s4y05qfg',50,'style=\"border-style:none;\" alt=\"addtl-info.gif\"',1284523759,''),('4TdAkKoQbSCvI7QWcW889A',50,'style=\"border-style:none;\" alt=\"row-1.jpg\"',1284523759,''),('SAgK6eDPCG1cgkJ59WapHQ',50,'style=\"border-style:none;\" alt=\"prev-btn.gif\"',1284523759,''),('XJYLuvGy9ubF7JNKyINtpA',50,'style=\"border-style:none;\" alt=\"play-btn.gif\"',1284523759,''),('RWj7hyv2SpZuXxwj1Wocug',50,'style=\"border-style:none;\" alt=\"next-btn.gif\"',1284523759,''),('aq8QElnlm3YufAoxRz9Pcg',50,'style=\"border-style:none;\" alt=\"data-bg.jpg\"',1284523759,''),('i6-BofrJJYozovlzFBByXg',50,'style=\"border-style:none;\"',1284523759,''),('fU_OZCmtdFNJ8a6bMve8ng',50,'style=\"border-style:none;\"',1284523759,''),('YXCtusAxb4vzZ5sTnUA5DA',50,'style=\"border-style:none;\"',1284523759,''),('k_xuE82wwp8gFVl9aaaG8g',50,'style=\"border-style:none;\"',1284523759,''),('NPM_WItpM5IzLWBhWjYfCA',50,'style=\"border-style:none;\"',1284523759,''),('2q5fxatSFLgIhXaUX-oSvg',50,'style=\"border-style:none;\" alt=\"bottom-left.jpg\"',1289360562,''),('_d5WTkKjnwct-_Dk7gZHvQ',50,'style=\"border-style:none;\" alt=\"bottom-right.jpg\"',1289360562,''),('Iz2mUR3jCPKyemwAea4b2g',50,'style=\"border-style:none;\" alt=\"input_bg.jpg\"',1289360562,''),('JU9bjsLRoWj7GVHs__prig',50,'style=\"border-style:none;\" alt=\"top-left.jpg\"',1289360562,''),('noOlnjQGexHg8c4bGVUo9g',50,'style=\"border-style:none;\" alt=\"top-right.jpg\"',1289360562,'');
ALTER TABLE `ImageAsset` ENABLE KEYS;
ALTER TABLE `Layout` DISABLE KEYS;
INSERT INTO `Layout` VALUES ('68sKwDgf9cGH58-NZcU4lg','PBtmpl0000000000000054','TKzUMeIxRLrZ3NAEez6CXQ,sWVXMZGibxHe2Ekj1DCldA',NULL,1271355027,'asc','PBtmpl0000000000000054'),('_iHetEvMQUOoxS-T2CM0sQ','PBtmpl0000000000000054','x_WjMvFmilhX-jvZuIpinw','Vzv1pWpg_w6R_o-b0rM2qQ',1273172789,'asc','PBtmpl0000000000000054'),('8Bb8gu-me2mhL3ljFyiWLg','PBtmpl0000000000000135','4Yfz9hqBqM8OYMGuQK8oLw,iCYOjohB9SKvAPr6bXElKA,Wl8WZ43g2rK5AYr9o4zY7w.ix1p0AbwKAz8QWB-T-HHfg,LBuiKzg2mWwmOPS9AgV3bg,jTNggl7AoVSUc_ZzrvuCmw',NULL,1271359194,'asc','PBtmpl0000000000000054'),('mTOiwwk3q4k9g5-XykXhPA','PBtmpl0000000000000054','j_1qEqM6iLfQLiR6VKy0aA,diZvW4bSgZWwyyGP3qXi1g,o_pq_e4vRyhMOKFzs61eag',NULL,1271349647,'asc','PBtmpl0000000000000054'),('2TqQc4OISddWCZmRY1_m8A','PBtmpl0000000000000109','l0guT3vTR3B8cL6vtP-g3A.k2Qj03FrAOXYra8kDJYYXw.nWxS5jnA3o3DgPEwBeR7yQ.ksSfkZdsr0uC62NwIk6hFQ',NULL,1271357565,'asc','PBtmpl0000000000000054'),('x3OFY6OJh_qsXkZfPwug4A','PBtmpl0000000000000054','pJd5TLAjfWMVXD6sCRLwUg',NULL,1271348790,'asc','PBtmpl0000000000000054');
ALTER TABLE `Layout` ENABLE KEYS;
ALTER TABLE `Navigation` DISABLE KEYS;
INSERT INTO `Navigation` VALUES ('PBnav00000000000000001','self\nancestors','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000093',55,1124395696,'text/html',0),('PBnav00000000000000014','pedigree','relativeToRoot','1',55,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000015','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000016','descendants','relativeToCurrentUrl','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000017','self\nsiblings','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000018','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000019','descendants','relativeToCurrentUrl','-1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000020','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000021','descendants','specificUrl','home',3,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000002','descendants','specificUrl','home',3,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000006','descendants','specificUrl','home',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000007','descendants','relativeToRoot','1',1,0,0,0,'PBnav00000000000bullet',55,1124395696,'text/html',0),('PBnav00000000000000008','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000108',55,1124395696,'text/html',0),('PBnav00000000000000009','descendants','relativeToRoot','0',1,0,0,0,'PBtmpl0000000000000124',55,1124395696,'text/html',0),('PBnav00000000000000010','descendants','relativeToRoot','1',1,0,0,0,'PBtmpl0000000000000117',55,1124395696,'text/html',0),('PBnav00000000000000011','self\ndescendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000130',55,1124395696,'text/html',0),('PBnav00000000000000012','descendants','relativeToRoot','1',55,0,0,0,'PBtmpl0000000000000134',55,1124395696,'text/html',0),('PBnav00000000000000013','self\ndescendants','relativeToCurrentUrl','0',55,0,0,0,'PBtmpl0000000000000136',55,1124395696,'text/html',0),('7-0-style0000000000025','descendants','relativeToRoot','1',1,0,0,0,'stevenav00000000000001',55,1147642498,'text/html',0),('7-0-style0000000000026','descendants','relativeToRoot','2',1,0,0,0,'PBnav000000style01lvl2',55,1147642499,'text/html',0),('7-0-style0000000000070','descendants','relativeToRoot','1',55,0,0,0,'stevecoolmenu000000001',55,1147642510,'text/html',0),('jVKLVakT_iA2010_oEuAwg','self\ndescendants','specificUrl','department',1,0,0,0,'stevecoolmenu000000001',55,1224116526,'text/html',0),('x_hiUi1XZloBvV47Obnu8Q','ancestors\nself','relativeToCurrentUrl','0',55,0,0,0,'hpCk0B3vQzgc-QJhSol41w',55,1273032718,'text/html',0),('n-Vr_wgxOkwiHGt1nJto9w','descendants','relativeToRoot','1',1,0,0,0,'39KNX53B4nYJAyIE1lu8ZQ',55,1273032720,'text/html',0),('jmqLxnoWb6p92Cr12lf1hw','self\npedigree','relativeToRoot','2',55,0,0,0,'ztfi__vHJLsQDsMenrEn-w',55,1273032720,'text/html',0),('h0bOzz7WvdaVZXsjpwtkww','pedigree','relativeToRoot','1',55,0,0,0,'_z3ukLCqvoaUygfsbbkBzw',55,1273032721,'text/html',0),('qFOfW1sKyOTnGNcP6BXbwg','ancestors\nself','relativeToCurrentUrl','0',55,0,0,0,'Pt38T5_MWSue2e1N36MLdw',55,1273032721,'text/html',0),('pJd5TLAjfWMVXD6sCRLwUg','descendants','specificUrl','root',55,0,0,0,'PBnav00000000000bullet',55,1271348790,'text/html',0),('Vch1Ww7G_JpBhOhXX07RDg','ancestors','relativeToCurrentUrl','0',55,0,1,0,'alraubvBu-YJJ614jAHD5w',1,1281501163,'text/html',0),('Am1J-meNBmhqFfEIWy6Gag','ancestors\ndescendants','relativeToRoot','1',2,0,0,0,'gaIOm5cr2TkT9Fk6QmZWug',55,1286941531,'text/html',0);
ALTER TABLE `Navigation` ENABLE KEYS;
ALTER TABLE `RichEdit` DISABLE KEYS;
INSERT INTO `RichEdit` VALUES ('PBrichedit000000000002',0,0,0,0,0,0,0,0,0,0,'ltr','bottom',NULL,'a[name|href|target|title],strong/b[class],em/i[class],strike[class],u[class],p[dir|class|align],ol,ul,li,br,img[class|src|border=0|alt|title|hspace|vspace|width|height|align],sub,sup,blockquote[dir|style],table[border=0|cellspacing|cellpadding|width|height|class|align],tr[class|rowspan|width|height|align|valign],td[dir|class|colspan|rowspan|width|height|align|valign],div[dir|class|align],span[class|align],pre[class|align],address[class|align],h1[dir|class|align],h2[dir|class|align],h3[dir|class|align],h4[dir|class|align],h5[dir|class|align],h6[dir|class|align],hr','bold\nitalic\nbullist\nnumlist\nlink\nunlink\nemotions',NULL,NULL,0,1124395696,0,0,NULL),('PBrichedit000000000001',0,0,0,0,600,500,0,0,0,0,'ltr','bottom',NULL,'strong/b[*],em/i[*],*[*]','bold\nitalic\njustifyleft\njustifycenter\njustifyright\njustifyfull\noutdent\nindent\nsub\nsup\nformatselect\nremoveformat','bullist\nnumlist\nlink\nwgpagetree\nanchor\nunlink\nadvhr\nimage\nwginsertimage\ncharmap\nwgmacro','replace\ntablecontrols\nvisualaid\ncode\ncleanup\npreview',1,1256092369,0,0,0);
ALTER TABLE `RichEdit` ENABLE KEYS;
ALTER TABLE `Survey_questionTypes` DISABLE KEYS;
INSERT INTO `Survey_questionTypes` VALUES ('Scale','[]'),('Gender','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Male\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Female\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Education','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Elementary or some high school\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"High school/GED\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Some college/vocational school\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"College graduate\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Some graduate work\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Master\'s degree\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Doctorate (of any type)\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":1,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Other degree (verbatim)\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Importance','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all important\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely important\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Yes/No','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Yes\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"No\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Confidence','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all confident\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely confident\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Effectiveness','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all effective\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely effective\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Oppose/Support','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly oppose\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly support\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Certainty','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all certain\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely certain\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('True/False','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"True\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"False\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Concern','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all concerned\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely concerned\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Ideology','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly liberal\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Liberal\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Somewhat liberal\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Middle of the road\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Slightly conservative\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Conservative\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly conservative\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Security','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all secure\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely secure\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Risk','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"No risk\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extreme risk\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Agree/Disagree','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly disagree\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Strongly agree\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Race','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"American Indian\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Asian\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Black\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Hispanic\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"White non-Hispanic\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":1,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Something else (verbatim)\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Threat','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"No threat\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extreme threat\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Party','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Democratic party\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Republican party (or GOP)\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Independent party\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":1,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Other party (verbatim)\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Likelihood','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all likely\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely likely\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]'),('Multiple Choice','[]'),('Satisfaction','[{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Not at all satisfied\",\"recordedAnswer\":0,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":1,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":2,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":3,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":4,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":5,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":6,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":7,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":8,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"\",\"recordedAnswer\":9,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1},{\"verbatim\":0,\"value\":1,\"min\":1,\"gotoExpression\":\"\",\"textCols\":10,\"max\":10,\"step\":1,\"terminal\":0,\"textRows\":5,\"text\":\"Extremely satisfied\",\"recordedAnswer\":10,\"type\":\"answer\",\"terminalUrl\":\"\",\"goto\":\"\",\"isCorrect\":1}]');
ALTER TABLE `Survey_questionTypes` ENABLE KEYS;
ALTER TABLE `SyndicatedContent` DISABLE KEYS;
INSERT INTO `SyndicatedContent` VALUES ('http://www.plainblack.com/news/news?func=viewRSS',3,'fK-HMSboA3uu0c1KYkYspA','GNvjCFQWjY2AF2uf0aCM8Q',1124395696,'',3600,0,'pubDate_des');
ALTER TABLE `SyndicatedContent` ENABLE KEYS;
ALTER TABLE `Workflow` DISABLE KEYS;
INSERT INTO `Workflow` VALUES ('pbworkflow000000000001','Daily Maintenance Tasks','This workflow runs daily maintenance tasks such as cleaning up old temporary files and cache.',1,'None','singleton'),('pbworkflow000000000002','Weekly Maintenance Tasks','This workflow runs once per week to perform maintenance tasks like cleaning up log files.',1,'None','singleton'),('pbworkflow000000000004','Hourly Maintenance Tasks','This workflow runs once per hour to perform maintenance tasks like deleting expired user sessions.',1,'None','singleton'),('pbworkflow000000000003','Commit Without Approval','This workflow commits all the assets in this version tag without asking for any approval.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000005','Commit With Approval','This workflow commits all the assets in this version tag after getting approval from content managers.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000006','Unlock Version Tag and Notify Owner','This workflow is used when a version tag approval is denied. It unlocks the version tag, making it available for editing, and notifies the tag owner.',1,'WebGUI::VersionTag','parallel'),('pbworkflow000000000007','Send Queued Email Messages','Sends all the messages in the mail queue.',1,'None','singleton'),('csworkflow000000000001','Get CS Mail','Retrieves mail from a POP3 account for the given Collaboration System.',1,'WebGUI::Asset::Wobject::Collaboration','singleton'),('AuthLDAPworkflow000001','Synchronize Profile To LDAP','Synchronizes a users LDAP information to their WebGUI User Profile',1,'WebGUI::User','singleton'),('DPWwf20061030000000002','Delete Exported Files','Deletes exported files from an asset being deleted or moved.',1,'None','parallel'),('PassiveAnalytics000001','Analyze Passive Analytics','Manual changes to this workflow will be lost.  Please only use the Passive Analytics screen to make changes',1,'None','singleton'),('send_webgui_statistics','Send WebGUI Stats','This workflow sends some information about your site to the central WebGUI statistics repository. No personal information is sent. The information is used to help determine the future direction WebGUI should take.',0,'None','singleton'),('taxeurecheckworkflow01','Recheck unverified EU VAT numbers','Utility workflow that automatically rechecks VAT numbers that could not be checked when they were submitted',1,'None','parallel');
ALTER TABLE `Workflow` ENABLE KEYS;
ALTER TABLE `WorkflowActivity` DISABLE KEYS;
INSERT INTO `WorkflowActivity` VALUES ('pbwfactivity0000000001','pbworkflow000000000001','Delete temp files older than 24 hours',NULL,1,'WebGUI::Workflow::Activity::CleanTempStorage'),('pbwfactivity0000000002','pbworkflow000000000001','Prune file cache larger than 100MB',NULL,3,'WebGUI::Workflow::Activity::CleanFileCache'),('pbwfactivity0000000022','pbworkflow000000000001','Prune database cache larger than 100MB',NULL,4,'WebGUI::Workflow::Activity::CleanDatabaseCache'),('pbwfactivity0000000005','pbworkflow000000000001','Archive old CS threads',NULL,5,'WebGUI::Workflow::Activity::ArchiveOldThreads'),('vtagactivity0000000002','pbworkflow000000000003','Wait Until','This workflow waits until the value chosen in the \"Wait Until\" field has passed and then continues',1,'WebGUI::Workflow::Activity::WaitUntil'),('pbwfactivity0000000007','pbworkflow000000000001','deal with user groupings that have expired',NULL,6,'WebGUI::Workflow::Activity::ExpireGroupings'),('pbwfactivity0000000011','pbworkflow000000000001','Expire old subscription codes',NULL,7,'WebGUI::Workflow::Activity::ExpireSubscriptionCodes'),('pbwfactivity0000000014','pbworkflow000000000001','Summarize Passive Profiling Data',NULL,8,'WebGUI::Workflow::Activity::SummarizePassiveProfileLog'),('pbwfactivity0000000015','pbworkflow000000000001','Sync User Profiles With LDAP',NULL,9,'WebGUI::Workflow::Activity::SyncProfilesToLdap'),('pbwfactivity0000000003','pbworkflow000000000002','Delete login entries older than 90 days',NULL,1,'WebGUI::Workflow::Activity::CleanLoginHistory'),('pbwfactivity0000000004','pbworkflow000000000002','Move clipboard items older than 30 days to trash',NULL,2,'WebGUI::Workflow::Activity::TrashClipboard'),('pbwfactivity0000000008','pbworkflow000000000002','delete asset revisions older than a year from the database',NULL,3,'WebGUI::Workflow::Activity::PurgeOldAssetRevisions'),('pbwfactivity0000000010','pbworkflow000000000002','delete assets from trash that have been sitting around for 30 days',NULL,4,'WebGUI::Workflow::Activity::PurgeOldTrash'),('pbwfactivity0000000009','pbworkflow000000000004','delete expired sessions',NULL,1,'WebGUI::Workflow::Activity::DeleteExpiredSessions'),('pbwfactivity0000000012','pbworkflow000000000004','Get syndicated content',NULL,2,'WebGUI::Workflow::Activity::GetSyndicatedContent'),('vtagactivity0000000001','pbworkflow000000000005','Wait Until','This workflow waits until the value chosen in the \"Wait Until\" field has passed and then continues',2,'WebGUI::Workflow::Activity::WaitUntil'),('pbwfactivity0000000017','pbworkflow000000000005','Get Approval from Content Managers',NULL,1,'WebGUI::Workflow::Activity::RequestApprovalForVersionTag'),('pbwfactivity0000000019','pbworkflow000000000006','Unlock Version Tag',NULL,1,'WebGUI::Workflow::Activity::UnlockVersionTag'),('pbwfactivity0000000020','pbworkflow000000000006','Notify Committer of Denial',NULL,2,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('pbwfactivity0000000021','pbworkflow000000000007','Send Queued Messages',NULL,1,'WebGUI::Workflow::Activity::SendQueuedMailMessages'),('csactivity000000000001','csworkflow000000000001','Get the mail',NULL,1,'WebGUI::Workflow::Activity::GetCsMail'),('Dl_3P-4y1OoOTf3cRwQ7EA','AuthLDAPworkflow000001','Synchronize Profile To LDAP',NULL,1,'WebGUI::Workflow::Activity::SyncProfileToLdap'),('DPWwfa2006103000000002','DPWwf20061030000000002','Delete Exported Files',NULL,1,'WebGUI::Workflow::Activity::DeleteExportedFiles'),('SWHs3shndnc8LuLpmLeeNw','pbworkflow000000000004','Update Calendar Feeds','This activity imports calendar events from calendar feeds',3,'WebGUI::Workflow::Activity::CalendarUpdateFeeds'),('pbwfactivity0000000006','pbworkflow000000000003','Commit Assets',NULL,2,'WebGUI::Workflow::Activity::CommitVersionTag'),('newslettersendactivity','pbworkflow000000000002','Send Newsletters For Newsletter Assets',NULL,5,'WebGUI::Workflow::Activity::SendNewsletters'),('unansweredfriends_____','pbworkflow000000000001','Deny Friend Requests Older Than A Month',NULL,10,'WebGUI::Workflow::Activity::DenyUnansweredFriends'),('pbwfactivity0000000016','pbworkflow000000000005','Commit Assets',NULL,3,'WebGUI::Workflow::Activity::CommitVersionTag'),('pbwfactivity0000000018','pbworkflow000000000005','Notify Committer of Approval',NULL,4,'WebGUI::Workflow::Activity::NotifyAboutVersionTag'),('4X02MxKDfvNwzyY4u_yEwQ','PassiveAnalytics000001','Perform duration analysis',NULL,1,'WebGUI::Workflow::Activity::SummarizePassiveAnalytics'),('zUZZLAyKNUl933pI4RspPg','PassiveAnalytics000001','Please log entries into buckets',NULL,2,'WebGUI::Workflow::Activity::BucketPassiveAnalytics'),('1BbO0rpY9-fGqlfpMDHang','pbworkflow000000000001','Remove old carts',NULL,11,'WebGUI::Workflow::Activity::RemoveOldCarts'),('C2v8fZHn-epffECKPWE87g','pbworkflow000000000004','Expire Purchased Thingy Records','Expire any expired thingy records. Send notifications of imminent expiration.',4,'WebGUI::Workflow::Activity::ExpirePurchasedThingyRecords'),('LT8Y9qSH4mOkgH7GVlj6ww','pbworkflow000000000001','Archive Old Stories','Archive old stories, based on the settings of the Story Archives that own them',12,'WebGUI::Workflow::Activity::ArchiveOldStories'),('send_webgui_statistics','send_webgui_statistics','Send WebGUI Stats',NULL,1,'WebGUI::Workflow::Activity::SendWebguiStats'),('ixOnGnjE6D1m71WzhSxcFQ','pbworkflow000000000001','Expire Incomplete Survey Responses','Expires incomplete Survey Responses according to per-instance Survey settings',13,'WebGUI::Workflow::Activity::ExpireIncompleteSurveyResponses'),('g6jJY1hPVgrUm5PKzrfZaQ','pbworkflow000000000001','Purge Denied EMS Submissions','Purges EMS Submissions that were denied and are aged according to parameters.',14,'WebGUI::Workflow::Activity::CleanupEMSSubmissions'),('w5DtU9T4SzFLwiXjP5hEbg','pbworkflow000000000004','Process Approves EMS Submissions','Create EMS Ticket Assets for approved submissions.',5,'WebGUI::Workflow::Activity::ProcessEMSApprovals'),('taxeurecheckactivity01','taxeurecheckworkflow01','Untitled',NULL,1,'WebGUI::Workflow::Activity::RecheckVATNumber'),('ZATo3t_rm09J74Cs_Xavyg','pbworkflow000000000002','Extend Calendar Recurrences','Create events for live recurrences up to two years from the current date',6,'WebGUI::Workflow::Activity::ExtendCalendarRecurrences');
ALTER TABLE `WorkflowActivity` ENABLE KEYS;
ALTER TABLE `WorkflowActivityData` DISABLE KEYS;
INSERT INTO `WorkflowActivityData` VALUES ('pbwfactivity0000000001','storageTimeout','86400'),('pbwfactivity0000000002','sizeLimit','100000000'),('pbwfactivity0000000022','sizeLimit','100000000'),('vtagactivity0000000002','type','startTime'),('pbwfactivity0000000003','ageToDelete','7776000'),('pbwfactivity0000000004','trashAfter','2592000'),('pbwfactivity0000000008','purgeAfter','31536000'),('pbwfactivity0000000010','purgeAfter','2592000'),('vtagactivity0000000001','type','startTime'),('pbwfactivity0000000017','message','A new version tag awaits your approval.'),('pbwfactivity0000000017','doOnDeny','pbworkflow000000000006'),('pbwfactivity0000000017','groupToApprove','4'),('pbwfactivity0000000020','message','Your version tag was denied. Please take corrective actions and recommit your changes.'),('pbwfactivity0000000020','who','committer'),('unansweredfriends_____','timeout','2592000'),('pbwfactivity0000000006','trashAfter','2592000'),('pbwfactivity0000000018','who','committer'),('pbwfactivity0000000018','message','Your version tag was approved.');
ALTER TABLE `WorkflowActivityData` ENABLE KEYS;
ALTER TABLE `WorkflowSchedule` DISABLE KEYS;
INSERT INTO `WorkflowSchedule` VALUES ('pbcron0000000000000001','Daily Maintenance',1,0,'30','23','*','*','*','pbworkflow000000000001',NULL,NULL,3,NULL),('pbcron0000000000000002','Weekly Maintenance',1,0,'30','1','*','*','0','pbworkflow000000000002',NULL,NULL,3,NULL),('pbcron0000000000000003','Hourly Maintenance',1,0,'15','*','*','*','*','pbworkflow000000000004',NULL,NULL,3,NULL),('pbcron0000000000000004','Send Queued Email Messages Every 5 Minutes',1,0,'*/5','*','*','*','*','pbworkflow000000000007',NULL,NULL,3,NULL),('NpRVTSR-NX2sD52LUc520A','Request Tracker Mail',0,0,'*/5','*','*','*','*','csworkflow000000000001','WebGUI::Asset::Wobject::Collaboration','new',2,'{\n    \"parameters\" : \"pbproto000000000000002\"\n}');
ALTER TABLE `WorkflowSchedule` ENABLE KEYS;
ALTER TABLE `asset` DISABLE KEYS;
INSERT INTO `asset` VALUES ('PBasset000000000000001','infinity','000001','published','WebGUI::Asset',1124395696,'3','997995720','3',NULL,1,NULL),('PBasset000000000000002','PBasset000000000000001','000001000001','published','WebGUI::Asset::Wobject::Folder',1124395696,'3','997995720','3',NULL,1,NULL),('68sKwDgf9cGH58-NZcU4lg','PBasset000000000000001','000001000002','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('iCYOjohB9SKvAPr6bXElKA','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000002','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('ix1p0AbwKAz8QWB-T-HHfg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000001','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('_iHetEvMQUOoxS-T2CM0sQ','68sKwDgf9cGH58-NZcU4lg','000001000002000001','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('8Bb8gu-me2mhL3ljFyiWLg','68sKwDgf9cGH58-NZcU4lg','000001000002000002','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('IWFxZDyGhQ3-SLZhELa3qw','68sKwDgf9cGH58-NZcU4lg','000001000002000007','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('bX5rYxb6tZ9docY6sUhBlw','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000001','published','WebGUI::Asset::Wobject::Article',1147642514,'3','997995720','3',NULL,0,NULL),('Vzv1pWpg_w6R_o-b0rM2qQ','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000002','published','WebGUI::Asset::File',1147642515,'3','997995720','3',NULL,0,NULL),('NK8bqlwVRILJknqeCDPBHg','_iHetEvMQUOoxS-T2CM0sQ','000001000002000001000003','published','WebGUI::Asset::Wobject::Article',1147642515,'3','997995720','3',NULL,0,NULL),('2TqQc4OISddWCZmRY1_m8A','68sKwDgf9cGH58-NZcU4lg','000001000002000004','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('fK-HMSboA3uu0c1KYkYspA','2TqQc4OISddWCZmRY1_m8A','000001000002000004000001','published','WebGUI::Asset::Wobject::SyndicatedContent',1124395696,'3','997995720','3',NULL,0,NULL),('x3OFY6OJh_qsXkZfPwug4A','68sKwDgf9cGH58-NZcU4lg','000001000002000005','published','WebGUI::Asset::Wobject::Layout',1124395696,'3','997995720','3',NULL,0,NULL),('pJd5TLAjfWMVXD6sCRLwUg','x3OFY6OJh_qsXkZfPwug4A','000001000002000005000001','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000003','7-0-style0000000000001','000001000001000051000002','published','WebGUI::Asset::Snippet',1147642492,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000001','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000008','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000014','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000009','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000015','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000010','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000016','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000011','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000017','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000012','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000018','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000013','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000019','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000014','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000020','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000015','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000021','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000016','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000002','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000017','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000006','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000018','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000007','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000019','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000008','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000020','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000009','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000021','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000010','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000022','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000011','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000023','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000012','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000024','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('PBnav00000000000000013','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000025','published','WebGUI::Asset::Wobject::Navigation',1124395696,'3','997995720','3',NULL,0,NULL),('Wl8WZ43g2rK5AYr9o4zY7w','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000004','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('4Yfz9hqBqM8OYMGuQK8oLw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000003','published','WebGUI::Asset::Wobject::Article',1147642516,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000005','7-0-style0000000000001','000001000001000051000004','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000006','7-0-style0000000000001','000001000001000051000005','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000103','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000002','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000115','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000066','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000080','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000097','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000112','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000121','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000067','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000026','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000128','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000008','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000079','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000009','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000083','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000010','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000082','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000011','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000056','TYo2Bwl7aafzTtdHlS-arQ','000001000001000028000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000135','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000131','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000054','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000024','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000088','tPagC0AQErZXjLFZQ6OI1g','000001000001000017000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000078','GYaFxnMu9UsEG8oanwB6TA','000001000001000014000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('-PkdI8l1idu-8gDX3iOdcw','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000007','published','WebGUI::Asset::Template',1247482172,'3','997995720','3',NULL,0,NULL),('VyCINX2KixKYr2pzQGX9Mg','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000006','published','WebGUI::Asset::Snippet',1246968584,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000109','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000094','aNNC62qLAS6TB-0_MCYjsw','000001000001000019000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000133','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000012','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000065','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000055','VZK3CRgiMb8r4dBjUmCTgQ','000001000001000027000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000020','-K8Hj45mbelljN9-0CXZxg','000001000001000010000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000085','-K8Hj45mbelljN9-0CXZxg','000001000001000010000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000104','-K8Hj45mbelljN9-0CXZxg','000001000001000010000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000021','-K8Hj45mbelljN9-0CXZxg','000001000001000010000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000033','N13SD1Fpqk00UgBt1Z8ivQ','000001000001000016000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000047','cj2y4papTVGZRFdwTI-_fw','000001000001000023000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000029','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000013','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000032','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000014','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000027','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000015','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000031','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000016','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('jTNggl7AoVSUc_ZzrvuCmw','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000006','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('LBuiKzg2mWwmOPS9AgV3bg','8Bb8gu-me2mhL3ljFyiWLg','000001000002000002000005','published','WebGUI::Asset::Wobject::Article',1147642517,'3','997995720','3',NULL,0,NULL),('GNvjCFQWjY2AF2uf0aCM8Q','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000068','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000017','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000099','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000018','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000114','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000019','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000092','V3l5S5TtI7wMm1WpIMhvOA','000001000001000021000009000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000044','V3l5S5TtI7wMm1WpIMhvOA','000001000001000021000009000002','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000059','bbiA9Zq5Gy2oCFBlILO3QA','000001000001000040000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('IZkrow_zwvbf4FCH-taVTQ','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000002','published','WebGUI::Asset::Wobject::Folder',1226011853,'3','997995720','3',NULL,0,NULL),('QHn6T9rU7KsnS3Y70KCNTg','PBasset000000000000002','000001000001000002','published','WebGUI::Asset::Wobject::Folder',1227080251,'3','997995720','3',NULL,0,NULL),('HPDOcsj4gBme8D4svHodBw','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000001','published','WebGUI::Asset::Wobject::Folder',1225404573,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000002','TCtybxdqmdwdvRn555zpCQ','000001000001000034000002','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000063','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000062','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000061','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000007','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000012','published','WebGUI::Asset::Template',1236594030,'3','1238119576','3',NULL,0,NULL),('PBtmpl0000000000000116','-K8Hj45mbelljN9-0CXZxg','000001000001000010000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000007','7-0-style0000000000001','000001000001000051000006','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000093','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000108','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000117','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000124','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000130','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000005','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000134','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000077','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000020','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000098','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000021','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000122','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000022','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000136','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000007','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000013','9M-lrlPQWeeNWfvnDnK_Xg','000001000001000005000007000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000010','K0q_N885Httqev1VCqUWxg','000001000001000005000004000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000011','fq1ZkYhH24R5tb96kuT10Q','000001000001000005000005000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000014','_gBYAdTcbkiyamnqi2Xskg','000001000001000005000008000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000012','oHk7fAFhEEkB7dHzi0QOQA','000001000001000005000006000001','published','WebGUI::Asset::Template',1124395696,'3','1222803164','3',NULL,0,NULL),('PBtmpl0000000000000006','taX2UYkFF21ALpFZY2rhMw','000001000001000005000003000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000004','xSmREZO3GNzK3M5PaueOOQ','000001000001000005000001000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000005','0bx-xoL8TSXXubFuqKAoVQ','000001000001000005000002000001','published','WebGUI::Asset::Template',1124395696,'3','1222803163','3',NULL,0,NULL),('PBtmpl0000000000000057','Ik9HHky10DIyFTKehUD1dw','000001000001000032000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000060','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('pbrobot000000000000001','PBasset000000000000002','000001000001000035','published','WebGUI::Asset::Snippet',1147642511,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000111','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000002','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000137','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000003','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000132','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000123','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000004','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000081','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000023','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000101','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000024','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000065','7-0-style0000000000049','000001000001000053000016','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('OhdaFLE7sXOzo_SIP2ZUgA','68sKwDgf9cGH58-NZcU4lg','000001000002000006','published','WebGUI::Asset::Wobject::Article',1147642513,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000113','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000025','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000037','GdkQpvjRtJqtzOUbwIIQRA','000001000001000021000002000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000038','tnc5iYyynX2hfdEs9D3P8w','000001000001000021000003000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000036','tBL7BWiQRZFed2Y-Zjo9tQ','000001000001000021000001000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000039','vgXdBcFTqU7h4wBG1ewdBw','000001000001000021000004000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000091','vgXdBcFTqU7h4wBG1ewdBw','000001000001000021000004000002','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000107','vgXdBcFTqU7h4wBG1ewdBw','000001000001000021000004000003','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000040','hcFlqnXlsmC1ujN6Id0F0A','000001000001000021000005000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000041','eRJR52fvlaxfetv3DQkQYw','000001000001000021000006000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000042','5HIDHq5lAWHV5gpYGS0zLg','000001000001000021000007000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000045','y8XkRdxIperLKkJ3bL5sSQ','000001000001000021000011000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('PBtmpl0000000000000043','rYEFwXXo0tkGhQTcbDibvg','000001000001000021000008000001','published','WebGUI::Asset::Template',1124395696,'3','1222803175','3',NULL,0,NULL),('7-0-style0000000000064','7-0-style0000000000049','000001000001000053000015','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBrichedit000000000001','TCtybxdqmdwdvRn555zpCQ','000001000001000034000001','published','WebGUI::Asset::RichEdit',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000053','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000017','published','WebGUI::Asset::Template',1124395696,'3','1222802960','3',NULL,0,NULL),('PBtmpl0000000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000003000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000140','Da6KWn805L4B5e4HFgQRQA','000001000001000039000001','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000141','-K8Hj45mbelljN9-0CXZxg','000001000001000010000006','published','WebGUI::Asset::Template',1124395696,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000066','7-0-style0000000000049','000001000001000053000017','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000062','7-0-style0000000000049','000001000001000053000013','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000060','7-0-style0000000000049','000001000001000053000011','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000061','7-0-style0000000000049','000001000001000053000012','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000057','7-0-style0000000000049','000001000001000053000008','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000058','7-0-style0000000000049','000001000001000053000009','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000059','7-0-style0000000000049','000001000001000053000010','published','WebGUI::Asset::File::Image',1147642507,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000056','7-0-style0000000000049','000001000001000053000007','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000052','7-0-style0000000000049','000001000001000053000003','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000053','7-0-style0000000000049','000001000001000053000004','published','WebGUI::Asset::File::Image',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000054','7-0-style0000000000049','000001000001000053000005','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000055','7-0-style0000000000049','000001000001000053000006','published','WebGUI::Asset::File::Image',1147642506,'3','997995720','3',NULL,0,NULL),('stevecoolmenu000000001','7-0-style0000000000049','000001000001000053000001','published','WebGUI::Asset::Template',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000051','7-0-style0000000000049','000001000001000053000002','published','WebGUI::Asset::Snippet',1147642505,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000049','PBasset000000000000002','000001000001000053','published','WebGUI::Asset::Wobject::Folder',1147642504,'3','997995720','3',NULL,0,NULL),('stevestyle000000000002','7-0-style0000000000031','000001000001000052000016','published','WebGUI::Asset::Template',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000048','7-0-style0000000000031','000001000001000052000017','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000046','7-0-style0000000000031','000001000001000052000015','published','WebGUI::Asset::File::Image',1147642504,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000044','7-0-style0000000000031','000001000001000052000013','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000045','7-0-style0000000000031','000001000001000052000014','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000043','7-0-style0000000000031','000001000001000052000012','published','WebGUI::Asset::File::Image',1147642503,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000041','7-0-style0000000000031','000001000001000052000010','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000042','7-0-style0000000000031','000001000001000052000011','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000038','7-0-style0000000000031','000001000001000052000007','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000039','7-0-style0000000000031','000001000001000052000008','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000040','7-0-style0000000000031','000001000001000052000009','published','WebGUI::Asset::File::Image',1147642502,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000036','7-0-style0000000000031','000001000001000052000005','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000037','7-0-style0000000000031','000001000001000052000006','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000034','7-0-style0000000000031','000001000001000052000003','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000035','7-0-style0000000000031','000001000001000052000004','published','WebGUI::Asset::File::Image',1147642501,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000032','7-0-style0000000000031','000001000001000052000001','published','WebGUI::Asset::File::Image',1147642500,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000033','7-0-style0000000000031','000001000001000052000002','published','WebGUI::Asset::Snippet',1147642500,'3','997995720','3',NULL,0,NULL),('PBnav000000style01lvl2','7-0-style0000000000001','000001000001000051000028','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000030','7-0-style0000000000001','000001000001000051000029','published','WebGUI::Asset::File::Image',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000031','PBasset000000000000002','000001000001000052','published','WebGUI::Asset::Wobject::Folder',1147642500,'3','997995720','3',NULL,0,NULL),('stevenav00000000000001','7-0-style0000000000001','000001000001000051000027','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000025','7-0-style0000000000001','000001000001000051000024','published','WebGUI::Asset::Wobject::Navigation',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000026','7-0-style0000000000001','000001000001000051000025','published','WebGUI::Asset::Wobject::Navigation',1147642499,'3','997995720','3',NULL,0,NULL),('stevestyle000000000001','7-0-style0000000000001','000001000001000051000026','published','WebGUI::Asset::Template',1147642499,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000023','7-0-style0000000000001','000001000001000051000022','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000024','7-0-style0000000000001','000001000001000051000023','published','WebGUI::Asset::File::Image',1147642498,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000022','7-0-style0000000000001','000001000001000051000021','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000021','7-0-style0000000000001','000001000001000051000020','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000018','7-0-style0000000000001','000001000001000051000017','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000019','7-0-style0000000000001','000001000001000051000018','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000020','7-0-style0000000000001','000001000001000051000019','published','WebGUI::Asset::File::Image',1147642497,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000017','7-0-style0000000000001','000001000001000051000016','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000016','7-0-style0000000000001','000001000001000051000015','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000015','7-0-style0000000000001','000001000001000051000014','published','WebGUI::Asset::File::Image',1147642496,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000014','7-0-style0000000000001','000001000001000051000013','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000012','7-0-style0000000000001','000001000001000051000011','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000013','7-0-style0000000000001','000001000001000051000012','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000010','7-0-style0000000000001','000001000001000051000009','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000011','7-0-style0000000000001','000001000001000051000010','published','WebGUI::Asset::File::Image',1147642495,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000009','7-0-style0000000000001','000001000001000051000008','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000008','7-0-style0000000000001','000001000001000051000007','published','WebGUI::Asset::File::Image',1147642494,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000067','7-0-style0000000000049','000001000001000053000018','published','WebGUI::Asset::File::Image',1147642509,'3','997995720','3',NULL,0,NULL),('PBtmplHelp000000000001','nbSrhXZQuxIjhWFaFPSuVA','000001000001000003000002','published','WebGUI::Asset::Template',1124395706,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000001','PBasset000000000000002','000001000001000051','published','WebGUI::Asset::Wobject::Folder',1147642492,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000001','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000003','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000002','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000004','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000003','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000005','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('SynConXSLT000000000004','oGfxez5sksyB_PcaAsEm_Q','000001000001000045000006','published','WebGUI::Asset::Snippet',1124395707,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000063','7-0-style0000000000049','000001000001000053000014','published','WebGUI::Asset::File::Image',1147642508,'3','997995720','3',NULL,0,NULL),('stevestyle000000000003','7-0-style0000000000049','000001000001000053000020','published','WebGUI::Asset::Template',1147642510,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000002','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000001','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000001','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000002','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000003','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000003','published','WebGUI::Asset::Template',1133743238,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000004','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000004','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('matrixtmpl000000000005','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000005','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000004','7-0-style0000000000001','000001000001000051000003','published','WebGUI::Asset::File::Image',1147642493,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000002','3uuBf8cYuj1sew2OJXl9tg','000001000001000018000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('IOB0000000000000000001','3uuBf8cYuj1sew2OJXl9tg','000001000001000018000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('PBtmplBlankStyle000001','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000005','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('DashboardViewTmpl00001','S1A9iAwKcQQ6P20uTqw-Ew','000001000001000009000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('WeatherDataTmpl0000001','9wKWdum0_8z-OhhquWLtSQ','000001000001000050000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000002','Efe2W0UgrSRDltNJ87jlfg','000001000001000041000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('StockDataTMPL000000001','Efe2W0UgrSRDltNJ87jlfg','000001000001000041000002','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('MultiSearchTmpl0000001','bBzO4CWjqU_ile3gf5Iypw','000001000001000024000001','published','WebGUI::Asset::Template',1133743239,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000068','7-0-style0000000000049','000001000001000053000019','published','WebGUI::Asset::File::Image',1147642510,'3','997995720','3',NULL,0,NULL),('ZipArchiveTMPL00000001','CSN-ZON7Uwv8kxf3F1fh5Q','000001000001000055000001','published','WebGUI::Asset::Template',1133743240,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000002','7-0-style0000000000001','000001000001000051000001','published','WebGUI::Asset::File::Image',1147642492,'3','997995720','3',NULL,0,NULL),('WVtmpl0000000000000001','nqNbSUAhk9Vd1zda2SCz9A','000001000001000021000010000001','published','WebGUI::Asset::Template',1133743240,'3','1222803175','3',NULL,0,NULL),('2CS-BErrjMmESOtGT90qOg','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000003','published','WebGUI::Asset::Template',1227070888,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000208','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000026','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000209','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000027','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000210','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000028','published','WebGUI::Asset::Template',1147642410,'3','997995720','3',NULL,0,NULL),('ProjectManagerTMPL0004','yD1SMHelczihzjEmx6eXBA','000001000001000031000002000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0003','pV7GnZdpjR3XpZaSINIoeg','000001000001000031000003000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0002','71e17KeduiXgODLMlUxiow','000001000001000031000004000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('ProjectManagerTMPL0001','9A-mg2gwWmaYi9o_1C7ArQ','000001000001000031000001000001','published','WebGUI::Asset::Template',1147642415,'3','1222803147','3',NULL,0,NULL),('TimeTrackingTMPL000002','vTymIDYL2YqEh6PV50F7ew','000001000001000048000001000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('TimeTrackingTMPL000003','lo1ac3BsoJx3ijGQ3gR-bQ','000001000001000048000002000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('TimeTrackingTMPL000001','huASapWvFDzqwOSbcN-JFQ','000001000001000048000003000001','published','WebGUI::Asset::Template',1147642417,'3','1222803153','3',NULL,0,NULL),('PBtmpl0000000000000200','f_tn9FfoSfKWX43F83v_3w','000001000001000036000001','published','WebGUI::Asset::Template',1147642427,'3','997995720','3',NULL,0,NULL),('PBasset000000000000003','PBasset000000000000001','000001000003','published','WebGUI::Asset::Wobject::Folder',1147642437,'3','997995720','3',NULL,1,NULL),('pbproto000000000000002','PBasset000000000000002','000001000001000033','published','WebGUI::Asset::Wobject::Collaboration',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000220','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000002','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('pbtmpl0000000000000221','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000003','published','WebGUI::Asset::Template',1147642465,'3','997995720','3',NULL,0,NULL),('nbSrhXZQuxIjhWFaFPSuVA','PBasset000000000000002','000001000001000003','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('TvOZs8U1kRXLtwtmyW75pg','PBasset000000000000002','000001000001000004','published','WebGUI::Asset::Wobject::Folder',1147642465,'3','997995720','3',NULL,0,NULL),('xSmREZO3GNzK3M5PaueOOQ','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000001','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('0bx-xoL8TSXXubFuqKAoVQ','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000002','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('taX2UYkFF21ALpFZY2rhMw','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000003','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803163','3',NULL,0,NULL),('K0q_N885Httqev1VCqUWxg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000004','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('fq1ZkYhH24R5tb96kuT10Q','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000005','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('oHk7fAFhEEkB7dHzi0QOQA','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000006','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('9M-lrlPQWeeNWfvnDnK_Xg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000007','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('_gBYAdTcbkiyamnqi2Xskg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000008','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','1222803164','3',NULL,0,NULL),('GNOAsX98vCsl0JRwfwL-gg','PBasset000000000000002','000001000001000008','published','WebGUI::Asset::Wobject::Folder',1147642466,'3','997995720','3',NULL,0,NULL),('S1A9iAwKcQQ6P20uTqw-Ew','PBasset000000000000002','000001000001000009','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('-K8Hj45mbelljN9-0CXZxg','PBasset000000000000002','000001000001000010','published','WebGUI::Asset::Wobject::Folder',1147642468,'3','997995720','3',NULL,0,NULL),('tXwf1zaOXTvsqPn6yu-GSw','PBasset000000000000002','000001000001000013','published','WebGUI::Asset::Wobject::Folder',1147642469,'3','997995720','3',NULL,0,NULL),('GYaFxnMu9UsEG8oanwB6TA','PBasset000000000000002','000001000001000014','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('N13SD1Fpqk00UgBt1Z8ivQ','PBasset000000000000002','000001000001000016','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('tPagC0AQErZXjLFZQ6OI1g','PBasset000000000000002','000001000001000017','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('default_post_received1','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000029','published','WebGUI::Asset::Template',1222708029,'3','1222803001','3',NULL,0,NULL),('3uuBf8cYuj1sew2OJXl9tg','PBasset000000000000002','000001000001000018','published','WebGUI::Asset::Wobject::Folder',1147642470,'3','997995720','3',NULL,0,NULL),('aNNC62qLAS6TB-0_MCYjsw','PBasset000000000000002','000001000001000019','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','997995720','3',NULL,0,NULL),('tBL7BWiQRZFed2Y-Zjo9tQ','zyWi26q9na-iiZqL4yedog','000001000001000021000001','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','1222803175','3',NULL,0,NULL),('GdkQpvjRtJqtzOUbwIIQRA','zyWi26q9na-iiZqL4yedog','000001000001000021000002','published','WebGUI::Asset::Wobject::Folder',1147642471,'3','1222803175','3',NULL,0,NULL),('tnc5iYyynX2hfdEs9D3P8w','zyWi26q9na-iiZqL4yedog','000001000001000021000003','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','1222803175','3',NULL,0,NULL),('vgXdBcFTqU7h4wBG1ewdBw','zyWi26q9na-iiZqL4yedog','000001000001000021000004','published','WebGUI::Asset::Wobject::Folder',1147642472,'3','1222803175','3',NULL,0,NULL),('hcFlqnXlsmC1ujN6Id0F0A','zyWi26q9na-iiZqL4yedog','000001000001000021000005','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('eRJR52fvlaxfetv3DQkQYw','zyWi26q9na-iiZqL4yedog','000001000001000021000006','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('5HIDHq5lAWHV5gpYGS0zLg','zyWi26q9na-iiZqL4yedog','000001000001000021000007','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('rYEFwXXo0tkGhQTcbDibvg','zyWi26q9na-iiZqL4yedog','000001000001000021000008','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('V3l5S5TtI7wMm1WpIMhvOA','zyWi26q9na-iiZqL4yedog','000001000001000021000009','published','WebGUI::Asset::Wobject::Folder',1147642473,'3','1222803175','3',NULL,0,NULL),('nqNbSUAhk9Vd1zda2SCz9A','zyWi26q9na-iiZqL4yedog','000001000001000021000010','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','1222803175','3',NULL,0,NULL),('y8XkRdxIperLKkJ3bL5sSQ','zyWi26q9na-iiZqL4yedog','000001000001000021000011','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','1222803175','3',NULL,0,NULL),('LdiozcIUciWuvt3Z-na5Ww','PBasset000000000000002','000001000001000022','published','WebGUI::Asset::Wobject::Folder',1147642474,'3','997995720','3',NULL,0,NULL),('cj2y4papTVGZRFdwTI-_fw','PBasset000000000000002','000001000001000023','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('bBzO4CWjqU_ile3gf5Iypw','PBasset000000000000002','000001000001000024','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('BFfNj5wA9bDw8H3cnr8pTw','PBasset000000000000002','000001000001000025','published','WebGUI::Asset::Wobject::Folder',1147642475,'3','997995720','3',NULL,0,NULL),('AgyFhx3eXlfZXNp2MkrsiQ','NywJYmGWe1f6EBXJnWg9Xg','000001000001000030000001','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222803652','3',NULL,0,NULL),('F7MAQ-cpuvQ1KuC7J4P5zQ','NywJYmGWe1f6EBXJnWg9Xg','000001000001000030000002','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222803653','3',NULL,0,NULL),('jEz8iTGNWEt2I05IhVV19Q','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000016','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','1222802937','3',NULL,0,NULL),('VZK3CRgiMb8r4dBjUmCTgQ','PBasset000000000000002','000001000001000027','published','WebGUI::Asset::Wobject::Folder',1147642477,'3','997995720','3',NULL,0,NULL),('TYo2Bwl7aafzTtdHlS-arQ','PBasset000000000000002','000001000001000028','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','997995720','3',NULL,0,NULL),('9A-mg2gwWmaYi9o_1C7ArQ','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000001','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('yD1SMHelczihzjEmx6eXBA','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000002','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('pV7GnZdpjR3XpZaSINIoeg','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000003','published','WebGUI::Asset::Wobject::Folder',1147642478,'3','1222803147','3',NULL,0,NULL),('71e17KeduiXgODLMlUxiow','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000004','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','1222803147','3',NULL,0,NULL),('Ik9HHky10DIyFTKehUD1dw','PBasset000000000000002','000001000001000032','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('f_tn9FfoSfKWX43F83v_3w','PBasset000000000000002','000001000001000036','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('Da6KWn805L4B5e4HFgQRQA','PBasset000000000000002','000001000001000039','published','WebGUI::Asset::Wobject::Folder',1147642479,'3','997995720','3',NULL,0,NULL),('bbiA9Zq5Gy2oCFBlILO3QA','PBasset000000000000002','000001000001000040','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('Efe2W0UgrSRDltNJ87jlfg','PBasset000000000000002','000001000001000041','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('RrV4aAPnn4dM0ZcU3OXnlw','PBasset000000000000002','000001000001000043','published','WebGUI::Asset::Wobject::Folder',1147642480,'3','997995720','3',NULL,0,NULL),('5bnNzteN7w3NnK9mF4XiCg','PBasset000000000000002','000001000001000044','published','WebGUI::Asset::Wobject::Folder',1147642481,'3','997995720','3',NULL,0,NULL),('oGfxez5sksyB_PcaAsEm_Q','PBasset000000000000002','000001000001000045','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','997995720','3',NULL,0,NULL),('vTymIDYL2YqEh6PV50F7ew','2OcUWHVsu_L1sDFzIMWYqw','000001000001000048000001','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','1222803153','3',NULL,0,NULL),('lo1ac3BsoJx3ijGQ3gR-bQ','2OcUWHVsu_L1sDFzIMWYqw','000001000001000048000002','published','WebGUI::Asset::Wobject::Folder',1147642482,'3','1222803153','3',NULL,0,NULL),('huASapWvFDzqwOSbcN-JFQ','2OcUWHVsu_L1sDFzIMWYqw','000001000001000048000003','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','1222803153','3',NULL,0,NULL),('9wKWdum0_8z-OhhquWLtSQ','PBasset000000000000002','000001000001000050','published','WebGUI::Asset::Wobject::Folder',1147642483,'3','997995720','3',NULL,0,NULL),('CSN-ZON7Uwv8kxf3F1fh5Q','PBasset000000000000002','000001000001000055','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('TCtybxdqmdwdvRn555zpCQ','PBasset000000000000002','000001000001000034','published','WebGUI::Asset::Wobject::Folder',1147642484,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000070','7-0-style0000000000049','000001000001000053000021','published','WebGUI::Asset::Wobject::Navigation',1147642510,'3','997995720','3',NULL,0,NULL),('7-0-style0000000000071','7-0-style0000000000049','000001000001000053000022','published','WebGUI::Asset::File::Image',1147642511,'3','997995720','3',NULL,0,NULL),('PBnav00000000000bullet','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000026','published','WebGUI::Asset::Template',1148579524,'3','1222803972','3',NULL,0,NULL),('PBnav00000000indentnav','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000027','published','WebGUI::Asset::Template',1148579525,'3','1222803972','3',NULL,0,NULL),('MK4fCNoyrx5SE8eyDfOpxg','tXwf1zaOXTvsqPn6yu-GSw','000001000001000013000004','published','WebGUI::Asset::Template',1247489252,'3','997995720','3',NULL,0,NULL),('uCn31PzislTZlgt_79j7cQ','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000006','published','WebGUI::Asset::Snippet',1258524916,'3','997995720','3',NULL,0,NULL),('i5kt5aodVs_oepNEkE7Okw','VZK3CRgiMb8r4dBjUmCTgQ','000001000001000027000002','published','WebGUI::Asset::Snippet',1242312883,'3','997995720','3',NULL,0,NULL),('zb_OPKNqcTuIjdvvbEkRjw','TvOZs8U1kRXLtwtmyW75pg','000001000001000004000005','published','WebGUI::Asset::Snippet',1247484073,'3','997995720','3',NULL,0,NULL),('FEDP3dk8J3Chw_gyr7_XEQ','BFfNj5wA9bDw8H3cnr8pTw','000001000001000025000028','published','WebGUI::Asset::Snippet',1246278679,'3','997995720','3',NULL,0,NULL),('BmLaN4rmAANkCglXUViEbg','-WM2dt0ZGpDasuL2wWocxg','000001000001000031000005','published','WebGUI::Asset::Wobject::Folder',1157679165,'3','1222803845','3',NULL,0,NULL),('ProjectManagerTMPL0006','BmLaN4rmAANkCglXUViEbg','000001000001000031000005000001','published','WebGUI::Asset::Template',1157679165,'3','1222803845','3',NULL,0,NULL),('ProjectManagerTMPL0005','BmLaN4rmAANkCglXUViEbg','000001000001000031000005000002','published','WebGUI::Asset::Template',1157679165,'3','1222803845','3',NULL,0,NULL),('Q4uX_C557arTp6D_jwB1jQ','PBasset000000000000002','000001000001000054','published','WebGUI::Asset::Wobject::Folder',1165460175,'3','997995720','3',NULL,0,NULL),('WikiRCTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000001','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiFrontTmpl000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000002','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiSearchTmpl00000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000003','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPHTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000004','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPageTmpl0000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000005','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiPageEditTmpl000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000006','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('WikiMPTmpl000000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000007','published','WebGUI::Asset::Template',1165460175,'3','1222803570','3',NULL,0,NULL),('SQLReportDownload00001','bbiA9Zq5Gy2oCFBlILO3QA','000001000001000040000002','published','WebGUI::Asset::Template',1171466654,'3','1222803962','3',NULL,0,NULL),('X7DrzUcj8pOKFa_6k9D5iw','PBasset000000000000002','000001000001000026','published','WebGUI::Asset::Wobject::Folder',1185754569,'3','997995720','3',NULL,0,NULL),('newsletter000000000001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000026000001','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('newslettercs0000000001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000026000002','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('newslettersubscrip0001','X7DrzUcj8pOKFa_6k9D5iw','000001000001000026000003','published','WebGUI::Asset::Template',1185754569,'3','1222803570','3',NULL,0,NULL),('MBmWlA_YEA2I6D29OMGtRg','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000004','published','WebGUI::Asset::Template',1226542675,'3','997995720','3',NULL,0,NULL),('FJbUTvZ2nUTn65LpW6gjsA','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000001','published','WebGUI::Asset::Template',1227070381,'3','997995720','3',NULL,0,NULL),('WikiKeyword00000000001','Q4uX_C557arTp6D_jwB1jQ','000001000001000054000008','published','WebGUI::Asset::Template',1185754571,'3','1222803956','3',NULL,0,NULL),('tempspace0000000000000','PBasset000000000000001','000001000004','published','WebGUI::Asset::Wobject::Folder',1185754574,'3','997995720','3',NULL,1,NULL),('75CmQgpcCSkdsL-oawdn3Q','HPDOcsj4gBme8D4svHodBw','000001000001000002000001000002','published','WebGUI::Asset::Template',1227052575,'3','997995720','3',NULL,0,NULL),('gI_TxK-5S4DNuv42wpImmw','PBasset000000000000002','000001000001000015','published','WebGUI::Asset::Wobject::Folder',1197330678,'3','997995720','3',NULL,0,NULL),('jME5BEDYVDlBZ8jIQA9-jQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000001','published','WebGUI::Asset::Template',1197927169,'3','997995720','3',NULL,0,NULL),('azCqD0IjdQSlM3ar29k5Sg','gI_TxK-5S4DNuv42wpImmw','000001000001000015000002','published','WebGUI::Asset::Template',1197881748,'3','997995720','3',NULL,0,NULL),('05FpjceLYhq4csF1Kww1KQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000003','published','WebGUI::Asset::Template',1197879361,'3','997995720','3',NULL,0,NULL),('q5O62aH4pjUXsrQR3Pq4lw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000004','published','WebGUI::Asset::Template',1197825772,'3','997995720','3',NULL,0,NULL),('KAMdiUdJykjN02CPHpyZOw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000005','published','WebGUI::Asset::Template',1197825787,'3','997995720','3',NULL,0,NULL),('OkphOEdaSGTXnFGhK4GT5A','gI_TxK-5S4DNuv42wpImmw','000001000001000015000006','published','WebGUI::Asset::Template',1197825794,'3','997995720','3',NULL,0,NULL),('TEId5V-jEvUULsZA0wuRuA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000007','published','WebGUI::Asset::Template',1197989443,'3','997995720','3',NULL,0,NULL),('6X-7Twabn5KKO_AbgK3PEw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000008','published','WebGUI::Asset::Template',1197987780,'3','997995720','3',NULL,0,NULL),('7JCTAiu1U_bT9ldr655Blw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000009','published','WebGUI::Asset::Template',1197825824,'3','997995720','3',NULL,0,NULL),('0X4Q3tBWUb_thsVbsYz9xQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000010','published','WebGUI::Asset::Template',1197987372,'3','997995720','3',NULL,0,NULL),('m3IbBavqzuKDd2PGGhKPlA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000011','published','WebGUI::Asset::Template',1197825845,'3','997995720','3',NULL,0,NULL),('UTNFeV7B_aSCRmmaFCq4Vw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000012','published','WebGUI::Asset::Template',1197825856,'3','997995720','3',NULL,0,NULL),('zcX-wIUct0S_np14xxOA-A','gI_TxK-5S4DNuv42wpImmw','000001000001000015000013','published','WebGUI::Asset::Template',1197825866,'3','997995720','3',NULL,0,NULL),('MBZK_LPVzqhb4TV4mMRTJg','gI_TxK-5S4DNuv42wpImmw','000001000001000015000014','published','WebGUI::Asset::Snippet',1197330678,'3','997995720','3',NULL,0,NULL),('_hELmIJfgbAyXFNqPyApxQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000015','published','WebGUI::Asset::Snippet',1197330678,'3','997995720','3',NULL,0,NULL),('_9_eiaPgxzF_x_upt6-PNQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000016','published','WebGUI::Asset::Snippet',1197988920,'3','997995720','3',NULL,0,NULL),('kaPRSaf8UKiskiGEgJgLAw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000017','published','WebGUI::Asset::Wobject::Folder',1197330678,'3','997995720','3',NULL,0,NULL),('bANo8aiAPA7aY_oQZKxIWw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000001','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('2ci_v2d4x4uvyjTRlC49OA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000002','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('O-EsSzKgAk1KolFT-x_KsA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000003','published','WebGUI::Asset::File::Image',1197330678,'3','997995720','3',NULL,0,NULL),('fdd8tGExyVwHyrB8RBbKXg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000004','published','WebGUI::Asset::File::Image',1197330839,'3','997995720','3',NULL,0,NULL),('BpisgHl4ZDcSECJp6oib1w','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000005','published','WebGUI::Asset::File::Image',1197330840,'3','997995720','3',NULL,0,NULL),('zshreRgPAXtnF0DtVbQ1Yg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000006','published','WebGUI::Asset::File::Image',1197330840,'3','997995720','3',NULL,0,NULL),('mM3bjP_iG9sv5nQb4S17tQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000018','published','WebGUI::Asset::Template',1197879662,'3','997995720','3',NULL,0,NULL),('ilu5BrM-VGaOsec9Lm7M6Q','gI_TxK-5S4DNuv42wpImmw','000001000001000015000019','published','WebGUI::Asset::Template',1197878780,'3','997995720','3',NULL,0,NULL),('-ANLpoTEP-n4POAdRxCzRw','gI_TxK-5S4DNuv42wpImmw','000001000001000015000020','published','WebGUI::Asset::Template',1197880641,'3','997995720','3',NULL,0,NULL),('OxJWQgnGsgyGohP2L3zJPQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000021','published','WebGUI::Asset::Template',1204663962,'3','997995720','3',NULL,0,NULL),('Tsg7xmPYv782j6IVz7yHFg','PBasset000000000000002','000001000001000006','published','WebGUI::Asset::Wobject::Folder',1204890713,'3','997995720','3',NULL,0,NULL),('kj3b-X3i6zRKnhLb4ZiCLw','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000001','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('uRL9qtk7Rb0YRJ41LmHOJw','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000002','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarWeek0000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000003','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarDay00000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000004','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarEvent000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000005','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarEventEdit00001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000006','published','WebGUI::Asset::Template',1205160982,'3','997995720','3',NULL,0,NULL),('CalendarMonth000000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000007','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarSearch00000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000008','published','WebGUI::Asset::Template',1204890713,'3','997995720','3',NULL,0,NULL),('CalendarPrintEvent0001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000009','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintMonth0001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000010','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintWeek00001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000011','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('CalendarPrintDay000001','Tsg7xmPYv782j6IVz7yHFg','000001000001000006000012','published','WebGUI::Asset::Template',1204890714,'3','997995720','3',NULL,0,NULL),('jnYdqDkUR8x7Pv2eGR1qTA','PBasset000000000000002','000001000001000046','published','WebGUI::Asset::Wobject::Folder',1205431513,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000001','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000001','published','WebGUI::Asset::Template',1205003608,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000002','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000002','published','WebGUI::Asset::Template',1205003676,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000003','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000003','published','WebGUI::Asset::Template',1205003711,'3','997995720','3',NULL,0,NULL),('ThingyTmpl000000000004','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000004','published','WebGUI::Asset::Template',1205158717,'3','997995720','3',NULL,0,NULL),('7fE8md51vTCcuJFOvxNaGA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000022','published','WebGUI::Asset::Snippet',1205443600,'3','997995720','3',NULL,0,NULL),('1oGhfj00KkCzP1ez01AfKA','gI_TxK-5S4DNuv42wpImmw','000001000001000015000023','published','WebGUI::Asset::Snippet',1205635970,'3','997995720','3',NULL,0,NULL),('3qiVYhNTXMVC5hfsumVHgg','gI_TxK-5S4DNuv42wpImmw','000001000001000015000024','published','WebGUI::Asset::Snippet',1206743306,'3','997995720','3',NULL,0,NULL),('vrKXEtluIhbmAS9xmPukDA','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000010','published','WebGUI::Asset::Template',1212092352,'3','1222802925','3',NULL,0,NULL),('4qh0kIsFUdd4Ox-Iu1JZgg','PBasset000000000000002','000001000001000012','published','WebGUI::Asset::Wobject::Folder',1208725439,'3','997995720','3',NULL,0,NULL),('BMybD3cEnmXVk2wQ_qEsRQ','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000001','published','WebGUI::Asset::Template',1208530113,'3','997995720','3',NULL,0,NULL),('OOyMH33plAy6oCj_QWrxtg','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000002','published','WebGUI::Asset::Template',1207951375,'3','997995720','3',NULL,0,NULL),('2rC4ErZ3c77OJzJm7O5s3w','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000003','published','WebGUI::Asset::Template',1208721232,'3','997995720','3',NULL,0,NULL),('PsFn7dJt4wMwBa8hiE3hOA','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000004','published','WebGUI::Asset::Template',1208558071,'3','997995720','3',NULL,0,NULL),('yBwydfooiLvhEFawJb0VTQ','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000005','published','WebGUI::Asset::Template',1208629936,'3','997995720','3',NULL,0,NULL),('63ix2-hU0FchXGIWkG3tow','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000011','published','WebGUI::Asset::Template',1209588387,'3','1222802925','3',NULL,0,NULL),('POVcY79vIqAHR8OfGt36aw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000007','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('hIB-z34r8Xl-vYVYCkKr-w','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000008','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('-mPUoFlYcjqjPUPRLAlxNQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000009','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('MDpUOR-N8KMyt1J7Hh_h4w','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000010','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('YfXKByTwDZVituMc4h13Dg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000011','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('esko_HSU0Gh-uJZ1h3xRmQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000012','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('oSqpGswzpBG_ErdfYwIO8A','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000013','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('MXJklShZvLLB_DSnZQmXrQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000014','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('BthxD5oJ0idmsyI3ioA2FA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000015','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('aZ-1HYQamkRHYXvzAra8WQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000016','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('eRkb94OYcS5AdcrrerOP5Q','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000017','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('TbnkjAJQEASORXIpYqDkcA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000018','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('er-3faBjY-hhlDcc5aKqdQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000019','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('8bFsu2FJUqHRUiHcozcVFw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000020','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('34Aayx5eA320D8VfhdfDBw','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000021','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('TlhKOVmWblZOsAdqmhEpeg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000022','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('Nx0ypjO3cN6QdZUBUEE0lA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000023','published','WebGUI::Asset::File::Image',1209499189,'3','997995720','3',NULL,0,NULL),('CmFZLN7iPS7XXvUEsxKPKA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000024','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('v_XBgwwZqgW1D5s4y05qfg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000025','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('4TdAkKoQbSCvI7QWcW889A','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000026','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('SAgK6eDPCG1cgkJ59WapHQ','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000027','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('XJYLuvGy9ubF7JNKyINtpA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000028','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('RWj7hyv2SpZuXxwj1Wocug','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000029','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('aq8QElnlm3YufAoxRz9Pcg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000030','published','WebGUI::Asset::File::Image',1209499190,'3','997995720','3',NULL,0,NULL),('gbnRhcWNk1iQe32LFEB5eQ','PBasset000000000000002','000001000001000037','published','WebGUI::Asset::Wobject::Folder',1210779723,'3','997995720','3',NULL,0,NULL),('6tK47xsaIH-ELw0IBo0uRQ','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000001','published','WebGUI::Asset::Wobject::Folder',1210777115,'3','997995720','3',NULL,0,NULL),('_bZJ9LA_KNekZiFPaP2SeQ','6tK47xsaIH-ELw0IBo0uRQ','000001000001000037000001000001','published','WebGUI::Asset::File::Image',1210777868,'3','997995720','3',NULL,0,NULL),('nFen0xjkZn8WkpM93C9ceQ','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000002','published','WebGUI::Asset::Template',1210779326,'3','997995720','3',NULL,0,NULL),('1XOJDcg_ITRYwVM-QnIcPw','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000003','published','WebGUI::Asset::Snippet',1210779441,'3','997995720','3',NULL,0,NULL),('4e-_rNs6mSWedZhQ_V5kJA','gbnRhcWNk1iQe32LFEB5eQ','000001000001000037000004','published','WebGUI::Asset::Snippet',1210779672,'3','997995720','3',NULL,0,NULL),('eqb9sWjFEVq0yHunGV8IGw','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000012','published','WebGUI::Asset::Template',1213182595,'3','1222802925','3',NULL,0,NULL),('6D4Z-oruXPS6OlH_Kx8pBg','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000005','published','WebGUI::Asset::Wobject::Folder',1209509389,'3','997995720','3',NULL,0,NULL),('hQ7z33_jOYkQ8WNX5xy9Sw','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000001','published','WebGUI::Asset::File::Image',1209509455,'3','997995720','3',NULL,0,NULL),('vWW_DcHiYSrKZOkkIfEfcQ','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000002','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('_bPYzRA87NTAUIKlfrJMHg','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000003','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('nJjZHRwdDs5MAZYsAyioHw','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000004','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('8hxfkrJPeFVRWF5piCNJ1A','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000005','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('Osx7WN52iIKHZFT4vqUBHQ','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000006','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('oWff8fGzRdHPyq5VNREe9Q','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000007','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('uqbkvb1b9443VvfkyRz95w','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000008','published','WebGUI::Asset::File::Image',1209509433,'3','997995720','3',NULL,0,NULL),('8YiMkcz32xalkAn3WBLpag','6D4Z-oruXPS6OlH_Kx8pBg','000001000001000046000005000009','published','WebGUI::Asset::File::Image',1210181860,'3','997995720','3',NULL,0,NULL),('3n3H85BsdeRQ0I08WmvlOg','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000006','published','WebGUI::Asset::Snippet',1212091492,'3','997995720','3',NULL,0,NULL),('5m5I7__l40C4hhv4ydqAHQ','jnYdqDkUR8x7Pv2eGR1qTA','000001000001000046000007','published','WebGUI::Asset::Snippet',1210181698,'3','997995720','3',NULL,0,NULL),('C5fPz-Wg85vkYRvCdl-Xqw','PBasset000000000000002','000001000001000049','published','WebGUI::Asset::Wobject::Folder',1212160830,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000001','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000049000001','published','WebGUI::Asset::Template',1212159641,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000002','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000049000002','published','WebGUI::Asset::Template',1212000800,'3','997995720','3',NULL,0,NULL),('UserListTmpl0000000003','C5fPz-Wg85vkYRvCdl-Xqw','000001000001000049000003','published','WebGUI::Asset::Template',1212001437,'3','997995720','3',NULL,0,NULL),('usuxw9V3jN4d4pujRiEYxg','7-0-style0000000000049','000001000001000053000023','published','WebGUI::Asset::Snippet',1209494150,'3','997995720','3',NULL,0,NULL),('aNmgn0cd6tldmC1FpW4KbA','PBasset000000000000002','000001000001000038','published','WebGUI::Asset::Wobject::Folder',1213122695,'3','997995720','3',NULL,0,NULL),('2q5fxatSFLgIhXaUX-oSvg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000001','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('_d5WTkKjnwct-_Dk7gZHvQ','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000002','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('Iz2mUR3jCPKyemwAea4b2g','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000003','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('JU9bjsLRoWj7GVHs__prig','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000004','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('noOlnjQGexHg8c4bGVUo9g','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000005','published','WebGUI::Asset::File::Image',1204149033,'3','997995720','3',NULL,0,NULL),('aIpCmr9Hi__vgdZnDTz1jw','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000006','published','WebGUI::Asset::Template',1209921197,'3','997995720','3',NULL,0,NULL),('XNd7a_g_cTvJVYrVHcx2Mw','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000007','published','WebGUI::Asset::Template',1212099009,'3','997995720','3',NULL,0,NULL),('2gtFt7c0qAFNU3BG_uvNvg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000008','published','WebGUI::Asset::Template',1211824430,'3','997995720','3',NULL,0,NULL),('bPz1yk6Y9uwMDMBcmMsSCg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000009','published','WebGUI::Asset::Template',1211829604,'3','997995720','3',NULL,0,NULL),('3womoo7Teyy2YKFa25-MZg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000013','published','WebGUI::Asset::Template',1212098997,'3','1222802925','3',NULL,0,NULL),('EBlxJpZQ9o-8VBOaGQbChA','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000014','published','WebGUI::Asset::Template',1212093746,'3','1222802925','3',NULL,0,NULL),('g8W53Pd71uHB9pxaXhWf_A','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000015','published','WebGUI::Asset::Template',1213184121,'3','1222802925','3',NULL,0,NULL),('mTOiwwk3q4k9g5-XykXhPA','68sKwDgf9cGH58-NZcU4lg','000001000002000003','published','WebGUI::Asset::Wobject::Layout',1215717999,'3','1215733893','3',NULL,0,NULL),('j_1qEqM6iLfQLiR6VKy0aA','mTOiwwk3q4k9g5-XykXhPA','000001000002000003000001','published','WebGUI::Asset::Wobject::Article',1215718151,'3','1215733893','3',NULL,0,NULL),('o_pq_e4vRyhMOKFzs61eag','mTOiwwk3q4k9g5-XykXhPA','000001000002000003000002','published','WebGUI::Asset::File::Image',1215714957,'3','1215733893','3',NULL,0,NULL),('diZvW4bSgZWwyyGP3qXi1g','mTOiwwk3q4k9g5-XykXhPA','000001000002000003000003','published','WebGUI::Asset::Wobject::Article',1215717972,'3','1215733893','3',NULL,0,NULL),('PBEmsBadgeTemplate0000','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000006','published','WebGUI::Asset::Template',1221077977,'3','1222802972','3',NULL,0,NULL),('-WM2dt0ZGpDasuL2wWocxg','PBasset000000000000002','000001000001000031','published','WebGUI::Asset::Wobject::Folder',1222803056,'3','997995720','3',NULL,0,NULL),('2OcUWHVsu_L1sDFzIMWYqw','PBasset000000000000002','000001000001000048','published','WebGUI::Asset::Wobject::Folder',1222803070,'3','997995720','3',NULL,0,NULL),('1z9J1O08n_7gVVlBwSRBJQ','PBasset000000000000002','000001000001000005','published','WebGUI::Asset::Wobject::Folder',1222803099,'3','997995720','3',NULL,0,NULL),('zyWi26q9na-iiZqL4yedog','PBasset000000000000002','000001000001000021','published','WebGUI::Asset::Wobject::Folder',1222803114,'3','997995720','3',NULL,0,NULL),('NywJYmGWe1f6EBXJnWg9Xg','PBasset000000000000002','000001000001000030','published','WebGUI::Asset::Wobject::Folder',1222803606,'3','997995720','3',NULL,0,NULL),('UL-ItI4L1Z6-WSuhuXVvsQ','PBasset000000000000002','000001000001000011','published','WebGUI::Asset::Wobject::Folder',1225139673,'3','997995720','3',NULL,0,NULL),('3rjnBVJRO6ZSkxlFkYh_ug','UL-ItI4L1Z6-WSuhuXVvsQ','000001000001000011000001','published','WebGUI::Asset::Template',1225139643,'3','997995720','3',NULL,0,NULL),('TuYPpHx7TUyk08639Pc8Bg','UL-ItI4L1Z6-WSuhuXVvsQ','000001000001000011000002','published','WebGUI::Asset::Template',1225139643,'3','997995720','3',NULL,0,NULL),('THQhn1C-ooj-TLlEP7aIJQ','gI_TxK-5S4DNuv42wpImmw','000001000001000015000025','published','WebGUI::Asset::Snippet',1225313951,'3','1234301624','3',NULL,0,NULL),('jVKLVakT_iA2010_oEuAwg','7-0-style0000000000049','000001000001000053000024','published','WebGUI::Asset::Wobject::Navigation',1224116526,'3','997995720','3',NULL,0,NULL),('QpmlAiYZz6VsKBM-_0wXaw','zyWi26q9na-iiZqL4yedog','000001000001000021000012','published','WebGUI::Asset::Wobject::Folder',1224616691,'3','1234301591','3',NULL,0,NULL),('h_T2xtOxGRQ9QJOR6ebLpQ','QpmlAiYZz6VsKBM-_0wXaw','000001000001000021000012000001','published','WebGUI::Asset::Template',1224616545,'3','1234301591','3',NULL,0,NULL),('4Ekp0kJoJllRRRo_J1Rj6w','QpmlAiYZz6VsKBM-_0wXaw','000001000001000021000012000002','published','WebGUI::Asset::Template',1224616672,'3','1234301591','3',NULL,0,NULL),('gfZOwaTWYjbSoVaQtHBBEw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000001','published','WebGUI::Asset::Template',1226974679,'3','997995720','3',NULL,0,NULL),('c8xrwVuu5QE0XtF9DiVzLw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000002','published','WebGUI::Asset::Template',1226894351,'3','997995720','3',NULL,0,NULL),('0n4HtbXaWa_XJHkFjetnLQ','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000003','published','WebGUI::Asset::Template',1226894994,'3','997995720','3',NULL,0,NULL),('ErEzulFiEKDkaCDVmxUavw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000004','published','WebGUI::Asset::Template',1226895484,'3','997995720','3',NULL,0,NULL),('6uQEULvXFgCYlRWnYzZsuA','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000005','published','WebGUI::Asset::Template',1226896682,'3','997995720','3',NULL,0,NULL),('DUoxlTBXhVS-Zl3CFDpt9g','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000006','published','WebGUI::Asset::Template',1226896802,'3','997995720','3',NULL,0,NULL),('1Q4Je3hKCJzeo0ZBB5YB8g','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000007','published','WebGUI::Asset::Template',1226898445,'3','997995720','3',NULL,0,NULL),('5A8Hd9zXvByTDy4x-H28qw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000008','published','WebGUI::Asset::Template',1226899462,'3','997995720','3',NULL,0,NULL),('VBkY05f-E3WJS50WpdKd1Q','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000009','published','WebGUI::Asset::Template',1226899241,'3','997995720','3',NULL,0,NULL),('XgcsoDrbC0duVla7N7JAdw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000010','published','WebGUI::Asset::Template',1226973330,'3','997995720','3',NULL,0,NULL),('cR0UFm7I1qUI2Wbpj--08Q','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000011','published','WebGUI::Asset::Template',1226964738,'3','997995720','3',NULL,0,NULL),('SVIhz68689hwUGgcDM-gWw','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000012','published','WebGUI::Asset::Template',1226973314,'3','997995720','3',NULL,0,NULL),('K0YjxqOqr7RupSo6sIdcAg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000003','published','WebGUI::Asset::Wobject::Folder',1227074310,'3','997995720','3',NULL,0,NULL),('zrNpGbT3odfIkg6nFSUy8Q','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000001','published','WebGUI::Asset::Template',1226994016,'3','997995720','3',NULL,0,NULL),('1Yn_zE_dSiNuaBGNLPbxtw','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000002','published','WebGUI::Asset::Template',1226994422,'3','997995720','3',NULL,0,NULL),('AZFU33p0jpPJ-E6qLSWZng','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000003','published','WebGUI::Asset::Template',1226994865,'3','997995720','3',NULL,0,NULL),('AGJBGviWGAwjnwziiPjvDg','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000004','published','WebGUI::Asset::Template',1226995497,'3','997995720','3',NULL,0,NULL),('7Ijdd8SW32lVgg2H8R-Aqw','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000005','published','WebGUI::Asset::Template',1226995714,'3','997995720','3',NULL,0,NULL),('K8F0j_cq_jgo8dvWY_26Ag','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000006','published','WebGUI::Asset::Template',1226995643,'3','997995720','3',NULL,0,NULL),('G5V6neXIDiFXN05oL-U3AQ','K0YjxqOqr7RupSo6sIdcAg','000001000001000002000003000007','published','WebGUI::Asset::Template',1226995768,'3','997995720','3',NULL,0,NULL),('_ilRXNR3s8F2vGJ_k9ePcg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000004','published','WebGUI::Asset::Wobject::Folder',1226643205,'3','997995720','3',NULL,0,NULL),('9ThW278DWLV0-Svf68ljFQ','_ilRXNR3s8F2vGJ_k9ePcg','000001000001000002000004000001','published','WebGUI::Asset::Template',1226647187,'3','997995720','3',NULL,0,NULL),('AOjPG2NHgfL9Cq6dDJ7mew','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000005','published','WebGUI::Asset::Wobject::Folder',1226659753,'3','997995720','3',NULL,0,NULL),('aUDsJ-vB9RgP-AYvPOy8FQ','AOjPG2NHgfL9Cq6dDJ7mew','000001000001000002000005000001','published','WebGUI::Asset::Template',1226660439,'3','997995720','3',NULL,0,NULL),('qaVcU0FFzzraMX_bzELqzw','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000006','published','WebGUI::Asset::Wobject::Folder',1227074362,'3','997995720','3',NULL,0,NULL),('b4n3VyUIsAHyIvT-W-jziA','qaVcU0FFzzraMX_bzELqzw','000001000001000002000006000001','published','WebGUI::Asset::Template',1227074747,'3','997995720','3',NULL,0,NULL),('1IzRpX0tgW7iuCfaU2Kk0A','qaVcU0FFzzraMX_bzELqzw','000001000001000002000006000002','published','WebGUI::Asset::Template',1227079721,'3','997995720','3',NULL,0,NULL),('N716tpSna0iIQTKxS4gTWA','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000007','published','WebGUI::Asset::Template',1226604666,'3','997995720','3',NULL,0,NULL),('GRUNFctldUgop-qRLuo_DA','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000004','published','WebGUI::Asset::Template',1227254010,'3','997995720','3',NULL,0,NULL),('d8jMMMRddSQ7twP4l1ZSIw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000005','published','WebGUI::Asset::Template',1227248175,'3','997995720','3',NULL,0,NULL),('CxMpE_UPauZA3p8jdrOABw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000006','published','WebGUI::Asset::Template',1227556536,'3','997995720','3',NULL,0,NULL),('1oBRscNIcFOI-pETrCOspA','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000007','published','WebGUI::Asset::Template',1226009642,'3','997995720','3',NULL,0,NULL),('wAc4azJViVTpo-2NYOXWvg','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000008','published','WebGUI::Asset::Template',1226009650,'3','997995720','3',NULL,0,NULL),('AjhlNO3wZvN5k4i4qioWcg','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000009','published','WebGUI::Asset::Template',1226009658,'3','997995720','3',NULL,0,NULL),('itransact_credentials1','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000018','published','WebGUI::Asset::Template',1228953856,'3','1234301682','3',NULL,0,NULL),('hkj6WeChxFyqfP85UlRP8w','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000006','published','WebGUI::Asset::Snippet',1232664229,'3','997995720','3',NULL,0,NULL),('kJf77eCr9GAMiEzWrzsBTA','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000007','published','WebGUI::Asset::Snippet',1229639255,'3','997995720','3',NULL,0,NULL),('4LQT4-bGW4FkiEQLSY5gvQ','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000008','published','WebGUI::Asset::Snippet',1232400287,'3','997995720','3',NULL,0,NULL),('alraubvBu-YJJ614jAHD5w','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000009','published','WebGUI::Asset::Template',1232664015,'3','997995720','3',NULL,0,NULL),('Vch1Ww7G_JpBhOhXX07RDg','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000010','published','WebGUI::Asset::Wobject::Navigation',1232664082,'3','997995720','3',NULL,0,NULL),('_XfvgNH__bY1ykMiKYSobQ','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000008','published','WebGUI::Asset::Snippet',1233168041,'3','997995720','3',NULL,0,NULL),('HW-sPoDDZR8wBZ0YgFgPtg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000009','published','WebGUI::Asset::Wobject::Folder',1227634350,'3','997995720','3',NULL,0,NULL),('hBpisL-_URyZnh9clR5ohA','HW-sPoDDZR8wBZ0YgFgPtg','000001000001000002000009000001','published','WebGUI::Asset::File::Image',1227634417,'3','997995720','3',NULL,0,NULL),('FOBV6KkifreXa4GmEAUU4A','HW-sPoDDZR8wBZ0YgFgPtg','000001000001000002000009000002','published','WebGUI::Asset::File::Image',1227634447,'3','997995720','3',NULL,0,NULL),('qsG6B24a0SC5KrhQjmdZBw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000010','published','WebGUI::Asset::Snippet',1233860274,'3','1234301655','3',NULL,0,NULL),('wrq7hMxb1ewQqZ46xmd8Gg','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000011','published','WebGUI::Asset::Snippet',1235706620,'3','1238119575','3',NULL,0,NULL),('matrixtmpl000000000006','LdiozcIUciWuvt3Z-na5Ww','000001000001000022000013','published','WebGUI::Asset::Template',1236889702,'3','1238119576','3',NULL,0,NULL),('-zxyB-O50W8YnL39Ouoc4Q','AOjPG2NHgfL9Cq6dDJ7mew','000001000001000002000005000002','published','WebGUI::Asset::Template',1236959717,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000016','fq1ZkYhH24R5tb96kuT10Q','000001000001000005000005000003','published','WebGUI::Asset::Template',1237407798,'3','1238119553','3',NULL,0,NULL),('RSAMkc6WQmfRE3TOr1_3Mw','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000011','published','WebGUI::Asset::Wobject::Folder',1234828062,'3','1238119589','3',NULL,0,NULL),('ExpireIncResptmpl00001','RSAMkc6WQmfRE3TOr1_3Mw','000001000001000044000011000001','published','WebGUI::Asset::Template',1236752721,'3','1238119589','3',NULL,0,NULL),('XdlKhCDvArs40uqBhvzR3w','PBasset000000000000002','000001000001000057','published','WebGUI::Asset::Template',1254881103,'3','997995720','3',NULL,0,NULL),('VCFhB9WOsDsH2Apj3c6DpQ','PBasset000000000000002','000001000001000058','published','WebGUI::Asset::Template',1254881103,'3','997995720','3',NULL,0,NULL),('NBVSVNLp9X_bV7WrCprtCA','tPagC0AQErZXjLFZQ6OI1g','000001000001000017000002','published','WebGUI::Asset::Template',1237842096,'3','1238119599','3',NULL,0,NULL),('jmlI9IK-lV8n2WMYmmPhAA','PBasset000000000000002','000001000001000001','published','WebGUI::Asset::Wobject::Folder',1238106173,'3','997995720','3',NULL,0,NULL),('AldPGu0u-jm_5xK13atCSQ','jmlI9IK-lV8n2WMYmmPhAA','000001000001000001000001','published','WebGUI::Asset::Template',1238106805,'3','997995720','3',NULL,0,NULL),('ohjyzab5i-yW6GOWTeDUHg','jmlI9IK-lV8n2WMYmmPhAA','000001000001000001000002','published','WebGUI::Asset::Template',1238106805,'3','997995720','3',NULL,0,NULL),('PBtmpl0000000000000015','fq1ZkYhH24R5tb96kuT10Q','000001000001000005000005000002','published','WebGUI::Asset::Template',1237647040,'3','1238119545','3',NULL,0,NULL),('6uvSLY-ak_w4p_wS8q33cA','PBasset000000000000002','000001000001000007','published','WebGUI::Asset::Wobject::Folder',1239213092,'3','997995720','3',NULL,0,NULL),('CarouselTmpl0000000001','6uvSLY-ak_w4p_wS8q33cA','000001000001000007000001','published','WebGUI::Asset::Template',1239290719,'3','997995720','3',NULL,0,NULL),('CarouselTmpl0000000002','6uvSLY-ak_w4p_wS8q33cA','000001000001000007000002','published','WebGUI::Asset::Template',1238878995,'3','997995720','3',NULL,0,NULL),('7F-BuEHi7t9bPi008H8xZQ','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000012','published','WebGUI::Asset::Template',1239248021,'3','1251849727','3',NULL,0,NULL),('GaBAW-2iVhLMJaZQzVLE5A','PBasset000000000000002','000001000001000047','published','WebGUI::Asset::Wobject::Folder',1240103565,'3','997995720','3',NULL,0,NULL),('TKmhv8boP3TD2xwSwUBq0g','GaBAW-2iVhLMJaZQzVLE5A','000001000001000047000001','published','WebGUI::Asset::Template',1240103436,'3','997995720','3',NULL,0,NULL),('fowHfgOkJtAxdst7rugTog','PBasset000000000000002','000001000001000042','published','WebGUI::Asset::Wobject::Folder',1236184911,'3','997995720','3',NULL,0,NULL),('3QpYtHrq_jmAk1FNutQM5A','fowHfgOkJtAxdst7rugTog','000001000001000042000001','published','WebGUI::Asset::Template',1239237827,'3','997995720','3',NULL,0,NULL),('yxD5ka7XHebPLD-LXBwJqw','fowHfgOkJtAxdst7rugTog','000001000001000042000002','published','WebGUI::Asset::Template',1239918573,'3','997995720','3',NULL,0,NULL),('E3tzZjzhmYoNlAyP2VW33Q','fowHfgOkJtAxdst7rugTog','000001000001000042000003','published','WebGUI::Asset::Template',1239236292,'3','997995720','3',NULL,0,NULL),('TbDcVLbbznPi0I0rxQf2CQ','fowHfgOkJtAxdst7rugTog','000001000001000042000004','published','WebGUI::Asset::Template',1237524306,'3','997995720','3',NULL,0,NULL),('A16v-YjWAShXWvSACsraeg','fowHfgOkJtAxdst7rugTog','000001000001000042000005','published','WebGUI::Asset::Template',1239918710,'3','997995720','3',NULL,0,NULL),('0EAJ9EYb9ap2XwfrcXfdLQ','fowHfgOkJtAxdst7rugTog','000001000001000042000006','published','WebGUI::Asset::Template',1240262820,'3','997995720','3',NULL,0,NULL),('b1316COmd9xRv4fCI3LLGA','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000013','published','WebGUI::Asset::Template',1236956475,'3','1251849906','3',NULL,0,NULL),('lo1rpxn3t8YPyKGers5eQg','QHn6T9rU7KsnS3Y70KCNTg','000001000001000002000010','published','WebGUI::Asset::Wobject::Folder',1238625621,'3','1251850125','3',NULL,0,NULL),('64tqS80D53Z0JoAs2cX2VQ','lo1rpxn3t8YPyKGers5eQg','000001000001000002000010000001','published','WebGUI::Asset::Template',1239400975,'3','1251850125','3',NULL,0,NULL),('lG2exkH9FeYvn4pA63idNg','lo1rpxn3t8YPyKGers5eQg','000001000001000002000010000002','published','WebGUI::Asset::Template',1239383808,'3','1251850125','3',NULL,0,NULL),('nWNVoMLrMo059mDRmfOp9g','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000015','published','WebGUI::Asset::Template',1242259265,'3','1251849915','3',NULL,0,NULL),('brxm_faNdZX5tRo3p50g3g','PBasset000000000000002','000001000001000020','published','WebGUI::Asset::Wobject::Folder',1238054297,'3','997995720','3',NULL,0,NULL),('9j0_Z1j3Jd0QBbY2akb6qw','brxm_faNdZX5tRo3p50g3g','000001000001000020000001','published','WebGUI::Asset::Template',1238053232,'3','997995720','3',NULL,0,NULL),('oHh0UqAJeY7u2n--WD-BAA','brxm_faNdZX5tRo3p50g3g','000001000001000020000002','published','WebGUI::Asset::Template',1238040667,'3','997995720','3',NULL,0,NULL),('u9vfx33XDk5la1-QC5FK7g','brxm_faNdZX5tRo3p50g3g','000001000001000020000003','published','WebGUI::Asset::Template',1238048383,'3','997995720','3',NULL,0,NULL),('D6cJpRcey35aSkh9Q_FPUQ','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000019','published','WebGUI::Asset::Template',1242407725,'3','1251849978','3',NULL,0,NULL),('S2_LsvVa95OSqc66ITAoig','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000007','published','WebGUI::Asset::Template',1242730712,'3','1251849967','3',NULL,0,NULL),('S3zpVitAmhy58CAioH359Q','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000013','published','WebGUI::Asset::Template',1242893798,'3','1251849727','3',NULL,0,NULL),('kwTL1SWCk0GlpiJ5zAAEPQ','5bnNzteN7w3NnK9mF4XiCg','000001000001000044000014','published','WebGUI::Asset::Snippet',1244488512,'3','1251849727','3',NULL,0,NULL),('YP9WaMPJHvCJl-YwrLVcPw','PBasset000000000000002','000001000001000029','published','WebGUI::Asset::Template',1245376837,'3','997995720','3',NULL,0,NULL),('i9-G00ALhJOr0gMh-vHbKA','IZkrow_zwvbf4FCH-taVTQ','000001000001000002000002000014','published','WebGUI::Asset::Template',1250408924,'3','1251849906','3',NULL,0,NULL),('iCM9pRY5yYyjufROgaCDlg','fowHfgOkJtAxdst7rugTog','000001000001000042000007','published','WebGUI::Asset::Snippet',1253305659,'3','997995720','3',NULL,0,NULL),('limMkk80fMB3fqNZVf162w','PBasset000000000000002','000001000001000056','published','WebGUI::Asset::Template',1253507213,'3','997995720','3',NULL,0,NULL),('hreA_bgxiTX-EzWCSZCZJw','4qh0kIsFUdd4Ox-Iu1JZgg','000001000001000012000008','published','WebGUI::Asset::Template',1257311887,'3','997995720','3',NULL,0,NULL),('2GxjjkRuRkdUg_PccRPjpA','PBasset000000000000002','000001000001000059','published','WebGUI::Asset::Template',1257311888,'3','997995720','3',NULL,0,NULL),('_aE16Rr1-bXBf8SIaLZjCg','PBasset000000000000002','000001000001000060','published','WebGUI::Asset::Template',1257311888,'3','997995720','3',NULL,0,NULL),('P_4uog81vSUK4KxuW_4GUA','PBasset000000000000002','000001000001000061','published','WebGUI::Asset::Wobject::Folder',1258524916,'3','997995720','3',NULL,0,NULL),('H_-8zjtWsO1FUpQqNtkxNQ','P_4uog81vSUK4KxuW_4GUA','000001000001000061000001','published','WebGUI::Asset::Snippet',1258524916,'3','997995720','3',NULL,0,NULL),('8tqyQx-LwYUHIWOlKPjJrA','PBasset000000000000002','000001000001000062','published','WebGUI::Asset::Template',1258524917,'3','997995720','3',NULL,0,NULL),('DoVNijm6lMDE0cYrtvEbDQ','PBasset000000000000002','000001000001000063','published','WebGUI::Asset::Template',1258524917,'3','997995720','3',NULL,0,NULL),('ktSvKU8riGimhcsxXwqvPQ','PBasset000000000000002','000001000001000064','published','WebGUI::Asset::Template',1258524917,'3','997995720','3',NULL,0,NULL),('mRtqRuVikSe82BQsYBlD0A','PBasset000000000000002','000001000001000065','published','WebGUI::Asset::Template',1263962529,'3','997995720','3',NULL,0,NULL),('0iMMbGN3BevuCBHjjLiQNA','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000009','published','WebGUI::Asset::Wobject::Folder',1269401469,'3','997995720','3',NULL,0,NULL),('zaHUYsE_PgKk8hnVd8ffEQ','0iMMbGN3BevuCBHjjLiQNA','000001000001000005000009000001','published','WebGUI::Asset::Template',1269401469,'3','997995720','3',NULL,0,NULL),('6A4yIjWwJfIE0Ep-I0jutg','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000010','published','WebGUI::Asset::Wobject::Folder',1269401469,'3','997995720','3',NULL,0,NULL),('_P4PMiraGsLTfOjK4fYQPQ','6A4yIjWwJfIE0Ep-I0jutg','000001000001000005000010000001','published','WebGUI::Asset::Template',1269401469,'3','997995720','3',NULL,0,NULL),('i6-BofrJJYozovlzFBByXg','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000031','published','WebGUI::Asset::File::Image',1270612331,'3','997995720','3',NULL,0,NULL),('fU_OZCmtdFNJ8a6bMve8ng','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000032','published','WebGUI::Asset::File::Image',1270612331,'3','997995720','3',NULL,0,NULL),('YXCtusAxb4vzZ5sTnUA5DA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000033','published','WebGUI::Asset::File::Image',1270612331,'3','997995720','3',NULL,0,NULL),('k_xuE82wwp8gFVl9aaaG8g','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000034','published','WebGUI::Asset::File::Image',1270612331,'3','997995720','3',NULL,0,NULL),('NPM_WItpM5IzLWBhWjYfCA','kaPRSaf8UKiskiGEgJgLAw','000001000001000015000017000035','published','WebGUI::Asset::File::Image',1270612331,'3','997995720','3',NULL,0,NULL),('qxd0WpRGqDPWP8WBicYvEA','PBasset000000000000002','000001000001000066','published','WebGUI::Asset::Snippet',1271820952,'3','997995720','3',NULL,0,NULL),('30h5rHxzE_Q0CyI3Gg7EJw','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000020','published','WebGUI::Asset::Template',1273032715,'3','997995720','3',NULL,0,NULL),('jysVZeUR0Bx2NfrKs5sulg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000021','published','WebGUI::Asset::Template',1273032715,'3','997995720','3',NULL,0,NULL),('300AozDaeveAjB_KN0ljlQ','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000022','published','WebGUI::Asset::Template',1273032715,'3','997995720','3',NULL,0,NULL),('GqnZPB0gLoZmqQzYFaq7bg','aNmgn0cd6tldmC1FpW4KbA','000001000001000038000023','published','WebGUI::Asset::Template',1273032716,'3','997995720','3',NULL,0,NULL),('t87D1138NhPHhA23-hozBA','PBasset000000000000002','000001000001000067','published','WebGUI::Asset::Wobject::Folder',1273032716,'3','997995720','3',NULL,0,NULL),('QtBumey5ffc-xffRp1-7Aw','t87D1138NhPHhA23-hozBA','000001000001000067000001','published','WebGUI::Asset::Wobject::Folder',1273032716,'3','997995720','3',NULL,0,NULL),('-0sK2rX1cwQt1ipUSqsiQQ','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000001','published','WebGUI::Asset::File::Image',1273032716,'3','997995720','3',NULL,0,NULL),('hS_eOaVz9Qb5ixndK9EXAw','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000002','published','WebGUI::Asset::File::Image',1273032716,'3','997995720','3',NULL,0,NULL),('k2p-Be8C98pf2cRq7E-JHg','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000003','published','WebGUI::Asset::File::Image',1273032716,'3','997995720','3',NULL,0,NULL),('aYG4fjbMPbC4LCuuMp4gGA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000004','published','WebGUI::Asset::File::Image',1273032716,'3','997995720','3',NULL,0,NULL),('F122Ey0NtVAw6Lfv1M6G_Q','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000005','published','WebGUI::Asset::File::Image',1273032716,'3','997995720','3',NULL,0,NULL),('qmXHKrQ6EDLSOGkrEKRUDA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000006','published','WebGUI::Asset::File::Image',1273032716,'3','997995720','3',NULL,0,NULL),('4qZgXjPPO4fwV879yu5XUg','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000007','published','WebGUI::Asset::File::Image',1273032716,'3','997995720','3',NULL,0,NULL),('mb-xeAugm5GJdvu-Wh0MtQ','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000008','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('84Y9CwgzP6eNU7wZnk019Q','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000009','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('ikXTtJKZfHVxqw-47E4AQA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000010','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('DhRWPTgzhvju_-TbMN3CwA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000011','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('6njI-pZz2bwsjWh-Q1_11g','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000012','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('_Hz1Gnd3yEnJzVS7l7nJMQ','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000013','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('VOOrXK5dFnkGih7aTkuDWA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000014','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('ruf-QejOkUHDRtfgakHlbA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000015','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('FSHy5KjQjkt599PHS41seA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000016','published','WebGUI::Asset::File::Image',1273032717,'3','997995720','3',NULL,0,NULL),('nuYYXAz4KNNxgfumfnpo_g','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000017','published','WebGUI::Asset::File::Image',1273032718,'3','997995720','3',NULL,0,NULL),('Mr7ljjoy6n4fZojpQWajKQ','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000018','published','WebGUI::Asset::File::Image',1273032718,'3','997995720','3',NULL,0,NULL),('ApkqpDOrJDxK3QrWBGSRIg','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000019','published','WebGUI::Asset::File::Image',1273032718,'3','997995720','3',NULL,0,NULL),('AzzTY0Lay1f_YGeQJFnQCA','QtBumey5ffc-xffRp1-7Aw','000001000001000067000001000020','published','WebGUI::Asset::File::Image',1273032718,'3','997995720','3',NULL,0,NULL),('OiJNwP1gAlcva8_yOtL4gA','t87D1138NhPHhA23-hozBA','000001000001000067000002','published','WebGUI::Asset::Template',1273032718,'3','997995720','3',NULL,0,NULL),('JOuCU4x5BJfVHfkfMkVQdQ','t87D1138NhPHhA23-hozBA','000001000001000067000003','published','WebGUI::Asset::Snippet',1273032718,'3','997995720','3',NULL,0,NULL),('Am1J-meNBmhqFfEIWy6Gag','t87D1138NhPHhA23-hozBA','000001000001000067000004','published','WebGUI::Asset::Wobject::Navigation',1273032718,'3','997995720','3',NULL,0,NULL),('gaIOm5cr2TkT9Fk6QmZWug','t87D1138NhPHhA23-hozBA','000001000001000067000005','published','WebGUI::Asset::Template',1273032718,'3','997995720','3',NULL,0,NULL),('w0QifHLhsrzeOpFKl-DX-Q','t87D1138NhPHhA23-hozBA','000001000001000067000006','published','WebGUI::Asset::Snippet',1273032718,'3','997995720','3',NULL,0,NULL),('x_hiUi1XZloBvV47Obnu8Q','t87D1138NhPHhA23-hozBA','000001000001000067000007','published','WebGUI::Asset::Wobject::Navigation',1273032718,'3','997995720','3',NULL,0,NULL),('hpCk0B3vQzgc-QJhSol41w','t87D1138NhPHhA23-hozBA','000001000001000067000008','published','WebGUI::Asset::Template',1273032718,'3','997995720','3',NULL,0,NULL),('UUwEL6hLEPdrnkZnKRzFYQ','t87D1138NhPHhA23-hozBA','000001000001000067000009','published','WebGUI::Asset::Wobject::Search',1273032718,'3','997995720','3',NULL,0,NULL),('OfKbvK7CrfMnfc8WDoF4Rg','t87D1138NhPHhA23-hozBA','000001000001000067000010','published','WebGUI::Asset::Template',1273032718,'3','997995720','3',NULL,0,NULL),('CQp-RFA2pMh5lFSggPPPYg','PBasset000000000000002','000001000001000068','published','WebGUI::Asset::Wobject::Folder',1273032719,'3','997995720','3',NULL,0,NULL),('_Mi_NTd3x8UB96LWezWHnw','CQp-RFA2pMh5lFSggPPPYg','000001000001000068000001','published','WebGUI::Asset::Wobject::Folder',1273032719,'3','997995720','3',NULL,0,NULL),('A_5LVQQWR73QZR8FFbny_w','_Mi_NTd3x8UB96LWezWHnw','000001000001000068000001000001','published','WebGUI::Asset::File::Image',1273032719,'3','997995720','3',NULL,0,NULL),('wywIfa_VuTsq0c5Ed-W-MA','_Mi_NTd3x8UB96LWezWHnw','000001000001000068000001000002','published','WebGUI::Asset::File::Image',1273032719,'3','997995720','3',NULL,0,NULL),('xmykMFjri1O2NrYHbeToVQ','_Mi_NTd3x8UB96LWezWHnw','000001000001000068000001000003','published','WebGUI::Asset::File::Image',1273032719,'3','997995720','3',NULL,0,NULL),('0IIGNBs_-INzqBC5VLeJgw','_Mi_NTd3x8UB96LWezWHnw','000001000001000068000001000004','published','WebGUI::Asset::File::Image',1273032719,'3','997995720','3',NULL,0,NULL),('FXmePdyS0YKuZ1VCGGpK9w','_Mi_NTd3x8UB96LWezWHnw','000001000001000068000001000005','published','WebGUI::Asset::File::Image',1273032719,'3','997995720','3',NULL,0,NULL),('66qCywiE_fiL9u5YIaJhgw','_Mi_NTd3x8UB96LWezWHnw','000001000001000068000001000006','published','WebGUI::Asset::File::Image',1273032719,'3','997995720','3',NULL,0,NULL),('n5VpG4lFsOG1elaWDQbilw','_Mi_NTd3x8UB96LWezWHnw','000001000001000068000001000007','published','WebGUI::Asset::File::Image',1273032719,'3','997995720','3',NULL,0,NULL),('g3JH1PRq6m6Bj_PnGpcrSQ','CQp-RFA2pMh5lFSggPPPYg','000001000001000068000002','published','WebGUI::Asset::Wobject::Folder',1273032719,'3','997995720','3',NULL,0,NULL),('egpnaaFqWmJwYTZ5CvFH9g','g3JH1PRq6m6Bj_PnGpcrSQ','000001000001000068000002000001','published','WebGUI::Asset::Snippet',1273032719,'3','997995720','3',NULL,0,NULL),('BBpxqoSseIor5C9ei9JEFQ','g3JH1PRq6m6Bj_PnGpcrSQ','000001000001000068000002000002','published','WebGUI::Asset::Snippet',1273032719,'3','997995720','3',NULL,0,NULL),('G0hl4VilbFKipToyxKqFrg','CQp-RFA2pMh5lFSggPPPYg','000001000001000068000003','published','WebGUI::Asset::Wobject::Folder',1273032719,'3','997995720','3',NULL,0,NULL),('GWU2qZqe6yEuAKG-5HtBdg','CQp-RFA2pMh5lFSggPPPYg','000001000001000068000004','published','WebGUI::Asset::Wobject::Folder',1273032719,'3','997995720','3',NULL,0,NULL),('Qk24uXao2yowR6zxbVJ0xA','GWU2qZqe6yEuAKG-5HtBdg','000001000001000068000004000001','published','WebGUI::Asset::Template',1273032719,'3','997995720','3',NULL,0,NULL),('39KNX53B4nYJAyIE1lu8ZQ','GWU2qZqe6yEuAKG-5HtBdg','000001000001000068000004000002','published','WebGUI::Asset::Template',1273032720,'3','997995720','3',NULL,0,NULL),('ztfi__vHJLsQDsMenrEn-w','GWU2qZqe6yEuAKG-5HtBdg','000001000001000068000004000003','published','WebGUI::Asset::Template',1273032720,'3','997995720','3',NULL,0,NULL),('8qyrDCNeggB4dzKiOoRuiQ','GWU2qZqe6yEuAKG-5HtBdg','000001000001000068000004000004','published','WebGUI::Asset::Template',1273032720,'3','997995720','3',NULL,0,NULL),('M1NyNeS5jpdIsiIWFiJprw','GWU2qZqe6yEuAKG-5HtBdg','000001000001000068000004000005','published','WebGUI::Asset::Template',1273032720,'3','997995720','3',NULL,0,NULL),('AsfpsOpsGzZCb9m7MyxPuw','CQp-RFA2pMh5lFSggPPPYg','000001000001000068000005','published','WebGUI::Asset::Wobject::Folder',1273032720,'3','997995720','3',NULL,0,NULL),('n-Vr_wgxOkwiHGt1nJto9w','AsfpsOpsGzZCb9m7MyxPuw','000001000001000068000005000001','published','WebGUI::Asset::Wobject::Navigation',1273032720,'3','997995720','3',NULL,0,NULL),('jmqLxnoWb6p92Cr12lf1hw','AsfpsOpsGzZCb9m7MyxPuw','000001000001000068000005000002','published','WebGUI::Asset::Wobject::Navigation',1273032720,'3','997995720','3',NULL,0,NULL),('8E2UOnj_XPEghTj7nfVM0g','CQp-RFA2pMh5lFSggPPPYg','000001000001000068000006','published','WebGUI::Asset::Wobject::Search',1273032720,'3','997995720','3',NULL,0,NULL),('1qFjOEiILIwr1xB5_ebppQ','PBasset000000000000002','000001000001000069','published','WebGUI::Asset::Wobject::Folder',1273032721,'3','997995720','3',NULL,0,NULL),('xD76UfQ_JnSgTLBNvytcpQ','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000001','published','WebGUI::Asset::Wobject::Folder',1273032721,'3','997995720','3',NULL,0,NULL),('pAXR7Kby4O-dSxOwLp1GaA','xD76UfQ_JnSgTLBNvytcpQ','000001000001000069000001000001','published','WebGUI::Asset::File::Image',1273032721,'3','997995720','3',NULL,0,NULL),('TthzMLO4n3qxy59QZ5YBHg','xD76UfQ_JnSgTLBNvytcpQ','000001000001000069000001000002','published','WebGUI::Asset::File::Image',1273032721,'3','997995720','3',NULL,0,NULL),('3n31SQjYa150TBrRBgMPhA','xD76UfQ_JnSgTLBNvytcpQ','000001000001000069000001000003','published','WebGUI::Asset::File::Image',1273032721,'3','997995720','3',NULL,0,NULL),('R4RxDufGbbIzEmpcoEcLrw','xD76UfQ_JnSgTLBNvytcpQ','000001000001000069000001000004','published','WebGUI::Asset::File::Image',1273032721,'3','997995720','3',NULL,0,NULL),('xyyn5mz3xGyvrcI1rY8C-w','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000002','published','WebGUI::Asset::Snippet',1273032721,'3','997995720','3',NULL,0,NULL),('KKt0VB_eoQxw9xEsHsAhag','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000003','published','WebGUI::Asset::Template',1273032721,'3','997995720','3',NULL,0,NULL),('h0bOzz7WvdaVZXsjpwtkww','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000004','published','WebGUI::Asset::Wobject::Navigation',1273032721,'3','997995720','3',NULL,0,NULL),('_z3ukLCqvoaUygfsbbkBzw','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000005','published','WebGUI::Asset::Template',1273032721,'3','997995720','3',NULL,0,NULL),('qFOfW1sKyOTnGNcP6BXbwg','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000006','published','WebGUI::Asset::Wobject::Navigation',1273032721,'3','997995720','3',NULL,0,NULL),('Pt38T5_MWSue2e1N36MLdw','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000007','published','WebGUI::Asset::Template',1273032721,'3','997995720','3',NULL,0,NULL),('LDcM1Iop17nF2MoSa7zo_Q','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000008','published','WebGUI::Asset::Template',1273032721,'3','997995720','3',NULL,0,NULL),('hVF1taXj4bfd7DuL4XDMYg','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000009','published','WebGUI::Asset::Template',1273032721,'3','997995720','3',NULL,0,NULL),('x4-2QYRSrIB_BJfnSKKj4w','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000010','published','WebGUI::Asset::Template',1273032721,'3','997995720','3',NULL,0,NULL),('423R4Y6XIt3wUzlnLo-chg','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000011','published','WebGUI::Asset::Template',1273032721,'3','997995720','3',NULL,0,NULL),('oZ1Mk-zExYUyD-JsjTvaHg','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000012','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('mYwS8CZaOLMt0raaKXGZcQ','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000013','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('kSGR4OHsKmhLQTuLkisOww','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000014','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('G5DgNizuG3jXkjPp6UaGrA','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000015','published','WebGUI::Asset::Wobject::Folder',1273032722,'3','997995720','3',NULL,0,NULL),('U78V5IJHVljvRTb6ydsTHg','G5DgNizuG3jXkjPp6UaGrA','000001000001000069000015000001','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('Xqc3qPUXoFE8dt9qocdWig','G5DgNizuG3jXkjPp6UaGrA','000001000001000069000015000002','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('IBTb7wllSt7RxFmmvm9pkQ','G5DgNizuG3jXkjPp6UaGrA','000001000001000069000015000003','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('Z1EM7JMI_4SkyfaZffSElw','G5DgNizuG3jXkjPp6UaGrA','000001000001000069000015000004','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('fJg7SKpGZwzSNx3_ebki1A','G5DgNizuG3jXkjPp6UaGrA','000001000001000069000015000005','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('ihf4Rx6p72xn_nVKaIeOaw','G5DgNizuG3jXkjPp6UaGrA','000001000001000069000015000006','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('jrWJ6nHXkqgFbml7BZ9chw','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000016','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('Ys6f3vpe0y1uRcaCJ2TlFw','1qFjOEiILIwr1xB5_ebppQ','000001000001000069000017','published','WebGUI::Asset::Template',1273032722,'3','997995720','3',NULL,0,NULL),('default_CS_unsubscribe','GNOAsX98vCsl0JRwfwL-gg','000001000001000008000030','published','WebGUI::Asset::Template',1274238758,'3','997995720','3',NULL,0,NULL),('mfHGkp6t9gdclmzN33OEnw','PBasset000000000000002','000001000001000070','published','WebGUI::Asset::Template',1277868927,'3','997995720','3',NULL,0,NULL),('l0guT3vTR3B8cL6vtP-g3A','2TqQc4OISddWCZmRY1_m8A','000001000002000004000002','published','WebGUI::Asset::Wobject::Article',1271445611,'1','997995720','3',NULL,0,NULL),('k2Qj03FrAOXYra8kDJYYXw','2TqQc4OISddWCZmRY1_m8A','000001000002000004000003','published','WebGUI::Asset::Wobject::Article',1271357513,'1','997995720','3',NULL,0,NULL),('ksSfkZdsr0uC62NwIk6hFQ','2TqQc4OISddWCZmRY1_m8A','000001000002000004000004','published','WebGUI::Asset::Wobject::Article',1271356973,'1','997995720','3',NULL,0,NULL),('nWxS5jnA3o3DgPEwBeR7yQ','2TqQc4OISddWCZmRY1_m8A','000001000002000004000005','published','WebGUI::Asset::Wobject::Article',1271357239,'1','997995720','3',NULL,0,NULL),('AssetReportFolder00001','PBasset000000000000002','000001000001000071','published','WebGUI::Asset::Wobject::Folder',1281501163,'3','997995720','3',NULL,0,NULL),('sJtcUCfn0CVbKdb4QM61Yw','AssetReportFolder00001','000001000001000071000001','published','WebGUI::Asset::Template',1281501163,'3','997995720','3',NULL,0,NULL),('N7uMnnicbyTEulcuRi1sSg','PBasset000000000000003','000001000003000001','published','WebGUI::Asset::Wobject::Folder',1284523698,'3','997995720','3',NULL,0,NULL),('bCGr7FRtZt-XYlBVUEJBjw','N7uMnnicbyTEulcuRi1sSg','000001000003000001000001','published','WebGUI::Asset::File::Image',1278013724,'3','997995720','3',NULL,0,NULL),('A3T7jpTBKLYws1h5mJ0t8A','RrV4aAPnn4dM0ZcU3OXnlw','000001000001000043000007','published','WebGUI::Asset::Snippet',1286941427,'3','997995720','3',NULL,0,NULL),('sK_0zVw4kwdJ1sqREIsSzA','1z9J1O08n_7gVVlBwSRBJQ','000001000001000005000011','published','WebGUI::Asset::Template',1288142107,'3','997995720','3',NULL,0,NULL),('_cD6DLM_Fs5IlrLeWUjrjg','PBasset000000000000002','000001000001000072','published','WebGUI::Asset::Wobject::Folder',1288142107,'3','997995720','3',NULL,0,NULL),('lYhMheuuLROK_iNjaQuPKg','_cD6DLM_Fs5IlrLeWUjrjg','000001000001000072000001','published','WebGUI::Asset::Template',1288142107,'3','997995720','3',NULL,0,NULL);
ALTER TABLE `asset` ENABLE KEYS;
ALTER TABLE `assetAspectRssFeed` DISABLE KEYS;
INSERT INTO `assetAspectRssFeed` VALUES ('fK-HMSboA3uu0c1KYkYspA',1124395696,25,NULL,'','',NULL,'','','rss\natom'),('pbproto000000000000002',1163019036,25,NULL,'','',NULL,'','','');
ALTER TABLE `assetAspectRssFeed` ENABLE KEYS;
ALTER TABLE `assetData` DISABLE KEYS;
INSERT INTO `assetData` VALUES ('PBasset000000000000001',1124395696,'3','pbversion0000000000001','approved','Root','Root','root','3','7','3',NULL,0,1,0,0,0,158,NULL,0,1,0,1242380151,NULL,0),('PBasset000000000000002',1124395696,'3','pbversion0000000000001','approved','Import Node','Import','root/import','3','7','12',NULL,0,1,0,0,0,309,NULL,0,1,0,1242380151,NULL,0),('Vzv1pWpg_w6R_o-b0rM2qQ',1147642515,'3','pbversion0000000000001','approved','Ad','Ad','home/ad2','3','7','4',NULL,0,1,0,0,0,2155189,NULL,0,1,0,1280279777,NULL,0),('fK-HMSboA3uu0c1KYkYspA',1124395696,'3','pbversion0000000000001','approved','The Latest News','The Latest News','the_latest_news/the_latest_news','3','7','3',NULL,0,1,0,0,0,524,NULL,0,1,0,1285733456,NULL,0),('7-0-style0000000000003',1147642492,'3','pbversion0000000000001','approved','css01.css','css01.css','style1/css01.css','3','7','12',NULL,0,0,0,0,0,9086,NULL,0,1,0,1285733366,NULL,0),('PBnav00000000000000001',1124395696,'3','pbversion0000000000001','approved','crumbTrail','crumbTrail','crumbtrail','3','7','12',NULL,0,1,0,0,0,371,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000014',1124395696,'3','pbversion0000000000001','approved','FlexMenu','FlexMenu','flexmenu','3','7','12',NULL,0,1,0,0,0,353,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000015',1124395696,'3','pbversion0000000000001','approved','currentMenuVertical','currentMenuVertical','currentmenuvertical','3','7','12',NULL,0,1,0,0,0,394,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000016',1124395696,'3','pbversion0000000000001','approved','currentMenuHorizontal','currentMenuHorizontal','currentmenuhorizontal','3','7','12',NULL,0,1,0,0,0,400,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000017',1124395696,'3','pbversion0000000000001','approved','PreviousDropMenu','PreviousDropMenu','previousdropmenu','3','7','12',NULL,0,1,0,0,0,388,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000018',1124395696,'3','pbversion0000000000001','approved','previousMenuVertical','previousMenuVertical','previousmenuvertical','3','7','12',NULL,0,1,0,0,0,398,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000019',1124395696,'3','pbversion0000000000001','approved','previousMenuHorizontal','previousMenuHorizontal','previousmenuhorizontal','3','7','12',NULL,0,1,0,0,0,404,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000020',1124395696,'3','pbversion0000000000001','approved','rootmenu','rootmenu','rootmenu','3','7','12',NULL,0,1,0,0,0,355,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000021',1124395696,'3','pbversion0000000000001','approved','SpecificDropMenu','SpecificDropMenu','specificdropmenu','3','7','12',NULL,0,1,0,0,0,379,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000002',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuVertical','SpecificSubMenuVertical','specificsubmenuvertical','3','7','12',NULL,0,1,0,0,0,400,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000006',1124395696,'3','pbversion0000000000001','approved','SpecificSubMenuHorizontal','SpecificSubMenuHorizontal','specificsubmenuhorizontal','3','7','12',NULL,0,1,0,0,0,406,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000007',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuVertical','TopLevelMenuVertical','toplevelmenuvertical','3','7','12',NULL,0,1,0,0,0,391,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000008',1124395696,'3','pbversion0000000000001','approved','TopLevelMenuHorizontal','TopLevelMenuHorizontal','toplevelmenuhorizontal','3','7','12',NULL,0,1,0,0,0,397,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000009',1124395696,'3','pbversion0000000000001','approved','RootTab','RootTab','roottab','3','7','12',NULL,0,1,0,0,0,352,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000010',1124395696,'3','pbversion0000000000001','approved','TopDropMenu','TopDropMenu','topdropmenu','3','7','12',NULL,0,1,0,0,0,364,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000011',1124395696,'3','pbversion0000000000001','approved','dtree','dtree','dtree','3','7','12',NULL,0,1,0,0,0,352,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000012',1124395696,'3','pbversion0000000000001','approved','coolmenu','coolmenu','coolmenu','3','7','12',NULL,0,1,0,0,0,356,NULL,0,1,0,1247779653,NULL,0),('PBnav00000000000000013',1124395696,'3','pbversion0000000000001','approved','Synopsis','Synopsis','synopsis','3','7','12',NULL,0,1,0,0,0,367,NULL,0,1,0,1247779653,NULL,0),('7-0-style0000000000006',1147642493,'3','pbversion0000000000001','approved','main_bg.gif','main_bg.gif','style1/main_bg.gif','3','7','12',NULL,0,0,0,0,0,1149,NULL,0,1,0,1242380143,NULL,0),('PBrichedit000000000002',1124395696,'3','pbversion0000000000001','approved','Forum Rich Edit','Forum Rich Edit','forum_rich_edit','3','7','12',NULL,0,0,0,0,0,873,NULL,0,1,0,1242380152,NULL,0),('7-0-style0000000000068',1147642510,'3','pbversion0000000000001','approved','spacer.gif','spacer.gif','style3/spacer.gif','3','7','12',NULL,0,0,0,0,0,358,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000066',1147642509,'3','pbversion0000000000001','approved','nav_bg_on.jpg','nav_bg_on.jpg','style3/nav_bg_on.jpg','3','7','12',NULL,0,0,0,0,0,658,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000067',1147642509,'3','pbversion0000000000001','approved','pb.jpg','pb.jpg','style3/pb.jpg','3','7','12',NULL,0,0,0,0,0,24981,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000062',1147642508,'3','pbversion0000000000001','approved','nav_bg1.jpg','nav_bg1.jpg','style3/nav_bg1.jpg','3','7','12',NULL,0,0,0,0,0,672,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000063',1147642508,'3','pbversion0000000000001','approved','nav_bg1_on.jpg','nav_bg1_on.jpg','style3/nav_bg1_on.jpg','3','7','12',NULL,0,0,0,0,0,683,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000064',1147642509,'3','pbversion0000000000001','approved','nav_bg2.jpg','nav_bg2.jpg','style3/nav_bg2.jpg','3','7','12',NULL,0,0,0,0,0,675,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000065',1147642509,'3','pbversion0000000000001','approved','nav_bg2_on.jpg','nav_bg2_on.jpg','style3/nav_bg2_on.jpg','3','7','12',NULL,0,0,0,0,0,688,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000061',1147642508,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style3/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,669,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000057',1147642507,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style3/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,639,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000058',1147642507,'3','pbversion0000000000001','approved','main_bottom.jpg','main_bottom.jpg','style3/main_bottom.jpg','3','7','12',NULL,0,0,0,0,0,2630,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000060',1147642508,'3','pbversion0000000000001','approved','main_top_bg.jpg','main_top_bg.jpg','style3/main_top_bg.jpg','3','7','12',NULL,0,0,0,0,0,687,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000054',1147642506,'3','pbversion0000000000001','approved','header_bg.jpg','header_bg.jpg','style3/header_bg.jpg','3','7','12',NULL,0,0,0,0,0,715,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000055',1147642506,'3','pbversion0000000000001','approved','header_left.jpg','header_left.jpg','style3/header_left.jpg','3','7','12',NULL,0,0,0,0,0,23983,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000056',1147642506,'3','pbversion0000000000001','approved','header_right.jpg','header_right.jpg','style3/header_right.jpg','3','7','12',NULL,0,0,0,0,0,24757,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000053',1147642505,'3','pbversion0000000000001','approved','footer_right.jpg','footer_right.jpg','style3/footer_right.jpg','3','7','12',NULL,0,0,0,0,0,2886,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000052',1147642505,'3','pbversion0000000000001','approved','footer_bg.jpg','footer_bg.jpg','style3/footer_bg.jpg','3','7','12',NULL,0,0,0,0,0,680,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000048',1147642504,'3','pbversion0000000000001','approved','wg.jpg','wg.jpg','style2/wg.jpg','3','7','12',NULL,0,0,0,0,0,20795,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000046',1147642504,'3','pbversion0000000000001','approved','rightCol_bg.jpg','rightCol_bg.jpg','style2/rightcol_bg.jpg','3','7','12',NULL,0,0,0,0,0,720,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000043',1147642503,'3','pbversion0000000000001','approved','pb.jpg','pb.jpg','style2/pb.jpg','3','7','12',NULL,0,0,0,0,0,22948,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000044',1147642503,'3','pbversion0000000000001','approved','pb_wg.jpg','pb_wg.jpg','style2/pb_wg.jpg','3','7','12',NULL,0,0,0,0,0,2720,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000040',1147642502,'3','pbversion0000000000001','approved','navbar_right.jpg','navbar_right.jpg','style2/navbar_right.jpg','3','7','12',NULL,0,0,0,0,0,960,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000041',1147642502,'3','pbversion0000000000001','approved','page_title.jpg','page_title.jpg','style2/page_title.jpg','3','7','12',NULL,0,0,0,0,0,24856,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000042',1147642502,'3','pbversion0000000000001','approved','page_title_bg.jpg','page_title_bg.jpg','style2/page_title_bg.jpg','3','7','12',NULL,0,0,0,0,0,720,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000038',1147642501,'3','pbversion0000000000001','approved','navbar_bg.jpg','navbar_bg.jpg','style2/navbar_bg.jpg','3','7','12',NULL,0,0,0,0,0,625,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000039',1147642502,'3','pbversion0000000000001','approved','navbar_left.jpg','navbar_left.jpg','style2/navbar_left.jpg','3','7','12',NULL,0,0,0,0,0,663,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000036',1147642501,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style2/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,764,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000037',1147642501,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style2/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,602,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000033',1147642500,'3','pbversion0000000000001','approved','css02.css','css02.css','style2/css02.css','3','7','12',NULL,0,0,0,0,0,5530,NULL,0,1,0,1285733366,NULL,0),('7-0-style0000000000034',1147642500,'3','pbversion0000000000001','approved','leftCol_header.jpg','leftCol_header.jpg','style2/leftcol_header.jpg','3','7','12',NULL,0,0,0,0,0,10987,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000035',1147642501,'3','pbversion0000000000001','approved','leftCol_header02.jpg','leftCol_header02.jpg','style2/leftcol_header02.jpg','3','7','12',NULL,0,0,0,0,0,4606,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000030',1147642499,'3','pbversion0000000000001','approved','webgui_btn.jpg','webgui_btn.jpg','style1/webgui_btn.jpg','3','7','12',NULL,0,0,0,0,0,5180,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000031',1147642500,'3','pbversion0000000000001','approved','WebGUI 7 Style 2','WebGUI 7 Style 2','root/import/webgui-7-style-2','3','7','12',NULL,0,0,0,0,0,325,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000032',1147642500,'3','pbversion0000000000001','approved','context_bg.jpg','context_bg.jpg','style2/context_bg.jpg','3','7','12',NULL,0,0,0,0,0,661,NULL,0,1,0,1242380143,NULL,0),('PBnav000000style01lvl2',1147642499,'3','pbversion0000000000001','approved','Style 01 Nav lvl2','untitled','style1_nav_lvl2','3','7','12',NULL,0,0,0,0,0,1713,NULL,0,1,0,1285733358,NULL,0),('7-0-style0000000000026',1147642499,'3','pbversion0000000000001','approved','RootTab Level 1','RootTab Level 1','roottab_level1','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1242380143,NULL,0),('stevenav00000000000001',1147642499,'3','pbversion0000000000001','approved','Style 01 Nav','Style 01 Nav','style1_nav','3','7','12',NULL,0,0,0,0,0,1682,NULL,0,1,0,1285733365,NULL,0),('7-0-style0000000000025',1147642498,'3','pbversion0000000000001','approved','RootTab Level 0','RootTab Level 0','roottab_level0','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000022',1147642497,'3','pbversion0000000000001','approved','nav_bg.jpg','nav_bg.jpg','style1/nav_bg.jpg','3','7','12',NULL,0,0,0,0,0,1109,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000023',1147642498,'3','pbversion0000000000001','approved','nav_on.jpg','nav_on.jpg','style1/nav_on.jpg','3','7','12',NULL,0,0,0,0,0,919,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000024',1147642498,'3','pbversion0000000000001','approved','orange_left01.jpg','orange_left01.jpg','style1/orange_left01.jpg','3','7','12',NULL,0,0,0,0,0,2747,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000018',1147642496,'3','pbversion0000000000001','approved','nav2_off_left.jpg','nav2_off_left.jpg','style1/nav2_off_left.jpg','3','7','12',NULL,0,0,0,0,0,752,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000019',1147642497,'3','pbversion0000000000001','approved','nav2_off_right.jpg','nav2_off_right.jpg','style1/nav2_off_right.jpg','3','7','12',NULL,0,0,0,0,0,748,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000017',1147642496,'3','pbversion0000000000001','approved','nav2_off_center.jpg','nav2_off_center.jpg','style1/nav2_off_center.jpg','3','7','12',NULL,0,0,0,0,0,837,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000015',1147642496,'3','pbversion0000000000001','approved','nav1_on_right.jpg','nav1_on_right.jpg','style1/nav1_on_right.jpg','3','7','12',NULL,0,0,0,0,0,1134,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000014',1147642495,'3','pbversion0000000000001','approved','nav1_on_left.jpg','nav1_on_left.jpg','style1/nav1_on_left.jpg','3','7','12',NULL,0,0,0,0,0,1195,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000013',1147642495,'3','pbversion0000000000001','approved','nav1_on.jpg','nav1_on.jpg','style1/nav1_on.jpg','3','7','12',NULL,0,0,0,0,0,2426,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000011',1147642495,'3','pbversion0000000000001','approved','nav1_off_left.jpg','nav1_off_left.jpg','style1/nav1_off_left.jpg','3','7','12',NULL,0,0,0,0,0,1230,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000012',1147642495,'3','pbversion0000000000001','approved','nav1_off_right.jpg','nav1_off_right.jpg','style1/nav1_off_right.jpg','3','7','12',NULL,0,0,0,0,0,1178,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000010',1147642494,'3','pbversion0000000000001','approved','nav1_off_center.jpg','nav1_off_center.jpg','style1/nav1_off_center.jpg','3','7','12',NULL,0,0,0,0,0,1468,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000009',1147642494,'3','pbversion0000000000001','approved','nav1_off.jpg','nav1_off.jpg','style1/nav1_off.jpg','3','7','12',NULL,0,0,0,0,0,2591,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000007',1147642493,'3','pbversion0000000000001','approved','main_bg.jpg','main_bg.jpg','style1/main_bg.jpg','3','7','12',NULL,0,0,0,0,0,1149,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000001',1147642492,'3','pbversion0000000000001','approved','WebGUI 7 Style 1','WebGUI 7 Style 1','root/import/webgui-7-style-1','3','7','12',NULL,0,0,0,0,0,325,NULL,0,1,0,1242380142,NULL,0),('SynConXSLT000000000001',1124395707,'3','pbversion0000000000001','approved','RSS 0.9 XSLT Stylesheet','RSS 0.9 XSLT','xslt/rss0.9.xsl','3','7','12',NULL,0,0,0,0,0,5040,NULL,0,1,0,1285733366,NULL,0),('SynConXSLT000000000002',1124395707,'3','pbversion0000000000001','approved','RSS 0.91 XSLT Stylesheet','RSS 0.91 XSLT','xslt/rss0.91.xsl','3','7','12',NULL,0,0,0,0,0,4717,NULL,0,1,0,1285733366,NULL,0),('SynConXSLT000000000003',1124395707,'3','pbversion0000000000001','approved','RSS 1.0 XSLT Stylesheet','RSS 1.0 XSLT','xslt/rss1.0.xsl','3','7','12',NULL,0,0,0,0,0,5186,NULL,0,1,0,1285733366,NULL,0),('SynConXSLT000000000004',1124395707,'3','pbversion0000000000001','approved','RSS 2.0 XSLT Stylesheet','RSS 2.0 XSLT','xslt/rss2.0.xsl','3','7','12',NULL,0,0,0,0,0,4852,NULL,0,1,0,1285733366,NULL,0),('PBtmpl0000000000000036',1129049186,'3','pbversion0000000000001','approved','Default Admin Toggle Macro','Default Admin Toggle Macro','default_admin_toggle_macro','3','7','12',NULL,0,1,0,0,0,448,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000037',1129049186,'3','pbversion0000000000001','approved','Default Account Macro','Default Account Macro','default_account_macro','3','7','12',NULL,0,1,0,0,0,479,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000038',1129049186,'3','pbversion0000000000001','approved','Default Editable Toggle Macro','Default Editable Toggle Macro','default_editable_toggle_macro','3','7','12',NULL,0,1,0,0,0,460,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000040',1129049186,'3','pbversion0000000000001','approved','Default Group Add Macro','Default Group Add Macro','default_group_add_macro','3','7','12',NULL,0,1,0,0,0,432,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000041',1129049186,'3','pbversion0000000000001','approved','Default Group Delete Macro','Default Group Delete Macro','default_group_delete_macro','3','7','12',NULL,0,1,0,0,0,444,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000042',1129049186,'3','pbversion0000000000001','approved','Default Homelink','Default Homelink','default_homelink','3','7','12',NULL,0,1,0,0,0,459,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000043',1129049186,'3','pbversion0000000000001','approved','Default LoginToggle','Default LoginToggle','default_logintoggle','3','7','12',NULL,0,1,0,0,0,475,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000045',1129049186,'3','pbversion0000000000001','approved','Default Make Printable','Default Make Printable','default_make_printable','3','7','12',NULL,0,1,0,0,0,500,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000091',1129049189,'3','pbversion0000000000001','approved','File no icon','File no icon','file_no_icon','3','7','12',NULL,0,1,0,0,0,391,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000140',1129573244,'3','pbversion0000000000001','approved','Default Shortcut','Default Shortcut','pbtmpl0000000000000140','3','7','12',NULL,0,1,0,0,0,1732,NULL,0,1,0,1285733361,NULL,0),('PBtmplHelp000000000001',1147642410,'3','pbversion0000000000001','approved','Help','Help','root/import/adminconsole/help','3','7','12',NULL,0,0,0,0,0,2221,'<style type=\"text/css\">\ndd {\n	margin-bottom: 15px;\n}\n\ndt {\n	font-weight: bold;	\n}\n</style>\n\n',0,1,0,1288142105,'<style type=\"text/css\">dd{margin-bottom:15px;}dt{font-weight:bold;}</style>',0),('ProjectManagerTMPL0004',1222574693,'3','pbversion0000000000001','approved','Default Project Manager Edit Task','Default Project Manager Edit Task','default-pm-template-edit-task','3','7','12',NULL,0,0,0,0,0,8779,'<style type=\"text/css\">\r\n.PM_small {\r\n	font-size:8pt;\r\n}\r\ntr.clearNoBG a {\r\n	text-decoration:none;\r\n	color:navy;\r\n}\r\n</style>\r\n',0,1,0,1285733362,'<style type=\"text/css\">.PM_small{font-size:8pt;}tr.clearNoBG a{text-decoration:none;color:navy;}</style>',0),('7-0-style0000000000071',1147642511,'3','pbversion0000000000001','approved','wg.jpg','wg.jpg','style3/wg.jpg','3','7','12',NULL,0,0,0,0,0,27499,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000070',1147642510,'3','pbversion0000000000001','approved','Style3 Coolmenu','Style3 Coolmenu','style3_coolmenu','3','7','12',NULL,0,0,0,0,0,377,NULL,0,1,0,1242380145,NULL,0),('7-0-style0000000000004',1147642493,'3','pbversion0000000000001','approved','gui_bottom.jpg','gui_bottom.jpg','style1/gui_bottom.jpg','3','7','12',NULL,0,0,0,0,0,11011,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000002',1147642492,'3','pbversion0000000000001','approved','body_bg.jpg','body_bg.jpg','style1/body_bg.jpg','3','7','12',NULL,0,0,0,0,0,598,NULL,0,1,0,1242380142,NULL,0),('PBtmpl0000000000000047',1147642414,'3','pbversion0000000000001','approved','Default Message Board','Default Message Board','default_message_board','3','7','12',NULL,0,1,0,0,0,5637,'<style type=\"text/css\">\n.defaultMessageBoard {\n\n}\n.defaultMessageBoard .tableHeader{\n	font-weight:bold;\n	border-bottom:solid gray 3px;\n	text-align:center;\n}\n.defaultMessageBoard td {\n	font-family:arial;\n	font-size:9pt;\n	border-bottom:solid gray 1px;\n}\n.defaultMessageBoard td a {\n	color:#29587E;\n}\n.defaultMessageBoard td.even {\n	background-color:#DADADA;\n	border-bottom:solid gray 1px;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n</style>',0,1,0,1285733359,'<style type=\"text/css\">.defaultMessageBoard{}.defaultMessageBoard .tableHeader{font-weight:bold;border-bottom:solid gray 3px;text-align:center;}.defaultMessageBoard td{font-family:arial;font-size:9pt;border-bottom:solid gray 1px;}.defaultMessageBoard td a{color:#29587E;}.defaultMessageBoard td.even{background-color:#DADADA;border-bottom:solid gray 1px;}h2{font-family:arial;margin-top:3px;margin-bottom:3px;}</style>',0),('TimeTrackingTMPL000002',1147642417,'3','pbversion0000000000001','approved','Default Time Tracking Manager View','Default Time Tracking Manager View','default-tt-template-manager','3','7','12',NULL,0,0,0,0,0,408,'	',0,1,0,1285733362,NULL,0),('PBtmpl0000000000000057',1147642418,'3','pbversion0000000000001','approved','Default WebGUI Yes/No Prompt','Default WebGUI Yes/No Prompt','default_webgui_yes/no_prompt','3','7','12',NULL,0,1,0,0,0,797,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000107',1147642420,'3','pbversion0000000000001','approved','File with size','File with size','file_with_size','3','7','12',NULL,0,1,0,0,0,661,NULL,0,1,0,1285733361,NULL,0),('WVtmpl0000000000000001',1147642426,'3','pbversion0000000000001','approved','Random Thread Macro Default Template','Random Thread Macro Default Template','randomthread-template','3','7','12',NULL,0,0,0,0,0,9218,NULL,0,1,0,1285733363,NULL,0),('7-0-style0000000000005',1147642493,'3','pbversion0000000000001','approved','header.jpg','header.jpg','style1/header.jpg','3','7','12',NULL,0,0,0,0,0,45014,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000008',1147642494,'3','pbversion0000000000001','approved','nav1_center_on.jpg','nav1_center_on.jpg','style1/nav1_center_on.jpg','3','7','12',NULL,0,0,0,0,0,1382,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000045',1147642503,'3','pbversion0000000000001','approved','pb_wg_bg.jpg','pb_wg_bg.jpg','style2/pb_wg_bg.jpg','3','7','12',NULL,0,0,0,0,0,21720,NULL,0,1,0,1242380144,NULL,0),('7-0-style0000000000021',1147642497,'3','pbversion0000000000001','approved','nav2_on_right.jpg','nav2_on_right.jpg','style1/nav2_on_right.jpg','3','7','12',NULL,0,0,0,0,0,720,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000020',1147642497,'3','pbversion0000000000001','approved','nav2_on_left.jpg','nav2_on_left.jpg','style1/nav2_on_left.jpg','3','7','12',NULL,0,0,0,0,0,732,NULL,0,1,0,1242380143,NULL,0),('7-0-style0000000000016',1147642496,'3','pbversion0000000000001','approved','nav2_center_on.jpg','nav2_center_on.jpg','style1/nav2_center_on.jpg','3','7','12',NULL,0,0,0,0,0,807,NULL,0,1,0,1242380143,NULL,0),('PBasset000000000000003',1147642437,'3','pbversion0000000000001','approved','Media','Media','media','3','7','12',NULL,0,0,0,0,0,296,NULL,0,1,0,1242380151,NULL,0),('nbSrhXZQuxIjhWFaFPSuVA',1147642465,'3','pbversion0000000000001','approved','AdminConsole','AdminConsole','root/import/adminconsole','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1242380150,NULL,0),('S1A9iAwKcQQ6P20uTqw-Ew',1147642468,'3','pbversion0000000000001','approved','Dashboard','Dashboard','root/import/dashboard','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380162,NULL,0),('71e17KeduiXgODLMlUxiow',1222803352,'3','pbversion0000000000001','approved','project','project','root/import/projectmanager/project','3','7','12',NULL,0,0,0,0,0,342,NULL,0,1,0,1242380145,NULL,0),('N13SD1Fpqk00UgBt1Z8ivQ',1147642470,'3','pbversion0000000000001','approved','HttpProxy','HttpProxy','root/import/httpproxy','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380150,NULL,0),('3uuBf8cYuj1sew2OJXl9tg',1147642470,'3','pbversion0000000000001','approved','InOutBoard','InOutBoard','root/import/inoutboard','3','7','12',NULL,0,0,0,0,0,307,NULL,0,1,0,1242380142,NULL,0),('ProjectManagerTMPL0002',1222574693,'3','pbversion0000000000001','approved','Default Project Display','Default Project Display','default-pm-template-project-display','3','7','12',NULL,0,0,0,0,0,13074,'<style type=\"text/css\">\r\n	body, html {\r\n		margin:0px;\r\n		padding:0px;\r\n	}\r\n	.project {\r\n		position:relative;\r\n		margin-top:5px;\r\n		margin-left:5px;\r\n	}\r\n	.project td {\r\n		border:solid silver 1px;\r\n		border-bottom:solid gray 1px;\r\n		font-size:9pt;\r\n		font-family:arial;		\r\n	}\r\n	.project a {\r\n	    color:#000000;\r\n		font-weight: normal;\r\n		font-size: 9pt;\r\n		text-decoration: none;\r\n	}\r\n	\r\n	.project a:hover {\r\n	    color:#7AB7E9;\r\n		font-weight: normal;\r\n		font-size: 9pt;\r\n		text-decoration: none;\r\n	}\r\n	\r\n	.taskname {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 295px;\r\n    }\r\n	.taskduration {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 25px;\r\n	}\r\n	.taskdate {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 68px;\r\n	}\r\n	.taskdependant {\r\n	   font-family: verdana;\r\n	   font-size: 10px;\r\n	   font-weight: normal;\r\n	   color: black;\r\n	   width: 20px;\r\n	}\r\n	tr.monthNames td {		\r\n		text-align:center;		\r\n	}\r\n	tr.dates td {\r\n		width:16px;\r\n	}\r\n	div.scroller {		\r\n		overflow:scroll;		\r\n		position:relative;\r\n		width:400px;		\r\n	}\r\n	\r\n	* html div.scroller {\r\n		overflow-x:scroll;\r\n	}\r\n	\r\n	td.empty {\r\n		background-color:transparent;\r\n		border-style:none;\r\n		height:20px;\r\n	}\r\n	\r\n	div.barPositions {\r\n		position:relative;\r\n	}\r\n	div.projectBar {\r\n		position:absolute;\r\n		height:10px;\r\n		z-index:2;\r\n		padding:0px;\r\n		margin:0px;\r\n		font-size:1pt;\r\n	}\r\n	div.statusBar {	\r\n		background-color:#000;\r\n		position:absolute;	\r\n		height:5px;\r\n		z-index:3;\r\n		padding:0px;\r\n		top:2px;\r\n		margin:0px;		\r\n		font-size:1pt;		\r\n	}\r\n	\r\n	div.projectLineH {		\r\n		background: url(\'images/dot.gif\') top repeat-x;		\r\n		font-size:1pt;\r\n		text-align:right;\r\n		position:absolute;\r\n	}		\r\n	div.projectLineV {\r\n		width:1px;\r\n		background-color:black;\r\n		position:relative;\r\n		font-size:1pt;	\r\n		height:100%;\r\n		float:right;\r\n	}\r\n	\r\n	div.projectLabel {\r\n		position:absolute;\r\n		margin-top:-3px;\r\n		white-space:nowrap;\r\n		font-family: verdana;\r\n		font-size:8px;\r\n	}\r\n	\r\n	div.milestone {\r\n		color:#000000;\r\n		position:absolute;\r\n		z-index:4;\r\n		margin:0px;\r\n		padding:0px;		\r\n		margin-top:-3px;\r\n		font-size: 10px;\r\n		font-family: times;\r\n	}\r\n	\r\n	#links {\r\n		margin-top:7px;\r\n		margin-left:5px;\r\n		font-family:arial;\r\n		font-size:9pt;\r\n	}\r\n	\r\n	#links a {\r\n		color:#7AB7E9;\r\n	}\r\n</style>\r\n\r\n<style>\r\n.popUp {\r\n			width:100%;\r\n			border:solid black 0px;\r\n			background-color:#F5F5F5;\r\n		}\r\n		.popUp td {\r\n			font-size:9pt;	\r\n			font-family:arial;\r\n			border-top:solid #E0E0E0 1px;\r\n		}	\r\n		.popUp tr.clear td {\r\n			border-style:none;\r\n			background-color:#F0F0F0;\r\n		}\r\n		.popUp tr.clearNoBG td {\r\n			border-style:none;\r\n		}\r\n		.popUp td.header {\r\n			font-weight:bold;\r\n		}\r\n		.popUp td span.header {\r\n			font-weight:bold;\r\n		}\r\n		a.saveBtn {\r\n			width:40px;\r\n			height:15px;\r\n			background-color:silver;\r\n			padding:1px;\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:white;\r\n			border:solid gray 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;\r\n			display:block;\r\n			float:right;\r\n			text-align:center;\r\n		}\r\n		a.saveBtn:hover {\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n</style>\r\n',0,1,0,1285733362,'<style type=\"text/css\">body,html{margin:0px;padding:0px;}.project{position:relative;margin-top:5px;margin-left:5px;}.project td{border:solid silver 1px;border-bottom:solid gray 1px;font-size:9pt;font-family:arial;}.project a{color:#000000;font-weight:normal;font-size:9pt;text-decoration:none;}.project a:hover{color:#7AB7E9;font-weight:normal;font-size:9pt;text-decoration:none;}.taskname{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:295px;}.taskduration{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:25px;}.taskdate{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:68px;}.taskdependant{font-family:verdana;font-size:10px;font-weight:normal;color:black;width:20px;}tr.monthNames td{text-align:center;}tr.dates td{width:16px;}div.scroller{overflow:scroll;position:relative;width:400px;}* html div.scroller{overflow-x:scroll;}td.empty{background-color:transparent;border-style:none;height:20px;}div.barPositions{position:relative;}div.projectBar{position:absolute;height:10px;z-index:2;padding:0px;margin:0px;font-size:1pt;}div.statusBar{background-color:#000;position:absolute;height:5px;z-index:3;padding:0px;top:2px;margin:0px;font-size:1pt;}div.projectLineH{background:url(\'images/dot.gif\') top repeat-x;font-size:1pt;text-align:right;position:absolute;}div.projectLineV{width:1px;background-color:black;position:relative;font-size:1pt;height:100%;float:right;}div.projectLabel{position:absolute;margin-top:-3px;white-space:nowrap;font-family:verdana;font-size:8px;}div.milestone{color:#000000;position:absolute;z-index:4;margin:0px;padding:0px;margin-top:-3px;font-size:10px;font-family:times;}#links{margin-top:7px;margin-left:5px;font-family:arial;font-size:9pt;}#links a{color:#7AB7E9;}</style><style>\r\n.popUp {\r\n			width:100%;\r\n			border:solid black 0px;\r\n			background-color:#F5F5F5;\r\n		}\r\n		.popUp td {\r\n			font-size:9pt;	\r\n			font-family:arial;\r\n			border-top:solid #E0E0E0 1px;\r\n		}	\r\n		.popUp tr.clear td {\r\n			border-style:none;\r\n			background-color:#F0F0F0;\r\n		}\r\n		.popUp tr.clearNoBG td {\r\n			border-style:none;\r\n		}\r\n		.popUp td.header {\r\n			font-weight:bold;\r\n		}\r\n		.popUp td span.header {\r\n			font-weight:bold;\r\n		}\r\n		a.saveBtn {\r\n			width:40px;\r\n			height:15px;\r\n			background-color:silver;\r\n			padding:1px;\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:white;\r\n			border:solid gray 1px;\r\n			text-decoration:none;\r\n			font-weight:bold;\r\n			display:block;\r\n			float:right;\r\n			text-align:center;\r\n		}\r\n		a.saveBtn:hover {\r\n			background-color:#F0F0F0;\r\n			color:gray;\r\n		}		\r\n</style>',0),('cj2y4papTVGZRFdwTI-_fw',1147642475,'3','pbversion0000000000001','approved','MessageBoard','MessageBoard','root/import/messageboard','3','7','12',NULL,0,0,0,0,0,313,NULL,0,1,0,1242380147,NULL,0),('bBzO4CWjqU_ile3gf5Iypw',1147642475,'3','pbversion0000000000001','approved','MultiSearch','MultiSearch','root/import/multisearch','3','7','12',NULL,0,0,0,0,0,310,NULL,0,1,0,1242380147,NULL,0),('Da6KWn805L4B5e4HFgQRQA',1147642479,'3','pbversion0000000000001','approved','Shortcut','Shortcut','root/import/shortcut','3','7','12',NULL,0,0,0,0,0,301,NULL,0,1,0,1242380148,NULL,0),('bbiA9Zq5Gy2oCFBlILO3QA',1147642480,'3','pbversion0000000000001','approved','SQLReport','SQLReport','root/import/sqlreport','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380147,NULL,0),('Efe2W0UgrSRDltNJ87jlfg',1147642480,'3','pbversion0000000000001','approved','StockData','StockData','root/import/stockdata','3','7','12',NULL,0,0,0,0,0,304,NULL,0,1,0,1242380148,NULL,0),('9wKWdum0_8z-OhhquWLtSQ',1147642483,'3','pbversion0000000000001','approved','WeatherData','WeatherData','root/import/weatherdata','3','7','12',NULL,0,0,0,0,0,310,NULL,0,1,0,1242380146,NULL,0),('CSN-ZON7Uwv8kxf3F1fh5Q',1147642484,'3','pbversion0000000000001','approved','ZipArchiveAsset','ZipArchiveAsset','root/import/ziparchiveasset','3','7','12',NULL,0,0,0,0,0,322,NULL,0,1,0,1242380147,NULL,0),('TCtybxdqmdwdvRn555zpCQ',1147642484,'3','pbversion0000000000001','approved','RichEdit','RichEdit','root/import/richedit','3','7','12',NULL,0,0,0,0,0,301,NULL,0,1,0,1242380163,NULL,0),('PBtmpl0000000000000044',1148579524,'3','pbversion0000000000001','approved','Default Login Box','Default Login Box','default_login_box','3','7','12',NULL,0,1,0,0,0,1884,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000092',1148579524,'3','pbversion0000000000001','approved','Horizontal Login Box','Horizontal Login Box','horizontal_login_box','3','7','12',NULL,0,1,0,0,0,2082,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000039',1154535073,'3','pbversion0000000000001','approved','Default File Macro','Default File Macro','default_file_macro','3','7','12',NULL,0,1,0,0,0,630,NULL,0,1,0,1285733359,NULL,0),('ProjectManagerTMPL0006',1157679165,'3','pbversion0000000000001','approved','Default Resource List','Default Resource List','default-pm-resource-list','3','7','12',NULL,0,0,0,0,0,1802,NULL,0,1,0,1285733362,NULL,0),('ProjectManagerTMPL0003',1159989349,'3','pbversion0000000000001','approved','Default Project Manager Gantt Chart','Default Project Manager Gantt Chart','default-pm-template-gantt-chart','3','7','12',NULL,0,0,0,0,0,3787,NULL,0,1,0,1285733362,NULL,0),('pbproto000000000000002',1163019036,'3','pbversion0000000000001','approved','Request Tracker','Request Tracker','request-tracker-prototype','3','7','12',NULL,0,0,0,1,0,595,NULL,0,1,0,1263962528,NULL,0),('IOB0000000000000000002',1166019641,'3','pbversion0000000000001','approved','Default InOutBoard Report Template','Default InOutBoard Report Template','iob-report-template','3','7','12',NULL,0,0,0,0,0,2746,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob a {\n	color:#29587E;\n}\n.iob .formDescription {\n	background-color:#DADADA;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}\n</style>',0,1,0,1285733358,'<style type=\"text/css\">.fontSettings{font-family:arial;font-size:9pt;}h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.iob td{font-family:arial;font-size:9pt;border:solid silver 1px;}.iob a{color:#29587E;}.iob .formDescription{background-color:#DADADA;}.pagination{-moz-box-sizing:border-box;background:#C0C0C0;width:100%;text-align:center;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.pagination a{color:white;}</style>',0),('ZipArchiveTMPL00000001',1169738426,'3','pbversion0000000000001','approved','Default Zip Archive Template','Default Zip Archive Template','zip-archive-template','3','7','12',NULL,0,0,0,0,0,1056,NULL,0,1,0,1285733363,NULL,0),('IOB0000000000000000001',1169795123,'3','pbversion0000000000001','approved','Default InOutBoard Template','Default InOutBoard Template','iob-template','3','7','12',NULL,0,0,0,0,0,3850,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.iob {\n			\n}	\n.iob td {	\n	font-family:arial;\n	font-size:9pt;	\n	border:solid silver 1px;\n}\n.iob td.odd {\n	background-color:#DADADA;\n}\n.iob td.noBorder {\n	border:none;\n}	\n.iob a {\n	color:#29587E;\n}\n.pagination	{\n	-moz-box-sizing:border-box;\n	background:#C0C0C0;\n	width:100%;\n	text-align:center;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.pagination a {\n	color:white;\n}   \n\n</style>',0,1,0,1285733358,'<style type=\"text/css\">.fontSettings{font-family:arial;font-size:9pt;}h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.iob{}.iob td{font-family:arial;font-size:9pt;border:solid silver 1px;}.iob td.odd{background-color:#DADADA;}.iob td.noBorder{border:none;}.iob a{color:#29587E;}.pagination{-moz-box-sizing:border-box;background:#C0C0C0;width:100%;text-align:center;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.pagination a{color:white;}</style>',0),('SQLReportDownload00001',1171466654,'3','pbversion0000000000001','approved','SQLReport Download Default Template','untitled','SQLReportDownload0001','3','7','12',NULL,0,0,0,0,0,6386,NULL,0,1,0,1285733362,NULL,0),('newsletter000000000001',1185754569,'3','pbversion0000000000001','approved',' Summary Newsletter (default)',' Summary Newsletter','newsletterdefaulttemplate','3','7','3',NULL,0,0,0,0,0,674,NULL,0,1,0,1285733365,NULL,0),('tempspace0000000000000',1185754574,'3','pbversion0000000000001','approved','Tempspace','Tempspace','tempspace','3','7','3',NULL,0,0,0,0,0,307,NULL,0,1,0,1242380163,NULL,0),('TimeTrackingTMPL000001',1201205738,'3','pbversion0000000000001','approved','Default Time Tracking User View','Default Time Tracking User View','default-tt-template-user','3','7','12',NULL,0,0,0,0,0,18644,'\n	<style type=\"text/css\">\n		.timeTracking02 {			\n			width:850px;\n		}\n		.timeTracking02 td {\n			border:solid silver 1px;\n			border-bottom:solid gray 1px;\n			font-size:9pt;\n			font-family:arial;			\n		}\n		tr.tt_title td {\n			font-weight:bold;			\n			background-color:#F0F0F0;\n			border-style:none;\n			font-size:11pt;\n		}\n		tr.tt_header td {\n			font-weight:bold;\n			text-align:center;		\n		}\n		tr.tt_empty td {\n			border-style:none;\n		}\n		\n		a.PM_blueLink {\n			color:#29587E;\n			text-decoration:none;\n			font-weight:bold;\n		}\n		a.PM_blueLink:hover {\n			text-decoration:underline;\n		}	\n		\n		.pt-select {\n	       font-weight: normal;\n	       color: black;\n  	       width: 175px;\n        }\n		.date-select {\n		   font-weight: normal;\n	           color: black;\n  	           width: 110px;\n		}\n	</style>\n',0,1,0,1285733362,'<style type=\"text/css\">.timeTracking02{width:850px;}.timeTracking02 td{border:solid silver 1px;border-bottom:solid gray 1px;font-size:9pt;font-family:arial;}tr.tt_title td{font-weight:bold;background-color:#F0F0F0;border-style:none;font-size:11pt;}tr.tt_header td{font-weight:bold;text-align:center;}tr.tt_empty td{border-style:none;}a.PM_blueLink{color:#29587E;text-decoration:none;font-weight:bold;}a.PM_blueLink:hover{text-decoration:underline;}.pt-select{font-weight:normal;color:black;width:175px;}.date-select{font-weight:normal;color:black;width:110px;}</style>',0),('CalendarPrintMonth0001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Month','Default Calendar Print Month','root/import/calendar-templates/default-calendar-print-month','3','7','12',NULL,0,0,0,0,0,2454,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1285733357,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('CalendarPrintWeek00001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Week','Default Calendar Print Week','root/import/calendar-templates/default-calendar-print-week','3','7','12',NULL,0,0,0,0,0,2654,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1285733357,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('CalendarPrintDay000001',1204890714,'3','pbversion0000000000001','approved','Default Calendar Print Day','Default Calendar Print Day','root/import/calendar-templates/default-calendar-print-day','3','7','12',NULL,0,0,0,0,0,2394,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1285733357,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('F7MAQ-cpuvQ1KuC7J4P5zQ',1222803673,'3','pbversion0000000000001','approved','View','View','root/import/profile/view','3','7','12',NULL,0,0,0,0,0,326,NULL,0,1,0,1242380148,NULL,0),('Tsg7xmPYv782j6IVz7yHFg',1213244777,'3','pbversion0000000000001','approved','Calendar Templates','Calendar Templates','root/import/calendar-templates','3','7','12',NULL,0,1,0,0,0,353,NULL,0,1,0,1242380164,NULL,0),('NywJYmGWe1f6EBXJnWg9Xg',1222803638,'3','pbversion0000000000001','approved','Profile','Profile','root/import/profile','3','7','12',NULL,0,1,0,0,0,320,NULL,0,1,0,1242380151,NULL,0),('AgyFhx3eXlfZXNp2MkrsiQ',1222803665,'3','pbversion0000000000001','approved','Edit','Edit','root/import/profile/edit','3','7','12',NULL,0,0,0,0,0,326,NULL,0,1,0,1242380146,NULL,0),('TYo2Bwl7aafzTtdHlS-arQ',1211664878,'3','pbversion0000000000001','approved','Product','Product','root/import/product','3','7','12',NULL,0,0,0,0,0,320,NULL,0,1,0,1242380164,NULL,0),('gbnRhcWNk1iQe32LFEB5eQ',1212086102,'3','pbversion0000000000001','approved','Shelf','Shelf','root/import/shelf2','3','7','12',NULL,0,1,0,0,0,315,NULL,0,1,0,1242380149,NULL,0),('6tK47xsaIH-ELw0IBo0uRQ',1210777115,'3','pbversion0000000000001','approved','images','images','root/import/shelf2/images','3','7','12',NULL,0,1,0,0,0,330,NULL,0,1,0,1242380142,NULL,0),('_bZJ9LA_KNekZiFPaP2SeQ',1210777868,'3','pbversion0000000000001','approved','shelf-titles.jpg','shelf-titles.jpg','root/import/shelf2/images/shelf-titles.jpg','3','7','12',NULL,0,1,0,0,0,1038,NULL,0,0,0,1242380165,NULL,0),('4e-_rNs6mSWedZhQ_V5kJA',1210779672,'3','pbversion0000000000001','approved','shelf-ie.css','shelf-ie.css','root/import/shelf2/shelf-ie.css','3','7','12',NULL,0,1,0,0,0,1092,NULL,0,1,0,1285733366,NULL,0),('6D4Z-oruXPS6OlH_Kx8pBg',1209509389,'3','pbversion0000000000001','approved','images','images','root/import/thingy-templates/images','3','7','12',NULL,0,1,0,0,0,340,NULL,0,1,0,1242380142,NULL,0),('hQ7z33_jOYkQ8WNX5xy9Sw',1209509455,'3','pbversion0000000000001','approved','style-button.gif','style-button.gif','root/import/thingy-templates/images/style-button.gif','3','7','12',NULL,0,1,0,0,0,923,NULL,0,0,0,1242380149,NULL,0),('vWW_DcHiYSrKZOkkIfEfcQ',1209509433,'3','pbversion0000000000001','approved','row-2.jpg','row-2.jpg','root/import/thingy-templates/images/row-2.jpg','3','7','12',NULL,0,1,0,0,0,805,NULL,0,0,0,1242380164,NULL,0),('_bPYzRA87NTAUIKlfrJMHg',1209509433,'3','pbversion0000000000001','approved','row-1.jpg','row-1.jpg','root/import/thingy-templates/images/row-1.jpg','3','7','12',NULL,0,1,0,0,0,790,NULL,0,0,0,1242380165,NULL,0),('nJjZHRwdDs5MAZYsAyioHw',1209509433,'3','pbversion0000000000001','approved','title-bg.jpg','title-bg.jpg','root/import/thingy-templates/images/title-bg.jpg','3','7','12',NULL,0,1,0,0,0,1105,NULL,0,0,0,1242380151,NULL,0),('8hxfkrJPeFVRWF5piCNJ1A',1209509433,'3','pbversion0000000000001','approved','field-bg.jpg','field-bg.jpg','root/import/thingy-templates/images/field-bg.jpg','3','7','12',NULL,0,1,0,0,0,721,NULL,0,0,0,1242380146,NULL,0),('Osx7WN52iIKHZFT4vqUBHQ',1209509433,'3','pbversion0000000000001','approved','search-btn.gif','search-btn.gif','root/import/thingy-templates/images/search-btn.gif','3','7','12',NULL,0,1,0,0,0,1263,NULL,0,0,0,1242380151,NULL,0),('oWff8fGzRdHPyq5VNREe9Q',1209509433,'3','pbversion0000000000001','approved','top-bg.jpg','top-bg.jpg','root/import/thingy-templates/images/top-bg.jpg','3','7','12',NULL,0,1,0,0,0,691,NULL,0,0,0,1242380151,NULL,0),('uqbkvb1b9443VvfkyRz95w',1209509433,'3','pbversion0000000000001','approved','save-button.gif','save-button.gif','root/import/thingy-templates/images/save-button.gif','3','7','12',NULL,0,1,0,0,0,1271,NULL,0,0,0,1242380164,NULL,0),('8YiMkcz32xalkAn3WBLpag',1210181860,'3','pbversion0000000000001','approved','go-btn.gif','go-btn.gif','root/import/thingy-templates/images/go-btn.gif','3','7','12',NULL,0,1,0,0,0,430,NULL,0,0,0,1242380146,NULL,0),('C5fPz-Wg85vkYRvCdl-Xqw',1212160830,'3','pbversion0000000000001','approved','UserList','UserList','root/import/userlist','3','7','12',NULL,0,1,0,0,0,323,NULL,0,1,0,1242380147,NULL,0),('usuxw9V3jN4d4pujRiEYxg',1209494150,'3','pbversion0000000000001','approved','css03-ie.css','css03-ie.css','style3/css03-ie.css','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1285733367,NULL,0),('WeatherDataTmpl0000001',1210711353,'3','pbversion0000000000001','approved','WeatherData Default View','WeatherData Default View','weatherdatatmpl0000001','3','7','12',NULL,0,1,0,0,0,5540,'<script type=\"text/javascript\" src=\"^Extras(/yui/build/yahoo/yahoo-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(/yui/build/event/event-min.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\n// correctly handle PNG transparency in Win IE 5.5 or higher.\r\n    var correctPNG = function() {\r\n        if (YAHOO.util.Event.isIE) {\r\n            for(var i=0; i<document.images.length; i++) {\r\n                var img = document.images[i]\r\n                var imgName = img.src.toUpperCase()\r\n                if (imgName.substring(imgName.length-3, imgName.length) == \"PNG\") {\r\n                    var imgID = (img.id) ? \"id=\'\" + img.id + \"\' \" : \"\"\r\n                    var imgClass = (img.className) ? \"class=\'\" + img.className + \"\' \" : \"\"\r\n                    var imgTitle = (img.title) ? \"title=\'\" + img.title + \"\' \" : \"title=\'\" + img.alt + \"\' \"\r\n                    var imgStyle = \"display:inline-block;\" + img.style.cssText\r\n                    if (img.align == \"left\") imgStyle = \"float:left;\" + imgStyle\r\n                    if (img.align == \"right\") imgStyle = \"float:right;\" + imgStyle\r\n                    if (img.parentElement.href) imgStyle = \"cursor:hand;\" + imgStyle\r\n                    var strNewHTML = \"<span \" + imgID + imgClass + imgTitle\r\n                        + \" style=\\\"\" + \"width:\" + img.width + \"px; height:\" + img.height + \"px;\" + imgStyle + \";\"\r\n                        + \"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"\r\n                        + \"(src=\\\'\" + img.src + \"\\\', sizingMethod=\'scale\');\\\"></span>\"\r\n                    img.outerHTML = strNewHTML\r\n                    i = i-1\r\n                }\r\n            }\r\n        }\r\n    }\r\n    YAHOO.util.Event.onDOMReady(correctPNG);\r\n</script>',0,1,0,1285733363,'<script type=\"text/javascript\" src=\"^Extras(/yui/build/yahoo/yahoo-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(/yui/build/event/event-min.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/var correctPNG=function(){if(YAHOO.util.Event.isIE){for(var i=0;i<document.images.length;i++){var d=document.images[i]var g=d.src.toUpperCase()if(g.substring(g.length-3,g.length)==\"PNG\"){var c=(d.id)?\"id=\'\"+d.id+\"\' \":\"\"var f=(d.className)?\"class=\'\"+d.className+\"\' \":\"\"var b=(d.title)?\"title=\'\"+d.title+\"\' \":\"title=\'\"+d.alt+\"\' \"var e=\"display:inline-block;\"+d.style.cssText if(d.align==\"left\")e=\"float:left;\"+e if(d.align==\"right\")e=\"float:right;\"+e if(d.parentElement.href)e=\"cursor:hand;\"+e var a=\"<span \"+c+f+b+\" style=\\\"\"+\"width:\"+d.width+\"px; height:\"+d.height+\"px;\"+e+\";\"+\"filter:progid:DXImageTransform.Microsoft.AlphaImageLoader\"+\"(src=\\\'\"+d.src+\"\\\', sizingMethod=\'scale\');\\\"></span>\"d.outerHTML=a i=i-1}}}}YAHOO.util.Event.onDOMReady(correctPNG);/*]]>*/</script>',0),('Ik9HHky10DIyFTKehUD1dw',1222803478,'3','pbversion0000000000001','approved','Prompt','Prompt','root/import/prompt','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1242380149,NULL,0),('BmLaN4rmAANkCglXUViEbg',1222803871,'3','pbversion0000000000001','approved','Resource','Resource','root/import/projectmanager/resource','3','12','12',NULL,0,0,0,0,0,346,NULL,0,1,0,1242380147,NULL,0),('X7DrzUcj8pOKFa_6k9D5iw',1222804045,'3','pbversion0000000000001','approved','Newsletter','Newsletter','root/import/newsletter','3','12','3',NULL,0,0,0,0,0,329,NULL,0,1,0,1242380165,NULL,0),('7-0-style0000000000059',1213386091,'3','pbversion0000000000001','approved','main_top.jpg','main_top.jpg','style3/main_top.jpg','3','7','12',NULL,0,0,0,0,0,3594,NULL,0,1,0,1242380144,NULL,0),('CalendarPrintEvent0001',1215396964,'3','pbversion0000000000001','approved','Default Calendar Print Event','Default Calendar Print Event','root/import/calendar-templates/default-calendar-print-event','3','7','12',NULL,0,0,0,0,0,4202,'	<style type=\"text/css\">\r\n	.calHeader {\r\n		font-size:22px;\r\n		font-weight:bold;\r\n		text-align:right;		\r\n		border-bottom:double #666 3px;\r\n		width:65%;\r\n		font-family:arial;\r\n	}	\r\n	#printableCal {\r\n		font-family:arial;\r\n		font-size:13px;\r\n		width:65%;\r\n		border:solid #aaa 1px;\r\n		border-top-style:none;\r\n	}\r\n	#printableCal .label {\r\n		font-weight:bold;\r\n		font-size:13px;\r\n		vertical-align:top;\r\n		width:15%;\r\n	}\r\n	#printableCal ul {\r\n		margin:0px;\r\n		padding:0px;\r\n		padding-left:16px;\r\n	}\r\n	#printableCal .alt {\r\n		background-color:#eee;\r\n	}\r\n	.calFooter {\r\n		width:65%;\r\n		text-align:center;\r\n		font-size:10px;\r\n		font-family:arial;\r\n	}\r\n	</style>\r\n',0,1,0,1285733357,'<style type=\"text/css\">.calHeader{font-size:22px;font-weight:bold;text-align:right;border-bottom:double #666 3px;width:65%;font-family:arial;}#printableCal{font-family:arial;font-size:13px;width:65%;border:solid #aaa 1px;border-top-style:none;}#printableCal .label{font-weight:bold;font-size:13px;vertical-align:top;width:15%;}#printableCal ul{margin:0px;padding:0px;padding-left:16px;}#printableCal .alt{background-color:#eee;}.calFooter{width:65%;text-align:center;font-size:10px;font-family:arial;}</style>',0),('o_pq_e4vRyhMOKFzs61eag',1215714957,'3','pbversion0000000000001','approved','book-covers.jpg','book-covers.jpg','documentation/book-covers.jpg','3','7','3',NULL,0,1,0,0,0,106078,NULL,0,0,0,1280279777,NULL,0),('jnYdqDkUR8x7Pv2eGR1qTA',1216250666,'3','pbversion0000000000001','approved','Thingy Templates','Thingy Templates','root/import/thingy-templates','3','7','12',NULL,0,1,0,0,0,347,NULL,0,1,0,1242380149,NULL,0),('5m5I7__l40C4hhv4ydqAHQ',1216227786,'3','pbversion0000000000001','approved','thingy-ie.css','thingy-ie.css','root/import/thingy-templates/thingy-ie.css','3','7','12',NULL,0,1,0,0,0,1329,NULL,0,1,0,1285733366,NULL,0),('pV7GnZdpjR3XpZaSINIoeg',1222803347,'3','pbversion0000000000001','approved','gantt','gantt','root/import/projectmanager/gantt','3','7','12',NULL,0,0,0,0,0,336,NULL,0,1,0,1242380162,NULL,0),('9A-mg2gwWmaYi9o_1C7ArQ',1222803338,'3','pbversion0000000000001','approved','dashboard','dashboard','root/import/projectmanager/dashboard','3','7','12',NULL,0,0,0,0,0,348,NULL,0,1,0,1242380146,NULL,0),('yD1SMHelczihzjEmx6eXBA',1222803342,'3','pbversion0000000000001','approved','editTask','editTask','root/import/projectmanager/edittask','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380165,NULL,0),('BFfNj5wA9bDw8H3cnr8pTw',1247046273,'3','pbversion0000000000001','approved','Navigation','Navigation','root/import/navigation','3','7','12',NULL,0,0,0,0,0,329,NULL,0,1,0,1247779656,NULL,0),('PBtmpl0000000000000094',1220655703,'3','pbversion0000000000001','approved','News','News','plainblacknews','3','7','12',NULL,0,1,0,0,0,6236,'<style type=\"text/css\">\r\n.firstColumn {\r\n	float: left;\r\n	width: 50%;\r\n}\r\n.secondColumn {\r\n	float: left;\r\n	width: auto;\r\n	max-width: 50%;\r\n}\r\n.endFloat {\r\n	clear: both;\r\n}\r\n</style>\r\n\r\n\r\n',0,1,0,1285733360,'<style type=\"text/css\">.firstColumn{float:left;width:50%;}.secondColumn{float:left;width:auto;max-width:50%;}.endFloat{clear:both;}</style>',0),('1XOJDcg_ITRYwVM-QnIcPw',1219175575,'3','pbversion0000000000001','approved','shelf.css','shelf.css','root/import/shelf2/shelf.css','3','7','12',NULL,0,1,0,0,0,2431,NULL,0,1,0,1285733366,NULL,0),('aNNC62qLAS6TB-0_MCYjsw',1246969327,'3','pbversion0000000000001','approved','Layout','Layout','root/import/layout','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1247779656,NULL,0),('huASapWvFDzqwOSbcN-JFQ',1222803313,'3','pbversion0000000000001','approved','user','user','root/import/timetracking/user','3','7','12',NULL,0,0,0,0,0,331,NULL,0,1,0,1242380149,NULL,0),('lo1ac3BsoJx3ijGQ3gR-bQ',1222803309,'3','pbversion0000000000001','approved','row','row','root/import/timetracking/row','3','7','12',NULL,0,0,0,0,0,328,NULL,0,1,0,1242380150,NULL,0),('zyWi26q9na-iiZqL4yedog',1222803114,'3','pbversion0000000000001','approved','Macro','Macro','root/import/macro','3','7','12',NULL,0,1,0,0,0,314,NULL,0,1,0,1242380165,NULL,0),('tBL7BWiQRZFed2Y-Zjo9tQ',1222803200,'3','pbversion0000000000001','approved','AdminToggle','AdminToggle','root/import/macro/admintoggle','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380163,NULL,0),('GdkQpvjRtJqtzOUbwIIQRA',1222803205,'3','pbversion0000000000001','approved','a_account','a_account','root/import/macro/a_account','3','7','12',NULL,0,0,0,0,0,339,NULL,0,1,0,1242380149,NULL,0),('tnc5iYyynX2hfdEs9D3P8w',1222803213,'3','pbversion0000000000001','approved','EditableToggle','EditableToggle','root/import/macro/editabletoggle','3','7','12',NULL,0,0,0,0,0,354,NULL,0,1,0,1242380164,NULL,0),('vgXdBcFTqU7h4wBG1ewdBw',1222803217,'3','pbversion0000000000001','approved','File','File','root/import/macro/file','3','7','12',NULL,0,0,0,0,0,324,NULL,0,1,0,1242380164,NULL,0),('hcFlqnXlsmC1ujN6Id0F0A',1222803234,'3','pbversion0000000000001','approved','GroupAdd','GroupAdd','root/import/macro/groupadd','3','7','12',NULL,0,0,0,0,0,336,NULL,0,1,0,1242380149,NULL,0),('eRJR52fvlaxfetv3DQkQYw',1222803238,'3','pbversion0000000000001','approved','GroupDelete','GroupDelete','root/import/macro/groupdelete','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380148,NULL,0),('5HIDHq5lAWHV5gpYGS0zLg',1222803244,'3','pbversion0000000000001','approved','H_homeLink','H_homeLink','root/import/macro/h_homelink','3','7','12',NULL,0,0,0,0,0,342,NULL,0,1,0,1242380142,NULL,0),('rYEFwXXo0tkGhQTcbDibvg',1222803249,'3','pbversion0000000000001','approved','LoginToggle','LoginToggle','root/import/macro/logintoggle','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380162,NULL,0),('-WM2dt0ZGpDasuL2wWocxg',1222803056,'3','pbversion0000000000001','approved','ProjectManager','ProjectManager','root/import/projectmanager','3','7','12',NULL,0,1,0,0,0,341,NULL,0,1,0,1242380141,NULL,0),('2OcUWHVsu_L1sDFzIMWYqw',1222803070,'3','pbversion0000000000001','approved','TimeTracking','TimeTracking','root/import/timetracking','3','7','12',NULL,0,1,0,0,0,335,NULL,0,1,0,1242380141,NULL,0),('vTymIDYL2YqEh6PV50F7ew',1222803302,'3','pbversion0000000000001','approved','manager','manager','root/import/timetracking/manager','3','7','12',NULL,0,0,0,0,0,340,NULL,0,1,0,1242380164,NULL,0),('nqNbSUAhk9Vd1zda2SCz9A',1222803258,'3','pbversion0000000000001','approved','RandomThread','RandomThread','root/import/macro/randomthread','3','7','12',NULL,0,0,0,0,0,348,NULL,0,1,0,1242380151,NULL,0),('y8XkRdxIperLKkJ3bL5sSQ',1222803264,'3','pbversion0000000000001','approved','r_printable','r_printable','root/import/macro/r_printable','3','7','12',NULL,0,0,0,0,0,345,NULL,0,1,0,1242380165,NULL,0),('V3l5S5TtI7wMm1WpIMhvOA',1222803253,'3','pbversion0000000000001','approved','L_loginBox','L_loginBox','root/import/macro/l_loginbox','3','7','12',NULL,0,0,0,0,0,342,NULL,0,1,0,1242380164,NULL,0),('newslettersubscrip0001',1221692339,'3','pbversion0000000000001','approved','My Subscriptions (default)',' My Subscriptions','newslettermysubscriptionstemplate','3','7','3',NULL,0,0,0,0,0,1184,NULL,0,1,0,1285733365,NULL,0),('ThingyTmpl000000000002',1222574693,'3','pbversion0000000000001','approved','Default Thingy View Thing','Default Thingy View Thing','templates/thingy-default-view-thing','3','7','12',NULL,0,0,0,0,0,4843,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\n',0,1,0,1285733362,'<style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('UL-ItI4L1Z6-WSuhuXVvsQ',1225139673,'3','pbversion0000000000001','approved','DataTable','DataTable','root/import/datatable','3','7','3',NULL,0,0,0,0,0,325,NULL,0,1,0,1242380164,NULL,0),('7-0-style0000000000049',1224117144,'3','pbversion0000000000001','approved','WebGUI 7 Style 3','WebGUI 7 Style 3','root/import/webgui-7-style-3','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1242380144,NULL,0),('stevecoolmenu000000001',1224116942,'3','pbversion0000000000001','approved','Site Nav','Site Nav','webgui7/style3/hierarchical-top-nav','3','7','12',NULL,0,0,0,0,0,3754,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" />\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>\r\n',0,1,0,1285733365,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>',0),('7-0-style0000000000051',1224117026,'3','pbversion0000000000001','approved','css03.css','css03.css','style3/css03.css','3','7','12',NULL,0,0,0,0,0,5975,NULL,0,1,0,1285733366,NULL,0),('jVKLVakT_iA2010_oEuAwg',1224116526,'3','pbversion0000000000001','approved','Style3 Coolmenu','Style3 Coolmenu','department_nav','3','7','12',NULL,0,0,0,0,0,386,NULL,0,1,0,1242380150,NULL,0),('ThingyTmpl000000000003',1224518002,'3','pbversion0000000000001','approved','Default Thingy Edit Thing','Default Thingy Edit Thing','templates/thingy-default-edit-thing','3','7','12',NULL,0,0,0,0,0,6324,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>\r\n\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/thingy-templates/thingy-ie.css););\r\n	</style>\r\n<![endif]-->\r\n',0,1,0,1285733362,'<style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('QpmlAiYZz6VsKBM-_0wXaw',1224616691,'3','pbversion0000000000001','approved','UsersOnline Macro','UsersOnline Macro','users-online-macro-templates','3','7','3',NULL,0,0,0,0,0,368,NULL,0,1,0,1242380162,NULL,0),('h_T2xtOxGRQ9QJOR6ebLpQ',1224616545,'3','pbversion0000000000001','approved','UsersOnline Default View','UsersOnline Default View','users-online-macro-templates/usersonline-default-view','3','7','3',NULL,0,1,0,0,0,2495,'<style type=\"text/css\">\r\n.UsersOnlineTable { \r\n	border-collapse: collapse;\r\n}\r\n\r\n.UsersOnlineTable th, .UsersOnlineTable td {\r\n	text-align: left;\r\n	border: 2px ridge;\r\n}\r\n\r\n.UsersOnlineTable img {\r\n	max-width: 3em;\r\n	max-height: 3em;\r\n	float: left;\r\n}\r\n</style>\r\n\r\n',0,1,0,1285733364,'<style type=\"text/css\">.UsersOnlineTable{border-collapse:collapse;}.UsersOnlineTable th,.UsersOnlineTable td{text-align:left;border:2px ridge;}.UsersOnlineTable img{max-width:3em;max-height:3em;float:left;}</style>',0),('4Ekp0kJoJllRRRo_J1Rj6w',1224616672,'3','pbversion0000000000001','approved','UsersOnline Detailed View','UsersOnline Detailed View','users-online-macro-templates/usersonline-detailed-view','3','7','3',NULL,0,1,0,0,0,4318,'<style type=\"text/css\">\r\n.UsersOnlineTable { \r\n	border-collapse: collapse;\r\n}\r\n\r\n.UsersOnlineTable th, .UsersOnlineTable td {\r\n	text-align: left;\r\n	border: 2px ridge;\r\n}\r\n\r\n.UsersOnlineTable img {\r\n	max-width: 3em;\r\n	max-height: 3em;\r\n	float: left;\r\n}\r\n</style>\r\n\r\n',0,1,0,1285733356,'<style type=\"text/css\">.UsersOnlineTable{border-collapse:collapse;}.UsersOnlineTable th,.UsersOnlineTable td{text-align:left;border:2px ridge;}.UsersOnlineTable img{max-width:3em;max-height:3em;float:left;}</style>',0),('IZkrow_zwvbf4FCH-taVTQ',1226011853,'3','pbversion0000000000001','approved','Inbox','Inbox','root/import/account/inbox','3','7','12',NULL,0,1,0,0,0,328,NULL,0,1,0,1250190873,NULL,0),('K0YjxqOqr7RupSo6sIdcAg',1227074310,'3','pbversion0000000000001','approved','Friends','Friends','root/import/account/friends','3','7','12',NULL,0,1,0,0,0,334,NULL,0,1,0,1250190873,NULL,0),('_ilRXNR3s8F2vGJ_k9ePcg',1226643205,'3','pbversion0000000000001','approved','User','User','root/import/account/user','3','7','12',NULL,0,1,0,0,0,325,NULL,0,1,0,1250190873,NULL,0),('qaVcU0FFzzraMX_bzELqzw',1227074362,'3','pbversion0000000000001','approved','Contributions','Contributions','root/import/account/contributions','3','7','12',NULL,0,1,0,0,0,352,NULL,0,1,0,1250190873,NULL,0),('UserListTmpl0000000001',1228125743,'3','pbversion0000000000001','approved','Default UserList','Default UserList','root/import/userlist/default-userlist','3','7','12',NULL,0,1,0,0,0,5202,NULL,0,1,0,1285733362,NULL,0),('UserListTmpl0000000003',1228125758,'3','pbversion0000000000001','approved','UserList with multiple search keywords','UserList with multiple search keywords','root/import/userlist/userlist-with-multiple-search-keywords','3','7','12',NULL,0,1,0,0,0,5489,NULL,0,1,0,1285733362,NULL,0),('UserListTmpl0000000002',1228125752,'3','pbversion0000000000001','approved','UserList with search field selection','UserList with search field selection','root/import/userlist/userlist-with-search-field-selection','3','7','12',NULL,0,1,0,0,0,5116,NULL,0,1,0,1285733362,NULL,0),('TimeTrackingTMPL000003',1229311434,'3','pbversion0000000000001','approved','Default Time Tracking Row Template','Default Time Tracking Row Template','default-tt-template-row','3','7','12',NULL,0,0,0,0,0,5721,NULL,0,1,0,1285733362,NULL,0),('uRL9qtk7Rb0YRJ41LmHOJw',1229311072,'3','pbversion0000000000001','approved','Default Calendar Print List View','Default Calendar Print List View','root/import/calendar-templates/default-calendar-print-list-view','3','7','3',NULL,0,1,0,0,0,1737,NULL,0,1,0,1285733365,NULL,0),('DashboardViewTmpl00001',1230358389,'3','pbversion0000000000001','approved','Dashboard Default View','Dashboard Default View','dashboard-default-view-template','3','7','12',NULL,0,0,0,0,0,14822,'<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/draggable.css);\"; </style>\r\n<style type=\"text/css\"> @import \"^Extras(wobject/Dashboard/dashboard.css);\"; </style>\r\n<script src=\"^Extras(wobject/Dashboard/draggable.js);\" type=\"text/javascript\"></script>\r\n<!--[if IE]>\r\n<style type=\"text/css\">\r\ndiv.dragTitle\r\n{\r\n	overflow-x:hidden;\r\n}\r\n</style>\r\n<![endif]-->',0,1,0,1285733357,'<style type=\"text/css\">@import \"^Extras(wobject/Dashboard/draggable.css);\";</style><style type=\"text/css\">@import \"^Extras(wobject/Dashboard/dashboard.css);\";</style><script src=\"^Extras(wobject/Dashboard/draggable.js);\" type=\"text/javascript\"></script>',0),('ProjectManagerTMPL0005',1229579830,'3','pbversion0000000000001','approved','Default Resource Popup','Default Resource Popup','default-pm-resource-popup','3','7','12',NULL,0,0,0,0,0,3582,NULL,0,1,0,1285733362,NULL,0),('ProjectManagerTMPL0001',1229579830,'3','pbversion0000000000001','approved','Default Project Management System Dashboard','Default Project Management System Dashboard','default-pm-template-dashboard','3','7','12',NULL,0,0,0,0,0,6862,'<style type=\"text/css\">\n.fontSettings {\n	font-family:arial;\n	font-size:9pt;\n}\n.projectView td {\n	border:solid silver 1px;\n	border-bottom:solid gray 1px;\n	font-size:9pt;\n	font-family:arial;\n}\n.projectView a {\n	color:#3391DD;\n}\ntr.header td {\n	font-weight:bold;\n}\ntd.projectNames {\n	white-space:nowrap;\n}\ntd.projectNames a {\n	display:block;\n	color:#3391DD;\n}\ntd.projectNames a.level1 {\n	margin:0 10px;\n}\ntd.projectNames a.level2 {\n	margin:0px 10px 0px 20px;\n}\ntd.projectNames a.level3 {\n	margin:0px 10px 0px 30px;\n}\ntd.projectNames a.level4 {\n	margin:0px 10px 0px 40px;\n}\ntd.projectNames a.level5 {\n	margin:0px 10px 0px 50px;\n}\ntr.alt td {\n	background-color:#F0F0F0;\n}\ndiv.completeContainer {\n	position:relative;\n	z-index:0;\n	background: #000;\n	color:white;\n	text-align:center;\n}\ndiv.completeBar {\n	position:absolute;\n	height:100%;\n	top:0px;\n	left:0px;\n	background: #7AB7E9;\n	z-index:1;\n}\ndiv.completeText {\n	position:relative;\n	height:100%;\n	top:0px;\n	left:0px;\n	z-index:2;\n}\n</style>',0,1,0,1285733362,'<style type=\"text/css\">.fontSettings{font-family:arial;font-size:9pt;}.projectView td{border:solid silver 1px;border-bottom:solid gray 1px;font-size:9pt;font-family:arial;}.projectView a{color:#3391DD;}tr.header td{font-weight:bold;}td.projectNames{white-space:nowrap;}td.projectNames a{display:block;color:#3391DD;}td.projectNames a.level1{margin:0 10px;}td.projectNames a.level2{margin:0px 10px 0px 20px;}td.projectNames a.level3{margin:0px 10px 0px 30px;}td.projectNames a.level4{margin:0px 10px 0px 40px;}td.projectNames a.level5{margin:0px 10px 0px 50px;}tr.alt td{background-color:#F0F0F0;}div.completeContainer{position:relative;z-index:0;background:#000;color:white;text-align:center;}div.completeBar{position:absolute;height:100%;top:0px;left:0px;background:#7AB7E9;z-index:1;}div.completeText{position:relative;height:100%;top:0px;left:0px;z-index:2;}</style>',0),('PBtmpl0000000000000033',1230159454,'3','pbversion0000000000001','approved','Default HTTP Proxy','Default HTTP Proxy','default_http_proxy','3','7','12',NULL,0,1,0,0,0,2214,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000059',1229907401,'3','pbversion0000000000001','approved','Default SQL Report','Default SQL Report','default_sql_report','3','7','12',NULL,0,1,0,0,0,7737,NULL,0,1,0,1285733360,NULL,0),('MultiSearchTmpl0000001',1230269962,'3','pbversion0000000000001','approved','MultiSearch Default Display','MultiSearch Default Display','multisearchtmpl0000001','3','7','12',NULL,0,1,0,0,0,3538,'<style type=\"text/css\">\nh2 {\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.multiSearch {\n	background-color:#DADADA;\n	border:solid gray 1px;	\n}\n</style>',0,1,0,1285733358,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.multiSearch{background-color:#DADADA;border:solid gray 1px;}</style>',0),('CalendarDay00000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Day','Default Calendar Day','root/import/calendar-templates/default-calendar-day','3','7','12',NULL,0,0,0,0,0,13749,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n            }\r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n            }\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n        }\r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n            }\r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n                        -moz-border-radius-topRight:8px;\r\n        }\r\n        #mCAL .day {\r\n                        background-color:#E9ECF3;\r\n            width:400px;\r\n            position:relative;\r\n                    vertical-align:top;\r\n            -moz-border-radius-topLeft:8px;\r\n                        -moz-border-radius-bottomLeft:8px;\r\n            border:solid #CCD2E3 1px;\r\n        }\r\n        #mCAL .curDay {\r\n            background-color:#FFE4B3;\r\n            border-color:orange;\r\n        }\r\n                    #mCAL .dayWrapper {\r\n            height:100%;\r\n            width:100%;\r\n            position:relative;\r\n            z-index:0;\r\n                margin:0px;\r\n            padding:0px 0px 2px 5px;;\r\n            -moz-box-sizing:border-box;\r\n        }\r\n        html > body #mCAL .dayWrapper {\r\n            height:auto;\r\n            min-height:100%;\r\n        }\r\n        #mCAL .dayNum {\r\n            width:100%;\r\n            text-align:right;\r\n            \r\n        }\r\n\r\n                                    #mCAL span.border {\r\n                        text-align:center;\r\n            padding:5px;\r\n            font-weight:bold;\r\n            -moz-border-radius-bottomRight:5px;\r\n            -moz-border-radius-topLeft:5px;\r\n                        color:black;\r\n            border-right:solid #CCD2E3 1px;\r\n            border-bottom: solid #CCD2E3 1px;\r\n            background-color:#ABB7D1;\r\n            -moz-box-sizing:border-box;\r\n            top:5px;\r\n            position:relative;\r\n            \r\n        }\r\n        #mCAL .curDay span.border {\r\n            background-color:orange;\r\n            color:black;\r\n            border-color:orange;\r\n        }\r\n        #mCAL .event {\r\n            padding:3px;\r\n            padding-top:8px;\r\n            clear:left;\r\n                        font-weight:bold;\r\n        }\r\n        #mCAL .event a {\r\n            color:#4F4F4F;\r\n            text-decoration:none;\r\n            font-size:9px;\r\n        }\r\n        #mCAL .moreButton {\r\n            border-style:none;\r\n            z-index:5;\r\n            position:absolute;\r\n            bottom:0px;\r\n            width:100%;\r\n            height:9px;\r\n                background-color:#517AC8;\r\n            font-size:5px;\r\n            text-align:center;\r\n        }\r\n        #mCAL .moreButton:hover {\r\n            background-color:orange;\r\n        }\r\n        #mCAL .empty {\r\n            border-style:none;\r\n            background-color:#CCD2E3;\r\n            -moz-border-radius:10px;\r\n            \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n                        background-color:#DFE3EE;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n                        text-decoration:none;\r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n            }\r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n                        background-color:#fff;\r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:center;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        \r\n        /* MORE STYLES */\r\n        #more1 {\r\n            position:absolute;\r\n            top:170px;\r\n                        left:10px;\r\n            \r\n        }\r\n        * html #more1 {\r\n            top:158px;\r\n            left:12px;\r\n\r\n        }\r\n        .moreDisplay {\r\n            border:solid orange 1px;\r\n            border-top:solid orange 2px;\r\n            font-family:arial;\r\n            font-size:10px;\r\n            width:300px;\r\n            padding:2px;\r\n            background-color:#FFD3A8;\r\n                        z-index:10;\r\n        }\r\n        ul.eventList {\r\n            margin:0px;\r\n            padding:0px;\r\n            margin-left:30px;\r\n            color:#526896;\r\n        }\r\n    </style>',0,1,0,1285733357,'<style type=\"text/css\">#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .curDay{background-color:#FFE4B3;border-color:orange;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL span.border{text-align:center;padding:5px;font-weight:bold;-moz-border-radius-bottomRight:5px;-moz-border-radius-topLeft:5px;color:black;border-right:solid #CCD2E3 1px;border-bottom:solid #CCD2E3 1px;background-color:#ABB7D1;-moz-box-sizing:border-box;top:5px;position:relative;}#mCAL .curDay span.border{background-color:orange;color:black;border-color:orange;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .event a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL .moreButton{border-style:none;z-index:5;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;}#mCAL .moreButton:hover{background-color:orange;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:30px;color:#526896;}</style>',0),('CalendarEvent000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Event','Default Calendar Event','root/import/calendar-templates/default-calendar-event','3','7','12',NULL,0,0,0,0,0,11792,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        body * {\r\n            margin:0px;\r\n        }   \r\n        #mCAL {\r\n            \r\n        }\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n        }   \r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n        }   \r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n        }   \r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n            -moz-border-radius-topRight:8px;            \r\n        }\r\n        #mCAL .day {\r\n            background-color:#E9ECF3;           \r\n            width:400px;\r\n            position:relative;\r\n            vertical-align:top;     \r\n            -moz-border-radius-topLeft:8px;\r\n            -moz-border-radius-bottomLeft:8px;          \r\n            border:solid #CCD2E3 1px;\r\n        }\r\n\r\n        \r\n        #mCAL .months {\r\n            text-align:center;\r\n            background-color:#DFE3EE;   \r\n            color:#3E4D75;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n            text-decoration:none;           \r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n        }   \r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n            background-color:#fff;          \r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:center;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n\r\n        #mCAL .searchField {\r\n            margin: 2px 10px;\r\n            border:solid #ABB7D1 1px;\r\n        }\r\n        #mCAL .searchBtn {\r\n            background-color: #ABB7D1;\r\n            border:solid #CCD2E3 1px;\r\n            color:white;\r\n            font-weight:bold;\r\n            cursor:pointer;\r\n        }\r\n        \r\n        #mCAL .eventWrapper {\r\n            margin:2px 10px;\r\n        }\r\n    </style>',0,1,0,1285733357,'<style type=\"text/css\">body *{margin:0px;}#mCAL{}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .months{text-align:center;background-color:#DFE3EE;color:#3E4D75;font-size:14px;font-weight:bold;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#mCAL .searchField{margin:2px 10px;border:solid #ABB7D1 1px;}#mCAL .searchBtn{background-color:#ABB7D1;border:solid #CCD2E3 1px;color:white;font-weight:bold;cursor:pointer;}#mCAL .eventWrapper{margin:2px 10px;}</style>',0),('CalendarSearch00000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Search','Default Calendar Search','root/import/calendar-templates/default-calendar-search','3','7','12',NULL,0,0,0,0,0,14791,'    <style type=\"text/css\">\r\n        body * {\r\n            margin:0px;\r\n            }\r\n        #mCAL {\r\n            \r\n        }\r\n        #mCAL td {\r\n            font-size:10px;\r\n            font-family:arial;\r\n        }\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#E9ECF3;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            color:#7588B5;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tab:hover {\r\n            color:black;\r\n            }\r\n        #mCAL .active {\r\n            background-color:#DFE3EE;\r\n            color:#404F77;\r\n            border-bottom:solid #DFE3EE 1px;\r\n            }\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n        }\r\n        #mCAL a {\r\n            font-size:11px;\r\n            color:#517AC8;\r\n            }\r\n        #mCAL .heading {\r\n            width:200px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#ABB7D1;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#374664;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n                        -moz-border-radius-topRight:8px;\r\n        }\r\n        #mCAL .day {\r\n                        background-color:#E9ECF3;\r\n            width:400px;\r\n            position:relative;\r\n                    vertical-align:top;\r\n            -moz-border-radius-topLeft:8px;\r\n                        -moz-border-radius-bottomLeft:8px;\r\n            border:solid #CCD2E3 1px;\r\n        }\r\n        #mCAL .curDay {\r\n            background-color:#FFE4B3;\r\n            border-color:orange;\r\n        }\r\n                    #mCAL .dayWrapper {\r\n            height:100%;\r\n            width:100%;\r\n            position:relative;\r\n            z-index:0;\r\n                margin:0px;\r\n            padding:0px 0px 2px 5px;;\r\n            -moz-box-sizing:border-box;\r\n        }\r\n        html > body #mCAL .dayWrapper {\r\n            height:auto;\r\n            min-height:100%;\r\n        }\r\n        #mCAL .dayNum {\r\n            width:100%;\r\n            text-align:right;\r\n            \r\n        }\r\n\r\n                                    #mCAL span.border {\r\n                        text-align:center;\r\n            padding:5px;\r\n            font-weight:bold;\r\n            -moz-border-radius-bottomRight:5px;\r\n            -moz-border-radius-topLeft:5px;\r\n                        color:black;\r\n            border-right:solid #CCD2E3 1px;\r\n            border-bottom: solid #CCD2E3 1px;\r\n            background-color:#ABB7D1;\r\n            -moz-box-sizing:border-box;\r\n            top:5px;\r\n            position:relative;\r\n            \r\n        }\r\n        #mCAL .curDay span.border {\r\n            background-color:orange;\r\n            color:black;\r\n            border-color:orange;\r\n        }\r\n        #mCAL .event {\r\n            padding:3px;\r\n            padding-top:8px;\r\n            clear:left;\r\n                        font-weight:bold;\r\n        }\r\n        #mCAL .event a {\r\n            color:#4F4F4F;\r\n            text-decoration:none;\r\n            font-size:9px;\r\n        }\r\n        #mCAL .moreButton {\r\n            border-style:none;\r\n            z-index:5;\r\n            position:absolute;\r\n            bottom:0px;\r\n            width:100%;\r\n            height:9px;\r\n                background-color:#517AC8;\r\n            font-size:5px;\r\n            text-align:center;\r\n        }\r\n        #mCAL .moreButton:hover {\r\n            background-color:orange;\r\n        }\r\n        #mCAL .empty {\r\n            border-style:none;\r\n            background-color:#CCD2E3;\r\n            -moz-border-radius:10px;\r\n            \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n                        background-color:#DFE3EE;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n                        text-decoration:none;\r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            color:#AAB8D5;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n            }\r\n        #mCAL .months .current {\r\n            color:#517AC8;\r\n        }\r\n        #mCAL .current {\r\n            font-weight:bold;\r\n            color:#517AC8;\r\n                        background-color:#fff;\r\n            -moz-border-radius:5px;\r\n        }\r\n        #mCAL .curMonth {\r\n            text-align:left;\r\n            margin: 2px 0px;\r\n            background-color:#517AC8;\r\n            color:white;\r\n            font-size:14px;\r\n            font-weight:bold;\r\n        }\r\n        \r\n        /* MORE STYLES */\r\n        #more1 {\r\n            position:absolute;\r\n            top:170px;\r\n                        left:10px;\r\n            \r\n        }\r\n        * html #more1 {\r\n            top:158px;\r\n            left:12px;\r\n\r\n        }\r\n        .moreDisplay {\r\n            border:solid orange 1px;\r\n            border-top:solid orange 2px;\r\n            font-family:arial;\r\n            font-size:10px;\r\n            width:300px;\r\n            padding:2px;\r\n            background-color:#FFD3A8;\r\n                        z-index:10;\r\n        }\r\n        ul.eventList {\r\n            margin:0px;\r\n            padding:0px;\r\n            margin-left:30px;\r\n            color:#526896;\r\n        }\r\n    </style>',0,1,0,1285733357,'<style type=\"text/css\">body *{margin:0px;}#mCAL{}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .curDay{background-color:#FFE4B3;border-color:orange;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL span.border{text-align:center;padding:5px;font-weight:bold;-moz-border-radius-bottomRight:5px;-moz-border-radius-topLeft:5px;color:black;border-right:solid #CCD2E3 1px;border-bottom:solid #CCD2E3 1px;background-color:#ABB7D1;-moz-box-sizing:border-box;top:5px;position:relative;}#mCAL .curDay span.border{background-color:orange;color:black;border-color:orange;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .event a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL .moreButton{border-style:none;z-index:5;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;}#mCAL .moreButton:hover{background-color:orange;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:left;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:30px;color:#526896;}</style>',0),('CalendarWeek0000000001',1230358389,'3','pbversion0000000000001','approved','Default Calendar Week','Default Calendar Week','root/import/calendar-templates/default-calendar-week','3','7','12',NULL,0,0,0,0,0,12761,'<style type=\"text/css\">\r\n		#mCAL * {\r\n			/*margin:0px;*/\r\n		}\r\n		#mCAL td {\r\n			font-size:10px;\r\n			font-family:arial;\r\n		}\r\n		#mCAL .tab {\r\n\r\n			border-bottom-style:none;\r\n			font-weight:bold;\r\n			padding: 2px 15px 0px 15px;\r\n			text-align;center;\r\n			background-color:#E9ECF3;\r\n			-moz-border-radius-topLeft:10px;\r\n			-moz-border-radius-topRight:10px;\r\n			color:#7588B5;\r\n			text-decoration:none;\r\n			font-size:10pt;\r\n			display:block;\r\n			float:left;\r\n			margin-right:5px;\r\n		}\r\n		#mCAL .tab:hover {\r\n			color:black;\r\n		}	\r\n		#mCAL .active {\r\n			background-color:#DFE3EE;\r\n			color:#404F77;\r\n			border-bottom:solid #DFE3EE 1px;\r\n		}	\r\n		#mCAL .controls {\r\n			float:right;\r\n			vertical-align:bottom;\r\n		}\r\n		#mCAL a {\r\n			font-size:11px;\r\n			color:#517AC8;\r\n		}	\r\n		#mCAL .heading {\r\n			width:200px;\r\n			-moz-box-sizing:border-box;\r\n			background-color:#ABB7D1;\r\n			text-align:center;\r\n			font-weight:bold;\r\n			color:#374664;\r\n			font-size:9px;\r\n			letter-spacing:1px;\r\n			text-transform:uppercase;\r\n			text-align:right;\r\n			vertical-align:top;\r\n			-moz-border-radius-bottomRight:8px;\r\n			-moz-border-radius-topRight:8px;			\r\n		}\r\n		#mCAL .day {\r\n			background-color:#E9ECF3;			\r\n			width:400px;\r\n			position:relative;\r\n			vertical-align:top;		\r\n			-moz-border-radius-topLeft:8px;\r\n			-moz-border-radius-bottomLeft:8px;			\r\n			border:solid #CCD2E3 1px;\r\n		}\r\n		#mCAL .curDay {\r\n			background-color:#FFE4B3;\r\n			border-color:orange;\r\n		}\r\n		#mCAL .dayWrapper {			\r\n			height:100%;\r\n			width:100%;\r\n			position:relative;\r\n			z-index:0;\r\n			margin:0px;	\r\n			padding:0px 0px 2px 5px;;\r\n			-moz-box-sizing:border-box;\r\n		}\r\n		html > body #mCAL .dayWrapper {\r\n			height:auto;\r\n			min-height:100%;\r\n		}\r\n		#mCAL .dayNum {\r\n			width:100%;\r\n			text-align:right;\r\n			\r\n		}\r\n\r\n		#mCAL span.border {							\r\n			text-align:center;			\r\n			padding:5px;\r\n			font-weight:bold;\r\n			-moz-border-radius-bottomRight:5px;\r\n			-moz-border-radius-topLeft:5px;\r\n			color:black;			\r\n			border-right:solid #CCD2E3 1px;\r\n			border-bottom: solid #CCD2E3 1px;\r\n			background-color:#ABB7D1;\r\n			-moz-box-sizing:border-box;\r\n			top:5px;\r\n			position:relative;\r\n			\r\n		}\r\n		#mCAL .curDay span.border {\r\n			background-color:orange;\r\n			color:black;\r\n			border-color:orange;\r\n		}\r\n		#mCAL .event {\r\n			padding:3px;\r\n			padding-top:8px;\r\n			clear:left;\r\n			font-weight:bold;			\r\n		}\r\n		#mCAL .event a {\r\n			color:#4F4F4F;\r\n			text-decoration:none;\r\n			font-size:9px;\r\n		}\r\n		#mCAL .moreButton {\r\n			border-style:none;\r\n			z-index:5;\r\n			position:absolute;\r\n			bottom:0px;\r\n			width:100%;\r\n			height:9px;\r\n			background-color:#517AC8;	\r\n			font-size:5px;\r\n			text-align:center;\r\n		}\r\n		#mCAL .moreButton:hover {\r\n			background-color:orange;\r\n		}\r\n		#mCAL .empty {\r\n			border-style:none;\r\n			background-color:#CCD2E3;\r\n			-moz-border-radius:10px;\r\n			\r\n		}\r\n		#mCAL .months {\r\n			text-align:center;\r\n			background-color:#DFE3EE;			\r\n		}\r\n		#mCAL .months a {\r\n			color:#517AC8;\r\n			text-decoration:none;\r\n		}\r\n		#mCAL .months .monthLink {\r\n			text-decoration:none;			\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:#AAB8D5;\r\n			font-size:12px;\r\n			font-weight:bold;\r\n		}	\r\n		#mCAL .months .current {\r\n			color:#517AC8;\r\n		}\r\n		#mCAL .current {\r\n			font-weight:bold;\r\n			color:#517AC8;\r\n			background-color:#fff;			\r\n			-moz-border-radius:5px;\r\n		}\r\n		#mCAL .curMonth {\r\n			text-align:center;\r\n			margin: 2px 0px;\r\n			background-color:#517AC8;\r\n			color:white;\r\n			font-size:14px;\r\n			font-weight:bold;\r\n		}\r\n		\r\n		/* MORE STYLES */\r\n		#more1 {\r\n			position:absolute;\r\n			top:170px;\r\n			left:10px;			\r\n			\r\n		}\r\n		* html #more1 {\r\n			top:158px;\r\n			left:12px;\r\n\r\n		}\r\n		.moreDisplay {\r\n			border:solid orange 1px;\r\n			border-top:solid orange 2px;\r\n			font-family:arial;\r\n			font-size:10px;\r\n			width:300px;\r\n			padding:2px;\r\n			background-color:#FFD3A8;\r\n			z-index:10;			\r\n		}\r\n		ul.eventList {\r\n			margin:0px;\r\n			padding:0px;\r\n			margin-left:50px;\r\n			color:#526896;\r\n		}\r\n\r\n\r\n</style>',0,1,0,1285733357,'<style type=\"text/css\">#mCAL *{}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n			text-align;center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .heading{width:200px;-moz-box-sizing:border-box;background-color:#ABB7D1;text-align:center;font-weight:bold;color:#374664;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#E9ECF3;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;border:solid #CCD2E3 1px;}#mCAL .curDay{background-color:#FFE4B3;border-color:orange;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL span.border{text-align:center;padding:5px;font-weight:bold;-moz-border-radius-bottomRight:5px;-moz-border-radius-topLeft:5px;color:black;border-right:solid #CCD2E3 1px;border-bottom:solid #CCD2E3 1px;background-color:#ABB7D1;-moz-box-sizing:border-box;top:5px;position:relative;}#mCAL .curDay span.border{background-color:orange;color:black;border-color:orange;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .event a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL .moreButton{border-style:none;z-index:5;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;}#mCAL .moreButton:hover{background-color:orange;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:50px;color:#526896;}</style>',0),('StockDataTMPL000000002',1229494994,'3','pbversion0000000000001','approved','StockData Default Display','StockData Default Display','stockdatatmpl000000002','3','7','12',NULL,0,1,0,0,0,20602,NULL,0,1,0,1285733362,NULL,0),('QHn6T9rU7KsnS3Y70KCNTg',1233173545,'3','pbversion0000000000001','approved','Account','Account','root/import/account','3','7','12',NULL,0,1,0,0,0,320,NULL,0,1,0,1250190873,NULL,0),('HW-sPoDDZR8wBZ0YgFgPtg',1227634350,'3','pbversion0000000000001','approved','images','images','root/import/account/images','3','7','12',NULL,0,1,0,0,0,331,NULL,0,1,0,1250190873,NULL,0),('hBpisL-_URyZnh9clR5ohA',1227634417,'3','pbversion0000000000001','approved','no_photo.gif','no_photo.gif','root/import/account/images/no_photo.gif','3','7','12',NULL,0,1,0,0,0,2564,NULL,0,1,0,1250190873,NULL,0),('FOBV6KkifreXa4GmEAUU4A',1227634447,'3','pbversion0000000000001','approved','no_photo_sm.gif','no_photo_sm.gif','root/import/account/images/no_photo_sm.gif','3','7','12',NULL,0,1,0,0,0,1580,NULL,0,1,0,1250190873,NULL,0),('TuYPpHx7TUyk08639Pc8Bg',1233861621,'3','pbversion0000000000001','approved','Default DataTable Template (HTML)','Default DataTable Template (HTML)','root/import/datatable/default-datatable-template-html','3','7','3',NULL,0,1,0,0,0,1429,NULL,0,1,0,1285733362,NULL,0),('3rjnBVJRO6ZSkxlFkYh_ug',1233861835,'3','pbversion0000000000001','approved','Default DataTable Template (YUI)','Default DataTable Template (YUI)','root/import/datatable/default-datatable-template-yui','3','7','3',NULL,0,1,0,0,0,1089,NULL,0,1,0,1285733356,NULL,0),('AOjPG2NHgfL9Cq6dDJ7mew',1236960881,'3','pbversion0000000000001','approved','Shop','Shop','root/import/account/shop','3','7','12',NULL,0,1,0,0,0,325,NULL,0,1,0,1250190873,NULL,0),('NBVSVNLp9X_bV7WrCprtCA',1237842096,'3','pbversion0000000000001','approved','Annotate Image','Annotate Image','image3','3','7','12',NULL,0,1,0,0,0,675,NULL,0,1,0,1285733358,NULL,0),('jmlI9IK-lV8n2WMYmmPhAA',1238106173,'3','pbversion0000000000001','approved','Ad Sku','Ad Sku','root/import/ad-sku','3','7','12',NULL,0,1,0,0,0,317,NULL,0,1,0,1242380149,NULL,0),('ThingyTmpl000000000001',1237914005,'3','pbversion0000000000001','approved','Default Thingy','Default Thingy','templates/thingy-default','3','7','12',NULL,0,0,0,0,0,2554,'<style type=\"text/css\">\r\n	@import url(^/(root/import/thingy-templates/thingy.css););\r\n</style>',0,1,0,1285733362,'<style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('6uvSLY-ak_w4p_wS8q33cA',1239213092,'3','pbversion0000000000001','approved','Carousel','Carousel','root/import/carousel','3','7','12',NULL,0,1,0,0,0,323,NULL,0,1,0,1242380142,NULL,0),('CarouselTmpl0000000002',1239475937,'3','pbversion0000000000001','approved','Carousel hidden textareas','Carousel hidden textareas','root/import/carousel/carousel-hidden-textareas','3','7','12',NULL,0,0,0,0,0,1059,NULL,0,1,0,1285733357,NULL,0),('GaBAW-2iVhLMJaZQzVLE5A',1240103565,'3','pbversion0000000000001','approved','ThingyRecord Templates','ThingyRecord Templates','root/import/thingyrecord-templates','3','7','3',NULL,0,0,0,0,0,364,NULL,0,1,0,1242380149,NULL,0),('b1316COmd9xRv4fCI3LLGA',1236956475,'3','pbversion0000000000001','approved','Inbox Notification','Inbox Notification','inbox_notification','3','7','4',NULL,0,0,0,0,0,414,NULL,0,1,0,1285733363,NULL,0),('lo1rpxn3t8YPyKGers5eQg',1238625621,'3','pbversion0000000000001','approved','Friend Manager','Friend Manager','root/import/account/friendmanager','3','7','12',NULL,0,1,0,0,0,388,NULL,0,1,0,1242380168,NULL,0),('64tqS80D53Z0JoAs2cX2VQ',1239400975,'3','pbversion0000000000001','approved','FriendManager View Template','FriendManager View Template','root/import/account/friendmanager/view','3','7','4',NULL,0,0,0,0,0,4438,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\"                     rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(yui/build/paginator/assets/skins/sam/button.css);\"    rel=\"stylesheet\" type=\"text/css\" />\n\n<script src=\"^Extras(yui/build/utilities/utilities.js);\"              type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/json/json-min.js);\"                    type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"  type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/element/element-min.js);\"              type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/paginator/paginator-min.js);\"          type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/datasource/datasource-min.js);\"        type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/datatable/datatable-min.js);\"          type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/button/button-min.js);\"                type=\"text/javascript\"></script>\n<script src=\"^Extras(yui-webgui/build/i18n/i18n.js);\"                 type=\"text/javascript\"></script>\n\n<script src=\"^Extras(yui-webgui/build/friendManager/friendManager.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\"> #paging a { color: #0000de; } #search form { display: inline; } </style>\n\n',0,1,0,1285733357,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(yui/build/paginator/assets/skins/sam/button.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/element/element-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/button/button-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui-webgui/build/i18n/i18n.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui-webgui/build/friendManager/friendManager.js);\" type=\"text/javascript\"></script><style type=\"text/css\">#paging a{color:#0000de;}#search form{display:inline;}</style>',0),('lG2exkH9FeYvn4pA63idNg',1239383808,'3','pbversion0000000000001','approved','Friend Manager Edit Friends','Friend Manager Edit Friends','root/import/account/friendmanager/edit','3','7','4',NULL,0,0,0,0,0,2587,'<style>\ndiv.fmAdd, div.fmRemove {\n    float: left;\n    margin: 5px;\n    padding: 3px;\n}\n\n</style>',0,1,0,1285733364,'<style>\ndiv.fmAdd, div.fmRemove {\n    float: left;\n    margin: 5px;\n    padding: 3px;\n}\n\n</style>',0),('kj3b-X3i6zRKnhLb4ZiCLw',1243445504,'3','pbversion0000000000001','approved','Default Calendar List View','Default Calendar List View','root/import/calendar-templates/default-calendar-list-view','3','7','3',NULL,0,1,0,0,0,5741,'<style type=\"text/css\">\n	#wgListView * {\n		padding:0px;\n		margin:0px;\n	}	\n	#wgListView a:link,\n	#wgListView a:visited {			\n		font-weight:bold;\n	}\n	#wgListView .newUnit {\n		font-weight:bold;\n	}\n	#wgListView .allEvents {\n		padding-left:20px;\n	}\n	#wgListView .controls {\n		margin-top:20px;\n	}	\n	#wgListView .tab:link,\n	#wgListView .tab:visited {;\n		font-weight: bold;\n		padding: 2px 15px 0px 15px;\n		text-align: center;\n		font-size: 15px;\n		line-height:15px;\n		margin-right: 5px;		\n	}\n	#wgListView .bar {\n		text-align:right;\n	}\n	* html #wgListView .bar {\n		height:1%;\n	}\n	#wgListView .bar a:hover {\n		text-decoration:underline;\n	}\n	#wgListView .allEvents {\n		padding:15px;\n	}\n	#wgListView .event {\n		margin:10px 0px;\n	}\n	#wgListView .event .wgDate {\n		font-size:9px;\n		font-style:italic;\n	}\n	#wgListView h3 a:link,\n	#wgListView h3 a:visited {\n		font-size:16px;\n		margin-bottom:2px;\n	}\n</style>\n',0,1,0,1285733364,'<style type=\"text/css\">#wgListView *{padding:0px;margin:0px;}#wgListView a:link,#wgListView a:visited{font-weight:bold;}#wgListView .newUnit{font-weight:bold;}#wgListView .allEvents{padding-left:20px;}#wgListView .controls{margin-top:20px;}#wgListView .tab:link,#wgListView .tab:visited{;font-weight:bold;padding:2px 15px 0px 15px;text-align:center;font-size:15px;line-height:15px;margin-right:5px;}#wgListView .bar{text-align:right;}* html #wgListView .bar{height:1%;}#wgListView .bar a:hover{text-decoration:underline;}#wgListView .allEvents{padding:15px;}#wgListView .event{margin:10px 0px;}#wgListView .event .wgDate{font-size:9px;font-style:italic;}#wgListView h3 a:link,#wgListView h3 a:visited{font-size:16px;margin-bottom:2px;}</style>',0),('YP9WaMPJHvCJl-YwrLVcPw',1245376837,'3','pbversion0000000000001','approved','Progress Bar','Progress Bar','admin_progress_bar','3','7','12',NULL,0,1,0,0,0,2600,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" />\n<script type=\"text/javascript\">\n/** updateWgProgressBar()\n  * called every time the server sends updated progress\n  * convenient place to hook in your own UI behaviour\n*/\nfunction updateWgProgressBar(counter, message) {\n    document.getElementById(\"progressMeter\").style.width = counter;\n    document.getElementById(\"progressStatus\").innerHTML = message;\n}\n</script>',0,1,0,1285733363,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" /><script type=\"text/javascript\">/*<![CDATA[*/function updateWgProgressBar(a,b){document.getElementById(\"progressMeter\").style.width=a;document.getElementById(\"progressStatus\").innerHTML=b}/*]]>*/</script>',0),('3n3H85BsdeRQ0I08WmvlOg',1245107956,'3','pbversion0000000000001','approved','thingy.css','thingy.css','root/import/thingy-templates/thingy.css','3','7','12',NULL,0,1,0,0,0,4731,NULL,0,1,0,1285733366,NULL,0),('FEDP3dk8J3Chw_gyr7_XEQ',1246278679,'3','pbversion0000000000001','approved','navigation.css','navigation.css','navigation.css','3','7','12',NULL,0,1,0,0,0,2437,NULL,0,1,0,1285733366,NULL,0),('f_tn9FfoSfKWX43F83v_3w',1247053009,'3','pbversion0000000000001','approved','Search','Search','root/import/search','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1247779657,NULL,0),('oGfxez5sksyB_PcaAsEm_Q',1247053097,'3','pbversion0000000000001','approved','SyndicatedContent','SyndicatedContent','root/import/syndicatedcontent','3','7','12',NULL,0,0,0,0,0,350,NULL,0,1,0,1247779657,NULL,0),('tPagC0AQErZXjLFZQ6OI1g',1246966459,'3','pbversion0000000000001','approved','ImageAsset','ImageAsset','root/import/imageasset','3','7','12',NULL,0,0,0,0,0,329,NULL,0,1,0,1247779656,NULL,0),('pbtmpl0000000000000220',1247488979,'3','pbversion0000000000001','approved','Flash Style 3 Template','Flash Style 3 Template','flash-style-3-template','3','7','12',NULL,0,0,0,0,0,1386,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script>\r\n<script type=\"text/javascript\">\r\n	swfobject.registerObject(\"myFlashContent\", \"9.0.0\", \"^Extras(ukplayer/expressinstall.swf\"););\r\n</script>\r\n',0,1,0,1285733365,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/swfobject.registerObject(\"myFlashContent\",\"9.0.0\",\"^Extras(ukplayer/expressinstall.swf\"););/*]]>*/</script>',0),('PBtmpl0000000000000001',1247535846,'3','pbversion0000000000001','approved','Admin Console','Admin Console','admin_console2','3','7','12',NULL,0,1,0,0,0,5963,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" />\n<script src=\"^Extras(adminConsole/adminConsole.js);\" type=\"text/javascript\"></script>',0,1,0,1285733358,'<link href=\"^Extras(adminConsole/adminConsole.css);\" type=\"text/css\" rel=\"stylesheet\" /><script src=\"^Extras(adminConsole/adminConsole.js);\" type=\"text/javascript\"></script>',0),('GYaFxnMu9UsEG8oanwB6TA',1246965871,'3','pbversion0000000000001','approved','Folder','Folder','root/import/folder','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1247779656,NULL,0),('pbtmpl0000000000000221',1247487940,'3','pbversion0000000000001','approved','Flash Tutorial Template','Flash Tutorial Template','flash-tutorial-template','3','7','12',NULL,0,0,0,0,0,2092,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script>\r\n<script type=\"text/javascript\">\r\n	swfobject.registerObject(\"myFlashContent\", \"9.0.0\", \"^Extras(ukplayer/expressinstall.swf\"););\r\n</script>\r\n',0,1,0,1285733365,'<script type=\"text/javascript\" src=\"^Extras(ukplayer/swfobject.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/swfobject.registerObject(\"myFlashContent\",\"9.0.0\",\"^Extras(ukplayer/expressinstall.swf\"););/*]]>*/</script>',0),('VZK3CRgiMb8r4dBjUmCTgQ',1247046242,'3','pbversion0000000000001','approved','Poll','Poll','root/import/poll','3','7','12',NULL,0,0,0,0,0,311,NULL,0,1,0,1247779656,NULL,0),('i5kt5aodVs_oepNEkE7Okw',1242312883,'3','pbversion0000000000001','approved','poll.css','poll.css','poll.css','3','7','12',NULL,0,1,0,0,0,458,NULL,0,1,0,1285733366,NULL,0),('tXwf1zaOXTvsqPn6yu-GSw',1246965607,'3','pbversion0000000000001','approved','FileAsset','FileAsset','root/import/fileasset','3','7','12',NULL,0,0,0,0,0,326,NULL,0,1,0,1247779656,NULL,0),('nFen0xjkZn8WkpM93C9ceQ',1247864696,'3','pbversion0000000000001','approved','Shelf (Default)','Shelf (Default)','root/import/shelf-default','3','7','12',NULL,0,1,0,0,0,4612,'<style type=\"text/css\">\n	@import url(^/(root/import/shelf2/shelf.css););\n</style>\n<!--[if IE]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/shelf2/shelf-ie.css););\n	</style>\n<![endif]-->',0,1,0,1285733365,'<style type=\"text/css\">@import url(^/(root/import/shelf2/shelf.css);</style>',0),('gfZOwaTWYjbSoVaQtHBBEw',1249407461,'3','pbversion0000000000001','approved','Inbox Account Layout','Inbox Account Layout','root/import/account/inbox-account-layout','3','7','12',NULL,0,1,0,0,0,3260,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0,1,0,1285733364,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('0n4HtbXaWa_XJHkFjetnLQ',1248549086,'3','pbversion0000000000001','approved','Default Inbox View Message Template','Default Inbox View Message Template','root/import/account/inbox/default-inbox-view-message-template','3','7','12',NULL,0,1,0,0,0,5000,NULL,0,1,0,1285733356,NULL,0),('ErEzulFiEKDkaCDVmxUavw',1248549086,'3','pbversion0000000000001','approved','Default Inbox Error Template','Default Inbox Error Template','root/import/account/inbox/default-inbox-error-template','3','7','12',NULL,0,1,0,0,0,732,NULL,0,1,0,1285733357,NULL,0),('DUoxlTBXhVS-Zl3CFDpt9g',1248549086,'3','pbversion0000000000001','approved','Default Message Confirm Template','Default Message Confirm Template','root/import/account/inbox/default-message-confirm-template','3','7','12',NULL,0,1,0,0,0,785,NULL,0,1,0,1285733357,NULL,0),('1Q4Je3hKCJzeo0ZBB5YB8g',1248549086,'3','pbversion0000000000001','approved','Default Manage Invitations Template','Default Manage Invitations Template','root/import/account/inbox/default-manage-invitations-template','3','7','12',NULL,0,1,0,0,0,9795,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n\n<script type=\"text/javascript\">\nYAHOO.util.Event.onDOMReady(function(){\n   function isMessageCheckBox( element ) {\n      if(element.name == \"inviteId\") return true;\n      return false;\n   }\n   \n   function toggleAllChecked(evt) {\n      var allBox     = YAHOO.util.Dom.get(\"check_all\");\n      var checkBoxes = YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"inboxTbl\");\n      for (var i = 0; i < checkBoxes.length; i++) {\n         checkBoxes[i].checked = allBox.checked;\n      }\n   }\n   \n   YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked);\n});\n</script>',0,1,0,1285733356,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){function isMessageCheckBox(a){if(a.name==\"inviteId\")return true;return false}function toggleAllChecked(b){var a=YAHOO.util.Dom.get(\"check_all\");var c=YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"inboxTbl\");for(var i=0;i<c.length;i++){c[i].checked=a.checked}}YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked)});/*]]>*/</script>',0),('5A8Hd9zXvByTDy4x-H28qw',1248549086,'3','pbversion0000000000001','approved','Default Invitation Confirmation Template','Default Invitation Confirmation Template','root/import/account/inbox/default-invitation-confirmation-template','3','7','12',NULL,0,1,0,0,0,1549,NULL,0,1,0,1285733356,NULL,0),('VBkY05f-E3WJS50WpdKd1Q',1248549087,'3','pbversion0000000000001','approved','Default View Invitation Template','Default View Invitation Template','root/import/account/inbox/default-view-invitation-template','3','7','12',NULL,0,1,0,0,0,3836,NULL,0,1,0,1285733362,NULL,0),('XgcsoDrbC0duVla7N7JAdw',1248549086,'3','pbversion0000000000001','approved','Default Invite User Email Template','Default Invite User Email Template','root/import/account/inbox/default-invite-user-email-template','3','7','12',NULL,0,1,0,0,0,490,NULL,0,1,0,1285733363,NULL,0),('cR0UFm7I1qUI2Wbpj--08Q',1248549086,'3','pbversion0000000000001','approved','Default Invite User Form Template','Default Invite User Form Template','root/import/account/inbox/default-invite-user-form-template','3','7','12',NULL,0,1,0,0,0,3967,NULL,0,1,0,1285733364,NULL,0),('SVIhz68689hwUGgcDM-gWw',1248549086,'3','pbversion0000000000001','approved','Default Invite User Confirm Template','Default Invite User Confirm Template','root/import/account/inbox/default-invite-user-confirm-template','3','7','12',NULL,0,1,0,0,0,819,NULL,0,1,0,1285733362,NULL,0),('zrNpGbT3odfIkg6nFSUy8Q',1249407461,'3','pbversion0000000000001','approved','Friends Layout Template','Friends Layout Template','root/import/account/friends/friends-layout-template','3','7','12',NULL,0,1,0,0,0,2662,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1285733366,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('1Yn_zE_dSiNuaBGNLPbxtw',1248549086,'3','pbversion0000000000001','approved','Default Friends View Template','Default Friends View Template','root/import/account/friends/default-friends-view-template','3','7','12',NULL,0,1,0,0,0,8064,NULL,0,1,0,1285733356,NULL,0),('AZFU33p0jpPJ-E6qLSWZng',1248549086,'3','pbversion0000000000001','approved','Default Friends Edit Template','Default Friends Edit Template','root/import/account/friends/default-friends-edit-template','3','7','12',NULL,0,1,0,0,0,9831,NULL,0,1,0,1285733357,NULL,0),('AGJBGviWGAwjnwziiPjvDg',1248549087,'3','pbversion0000000000001','approved','Default Send Request Template','Default Send Request Template','root/import/account/friends/default-send-request-template','3','7','12',NULL,0,1,0,0,0,2781,NULL,0,1,0,1285733357,NULL,0),('7Ijdd8SW32lVgg2H8R-Aqw',1248549086,'3','pbversion0000000000001','approved','Default Friends Error Template','Default Friends Error Template','root/import/account/friends/default-friends-error-template','3','7','12',NULL,0,1,0,0,0,776,NULL,0,1,0,1285733357,NULL,0),('K8F0j_cq_jgo8dvWY_26Ag',1248549086,'3','pbversion0000000000001','approved','Default Friends Confirmation Template','Default Friends Confirmation Template','root/import/account/friends/default-friends-confirmation-template','3','7','12',NULL,0,1,0,0,0,942,NULL,0,1,0,1285733358,NULL,0),('G5V6neXIDiFXN05oL-U3AQ',1248549087,'3','pbversion0000000000001','approved','Default Remove Friends Confirmation Template','Default Remove Friends Confirmation Template','root/import/account/friends/default-remove-friends-confirmation-template','3','7','12',NULL,0,1,0,0,0,1166,NULL,0,1,0,1285733358,NULL,0),('9ThW278DWLV0-Svf68ljFQ',1249407460,'3','pbversion0000000000001','approved','Account Layout','Account Layout','root/import/account/user/account-layout','3','7','12',NULL,0,1,0,0,0,1728,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1285733357,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('-zxyB-O50W8YnL39Ouoc4Q',1248563425,'3','pbversion0000000000001','approved','Default My Sales Template','Default My Sales Template','root/import/default-my-sales-template','3','7','12',NULL,0,1,0,0,0,3993,NULL,0,1,0,1285733356,NULL,0),('b4n3VyUIsAHyIvT-W-jziA',1249407461,'3','pbversion0000000000001','approved','Contributions Layout','Contributions Layout','root/import/account/contributions/contributions-layout','3','7','12',NULL,0,1,0,0,0,1753,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1285733363,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('PBtmpl0000000000000056',1248729559,'3','pbversion0000000000001','approved','Default Product','Default Product','default_product','3','7','12',NULL,0,1,0,0,0,13325,'<style type=\"text/css\">\n	.wgProduct {\n\n	}\n	.wgProduct h3.title {\n		margin-bottom:2px;\n		padding-bottom:0px;\n	}\n	.wgProduct .images {\n		float:left;\n		min-width:1%;\n		margin:10px;\n	}\n	.wgProduct .images ul, \n	.wgProduct .images li {\n		padding:0px;\n		margin:0px;\n		margin-left:15px;\n		color:#787878;\n	}	\n	.wgProduct .images .controls .title {\n		background-color:#E0E0E0;\n		padding:2px;\n		font-weight:bold;\n		margin-bottom:5px;\n	}	\n	.wgProduct .images .controls {\n		margin-top:10px;\n		display:block;\n		background-color:#F1F1F1;\n		padding-bottom:5px;\n		border:1px ridge #E0E0E0;		\n	}\n	.wgProduct .images .controls a {\n		font-size:10px;\n		letter-spacing:0px;\n		display:block;\n		padding:0px 3px;\n		color:#787878;\n	}	\n	.wgProduct .images .buttons {\n		margin:10px 0px;\n	}\n	.wgProduct .images .buttons a {\n		background-color:#F1F1F1;\n		padding:2px 5px;\n		color:#787878;\n		text-decoration:none;\n		border:1px ridge #E0E0E0;\n		font-size:10px;\n		display:block;\n		margin:1px 0px;\n	}\n	\n	\n	\n	\n	.wgProduct .product {\n		float:left;\n		margin-left:40px;\n		padding:0px 10px 10px 0px;\n	}\n	.wgProduct .product .description {\n		margin-left:-20px;\n	}\n	.wgProduct .product form {\n		margin:20px 0px;\n	}	\n	.wgProduct .product ul,\n	.wgProduct .product li {\n		margin:0px;\n		padding:0px;\n	}\n	.wgProduct .product ul {\n		margin-bottom:15px;\n	}\n	.wgProduct .product li {\n		margin-left:15px;\n	}\n\n.hoverbox {\n	cursor: default;\n	list-style: none;\n}\n\n.hoverbox a {\n	cursor: default;\n}\n\n.hoverbox a .bigImage {\n	display: none;\n}\n\n.hoverbox a:hover .bigImage {\n	display: block;\n	position: absolute;\n	top: -33px;\n	left: -45px;\n	z-index: 1;\n}\n\n.hoverbox img {\n	background: #fff;\n	border: 1px solid #000000;\n	color: inherit;\n	padding: 2px;\n	vertical-align: top;\n}\n\n.hoverbox li\n{\n	background: #eee;\n	border: 1px solid #000000;\n	color: inherit;\n	display: inline;\n	float: left;\n	margin: 3px;\n	padding: 5px;\n	position: relative;\n}\n\n\n\n.hoverbox .bigImage {\n	border-color: #000;\n	max-width: 600px;\n	max-height: 480px;\n}		\n</style>\n\n',0,1,0,1285733360,'<style type=\"text/css\">.wgProduct{}.wgProduct h3.title{margin-bottom:2px;padding-bottom:0px;}.wgProduct .images{float:left;min-width:1%;margin:10px;}.wgProduct .images ul,.wgProduct .images li{padding:0px;margin:0px;margin-left:15px;color:#787878;}.wgProduct .images .controls .title{background-color:#E0E0E0;padding:2px;font-weight:bold;margin-bottom:5px;}.wgProduct .images .controls{margin-top:10px;display:block;background-color:#F1F1F1;padding-bottom:5px;border:1px ridge #E0E0E0;}.wgProduct .images .controls a{font-size:10px;letter-spacing:0px;display:block;padding:0px 3px;color:#787878;}.wgProduct .images .buttons{margin:10px 0px;}.wgProduct .images .buttons a{background-color:#F1F1F1;padding:2px 5px;color:#787878;text-decoration:none;border:1px ridge #E0E0E0;font-size:10px;display:block;margin:1px 0px;}.wgProduct .product{float:left;margin-left:40px;padding:0px 10px 10px 0px;}.wgProduct .product .description{margin-left:-20px;}.wgProduct .product form{margin:20px 0px;}.wgProduct .product ul,.wgProduct .product li{margin:0px;padding:0px;}.wgProduct .product ul{margin-bottom:15px;}.wgProduct .product li{margin-left:15px;}.hoverbox{cursor:default;list-style:none;}.hoverbox a{cursor:default;}.hoverbox a .bigImage{display:none;}.hoverbox a:hover .bigImage{display:block;position:absolute;top:-33px;left:-45px;z-index:1;}.hoverbox img{background:#fff;border:1px solid #000000;color:inherit;padding:2px;vertical-align:top;}.hoverbox li{background:#eee;border:1px solid #000000;color:inherit;display:inline;float:left;margin:3px;padding:5px;position:relative;}.hoverbox .bigImage{border-color:#000;max-width:600px;max-height:480px;}</style>',0),('i9-G00ALhJOr0gMh-vHbKA',1250408924,'3','pbversion0000000000001','approved','Inbox SMS Notification','Inbox SMS Notification','root/import/inbox-sms-notification','3','7','4',NULL,0,0,0,0,0,446,NULL,0,1,0,1285733364,NULL,0),('ohjyzab5i-yW6GOWTeDUHg',1251425384,'3','pbversion0000000000001','approved','Default Manage Ad Sku Template','Default Manage Ad Sku Template','root/import/ad-sku/default-manage-ad-sku-template','3','7','12',NULL,0,0,0,0,0,2567,NULL,0,1,0,1285733365,NULL,0),('AldPGu0u-jm_5xK13atCSQ',1251419124,'3','pbversion0000000000001','approved','Default Purchase Ad Sku Template','Default Purchase Ad Sku Template','root/import/ad-sku/default-purchase-ad-sku-template','3','7','12',NULL,0,0,0,0,0,4230,NULL,0,1,0,1285733357,NULL,0),('5bnNzteN7w3NnK9mF4XiCg',1250243000,'3','pbversion0000000000001','approved','Survey','Survey','root/import/survey','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1253052788,NULL,0),('PBtmpl0000000000000063',1250243000,'3','pbversion0000000000001','approved','Default Overview Report','Default Overview Report','root/import/survey/default-overview-report','3','7','12',NULL,0,1,0,0,0,5835,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000062',1250243000,'3','pbversion0000000000001','approved','Default Gradebook Report','Default Gradebook Report','root/import/survey/default-gradebook-report','3','7','12',NULL,0,1,0,0,0,4863,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000061',1250243000,'3','pbversion0000000000001','approved','Default Survey','Default Survey','root/import/survey/default-survey','3','7','12',NULL,0,1,0,0,0,2968,NULL,0,1,0,1285733360,NULL,0),('CxMpE_UPauZA3p8jdrOABw',1250243000,'3','pbversion0000000000001','approved','Default Questions','Default Questions','root/import/survey/default-questions','3','7','12',NULL,0,1,0,0,0,17836,NULL,0,1,0,1285733357,NULL,0),('1oBRscNIcFOI-pETrCOspA',1250243000,'3','pbversion0000000000001','approved','Default Section Edit','Default Section Edit','root/import/survey/default-section-edit','3','7','12',NULL,0,1,0,0,0,14088,NULL,0,1,0,1285733356,NULL,0),('wAc4azJViVTpo-2NYOXWvg',1250243000,'3','pbversion0000000000001','approved','Default Question Edit','Default Question Edit','root/import/survey/default-question-edit','3','7','12',NULL,0,1,0,0,0,12766,NULL,0,1,0,1285733365,NULL,0),('AjhlNO3wZvN5k4i4qioWcg',1250243000,'3','pbversion0000000000001','approved','Default Answer Edit','Default Answer Edit','root/import/survey/default-answer-edit','3','7','12',NULL,0,1,0,0,0,9595,NULL,0,1,0,1285733357,NULL,0),('RSAMkc6WQmfRE3TOr1_3Mw',1250243000,'3','pbversion0000000000001','approved','ExpireIncompleteSurveyResponses','ExpireIncompleteSurveyResponses','root/import/expireincompletesurveyresponses','3','7','12',NULL,0,1,0,0,0,399,NULL,0,1,0,1253052788,NULL,0),('ExpireIncResptmpl00001',1250243000,'3','pbversion0000000000001','approved','ExpireIncompleteSurveyResponses','ExpireIncompleteSurveyResponses','root/import/expireincompletesurveyresponses/expireincompletesurveyresponses','3','7','12',NULL,0,1,0,0,0,810,NULL,0,1,0,1285733357,NULL,0),('7F-BuEHi7t9bPi008H8xZQ',1250243000,'3','pbversion0000000000001','approved','Default Survey Summary','Default Survey Summary','root/import/survey/default-survey-summary','3','7','12',NULL,0,1,0,0,0,2300,NULL,0,1,0,1285733357,NULL,0),('S3zpVitAmhy58CAioH359Q',1250243000,'3','pbversion0000000000001','approved','Default Test Results','Default Test Results','root/import/survey/default-test-results','3','7','12',NULL,0,1,0,0,0,8673,'<style type=\"text/css\">\n.fail {\n  color: red;\n}\n.pass {\n  color: green;\n}\n/* All lines other than tests */\n.plan, .pragma, .comment, .bailout, .version, .unknown {\n  color: blue;\n}\n</style>',0,1,0,1285733362,'<style type=\"text/css\">.fail{color:red;}.pass{color:green;}.plan,.pragma,.comment,.bailout,.version,.unknown{color:blue;}</style>',0),('nWNVoMLrMo059mDRmfOp9g',1250243000,'3','pbversion0000000000001','approved','Default Feedback','Default Feedback','root/import/survey/default-feedback','3','7','12',NULL,0,1,0,0,0,1235,NULL,0,1,0,1285733365,NULL,0),('newslettercs0000000001',1252682678,'3','pbversion0000000000001','approved','Newsletter Manager (default)',' Newsletter Manager','newslettercstemplate','3','7','3',NULL,0,0,0,0,0,2824,'<style type=\"text/css\">\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n</style>\n',0,1,0,1285733365,'<style type=\"text/css\">.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}</style>',0),('1IzRpX0tgW7iuCfaU2Kk0A',1250243000,'3','pbversion0000000000001','approved','Default Contributions View','Default Contributions View','root/import/account/contributions/default-contributions-view','3','7','12',NULL,0,1,0,0,0,7799,'<link rel=\"stylesheet\" href=\"^/(root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1285733356,'<link rel=\"stylesheet\" href=\"^/(root/import/account/account.css);\" type=\"text/css\">',0),('0EAJ9EYb9ap2XwfrcXfdLQ',1250243000,'3','pbversion0000000000001','approved','Story Archive Asset List','Story Archive Asset List','root/import/storymanager/keywordlist','3','7','4',NULL,0,0,0,0,0,579,NULL,0,1,0,1285733356,NULL,0),('TKmhv8boP3TD2xwSwUBq0g',1250243000,'3','pbversion0000000000001','approved','Default ThingyRecord View','Default ThingyRecord View','home/thinyrecord-templates/default-thingyrecord-view','3','7','3',NULL,0,1,0,0,0,1789,NULL,0,1,0,1285733362,NULL,0),('d8jMMMRddSQ7twP4l1ZSIw',1253555614,'3','pbversion0000000000001','approved','Default Survey Take','Default Survey Take','root/import/survey/default-survey-take','3','7','12',NULL,0,1,0,0,0,3994,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts-min.css);\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/assets/skins/sam/skin.css);\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^/(survey.css);\" />\n\n',0,1,0,1285733364,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts-min.css);\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/assets/skins/sam/skin.css);\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"^/(survey.css);\" />',0),('fowHfgOkJtAxdst7rugTog',1252595993,'3','pbversion0000000000001','approved','Story Manager','Story Manager','root/import/storymanager','3','7','12',NULL,0,1,0,0,0,339,'\r\n',0,1,0,1253676393,NULL,0),('3QpYtHrq_jmAk1FNutQM5A',1253636379,'3','pbversion0000000000001','approved','Story Template','Story Template','root/import/storymanager/storytemplate','3','7','4',NULL,0,0,0,0,0,6662,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\">\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/carousel/carousel-min.js);\"></script>',0,1,0,1285733356,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\"><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/carousel/carousel-min.js);\"></script>',0),('yxD5ka7XHebPLD-LXBwJqw',1253635396,'3','pbversion0000000000001','approved','StoryArchive','StoryArchive','root/import/storymanager/storyarchive','3','7','4',NULL,0,0,0,0,0,3375,'<link href=\"^/(storymanager.css);\" rel=\"stylesheet\" type=\"text/css\" />',0,1,0,1285733365,'<link href=\"^/(storymanager.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('E3tzZjzhmYoNlAyP2VW33Q',1253635296,'3','pbversion0000000000001','approved','Edit Story','Edit Story','root/import/storymanager/editstory','3','7','4',NULL,0,0,0,0,0,5987,'<link href=\"^/(storymanager.css);\" rel=\"stylesheet\" type=\"text/css\" />',0,1,0,1285733357,'<link href=\"^/(storymanager.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('TbDcVLbbznPi0I0rxQf2CQ',1253636379,'3','pbversion0000000000001','approved','Story Template Topic','Story Template Topic','root/import/storymanager/storytemplatetopic','3','7','4',NULL,0,0,0,0,0,7134,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel-skin.css);\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^/(storymanager.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/carousel/carousel-min.js);\"></script>',0,1,0,1285733362,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\"><link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel-skin.css);\"><link rel=\"stylesheet\" type=\"text/css\" href=\"^/(storymanager.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/carousel/carousel-min.js);\"></script>',0),('iCM9pRY5yYyjufROgaCDlg',1253305659,'3','pbversion0000000000001','approved','storyManager.css','storyManager.css','storymanager.css','3','7','12',NULL,0,1,0,0,0,4360,NULL,0,1,0,1285733366,NULL,0),('VyCINX2KixKYr2pzQGX9Mg',1254881103,'3','pbversion0000000000001','approved','layout.css','layout.css','layout.css','3','7','12',NULL,0,1,0,0,0,1439,'\r\n',0,1,0,1285733366,NULL,0),('TvOZs8U1kRXLtwtmyW75pg',1256092368,'3','pbversion0000000000001','approved','Article','Article','root/import/article','3','7','12',NULL,0,0,0,0,0,322,'\r\n',0,1,0,1256092370,NULL,0),('zb_OPKNqcTuIjdvvbEkRjw',1256092368,'3','pbversion0000000000001','approved','article.css','article.css','article.css','3','7','12',NULL,0,1,0,0,0,723,'\r\n',0,1,0,1285733367,NULL,0),('brxm_faNdZX5tRo3p50g3g',1256092368,'3','pbversion0000000000001','approved','Map Templates','Map Templates','home/map/map-templates','3','7','3',NULL,0,0,0,0,0,336,'\r\n',0,1,0,1256092370,NULL,0),('PBrichedit000000000001',1256092369,'3','pbversion0000000000001','approved','Content Manager\'s Rich Edit','Content Manager\'s Rich Edit','content_managers_rich_edit','3','7','12',NULL,0,0,0,0,0,572,'\r\n',0,1,0,1256092370,NULL,0),('l0guT3vTR3B8cL6vtP-g3A',1285733528,'3','pbversion0000000000001','approved','Contribute','contribute','contribute','3','7','3',NULL,0,1,0,0,0,3239,NULL,0,1,0,1285733528,NULL,0),('Qk24uXao2yowR6zxbVJ0xA',1285733565,'3','pbversion0000000000001','approved','[style] Underground','[style] Underground','style-underground/style-underground','3','7','3','by Doug from Plain Black http://plainblack.com\r\n\r\nThis is the Underground style from http://www.styleshout.com/ made into a WebGUI package. A simple, functional style.',0,1,0,0,0,4472,NULL,0,1,0,1285733565,NULL,0),('pbrobot000000000000001',1256092369,'3','pbversion0000000000001','approved','robots.txt','robots.txt','robots.txt','3','7','12',NULL,0,0,0,0,0,562,NULL,0,1,0,1285733366,NULL,0),('4qh0kIsFUdd4Ox-Iu1JZgg',1257311886,'3','pbversion0000000000001','approved','EMS','EMS','root/import/ems','3','7','12',NULL,0,1,0,0,0,310,'\r\n',0,1,0,1257311889,NULL,0),('OOyMH33plAy6oCj_QWrxtg',1257311886,'3','pbversion0000000000001','approved','Lookup Registrant (Default)','Lookup Registrant (Default)','root/import/ems/lookup-registrant-default','3','7','12',NULL,0,1,0,0,0,7007,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n\n\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\">\ndiv.search, p {\n	text-align: left;\n}\n\n</style>\n',0,1,0,1285733358,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><style type=\"text/css\">div.search,p{text-align:left;}</style>',0),('PsFn7dJt4wMwBa8hiE3hOA',1257311886,'3','pbversion0000000000001','approved','Print Badge (Default)','Print Badge (Default)','root/import/ems/print-badge-default','3','7','12',NULL,0,1,0,0,0,2323,NULL,0,1,0,1285733362,NULL,0),('yBwydfooiLvhEFawJb0VTQ',1257311887,'3','pbversion0000000000001','approved','Print Ticket (Default)','Print Ticket (Default)','root/import/ems/print-ticket-default','3','7','12',NULL,0,1,0,0,0,2386,NULL,0,1,0,1285733365,NULL,0),('PBEmsBadgeTemplate0000',1257311887,'3','pbversion0000000000001','approved','Default EMS Badge Template','Default EMS Badge Template','default_emsbadge','3','7','4',NULL,0,0,0,0,0,2607,NULL,0,1,0,1285733358,NULL,0),('S2_LsvVa95OSqc66ITAoig',1257311887,'3','pbversion0000000000001','approved','EMS Schedule Listing (default)','EMS Schedule Listing (default)','root/import/ems/ems-schedule-listing-default2','3','7','12',NULL,0,1,0,0,0,14216,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\n\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n	<style type=\"text/css\">\n        #emsDatePaginator {\n                       display: inline; \n                       float : left;\n                       width:  100px;\n        }\n	 #emsDatePaginator .yui-pg-pages { \n	     display: block; \n	} \n	#emsDatePaginator .yui-pg-page { \n	    display: block; \n	    background-color: blue; \n	    background: transparent; \n	    border: none; \n	    white-space: normal; \n	} \n	#emsDatePaginator .yui-pg-current-page { \n	    background-color: white; \n        }\n                .locationHeader {\n                       font-weight: bold;\n                       color: blue;\n                 }\n                .dateHeader {\n                       font-weight: bold;\n                       color: green;\n                 }\n                .datePaginatorLink {\n		     background-color: blue;\n                 }\n                .emptyCell {\n		     background-color: light-grey;\n                 }\n		.eventDescription {\n		     background-color: white;\n		    max-width: 400px;\n		    border:1px solid #000;\n		    padding:10px;\n		}\n		.forwardButton {\n			background-color: green;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n		.backwardButton {\n			background-color: red;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n                .yui-dt thead {display:none;} \n	</style>\n',0,1,0,1285733362,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><style type=\"text/css\">#emsDatePaginator{display:inline;float:left;width:100px;}#emsDatePaginator .yui-pg-pages{display:block;}#emsDatePaginator .yui-pg-page{display:block;background-color:blue;background:transparent;border:none;white-space:normal;}#emsDatePaginator .yui-pg-current-page{background-color:white;}.locationHeader{font-weight:bold;color:blue;}.dateHeader{font-weight:bold;color:green;}.datePaginatorLink{background-color:blue;}.emptyCell{background-color:light-grey;}.eventDescription{background-color:white;max-width:400px;border:1px solid #000;padding:10px;}.forwardButton{background-color:green;color:white;font-weight:bold;padding:3px;}.backwardButton{background-color:red;color:white;font-weight:bold;padding:3px;}.yui-dt thead{display:none;}</style>',0),('hreA_bgxiTX-EzWCSZCZJw',1257311887,'3','pbversion0000000000001','approved','Print Remaining Tickets Template (default)','Print Remaining Tickets Template (default)','root/import/ems/default-print-remaining-tickets-template','3','7','12',NULL,0,1,0,0,0,2345,'\r\n',0,1,0,1285733364,NULL,0),('9j0_Z1j3Jd0QBbY2akb6qw',1257311887,'3','pbversion0000000000001','approved','Default Map View','Default Map View','home/map/map-templates/default-map-view','3','7','3',NULL,0,1,0,0,0,1293,'<style type=\"text/css\">\r\n.wg_editMapPoint label {\r\n    display: block;\r\n}\r\n.wg_editMapPoint input, .wg_editMapPoint textarea, .wg_editMapPoint select {\r\n    display: block;\r\n}\r\n.wg_editMapPoint textarea {\r\n    width: 100%;\r\n}\r\n\r\n#editPoint .bd { height: 500px; width: 500px; overflow-y: scroll }\r\n</style>',0,1,0,1285733357,'<style type=\"text/css\">.wg_editMapPoint label{display:block;}.wg_editMapPoint input,.wg_editMapPoint textarea,.wg_editMapPoint select{display:block;}.wg_editMapPoint textarea{width:100%;}#editPoint .bd{height:500px;width:500px; overflow-y: scroll}</style>',0),('-K8Hj45mbelljN9-0CXZxg',1257311887,'3','pbversion0000000000001','approved','DataForm','DataForm','root/import/dataform','3','7','12',NULL,0,0,0,0,0,336,NULL,0,1,0,1257311888,NULL,0),('PBtmpl0000000000000020',1257311887,'3','pbversion0000000000001','approved','Mail Form','Mail Form','mail_form','3','7','12',NULL,0,1,0,0,0,4606,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.fontSettings{\n	font-family:arial;\n	font-size:9pt;\n}\n.mailForm td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>\n',0,1,0,1285733359,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.fontSettings{font-family:arial;font-size:9pt;}.mailForm td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('PBtmpl0000000000000104',1257311888,'3','pbversion0000000000001','approved','Default Acknowledgement','Default Acknowledgement','default_acknowledgement','3','7','12',NULL,0,1,0,0,0,1750,'<style type=\"text/css\">\n.acknowledgement\n{\n	margin-top:5px;\n}\n.acknowledgement td\n{\n	font-size:9pt;\n	font-family:arial;\n}\n\na.blackLabel\n{\n	color:#29587E;\n}\n\n</style>',0,1,0,1285733361,'<style type=\"text/css\">.acknowledgement{margin-top:5px;}.acknowledgement td{font-size:9pt;font-family:arial;}a.blackLabel{color:#29587E;}</style>',0),('68sKwDgf9cGH58-NZcU4lg',1271355027,'1','pbversion0000000000001','approved','Welcome','Home','home','3','7','3',NULL,0,0,0,0,0,357,NULL,0,1,0,1280279778,NULL,0),('_iHetEvMQUOoxS-T2CM0sQ',1273172789,'1','pbversion0000000000001','approved','Getting Started','Getting Started','getting_started','3','7','3',NULL,0,0,0,0,0,392,NULL,0,1,0,1280279778,NULL,0),('bX5rYxb6tZ9docY6sUhBlw',1278013772,'1','pbversion0000000000001','approved','Getting Started','Getting Started','getting_started/getting-started','3','7','4',NULL,0,1,0,0,0,1253,NULL,0,1,0,1280279778,NULL,0),('NK8bqlwVRILJknqeCDPBHg',1278013933,'1','pbversion0000000000001','approved','Getting Started (part 2)','Getting Started (part 2)','getting_started/getting-started-part2','3','7','4',NULL,0,1,0,0,0,1513,NULL,0,1,0,1280279778,NULL,0),('8Bb8gu-me2mhL3ljFyiWLg',1271359194,'1','pbversion0000000000001','approved','Talk to the Experts','Your Next Step','your_next_step','3','7','3',NULL,0,0,0,0,0,869,NULL,0,1,0,1280279778,NULL,0),('ix1p0AbwKAz8QWB-T-HHfg',1271359087,'1','pbversion0000000000001','approved','Get Support','Get Support','yns/support','3','7','4',NULL,0,1,0,0,0,739,NULL,0,1,0,1280279778,NULL,0),('iCYOjohB9SKvAPr6bXElKA',1271445525,'1','pbversion0000000000001','approved','Get Hosting','Get Hosting','yns/hosting','3','7','4',NULL,0,1,0,0,0,749,NULL,0,1,0,1280279778,NULL,0),('PBtmpl0000000000000116',1257311888,'3','pbversion0000000000001','approved','Tab Form','Tab Form','tab_form','3','7','12',NULL,0,1,0,0,0,5745,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.fontSettings{\n	font-family:arial;\n	font-size:9pt;\n}\n.tabForm td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>\n',0,1,0,1285733361,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.fontSettings{font-family:arial;font-size:9pt;}.tabForm td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('PBtmpl0000000000000141',1257311888,'3','pbversion0000000000001','approved','Default DataForm','Default DataForm','pbtmpl0000000000000141','3','7','12',NULL,0,1,0,0,0,6035,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.errors{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultData td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>\n',0,1,0,1285733361,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.errors{font-family:arial;font-size:9pt;}.defaultData td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('_aE16Rr1-bXBf8SIaLZjCg',1257311888,'3','pbversion0000000000001','approved','picklanguage','picklanguage','media/picklanguage','3','7','12',NULL,0,1,0,0,0,617,'\r\n',0,1,0,1285733363,NULL,0),('P_4uog81vSUK4KxuW_4GUA',1258524916,'3','pbversion0000000000001','approved','css','css','css','3','7','12',NULL,0,1,0,0,0,298,'\r\n',0,1,0,1258524918,NULL,0),('PBtmpl0000000000000060',1258524916,'3','pbversion0000000000001','approved','Fail Safe','Fail Safe','fail_safe','3','7','12',NULL,0,1,0,0,0,2413,NULL,0,1,0,1285733360,NULL,0),('Am1J-meNBmhqFfEIWy6Gag',1286941531,'1','pbversion0000000000001','approved','crystalX_Navigation','crystalX_Navigation','crystalx/crystalx_navigation','3','7','3',NULL,0,1,0,0,0,406,NULL,1,1,0,1286941531,NULL,0),('PBtmpl0000000000000137',1258524916,'3','pbversion0000000000001','approved','Admin Console Style','Admin Console','admin_console','3','7','12',NULL,0,1,0,0,0,1283,NULL,0,1,0,1285733361,NULL,0),('PBtmpl0000000000000132',1258524916,'3','pbversion0000000000001','approved','Empty','Empty','empty','3','7','12',NULL,0,1,0,0,0,296,NULL,0,1,0,1285733361,NULL,0),('PBtmplBlankStyle000001',1258524916,'3','pbversion0000000000001','approved','WebGUI 6 Blank Style','WebGUI 6 Blank Style','pbtmplblankstyle000001','3','7','12',NULL,0,1,0,0,0,1970,NULL,0,1,0,1285733362,NULL,0),('uCn31PzislTZlgt_79j7cQ',1258524916,'3','pbversion0000000000001','approved','style.css','style.css','css/style.css','3','7','12',NULL,0,1,0,0,0,1019,'\r\n',0,1,0,1285733367,NULL,0),('H_-8zjtWsO1FUpQqNtkxNQ',1258524916,'3','pbversion0000000000001','approved','wg-base.css','wg-base.css','css/wg-base.css','3','7','12',NULL,0,1,0,0,0,1138,'\r\n',0,1,0,1285733366,NULL,0),('PBtmpl0000000000000117',1259133274,'3','pbversion0000000000001','approved','DropMenu','DropMenu','dropmenu','3','7','12',NULL,0,1,0,0,0,2660,'<script type=\"text/javascript\" defer=\"defer\">\n//<![CDATA[\nfunction go(formObj) {\n	if (formObj.chooser.options[formObj.chooser.selectedIndex].value != \"none\") {\n		location = formObj.chooser.options[formObj.chooser.selectedIndex].value;\n	}\n}\n//]]>\n</script>',0,1,0,1285733361,'<script type=\"text/javascript\" defer=\"defer\">/*<![CDATA[*/function go(a){if(a.chooser.options[a.chooser.selectedIndex].value!=\"none\"){location=a.chooser.options[a.chooser.selectedIndex].value}}/*]]>*/</script>',0),('PBtmpl0000000000000136',1259133274,'3','pbversion0000000000001','approved','Synopsis','Synopsis','synopsis2','3','7','12',NULL,0,1,0,0,0,1734,NULL,0,1,0,1285733361,NULL,0),('PBtmpl0000000000000093',1259133274,'3','pbversion0000000000001','approved','crumbTrail','crumbTrail','crumbtrail2','3','7','12',NULL,0,1,0,0,0,1494,NULL,0,1,0,1285733360,NULL,0),('GNvjCFQWjY2AF2uf0aCM8Q',1259133274,'3','pbversion0000000000001','approved','Syndicated Articles','Syndicated Articles','syndicated_articles','3','7','12',NULL,0,1,0,0,0,2472,NULL,0,1,0,1285733358,NULL,0),('-PkdI8l1idu-8gDX3iOdcw',1259133274,'3','pbversion0000000000001','approved','One Over Two','One Over Two','one_over_two','3','7','12',NULL,0,1,0,0,0,6326,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1285733356,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000103',1259133275,'3','pbversion0000000000001','approved','Article With Image','Article With Image','article-with-image','3','7','12',NULL,0,1,0,0,0,2130,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--article-->',0,1,0,1285733361,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000024',1259133275,'3','pbversion0000000000001','approved','File','File','file','3','7','12',NULL,0,1,0,0,0,940,NULL,0,1,0,1285733359,NULL,0),('XdlKhCDvArs40uqBhvzR3w',1259133275,'3','pbversion0000000000001','approved','Article With Pagination','Article With Pagination','article-with-pagination','3','7','12',NULL,0,1,0,0,0,3274,'\n',0,1,0,1285733363,NULL,0),('PBnav00000000indentnav',1259133275,'3','pbversion0000000000001','approved','Indent Nav','Indent Nav','indent_nav','3','7','12',NULL,0,0,0,0,0,1978,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0,1,0,1285733358,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000124',1259133275,'3','pbversion0000000000001','approved','Tabs','Tabs','tabs','3','7','12',NULL,0,1,0,0,0,1766,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0,1,0,1285733361,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000131',1259133275,'3','pbversion0000000000001','approved','Right Column','Right Column','right_column','3','7','12',NULL,0,1,0,0,0,4905,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1285733361,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000134',1259133275,'3','pbversion0000000000001','approved','Hierarchical Top Nav','Hierarchical Top Nav','import/hierarchical-top-nav','3','7','12',NULL,0,1,0,0,0,4021,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>\n<!-- Page-specific script -->\n<script type=\"text/javascript\">\n//<![CDATA[\n    YAHOO.util.Event.onAvailable(\"webguinavigation\", function() {\n        var wgMenuBar = new YAHOO.widget.MenuBar(\"webguinavigation\", {\n            autosubmenudisplay : true,\n            showdelay          : 250,\n            hidedelay          : 750,\n            lazyload           : true\n        });\n        wgMenuBar.render();\n    });\n//]]>\n</script>\n',0,1,0,1285733361,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onAvailable(\"webguinavigation\",function(){var a=new YAHOO.widget.MenuBar(\"webguinavigation\",{autosubmenudisplay:true,showdelay:250,hidedelay:750,lazyload:true});a.render()});/*]]>*/</script>',0),('PBtmpl0000000000000088',1259133275,'3','pbversion0000000000001','approved','Image','Image','image','3','7','12',NULL,0,1,0,0,0,827,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000078',1259133275,'3','pbversion0000000000001','approved','File Folder','File Folder','file_folder','3','7','12',NULL,0,1,0,0,0,3834,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000055',1259133275,'3','pbversion0000000000001','approved','Default Poll','Default Poll','default_poll','3','7','12',NULL,0,1,0,0,0,3032,'<link href=\"^/(poll.css);\" type=\"text/css\" rel=\"stylesheet\" /><!--poll-->',0,1,0,1285733360,'<link href=\"^/(poll.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000065',1259133275,'3','pbversion0000000000001','approved','Default Syndicated Content','Default Syndicated Content','default_syndicated_content','3','7','12',NULL,0,1,0,0,0,2387,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000054',1259133276,'3','pbversion0000000000001','approved','Default Page','Default Page','default_page','3','7','12',NULL,0,1,0,0,0,3083,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1285733360,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000108',1259133276,'3','pbversion0000000000001','approved','horizontalMenu','horizontalMenu','horizontalmenu','3','7','12',NULL,0,1,0,0,0,1982,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0,1,0,1285733361,'<link href=\"^/(navigation.css);\" type=\"text/css\" rel=\"stylesheet\" />',0),('PBtmpl0000000000000115',1259133276,'3','pbversion0000000000001','approved','Linked Image with Caption','Linked Image with Caption','linked_image_with_caption','3','7','12',NULL,0,1,0,0,0,2393,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--article-->',0,1,0,1285733361,'<link href=\"^/(article.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000109',1259133276,'3','pbversion0000000000001','approved','One Over Three','One Over Three','one_over_three','3','7','12',NULL,0,1,0,0,0,7968,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1285733361,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('VCFhB9WOsDsH2Apj3c6DpQ',1259133276,'3','pbversion0000000000001','approved','Three Columns','Three Columns','three-columns','3','7','12',NULL,0,1,0,0,0,5947,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->',0,1,0,1285733362,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBtmpl0000000000000002',1259133276,'3','pbversion0000000000001','approved','Default Article','Default Article','default_article','3','7','12',NULL,0,1,0,0,0,2241,NULL,0,1,0,1285733358,NULL,0),('PBtmpl0000000000000123',1259133276,'3','pbversion0000000000001','approved','Item','Item','item','3','7','12',NULL,0,1,0,0,0,2232,NULL,0,1,0,1285733361,NULL,0),('PBtmpl0000000000000200',1259133276,'3','pbversion0000000000001','approved','Default Search','Default Search','default_search2','3','7','12',NULL,0,0,0,0,0,4007,NULL,0,1,0,1285733361,NULL,0),('PBtmpl0000000000000135',1259133276,'3','pbversion0000000000001','approved','Side By Side','Side By Side','side_by_side','3','7','12',NULL,0,1,0,0,0,4489,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" /><!--page layout-->\n',0,1,0,1285733361,'<link href=\"^/(layout.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('PBnav00000000000bullet',1259133276,'3','pbversion0000000000001','approved','Bulleted List','Bulleted List','bulleted_list','3','7','12',NULL,0,0,0,0,0,2744,'<style type=\"text/css\">\nul.bulletList li, ul.bulletList ul {\n	margin-left:7px;\n	padding-left:0px;\n	font-size:9px;	\n}\n\n.bulletList .level0 {\n	font-size:13px;\n}\n\n.bulletList .level1 {\n	font-size:11px;\n}\n</style>\n\n',0,1,0,1285733358,'<style type=\"text/css\">ul.bulletList li,ul.bulletList ul{margin-left:7px;padding-left:0px;font-size:9px;}.bulletList .level0{font-size:13px;}.bulletList .level1{font-size:11px;}</style>',0),('MK4fCNoyrx5SE8eyDfOpxg',1259133276,'3','pbversion0000000000001','approved','Flash File','Flash File','flash-file','3','7','12',NULL,0,1,0,0,0,1861,NULL,0,1,0,1285733358,NULL,0),('PBtmpl0000000000000130',1259133276,'3','pbversion0000000000001','approved','Tree Navigation','Tree Navigation','root/import/navigation/tree-navigation','3','7','12',NULL,0,1,0,0,0,3529,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/treeview/assets/skins/sam/treeview.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/treeview/treeview-min.js);\"></script>\n',0,1,0,1285733361,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/treeview/assets/skins/sam/treeview.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/treeview/treeview-min.js);\"></script>',0),('BMybD3cEnmXVk2wQ_qEsRQ',1263962529,'3','pbversion0000000000001','approved','Badge Builder (Default)','Badge Builder (Default)','root/import/ems/badge-builder-default','3','7','12',NULL,0,1,0,0,0,36631,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\r\n\r\n\r\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui/build/tabview/tabview-min.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(/yui-webgui/build/string/string.js);\" type=\"text/javascript\"></script>\r\n\r\n<style type=\"text/css\">\r\n		.skuDescription {\r\n		background-color: white;\r\n		max-width: 400px;\r\n		border:1px solid #000;\r\n		padding:10px;\r\n		}\r\n		.forwardButton {\r\n			background-color: green;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		.backwardButton {\r\n			background-color: red;\r\n			color: white;\r\n			font-weight: bold;\r\n			padding: 3px;\r\n		}\r\n		#emstickets p, #emsribbons p, #emstokens p { text-align: left; padding: 5px; }\r\n		#badge {\r\n			font-size: 15px;\r\n			-moz-border-radius: 10px;\r\n			-webkit-border-radius: 10px;\r\n			border-radius: 10px;\r\n			border: 3px solid #2647a0;\r\n		}\r\n		#badgeHolderName {\r\n			background-color: #2647a0;\r\n			width: 100%;\r\n			color: white;\r\n			font-family: bold;\r\n			font-size: 25px;\r\n			padding: 5px 0px 5px 0px;\r\n			margin: 5px 0px 5px 0px;\r\n			margin-bottom: 5px;\r\n		}\r\n		#badgeTicketList div , #badgeRibbonList div , #badgeTokenList div {\r\n			border-top: 1px solid #808080;\r\n			width: 100%;\r\n			font-size: 13px;\r\n			padding: 5px 0px 5px 0px;\r\n			margin-top: 5px;\r\n		}\r\n</style>\r\n\r\n',0,1,0,1285733357,'<link href=\"^Extras(/yui/build/reset-fonts-grids/reset-fonts-grids.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/tabview/tabview-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui-webgui/build/string/string.js);\" type=\"text/javascript\"></script><style type=\"text/css\">.skuDescription{background-color:white;max-width:400px;border:1px solid #000;padding:10px;}.forwardButton{background-color:green;color:white;font-weight:bold;padding:3px;}.backwardButton{background-color:red;color:white;font-weight:bold;padding:3px;}#emstickets p,#emsribbons p,#emstokens p{text-align:left;padding:5px;}#badge{font-size:15px;-moz-border-radius:10px;-webkit-border-radius:10px;border-radius:10px;border:3px solid #2647a0;}#badgeHolderName{background-color:#2647a0;width:100%;color:white;font-family:bold;font-size:25px;padding:5px 0px 5px 0px;margin:5px 0px 5px 0px;margin-bottom:5px;}#badgeTicketList div,#badgeRibbonList div,#badgeTokenList div{border-top:1px solid #808080;width:100%;font-size:13px;padding:5px 0px 5px 0px;margin-top:5px;}</style>',0),('mRtqRuVikSe82BQsYBlD0A',1263962529,'3','pbversion0000000000001','approved','Bare Image','Bare Image','bare_image','3','7','12',NULL,0,1,0,0,0,558,NULL,0,1,0,1285733364,NULL,0),('aUDsJ-vB9RgP-AYvPOy8FQ',1263962529,'3','pbversion0000000000001','approved','Shop Account Layout','Shop Account Layout','root/import/account/shop/shop-account-layout','3','7','12',NULL,0,1,0,0,0,3337,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">\n',0,1,0,1285733363,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('CalendarEventEdit00001',1269401468,'3','pbversion0000000000001','approved','Default Calendar Event Edit','Default Calendar Event Edit','root/import/calendar-templates/default-calendar-event-edit','3','7','12',NULL,0,0,0,0,0,18084,'<script src=\"^Extras(yui/build/yahoo/yahoo.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/event/event.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/dom/dom.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/dragdrop/dragdrop.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(yui/build/logger/logger.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(textFix.js);\" type=\"text/javascript\"></script>\r\n<script src=\"^Extras(tabs/tabs.js);\" type=\"text/javascript\"></script>\r\n    <style type=\"text/css\">\r\n        #event_edit_container * {\r\n            margin:0px;\r\n        }\r\n        #event_edit_container td {\r\n            font-family:Arial;\r\n            font-size:10px;\r\n        }\r\n        #tabs a {\r\n            border:solid #F0F0F0 1px;\r\n            -moz-border-radius-topLeft: 20px;\r\n            -moz-border-radius-topRight: 20px;\r\n            font-weight:bold;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align:center;\r\n            background-color:#FBFBFB;\r\n            border-top:solid #F0F0F0 2px;\r\n            color:#b0b0b0;\r\n            text-decoration:none;\r\n            font-size:10pt;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #tabs a:hover {\r\n            color:black;\r\n        }\r\n        #tabs .active {\r\n            background-color:#F0F0F0;\r\n            color:#404040;\r\n        }\r\n        #event_edit_container table a {\r\n            font-size:11px;\r\n            color:#447BFD;\r\n        }\r\n        #event_edit_container input,\r\n        #event_edit_container select {\r\n            font-size:10px;\r\n            border:gray solid 1px;\r\n            background-color:#F0F0F0;\r\n            cursor:pointer;\r\n        }\r\n        table#event td.label {\r\n	         padding-right: 4px;\r\n	    }\r\n    </style>\r\n\r\n',0,1,0,1285733357,'<script src=\"^Extras(yui/build/yahoo/yahoo.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/event/event.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dom/dom.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dragdrop/dragdrop.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/logger/logger.js);\" type=\"text/javascript\"></script><script src=\"^Extras(textFix.js);\" type=\"text/javascript\"></script><script src=\"^Extras(tabs/tabs.js);\" type=\"text/javascript\"></script><style type=\"text/css\">#event_edit_container *{margin:0px;}#event_edit_container td{font-family:Arial;font-size:10px;}#tabs a{border:solid #F0F0F0 1px;-moz-border-radius-topLeft:20px;-moz-border-radius-topRight:20px;font-weight:bold;padding:2px 15px 0px 15px;text-align:center;background-color:#FBFBFB;border-top:solid #F0F0F0 2px;color:#b0b0b0;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#tabs a:hover{color:black;}#tabs .active{background-color:#F0F0F0;color:#404040;}#event_edit_container table a{font-size:11px;color:#447BFD;}#event_edit_container input,#event_edit_container select{font-size:10px;border:gray solid 1px;background-color:#F0F0F0;cursor:pointer;}table#event td.label{padding-right:4px;}</style>',0),('GRUNFctldUgop-qRLuo_DA',1269401469,'3','pbversion0000000000001','approved','Default Survey Edit','Default Survey Edit','root/import/survey/default-survey-edit','3','7','12',NULL,0,1,0,0,0,7101,NULL,0,1,0,1285733358,NULL,0),('oHh0UqAJeY7u2n--WD-BAA',1271820952,'3','pbversion0000000000001','approved','Default Edit Map Point','Default Edit Map Point','home/map/map-templates/default-edit-map-point','3','7','3',NULL,0,1,0,0,0,2499,'\n',0,1,0,1285733365,NULL,0),('u9vfx33XDk5la1-QC5FK7g',1271820953,'3','pbversion0000000000001','approved','Default Map Point View','Default Map Point View','home/map/map-templates/default-map-point-view','3','7','3',NULL,0,1,0,0,0,2145,'\n',0,1,0,1285733365,NULL,0),('t87D1138NhPHhA23-hozBA',1273032716,'3','pbversion0000000000001','approved','CrystalX','CrystalX','crystalx','3','7','3',NULL,0,1,0,0,0,310,NULL,0,1,0,1273032724,NULL,0),('QtBumey5ffc-xffRp1-7Aw',1273032716,'3','pbversion0000000000001','approved','img','img','crystalx/img','3','7','3',NULL,0,1,0,0,0,310,NULL,0,1,0,1273032724,NULL,0),('-0sK2rX1cwQt1ipUSqsiQQ',1273032716,'3','pbversion0000000000001','approved','bg.gif','bg.gif','crystalx/img/bg.gif','3','7','3',NULL,0,1,0,0,0,1440,NULL,0,1,0,1273032724,NULL,0),('hS_eOaVz9Qb5ixndK9EXAw',1273032716,'3','pbversion0000000000001','approved','header.jpg','header.jpg','crystalx/img/header.jpg','3','7','3',NULL,0,1,0,0,0,8038,NULL,0,1,0,1273032724,NULL,0),('k2p-Be8C98pf2cRq7E-JHg',1273032716,'3','pbversion0000000000001','approved','tab_link.gif','tab_link.gif','crystalx/img/tab_link.gif','3','7','3',NULL,0,1,0,0,0,507,NULL,0,1,0,1273032724,NULL,0),('aYG4fjbMPbC4LCuuMp4gGA',1273032716,'3','pbversion0000000000001','approved','tab_hover.gif','tab_hover.gif','crystalx/img/tab_hover.gif','3','7','3',NULL,0,1,0,0,0,538,NULL,0,1,0,1273032724,NULL,0),('F122Ey0NtVAw6Lfv1M6G_Q',1273032716,'3','pbversion0000000000001','approved','ico_archive.gif','ico_archive.gif','crystalx/img/ico_archive.gif','3','7','3',NULL,0,1,0,0,0,427,NULL,0,1,0,1273032724,NULL,0),('qmXHKrQ6EDLSOGkrEKRUDA',1273032716,'3','pbversion0000000000001','approved','bg_page_in.jpg','bg_page_in.jpg','crystalx/img/bg_page_in.jpg','3','7','3',NULL,0,1,0,0,0,3242,NULL,0,1,0,1273032724,NULL,0),('4qZgXjPPO4fwV879yu5XUg',1273032716,'3','pbversion0000000000001','approved','bg_page.JPG','bg_page.JPG','crystalx/img/bg_page.jpg','3','7','3',NULL,0,1,0,0,0,1229,NULL,0,1,0,1273032724,NULL,0),('mb-xeAugm5GJdvu-Wh0MtQ',1273032717,'3','pbversion0000000000001','approved','search_submit.gif','search_submit.gif','crystalx/img/search_submit.gif','3','7','3',NULL,0,1,0,0,0,2108,NULL,0,1,0,1273032724,NULL,0),('84Y9CwgzP6eNU7wZnk019Q',1273032717,'3','pbversion0000000000001','approved','ico_date.gif','ico_date.gif','crystalx/img/ico_date.gif','3','7','3',NULL,0,1,0,0,0,416,NULL,0,1,0,1273032724,NULL,0),('ikXTtJKZfHVxqw-47E4AQA',1273032717,'3','pbversion0000000000001','approved','ico_user.gif','ico_user.gif','crystalx/img/ico_user.gif','3','7','3',NULL,0,1,0,0,0,407,NULL,0,1,0,1273032724,NULL,0),('DhRWPTgzhvju_-TbMN3CwA',1273032717,'3','pbversion0000000000001','approved','ico_comments.gif','ico_comments.gif','crystalx/img/ico_comments.gif','3','7','3',NULL,0,1,0,0,0,427,NULL,0,1,0,1273032724,NULL,0),('6njI-pZz2bwsjWh-Q1_11g',1273032717,'3','pbversion0000000000001','approved','ico_list.gif','ico_list.gif','crystalx/img/ico_list2.gif','3','7','3',NULL,0,1,0,0,0,412,NULL,0,1,0,1273032724,NULL,0),('_Hz1Gnd3yEnJzVS7l7nJMQ',1273032717,'3','pbversion0000000000001','approved','content_all_bg.PNG','content_all_bg.PNG','crystalx/img/content_all_bg.png','3','7','3',NULL,0,1,0,0,0,8683,NULL,0,1,0,1273032724,NULL,0),('VOOrXK5dFnkGih7aTkuDWA',1273032717,'3','pbversion0000000000001','approved','search.PNG','search.PNG','crystalx/img/search.png','3','7','3',NULL,0,1,0,0,0,2190,NULL,0,1,0,1273032724,NULL,0),('ruf-QejOkUHDRtfgakHlbA',1273032717,'3','pbversion0000000000001','approved','col_title_bg_long.GIF','col_title_bg_long.GIF','crystalx/img/col_title_bg_long.gif','3','7','3',NULL,0,1,0,0,0,1265,NULL,0,1,0,1273032724,NULL,0),('FSHy5KjQjkt599PHS41seA',1273032717,'3','pbversion0000000000001','approved','footer.jpg','footer.jpg','crystalx/img/footer.jpg','3','7','3',NULL,0,1,0,0,0,4571,NULL,0,1,0,1273032724,NULL,0),('nuYYXAz4KNNxgfumfnpo_g',1273032718,'3','pbversion0000000000001','approved','ico_top.gif','ico_top.gif','crystalx/img/ico_top.gif','3','7','3',NULL,0,1,0,0,0,834,NULL,0,1,0,1273032724,NULL,0),('Mr7ljjoy6n4fZojpQWajKQ',1273032718,'3','pbversion0000000000001','approved','ico_links.gif','ico_links.gif','crystalx/img/ico_links.gif','3','7','3',NULL,0,1,0,0,0,419,NULL,0,1,0,1273032724,NULL,0),('ApkqpDOrJDxK3QrWBGSRIg',1273032718,'3','pbversion0000000000001','approved','ico_archive2.gif','ico_archive2.gif','crystalx/img/ico_archive2.gif','3','7','3',NULL,0,1,0,0,0,432,NULL,0,1,0,1273032724,NULL,0),('AzzTY0Lay1f_YGeQJFnQCA',1273032718,'3','pbversion0000000000001','approved','ico_list.gif','ico_list.gif','crystalx/img/ico_list.gif','3','7','3',NULL,0,1,0,0,0,411,NULL,0,1,0,1273032724,NULL,0),('OiJNwP1gAlcva8_yOtL4gA',1273032718,'3','pbversion0000000000001','approved','CrystalX_style','CrystalX_style','crystalx_style','3','7','3','by Ning from Pluton -- http://pluton.nl\n\nCrystalX gives your site a crystal-ish look and a strictly formal style. Feel free to download and apply it to your own site.\n\nOriginally designed by \"Nuvio Webdesign\" and collected by Open Source Web Design, converted to WebGUI theme by Ning.',0,1,0,0,0,3470,NULL,0,1,0,1285733358,NULL,0),('JOuCU4x5BJfVHfkfMkVQdQ',1273032718,'3','pbversion0000000000001','approved','crystalx.css','crystalx.css','crystalx/crystalx.css','3','7','3',NULL,0,1,0,0,0,14430,NULL,0,1,0,1285733366,NULL,0),('gaIOm5cr2TkT9Fk6QmZWug',1273032718,'3','pbversion0000000000001','approved','crystalX_navi','crystalX_navi','crystalx/crystalx_navi','3','7','3',NULL,0,1,0,0,0,7486,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script>\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^/(crystalx/crystalx_navi.css);\" />',0,1,0,1285733364,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/menu/assets/skins/sam/menu.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/container/container_core-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/menu/menu-min.js);\"></script><link rel=\"stylesheet\" type=\"text/css\" href=\"^/(crystalx/crystalx_navi.css);\" />',0),('w0QifHLhsrzeOpFKl-DX-Q',1273032718,'3','pbversion0000000000001','approved','crystalx_navi.css','crystalx_navi.css','crystalx/crystalx_navi.css','3','7','3',NULL,0,1,0,0,0,10481,NULL,0,1,0,1285733367,NULL,0),('x_hiUi1XZloBvV47Obnu8Q',1273032718,'3','pbversion0000000000001','approved','crystalX_NavigationTrail','crystalX_NavigationTrail','crystalx/crystalx_navigationtrail','3','7','12',NULL,0,1,0,0,0,422,NULL,0,1,0,1273032724,NULL,0),('hpCk0B3vQzgc-QJhSol41w',1273032718,'3','pbversion0000000000001','approved','crystalX_navitrail','crystalX_navitrail','crystalx/crystalx_navitrail','3','7','12',NULL,0,1,0,0,0,1104,NULL,0,1,0,1285733364,NULL,0),('UUwEL6hLEPdrnkZnKRzFYQ',1273032718,'3','pbversion0000000000001','approved','Site Search','Site Search','crystalx/site-search','3','7','3',NULL,0,1,0,0,0,892,NULL,0,1,0,1273032724,NULL,0),('OfKbvK7CrfMnfc8WDoF4Rg',1273032718,'3','pbversion0000000000001','approved','crystalx_search','crystalx_search','crystalx/crystalx_search','3','7','3',NULL,0,1,0,0,0,2754,NULL,0,1,0,1285733358,NULL,0),('stevestyle000000000002',1273032718,'3','pbversion0000000000001','approved','Style 02','Style 02','style_02','3','7','12','by Steve from Plain Black http://plainblack.com\r\n\r\nThe second of the WebGUI 7 styles',0,0,0,0,0,5770,NULL,0,1,0,1285733365,NULL,0),('CQp-RFA2pMh5lFSggPPPYg',1273032719,'3','pbversion0000000000001','approved','[Style] Underground','[Style] Underground','style-underground','3','7','3',NULL,0,0,0,0,0,452,NULL,0,1,0,1273032724,NULL,0),('_Mi_NTd3x8UB96LWezWHnw',1273032719,'3','pbversion0000000000001','approved','Images','Images','style-underground/images','3','7','3',NULL,0,0,0,0,0,328,NULL,0,1,0,1273032724,NULL,0),('A_5LVQQWR73QZR8FFbny_w',1273032719,'3','pbversion0000000000001','approved','bg.gif','bg.gif','style-underground/images/bg.gif','3','7','3',NULL,0,1,0,0,0,612,NULL,0,0,0,1273032724,NULL,0),('wywIfa_VuTsq0c5Ed-W-MA',1273032719,'3','pbversion0000000000001','approved','bullet.gif','bullet.gif','style-underground/images/bullet.gif','3','7','3',NULL,0,1,0,0,0,686,NULL,0,0,0,1273032724,NULL,0),('xmykMFjri1O2NrYHbeToVQ',1273032719,'3','pbversion0000000000001','approved','footerbg.gif','footerbg.gif','style-underground/images/footerbg.gif','3','7','3',NULL,0,1,0,0,0,460,NULL,0,0,0,1273032724,NULL,0),('0IIGNBs_-INzqBC5VLeJgw',1273032719,'3','pbversion0000000000001','approved','headerbg.gif','headerbg.gif','style-underground/images/headerbg.gif','3','7','3',NULL,0,1,0,0,0,530,NULL,0,0,0,1273032724,NULL,0),('FXmePdyS0YKuZ1VCGGpK9w',1273032719,'3','pbversion0000000000001','approved','quote.gif','quote.gif','style-underground/images/quote.gif','3','7','3',NULL,0,1,0,0,0,685,NULL,0,0,0,1273032724,NULL,0),('66qCywiE_fiL9u5YIaJhgw',1273032719,'3','pbversion0000000000001','approved','tableft.gif','tableft.gif','style-underground/images/tableft.gif','3','7','3',NULL,0,1,0,0,0,720,NULL,0,0,0,1273032724,NULL,0),('n5VpG4lFsOG1elaWDQbilw',1273032719,'3','pbversion0000000000001','approved','tabright.gif','tabright.gif','style-underground/images/tabright.gif','3','7','3',NULL,0,1,0,0,0,2135,NULL,0,0,0,1273032724,NULL,0),('g3JH1PRq6m6Bj_PnGpcrSQ',1273032719,'3','pbversion0000000000001','approved','CSS','CSS','style-underground/css','3','7','3',NULL,0,0,0,0,0,319,NULL,0,1,0,1273032724,NULL,0),('egpnaaFqWmJwYTZ5CvFH9g',1273032719,'3','pbversion0000000000001','approved','Underground.css','Underground.css','style-underground/css/underground.css','3','7','3',NULL,0,1,0,0,0,11747,NULL,0,1,0,1285733366,NULL,0),('BBpxqoSseIor5C9ei9JEFQ',1273032719,'3','pbversion0000000000001','approved','Underground WebGUI.css','Underground WebGUI.css','style-underground/css/underground-webgui.css','3','7','3',NULL,0,1,0,0,0,506,NULL,0,1,0,1285733366,NULL,0),('G0hl4VilbFKipToyxKqFrg',1273032719,'3','pbversion0000000000001','approved','Prototypes','Prototypes','style-underground/prototypes','3','7','3',NULL,0,0,0,0,0,429,NULL,0,1,0,1273032725,NULL,0),('GWU2qZqe6yEuAKG-5HtBdg',1273032719,'3','pbversion0000000000001','approved','Templates','Templates','style-underground/templates','3','7','3',NULL,0,0,0,0,0,337,NULL,0,1,0,1273032725,NULL,0),('39KNX53B4nYJAyIE1lu8ZQ',1273032720,'3','pbversion0000000000001','approved','[nav] Underground Top Navigation','[nav] Underground Top Navigation','style-underground/nav-underground-top-navigation','3','7','3',NULL,0,1,0,0,0,1139,NULL,0,1,0,1285733356,NULL,0),('ztfi__vHJLsQDsMenrEn-w',1273032720,'3','pbversion0000000000001','approved','[nav] Underground Side Navigation','[nav] Underground Side Navigation','style-underground/nav-underground-side-navigation','3','7','3',NULL,0,1,0,0,0,1148,NULL,0,1,0,1285733366,NULL,0),('8qyrDCNeggB4dzKiOoRuiQ',1273032720,'3','pbversion0000000000001','approved','[admintoggle] Underground Admin Toggle','[admintoggle] Underground Admin Toggle','style-underground/templates/admintoggle-underground-admin-toggle','3','7','3',NULL,0,1,0,0,0,520,NULL,0,1,0,1285733357,NULL,0),('M1NyNeS5jpdIsiIWFiJprw',1273032720,'3','pbversion0000000000001','approved','View My Account','View My Account','style-underground/templates/view-my-account','3','7','3',NULL,0,1,0,0,0,461,NULL,0,1,0,1285733358,NULL,0),('AsfpsOpsGzZCb9m7MyxPuw',1273032720,'3','pbversion0000000000001','approved','Navigation','Navigation','style-underground/navigation','3','7','3',NULL,0,0,0,0,0,340,NULL,0,1,0,1273032725,NULL,0),('n-Vr_wgxOkwiHGt1nJto9w',1273032720,'3','pbversion0000000000001','approved','Top Navigation','Top Navigation','style-underground/top-navigation','3','7','3',NULL,0,1,0,0,0,396,NULL,0,1,0,1273032725,NULL,0),('jmqLxnoWb6p92Cr12lf1hw',1273032720,'3','pbversion0000000000001','approved','Side Navigation','Side Navigation','style-underground/side-navigation','3','7','3',NULL,0,1,0,0,0,402,NULL,0,1,0,1273032725,NULL,0),('8E2UOnj_XPEghTj7nfVM0g',1273032720,'3','pbversion0000000000001','approved','Search','Search','style-underground/search','3','7','3',NULL,0,1,0,0,0,345,NULL,0,1,0,1273032725,NULL,0),('Q4uX_C557arTp6D_jwB1jQ',1273032720,'3','pbversion0000000000001','approved','Wiki','Wiki','root/import/wiki','3','12','12',NULL,0,0,0,0,0,312,NULL,0,1,0,1273032723,NULL,0),('WikiRCTmpl000000000001',1273032720,'3','pbversion0000000000001','approved','Default Recent Changes','Default Recent Changes','default-wiki-recent-changes','3','7','12',NULL,0,0,0,0,0,1657,NULL,0,1,0,1285733363,NULL,0),('WikiFrontTmpl000000001',1273032720,'3','pbversion0000000000001','approved','Default Wiki Front Page','Default Wiki Front Page','default-wiki-front-page','3','7','12',NULL,0,0,0,0,0,4434,NULL,0,1,0,1285733363,NULL,0),('WikiSearchTmpl00000001',1273032720,'3','pbversion0000000000001','approved','Default Wiki Search','Default Wiki Search','default-wiki-search','3','7','12',NULL,0,0,0,0,0,2450,'\n\n',0,1,0,1285733363,NULL,0),('WikiPHTmpl000000000001',1273032720,'3','pbversion0000000000001','approved','Default Page History','Default Page History','default-wiki-page-history','3','7','12',NULL,0,0,0,0,0,657,NULL,0,1,0,1285733363,NULL,0),('WikiPageTmpl0000000001',1273032720,'3','pbversion0000000000001','approved','Default Wiki Page','Default Wiki Page','default-wiki-page','3','7','12',NULL,0,0,0,0,0,6422,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview.css);\" />\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview-core.css);\" />\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/connection/connection-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\n\n<style type=\"text/css\">\n#wikipage.yui-navset .yui-nav li a {\n    border:1px solid #000;  /* label and content borders */\n}\n\n#wikipage.yui-navset .yui-content {\n        border-top: 1px solid #000;\n        border-bottom: 1px solid #000;\n}\n\n\n#wikipage.yui-navset .yui-nav .selected a {\n    background-color:black; /* active tab, tab hover, and content bgcolor */\n        color: white;\n    border-bottom-width:0; /* no bottom border for active tab */\n    padding-bottom:1px; /* to match height of other tabs */\n}\n\n#wikipage.yui-navset-top .yui-nav .selected a {\n    border-bottom:0; /* no bottom border for active tab */\n    padding-bottom:1px; /* to match height of other tabs */\n}\n\n#wikipage.yui-navset-top .yui-content {\n    margin-top:-1px; /* for active tab overlap */\n}\n\n#wikipage .yui-content {\n    padding-top:1em; \n    padding-bottom:1em; \n}\n#wikipage .loading {\n    background-image:url(^Extras(yui/examples/tabview/img/loading.gif););\n    background-position:center center;\n    background-repeat:no-repeat;\n}\n\n#wikipage .loading * {\n    display:none;\n}\n\n</style>\n',0,1,0,1285733363,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview.css);\" /><link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/tabview-core.css);\" /><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/connection/connection-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script><style type=\"text/css\">#wikipage.yui-navset .yui-nav li a{border:1px solid #000;}#wikipage.yui-navset .yui-content{border-top:1px solid #000;border-bottom:1px solid #000;}#wikipage.yui-navset .yui-nav .selected a{background-color:black;color:white;border-bottom-width:0;padding-bottom:1px;}#wikipage.yui-navset-top .yui-nav .selected a{border-bottom:0;padding-bottom:1px;}#wikipage.yui-navset-top .yui-content{margin-top:-1px;}#wikipage .yui-content{padding-top:1em;padding-bottom:1em;}#wikipage .loading{background-image:url(^Extras(yui/examples/tabview/img/loading.gif););background-position:center center;background-repeat:no-repeat;}#wikipage .loading *{display:none;}</style>',0),('WikiPageEditTmpl000001',1273032720,'3','pbversion0000000000001','approved','Default Wiki Page Edit','Default Wiki Page Edit','default-wiki-page-edit','3','7','12',NULL,0,0,0,0,0,2572,NULL,0,1,0,1285733363,NULL,0),('WikiMPTmpl000000000001',1273032720,'3','pbversion0000000000001','approved','Default Most Popular','Default Most Popular','default-wiki-most-popular','3','7','12',NULL,0,0,0,0,0,1033,NULL,0,1,0,1285733363,NULL,0),('stevestyle000000000003',1273032720,'3','pbversion0000000000001','approved','Style 03','Style 03','style_03','3','7','12','by Steve from Plain Black http://plainblack.com\r\n\r\nThe last of the WebGUI 7 style templates.',0,0,0,0,0,3907,NULL,0,1,0,1285733365,NULL,0),('1qFjOEiILIwr1xB5_ebppQ',1273032721,'3','pbversion0000000000001','approved','Greenportal','Greenportal','greenportal','3','7','3',NULL,0,1,0,0,0,319,NULL,0,1,0,1273032725,NULL,0),('xD76UfQ_JnSgTLBNvytcpQ',1273032721,'3','pbversion0000000000001','approved','greenportal_image','greenportal_image','greenportal_image','3','7','12',NULL,0,1,0,0,0,344,NULL,0,1,0,1273032725,NULL,0),('pAXR7Kby4O-dSxOwLp1GaA',1273032721,'3','pbversion0000000000001','approved','menu_top.png','menu_top.png','greenportal_image/menu_top.png','3','7','12',NULL,0,1,0,0,0,7649,NULL,0,1,0,1273032725,NULL,0),('TthzMLO4n3qxy59QZ5YBHg',1273032721,'3','pbversion0000000000001','approved','menu_dark.png','menu_dark.png','greenportal_image/menu_dark.png','3','7','12',NULL,0,1,0,0,0,2641,NULL,0,1,0,1273032725,NULL,0),('3n31SQjYa150TBrRBgMPhA',1273032721,'3','pbversion0000000000001','approved','menu_light.png','menu_light.png','greenportal_image/menu_light.png','3','7','12',NULL,0,1,0,0,0,2195,NULL,0,1,0,1273032725,NULL,0),('R4RxDufGbbIzEmpcoEcLrw',1273032721,'3','pbversion0000000000001','approved','logo.jpg','logo.jpg','greenportal_image/logo.jpg','3','7','12',NULL,0,1,0,0,0,41449,NULL,0,1,0,1273032725,NULL,0),('xyyn5mz3xGyvrcI1rY8C-w',1273032721,'3','pbversion0000000000001','approved','greenportal.css','greenportal.css','greenportal.css','3','7','12',NULL,0,1,0,0,0,6581,NULL,0,1,0,1285733367,NULL,0),('KKt0VB_eoQxw9xEsHsAhag',1273032721,'3','pbversion0000000000001','approved','Greenportal_style','Greenportal_style','greenportal_style','3','7','12','by Ning from PlutonIT http://pluton.nl\n\nA Joomla! Open Source design released under the GNU/GPL License. Enhanced and converted into WebGUI theme by Ning. The original PHP and CSS file can be downloaded following the author\'s link: http://www.studentsdesign.de/',0,1,0,0,0,2280,NULL,0,1,0,1285733358,NULL,0),('h0bOzz7WvdaVZXsjpwtkww',1273032721,'3','pbversion0000000000001','approved','greenportal_Navigation','greenportal_Navigation','greenportal_navigation','3','7','3',NULL,0,1,0,0,0,394,NULL,0,1,0,1273032725,NULL,0),('_z3ukLCqvoaUygfsbbkBzw',1273032721,'3','pbversion0000000000001','approved','Greenportal_menu','Greenportal_menu','greenportal_menu','3','7','3',NULL,0,1,0,0,0,2014,NULL,0,1,0,1285733363,NULL,0),('qFOfW1sKyOTnGNcP6BXbwg',1273032721,'3','pbversion0000000000001','approved','greenportal_NavigationTop','greenportal_NavigationTop','greenportal_navigationtop','3','7','12',NULL,0,1,0,0,0,416,NULL,0,1,0,1273032725,NULL,0),('Pt38T5_MWSue2e1N36MLdw',1273032721,'3','pbversion0000000000001','approved','Greenportal_menuTop','Greenportal_menuTop','greenportal_menutop','3','7','12',NULL,0,1,0,0,0,950,NULL,0,1,0,1285733362,NULL,0),('LDcM1Iop17nF2MoSa7zo_Q',1273032721,'3','pbversion0000000000001','approved','Greenportal_dataform','Greenportal_dataform','greenportal_dataform','3','7','3',NULL,0,1,0,0,0,5320,'<style type=\"text/css\">\r\n\r\n.error\r\n{\r\n	margin-left:90px;\r\n}\r\n\r\n.errorlist{\r\n	margin-left:10px;\r\n}\r\n\r\n.dataControls\r\n{\r\n	-moz-box-sizing:border-box;\r\n	background:#676767;\r\n	color:#C0C0C0;\r\n	width:100%;\r\n	text-align:right;\r\n	padding:3px;\r\n	margin-bottom:5px;\r\n}\r\n\r\n</style>\r\n\r\n',0,1,0,1285733358,'<style type=\"text/css\">.error{margin-left:90px;}.errorlist{margin-left:10px;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;margin-bottom:5px;}</style>',0),('hVF1taXj4bfd7DuL4XDMYg',1273032721,'3','pbversion0000000000001','approved','Greenportal_datalist','Greenportal_datalist','greenportal_datalist','3','7','3',NULL,0,1,0,0,0,4142,'<style type=\"text/css\">\n\n.error\n{\n	margin-left:10px;\n}\n\n.regDatabase\n{\n	text-align:center;\n}\n\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	margin-bottom:5px;\n}\n\n</style>\n\n',0,1,0,1285733364,'<style type=\"text/css\">.error{margin-left:10px;}.regDatabase{text-align:center;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;margin-bottom:5px;}</style>',0),('x4-2QYRSrIB_BJfnSKKj4w',1273032721,'3','pbversion0000000000001','approved','Greenportal_acknowledgement','Greenportal_acknowledgement','greenportal_acknowledgement','3','7','3',NULL,0,1,0,0,0,1755,'<style type=\"text/css\">\r\n\r\n.acknowledgement\r\n{\r\n	margin-top:5px;\r\n}\r\n\r\n</style>',0,1,0,1285733365,'<style type=\"text/css\">.acknowledgement{margin-top:5px;}</style>',0),('423R4Y6XIt3wUzlnLo-chg',1273032721,'3','pbversion0000000000001','approved','Greenportal_forum','Greenportal_forum','greenportal_forum','3','7','3',NULL,0,1,0,0,0,7997,'<style type=\"text/css\">\r\n.forumHead {\r\n	background: #676767;\r\n	!border-bottom: 1px solid #cccccc;\r\n	padding: 2px;\r\n	padding-bottom: 4px;\r\n	!font-size: 13px;\r\n	font-weight: bold;\r\n}\r\n.oddThread {\r\n	!font-size: 13px;\r\n	border-bottom: 1px dashed #99CC33;\r\n	padding-bottom: 4px;\r\n}\r\n.evenThread {\r\n	!font-size: 13px;\r\n	border-bottom: 1px dashed #EE82EE;\r\n	padding-bottom: 4px;\r\n}\r\n</style>\r\n\r\n\r\n',0,1,0,1285733356,'<style type=\"text/css\">.forumHead{background:#676767;!border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;!font-size:13px;font-weight:bold;}.oddThread{!font-size:13px;border-bottom:1px dashed #99CC33;padding-bottom:4px;}.evenThread{!font-size:13px;border-bottom:1px dashed #EE82EE;padding-bottom:4px;}</style>',0),('oZ1Mk-zExYUyD-JsjTvaHg',1273032722,'3','pbversion0000000000001','approved','Greenportal_thread','Greenportal_thread','greenportal_thread','3','7','3',NULL,0,1,0,0,0,11119,'<style type=\"text/css\">\r\n	.postBorderCurrent {\r\n		border: 2px solid #cccccc;\r\n		margin-bottom: 10px;\r\n	}\r\n\r\n	.postBorder {\r\n		border: 1px solid #cccccc;\r\n		margin-bottom: 10px;\r\n	}\r\n\r\n	.postSubject {\r\n		!border-bottom: 1px dashed #cccccc;\r\n		font-weight: bold;\r\n		padding: 3px;\r\n	}\r\n	.postData {\r\n		!border-bottom: 1px dashed #cccccc;\r\n		!font-size: 9pt;\r\n		background-color: #676767;\r\n		color: black;\r\n		padding: 3px;\r\n	}\r\n\r\n	.postControls {\r\n		!border-top: 1px dashed #cccccc;\r\n		background-color: #676767;\r\n		color: black;\r\n		padding: 2px;\r\n		text-align:right;\r\n	}\r\n\r\n	.bottomControls {\r\n		background-color:#676767;\r\n		padding: 3px;\r\n		text-align:right;\r\n	}\r\n\r\n	.postMessage {\r\n		padding: 3px;\r\n	}\r\n	.currentThread {\r\n		background-color: #eeeeee;\r\n	}\r\n	.threadHead {\r\n		font-weight: bold;\r\n		border-bottom: 1px solid #cccccc;\r\n		!font-size: 9pt;\r\n		background-color: #676767;\r\n		color: black;\r\n		padding: 3px;\r\n	}\r\n	.threadData {\r\n		!font-size: 11px;\r\n		padding: 3px;\r\n	}\r\n</style>\r\n',0,1,0,1285733365,'<style type=\"text/css\">.postBorderCurrent{border:2px solid #cccccc;margin-bottom:10px;}.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postSubject{!border-bottom:1px dashed #cccccc;font-weight:bold;padding:3px;}.postData{!border-bottom:1px dashed #cccccc;!font-size:9pt;background-color:#676767;color:black;padding:3px;}.postControls{!border-top:1px dashed #cccccc;background-color:#676767;color:black;padding:2px;text-align:right;}.bottomControls{background-color:#676767;padding:3px;text-align:right;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;!font-size:9pt;background-color:#676767;color:black;padding:3px;}.threadData{!font-size:11px;padding:3px;}</style>',0),('mYwS8CZaOLMt0raaKXGZcQ',1273032722,'3','pbversion0000000000001','approved','Greenportal_postform','Greenportal_postform','greenportal_postform','3','7','3',NULL,0,1,0,0,0,4047,'<style type=\"text/css\">\r\ntable.defaultPostForm td\r\n{\r\n	!font-family:arial;\r\n	font-size:9pt;\r\n}\r\nh2\r\n{\r\n	!font-family:arial;\r\n}\r\n</style>\r\n',0,1,0,1285733364,'<style type=\"text/css\">table.defaultPostForm td{!font-family:arial;font-size:9pt;}h2{!font-family:arial;}</style>',0),('kSGR4OHsKmhLQTuLkisOww',1273032722,'3','pbversion0000000000001','approved','Greenportal_search','Greenportal_search','greenportal_search','3','7','3',NULL,0,1,0,0,0,3685,'<style type=\"text/css\">\r\n\r\n.searchResults{\r\n	border:solid silver 1px;\r\n	margin-top:5px;\r\n}\r\n\r\n.odd{\r\n	background-color:#565656;\r\n	color: black;\r\n	border-top:1px solid #676767;\r\n	border-bottom:1px solid #676767; \r\n}\r\n\r\n.tableHeader{\r\n	background-color:#DADADA;\r\n	color:black;\r\n	border:1px solid #676767;\r\n	font-weight:bold;\r\n}\r\n\r\n.pagination\r\n{\r\n	background:#C0C0C0;\r\n	width:95%;\r\n	text-align:right;\r\n	padding:3px;\r\n	font-size:9pt;\r\n	font-family:arial;\r\n}\r\n\r\n</style>',0,1,0,1285733364,'<style type=\"text/css\">.searchResults{border:solid silver 1px;margin-top:5px;}.odd{background-color:#565656;color:black;border-top:1px solid #676767;border-bottom:1px solid #676767;}.tableHeader{background-color:#DADADA;color:black;border:1px solid #676767;font-weight:bold;}.pagination{background:#C0C0C0;width:95%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}</style>',0),('G5DgNizuG3jXkjPp6UaGrA',1273032722,'3','pbversion0000000000001','approved','Greenportal_Calendar','Greenportal_Calendar','greenportal_calendar','3','7','3',NULL,0,1,0,0,0,352,NULL,0,1,0,1273032725,NULL,0),('Xqc3qPUXoFE8dt9qocdWig',1273032722,'3','pbversion0000000000001','approved','Greenportal_calendarWeek','Greenportal_calendarWeek','greenportal_calendar/greenportal_calendarweek','3','7','3',NULL,0,1,0,0,0,10517,'<style type=\"text/css\">\r\n\r\n		#mCAL .tab {\r\n			border-bottom-style:none;\r\n			font-weight:bold;\r\n			padding: 2px 15px 0px 15px;\r\n			text-align;center;\r\n			background-color:gray;\r\n			-moz-border-radius-topLeft:10px;\r\n			-moz-border-radius-topRight:10px;\r\n			display:block;\r\n			float:left;\r\n			margin-right:5px;\r\n		}\r\n		#mCAL .tabWeek {\r\n			border-bottom-style:none;\r\n			font-weight:bold;\r\n			padding: 2px 15px 0px 15px;\r\n			text-align;center;\r\n			background-color: #565656;\r\n			-moz-border-radius-topLeft:10px;\r\n			-moz-border-radius-topRight:10px;\r\n			display:block;\r\n			float:left;\r\n			margin-right:5px;\r\n		}\r\n\r\n		#mCAL .tab:hover {\r\n			background-color:#666666;\r\n		}	\r\n		#mCAL .line {\r\n	    		float:right;\r\n	    		height:3px;\r\n	    		width:560px;\r\n	   	 	background-color:#565656;\r\n		}	\r\n		#mCAL .controls {\r\n			float:right;\r\n			vertical-align:bottom;\r\n			font-size:7pt;\r\n		}\r\n\r\n		#mCAL .heading {\r\n			width:100px;\r\n			-moz-box-sizing:border-box;\r\n			background-color:#334411;\r\n			text-align:center;\r\n			font-weight:bold;\r\n			color:#99CC33;\r\n			font-size:9px;\r\n			letter-spacing:1px;\r\n			text-transform:uppercase;\r\n			text-align:right;\r\n			vertical-align:top;\r\n			-moz-border-radius-bottomRight:8px;\r\n			-moz-border-radius-topRight:8px;			\r\n		}\r\n		#mCAL .day {\r\n			background-color:#334411;			\r\n			position:relative;\r\n			vertical-align:top;		\r\n			-moz-border-radius-topLeft:8px;\r\n			-moz-border-radius-bottomLeft:8px;\r\n		}\r\n		#mCAL .curDay {\r\n			background-color:#BB8888;\r\n		}\r\n		#mCAL .dayWrapper {			\r\n			height:100%;\r\n			width:100%;\r\n			position:relative;\r\n			z-index:0;\r\n			margin:0px;	\r\n			padding:0px 0px 2px 5px;;\r\n			-moz-box-sizing:border-box;\r\n		}\r\n		html > body #mCAL .dayWrapper {\r\n			height:auto;\r\n			min-height:100%;\r\n		}\r\n		#mCAL .dayNum {\r\n			width:100%;\r\n			text-align:right;\r\n			\r\n		}\r\n\r\n		#mCAL span.border {							\r\n			text-align:center;			\r\n			padding:5px;\r\n			font-weight:bold;\r\n			-moz-border-radius-bottomRight:5px;\r\n			-moz-border-radius-topLeft:5px;\r\n			color:black;			\r\n			border-right:solid #676767 1px;\r\n			border-bottom: solid #676767 1px;\r\n			background-color:#99CC33;\r\n			-moz-box-sizing:border-box;\r\n			top:5px;\r\n			position:relative;\r\n			\r\n		}\r\n		#mCAL .curDay span.border {\r\n			background-color:#EE82EE;\r\n		}\r\n		#mCAL .event {\r\n			padding:3px;\r\n			padding-top:8px;\r\n			clear:left;\r\n			font-weight:bold;			\r\n		}\r\n		#mCAL .event a {\r\n			color:#4F4F4F;\r\n			text-decoration:none;\r\n			font-size:9px;\r\n		}\r\n		#mCAL .moreButton {\r\n			border-style:none;\r\n			z-index:5;\r\n			position:absolute;\r\n			bottom:0px;\r\n			width:100%;\r\n			height:9px;\r\n			background-color:#517AC8;	\r\n			font-size:5px;\r\n			text-align:center;\r\n		}\r\n		#mCAL .moreButton:hover {\r\n			background-color:orange;\r\n		}\r\n		#mCAL .empty {\r\n			border-style:none;\r\n			background-color:#CCD2E3;\r\n			-moz-border-radius:10px;\r\n			\r\n		}\r\n		#mCAL .months {\r\n			text-align:center;\r\n			background-color:#DFE3EE;			\r\n		}\r\n		#mCAL .months a {\r\n			color:#517AC8;\r\n			text-decoration:none;\r\n		}\r\n		#mCAL .months .monthLink {\r\n			text-decoration:none;			\r\n			padding-left:5px;\r\n			padding-right:5px;\r\n			color:#AAB8D5;\r\n			font-size:12px;\r\n			font-weight:bold;\r\n		}	\r\n		#mCAL .months .current {\r\n			color:#517AC8;\r\n		}\r\n		#mCAL .current {\r\n			font-weight:bold;\r\n			color:#517AC8;\r\n			background-color:#fff;			\r\n			-moz-border-radius:5px;\r\n		}\r\n		#mCAL .curMonth {\r\n			text-align:center;\r\n			margin: 1px 0px;\r\n			background-color:#334411;\r\n			color:#99CC33;\r\n			font-weight:bold;\r\n		}\r\n		\r\n		/* MORE STYLES */\r\n		#more1 {\r\n			position:absolute;\r\n			top:170px;\r\n			left:10px;			\r\n			\r\n		}\r\n		* html #more1 {\r\n			top:158px;\r\n			left:12px;\r\n\r\n		}\r\n		.moreDisplay {\r\n			border:solid orange 1px;\r\n			border-top:solid orange 2px;\r\n			font-family:arial;\r\n			font-size:10px;\r\n			width:300px;\r\n			padding:2px;\r\n			background-color:#FFD3A8;\r\n			z-index:10;			\r\n		}\r\n		ul.eventList {\r\n			margin:0px;\r\n			padding:0px;\r\n			margin-left:50px;\r\n			color:#526896;\r\n		}\r\n\r\n\r\n</style>\r\n',0,1,0,1285733363,'<style type=\"text/css\">#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n			text-align;center;background-color:gray;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;display:block;float:left;margin-right:5px;}#mCAL .tabWeek{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n			text-align;center;background-color:#565656;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{background-color:#666666;}#mCAL .line{float:right;height:3px;width:560px;background-color:#565656;}#mCAL .controls{float:right;vertical-align:bottom;font-size:7pt;}#mCAL .heading{width:100px;-moz-box-sizing:border-box;background-color:#334411;text-align:center;font-weight:bold;color:#99CC33;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#334411;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;}#mCAL .curDay{background-color:#BB8888;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL span.border{text-align:center;padding:5px;font-weight:bold;-moz-border-radius-bottomRight:5px;-moz-border-radius-topLeft:5px;color:black;border-right:solid #676767 1px;border-bottom:solid #676767 1px;background-color:#99CC33;-moz-box-sizing:border-box;top:5px;position:relative;}#mCAL .curDay span.border{background-color:#EE82EE;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .event a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL .moreButton{border-style:none;z-index:5;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;}#mCAL .moreButton:hover{background-color:orange;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#517AC8;}#mCAL .current{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:1px 0px;background-color:#334411;color:#99CC33;font-weight:bold;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:50px;color:#526896;}</style>',0),('IBTb7wllSt7RxFmmvm9pkQ',1273032722,'3','pbversion0000000000001','approved','Greenportal_calendarDay','Greenportal_calendarDay','greenportal_calendar/greenportal_calendarday','3','7','3',NULL,0,1,0,0,0,10163,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:gray;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n        #mCAL .tabDay {\r\n\r\n            border-bottom-style:none;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:#565656;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }\r\n	#mCAL .line {\r\n	    float:right;\r\n	    height:3px;\r\n	    width:560px;\r\n	    background-color:#565656;\r\n	}\r\n        #mCAL .tab:hover {\r\n            background-color:#666666;\r\n            }\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n	    font-size:7pt;\r\n        }\r\n        #mCAL .heading {\r\n            width:100px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#334411;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#99CC33;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n            -moz-border-radius-topRight:8px;\r\n        }\r\n        #mCAL .day {\r\n            background-color:#334411;\r\n            width:400px;\r\n            position:relative;\r\n            vertical-align:top;\r\n            -moz-border-radius-topLeft:8px;\r\n            -moz-border-radius-bottomLeft:8px;\r\n        }\r\n        #mCAL .dayWrapper {\r\n            height:100%;\r\n            width:100%;\r\n            position:relative;\r\n            z-index:0;\r\n            margin:0px;\r\n            padding:0px 0px 2px 5px;;\r\n            -moz-box-sizing:border-box;\r\n        }\r\n        html > body #mCAL .dayWrapper {\r\n            height:auto;\r\n            min-height:100%;\r\n        }\r\n        #mCAL .dayNum {\r\n            width:100%;\r\n            text-align:right;\r\n            \r\n        }\r\n        #mCAL .event {\r\n            padding:3px;\r\n            padding-top:8px;\r\n            clear:left;\r\n            font-weight:bold;\r\n        }\r\n        #mCAL .empty {\r\n            border-style:none;\r\n            background-color:#CCD2E3;\r\n            -moz-border-radius:10px;\r\n            \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n            background-color:#334411;\r\n        }\r\n        #mCAL .months a {\r\n            color:#517AC8;\r\n            text-decoration:none;\r\n        }\r\n        #mCAL .months .monthLink {\r\n            text-decoration:none;\r\n            padding-left:5px;\r\n            padding-right:5px;\r\n            font-size:12px;\r\n            font-weight:bold;\r\n            }\r\n        #mCAL .months .current {\r\n            color:#334411;\r\n	    background-color:#99CC33;\r\n            font-weight:bold;\r\n            -moz-border-radius:5px;\r\n	    padding:2px;\r\n        }\r\n        \r\n        /* MORE STYLES */\r\n        #more1 {\r\n            position:absolute;\r\n            top:170px;\r\n                        left:10px;\r\n            \r\n        }\r\n        * html #more1 {\r\n            top:158px;\r\n            left:12px;\r\n\r\n        }\r\n        .moreDisplay {\r\n            border:solid orange 1px;\r\n            border-top:solid orange 2px;\r\n            font-family:arial;\r\n            font-size:10px;\r\n            width:300px;\r\n            padding:2px;\r\n            background-color:#FFD3A8;\r\n                        z-index:10;\r\n        }\r\n        ul.eventList {\r\n            margin:0px;\r\n            padding:0px;\r\n            margin-left:30px;\r\n            color:#526896;\r\n        }\r\n    </style>\r\n\r\n',0,1,0,1285733358,'<style type=\"text/css\">#mCAL .tab{border-bottom-style:none;padding:2px 15px 0px 15px;\n            text-align;center;background-color:gray;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;display:block;float:left;margin-right:5px;}#mCAL .tabDay{border-bottom-style:none;padding:2px 15px 0px 15px;\n            text-align;center;background-color:#565656;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;display:block;float:left;margin-right:5px;}#mCAL .line{float:right;height:3px;width:560px;background-color:#565656;}#mCAL .tab:hover{background-color:#666666;}#mCAL .controls{float:right;vertical-align:bottom;font-size:7pt;}#mCAL .heading{width:100px;-moz-box-sizing:border-box;background-color:#334411;text-align:center;font-weight:bold;color:#99CC33;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#334411;width:400px;position:relative;vertical-align:top;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;}#mCAL .dayWrapper{height:100%;width:100%;position:relative;z-index:0;margin:0px;padding:0px 0px 2px 5px;;-moz-box-sizing:border-box;}html > body #mCAL .dayWrapper{height:auto;min-height:100%;}#mCAL .dayNum{width:100%;text-align:right;}#mCAL .event{padding:3px;padding-top:8px;clear:left;font-weight:bold;}#mCAL .empty{border-style:none;background-color:#CCD2E3;-moz-border-radius:10px;}#mCAL .months{text-align:center;background-color:#334411;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;font-size:12px;font-weight:bold;}#mCAL .months .current{color:#334411;background-color:#99CC33;font-weight:bold;-moz-border-radius:5px;padding:2px;}#more1{position:absolute;top:170px;left:10px;}* html #more1{top:158px;left:12px;}.moreDisplay{border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;padding:2px;background-color:#FFD3A8;z-index:10;}ul.eventList{margin:0px;padding:0px;margin-left:30px;color:#526896;}</style>',0),('Z1EM7JMI_4SkyfaZffSElw',1273032722,'3','pbversion0000000000001','approved','Greenportal_calendarEvent','Greenportal_calendarEvent','greenportal_calendar/greenportal_calendarevent','3','7','3',NULL,0,1,0,0,0,8356,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:gray;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }      \r\n        #mCAL .tab:hover {\r\n            background-color:#565656;\r\n	}\r\n	#mCAL .line {\r\n	    float:right;\r\n	    height:3px;\r\n	    width:560px;\r\n	    background-color:#565656;\r\n	}	\r\n        #mCAL .controls {\r\n            float:right;\r\n            vertical-align:bottom;\r\n	    font-size:7pt;\r\n        }\r\n        #mCAL .heading {\r\n            width:100px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#334411;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#99CC33;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n            -moz-border-radius-topRight:8px;            \r\n        }\r\n        #mCAL .day {\r\n            background-color:#334411;    \r\n	    color:#99CC33;       \r\n            width:400px;\r\n            position:relative;\r\n            -moz-border-radius-topLeft:8px;\r\n            -moz-border-radius-bottomLeft:8px;          \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n            background-color:#334411;   \r\n            color:#99CC33;\r\n            font-weight:bold;\r\n        }         \r\n        #mCAL .eventWrapper {\r\n            margin:2px 10px;\r\n        }\r\n    </style>\r\n\r\n',0,1,0,1285733363,'<style type=\"text/css\">#mCAL .tab{border-bottom-style:none;padding:2px 15px 0px 15px;\n            text-align;center;background-color:gray;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{background-color:#565656;}#mCAL .line{float:right;height:3px;width:560px;background-color:#565656;}#mCAL .controls{float:right;vertical-align:bottom;font-size:7pt;}#mCAL .heading{width:100px;-moz-box-sizing:border-box;background-color:#334411;text-align:center;font-weight:bold;color:#99CC33;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#334411;color:#99CC33;width:400px;position:relative;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;}#mCAL .months{text-align:center;background-color:#334411;color:#99CC33;font-weight:bold;}#mCAL .eventWrapper{margin:2px 10px;}</style>',0),('fJg7SKpGZwzSNx3_ebki1A',1273032722,'3','pbversion0000000000001','approved','Greenportal_calendarEventEdit','Greenportal_calendarEventEdit','greenportal_calendar/greenportal_calendareventedit','3','7','3',NULL,0,1,0,0,0,9181,'<script src=\"^Extras(yui/build/yahoo/yahoo.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/event/event.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(tabs/tabs.js);\" type=\"text/javascript\"></script>\n    <style type=\"text/css\">\n\n        #eCAL .tab {\n            -moz-border-radius-topLeft: 20px;\n            -moz-border-radius-topRight: 20px;\n            padding: 2px 15px 0px 15px;\n            text-align;center;\n            background-color:gray;\n            display:block;\n            float:left;\n            margin-right:5px;\n        }\n	#eCAL .tab:hover {\n	    background-color:#565656;\n	}\n	#eCAL .line {\n	    !float:right;\n	    height:3px;\n	    width:700px;\n	    background-color:#565656;\n	}\n        input, select {\n            font-size:8pt;\n	    font-family:verdana;\n            border:gray solid 1px;\n            background-color:#F0F0F0;\n            cursor:pointer;\n        }\n    </style>\n\n',0,1,0,1285733364,'<script src=\"^Extras(yui/build/yahoo/yahoo.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/event/event.js);\" type=\"text/javascript\"></script><script src=\"^Extras(tabs/tabs.js);\" type=\"text/javascript\"></script><style type=\"text/css\">#eCAL .tab{-moz-border-radius-topLeft:20px;-moz-border-radius-topRight:20px;padding:2px 15px 0px 15px;\n            text-align;center;background-color:gray;display:block;float:left;margin-right:5px;}#eCAL .tab:hover{background-color:#565656;}#eCAL .line{!float:right;height:3px;width:700px;background-color:#565656;}input,select{font-size:8pt;font-family:verdana;border:gray solid 1px;background-color:#F0F0F0;cursor:pointer;}</style>',0),('ihf4Rx6p72xn_nVKaIeOaw',1273032722,'3','pbversion0000000000001','approved','Greenportal_calendarSearch','Greenportal_calendarSearch','greenportal_calendar/greenportal_calendarsearch','3','7','3',NULL,0,1,0,0,0,9139,'    <style type=\"text/css\">\r\n        /* Edited with EditCSS */\r\n\r\n/**** Inline STYLE-tag style sheet ****/\r\n\r\n        #mCAL .tab {\r\n\r\n            border-bottom-style:none;\r\n            padding: 2px 15px 0px 15px;\r\n            text-align;center;\r\n            background-color:gray;\r\n            -moz-border-radius-topLeft:10px;\r\n            -moz-border-radius-topRight:10px;\r\n            display:block;\r\n            float:left;\r\n            margin-right:5px;\r\n        }      \r\n	#mCAL .tabSearch {\r\n	    border-bottom-style:none;\r\n	    font-weight:bold;\r\n	    padding: 2px 15px 0px 15px;\r\n	    text-align;center;\r\n	    background-color: #565656;\r\n	    -moz-border-radius-topLeft:10px;\r\n	    -moz-border-radius-topRight:10px;\r\n	    display:block;\r\n	    float:left;\r\n	    margin-right:5px;\r\n	}\r\n        #mCAL .tab:hover {\r\n            background-color:#565656;\r\n	}\r\n        #mCAL .heading {\r\n            width:100px;\r\n            -moz-box-sizing:border-box;\r\n            background-color:#334411;\r\n            text-align:center;\r\n            font-weight:bold;\r\n            color:#99CC33;\r\n            font-size:9px;\r\n            letter-spacing:1px;\r\n            text-transform:uppercase;\r\n            text-align:right;\r\n            vertical-align:top;\r\n            -moz-border-radius-bottomRight:8px;\r\n            -moz-border-radius-topRight:8px;            \r\n        }\r\n        #mCAL .day {\r\n            background-color:#334411;    \r\n	    color:#99CC33;       \r\n            width:400px;\r\n            position:relative;\r\n            -moz-border-radius-topLeft:8px;\r\n            -moz-border-radius-bottomLeft:8px;          \r\n        }\r\n        #mCAL .months {\r\n            text-align:center;\r\n            background-color:#334411;   \r\n            color:#99CC33;\r\n            font-weight:bold;\r\n        }         \r\n	#mCAL .curMonth {\r\n	    text-align:center;\r\n	    margin: 1px 0px;\r\n	    background-color:#334411;\r\n	    color:#99CC33;\r\n	    font-weight:bold;\r\n	}\r\n    </style>\r\n\r\n',0,1,0,1285733364,'<style type=\"text/css\">#mCAL .tab{border-bottom-style:none;padding:2px 15px 0px 15px;\n            text-align;center;background-color:gray;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;display:block;float:left;margin-right:5px;}#mCAL .tabSearch{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;\n	    text-align;center;background-color:#565656;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{background-color:#565656;}#mCAL .heading{width:100px;-moz-box-sizing:border-box;background-color:#334411;text-align:center;font-weight:bold;color:#99CC33;font-size:9px;letter-spacing:1px;text-transform:uppercase;text-align:right;vertical-align:top;-moz-border-radius-bottomRight:8px;-moz-border-radius-topRight:8px;}#mCAL .day{background-color:#334411;color:#99CC33;width:400px;position:relative;-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;}#mCAL .months{text-align:center;background-color:#334411;color:#99CC33;font-weight:bold;}#mCAL .curMonth{text-align:center;margin:1px 0px;background-color:#334411;color:#99CC33;font-weight:bold;}</style>',0),('jrWJ6nHXkqgFbml7BZ9chw',1273032722,'3','pbversion0000000000001','approved','Greenportal_submission','Greenportal_submission','greenportal_submission','3','7','3',NULL,0,1,0,0,0,21039,'<style type=\"text/css\">\r\n.defaultSubmissionDetails\r\n{\r\n	float: right; 		\r\n	padding: 2px; \r\n	margin: 2px;\r\n	margin-bottom:20px;\r\n}\r\n\r\n.collaborationThreadContent\r\n{\r\n	width:70%;\r\n}\r\n\r\n.postControls {\r\n	!border-top: 1px solid #cccccc;\r\n	background-color: #676767;\r\n	color: black;\r\n	padding: 2px;\r\n	text-align:right;\r\n}\r\n\r\n.postBorder {\r\n	border: 1px solid #cccccc;\r\n	margin-bottom: 10px;\r\n}\r\n.postBorderCurrent {\r\n	border: 2px solid #cccccc;\r\n	margin-bottom: 10px;\r\n}\r\n.postSubject {\r\n	!border-bottom: 1px solid #cccccc;\r\n	font-weight: bold;\r\n	padding: 3px;\r\n}\r\n.postData {\r\n	!border-bottom: 1px solid #cccccc;\r\n	background-color: #676767;\r\n	color:black;\r\n	padding: 3px;\r\n}\r\n.postData td {\r\n	color: black;\r\n}\r\n\r\n.postMessage {\r\n	padding: 3px;\r\n}\r\n.currentThread {\r\n	background-color: #eeeeee;\r\n}\r\n.threadHead {\r\n	font-weight: bold;\r\n	border-bottom: 1px solid #cccccc;\r\n	font-size: 9pt;\r\n	background-color: #676767;\r\n	color: black;\r\n	padding: 3px;\r\n}\r\n.threadData {\r\n	padding: 3px;\r\n}\r\n\r\n\r\n</style>\r\n',0,1,0,1285733364,'<style type=\"text/css\">.defaultSubmissionDetails{float:right;padding:2px;margin:2px;margin-bottom:20px;}.collaborationThreadContent{width:70%;}.postControls{!border-top:1px solid #cccccc;background-color:#676767;color:black;padding:2px;text-align:right;}.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:2px solid #cccccc;margin-bottom:10px;}.postSubject{!border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;}.postData{!border-bottom:1px solid #cccccc;background-color:#676767;color:black;padding:3px;}.postData td{color:black;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-size:9pt;background-color:#676767;color:black;padding:3px;}.threadData{padding:3px;}</style>',0),('Ys6f3vpe0y1uRcaCJ2TlFw',1273032722,'3','pbversion0000000000001','approved','Greenportal_messageboard','Greenportal_messageboard','greenportal_messageboard','3','7','3',NULL,0,1,0,0,0,5587,'<style type=\"text/css\">\r\n.MessageBoard {\r\n\r\n}\r\n.MessageBoard .tableHeader{\r\n	background: #DADADA;\r\n	border: 1px solid #676767;\r\n	color: black;\r\n	font-weight: bold;\r\n}\r\n.MessageBoard td{\r\n	background: #999999;\r\n	border-top: 1px solid #676767;\r\n	border-bottom: 1px solid #676767;\r\n	color: black;\r\n	padding-left: 3px;\r\n}\r\n.MessageBoard td.even {\r\n	background: #565656;\r\n	border-top: 1px solid #676767;\r\n	border-bottom: 1px solid #676767;\r\n	color: #CCCCCC;\r\n}\r\nh2 {\r\n	font-size: 18px;\r\n}\r\n\r\n</style>',0,1,0,1285733363,'<style type=\"text/css\">.MessageBoard{}.MessageBoard .tableHeader{background:#DADADA;border:1px solid #676767;color:black;font-weight:bold;}.MessageBoard td{background:#999999;border-top:1px solid #676767;border-bottom:1px solid #676767;color:black;padding-left:3px;}.MessageBoard td.even{background:#565656;border-top:1px solid #676767;border-bottom:1px solid #676767;color:#CCCCCC;}h2{font-size:18px;}</style>',0),('stevestyle000000000001',1273032722,'3','pbversion0000000000001','approved','Style 01','Style 01','style_01','3','7','12','by Steve from Plain Black http://plainblack.com\r\n\r\nThe first of the WebGUI 7 styles',0,0,0,0,0,3790,NULL,0,1,0,1285733365,NULL,0),('c8xrwVuu5QE0XtF9DiVzLw',1273032723,'3','pbversion0000000000001','approved','Default Inbox View Template','Default Inbox View Template','root/import/account/inbox/default-inbox-view-template','3','7','12',NULL,0,1,0,0,0,11070,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n\n<script type=\"text/javascript\">\nYAHOO.util.Event.onDOMReady(function(){\n   function isMessageCheckBox( element ) {\n      if(element.name == \"message\") return true;\n      return false;\n   }\n   \n   function toggleAllChecked(evt) {\n      var allBox     = YAHOO.util.Dom.get(\"check_all\");\n      var checkBoxes = YAHOO.util.Dom.getElementsBy(isMessageCheckBox,\"INPUT\",\"WGinboxTbl\");\n      for (var i = 0; i < checkBoxes.length; i++) {\n         checkBoxes[i].checked = allBox.checked;\n      }\n   }\n   \n   YAHOO.util.Event.addListener(\"check_all\",\"click\",toggleAllChecked);\n});\n</script>',0,1,0,1285733363,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){function f(d){if(d.name==\"message\")return true;return false}function c(b){var d=YAHOO.util.Dom.get(\"check_all\");var a=YAHOO.util.Dom.getElementsBy(f,\"INPUT\",\"WGinboxTbl\");for(var e=0;e<a.length;e++){a[e].checked=d.checked}}YAHOO.util.Event.addListener(\"check_all\",\"click\",c)});/*]]>*/</script>',0),('WikiKeyword00000000001',1274238756,'3','pbversion0000000000001','approved',' Wiki Pages By Keyword (default)',' Wiki Pages By Keyword','wiki-master-by-keyword-template.tmpl','3','7','3',NULL,0,0,0,0,0,2818,NULL,0,1,0,1285733363,NULL,0),('ThingyTmpl000000000004',1277868920,'3','pbversion0000000000001','approved','Default Thingy Search Thing','Default Thingy Search Thing','templates/thingy-default-search-thing','3','7','12',NULL,0,0,0,0,0,9564,'<script type=\"text/javascript\">\n	var timer;\n	var tempThing;\n	function showHide(tempThingId) {	\n			tempThing = document.getElementById(tempThingId);\n			var tempVis = tempThing.style.display;			\n			tempChildren = tempThing.childNodes;			\n			for(i=0;i<tempThing.childNodes.length;i++) {\n				if(tempThing.childNodes[i].tagName == \"A\") {					\n					tempThing.childNodes[i].onmouseout = mouseOutHide;\n					tempThing.childNodes[i].onmouseover = cancelTimer;\n				}\n			}			\n			if(tempVis == \"block\")\n				tempThing.style.display = \"none\";\n			else\n				tempThing.style.display = \"block\";\n	}\n\n	function mouseOutHide() {					\n		var parentVis = this.parentNode.style.display;		\n		timer = setTimeout(\"tempThing.style.display = \'none\'\", 125);			\n\n	}\n	function cancelTimer() {						\n		clearTimeout(timer);\n	}	\n</script>\n\n<style type=\"text/css\">\n	@import url(^/(root/import/thingy-templates/thingy.css););\n</style>\n\n<!--[if IE]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/thingy-templates/thingy-ie.css););\n	</style>\n<![endif]-->\n',0,1,0,1285733362,'<script type=\"text/javascript\">/*<![CDATA[*/var timer;var tempThing;function showHide(a){tempThing=document.getElementById(a);var b=tempThing.style.display;tempChildren=tempThing.childNodes;for(i=0;i<tempThing.childNodes.length;i++){if(tempThing.childNodes[i].tagName==\"A\"){tempThing.childNodes[i].onmouseout=mouseOutHide;tempThing.childNodes[i].onmouseover=cancelTimer}}if(b==\"block\")tempThing.style.display=\"none\";else tempThing.style.display=\"block\"}function mouseOutHide(){var b=this.parentNode.style.display;timer=setTimeout(\"tempThing.style.display = \'none\'\",125)}function cancelTimer(){clearTimeout(timer)}/*]]>*/</script><style type=\"text/css\">@import url(^/(root/import/thingy-templates/thingy.css);</style>',0),('GNOAsX98vCsl0JRwfwL-gg',1277868921,'3','pbversion0000000000001','approved','Collaboration','Collaboration','root/import/collaboration','3','7','12',NULL,0,0,0,0,0,338,NULL,0,1,0,1277868927,NULL,0),('PBtmpl0000000000000066',1277868921,'3','pbversion0000000000001','approved','Default USS','Default USS','default_uss','3','7','12',NULL,0,1,0,0,0,4993,'<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n\n</style>\n\n\n',0,1,0,1285733360,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000080',1277868921,'3','pbversion0000000000001','approved','FAQ','FAQ','faqtemplate','3','7','12',NULL,0,1,0,0,0,3968,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000097',1277868921,'3','pbversion0000000000001','approved','Traditional with Thumbnails','Traditional with Thumbnails','traditional_with_thumbnails','3','7','12',NULL,0,1,0,0,0,6674,'<style type=\"text/css\">\n.forumHead {\n	background-color: #DADADA;\n	border: 2px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n	font-family:arial;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;	\n	font-family:arial;\n}\n.forumHead a\n{\n	color:#29587E;\n}\n.oddThread a\n{\n	color:#29587E;\n}\n.evenThread a\n{\n	color:#29587E;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n	background-color:#EEEEEE;\n	font-family:arial;\n}\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.pagination a:hover {\n	text-decoration:none;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1285733360,'<style type=\"text/css\">.forumHead{background-color:#DADADA;border:2px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;font-family:arial;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;font-family:arial;}.forumHead a{color:#29587E;}.oddThread a{color:#29587E;}.evenThread a{color:#29587E;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;background-color:#EEEEEE;font-family:arial;}.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000112',1277868921,'3','pbversion0000000000001','approved','Weblog','Weblog','weblog','3','7','12',NULL,0,1,0,0,0,5202,'<style type=\"text/css\">\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n.weblogTitleBar {\n	font-weight: bold;\n	font-size: 14px;\n	font-family:arial;\n}\n\n.weblogLegend {\n	font-size: 9px;\n	color: #999999;\n	font-family:arial;\n}\n\n.weblogLegend a\n{\n	color:#29587E;\n}\n\n.weblogReadMore {\n	text-align: right;\n	font-size: 9px;\n	width: 100%;\n	font-family:arial;\n}\n\n.weblogSynopsis {\n	border: 1px solid #bbbbbb;\n	font-size: 13px;\n	padding: 5px;\n	-moz-border-radius: 6px;\n	font-family:arial;\n}\n</style>',0,1,0,1285733361,'<style type=\"text/css\">.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}.weblogTitleBar{font-weight:bold;font-size:14px;font-family:arial;}.weblogLegend{font-size:9px;color:#999999;font-family:arial;}.weblogLegend a{color:#29587E;}.weblogReadMore{text-align:right;font-size:9px;width:100%;font-family:arial;}.weblogSynopsis{border:1px solid #bbbbbb;font-size:13px;padding:5px;-moz-border-radius:6px;font-family:arial;}</style>',0),('PBtmpl0000000000000121',1277868921,'3','pbversion0000000000001','approved','Photo Gallery','Photo Gallery','photo_gallery','3','7','12',NULL,0,1,0,0,0,3185,'<style type=\"text/css\">\n.picture {\n	padding: 0px;\n	margin: 10px;\n	float: left;\n	font-size: 12px;\n	width: 150px;\n	height: 100px;\n}\n\nhtml > body .picture {\nheight:auto;\nmin-height:150px;\nwidth:auto;\nmin-width:100px;\n}\n</style>\n\n',0,1,0,1285733361,'<style type=\"text/css\">.picture{padding:0px;margin:10px;float:left;font-size:12px;width:150px;height:100px;}html > body .picture{height:auto;min-height:150px;width:auto;min-width:100px;}</style>',0),('PBtmpl0000000000000067',1277868921,'3','pbversion0000000000001','approved','Default Submission','Default Submission','default_submission','3','7','12',NULL,0,1,0,0,0,22672,'<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:20px;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	background-color: #eeeeee;\n	padding: 3px;\n}\n.postData td {\n	font-size: 9pt;\n	color: black;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #676767;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n	clear:both;\n	width:100%;\n	display:block;\n	-moz-box-sizing:border-box;\n	text-align:right;\n	margin-top:1px;\n}\n.postControls a:link, .postControls a:visited\n{\n	text-decoration:underline;\n	color:white;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n\n.collaborationThreadContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\n</style>\n',0,1,0,1285733360,'<style type=\"text/css\">.defaultSubmissionDetails{float:right;padding:2px;margin:2px;font-size:9pt;font-family:arial;margin-bottom:20px;}.defaultSubmissionDetails a{color:#29587E;}.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;font-family:arial;}.postData{border-bottom:1px solid #cccccc;background-color:#eeeeee;padding:3px;}.postData td{font-size:9pt;color:black;font-family:arial;}.postControls{border-top:1px solid #cccccc;background-color:#676767;color:black;padding:3px;font-family:arial;clear:both;width:100%;display:block;-moz-box-sizing:border-box;text-align:right;margin-top:1px;}.postControls a:link,.postControls a:visited{text-decoration:underline;color:white;}.postControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;font-family:arial;}.threadData{font-size:11px;padding:3px;font-family:arial;}.collaborationThreadContent{font-family:arial;font-size:9pt;}</style>',0),('PBtmpl0000000000000026',1277868921,'3','pbversion0000000000001','approved','Default Forum','Default Forum','default_forum','3','7','12',NULL,0,1,0,0,0,7927,'<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n',0,1,0,1285733359,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000128',1277868921,'3','pbversion0000000000001','approved','Classifieds','Classifieds','classifieds','3','7','12',NULL,0,1,0,0,0,3272,'<style type=\"text/css\">\n.ad {\n	border: 1px dotted #aaaaaa;\n	padding: 10px;\n	margin: 0px;\n	float: left;\n	width: 140px;\n	font-size: 12px;\n	height: 175px;\n	overflow: hidden;\n}\n</style>\n\n',0,1,0,1285733361,'<style type=\"text/css\">.ad{border:1px dotted #aaaaaa;padding:10px;margin:0px;float:left;width:140px;font-size:12px;height:175px;overflow:hidden;}</style>',0),('PBtmpl0000000000000079',1277868921,'3','pbversion0000000000001','approved','Topics','Topics','topics','3','7','12',NULL,0,1,0,0,0,4948,'<style type=\"text/css\">\n.postControls\n{\n	background:#676767;\n	color:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.postControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.pagination\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a\n{\n	color:white;\n	font-size:8pt;\n}\n.pagination a:hover {\n	text-decoration:none;\n}\n.topicsTitle\n{\n	-moz-box-sizing:border-box;\n	width:95%;\n	border-bottom:solid silver 1px;\n	margin-bottom:3px;\n	font-family:arial;\n}\n\n.topicContent\n{\n	-moz-box-sizing:border-box;\n	font-family:arial;\n	font-size:9pt;\n	width:95%;\n	display:block;\n	border:solid silver 1px;\n	padding:3px;\n}\n\n</style>\n',0,1,0,1285733360,'<style type=\"text/css\">.postControls{background:#676767;color:#C0C0C0;width:95%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.postControls a{color:white;font-size:8pt;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.pagination{-moz-box-sizing:border-box;background:#676767;width:95%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;}.pagination a:hover{text-decoration:none;}.topicsTitle{-moz-box-sizing:border-box;width:95%;border-bottom:solid silver 1px;margin-bottom:3px;font-family:arial;}.topicContent{-moz-box-sizing:border-box;font-family:arial;font-size:9pt;width:95%;display:block;border:solid silver 1px;padding:3px;}</style>',0),('PBtmpl0000000000000083',1277868921,'3','pbversion0000000000001','approved','Link List','Link List','link_list','3','7','12',NULL,0,1,0,0,0,3716,NULL,0,1,0,1285733360,NULL,0),('PBtmpl0000000000000082',1277868921,'3','pbversion0000000000001','approved','Unordered List','Unordered List','unordered_list','3','7','12',NULL,0,1,0,0,0,4633,'<style type=\"text/css\">\n.pagination {\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n.pagination a {\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n\n.pagination a:hover {\n	text-decoration:none;\n}\n\n.unorderedList\n{\n	font-family:arial;\n	font-size:9pt;\n}\n\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1285733360,'<style type=\"text/css\">.pagination{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.pagination a{color:white;font-size:8pt;text-decoration:underline;}.pagination a:hover{text-decoration:none;}.unorderedList{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000133',1277868921,'3','pbversion0000000000001','approved','Guest Book','Guest Book','guest_book','3','7','12',NULL,0,1,0,0,0,3270,NULL,0,1,0,1285733361,NULL,0),('PBtmpl0000000000000029',1277868921,'3','pbversion0000000000001','approved','Default Post Form','Default Post Form','default_post_form','3','7','12',NULL,0,1,0,0,0,4119,'<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n',0,1,0,1285733359,'<style type=\"text/css\">table.defaultPostForm td{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000032',1277868921,'3','pbversion0000000000001','approved','Default Thread','Default Thread','default_thread','3','7','12',NULL,0,1,0,0,0,11649,'<style type=\"text/css\">\n	.postBorder {\n		border: 1px solid #cccccc;\n		margin-bottom: 10px;\n	}\n 	.postBorderCurrent {\n		border: 3px dotted black;\n		margin-bottom: 10px;\n	}\n	.postSubject {\n		border-bottom: 1px solid #cccccc;\n		font-weight: bold;\n		padding: 3px;\n	}\n	.postData {\n		border-bottom: 1px solid #cccccc;\n		font-size: 9pt;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.postData a {\n		color:#29587E;\n		text-decoration:underline;\n	}\n	.postData a:hover {\n		text-decoration:none;\n	}\n	.postControls {\n		border-top: 1px solid #cccccc;\n		background-color: #676767;\n		color: black;\n		padding: 3px;\n		text-align:right;\n	}\n	.postControls a:link, .postControls a:visited {\n		color:white;\n		text-decoration:underline;\n	}\n	.postControls a:hover {\n		text-decoration:none;\n	}\n	.bottomControls {\n		background-color:#676767;\n		padding: 3px;\n		text-align:right;\n	}\n	.bottomControls a:link, .bottomControls a:visited {\n		color:white;\n		text-decoration:underline;\n	}	\n	.bottomControls a:hover {\n		text-decoration:none;\n	}\n	.postMessage {\n		padding: 3px;\n	}\n	.currentThread {\n		background-color: #eeeeee;\n	}\n	.threadHead {\n		font-weight: bold;\n		border-bottom: 1px solid #cccccc;\n		font-size: 9pt;\n		background-color: #eeeeee;\n		color: black;\n		padding: 3px;\n	}\n	.threadData {\n		font-size: 11px;\n		padding: 3px;\n	}\n</style>\n',0,1,0,1285733359,'<style type=\"text/css\">.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;}.postData{border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.postData a{color:#29587E;text-decoration:underline;}.postData a:hover{text-decoration:none;}.postControls{border-top:1px solid #cccccc;background-color:#676767;color:black;padding:3px;text-align:right;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.bottomControls{background-color:#676767;padding:3px;text-align:right;}.bottomControls a:link,.bottomControls a:visited{color:white;text-decoration:underline;}.bottomControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.threadData{font-size:11px;padding:3px;}</style>',0),('PBtmpl0000000000000027',1277868921,'3','pbversion0000000000001','approved','Default Forum Notification','Default Forum Notification','default_forum_notification','3','7','12',NULL,0,1,0,0,0,3141,NULL,0,1,0,1285733359,NULL,0),('PBtmpl0000000000000031',1277868921,'3','pbversion0000000000001','approved','Default Forum Search','Default Forum Search','default_forum_search','3','7','12',NULL,0,1,0,0,0,3848,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n}\n.searchResults{\n	border:solid silver 1px;\n	margin-top:5px;\n}\n.searchResults td{\n	font-family:arial;\n	font-size:9pt;\n}\n.searchResults td a{\n	color:#29587E;\n}\n.searchResults td.odd{\n	background-color:#DADADA;\n}\n.searchResults td.tableHeader{\n	background-color:gray;\n	color:white;\n	border-bottom:double solid silver 3px;\n	font-weight:bold;\n}\n.pagination\n{\n	background:#C0C0C0;\n	width:95%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n}\n\n.postControls a\n{\n	color:white;\n}\n\n</style>',0,1,0,1285733359,'<style type=\"text/css\">h2{font-family:arial;}.searchResults{border:solid silver 1px;margin-top:5px;}.searchResults td{font-family:arial;font-size:9pt;}.searchResults td a{color:#29587E;}.searchResults td.odd{background-color:#DADADA;}.searchResults td.tableHeader{background-color:gray;color:white;border-bottom:double solid silver 3px;font-weight:bold;}.pagination{background:#C0C0C0;width:95%;text-align:right;padding:3px;font-size:9pt;font-family:arial;}.postControls a{color:white;}</style>',0),('PBtmpl0000000000000068',1277868921,'3','pbversion0000000000001','approved','Default Submission Form','Default Submission Form','default_submission_form','3','7','12',NULL,0,1,0,0,0,5051,'<style type=\"text/css\">\ntable.defaultSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1285733360,'<style type=\"text/css\">table.defaultSubmissionForm td{font-family:arial;font-size:9pt;}.defaultSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000099',1277868921,'3','pbversion0000000000001','approved','FAQ Submission Form','FAQ Submission Form','faq_submission_form','3','7','12',NULL,0,1,0,0,0,4330,'<style type=\"text/css\">\ntable.faqSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.faqSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1285733361,'<style type=\"text/css\">table.faqSubmissionForm td{font-family:arial;font-size:9pt;}.faqSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000114',1277868922,'3','pbversion0000000000001','approved','Link List Submission Form','Link List Submission Form','link_list_submission_form','3','7','12',NULL,0,1,0,0,0,5502,'<style type=\"text/css\">\ntable.linkSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.linkSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1285733361,'<style type=\"text/css\">table.linkSubmissionForm td{font-family:arial;font-size:9pt;}.linkSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000077',1277868922,'3','pbversion0000000000001','approved','Job Listing','Job Listing','job_listing','3','7','12',NULL,0,1,0,0,0,4723,'<style type=\"text/css\">\n\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n',0,1,0,1285733360,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000098',1277868922,'3','pbversion0000000000001','approved','Job','Job','job','3','7','12',NULL,0,1,0,0,0,20225,'<style type=\"text/css\">\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n	font-size:9pt;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.postControls\n{\n	background:#676767;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.threadData {\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n\n.tableHeader\n{\n	width:20%;\n	background-color:#DADADA;\n	font-family:arial;\n	font-size:9pt;	\n}\n\n.tableData\n{\n	width:80%;\n	border:solid #DADADA 1px;\n	font-family:arial;\n	font-size:9pt;	\n}\n</style>',0,1,0,1285733360,'<style type=\"text/css\">.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;font-family:arial;font-size:9pt;}.postData{border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.postControls{background:#676767;display:block;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-top:1px;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.threadData{font-family:arial;font-size:9pt;padding:3px;}.tableHeader{width:20%;background-color:#DADADA;font-family:arial;font-size:9pt;}.tableData{width:80%;border:solid #DADADA 1px;font-family:arial;font-size:9pt;}</style>',0),('PBtmpl0000000000000122',1277868922,'3','pbversion0000000000001','approved','Job Submission Form','Job Submission Form','job_submission_form','3','7','12',NULL,0,1,0,0,0,6134,'<style type=\"text/css\">\ntable.jobSubmissionForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.jobSubmissionFormContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n\n</style>\n',0,1,0,1285733361,'<style type=\"text/css\">table.jobSubmissionForm td{font-family:arial;font-size:9pt;}.jobSubmissionFormContent{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000081',1277868922,'3','pbversion0000000000001','approved','Q and A','Q and A','q_and_a','3','7','12',NULL,0,1,0,0,0,4546,'<style type=\"text/css\">\n.collab-qa { position: relative; }\n.collab-qa .dropcap { position: absolute; left: -1.5em; top: 0px; width: 1.4em; text-align: center; } \n.collab-qa dt, .collab-qa dd { margin-left: 1.5em; padding-left: 0.5em; position: relative; }\n.collab-qa dt, .collab-qa dt .dropcap { font-weight: bold; background-color: #ccc; line-height: 2em; height: 2em; vertical-align: bottom; }\n.collab-qa dt p { /* stupid controls */ margin: 0; vertical-align: top !important; }\n</style>\n',0,1,0,1285733360,'<style type=\"text/css\">.collab-qa{position:relative;}.collab-qa .dropcap{position:absolute;left:-1.5em;top:0px;width:1.4em;text-align:center;}.collab-qa dt,.collab-qa dd{margin-left:1.5em;padding-left:0.5em;position:relative;}.collab-qa dt,.collab-qa dt .dropcap{font-weight:bold;background-color:#ccc;line-height:2em;height:2em;vertical-align:bottom;}.collab-qa dt p{margin:0;vertical-align:top !important;}</style>',0),('PBtmpl0000000000000101',1277868922,'3','pbversion0000000000001','approved','Ordered List','Ordered List','ordered_list','3','7','12',NULL,0,1,0,0,0,3771,NULL,0,1,0,1285733361,NULL,0),('PBtmpl0000000000000113',1277868922,'3','pbversion0000000000001','approved','Link','Link','link','3','7','12',NULL,0,1,0,0,0,19099,'<style type=\"text/css\">\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.postControls\n{\n	background:#676767;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-family:arial;\n	font-size:9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n}\n.threadData {\n	font-family:arial;\n	font-size:9pt;\n	padding: 3px;\n}\n.linkContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n.linkContent a\n{\n	color:#29587E;\n}\nh2\n{\n	font-family:arial;\n}\n</style>',0,1,0,1285733361,'<style type=\"text/css\">.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;font-family:arial;font-size:9pt;padding:3px;}.postData{border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.postControls{background:#676767;display:block;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-top:1px;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-family:arial;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;}.threadData{font-family:arial;font-size:9pt;padding:3px;}.linkContent{font-family:arial;font-size:9pt;}.linkContent a{color:#29587E;}h2{font-family:arial;}</style>',0),('PBtmpl0000000000000208',1277868922,'3','pbversion0000000000001','approved','Request Tracker','Request Tracker','request-tracker-template','3','7','12',NULL,0,0,0,0,0,6800,'\n<style type=\"text/css\">\n.forumHead {\n	background-color: #eeeeee;\n	border-bottom: 1px solid #cccccc;\n	padding: 2px;\n	padding-bottom: 4px;\n	font-size: 13px;\n	font-weight: bold;\n}\n.oddThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #83cc83;\n	padding-bottom: 4px;\n}\n.evenThread {\n	font-size: 13px;\n	border-bottom: 1px dashed #aaaaff;\n	padding-bottom: 4px;\n}\n</style>\n\n\n\n',0,1,0,1285733362,'<style type=\"text/css\">.forumHead{background-color:#eeeeee;border-bottom:1px solid #cccccc;padding:2px;padding-bottom:4px;font-size:13px;font-weight:bold;}.oddThread{font-size:13px;border-bottom:1px dashed #83cc83;padding-bottom:4px;}.evenThread{font-size:13px;border-bottom:1px dashed #aaaaff;padding-bottom:4px;}</style>',0),('PBtmpl0000000000000209',1277868922,'3','pbversion0000000000001','approved','Request Tracker Thread','Request Tracker Thread','request-tracker-post-template','3','7','12',NULL,0,0,0,0,0,22451,'<style type=\"text/css\">\n.defaultSubmissionDetails\n{\n	float: right; 		\n	padding: 2px; \n	margin: 2px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:20px;\n}\n\n.defaultSubmissionDetails a\n{\n	color:#29587E;\n}\n\n.postBorder {\n	border: 1px solid #cccccc;\n	margin-bottom: 10px;\n}\n.postBorderCurrent {\n	border: 3px dotted black;\n	margin-bottom: 10px;\n}\n.postSubject {\n	border-bottom: 1px solid #cccccc;\n	font-weight: bold;\n	padding: 3px;\n	font-family:arial;\n}\n.postData {\n	border-bottom: 1px solid #cccccc;\n	background-color: #eeeeee;\n	padding: 3px;\n}\n.postData td {\n	font-size: 9pt;\n	color: black;\n	font-family:arial;\n}\n.postControls {\n	border-top: 1px solid #cccccc;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n	clear:both;\n	width:100%;\ndisplay:block;\n	-moz-box-sizing:border-box;\n}\n.postMessage {\n	padding: 3px;\n}\n.currentThread {\n	background-color: #eeeeee;\n}\n.threadHead {\n	font-weight: bold;\n	border-bottom: 1px solid #cccccc;\n	font-size: 9pt;\n	background-color: #eeeeee;\n	color: black;\n	padding: 3px;\n	font-family:arial;\n}\n.threadData {\n	font-size: 11px;\n	padding: 3px;\n	font-family:arial;\n}\n\n.postControls\n{\n	background:#676767;\n	display:block;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-top: 1px;	\n}\n.postControls a:link, .postControls a:visited\n{\n	color:white;\n	text-decoration:underline;\n}\n.postControls a:hover {\n	text-decoration:none;\n}\n.collaborationThreadContent\n{\n	font-family:arial;\n	font-size:9pt;\n}\n</style>\n',0,1,0,1285733362,'<style type=\"text/css\">.defaultSubmissionDetails{float:right;padding:2px;margin:2px;font-size:9pt;font-family:arial;margin-bottom:20px;}.defaultSubmissionDetails a{color:#29587E;}.postBorder{border:1px solid #cccccc;margin-bottom:10px;}.postBorderCurrent{border:3px dotted black;margin-bottom:10px;}.postSubject{border-bottom:1px solid #cccccc;font-weight:bold;padding:3px;font-family:arial;}.postData{border-bottom:1px solid #cccccc;background-color:#eeeeee;padding:3px;}.postData td{font-size:9pt;color:black;font-family:arial;}.postControls{border-top:1px solid #cccccc;background-color:#eeeeee;color:black;padding:3px;font-family:arial;clear:both;width:100%;display:block;-moz-box-sizing:border-box;}.postMessage{padding:3px;}.currentThread{background-color:#eeeeee;}.threadHead{font-weight:bold;border-bottom:1px solid #cccccc;font-size:9pt;background-color:#eeeeee;color:black;padding:3px;font-family:arial;}.threadData{font-size:11px;padding:3px;font-family:arial;}.postControls{background:#676767;display:block;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-top:1px;}.postControls a:link,.postControls a:visited{color:white;text-decoration:underline;}.postControls a:hover{text-decoration:none;}.collaborationThreadContent{font-family:arial;font-size:9pt;}</style>',0),('PBtmpl0000000000000210',1277868922,'3','pbversion0000000000001','approved','Request Tracker Post Form','Request Tracker Post Form','request-tracker-template2','3','7','12',NULL,0,0,0,0,0,5928,'<style type=\"text/css\">\ntable.defaultPostForm td\n{\n	font-family:arial;\n	font-size:9pt;\n}\nh2\n{\n	font-family:arial;\n}\n</style>\n\n\n',0,1,0,1285733362,'<style type=\"text/css\">table.defaultPostForm td{font-family:arial;font-size:9pt;}h2{font-family:arial;}</style>',0),('default_post_received1',1277868922,'3','pbversion0000000000001','approved','Default Post Received','Default Post Received','default_post_received','3','7','4',NULL,0,0,0,0,0,541,NULL,0,1,0,1285733364,NULL,0),('default_CS_unsubscribe',1277868922,'3','pbversion0000000000001','approved','Default Collaboration System Unsubscribe','Default Collaboration System Unsubscribe','collaboration_unsubscribe','3','7','4',NULL,0,0,0,0,0,1092,NULL,0,1,0,1285733364,NULL,0),('mfHGkp6t9gdclmzN33OEnw',1277868927,'3','pbversion0000000000001','approved','Default Twitter Choose Username','Default Twitter Choose Username','root/import/auth/twitter/chooseusername/default-twitter-choose-username','3','7','12',NULL,0,1,0,0,0,1074,NULL,0,1,0,1285733365,NULL,0),('U78V5IJHVljvRTb6ydsTHg',1279073449,'3','pbversion0000000000001','approved','Greenportal_calendarMonth','Greenportal_calendarMonth','greenportal_calendar/greenportal_calendarmonth','3','7','3',NULL,0,1,0,0,0,12462,'<style type=\"text/css\">\n\n		#mCAL .tab {\n			border-bottom-style: none;\n			padding: 2px 5px 0px 5px;\n			background-color: gray;\n			-moz-border-radius-topLeft: 8px;\n			-moz-border-radius-topRight: 8px;\n			display: block;\n			float: left;\n		}\n		\n		#mCAL .tabMonth {\n			border-bottom-style: none;\n			padding: 2px 5px 0px 5px;\n			background-color: #565656;\n			-moz-border-radius-topLeft: 8px;\n			-moz-border-radius-topRight: 8px;\n			display: block;\n			float: left;\n		}\n\n		#mCAL .tab:hover {\n			background-color: #666666;\n		}	\n\n		#mCAL .controls {\n			float:right;\n			vertical-align:bottom;\n			font-size:7pt;\n		}\n\n		#mCAL .curMonth {\n			text-align:center;\n			margin: 1px 0px;\n			background-color:#565656;\n			color:white;\n			font-weight:bold;\n		}\n\n		#mCAL .line {\n			float: right;\n			width: 220px;\n			height: 3px;\n			background-color: #565656;\n		}\n\n/**** Month view ****/\n/* Table */\n\n#mCAL table#month th\n{\n	-moz-box-sizing:border-box;\n	width:			27px;\n	background-color:	#334411;\n	text-align:		center;\n	font-size:		7pt;\n	font-weight:		bold;\n	color:			#99CC33;	\n}\n\n#mCAL table#month div\n{\n	position:		relative;\n	width:			27px;\n	height:			19px;\n}\n\n#mCAL table#month ul \n{	\n	overflow:		hidden;\n}\n\n#mCAL table#month .active\n{\n	!-moz-border-radius:	5px;\n	-moz-border-radius-topright: 5px;\n	vertical-align:		top;		\n	background-color:	#334411;\n	border:			solid #676767 1px;\n}\n\n#mCAL table#month .active a\n{		\n	height:			17px;\n}\n\n#mCAL table#month .active a:hover\n{	\n	height:			17px;\n	background-color:	#99CC33;\n	border:			solid #CCD2E3 1px;\n}\n\n#mCAL table#month .current \n{\n	background-color:	#BB8888;\n	border-color:		#676767;\n}\n#mCAL table#month .current a\n{\n}\n#mCAL table#month .current a:hover\n{\n	background-color:	#EE82EE;\n	border:			solid #CCD2E3 1px;\n}\n\n#mCAL table#month .number \n{\n	display:		block;\n	!position:		absolute;\n	!background-color:	#516BA4;\n	text-align:		center;\n	vertical-align:		right;\n	font-size:		7pt;\n	font-weight:		bold;\n	padding-top:		1px;\n}\n\n#mCAL table#month .eventButton \n{\n	position:		absolute;\n	left:			8px;\n	bottom:			12px;\n}\n\n/* MORE STYLES */\n\n.moreDisplay \n{\n	position: 		absolute;\n	border:			solid orange 1px;\n	border-top:		solid orange 2px;\n	font-family:		arial;\n	font-size:		10px;\n	width:			300px;\n	height: 		auto;\n	padding:		2px;\n	background-color:	#FFD3A8;\n	color:			black;\n	display:        none;\n	z-index: 		100;\n}\n\n.moreDisplay a {\n   color: black;\n}\n\n* html body table#month td { position: relative; z-index: 1; }\n</style>\n\n<script type=\"text/javascript\" src=\'^Extras(yui/build/yahoo/yahoo.js);\'></script>\n<script type=\"text/javascript\" src=\'^Extras(yui/build/event/event.js);\' ></script>\n\n<script>\n<!--\n//<![CDATA[\n	\n   //-----------------------------------------------------------------------------------   	\n   function isSelfOrChildOf(parent,node) {\n      if(parent == node) return true;\n	  if(parent == null || node == null) return false;\n	  var childLen = parent.childNodes.length;\n      for (var i = 0; i < childLen; i++) {\n         var child = parent.childNodes[i];\n	     if(child.nodeType != 1) continue; //Skip text and attribute nodes\n	     if(isSelfOrChildOf (child,node)) {\n	        return true;\n	     }\n      }\n      return false;\n   }	\n   \n   //-----------------------------------------------------------------------------------   \n   function findParentNodeFromChild (node,tagName) {\n      if(node == null) return node;\n	  var parent = node.parentNode;\n	  if(parent == null) return node;\n	  if(parent.tagName == tagName) {\n	     return parent;\n	  }\n	  return findParentNodeFromChild (parent,tagName);\n   }\n   \n   \n   //-----------------------------------------------------------------------------------   \n   function showEvents(eventId) {\n	  var evt = YAHOO.util.Event.getEvent();\n      var targ = YAHOO.util.Event.getTarget(evt);\n	  \n	  var elem = document.getElementById(eventId);\n	  var td;\n      var pPagex;\n      var pPagey;\n          \n      //IE is stupid\n      var isIE = navigator.userAgent.indexOf(\"MSIE\") > -1;\n      var isIE7 = navigator.userAgent.indexOf(\"MSIE 7\") > -1;\n      if(isIE && !isIE7) {\n         //IE 6 and below don\'t register offsetTop or offsetLeft for the div\n         td = findParentNodeFromChild(targ,\"TD\");\n         pPagex = td.offsetTop;\n         pPagey = td.offsetLeft;\n      } else {\n         var cDiv = findParentNodeFromChild(targ,\"DIV\");\n	     pPagex = cDiv.offsetTop;\n	     pPagey = cDiv.offsetLeft;\n         td = findParentNodeFromChild(cDiv,\"TD\");\n      }\n      \n      var tdHeight = td.offsetHeight;\n\n	  var eventX = tdHeight + pPagex;\n	  var eventY = pPagey;\n		  \n	  elem.style.top = eventX + \'px\';\n	  elem.style.left = eventY + \'px\';\n	  elem.style.display = \"block\";\n      \n	  //Register listener\n	  YAHOO.util.Event.addListener(document.body,\"mousemove\",hideEvents,{ \"targ\":targ, \"elem\": elem, \"td\": td })\n	  return false;\n   }\n   \n   //-----------------------------------------------------------------------------------   \n   function hideEvents(e, el) {\n	  if(!e || !el) return;\n	  \n	  var elem = el.elem;\n	  var td = el.td;\n	  var targ = el.targ;\n	  \n	  var evtTarg = YAHOO.util.Event.getTarget(e);\n	  \n	  var inDiv = isSelfOrChildOf(elem,evtTarg);\n      var inTd = isSelfOrChildOf(td,evtTarg);\n	  var inTarget = isSelfOrChildOf(targ,evtTarg);\n	  \n	  if(inDiv || inTd || inTarget) {\n	     //do nothing\n	  } else {\n	     elem.style.display = \"none\";\n		 YAHOO.util.Event.removeListener (document.body,\"mousemove\",hideEvents);    \n	  }\n	  return false;\n   }\n   \n//]]>\n-->      \n</script>\n\n',0,1,0,1285733362,'<style type=\"text/css\">#mCAL .tab{border-bottom-style:none;padding:2px 5px 0px 5px;background-color:gray;-moz-border-radius-topLeft:8px;-moz-border-radius-topRight:8px;display:block;float:left;}#mCAL .tabMonth{border-bottom-style:none;padding:2px 5px 0px 5px;background-color:#565656;-moz-border-radius-topLeft:8px;-moz-border-radius-topRight:8px;display:block;float:left;}#mCAL .tab:hover{background-color:#666666;}#mCAL .controls{float:right;vertical-align:bottom;font-size:7pt;}#mCAL .curMonth{text-align:center;margin:1px 0px;background-color:#565656;color:white;font-weight:bold;}#mCAL .line{float:right;width:220px;height:3px;background-color:#565656;}#mCAL table#month th{-moz-box-sizing:border-box;width:27px;background-color:#334411;text-align:center;font-size:7pt;font-weight:bold;color:#99CC33;}#mCAL table#month div{position:relative;width:27px;height:19px;}#mCAL table#month ul{overflow:hidden;}#mCAL table#month .active{!-moz-border-radius:5px;-moz-border-radius-topright:5px;vertical-align:top;background-color:#334411;border:solid #676767 1px;}#mCAL table#month .active a{height:17px;}#mCAL table#month .active a:hover{height:17px;background-color:#99CC33;border:solid #CCD2E3 1px;}#mCAL table#month .current{background-color:#BB8888;border-color:#676767;}#mCAL table#month .current a{}#mCAL table#month .current a:hover{background-color:#EE82EE;border:solid #CCD2E3 1px;}#mCAL table#month .number{display:block;!position:absolute;!background-color:#516BA4;text-align:center;vertical-align:right;font-size:7pt;font-weight:bold;padding-top:1px;}#mCAL table#month .eventButton{position:absolute;left:8px;bottom:12px;}.moreDisplay{position:absolute;border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;height:auto;padding:2px;background-color:#FFD3A8;color:black;display:none;z-index:100;}.moreDisplay a{color:black;}* html body table#month td{position:relative;z-index:1;}</style><script type=\"text/javascript\" src=\'^Extras(yui/build/yahoo/yahoo.js);\'></script><script type=\"text/javascript\" src=\'^Extras(yui/build/event/event.js);\'></script><script>\n      \n</script>',0),('CalendarMonth000000001',1279073449,'3','pbversion0000000000001','approved','Default Calendar Month','Default Calendar Month','root/import/calendar-templates/default-calendar-month','3','7','12',NULL,0,0,0,0,0,16187,'<style type=\"text/css\">\n		#mCAL * {\n			margin:0px;			\n		}\n		#mCAL td {\n			font-size:10px;\n			font-family:arial;\n		}\n		#mCAL .tab {\n\n			border-bottom-style: none;\n			font-weight: bold;\n			padding: 2px 15px 0px 15px;\n			text-align: center;\n			background-color: #E9ECF3;\n			-moz-border-radius-topLeft: 10px;\n			-moz-border-radius-topRight: 10px;\n			color: #7588B5;\n			text-decoration: none;\n			font-size: 10pt;\n			display: block;\n			float: left;\n			margin-right: 5px;\n		}\n		#mCAL .tab:hover {\n			color:black;\n		}	\n		#mCAL .active {\n			background-color:#DFE3EE;\n			color:#404F77;\n			border-bottom:solid #DFE3EE 1px;\n		}	\n		#mCAL .controls {\n			float:right;\n			vertical-align:bottom;\n		}\n		#mCAL a {\n			font-size:11px;\n			color:#517AC8;\n		}	\n		#mCAL .months {\n			text-align:center;\n			background-color:#DFE3EE;			\n		}\n		#mCAL .months a {\n			color:#517AC8;\n			text-decoration:none;\n		}\n		#mCAL .months .monthLink {\n			text-decoration:none;			\n			padding-left:5px;\n			padding-right:5px;\n			color:#AAB8D5;\n			font-size:12px;\n			font-weight:bold;\n		}	\n\n		#mCAL .months .current, #mCAL .months .monthLink:hover {\n			font-weight:bold;\n			color:#517AC8;\n			background-color:#fff;			\n			-moz-border-radius:5px;\n		}\n		#mCAL .curMonth {\n			text-align:center;\n			margin: 2px 0px;\n			background-color:#517AC8;\n			color:white;\n			font-size:14px;\n			font-weight:bold;\n		}\n\n\n\n/**** Month view ****/\n/* Table */\n#mCAL table#month\n{\n\n}\n\n#mCAL table#month *\n{\n	padding:		0px;\n	margin:			0px;\n}\n\n#mCAL table#month a\n{\n	text-decoration:	none;\n}\n\n#mCAL table#month th\n{\n	-moz-box-sizing:border-box;\n	width:			85px;\n	background-color:	#517AC8;\n	text-align:		center;\n	font-weight:		bold;\n	color:			white;	\n}\n\n#mCAL table#month div\n{\n	position:		relative;\n	width:			85px;\n	height:			85px;\n	margin:			0px;\n	background-color:	#E9ECF3;\n}\n\n#mCAL table#month ul \n{	\n	overflow:		hidden;\n}\n\n#mCAL table#month .active \n{\n	-moz-border-radius-topLeft:	8px;\n	-moz-border-radius-bottomLeft:	8px;\n	-moz-border-radius-bottomRight:	8px;\n	vertical-align:		top;		\n	background-color:	#CCD2E3;\n	border:			solid #CCD2E3 1px;\n}\n\n#mCAL table#month .current \n{\n	background-color:	#FFE4B3;\n	border-color:		orange;\n}\n\n#mCAL table#month .number \n{\n	-moz-border-radius-bottomLeft:5px;\n	display:		block;\n	position:		absolute;\n	top:			0px;\n	right:			0px;\n	height:			10px;\n	width:			13px;\n	background-color:	#516BA4;\n	color:			white;\n	text-align:		center;\n	vertical-align:		middle;\n	padding:		0px 3px 2px 2px;\n	font-weight:		bold;\n}\n\n#mCAL table#month .current .number\n{\n	background-color:	orange;\n	color:			black;\n}\n\n#mCAL table#month .events \n{\n	padding:		3px;\n	padding-top:		8px;\n	font-weight:		bold;			\n}\n\n#mCAL table#month .events a \n{\n	color:			#4F4F4F;\n	text-decoration:	none;\n	font-size:		9px;\n}\n\n#mCAL table#month .moreButton \n{\n	border-style:		none;\n	position:		absolute;\n	bottom:			0px;\n	width:			100%;\n	height:			9px;\n	background-color:	#517AC8;	\n	font-size:		5px;\n	text-align:		center;\n	-moz-border-radius-bottomLeft:	8px;\n	-moz-border-radius-bottomRight:	8px;\n}\n\n#mCAL table#month .moreButton img\n{\n	border:			none;\n}\n\n\n/* MORE STYLES */\n\n.moreDisplay \n{\n	position: 		absolute;\n	border:			solid orange 1px;\n	border-top:		solid orange 2px;\n	font-family:		arial;\n	font-size:		10px;\n	width:			300px;\n	height: 		auto;\n	padding:		2px;\n	background-color:	#FFD3A8;\n	color:			black;\n	display:        none;\n	z-index: 		100;\n}\n\n.moreDisplay a {\n   color: black;\n}\n\n* html body table#month td { position: relative; z-index: 1; }\n</style>\n\n<script type=\"text/javascript\" src=\'^Extras(yui/build/yahoo/yahoo.js);\'></script>\n<script type=\"text/javascript\" src=\'^Extras(yui/build/event/event.js);\' ></script>\n\n<script>\n<!--\n//<![CDATA[\n	\n   //-----------------------------------------------------------------------------------   	\n   function isSelfOrChildOf(parent,node) {\n      if(parent == node) return true;\n	  if(parent == null || node == null) return false;\n	  var childLen = parent.childNodes.length;\n      for (var i = 0; i < childLen; i++) {\n         var child = parent.childNodes[i];\n	     if(child.nodeType != 1) continue; //Skip text and attribute nodes\n	     if(isSelfOrChildOf (child,node)) {\n	        return true;\n	     }\n      }\n      return false;\n   }	\n   \n   //-----------------------------------------------------------------------------------   \n   function findParentNodeFromChild (node,tagName) {\n      if(node == null) return node;\n	  var parent = node.parentNode;\n	  if(parent == null) return node;\n	  if(parent.tagName == tagName) {\n	     return parent;\n	  }\n	  return findParentNodeFromChild (parent,tagName);\n   }\n   \n   \n   //-----------------------------------------------------------------------------------   \n   function showEvents(eventId) {\n	  var evt = YAHOO.util.Event.getEvent();\n      var targ = YAHOO.util.Event.getTarget(evt);\n	  \n	  var elem = document.getElementById(eventId);\n	  var td;\n      var pPagex;\n      var pPagey;\n          \n      //IE is stupid\n      var isIE = navigator.userAgent.indexOf(\"MSIE\") > -1;\n      var isIE7 = navigator.userAgent.indexOf(\"MSIE 7\") > -1;\n      var isIE8 = navigator.userAgent.indexOf(\"MSIE 8.0\") > -1;\n      if(isIE && !(isIE7 || isIE8)) {\n         //IE 6 and below don\'t register offsetTop or offsetLeft for the div\n         td = findParentNodeFromChild(targ,\"TD\");\n         pPagex = td.offsetTop;\n         pPagey = td.offsetLeft;\n      } else {\n         var cDiv = findParentNodeFromChild(targ,\"DIV\");\n	     pPagex = cDiv.offsetTop;\n	     pPagey = cDiv.offsetLeft;\n         td = findParentNodeFromChild(cDiv,\"TD\");\n      }\n      \n      var tdHeight = td.offsetHeight;\n\n	  var eventX = tdHeight + pPagex;\n	  var eventY = pPagey;\n		  \n	  elem.style.top = eventX + \'px\';\n	  elem.style.left = eventY + \'px\';\n	  elem.style.display = \"block\";\n      \n	  //Register listener\n	  YAHOO.util.Event.addListener(document.body,\"mousemove\",hideEvents,{ \"targ\":targ, \"elem\": elem, \"td\": td })\n	  return false;\n   }\n   \n   //-----------------------------------------------------------------------------------   \n   function hideEvents(e, el) {\n	  if(!e || !el) return;\n	  \n	  var elem = el.elem;\n	  var td = el.td;\n	  var targ = el.targ;\n	  \n	  var evtTarg = YAHOO.util.Event.getTarget(e);\n	  \n	  var inDiv = isSelfOrChildOf(elem,evtTarg);\n      var inTd = isSelfOrChildOf(td,evtTarg);\n	  var inTarget = isSelfOrChildOf(targ,evtTarg);\n	  \n	  if(inDiv || inTd || inTarget) {\n	     //do nothing\n	  } else {\n	     elem.style.display = \"none\";\n		 YAHOO.util.Event.removeListener (document.body,\"mousemove\",hideEvents);    \n	  }\n	  return false;\n   }\n   \n//]]>\n-->      \n</script>',0,1,0,1285733357,'<style type=\"text/css\">#mCAL *{margin:0px;}#mCAL td{font-size:10px;font-family:arial;}#mCAL .tab{border-bottom-style:none;font-weight:bold;padding:2px 15px 0px 15px;text-align:center;background-color:#E9ECF3;-moz-border-radius-topLeft:10px;-moz-border-radius-topRight:10px;color:#7588B5;text-decoration:none;font-size:10pt;display:block;float:left;margin-right:5px;}#mCAL .tab:hover{color:black;}#mCAL .active{background-color:#DFE3EE;color:#404F77;border-bottom:solid #DFE3EE 1px;}#mCAL .controls{float:right;vertical-align:bottom;}#mCAL a{font-size:11px;color:#517AC8;}#mCAL .months{text-align:center;background-color:#DFE3EE;}#mCAL .months a{color:#517AC8;text-decoration:none;}#mCAL .months .monthLink{text-decoration:none;padding-left:5px;padding-right:5px;color:#AAB8D5;font-size:12px;font-weight:bold;}#mCAL .months .current,#mCAL .months .monthLink:hover{font-weight:bold;color:#517AC8;background-color:#fff;-moz-border-radius:5px;}#mCAL .curMonth{text-align:center;margin:2px 0px;background-color:#517AC8;color:white;font-size:14px;font-weight:bold;}#mCAL table#month{}#mCAL table#month *{padding:0px;margin:0px;}#mCAL table#month a{text-decoration:none;}#mCAL table#month th{-moz-box-sizing:border-box;width:85px;background-color:#517AC8;text-align:center;font-weight:bold;color:white;}#mCAL table#month div{position:relative;width:85px;height:85px;margin:0px;background-color:#E9ECF3;}#mCAL table#month ul{overflow:hidden;}#mCAL table#month .active{-moz-border-radius-topLeft:8px;-moz-border-radius-bottomLeft:8px;-moz-border-radius-bottomRight:8px;vertical-align:top;background-color:#CCD2E3;border:solid #CCD2E3 1px;}#mCAL table#month .current{background-color:#FFE4B3;border-color:orange;}#mCAL table#month .number{-moz-border-radius-bottomLeft:5px;display:block;position:absolute;top:0px;right:0px;height:10px;width:13px;background-color:#516BA4;color:white;text-align:center;vertical-align:middle;padding:0px 3px 2px 2px;font-weight:bold;}#mCAL table#month .current .number{background-color:orange;color:black;}#mCAL table#month .events{padding:3px;padding-top:8px;font-weight:bold;}#mCAL table#month .events a{color:#4F4F4F;text-decoration:none;font-size:9px;}#mCAL table#month .moreButton{border-style:none;position:absolute;bottom:0px;width:100%;height:9px;background-color:#517AC8;font-size:5px;text-align:center;-moz-border-radius-bottomLeft:8px;-moz-border-radius-bottomRight:8px;}#mCAL table#month .moreButton img{border:none;}.moreDisplay{position:absolute;border:solid orange 1px;border-top:solid orange 2px;font-family:arial;font-size:10px;width:300px;height:auto;padding:2px;background-color:#FFD3A8;color:black;display:none;z-index:100;}.moreDisplay a{color:black;}* html body table#month td{position:relative;z-index:1;}</style><script type=\"text/javascript\" src=\'^Extras(yui/build/yahoo/yahoo.js);\'></script><script type=\"text/javascript\" src=\'^Extras(yui/build/event/event.js);\'></script><script>\n      \n</script>',0),('StockDataTMPL000000001',1279073449,'3','pbversion0000000000001','approved','StockData Default View','StockData Default View','stockdatatmpl000000001','3','7','12',NULL,0,1,0,0,0,9056,'\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(wobject/StockData/tools.css);\" />',0,1,0,1285733362,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(wobject/StockData/tools.css);\" />',0),('8tqyQx-LwYUHIWOlKPjJrA',1279073449,'3','pbversion0000000000001','approved','EMS Event Submission Template','EMS Event Submission Template','root/import/ems/ems-event-submission','3','7','12',NULL,0,1,0,0,0,5296,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" />\n\n<script src=\"^Extras(/tinymce/jscripts/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui-webgui/build/datepicker/datepicker.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/calendar/calendar-min.js);\" type=\"text/javascript\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui-webgui/build/form/form.js);\"></script>\n\n	<style type=\"text/css\">\n\n	</style>\n',0,1,0,1285733357,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" /><script src=\"^Extras(/tinymce/jscripts/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui-webgui/build/datepicker/datepicker.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/calendar/calendar-min.js);\" type=\"text/javascript\"></script><script type=\"text/javascript\" src=\"^Extras(yui-webgui/build/form/form.js);\"></script><style type=\"text/css\">\n\n	</style>',0),('DoVNijm6lMDE0cYrtvEbDQ',1279073449,'3','pbversion0000000000001','approved','EMS Event Submission Main Template','EMS Event Submission Main Template','root/import/ems/ems-event-submission-main','3','7','12',NULL,0,1,0,0,0,8281,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\n\n<script src=\"^Extras(/tinymce/jscripts/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/tabview/tabview-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/wobject/EMS/submission.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui-webgui/build/form/form.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui-webgui/build/i18n/i18n.js);\" type=\"text/javascript\"></script>\n\n<!--begin custom header content for this example-->\n<style type=\"text/css\">\n.yui-navset div.loading div {\n    background:url(^Extras(wobject/EMS/loading.gif);) no-repeat center center;\n    height:8em; /* hold some space while loading */\n}\n\n#example-canvas h2 {padding: 0 0 .5em 0;}\n\n#loadingIndicator { padding-right:20px; background-color:white; border:1px dotted black;padding:5px;margin:10px; } \n#loadingIndicator .hd { border:1px solid red;padding:5px; } \n#loadingIndicator .bd { border:1px solid green;padding:5px; } \n#loadingIndicator .ft { border:1px solid blue;padding:5px; } \n\nul.yui-nav li span.close {\nheight:12px;\noverflow:hidden;\nright:2px;\ntext-indent:500px;\ntop:2px;\nwidth:12px;\ncursor:pointer;\n}\n\n</style>\n',0,1,0,1285733357,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/tinymce/jscripts/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/tabview/tabview-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/wobject/EMS/submission.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui-webgui/build/form/form.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui-webgui/build/i18n/i18n.js);\" type=\"text/javascript\"></script><style type=\"text/css\">.yui-navset div.loading div{background:url(^Extras(wobject/EMS/loading.gif);) no-repeat center center;height:8em;}#example-canvas h2{padding:0 0 .5em 0;}#loadingIndicator{padding-right:20px;background-color:white;border:1px dotted black;padding:5px;margin:10px;}#loadingIndicator .hd{border:1px solid red;padding:5px;}#loadingIndicator .bd{border:1px solid green;padding:5px;}#loadingIndicator .ft{border:1px solid blue;padding:5px;}ul.yui-nav li span.close{height:12px;overflow:hidden;right:2px;text-indent:500px;top:2px;width:12px;cursor:pointer;}</style>',0),('6uQEULvXFgCYlRWnYzZsuA',1279073450,'3','pbversion0000000000001','approved','Default Inbox Send Message Template','Default Inbox Send Message Template','root/import/account/inbox/default-inbox-send-message-template','3','7','12',NULL,0,1,0,0,0,9065,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/container/assets/skins/sam/container.css);\" />\n\n<script>\n   var removeText = \'^International(remove text,Account_Inbox);\';\n</script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/container/container-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(account/inbox.js);\"></script>',0,1,0,1285733357,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/container/assets/skins/sam/container.css);\" /><script>\n   var removeText = \'^International(remove text,Account_Inbox);\';\n</script><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/container/container-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(account/inbox.js);\"></script>',0),('ktSvKU8riGimhcsxXwqvPQ',1279073450,'3','pbversion0000000000001','approved','EMS Event Submission Queue','EMS Event Submission Queue','root/import/ems/ems-event-submission-queue','3','7','12',NULL,0,1,0,0,0,7457,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link type=\"text/css\" rel=\"stylesheet\" src=\"^Extras(wobject/EMS/submission.js);\" />\n\n<script src=\"^Extras(/tinymce/jscripts/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n<script type=\"text/javascript\" src=\"^Extras(wobject/EMS/submission.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui-webgui/build/form/form.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui-webgui/build/i18n/i18n.js);\"></script>\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n\n	<style type=\"text/css\">\n	</style>\n',0,1,0,1285733364,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\" /><link type=\"text/css\" rel=\"stylesheet\" src=\"^Extras(wobject/EMS/submission.js);\" /><script src=\"^Extras(/tinymce/jscripts/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script type=\"text/javascript\" src=\"^Extras(wobject/EMS/submission.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui-webgui/build/form/form.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui-webgui/build/i18n/i18n.js);\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><style type=\"text/css\">\n	</style>',0),('PBtmpl0000000000000021',1280279759,'3','pbversion0000000000001','approved','Data List','Data List','data_list','3','7','12',NULL,0,1,0,0,0,4521,'<style type=\"text/css\">\nh2{\n	font-family:arial;\n	margin-top:3px;\n	margin-bottom:3px;\n}\n.errors{\n	font-family:arial;\n	font-size:9pt;\n}\n.defaultData td{\n	font-family:arial;\n	font-size:9pt;\n}\n.dataControls\n{\n	-moz-box-sizing:border-box;\n	background:#676767;\n	color:#C0C0C0;\n	width:100%;\n	text-align:right;\n	padding:3px;\n	font-size:9pt;\n	font-family:arial;\n	margin-bottom:5px;\n}\n.dataControls a\n{\n	color:white;\n	font-size:8pt;\n	text-decoration:underline;\n}\n.dataControls a:hover {\n	text-decoration:none;\n}\n</style>',0,1,0,1285733359,'<style type=\"text/css\">h2{font-family:arial;margin-top:3px;margin-bottom:3px;}.errors{font-family:arial;font-size:9pt;}.defaultData td{font-family:arial;font-size:9pt;}.dataControls{-moz-box-sizing:border-box;background:#676767;color:#C0C0C0;width:100%;text-align:right;padding:3px;font-size:9pt;font-family:arial;margin-bottom:5px;}.dataControls a{color:white;font-size:8pt;text-decoration:underline;}.dataControls a:hover{text-decoration:none;}</style>',0),('4Yfz9hqBqM8OYMGuQK8oLw',1271352537,'1','pbversion0000000000001','approved','Get Features','Get Features','yns/features','3','7','4',NULL,0,1,0,0,0,772,NULL,0,1,0,1280279778,NULL,0),('Wl8WZ43g2rK5AYr9o4zY7w',1271445539,'1','pbversion0000000000001','approved','Get Style','Get Style','yns/style','3','7','4',NULL,0,1,0,0,0,700,NULL,0,1,0,1280279778,NULL,0),('LBuiKzg2mWwmOPS9AgV3bg',1271348789,'1','pbversion0000000000001','approved','Get Translated','Get Translated','yns/translated','3','7','4',NULL,0,1,0,0,0,728,NULL,0,1,0,1280279778,NULL,0),('jTNggl7AoVSUc_ZzrvuCmw',1271348789,'1','pbversion0000000000001','approved','Get Promoted','Get Promoted','yns/promotion','3','7','4',NULL,0,1,0,0,0,721,NULL,0,1,0,1280279778,NULL,0),('mTOiwwk3q4k9g5-XykXhPA',1271349647,'1','pbversion0000000000001','approved','Documentation','Documentation','documentation','3','7','3',NULL,0,0,0,0,0,561,NULL,0,1,0,1280279778,NULL,0),('j_1qEqM6iLfQLiR6VKy0aA',1271349878,'1','pbversion0000000000001','approved','Free Documentation','Free Documentation','documentation/free-documentation','3','7','3',NULL,0,1,0,0,0,1604,NULL,0,1,0,1280279778,NULL,0),('diZvW4bSgZWwyyGP3qXi1g',1271349814,'1','pbversion0000000000001','approved','Commercial Documentation','Commercial Documentation','documentation/commercial-documentation','3','7','3',NULL,0,1,0,0,0,1440,NULL,0,1,0,1280279778,NULL,0),('2TqQc4OISddWCZmRY1_m8A',1271357565,'1','pbversion0000000000001','approved','Join Us','Join Us','join_us','3','7','3',NULL,0,0,0,0,0,577,NULL,0,1,0,1280279778,NULL,0),('k2Qj03FrAOXYra8kDJYYXw',1271357513,'1','pbversion0000000000001','approved','IRC (Internet Relay Chat)','IRC','join_us/irc','3','7','3',NULL,0,1,0,0,0,1197,NULL,0,1,0,1280279778,NULL,0),('ksSfkZdsr0uC62NwIk6hFQ',1271356973,'1','pbversion0000000000001','approved','WebGUI Users Conference','WUC','join_us/wuc','3','7','3',NULL,0,1,0,0,0,861,NULL,0,1,0,1280279778,NULL,0),('nWxS5jnA3o3DgPEwBeR7yQ',1271357239,'1','pbversion0000000000001','approved','The Forums','forums','join_us/forums','3','7','3',NULL,0,1,0,0,0,1531,NULL,0,1,0,1280279778,NULL,0),('x3OFY6OJh_qsXkZfPwug4A',1271348790,'1','pbversion0000000000001','approved','Site Map','Site Map','site_map','3','7','3',NULL,0,0,0,0,0,349,NULL,0,1,0,1280279778,NULL,0),('pJd5TLAjfWMVXD6sCRLwUg',1271348790,'1','pbversion0000000000001','approved','Site Map','Site Map','site_map/site_map','3','7','3',NULL,0,1,0,0,0,364,NULL,0,1,0,1280279778,NULL,0),('OhdaFLE7sXOzo_SIP2ZUgA',1271445348,'1','pbversion0000000000001','approved','Welcome','Welcome','home/welcome','3','7','4',NULL,0,1,0,0,0,2190,NULL,0,1,0,1280279778,NULL,0),('IWFxZDyGhQ3-SLZhELa3qw',1277737686,'1','pbversion0000000000001','approved','Benefits','Benefits','home/key-benefits','3','7','4',NULL,0,1,0,0,0,1835,NULL,0,1,0,1280279778,NULL,0),('LdiozcIUciWuvt3Z-na5Ww',1281501162,'3','pbversion0000000000001','approved','Matrix','Matrix','root/import/matrix','3','7','12',NULL,0,0,0,0,0,317,NULL,0,1,0,1281501164,NULL,0),('matrixtmpl000000000002',1281501162,'3','pbversion0000000000001','approved','Matrix Default Compare','Matrix Default Compare','matrix-default-compare-template','3','7','12',NULL,0,0,0,0,0,20669,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->\n\n',0,1,0,1285733364,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script><script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script><script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script><style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style>',0),('matrixtmpl000000000001',1281501162,'3','pbversion0000000000001','approved','Matrix Default View','Matrix Default View','matrix-default-view-template','3','7','12',NULL,0,0,0,0,0,22048,'<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->\n\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\n\n\n',0,1,0,1285733364,'<style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style><script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>',0),('matrixtmpl000000000003',1281501163,'3','pbversion0000000000001','approved','Matrix Default Detailed Listing','Matrix Default Detailed Listing','matrix-default-detailed-listing','3','7','12',NULL,0,0,0,0,0,15360,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script>\n\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->',0,1,0,1285733364,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script><script src=\"^/(new-matrix/show-hide.js);\" type=\"text/javascript\"></script><style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style>',0),('matrixtmpl000000000004',1281501163,'3','pbversion0000000000001','approved','Matrix Default Edit Listing','Matrix Default Edit Listing','default-matrix-edit-listing-template','3','7','12',NULL,0,0,0,0,0,525,NULL,0,1,0,1285733364,NULL,0),('matrixtmpl000000000005',1281501163,'3','pbversion0000000000001','approved','Matrix Default Search','Matrix Default Search','matrix-search-template','3','7','12',NULL,0,0,0,0,0,10307,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script>\n<script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix.css););\n</style>\n\n<!--[if IE]>\n<style type=\"text/css\">\n@import url(^/(new-matrix/matrix-ie.css););\n</style>\n<![endif]-->',0,1,0,1285733365,'<link href=\"^Extras(yui/build/container/assets/container.css);\" rel=\"stylesheet\" type=\"text/css\" /><link href=\"^Extras(hoverhelp.css);\" rel=\"stylesheet\" type=\"text/css\" /><script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/dom/dom-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/event/event-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(yui/build/container/container-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(hoverhelp.js);\" type=\"text/javascript\"></script><script src=\"^/(matrix/equal-cols.js);\" type=\"text/javascript\"></script><style type=\"text/css\">@import url(^/(new-matrix/matrix.css);</style>',0),('hkj6WeChxFyqfP85UlRP8w',1281501163,'3','pbversion0000000000001','approved','matrix.css','matrix.css','new-matrix/matrix.css','3','7','12',NULL,0,1,0,0,0,16408,NULL,0,1,0,1285733366,NULL,0),('kJf77eCr9GAMiEzWrzsBTA',1281501163,'3','pbversion0000000000001','approved','matrix-ie.css','matrix-ie.css','new-matrix/matrix-ie.css','3','7','12',NULL,0,1,0,0,0,764,NULL,0,1,0,1285733366,NULL,0),('4LQT4-bGW4FkiEQLSY5gvQ',1281501163,'3','pbversion0000000000001','approved','show-hide.js','show-hide.js','new-matrix/show-hide.js','3','7','12',NULL,0,1,0,0,0,933,NULL,0,1,0,1285733366,NULL,0),('alraubvBu-YJJ614jAHD5w',1281501163,'3','pbversion0000000000001','approved','matrix-nav-tmpl','matrix-nav-tmpl','new-matrix/matrix-nav-tmpl','3','7','12',NULL,0,1,0,0,0,711,NULL,0,1,0,1285733363,NULL,0),('Vch1Ww7G_JpBhOhXX07RDg',1281501163,'3','pbversion0000000000001','approved','matrx-nav','matrix-nav','new-matrix/matrix-nav','3','7','12',NULL,0,1,0,0,0,375,NULL,0,1,0,1281501164,NULL,0),('wrq7hMxb1ewQqZ46xmd8Gg',1281501163,'3','pbversion0000000000001','approved','equal-cols.js','equal-cols.js','matrix/equal-cols.js','3','7','12',NULL,0,1,0,0,0,796,NULL,0,1,0,1285733367,NULL,0),('matrixtmpl000000000007',1281501163,'3','pbversion0000000000001','approved','Matrix Default Screenshots Config','Matrix Default Screenshots Config','matrix-default-screenshots-config','3','7','12',NULL,0,0,0,0,0,4099,NULL,0,1,0,1285733365,NULL,0),('matrixtmpl000000000006',1281501163,'3','pbversion0000000000001','approved','Matrix Default Screenshots','Matrix Default Screenshots','matrix-default-screenshots','3','7','12',NULL,0,0,0,0,0,2952,NULL,0,1,0,1285733365,NULL,0),('N716tpSna0iIQTKxS4gTWA',1281501163,'3','pbversion0000000000001','approved','Default Account Layout','Default Account Layout','root/import/account/default-account-layout2','3','7','12',NULL,0,1,0,0,0,1923,'<link rel=\"stylesheet\" href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" type=\"text/css\">\r\n<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0,1,0,1285733358,'<link rel=\"stylesheet\" href=\"^Extras(yui/build/tabview/assets/skins/sam/tabview.css);\" type=\"text/css\"><link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('AssetReportFolder00001',1281501163,'3','pbversion0000000000001','approved','Asset Report','Asset Report','asset_report','3','3','4',NULL,0,0,0,0,0,322,NULL,0,1,0,1281501164,NULL,0),('_XfvgNH__bY1ykMiKYSobQ',1281501163,'3','pbversion0000000000001','approved','account.css','account.css','root/import/account/account.css','3','7','12',NULL,0,1,0,0,0,45634,NULL,0,1,0,1285733366,NULL,0),('limMkk80fMB3fqNZVf162w',1281501163,'3','pbversion0000000000001','approved','Default Asset Subscription','Default Asset Subscription','root/import/default-asset-subscription','3','7','3',NULL,0,1,0,0,0,550,NULL,0,1,0,1285733364,NULL,0),('N7uMnnicbyTEulcuRi1sSg',1284523698,'3','pbversion0000000000001','approved','PDFs','PDFs','media/pdfs','3','7','4',NULL,0,1,0,0,0,304,NULL,0,1,0,1284523814,NULL,0),('bCGr7FRtZt-XYlBVUEJBjw',1278013724,'3','pbversion0000000000001','approved','Getting_Started_doc.pdf','Getting_Started_doc.pdf','media/pdfs/getting_started_doc.pdf','3','7','4',NULL,0,1,0,0,0,1188407,NULL,0,1,0,1284523814,NULL,0),('A16v-YjWAShXWvSACsraeg',1284523755,'3','pbversion0000000000001','approved','StoryTopic','StoryTopic','root/import/storymanager/storytopic','3','7','4',NULL,0,0,0,0,0,2870,'<link href=\"^/(storymanager.css);\" rel=\"stylesheet\" type=\"text/css\" />',0,1,0,1285733357,'<link href=\"^/(storymanager.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('sJtcUCfn0CVbKdb4QM61Yw',1284523755,'3','pbversion0000000000001','approved','Asset Report Default Template','Asset Report Default Template','asset-report/asset-report-default-template','3','3','4',NULL,0,1,0,0,0,2218,NULL,0,1,0,1285733365,NULL,0),('gI_TxK-5S4DNuv42wpImmw',1284523756,'3','pbversion0000000000001','approved','Gallery Templates','Gallery Templates','root/import/gallery-templates','3','7','3',NULL,0,0,0,0,0,362,NULL,0,1,0,1284523760,NULL,0),('jME5BEDYVDlBZ8jIQA9-jQ',1284523756,'3','pbversion0000000000001','approved','Default Gallery Search','Default Gallery Search','root/import/gallery-templates/default-gallery-search','3','7','3',NULL,0,1,0,0,0,11344,'<style type=\"text/css\">\r\n	@import url(^/(root/import/gallery-templates/gallery.css););\r\n</style>\r\n	\r\n<!--[if IE]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n	</style>\r\n<![endif]-->',0,1,0,1285733364,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('azCqD0IjdQSlM3ar29k5Sg',1284523756,'3','pbversion0000000000001','approved','Default Gallery List Albums View','Default Gallery List Albums View','root/import/gallery-templates/default-gallery-list-albums-view','3','7','3',NULL,0,1,0,0,0,5810,'	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery.css););\r\n	</style>\r\n	\r\n	<!--[if IE ]>\r\n		<style type=\"text/css\">\r\n			@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n		</style>\r\n	<![endif]-->',0,1,0,1285733363,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('05FpjceLYhq4csF1Kww1KQ',1284523756,'3','pbversion0000000000001','approved','Default Gallery View Album','Default Gallery View Album','root/import/gallery-templates/default-gallery-view-album','3','7','3',NULL,0,1,0,0,0,7744,'	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery.css););\n	</style>\n	\n	<!--[if IE ]>\n		<style type=\"text/css\">\n			@import url(^/(root/import/gallery-templates/gallery-ie.css););\n		</style>\n	<![endif]-->',0,1,0,1285733356,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('q5O62aH4pjUXsrQR3Pq4lw',1284523756,'3','pbversion0000000000001','approved','Default Gallery View Album Thumbnails','Default Gallery View Album Thumbnails','root/import/gallery-templates/default-gallery-view-album-thumbnails','3','7','3',NULL,0,1,0,0,0,7534,'<style type=\"text/css\">\r\n	@import url(^/(root/import/gallery-templates/gallery.css););\r\n</style>\r\n\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n	</style>\r\n<![endif]-->\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/dom/dom-min.js);\"></script>\r\n<script type=\"text/javascript\" src=\"^Extras(yui/build/event/event-min.js);\"></script>',0,1,0,1285733365,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/dom/dom-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/event/event-min.js);\"></script>',0),('KAMdiUdJykjN02CPHpyZOw',1284523756,'3','pbversion0000000000001','approved','Default Gallery View Album Slideshow','Default Gallery View Album Slideshow','root/import/gallery-templates/default-gallery-view-album-slideshow','3','7','3',NULL,0,1,0,0,0,7824,'<style type=\"text/css\">\r\n	@import url(^/(root/import/gallery-templates/gallery.css););\r\n</style>\r\n	\r\n<!--[if IE ]>\r\n	<style type=\"text/css\">\r\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\r\n	</style>\r\n<![endif]-->\r\n\r\n<script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script> \r\n<script src=\"^Extras(yui/build/event/event-min.js);\"></script>  \r\n<script src=\"^Extras(yui/build/dom/dom-min.js);\"></script>  \r\n<script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/slideshow.js);\"></script>\r\n\r\n<script type=\"text/javascript\">\r\n	var ss  = new WebGUI.Slideshow();\r\n</script>',0,1,0,1285733358,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style><script src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script><script src=\"^Extras(yui/build/event/event-min.js);\"></script><script src=\"^Extras(yui/build/dom/dom-min.js);\"></script><script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/slideshow.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/var ss=new WebGUI.Slideshow();/*]]>*/</script>',0),('OkphOEdaSGTXnFGhK4GT5A',1284523756,'3','pbversion0000000000001','approved','Default Gallery List Files For User','Default Gallery List Files For User','root/import/gallery-templates/default-gallery-list-files-for-user','3','7','3',NULL,0,1,0,0,0,7673,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1285733358,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style>',0),('TEId5V-jEvUULsZA0wuRuA',1284523756,'3','pbversion0000000000001','approved','Default Gallery View Photo','Default Gallery View Photo','root/import/gallery-templates/default-gallery-view-photo','3','7','3',NULL,0,1,0,0,0,15449,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<script type=\"text/javascript\">\nfunction toggleView( link, first, second, eid ) {\n	var e = document.getElementById( eid );\n	if ( e.style.display == \"none\" ) {\n		e.style.display = \"block\";\n		link.innerHTML = second;\n	}\n	else {\n		e.style.display = \"none\";\n		link.innerHTML = first;\n	}\n}\n</script>',0,1,0,1285733362,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);</style><script type=\"text/javascript\">/*<![CDATA[*/function toggleView(c,e,a,d){var b=document.getElementById(d);if(b.style.display==\"none\"){b.style.display=\"block\";c.innerHTML=a}else{b.style.display=\"none\";c.innerHTML=e}}/*]]>*/</script>',0),('6X-7Twabn5KKO_AbgK3PEw',1284523756,'3','pbversion0000000000001','approved','Default Gallery Edit Album','Default Gallery Edit Album','root/import/gallery-templates/default-gallery-edit-album','3','7','3',NULL,0,1,0,0,0,8127,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/animation/animation-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/dragdrop/dragdrop-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/json/json-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/dragdropsorting.js);\"></script>\n\n<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->',0,1,0,1285733357,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/animation/animation-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/dragdrop/dragdrop-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo/yahoo-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/json/json-min.js);\"></script><script type=\"text/javascript\" src=\"^/(root/import/gallery-templates/dragdropsorting.js);\"></script><style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('7JCTAiu1U_bT9ldr655Blw',1284523757,'3','pbversion0000000000001','approved','Default Gallery Edit Photo','Default Gallery Edit Photo','root/import/gallery-templates/default-gallery-edit-photo','3','7','3',NULL,0,1,0,0,0,7198,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1285733357,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('0X4Q3tBWUb_thsVbsYz9xQ',1284523757,'3','pbversion0000000000001','approved','Default Gallery Add Archive','Default Gallery Add Archive','root/import/gallery-templates/default-gallery-add-archive','3','7','3',NULL,0,1,0,0,0,3650,'	<link href=\"^/(root/import/gallery-templates/admin.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n\r\n	<!--[if IE 7]>\r\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\r\n	<![endif]-->',0,1,0,1285733356,'<link href=\"^/(root/import/gallery-templates/admin.css);\" rel=\"stylesheet\" type=\"text/css\" />',0),('m3IbBavqzuKDd2PGGhKPlA',1284523757,'3','pbversion0000000000001','approved','Default Gallery Make Shortcut','Default Gallery Make Shortcut','root/import/gallery-templates/default-gallery-make-shortcut','3','7','3',NULL,0,1,0,0,0,4871,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1285733364,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('UTNFeV7B_aSCRmmaFCq4Vw',1284523757,'3','pbversion0000000000001','approved','Default Gallery Delete Album','Default Gallery Delete Album','root/import/gallery-templates/default-gallery-delete-album','3','7','3',NULL,0,1,0,0,0,4472,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1285733362,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('zcX-wIUct0S_np14xxOA-A',1284523757,'3','pbversion0000000000001','approved','Default Gallery Delete File','Default Gallery Delete File','root/import/gallery-templates/default-gallery-delete-file','3','7','3',NULL,0,1,0,0,0,4488,'<style type=\"text/css\">\n	@import url(^/(root/import/gallery-templates/gallery.css););\n	@import url(^/(root/import/gallery-templates/admin.css););\n</style>\n	\n<!--[if IE ]>\n	<style type=\"text/css\">\n		@import url(^/(root/import/gallery-templates/gallery-ie.css););\n	</style>\n<![endif]-->\n\n<!--[if IE 7]>\n	<link href=\"^/(root/import/gallery-templates/admin_ie7.css);\" rel=\"stylesheet\" type=\"text/css\" />\n<![endif]-->',0,1,0,1285733366,'<style type=\"text/css\">@import url(^/(root/import/gallery-templates/gallery.css);@import url(^/(root/import/gallery-templates/admin.css);</style>',0),('MBZK_LPVzqhb4TV4mMRTJg',1284523757,'3','pbversion0000000000001','approved','admin_ie7.css','admin_ie7.css','root/import/gallery-templates/admin_ie7.css','3','7','3',NULL,0,1,0,0,0,380,NULL,0,1,0,1285733366,NULL,0),('_hELmIJfgbAyXFNqPyApxQ',1284523757,'3','pbversion0000000000001','approved','admin.css','admin.css','root/import/gallery-templates/admin.css','3','7','3',NULL,0,1,0,0,0,3957,NULL,0,1,0,1285733366,NULL,0),('_9_eiaPgxzF_x_upt6-PNQ',1284523757,'3','pbversion0000000000001','approved','gallery.css','gallery.css','root/import/gallery-templates/gallery.css','3','7','3',NULL,0,1,0,0,0,18802,NULL,0,1,0,1285733366,NULL,0),('kaPRSaf8UKiskiGEgJgLAw',1284523757,'3','pbversion0000000000001','approved','images','images','root/import/gallery-templates/images','3','7','3',NULL,0,0,0,0,0,340,NULL,0,1,0,1284523760,NULL,0),('bANo8aiAPA7aY_oQZKxIWw',1284523757,'3','pbversion0000000000001','approved','rss.gif','rss.gif','root/import/gallery-templates/images/rss.gif','3','7','3',NULL,0,1,0,0,0,1389,NULL,0,1,0,1284523760,NULL,0),('2ci_v2d4x4uvyjTRlC49OA',1284523757,'3','pbversion0000000000001','approved','moveDown.gif','moveDown.gif','root/import/gallery-templates/images/movedown.gif','3','7','3',NULL,0,1,0,0,0,784,NULL,0,1,0,1284523760,NULL,0),('O-EsSzKgAk1KolFT-x_KsA',1284523757,'3','pbversion0000000000001','approved','moveUp.gif','moveUp.gif','root/import/gallery-templates/images/moveup.gif','3','7','3',NULL,0,1,0,0,0,772,NULL,0,1,0,1284523760,NULL,0),('fdd8tGExyVwHyrB8RBbKXg',1284523757,'3','pbversion0000000000001','approved','next.gif','next.gif','root/import/gallery-templates/images/next.gif','3','7','3',NULL,0,1,0,0,0,1676,NULL,0,1,0,1284523760,NULL,0),('BpisgHl4ZDcSECJp6oib1w',1284523757,'3','pbversion0000000000001','approved','play.gif','play.gif','root/import/gallery-templates/images/play.gif','3','7','3',NULL,0,1,0,0,0,2113,NULL,0,1,0,1284523760,NULL,0),('zshreRgPAXtnF0DtVbQ1Yg',1284523757,'3','pbversion0000000000001','approved','previous.gif','previous.gif','root/import/gallery-templates/images/previous.gif','3','7','3',NULL,0,1,0,0,0,1682,NULL,0,1,0,1284523760,NULL,0),('POVcY79vIqAHR8OfGt36aw',1284523757,'3','pbversion0000000000001','approved','pagination_button.jpg','pagination_button.jpg','root/import/gallery-templates/images/pagination_button.jpg','3','7','12',NULL,0,1,0,0,0,1050,NULL,0,0,0,1284523760,NULL,0),('hIB-z34r8Xl-vYVYCkKr-w',1284523758,'3','pbversion0000000000001','approved','bar-btn-r.jpg','bar-btn-r.jpg','root/import/gallery-templates/images/bar-btn-r.jpg','3','7','12',NULL,0,1,0,0,0,830,NULL,0,0,0,1284523760,NULL,0),('-mPUoFlYcjqjPUPRLAlxNQ',1284523758,'3','pbversion0000000000001','approved','search-field-r.jpg','search-field-r.jpg','root/import/gallery-templates/images/search-field-r.jpg','3','7','12',NULL,0,1,0,0,0,848,NULL,0,0,0,1284523761,NULL,0),('MDpUOR-N8KMyt1J7Hh_h4w',1284523758,'3','pbversion0000000000001','approved','bar-btn.jpg','bar-btn.jpg','root/import/gallery-templates/images/bar-btn.jpg','3','7','12',NULL,0,1,0,0,0,708,NULL,0,0,0,1284523761,NULL,0),('YfXKByTwDZVituMc4h13Dg',1284523758,'3','pbversion0000000000001','approved','pagination_bg.jpg','pagination_bg.jpg','root/import/gallery-templates/images/pagination_bg.jpg','3','7','12',NULL,0,1,0,0,0,1131,NULL,0,0,0,1284523761,NULL,0),('esko_HSU0Gh-uJZ1h3xRmQ',1284523758,'3','pbversion0000000000001','approved','search-field-l.jpg','search-field-l.jpg','root/import/gallery-templates/images/search-field-l.jpg','3','7','12',NULL,0,1,0,0,0,874,NULL,0,0,0,1284523761,NULL,0),('oSqpGswzpBG_ErdfYwIO8A',1284523758,'3','pbversion0000000000001','approved','top_bg.jpg','top_bg.jpg','root/import/gallery-templates/images/top_bg.jpg','3','7','12',NULL,0,1,0,0,0,692,NULL,0,0,0,1284523761,NULL,0),('MXJklShZvLLB_DSnZQmXrQ',1284523758,'3','pbversion0000000000001','approved','title_bg.jpg','title_bg.jpg','root/import/gallery-templates/images/title_bg.jpg','3','7','12',NULL,0,1,0,0,0,1658,NULL,0,0,0,1284523761,NULL,0),('BthxD5oJ0idmsyI3ioA2FA',1284523758,'3','pbversion0000000000001','approved','bar-btn-l.jpg','bar-btn-l.jpg','root/import/gallery-templates/images/bar-btn-l.jpg','3','7','12',NULL,0,1,0,0,0,845,NULL,0,0,0,1284523761,NULL,0),('aZ-1HYQamkRHYXvzAra8WQ',1284523758,'3','pbversion0000000000001','approved','search-field.jpg','search-field.jpg','root/import/gallery-templates/images/search-field.jpg','3','7','12',NULL,0,1,0,0,0,750,NULL,0,0,0,1284523761,NULL,0),('eRkb94OYcS5AdcrrerOP5Q',1284523758,'3','pbversion0000000000001','approved','rss.gif','rss.gif','root/import/gallery-templates/images/rss2.gif','3','7','12',NULL,0,1,0,0,0,1391,NULL,0,0,0,1284523761,NULL,0),('TbnkjAJQEASORXIpYqDkcA',1284523758,'3','pbversion0000000000001','approved','blank-image.jpg','blank-image.jpg','root/import/gallery-templates/images/blank-image.jpg','3','7','12',NULL,0,1,0,0,0,3084,NULL,0,0,0,1284523761,NULL,0),('er-3faBjY-hhlDcc5aKqdQ',1284523758,'3','pbversion0000000000001','approved','top_bg.jpg','top_bg.jpg','root/import/gallery-templates/images/top_bg2.jpg','3','7','12',NULL,0,1,0,0,0,693,NULL,0,0,0,1284523761,NULL,0),('8bFsu2FJUqHRUiHcozcVFw',1284523758,'3','pbversion0000000000001','approved','sub-btn-l.jpg','sub-btn-l.jpg','root/import/gallery-templates/images/sub-btn-l.jpg','3','7','12',NULL,0,1,0,0,0,844,NULL,0,0,0,1284523761,NULL,0),('34Aayx5eA320D8VfhdfDBw',1284523758,'3','pbversion0000000000001','approved','sub-btn-r.jpg','sub-btn-r.jpg','root/import/gallery-templates/images/sub-btn-r.jpg','3','7','12',NULL,0,1,0,0,0,824,NULL,0,0,0,1284523761,NULL,0),('TlhKOVmWblZOsAdqmhEpeg',1284523758,'3','pbversion0000000000001','approved','sub-btn.jpg','sub-btn.jpg','root/import/gallery-templates/images/sub-btn.jpg','3','7','12',NULL,0,1,0,0,0,702,NULL,0,0,0,1284523761,NULL,0),('Nx0ypjO3cN6QdZUBUEE0lA',1284523758,'3','pbversion0000000000001','approved','pic-title-bg.jpg','pic-title-bg.jpg','root/import/gallery-templates/images/pic-title-bg.jpg','3','7','12',NULL,0,1,0,0,0,865,NULL,0,0,0,1284523761,NULL,0),('CmFZLN7iPS7XXvUEsxKPKA',1284523758,'3','pbversion0000000000001','approved','row-2.jpg','row-2.jpg','root/import/gallery-templates/images/row-2.jpg','3','7','12',NULL,0,1,0,0,0,806,NULL,0,0,0,1284523761,NULL,0),('v_XBgwwZqgW1D5s4y05qfg',1284523759,'3','pbversion0000000000001','approved','addtl-info.gif','addtl-info.gif','root/import/gallery-templates/images/addtl-info.gif','3','7','12',NULL,0,1,0,0,0,914,NULL,0,0,0,1284523761,NULL,0),('4TdAkKoQbSCvI7QWcW889A',1284523759,'3','pbversion0000000000001','approved','row-1.jpg','row-1.jpg','root/import/gallery-templates/images/row-1.jpg','3','7','12',NULL,0,1,0,0,0,791,NULL,0,0,0,1284523761,NULL,0),('SAgK6eDPCG1cgkJ59WapHQ',1284523759,'3','pbversion0000000000001','approved','prev-btn.gif','prev-btn.gif','root/import/gallery-templates/images/prev-btn.gif','3','7','12',NULL,0,1,0,0,0,2015,NULL,0,0,0,1284523761,NULL,0),('XJYLuvGy9ubF7JNKyINtpA',1284523759,'3','pbversion0000000000001','approved','play-btn.gif','play-btn.gif','root/import/gallery-templates/images/play-btn.gif','3','7','12',NULL,0,1,0,0,0,2543,NULL,0,0,0,1284523761,NULL,0),('RWj7hyv2SpZuXxwj1Wocug',1284523759,'3','pbversion0000000000001','approved','next-btn.gif','next-btn.gif','root/import/gallery-templates/images/next-btn.gif','3','7','12',NULL,0,1,0,0,0,2045,NULL,0,0,0,1284523761,NULL,0),('aq8QElnlm3YufAoxRz9Pcg',1284523759,'3','pbversion0000000000001','approved','data-bg.jpg','data-bg.jpg','root/import/gallery-templates/images/data-bg.jpg','3','7','12',NULL,0,1,0,0,0,821,NULL,0,0,0,1284523761,NULL,0),('i6-BofrJJYozovlzFBByXg',1284523759,'3','pbversion0000000000001','approved','first-photo-button.png','first-photo-button.png','root/import/gallery-templates/images/first-photo-button.png','3','7','3',NULL,0,1,0,0,0,1069,NULL,0,1,0,1284523761,NULL,0),('fU_OZCmtdFNJ8a6bMve8ng',1284523759,'3','pbversion0000000000001','approved','previous-photo-button.png','previous-photo-button.png','root/import/gallery-templates/images/previous-photo-button.png','3','7','3',NULL,0,1,0,0,0,943,NULL,0,1,0,1284523761,NULL,0),('YXCtusAxb4vzZ5sTnUA5DA',1284523759,'3','pbversion0000000000001','approved','next-photo-button.png','next-photo-button.png','root/import/gallery-templates/images/next-photo-button.png','3','7','3',NULL,0,1,0,0,0,955,NULL,0,1,0,1284523761,NULL,0),('k_xuE82wwp8gFVl9aaaG8g',1284523759,'3','pbversion0000000000001','approved','last-photo-button.png','last-photo-button.png','root/import/gallery-templates/images/last-photo-button.png','3','7','3',NULL,0,1,0,0,0,1072,NULL,0,1,0,1284523761,NULL,0),('NPM_WItpM5IzLWBhWjYfCA',1284523759,'3','pbversion0000000000001','approved','photo-navigation-spacer.png','photo-navigation-spacer.png','root/import/gallery-templates/images/photo-navigation-spacer.png','3','7','3',NULL,0,1,0,0,0,569,NULL,0,1,0,1284523761,NULL,0),('mM3bjP_iG9sv5nQb4S17tQ',1284523759,'3','pbversion0000000000001','approved','Default Gallery View Album RSS','Default Gallery View Album RSS','root/import/gallery-templates/default-gallery-album-rss','3','7','3',NULL,0,1,0,0,0,1259,NULL,0,1,0,1285733364,NULL,0),('ilu5BrM-VGaOsec9Lm7M6Q',1284523759,'3','pbversion0000000000001','approved','Default Gallery List Albums RSS','Default Gallery List Albums RSS','root/import/gallery-templates/default-gallery-list-albums-rss','3','7','3',NULL,0,1,0,0,0,1268,NULL,0,1,0,1285733364,NULL,0),('-ANLpoTEP-n4POAdRxCzRw',1284523759,'3','pbversion0000000000001','approved','Default Gallery List Files For User RSS','Default Gallery List Files For User RSS','root/import/gallery-templates/default-gallery-list-files-for-user-rss','3','7','3',NULL,0,1,0,0,0,1300,NULL,0,1,0,1285733356,NULL,0),('OxJWQgnGsgyGohP2L3zJPQ',1284523760,'3','pbversion0000000000001','approved','Default Gallery Edit Comment','Default Gallery Edit Comment','root/import/gallery-templates/default-gallery-edit-comment','3','7','3',NULL,0,1,0,0,0,5493,'<link rel=\"stylesheet\" href=\"^/(root/import/gallery-templates/gallery.css);\" type=\"text/css\" />',0,1,0,1285733358,'<link rel=\"stylesheet\" href=\"^/(root/import/gallery-templates/gallery.css);\" type=\"text/css\" />',0),('7fE8md51vTCcuJFOvxNaGA',1284523760,'3','pbversion0000000000001','approved','thumbnails.js','thumbnails.js','root/import/gallery-templates/thumbnails.js','3','7','3',NULL,0,1,0,0,0,5848,NULL,0,1,0,1285733366,NULL,0),('1oGhfj00KkCzP1ez01AfKA',1284523760,'3','pbversion0000000000001','approved','slideshow.js','slideshow.js','root/import/gallery-templates/slideshow.js','3','7','3',NULL,0,1,0,0,0,11975,NULL,0,1,0,1285733366,NULL,0),('3qiVYhNTXMVC5hfsumVHgg',1284523760,'3','pbversion0000000000001','approved','browserdetect.js','browserdetect.js','root/import/gallery-templates/browserdetect.js','3','7','3',NULL,0,1,0,0,0,4375,NULL,0,1,0,1285733366,NULL,0),('THQhn1C-ooj-TLlEP7aIJQ',1284523760,'3','pbversion0000000000001','approved','gallery-ie.css','gallery-ie.css','root/import/gallery-templates/gallery-ie.css','3','7','3',NULL,0,1,0,0,0,626,NULL,0,1,0,1285733366,NULL,0),('qxd0WpRGqDPWP8WBicYvEA',1284523760,'3','pbversion0000000000001','approved','dragdropsorting.js','dragdropsorting.js','root/import/gallery-templates/dragdropsorting.js','3','7','12',NULL,0,1,0,0,0,9518,NULL,0,1,0,1285733367,NULL,0),('HPDOcsj4gBme8D4svHodBw',1285733367,'3','pbversion0000000000001','approved','Profile','Profile','root/import/account/profile','3','7','12',NULL,0,1,0,0,0,334,NULL,0,1,0,1285733367,NULL,0),('FJbUTvZ2nUTn65LpW6gjsA',1285733367,'3','pbversion0000000000001','approved','Profile Account Layout','Profile Account Layout','root/import/account/profile/profile-account-layout','3','7','12',NULL,0,1,0,0,0,4271,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0,1,0,1285733367,'<link rel=\"stylesheet\" href=\"^/(/root/import/account/account.css);\" type=\"text/css\">',0),('75CmQgpcCSkdsL-oawdn3Q',1285733367,'3','pbversion0000000000001','approved','Default Edit Profile Template','Default Edit Profile Template','root/import/account/profile/default-edit-profile-template','3','7','12',NULL,0,1,0,0,0,3294,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script>\n\n<script type=\"text/javascript\">\nYAHOO.util.Event.onDOMReady(function() {\n    var tabView = new YAHOO.widget.TabView(\'wgAccountTabs\');\n});\n</script>',0,1,0,1285733367,'<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/element/element-min.js);\"></script><script type=\"text/javascript\" src=\"^Extras(yui/build/tabview/tabview-min.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){var a=new YAHOO.widget.TabView(\'wgAccountTabs\')});/*]]>*/</script>',0),('2CS-BErrjMmESOtGT90qOg',1285733367,'3','pbversion0000000000001','approved','Default View Profile Template','Default View Profile Template','root/import/account/profile/default-view-profile-template','3','7','12',NULL,0,1,0,0,0,7605,NULL,0,1,0,1285733367,NULL,1),('MBmWlA_YEA2I6D29OMGtRg',1285733367,'3','pbversion0000000000001','approved','Default Profile Error Template','Default Profile Error Template','root/import/account/profile/default-profile-error-template','3','7','12',NULL,0,1,0,0,0,1223,NULL,0,1,0,1285733367,NULL,0),('RrV4aAPnn4dM0ZcU3OXnlw',1286941427,'3','pbversion0000000000001','approved','style','style','root/import/style','3','7','12',NULL,0,0,0,0,0,314,NULL,0,1,0,1286941428,NULL,0),('PBtmpl0000000000000111',1286941427,'3','pbversion0000000000001','approved','Make Page Printable','Make Page Printable','make_page_printable','3','7','12',NULL,0,1,0,0,0,1791,NULL,0,1,0,1286941428,NULL,0),('A3T7jpTBKLYws1h5mJ0t8A',1286941427,'3','pbversion0000000000001','approved','makepageprintable.css','makepageprintable.css','makepageprintable.css','3','7','12',NULL,0,1,0,0,0,6259,NULL,0,1,0,1286941428,NULL,0),('CarouselTmpl0000000001',1286941427,'3','pbversion0000000000001','approved','Default Carousel','Default Carousel','root/import/carousel/carousel-default','3','7','12',NULL,0,0,0,0,0,2974,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts.css);\">\n<link type=\"text/css\" rel=\"stylesheet\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\">\n<script src=\"^Extras(yui/build/utilities/utilities.js);\"></script>\n<script src=\"^Extras(yui/build/carousel/carousel-min.js);\"></script>',0,1,0,1286941428,'<link rel=\"stylesheet\" type=\"text/css\" href=\"^Extras(yui/build/fonts/fonts.css);\"><link type=\"text/css\" rel=\"stylesheet\" href=\"^Extras(yui/build/carousel/assets/skins/sam/carousel.css);\"><script src=\"^Extras(yui/build/utilities/utilities.js);\"></script><script src=\"^Extras(yui/build/carousel/carousel-min.js);\"></script>',0),('PBtmpl0000000000000085',1288142105,'3','pbversion0000000000001','approved','Default Email','Default Email','default_email','3','7','12',NULL,0,1,0,0,0,2031,NULL,0,1,0,1288142108,NULL,0),('1z9J1O08n_7gVVlBwSRBJQ',1288142106,'3','pbversion0000000000001','approved','Auth','Auth','root/import/auth','3','7','12',NULL,0,1,0,0,0,311,NULL,0,1,0,1288142107,NULL,0),('xSmREZO3GNzK3M5PaueOOQ',1288142106,'3','pbversion0000000000001','approved','LDAP/Account','LDAP/Account','root/import/auth/ldap/account','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1288142107,NULL,0),('PBtmpl0000000000000004',1288142106,'3','pbversion0000000000001','approved','Default LDAP Account Display Template','Default LDAP Account Display Template','default_ldap_account_display_template','3','7','12',NULL,0,1,0,0,0,1372,NULL,0,1,0,1288142107,NULL,0),('0bx-xoL8TSXXubFuqKAoVQ',1288142106,'3','pbversion0000000000001','approved','LDAP/Create','LDAP/Create','root/import/auth/ldap/create','3','7','12',NULL,0,0,0,0,0,344,NULL,0,1,0,1288142107,NULL,0),('PBtmpl0000000000000005',1288142106,'3','pbversion0000000000001','approved','Default LDAP Anonymous Registration Template','Default LDAP Anonymous Registration Template','default_ldap_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,5903,'<style type=\"text/css\">\n    .submitData {\n        text-align:right;\n        border-top:solid gray 1px;\n    }\n    .authfield_required_off {\n        background-color: #FFFFFF;\n    }\n    .authfield_required {\n        background-color: #FFFFBB;\n    }\n    .authfield_error {\n        background-color: #FF9494;\n    }\n</style>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\">\n   YAHOO.util.Event.onDOMReady(function () {\n        var setFieldColor = function ( evt, obj ) {\n            var field     = obj.field;\n            var hasError  = obj.hasError;\n            var origClass = field.className;\n            YAHOO.util.Dom.removeClass(field,origClass);\n            if(field.value == \"\") {\n                var newClass  = hasError?\"authfield_error\":\"authfield_required\";\n                YAHOO.util.Dom.replaceClass(field,origClass,newClass);\n            }\n            else {\n                YAHOO.util.Dom.replaceClass(field,origClass,\"authfield_required_off\");\n            }\n        }\n\n        var rFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");\n        var eFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");\n        var oFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");\n\n        for (var i = 0; i < rFields.length; i++) {\n            YAHOO.util.Event.addListener(rFields[i],\"change\",setFieldColor, {\n                field   : rFields[i],\n                hasError: (eFields.length > 0)\n            });\n        }\n\n        for (var i = 0; i < eFields.length; i++) {\n            YAHOO.util.Event.addListener(eFields[i],\"change\",setFieldColor, {\n                field   : eFields[i],\n                hasError: (eFields.length > 0)\n            });\n        }\n\n        for (var i = 0; i < oFields.length; i++) {\n            YAHOO.util.Event.addListener(oFields[i],\"change\",setFieldColor, {\n                field   : oFields[i],\n                hasError: (oFields.length > 0)\n            });\n        }\n       \n   });\n</script>',0,1,0,1288142107,'<style type=\"text/css\">.submitData{text-align:right;border-top:solid gray 1px;}.authfield_required_off{background-color:#FFFFFF;}.authfield_required{background-color:#FFFFBB;}.authfield_error{background-color:#FF9494;}</style><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){var f=function(e,b){var i=b.field;var j=b.hasError;var a=i.className;YAHOO.util.Dom.removeClass(i,a);if(i.value==\"\"){var g=j?\"authfield_error\":\"authfield_required\";YAHOO.util.Dom.replaceClass(i,a,g)}else{YAHOO.util.Dom.replaceClass(i,a,\"authfield_required_off\")}}var h=YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");var d=YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");var k=YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");for(var c=0;c<h.length;c++){YAHOO.util.Event.addListener(h[c],\"change\",f,{field:h[c],hasError:(d.length>0)})}for(var c=0;c<d.length;c++){YAHOO.util.Event.addListener(d[c],\"change\",f,{field:d[c],hasError:(d.length>0)})}for(var c=0;c<k.length;c++){YAHOO.util.Event.addListener(k[c],\"change\",f,{field:k[c],hasError:(k.length>0)})}});/*]]>*/</script>',0),('taX2UYkFF21ALpFZY2rhMw',1288142106,'3','pbversion0000000000001','approved','LDAP/Login','LDAP/Login','root/import/auth/ldap/login','3','7','12',NULL,0,0,0,0,0,341,NULL,0,1,0,1288142107,NULL,0),('PBtmpl0000000000000006',1288142106,'3','pbversion0000000000001','approved','Default LDAP Login Template','Default LDAP Login Template','default_ldap_login_template','3','7','12',NULL,0,1,0,0,0,1974,NULL,0,1,0,1288142107,NULL,0),('K0q_N885Httqev1VCqUWxg',1288142106,'3','pbversion0000000000001','approved','WebGUI/Account','WebGUI/Account','root/import/auth/webgui/account','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1288142107,NULL,0),('PBtmpl0000000000000010',1288142106,'3','pbversion0000000000001','approved','Default WebGUI Account Display Template','Default WebGUI Account Display Template','default_webgui_account_display_template','3','7','12',NULL,0,1,0,0,0,2780,NULL,0,1,0,1288142108,NULL,0),('fq1ZkYhH24R5tb96kuT10Q',1288142106,'3','pbversion0000000000001','approved','WebGUI/Create','WebGUI/Create','root/import/auth/webgui/create','3','7','12',NULL,0,0,0,0,0,350,NULL,0,1,0,1288142108,NULL,0),('PBtmpl0000000000000011',1288142106,'3','pbversion0000000000001','approved','Default WebGUI Anonymous Registration Template','Default WebGUI Anonymous Registration Template','default_webgui_anonymous_registration_template','3','7','12',NULL,0,1,0,0,0,6676,'<style type=\"text/css\">\n    .submitData {\n        text-align:right;\n        border-top:solid gray 1px;\n    }\n    .authfield_required_off {\n        background-color: #FFFFFF;\n    }\n    .authfield_required {\n        background-color: #FFFFBB;\n    }\n    .authfield_error {\n        background-color: #FF9494;\n    }\n</style>\n<script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script>\n<script type=\"text/javascript\">\n   YAHOO.util.Event.onDOMReady(function () {\n        var setFieldColor = function ( evt, obj ) {\n            var field     = obj.field;\n            var hasError  = obj.hasError;\n            var origClass = field.className;\n            YAHOO.util.Dom.removeClass(field,origClass);\n            if(field.value == \"\") {\n                var newClass  = hasError?\"authfield_error\":\"authfield_required\";\n                YAHOO.util.Dom.replaceClass(field,origClass,newClass);\n            }\n            else {\n                YAHOO.util.Dom.replaceClass(field,origClass,\"authfield_required_off\");\n            }\n        }\n\n        var rFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");\n        var eFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");\n        var oFields = YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");\n\n        for (var i = 0; i < rFields.length; i++) {\n            YAHOO.util.Event.addListener(rFields[i],\"change\",setFieldColor, {\n                field   : rFields[i],\n                hasError: (eFields.length > 0)\n            });\n        }\n\n        for (var i = 0; i < eFields.length; i++) {\n            YAHOO.util.Event.addListener(eFields[i],\"change\",setFieldColor, {\n                field   : eFields[i],\n                hasError: (eFields.length > 0)\n            });\n        }\n\n        for (var i = 0; i < oFields.length; i++) {\n            YAHOO.util.Event.addListener(oFields[i],\"change\",setFieldColor, {\n                field   : oFields[i],\n                hasError: (oFields.length > 0)\n            });\n        }\n       \n   });\n</script>',0,1,0,1288142108,'<style type=\"text/css\">.submitData{text-align:right;border-top:solid gray 1px;}.authfield_required_off{background-color:#FFFFFF;}.authfield_required{background-color:#FFFFBB;}.authfield_error{background-color:#FF9494;}</style><script type=\"text/javascript\" src=\"^Extras(yui/build/yahoo-dom-event/yahoo-dom-event.js);\"></script><script type=\"text/javascript\">/*<![CDATA[*/YAHOO.util.Event.onDOMReady(function(){var f=function(e,b){var i=b.field;var j=b.hasError;var a=i.className;YAHOO.util.Dom.removeClass(i,a);if(i.value==\"\"){var g=j?\"authfield_error\":\"authfield_required\";YAHOO.util.Dom.replaceClass(i,a,g)}else{YAHOO.util.Dom.replaceClass(i,a,\"authfield_required_off\")}}var h=YAHOO.util.Dom.getElementsByClassName(\"authfield_required\");var d=YAHOO.util.Dom.getElementsByClassName(\"authfield_error\");var k=YAHOO.util.Dom.getElementsByClassName(\"authfield_required_off\");for(var c=0;c<h.length;c++){YAHOO.util.Event.addListener(h[c],\"change\",f,{field:h[c],hasError:(d.length>0)})}for(var c=0;c<d.length;c++){YAHOO.util.Event.addListener(d[c],\"change\",f,{field:d[c],hasError:(d.length>0)})}for(var c=0;c<k.length;c++){YAHOO.util.Event.addListener(k[c],\"change\",f,{field:k[c],hasError:(k.length>0)})}});/*]]>*/</script>',0),('PBtmpl0000000000000015',1288142106,'3','pbversion0000000000001','approved','Default WebGUI Welcome Message Template','Default WebGUI Welcome Message Template','root/import/auth/webgui/create/default-webgui-welcome-message-template','3','7','12',NULL,0,1,0,0,0,698,NULL,0,1,0,1288142108,NULL,0),('PBtmpl0000000000000016',1288142106,'3','pbversion0000000000001','approved','Default WebGUI Account Activation Template','Default WebGUI Account Activation Template','root/import/auth/webgui/create/default-webgui-account-activation-template','3','7','3',NULL,0,1,0,0,0,602,NULL,0,1,0,1288142108,NULL,0),('oHk7fAFhEEkB7dHzi0QOQA',1288142106,'3','pbversion0000000000001','approved','WebGUI/Expired','WebGUI/Expired','root/import/auth/webgui/expired','3','7','12',NULL,0,0,0,0,0,353,NULL,0,1,0,1288142108,NULL,0),('PBtmpl0000000000000012',1288142106,'3','pbversion0000000000001','approved','Default WebGUI Password Reset Template','Default WebGUI Password Reset Template','default_webgui_password_reset_template','3','7','12',NULL,0,1,0,0,0,2095,NULL,0,1,0,1288142108,NULL,0),('9M-lrlPQWeeNWfvnDnK_Xg',1288142106,'3','pbversion0000000000001','approved','WebGUI/Login','WebGUI/Login','root/import/auth/webgui/login','3','7','12',NULL,0,0,0,0,0,347,NULL,0,1,0,1288142108,NULL,0),('PBtmpl0000000000000013',1288142106,'3','pbversion0000000000001','approved','Default WebGUI Login Template','Default WebGUI Login Template','default_webgui_login_template','3','7','12',NULL,0,1,0,0,0,2262,NULL,0,1,0,1288142108,NULL,0),('_gBYAdTcbkiyamnqi2Xskg',1288142106,'3','pbversion0000000000001','approved','WebGUI/Recovery','WebGUI/Recovery','root/import/auth/webgui/recovery','3','7','12',NULL,0,0,0,0,0,356,NULL,0,1,0,1288142108,NULL,0),('PBtmpl0000000000000014',1288142106,'3','pbversion0000000000001','approved','Default WebGUI Password Recovery Template','Default WebGUI Password Recovery Template','default_webgui_password_recovery_template','3','7','12',NULL,0,1,0,0,0,3073,NULL,0,1,0,1288142108,NULL,0),('0iMMbGN3BevuCBHjjLiQNA',1288142106,'3','pbversion0000000000001','approved','WebGUI/Deactivate','WebGUI/Deactivate','root/import/auth/webgui/deactivate','3','7','12',NULL,0,1,0,0,0,361,NULL,0,1,0,1288142108,NULL,0),('zaHUYsE_PgKk8hnVd8ffEQ',1288142107,'3','pbversion0000000000001','approved','WebGUI Deactivate Account Template','WebGUI Deactivate Account Template','default_webgui_deactivate_account_template','3','7','12',NULL,0,1,0,0,0,859,NULL,0,1,0,1288142108,NULL,0),('6A4yIjWwJfIE0Ep-I0jutg',1288142107,'3','pbversion0000000000001','approved','LDAP/Deactivate','LDAP/Deactivate','root/import/auth/ldap/deactivate','3','7','12',NULL,0,1,0,0,0,355,NULL,0,1,0,1288142108,NULL,0),('_P4PMiraGsLTfOjK4fYQPQ',1288142107,'3','pbversion0000000000001','approved','LDAP Deactivate Account Template','LDAP Deactivate Account Template','default_ldap_deactivate_account_template','3','7','12',NULL,0,1,0,0,0,851,NULL,0,1,0,1288142108,NULL,0),('sK_0zVw4kwdJ1sqREIsSzA',1288142107,'3','pbversion0000000000001','approved','WebGUI Auth Password Recovery Email Template','Password Recovery Email','root/import/auth/webgui/recoveryemail','3','7','4',NULL,0,0,0,0,0,769,NULL,0,1,0,1288142108,NULL,0),('qsG6B24a0SC5KrhQjmdZBw',1288142107,'3','pbversion0000000000001','approved','survey.css','survey.css','survey.css','3','7','12',NULL,0,1,0,0,0,5092,NULL,0,1,0,1288142108,NULL,0),('kwTL1SWCk0GlpiJ5zAAEPQ',1288142107,'3','pbversion0000000000001','approved','surveyedit.css','surveyedit.css','root/import/survey/surveyedit.css','3','7','12',NULL,0,1,0,0,0,4986,NULL,0,1,0,1288142108,NULL,0),('_cD6DLM_Fs5IlrLeWUjrjg',1288142107,'3','pbversion0000000000001','approved','Workflow Activity Templates','Workflow Activity Templates','root/import/workflow-activity-templates','3','7','12',NULL,0,1,0,0,0,434,NULL,0,1,0,1288142108,NULL,0),('lYhMheuuLROK_iNjaQuPKg',1288142107,'3','pbversion0000000000001','approved','Notify About Version Tag','Notify About Version Tag','root/import/workflow-activity-templates/notify-about-version-tag','3','7','12',NULL,0,1,0,0,0,502,NULL,0,1,0,1288142108,NULL,0),('aNmgn0cd6tldmC1FpW4KbA',1289360562,'3','pbversion0000000000001','approved','Shop','Shop','shopping-cart-collateral-items','3','7','3',NULL,0,1,0,0,0,324,NULL,0,0,0,1289360563,NULL,0),('2q5fxatSFLgIhXaUX-oSvg',1289360562,'3','pbversion0000000000001','approved','bottom-left.jpg','bottom-left.jpg','shopping-cart-collateral-items/bottom-left.jpg','3','7','3',NULL,0,1,0,0,0,32254,NULL,0,0,0,1289360563,NULL,0),('_d5WTkKjnwct-_Dk7gZHvQ',1289360562,'3','pbversion0000000000001','approved','bottom-right.jpg','bottom-right.jpg','shopping-cart-collateral-items/bottom-right.jpg','3','7','3',NULL,0,1,0,0,0,32258,NULL,0,0,0,1289360563,NULL,0),('Iz2mUR3jCPKyemwAea4b2g',1289360562,'3','pbversion0000000000001','approved','input_bg.jpg','input_bg.jpg','shopping-cart-collateral-items/input_bg.jpg','3','7','3',NULL,0,1,0,0,0,30076,NULL,0,0,0,1289360563,NULL,0),('JU9bjsLRoWj7GVHs__prig',1289360562,'3','pbversion0000000000001','approved','top-left.jpg','top-left.jpg','shopping-cart-collateral-items/top-left.jpg','3','7','3',NULL,0,1,0,0,0,32207,NULL,0,0,0,1289360563,NULL,0),('noOlnjQGexHg8c4bGVUo9g',1289360562,'3','pbversion0000000000001','approved','top-right.jpg','top-right.jpg','shopping-cart-collateral-items/top-right.jpg','3','7','3',NULL,0,1,0,0,0,32245,NULL,0,0,0,1289360563,NULL,0),('aIpCmr9Hi__vgdZnDTz1jw',1289360562,'3','pbversion0000000000001','approved','Cart (Default)','Cart (Default)','default-shopping-cart-template','3','7','3',NULL,0,1,0,0,0,24479,'    <style type=\"text/css\">\n            #shoppingCart {\n                font-family:arial;\n                font-size:12px;\n            }\n\n            #shoppingCart tr.header td {\n                font-weight:bold;\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #shoppingCart tr.data td {\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #updateCartButton {\n                color: white;\n                background-color: blue;                    \n            }\n            #checkoutButton {\n                color: white;\n                background-color: green;                    \n            }\n            #continueShoppingButton {\n                color: black;\n                background-color: GreenYellow;                    \n            }\n            #shoppingCart tr.alt td {\n                background-color:#F0F0F0;\n            }\n            #shoppingCart tr.alt td.delete {\n                padding-left:10px;\n                -moz-border-radius-topLeft:10px;\n                -moz-border-radius-bottomLeft:10px;\n                border-top-left-radius:10px;\n                border-bottom-left-radius:10px;\n            }\n            #shoppingCart tr.alt td.shipping {\n                padding-right:10px;\n                -moz-border-radius-topRight:10px;\n                -moz-border-radius-bottomRight:10px;\n                border-top-right-radius:10px;\n                border-bottom-right-radius:10px;\n            }\n            #shoppingCart tr.topLine td {\n                margin-top:10px;\n                border-top:solid silver 1px;\n            }\n            #shoppingCart tr.summary td {\n                background-color: #f3f3f3;\n                padding:5px 10px 5px 10px;\n            }\n            #shoppingCart .summary .empty {\n                background-color: transparent;\n                border-style:none;\n            }\n            #shoppingCart .summary .topLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\n            }\n            #shoppingCart .summary .topRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\n            }\n            #shoppingCart .summary .bottomLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\n            }\n            #shoppingCart .summary .bottomRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\n            }\n            #shoppingCart .summary select {\n                padding-right:0px;\n                text-align:left;\n            }\n            #shoppingCart tr.bottomLine td {\n                border-bottom: solid 1px silver;\n            }\n            #shoppingCart tr.topLine td {\n                border-top: solid 1px #fff;\n            }\n\n            #shippingAddress td, #billingAddress td {\n                padding:1px 1px 1px 1px;\n            }\n        </style>',0,1,0,1289360563,'<style type=\"text/css\">#shoppingCart{font-family:arial;font-size:12px;}#shoppingCart tr.header td{font-weight:bold;text-align:right;padding:3px 5px;}#shoppingCart tr.data td{text-align:right;padding:3px 5px;}#updateCartButton{color:white;background-color:blue;}#checkoutButton{color:white;background-color:green;}#continueShoppingButton{color:black;background-color:GreenYellow;}#shoppingCart tr.alt td{background-color:#F0F0F0;}#shoppingCart tr.alt td.delete{padding-left:10px;-moz-border-radius-topLeft:10px;-moz-border-radius-bottomLeft:10px;border-top-left-radius:10px;border-bottom-left-radius:10px;}#shoppingCart tr.alt td.shipping{padding-right:10px;-moz-border-radius-topRight:10px;-moz-border-radius-bottomRight:10px;border-top-right-radius:10px;border-bottom-right-radius:10px;}#shoppingCart tr.topLine td{margin-top:10px;border-top:solid silver 1px;}#shoppingCart tr.summary td{background-color:#f3f3f3;padding:5px 10px 5px 10px;}#shoppingCart .summary .empty{background-color:transparent;border-style:none;}#shoppingCart .summary .topLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;}#shoppingCart .summary .topRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;}#shoppingCart .summary .bottomLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;}#shoppingCart .summary .bottomRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;}#shoppingCart .summary select{padding-right:0px;text-align:left;}#shoppingCart tr.bottomLine td{border-bottom:solid 1px silver;}#shoppingCart tr.topLine td{border-top:solid 1px #fff;}#shippingAddress td,#billingAddress td{padding:1px 1px 1px 1px;}</style>',0),('XNd7a_g_cTvJVYrVHcx2Mw',1289360562,'3','pbversion0000000000001','approved','Address (Default)','Address (Default)','shopping-cart-collateral-items/address-default','3','7','3',NULL,0,1,0,0,0,5883,'<style type=\"text/css\">\r\n	.wgAddress h2.title {\r\n		background: black;\r\n		padding:5px;\r\n		padding-left:15px;\r\n		line-height:32px;\r\n		color:white;\r\n		margin:0px;\r\n		height:32px;\r\n	}\r\n	.wgAddress table {\r\n		margin-top:15px;\r\n	}\r\n\r\n	.wgAddress .label {\r\n		background:#000;\r\n		color:white;\r\n		font-weight:bold;\r\n		padding-left:5px;\r\n	}\r\n	.wgAddress input, .wgAddress select {\r\n		border:solid #555 1px;\r\n	}\r\n\r\n        .copyFromProfileButtons form, .copyFromProfileButtons div {\r\n                display : inline;\r\n        }\r\n\r\n</style>\r\n',0,1,0,1289360564,'<style type=\"text/css\">.wgAddress h2.title{background:black;padding:5px;padding-left:15px;line-height:32px;color:white;margin:0px;height:32px;}.wgAddress table{margin-top:15px;}.wgAddress .label{background:#000;color:white;font-weight:bold;padding-left:5px;}.wgAddress input,.wgAddress select{border:solid #555 1px;}.copyFromProfileButtons form,.copyFromProfileButtons div{display:inline;}</style>',0),('2gtFt7c0qAFNU3BG_uvNvg',1289360562,'3','pbversion0000000000001','approved','My Purchases (Default)','My Purchases (Default)','shopping-cart-collateral-items/my-purchases-default','3','7','3',NULL,0,1,0,0,0,3213,'<style type=\"text/css\">\n	.wgPurchase h3.title {\n		margin-bottom:0px;\n	}\n	.wgPurchase .transactionItems {\n		clear:both;\n		width:98%;\n		margin-top:15px;\n	}\n	.wgPurchase .transactionItems th {\n		background-color:#E0E0E0;\n		padding:3px;\n		text-align:left;\n		border-left:solid #AAAAAA 1px;\n		border-right:solid #f1f1f1 1px;\n	}\n	.wgPurchase .transactionItems th:first-child {\n		-moz-border-radius-topLeft: 15px;\n		border-left-style:none;\n	}\n	.wgPurchase .transactionItems th:last-child {\n		-moz-border-radius-topRight: 15px;\n		border-right-style:none;\n	}\n	.wgPurchase .transactionItems td {\n		background-color:#F1F1F1;\n		border-bottom:solid #E0E0E0 1PX;\n		border-top:solid #fff 1px;\n		border-left:solid #e0e0e0 1px;\n		border-right:solid white 1px;\n		padding:3px;		\n	}\n</style>\n',0,1,0,1289360564,'<style type=\"text/css\">.wgPurchase h3.title{margin-bottom:0px;}.wgPurchase .transactionItems{clear:both;width:98%;margin-top:15px;}.wgPurchase .transactionItems th{background-color:#E0E0E0;padding:3px;text-align:left;border-left:solid #AAAAAA 1px;border-right:solid #f1f1f1 1px;}.wgPurchase .transactionItems th:first-child{-moz-border-radius-topLeft:15px;border-left-style:none;}.wgPurchase .transactionItems th:last-child{-moz-border-radius-topRight:15px;border-right-style:none;}.wgPurchase .transactionItems td{background-color:#F1F1F1;border-bottom:solid #E0E0E0 1PX;border-top:solid #fff 1px;border-left:solid #e0e0e0 1px;border-right:solid white 1px;padding:3px;}</style>',0),('bPz1yk6Y9uwMDMBcmMsSCg',1289360562,'3','pbversion0000000000001','approved','Email Receipt (Default)','Email Receipt (Default)','shopping-cart-collateral-items/email-receipt-default','3','7','3',NULL,0,1,0,0,0,4694,NULL,0,1,0,1289360564,NULL,0),('vrKXEtluIhbmAS9xmPukDA',1289360562,'3','pbversion0000000000001','approved','Donation (Default)','Donation (Default)','root/import/default-donation-template','3','7','12',NULL,0,1,0,0,0,2504,'<style type=\"text/css\">\r\n	.wgDonation h3.title {\r\n		background: #000;\r\n		height:42px;\r\n		color:white;\r\n		font-size:18px;\r\n		font-weight:bold;\r\n		letter-spacing:1px;			\r\n		line-height:42px;\r\n		padding-left:15px;\r\n		margin-bottom:0px;\r\n	}\r\n	.wgDonation .cart {\r\n		margin:15px 0px 15px 25px;\r\n	}\r\n	.wgDonation #price_formId {\r\n		background-color:white;\r\n		border:solid black 1px;\r\n	}\r\n</style>\r\n',0,0,0,1289360564,'<style type=\"text/css\">.wgDonation h3.title{background:#000;height:42px;color:white;font-size:18px;font-weight:bold;letter-spacing:1px;line-height:42px;padding-left:15px;margin-bottom:0px;}.wgDonation .cart{margin:15px 0px 15px 25px;}.wgDonation #price_formId{background-color:white;border:solid black 1px;}</style>',0),('63ix2-hU0FchXGIWkG3tow',1289360562,'3','pbversion0000000000001','approved','Flat Discount (Default)','Flat Discount (Default)','root/import/flat-discount-default','3','7','12',NULL,0,1,0,0,0,1278,NULL,0,1,0,1289360564,NULL,0),('eqb9sWjFEVq0yHunGV8IGw',1289360562,'3','pbversion0000000000001','approved','Subscription (Default)','Subscription (Default)','root/import/subscription-default','3','7','12',NULL,0,1,0,0,0,2872,'<style type=\"text/css\">\r\n	.wgSubscription {\r\n\r\n	}\r\n	.wgSubscription .controls {\r\n		background-color:black;\r\n		padding:3px 10px;\r\n		color:white;\r\n		margin:5px 0px;\r\n	}\r\n	.wgSubscription h3.title {\r\n		margin-bottom:3px;\r\n	}\r\n	.wgSubscription .description * {\r\n		margin-top:0px;\r\n	}\r\n	.wgSubscription .controls a {\r\n		color:white;\r\n	}\r\n	.wgSubscription .smaller {\r\n		font-size:10px;\r\n		margin-bottom:10px;\r\n	}\r\n</style>\n',0,1,0,1289360564,'<style type=\"text/css\">.wgSubscription{}.wgSubscription .controls{background-color:black;padding:3px 10px;color:white;margin:5px 0px;}.wgSubscription h3.title{margin-bottom:3px;}.wgSubscription .description *{margin-top:0px;}.wgSubscription .controls a{color:white;}.wgSubscription .smaller{font-size:10px;margin-bottom:10px;}</style>',0),('3womoo7Teyy2YKFa25-MZg',1289360562,'3','pbversion0000000000001','approved','Address Book (Default)','Address Book (Default)','shopping-cart-collateral-items/address-book-default','3','7','3',NULL,0,1,0,0,0,3132,'<style>\n	.wgAddressBook .item {\n		float:left;\n		margin:15px;\n		width:210px;\n		background-color:white;\n		border:solid black 1px;\n	}\n	.wgAddressBook .default {\n		border:double black 3px;\n	}\n	.wgAddressBook .use input {\n		width:210px;\n		background-color:green;\n		font-size:10px;\n		cursor:pointer;\n		border:gray outset 2px;\n		font-weight:bold;\n		margin-bottom:10px;\n		color:white;\n	}\n	.wgAddressBook .label {\n		text-align:center;\n		font-size:15px;\n		font-weight:bold;\n	}\n	.wgAddressBook .address {\n		padding:5px;\n		margin-bottom:15px;\n	}\n	.wgAddressBook .delete input,\n	.wgAddressBook .edit input {\n		float:left;\n		width:70px;\n		font-size:10px;\n		border:gray outset 1px;\n		background-color:white;\n		cursor:pointer;\n	}\n	.wgAddressBook .delete input {\n		color:red;\n	}\n	.wgAddressBook * input:hover {\n		background-color:#FFFFEC;\n	}\n	.wgAddressBook .use input:hover {\n		background-color:#00AA00;\n        color:black\n	}\n</style>\n',0,1,0,1289360564,'<style>\n	.wgAddressBook .item {\n		float:left;\n		margin:15px;\n		width:210px;\n		background-color:white;\n		border:solid black 1px;\n	}\n	.wgAddressBook .default {\n		border:double black 3px;\n	}\n	.wgAddressBook .use input {\n		width:210px;\n		background-color:green;\n		font-size:10px;\n		cursor:pointer;\n		border:gray outset 2px;\n		font-weight:bold;\n		margin-bottom:10px;\n		color:white;\n	}\n	.wgAddressBook .label {\n		text-align:center;\n		font-size:15px;\n		font-weight:bold;\n	}\n	.wgAddressBook .address {\n		padding:5px;\n		margin-bottom:15px;\n	}\n	.wgAddressBook .delete input,\n	.wgAddressBook .edit input {\n		float:left;\n		width:70px;\n		font-size:10px;\n		border:gray outset 1px;\n		background-color:white;\n		cursor:pointer;\n	}\n	.wgAddressBook .delete input {\n		color:red;\n	}\n	.wgAddressBook * input:hover {\n		background-color:#FFFFEC;\n	}\n	.wgAddressBook .use input:hover {\n		background-color:#00AA00;\n        color:black\n	}\n</style>',0),('EBlxJpZQ9o-8VBOaGQbChA',1289360562,'3','pbversion0000000000001','approved','MiniCart','MiniCart','shopping-cart-collateral-items/minicart','3','7','3',NULL,0,1,0,0,0,2622,'<style>\r\n	.wgMiniCart * a:link,\r\n	.wgMiniCart * a:visited {\r\n		color:black;\r\n	}\r\n	.wgMiniCart{\r\n		background:#f1f1f1;\r\n		border:solid #e0e0e0 1px;\r\n		-moz-border-radius:15px;\r\n	}\r\n	.wgMiniCart h2.title {\r\n		background-color:#e0e0e0;\r\n		margin:0px;\r\n		-moz-border-radius-topLeft:15px;\r\n		-moz-border-radius-topRight:15px;\r\n		padding:3px;\r\n		border-bottom:solid white 1px;\r\n	}\r\n	.wgMiniCart .items {\r\n		border-top:solid #e0e0e0 1px;\r\n	}\r\n	.wgMiniCart .item {\r\n		border-bottom:solid #e0e0e0 1px;\r\n		border-top:solid #fff 1px;\r\n		padding:3px 0px 3px 15px;\r\n	}\r\n	.wgMiniCart .total {\r\n		padding:3px 0px 3px 15px;\r\n		border-top:solid white 1px;\r\n	}\r\n	.wgMiniCart .cart {\r\n		background-color:white;\r\n		-moz-border-radius-bottomLeft:15px;\r\n		-moz-border-radius-bottomRight:15px;\r\n		padding:3px;\r\n		margin-top:10px;\r\n	}\r\n</style>',0,1,0,1289360564,'<style>\r\n	.wgMiniCart * a:link,\r\n	.wgMiniCart * a:visited {\r\n		color:black;\r\n	}\r\n	.wgMiniCart{\r\n		background:#f1f1f1;\r\n		border:solid #e0e0e0 1px;\r\n		-moz-border-radius:15px;\r\n	}\r\n	.wgMiniCart h2.title {\r\n		background-color:#e0e0e0;\r\n		margin:0px;\r\n		-moz-border-radius-topLeft:15px;\r\n		-moz-border-radius-topRight:15px;\r\n		padding:3px;\r\n		border-bottom:solid white 1px;\r\n	}\r\n	.wgMiniCart .items {\r\n		border-top:solid #e0e0e0 1px;\r\n	}\r\n	.wgMiniCart .item {\r\n		border-bottom:solid #e0e0e0 1px;\r\n		border-top:solid #fff 1px;\r\n		padding:3px 0px 3px 15px;\r\n	}\r\n	.wgMiniCart .total {\r\n		padding:3px 0px 3px 15px;\r\n		border-top:solid white 1px;\r\n	}\r\n	.wgMiniCart .cart {\r\n		background-color:white;\r\n		-moz-border-radius-bottomLeft:15px;\r\n		-moz-border-radius-bottomRight:15px;\r\n		padding:3px;\r\n		margin-top:10px;\r\n	}\r\n</style>',0),('g8W53Pd71uHB9pxaXhWf_A',1289360563,'3','pbversion0000000000001','approved','My Purchases Detail (Default)','My Purchases Detail (Default)','shopping-cart-collateral-items/my-purchases-detail-default','3','7','3',NULL,0,1,0,0,0,8303,'<style type=\"text/css\">\n	.wgPurchase {\n\n	}\n\n    .wgPurchase .endOfList {\n        clear: left;\n    }\n\n	.wgPurchase h3.title {\n		font-size:14px;\n		background-color:black;\n		color:white;\n		padding:3px;\n	}\n\n	.wgPurchase ul.dataList,\n	.wgPurchase ul.dataList li {\n		margin:0px;\n		padding:0px;\n		list-style-type:none;\n		font-size:10px;\n	}\n	.wgPurchase ul.dataList li {\n		background-color:#F1F1F1;\n		margin:6px;\n		line-height:20px;\n	}\n	.wgPurchase ul.dataList span {\n		background-color:#E0E0E0;\n		font-weight:bold;\n		width:200px;\n		display:block;\n		float:left;\n		margin-right:5px;\n		padding-right:5px;\n		text-align:right;\n		border-right:solid white 1px;\n	}\n	.wgPurchase .address {\n		float:left;\n		margin:6px;\n	}\n	.wgPurchase .address {\n		background-color:#f1f1f1;\n		-moz-border-radius:15px;\n		width:48%;\n	}\n	.wgPurchase .address div:first-child {\n		font-weight:bold;\n		background-color:#E0E0E0;\n		-moz-border-radius-topLeft:15px;\n		-moz-border-radius-topRight:15px;\n		padding:5px;\n	}\n	.wgPurchase .address div:last-child {\n		padding:10px;\n	}\n\n	.wgPurchase .transactionItems {\n		clear:both;\n		width:98%;\n		margin-top:15px;\n	}\n	.wgPurchase .transactionItems th {\n		background-color:#E0E0E0;\n		padding:3px;\n		text-align:left;\n		border-left:solid #AAAAAA 1px;\n		border-right:solid #f1f1f1 1px;\n	}\n	.wgPurchase .transactionItems th:first-child {\n		-moz-border-radius-topLeft: 15px;\n		border-left-style:none;\n	}\n	.wgPurchase .transactionItems th:last-child {\n		-moz-border-radius-topRight: 15px;\n		border-right-style:none;\n	}\n	.wgPurchase .transactionItems td {\n		background-color:#F1F1F1;\n		border-bottom:solid #E0E0E0 1PX;\n		border-top:solid #fff 1px;\n		border-left:solid #e0e0e0 1px;\n		border-right:solid white 1px;\n		padding:3px;		\n	}\n</style>\n',0,1,0,1289360564,'<style type=\"text/css\">.wgPurchase{}.wgPurchase .endOfList{clear:left;}.wgPurchase h3.title{font-size:14px;background-color:black;color:white;padding:3px;}.wgPurchase ul.dataList,.wgPurchase ul.dataList li{margin:0px;padding:0px;list-style-type:none;font-size:10px;}.wgPurchase ul.dataList li{background-color:#F1F1F1;margin:6px;line-height:20px;}.wgPurchase ul.dataList span{background-color:#E0E0E0;font-weight:bold;width:200px;display:block;float:left;margin-right:5px;padding-right:5px;text-align:right;border-right:solid white 1px;}.wgPurchase .address{float:left;margin:6px;}.wgPurchase .address{background-color:#f1f1f1;-moz-border-radius:15px;width:48%;}.wgPurchase .address div:first-child{font-weight:bold;background-color:#E0E0E0;-moz-border-radius-topLeft:15px;-moz-border-radius-topRight:15px;padding:5px;}.wgPurchase .address div:last-child{padding:10px;}.wgPurchase .transactionItems{clear:both;width:98%;margin-top:15px;}.wgPurchase .transactionItems th{background-color:#E0E0E0;padding:3px;text-align:left;border-left:solid #AAAAAA 1px;border-right:solid #f1f1f1 1px;}.wgPurchase .transactionItems th:first-child{-moz-border-radius-topLeft:15px;border-left-style:none;}.wgPurchase .transactionItems th:last-child{-moz-border-radius-topRight:15px;border-right-style:none;}.wgPurchase .transactionItems td{background-color:#F1F1F1;border-bottom:solid #E0E0E0 1PX;border-top:solid #fff 1px;border-left:solid #e0e0e0 1px;border-right:solid white 1px;padding:3px;}</style>',0),('jEz8iTGNWEt2I05IhVV19Q',1289360563,'3','pbversion0000000000001','approved','Operation/RedeemSubscription','Operation/RedeemSubscription','root/import/operation/redeemsubscription','3','7','12',NULL,0,0,0,0,0,390,NULL,0,1,0,1289360564,NULL,0),('PBtmpl0000000000000053',1289360563,'3','pbversion0000000000001','approved','Subscription code redemption','Subscription code redemption','subscription_code_redemption','3','7','12',NULL,0,1,0,0,0,579,NULL,0,1,0,1289360564,NULL,0),('itransact_credentials1',1289360563,'3','pbversion0000000000001','approved','ITransact Credentials (Default)','ITransact Credentials (Default)','shopping-cart-collateral-items/itransact-credentials','3','7','4',NULL,0,0,0,0,0,11072,'    <style type=\"text/css\">\n            #shoppingCart {\n                font-family:arial;\n                font-size:12px;\n            }\n\n            #shoppingCart tr.header td {\n                font-weight:bold;\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #shoppingCart tr.data td {\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #chooseAddressButton, #checkoutButton {\n                color: white;\n                background-color: green;                    \n            }\n            #shoppingCart tr.alt td {\n                background-color:#F0F0F0;\n            }\n            #shoppingCart tr.alt td.delete {\n                padding-left:10px;\n                -moz-border-radius-topLeft:10px;\n                -moz-border-radius-bottomLeft:10px;\n                border-top-left-radius:10px;\n                border-bottom-left-radius:10px;\n            }\n            #shoppingCart tr.alt td.shipping {\n                padding-right:10px;\n                -moz-border-radius-topRight:10px;\n                -moz-border-radius-bottomRight:10px;\n                border-top-right-radius:10px;\n                border-bottom-right-radius:10px;\n            }\n            #shoppingCart tr.topLine td {\n                margin-top:10px;\n                border-top:solid silver 1px;\n            }\n            #shoppingCart tr.summary td {\n                background-color: #f3f3f3;\n                padding:5px 10px 5px 10px;\n            }\n            #shoppingCart .summary .empty {\n                background-color: transparent;\n                border-style:none;\n            }\n            #shoppingCart .summary .topLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\n            }\n            #shoppingCart .summary .topRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\n            }\n            #shoppingCart .summary .bottomLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\n            }\n            #shoppingCart .summary .bottomRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\n            }\n            #shoppingCart .summary select {\n                padding-right:0px;\n                text-align:left;\n            }\n            #shoppingCart tr.bottomLine td {\n                border-bottom: solid 1px silver;\n            }\n            #shoppingCart tr.topLine td {\n                border-top: solid 1px #fff;\n            }\n\n            #shippingAddress td, #billingAddress td {\n                padding:1px 1px 1px 1px;\n            }\n        </style>\n\n<style type=\"text/css\">\n	.wgAddress h2.title {\n		background: black;\n		padding:5px;\n		padding-left:15px;\n		line-height:32px;\n		color:white;\n		margin:0px;\n		height:32px;\n	}\n	.wgAddress table {\n		margin-top:15px;\n	}\n\n	.wgAddress .label {\n		background:#000;\n		color:white;\n		font-weight:bold;\n		padding-left:5px;\n	}\n	.wgAddress input, .wgAddress select {\n		border:solid #555 1px;\n	}\n</style>\n',0,1,0,1289360564,'<style type=\"text/css\">#shoppingCart{font-family:arial;font-size:12px;}#shoppingCart tr.header td{font-weight:bold;text-align:right;padding:3px 5px;}#shoppingCart tr.data td{text-align:right;padding:3px 5px;}#chooseAddressButton,#checkoutButton{color:white;background-color:green;}#shoppingCart tr.alt td{background-color:#F0F0F0;}#shoppingCart tr.alt td.delete{padding-left:10px;-moz-border-radius-topLeft:10px;-moz-border-radius-bottomLeft:10px;border-top-left-radius:10px;border-bottom-left-radius:10px;}#shoppingCart tr.alt td.shipping{padding-right:10px;-moz-border-radius-topRight:10px;-moz-border-radius-bottomRight:10px;border-top-right-radius:10px;border-bottom-right-radius:10px;}#shoppingCart tr.topLine td{margin-top:10px;border-top:solid silver 1px;}#shoppingCart tr.summary td{background-color:#f3f3f3;padding:5px 10px 5px 10px;}#shoppingCart .summary .empty{background-color:transparent;border-style:none;}#shoppingCart .summary .topLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;}#shoppingCart .summary .topRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;}#shoppingCart .summary .bottomLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;}#shoppingCart .summary .bottomRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;}#shoppingCart .summary select{padding-right:0px;text-align:left;}#shoppingCart tr.bottomLine td{border-bottom:solid 1px silver;}#shoppingCart tr.topLine td{border-top:solid 1px #fff;}#shippingAddress td,#billingAddress td{padding:1px 1px 1px 1px;}</style><style type=\"text/css\">.wgAddress h2.title{background:black;padding:5px;padding-left:15px;line-height:32px;color:white;margin:0px;height:32px;}.wgAddress table{margin-top:15px;}.wgAddress .label{background:#000;color:white;font-weight:bold;padding-left:5px;}.wgAddress input,.wgAddress select{border:solid #555 1px;}</style>',0),('D6cJpRcey35aSkh9Q_FPUQ',1289360563,'3','pbversion0000000000001','approved','Default EU User Screen','Default EU User Screen','root/import/default-eu-user-screen','3','7','12',NULL,0,1,0,0,0,1632,NULL,0,1,0,1289360564,NULL,0),('30h5rHxzE_Q0CyI3Gg7EJw',1289360563,'3','pbversion0000000000001','approved','Cash Summary Screen (Default)','Cash Summary Screen (Default)','shopping-cart-collateral-items/cash-summary','3','7','4',NULL,0,0,0,0,0,8671,'    <style type=\"text/css\">\n            #shoppingCart {\n                font-family:arial;\n                font-size:12px;\n            }\n\n            #shoppingCart tr.header td {\n                font-weight:bold;\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #shoppingCart tr.data td {\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #chooseAddressButton, #checkoutButton {\n                color: white;\n                background-color: green;                    \n            }\n            #shoppingCart tr.alt td {\n                background-color:#F0F0F0;\n            }\n            #shoppingCart tr.alt td.delete {\n                padding-left:10px;\n                -moz-border-radius-topLeft:10px;\n                -moz-border-radius-bottomLeft:10px;\n                border-top-left-radius:10px;\n                border-bottom-left-radius:10px;\n            }\n            #shoppingCart tr.alt td.shipping {\n                padding-right:10px;\n                -moz-border-radius-topRight:10px;\n                -moz-border-radius-bottomRight:10px;\n                border-top-right-radius:10px;\n                border-bottom-right-radius:10px;\n            }\n            #shoppingCart tr.topLine td {\n                margin-top:10px;\n                border-top:solid silver 1px;\n            }\n            #shoppingCart tr.summary td {\n                background-color: #f3f3f3;\n                padding:5px 10px 5px 10px;\n            }\n            #shoppingCart .summary .empty {\n                background-color: transparent;\n                border-style:none;\n            }\n            #shoppingCart .summary .topLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\n            }\n            #shoppingCart .summary .topRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\n            }\n            #shoppingCart .summary .bottomLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\n            }\n            #shoppingCart .summary .bottomRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\n            }\n            #shoppingCart .summary select {\n                padding-right:0px;\n                text-align:left;\n            }\n            #shoppingCart tr.bottomLine td {\n                border-bottom: solid 1px silver;\n            }\n            #shoppingCart tr.topLine td {\n                border-top: solid 1px #fff;\n            }\n\n            #shippingAddress td, #billingAddress td {\n                padding:1px 1px 1px 1px;\n            }\n        </style>\n',0,1,0,1289360564,'<style type=\"text/css\">#shoppingCart{font-family:arial;font-size:12px;}#shoppingCart tr.header td{font-weight:bold;text-align:right;padding:3px 5px;}#shoppingCart tr.data td{text-align:right;padding:3px 5px;}#chooseAddressButton,#checkoutButton{color:white;background-color:green;}#shoppingCart tr.alt td{background-color:#F0F0F0;}#shoppingCart tr.alt td.delete{padding-left:10px;-moz-border-radius-topLeft:10px;-moz-border-radius-bottomLeft:10px;border-top-left-radius:10px;border-bottom-left-radius:10px;}#shoppingCart tr.alt td.shipping{padding-right:10px;-moz-border-radius-topRight:10px;-moz-border-radius-bottomRight:10px;border-top-right-radius:10px;border-bottom-right-radius:10px;}#shoppingCart tr.topLine td{margin-top:10px;border-top:solid silver 1px;}#shoppingCart tr.summary td{background-color:#f3f3f3;padding:5px 10px 5px 10px;}#shoppingCart .summary .empty{background-color:transparent;border-style:none;}#shoppingCart .summary .topLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;}#shoppingCart .summary .topRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;}#shoppingCart .summary .bottomLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;}#shoppingCart .summary .bottomRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;}#shoppingCart .summary select{padding-right:0px;text-align:left;}#shoppingCart tr.bottomLine td{border-bottom:solid 1px silver;}#shoppingCart tr.topLine td{border-top:solid 1px #fff;}#shippingAddress td,#billingAddress td{padding:1px 1px 1px 1px;}</style>',0),('jysVZeUR0Bx2NfrKs5sulg',1289360563,'3','pbversion0000000000001','approved','Ogone Summary Screen (Default)','Ogone Summary Screen (Default)','shopping-cart-collateral-items/ogone-summary','3','7','4',NULL,0,0,0,0,0,8672,'    <style type=\"text/css\">\n            #shoppingCart {\n                font-family:arial;\n                font-size:12px;\n            }\n\n            #shoppingCart tr.header td {\n                font-weight:bold;\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #shoppingCart tr.data td {\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #chooseAddressButton, #checkoutButton {\n                color: white;\n                background-color: green;                  \n            }\n            #shoppingCart tr.alt td {\n                background-color:#F0F0F0;\n            }\n            #shoppingCart tr.alt td.delete {\n                padding-left:10px;\n                -moz-border-radius-topLeft:10px;\n                -moz-border-radius-bottomLeft:10px;\n                border-top-left-radius:10px;\n                border-bottom-left-radius:10px;\n            }\n            #shoppingCart tr.alt td.shipping {\n                padding-right:10px;\n                -moz-border-radius-topRight:10px;\n                -moz-border-radius-bottomRight:10px;\n                border-top-right-radius:10px;\n                border-bottom-right-radius:10px;\n            }\n            #shoppingCart tr.topLine td {\n                margin-top:10px;\n                border-top:solid silver 1px;\n            }\n            #shoppingCart tr.summary td {\n                background-color: #f3f3f3;\n                padding:5px 10px 5px 10px;\n            }\n            #shoppingCart .summary .empty {\n                background-color: transparent;\n                border-style:none;\n            }\n            #shoppingCart .summary .topLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\n            }\n            #shoppingCart .summary .topRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\n            }\n            #shoppingCart .summary .bottomLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\n            }\n            #shoppingCart .summary .bottomRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\n            }\n            #shoppingCart .summary select {\n                padding-right:0px;\n                text-align:left;\n            }\n            #shoppingCart tr.bottomLine td {\n                border-bottom: solid 1px silver;\n            }\n            #shoppingCart tr.topLine td {\n                border-top: solid 1px #fff;\n            }\n\n            #shippingAddress td, #billingAddress td {\n                padding:1px 1px 1px 1px;\n            }\n        </style>\n',0,1,0,1289360564,'<style type=\"text/css\">#shoppingCart{font-family:arial;font-size:12px;}#shoppingCart tr.header td{font-weight:bold;text-align:right;padding:3px 5px;}#shoppingCart tr.data td{text-align:right;padding:3px 5px;}#chooseAddressButton,#checkoutButton{color:white;background-color:green;}#shoppingCart tr.alt td{background-color:#F0F0F0;}#shoppingCart tr.alt td.delete{padding-left:10px;-moz-border-radius-topLeft:10px;-moz-border-radius-bottomLeft:10px;border-top-left-radius:10px;border-bottom-left-radius:10px;}#shoppingCart tr.alt td.shipping{padding-right:10px;-moz-border-radius-topRight:10px;-moz-border-radius-bottomRight:10px;border-top-right-radius:10px;border-bottom-right-radius:10px;}#shoppingCart tr.topLine td{margin-top:10px;border-top:solid silver 1px;}#shoppingCart tr.summary td{background-color:#f3f3f3;padding:5px 10px 5px 10px;}#shoppingCart .summary .empty{background-color:transparent;border-style:none;}#shoppingCart .summary .topLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;}#shoppingCart .summary .topRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;}#shoppingCart .summary .bottomLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;}#shoppingCart .summary .bottomRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;}#shoppingCart .summary select{padding-right:0px;text-align:left;}#shoppingCart tr.bottomLine td{border-bottom:solid 1px silver;}#shoppingCart tr.topLine td{border-top:solid 1px #fff;}#shippingAddress td,#billingAddress td{padding:1px 1px 1px 1px;}</style>',0),('300AozDaeveAjB_KN0ljlQ',1289360563,'3','pbversion0000000000001','approved','PayPal Standard Summary Screen (Default)','PayPal Standard Summary Screen (Default)','shopping-cart-collateral-items/paypal-std-summary','3','7','4',NULL,0,0,0,0,0,8697,'    <style type=\"text/css\">\n            #shoppingCart {\n                font-family:arial;\n                font-size:12px;\n            }\n\n            #shoppingCart tr.header td {\n                font-weight:bold;\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #shoppingCart tr.data td {\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #chooseAddressButton, #checkoutButton {\n                color: white;\n                background-color: green;                  \n            }\n            #shoppingCart tr.alt td {\n                background-color:#F0F0F0;\n            }\n            #shoppingCart tr.alt td.delete {\n                padding-left:10px;\n                -moz-border-radius-topLeft:10px;\n                -moz-border-radius-bottomLeft:10px;\n                border-top-left-radius:10px;\n                border-bottom-left-radius:10px;\n            }\n            #shoppingCart tr.alt td.shipping {\n                padding-right:10px;\n                -moz-border-radius-topRight:10px;\n                -moz-border-radius-bottomRight:10px;\n                border-top-right-radius:10px;\n                border-bottom-right-radius:10px;\n            }\n            #shoppingCart tr.topLine td {\n                margin-top:10px;\n                border-top:solid silver 1px;\n            }\n            #shoppingCart tr.summary td {\n                background-color: #f3f3f3;\n                padding:5px 10px 5px 10px;\n            }\n            #shoppingCart .summary .empty {\n                background-color: transparent;\n                border-style:none;\n            }\n            #shoppingCart .summary .topLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\n            }\n            #shoppingCart .summary .topRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\n            }\n            #shoppingCart .summary .bottomLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\n            }\n            #shoppingCart .summary .bottomRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\n            }\n            #shoppingCart .summary select {\n                padding-right:0px;\n                text-align:left;\n            }\n            #shoppingCart tr.bottomLine td {\n                border-bottom: solid 1px silver;\n            }\n            #shoppingCart tr.topLine td {\n                border-top: solid 1px #fff;\n            }\n\n            #shippingAddress td, #billingAddress td {\n                padding:1px 1px 1px 1px;\n            }\n        </style>\n',0,1,0,1289360564,'<style type=\"text/css\">#shoppingCart{font-family:arial;font-size:12px;}#shoppingCart tr.header td{font-weight:bold;text-align:right;padding:3px 5px;}#shoppingCart tr.data td{text-align:right;padding:3px 5px;}#chooseAddressButton,#checkoutButton{color:white;background-color:green;}#shoppingCart tr.alt td{background-color:#F0F0F0;}#shoppingCart tr.alt td.delete{padding-left:10px;-moz-border-radius-topLeft:10px;-moz-border-radius-bottomLeft:10px;border-top-left-radius:10px;border-bottom-left-radius:10px;}#shoppingCart tr.alt td.shipping{padding-right:10px;-moz-border-radius-topRight:10px;-moz-border-radius-bottomRight:10px;border-top-right-radius:10px;border-bottom-right-radius:10px;}#shoppingCart tr.topLine td{margin-top:10px;border-top:solid silver 1px;}#shoppingCart tr.summary td{background-color:#f3f3f3;padding:5px 10px 5px 10px;}#shoppingCart .summary .empty{background-color:transparent;border-style:none;}#shoppingCart .summary .topLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;}#shoppingCart .summary .topRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;}#shoppingCart .summary .bottomLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;}#shoppingCart .summary .bottomRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;}#shoppingCart .summary select{padding-right:0px;text-align:left;}#shoppingCart tr.bottomLine td{border-bottom:solid 1px silver;}#shoppingCart tr.topLine td{border-top:solid 1px #fff;}#shippingAddress td,#billingAddress td{padding:1px 1px 1px 1px;}</style>',0),('GqnZPB0gLoZmqQzYFaq7bg',1289360563,'3','pbversion0000000000001','approved','PayPal Express Checkout Summary Screen (Default)','PayPal Express Checkout Summary Screen (Default)','shopping-cart-collateral-items/paypal-express-summary','3','7','4',NULL,0,0,0,0,0,8716,'    <style type=\"text/css\">\n            #shoppingCart {\n                font-family:arial;\n                font-size:12px;\n            }\n\n            #shoppingCart tr.header td {\n                font-weight:bold;\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #shoppingCart tr.data td {\n                text-align:right;\n                padding:3px 5px;\n            }\n\n            #chooseAddressButton, #checkoutButton {\n                color: white;\n                background-color: green;                 \n            }\n            #shoppingCart tr.alt td {\n                background-color:#F0F0F0;\n            }\n            #shoppingCart tr.alt td.delete {\n                padding-left:10px;\n                -moz-border-radius-topLeft:10px;\n                -moz-border-radius-bottomLeft:10px;\n                border-top-left-radius:10px;\n                border-bottom-left-radius:10px;\n            }\n            #shoppingCart tr.alt td.shipping {\n                padding-right:10px;\n                -moz-border-radius-topRight:10px;\n                -moz-border-radius-bottomRight:10px;\n                border-top-right-radius:10px;\n                border-bottom-right-radius:10px;\n            }\n            #shoppingCart tr.topLine td {\n                margin-top:10px;\n                border-top:solid silver 1px;\n            }\n            #shoppingCart tr.summary td {\n                background-color: #f3f3f3;\n                padding:5px 10px 5px 10px;\n            }\n            #shoppingCart .summary .empty {\n                background-color: transparent;\n                border-style:none;\n            }\n            #shoppingCart .summary .topLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;\n            }\n            #shoppingCart .summary .topRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;\n            }\n            #shoppingCart .summary .bottomLeft {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;\n            }\n            #shoppingCart .summary .bottomRight {\n                background: #f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;\n            }\n            #shoppingCart .summary select {\n                padding-right:0px;\n                text-align:left;\n            }\n            #shoppingCart tr.bottomLine td {\n                border-bottom: solid 1px silver;\n            }\n            #shoppingCart tr.topLine td {\n                border-top: solid 1px #fff;\n            }\n\n            #shippingAddress td, #billingAddress td {\n                padding:1px 1px 1px 1px;\n            }\n        </style>\n',0,1,0,1289360564,'<style type=\"text/css\">#shoppingCart{font-family:arial;font-size:12px;}#shoppingCart tr.header td{font-weight:bold;text-align:right;padding:3px 5px;}#shoppingCart tr.data td{text-align:right;padding:3px 5px;}#chooseAddressButton,#checkoutButton{color:white;background-color:green;}#shoppingCart tr.alt td{background-color:#F0F0F0;}#shoppingCart tr.alt td.delete{padding-left:10px;-moz-border-radius-topLeft:10px;-moz-border-radius-bottomLeft:10px;border-top-left-radius:10px;border-bottom-left-radius:10px;}#shoppingCart tr.alt td.shipping{padding-right:10px;-moz-border-radius-topRight:10px;-moz-border-radius-bottomRight:10px;border-top-right-radius:10px;border-bottom-right-radius:10px;}#shoppingCart tr.topLine td{margin-top:10px;border-top:solid silver 1px;}#shoppingCart tr.summary td{background-color:#f3f3f3;padding:5px 10px 5px 10px;}#shoppingCart .summary .empty{background-color:transparent;border-style:none;}#shoppingCart .summary .topLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-left.jpg);) top left no-repeat;}#shoppingCart .summary .topRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/top-right.jpg);) top right no-repeat;}#shoppingCart .summary .bottomLeft{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-left.jpg);) bottom left no-repeat;}#shoppingCart .summary .bottomRight{background:#f3f3f3 url(^FileUrl(shopping-cart-collateral-items/bottom-right.jpg);) bottom right no-repeat;}#shoppingCart .summary select{padding-right:0px;text-align:left;}#shoppingCart tr.bottomLine td{border-bottom:solid 1px silver;}#shoppingCart tr.topLine td{border-top:solid 1px #fff;}#shippingAddress td,#billingAddress td{padding:1px 1px 1px 1px;}</style>',0),('2GxjjkRuRkdUg_PccRPjpA',1289360563,'3','pbversion0000000000001','approved','Select Gateway (Default)','Select Gateway (Default)','shopping-cart-collateral-items/select-gateway-default','3','7','3',NULL,0,1,0,0,0,619,'\r\n',0,1,0,1289360564,NULL,0),('2rC4ErZ3c77OJzJm7O5s3w',1289360563,'3','pbversion0000000000001','approved','EMS Badge Listing (default)','EMS Badge Listing (default)','root/import/ems/ems-badge-listing-default','3','7','12',NULL,0,1,0,0,0,11613,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\">\n<link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\">\n\n<script src=\"^Extras(/tinymce/jscript/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script>\n<script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script>\n\n		<style type=\"text/css\">\n		.badgeDescription {\n		background-color: white;\n		max-width: 400px;\n		border:1px solid #000;\n		padding:10px;\n		}\n		.forwardButton {\n			background-color: green;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n		.backwardButton {\n			background-color: red;\n			color: white;\n			font-weight: bold;\n			padding: 3px;\n		}\n		</style>\n',0,1,0,1289360563,'<link href=\"^Extras(/yui/build/fonts/fonts-min.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/paginator/assets/skins/sam/paginator.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/datatable/assets/skins/sam/datatable.css);\" rel=\"stylesheet\" type=\"text/css\"><link href=\"^Extras(/yui/build/container/assets/skins/sam/container.css);\" rel=\"stylesheet\" type=\"text/css\"><script src=\"^Extras(/tinymce/jscript/tiny_mce/tiny_mce_src.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/utilities/utilities.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/json/json-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/paginator/paginator-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datasource/datasource-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/datatable/datatable-min.js);\" type=\"text/javascript\"></script><script src=\"^Extras(/yui/build/container/container-min.js);\" type=\"text/javascript\"></script><style type=\"text/css\">.badgeDescription{background-color:white;max-width:400px;border:1px solid #000;padding:10px;}.forwardButton{background-color:green;color:white;font-weight:bold;padding:3px;}.backwardButton{background-color:red;color:white;font-weight:bold;padding:3px;}</style>',0);
ALTER TABLE `assetData` ENABLE KEYS;
ALTER TABLE `assetIndex` DISABLE KEYS;
INSERT INTO `assetIndex` VALUES ('PBasset000000000000003','Media','','media',1147642437,1147642437,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Media Media media','000001000003'),('PBtmpl0000000000000112','Weblog','','weblog',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Weblog Weblog weblog Collaboration','000001000001000008000004'),('PBtmplBlankStyle000001','WebGUI 6 Blank Style','','pbtmplblankstyle000001',1133743239,1258524916,'3','7','12','WebGUI::Asset::Template',0,'WebGUI 6 Blank Style WebGUI 6 Blank Style pbtmplblankstyle000001 style','000001000001000043000005'),('PBtmpl0000000000000079','Topics','','topics',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Topics Topics topics Collaboration','000001000001000008000009'),('PBtmpl0000000000000097','Traditional with Thumbnails','','traditional_with_thumbnails',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Traditional with Thumbnails Traditional with Thumbnails traditional with thumbnails Collaboration','000001000001000008000003'),('PBtmpl0000000000000082','Unordered List','','unordered_list',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Unordered List Unordered List unordered list Collaboration','000001000001000008000011'),('PBtmpl0000000000000124','Tabs','','tabs',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Tabs Tabs tabs Navigation','000001000001000025000004'),('GNvjCFQWjY2AF2uf0aCM8Q','Syndicated Articles','','syndicated_articles',1124395696,1259133274,'3','7','12','WebGUI::Asset::Template',0,'Syndicated Articles Syndicated Articles syndicated articles SyndicatedContent','000001000001000045000002'),('PBtmpl0000000000000136','Synopsis','','synopsis2',1124395696,1259133274,'3','7','12','WebGUI::Asset::Template',0,'Synopsis Synopsis synopsis2 Navigation','000001000001000025000007'),('PBtmpl0000000000000116','Tab Form','','tab_form',1124395696,1257311888,'3','7','12','WebGUI::Asset::Template',0,'Tab Form Tab Form tab form DataForm','000001000001000010000005'),('GRUNFctldUgop-qRLuo_DA','Default Survey Edit','','root/import/survey/default-survey-edit',1227254010,1269401469,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Edit Default Survey Edit root import survey default survey edit Survey/Edit','000001000001000044000004'),('ProjectManagerTMPL0004','Default Project Manager Edit Task','','default-pm-template-edit-task',1147642415,1222574693,'3','7','12','WebGUI::Asset::Template',0,'Default Project Manager Edit Task Default Project Manager Edit Task default pm template edit task ProjectManager_editTask','000001000001000031000002000001'),('ProjectManagerTMPL0002','Default Project Display','','default-pm-template-project-display',1147642415,1222574693,'3','7','12','WebGUI::Asset::Template',0,'Default Project Display Default Project Display default pm template project display ProjectManager_project','000001000001000031000004000001'),('PBtmpl0000000000000137','Admin Console Style','','admin_console',1124395696,1258524916,'3','7','12','WebGUI::Asset::Template',0,'Admin Console Style Admin Console admin console style','000001000001000043000003'),('StockDataTMPL000000001','StockData Default View','','stockdatatmpl000000001',1133743239,1279073449,'3','7','12','WebGUI::Asset::Template',0,'StockData Default View StockData Default View stockdatatmpl000000001 StockData','000001000001000041000002'),('PBtmpl0000000000000135','Side By Side','','side_by_side',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Side By Side Side By Side side by side Layout','000001000001000019000001'),('PBtmpl0000000000000200','Default Search','','default_search2',1147642427,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Default Search Default Search default search2 Search','000001000001000036000001'),('PBtmpl0000000000000101','Ordered List','','ordered_list',1124395696,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Ordered List Ordered List ordered list Collaboration','000001000001000008000024'),('PBtmpl0000000000000121','Photo Gallery','','photo_gallery',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Photo Gallery Photo Gallery photo gallery Collaboration','000001000001000008000005'),('PBtmpl0000000000000081','Q and A','','q_and_a',1124395696,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Q and A Q and A q and a Collaboration','000001000001000008000023'),('WVtmpl0000000000000001','Random Thread Macro Default Template','','randomthread-template',1133743240,1147642426,'3','7','12','WebGUI::Asset::Template',0,'Random Thread Macro Default Template Random Thread Macro Default Template randomthread template Macro/RandomThread','000001000001000021000010000001'),('PBtmpl0000000000000131','Right Column','','right_column',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Right Column Right Column right column Layout','000001000001000019000002'),('PBtmpl0000000000000094','News','','plainblacknews',1124395696,1220655703,'3','7','12','WebGUI::Asset::Template',0,'News News plainblacknews Layout','000001000001000019000005'),('matrixtmpl000000000005','Matrix Default Search','','matrix-search-template',1133743239,1281501163,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Search Matrix Default Search matrix search template Matrix/Search','000001000001000022000005'),('MultiSearchTmpl0000001','MultiSearch Default Display','','multisearchtmpl0000001',1133743239,1230269962,'3','7','12','WebGUI::Asset::Template',0,'MultiSearch Default Display MultiSearch Default Display multisearchtmpl0000001 MultiSearch','000001000001000024000001'),('matrixtmpl000000000002','Matrix Default Compare','','matrix-default-compare-template',1133743238,1281501162,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Compare Matrix Default Compare matrix default compare template Matrix/Compare','000001000001000022000001'),('PBtmpl0000000000000111','Make Page Printable','','make_page_printable',1124395696,1286941427,'3','7','12','WebGUI::Asset::Template',0,'Make Page Printable Make Page Printable make page printable style','000001000001000043000002'),('PBtmpl0000000000000020','Mail Form','','mail_form',1124395696,1257311887,'3','7','12','WebGUI::Asset::Template',0,'Mail Form Mail Form mail form DataForm','000001000001000010000001'),('PBtmpl0000000000000113','Link','','link',1124395696,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Link Link link Collaboration/Thread','000001000001000008000025'),('PBtmpl0000000000000083','Link List','','link_list',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Link List Link List link list Collaboration','000001000001000008000010'),('PBtmpl0000000000000114','Link List Submission Form','','link_list_submission_form',1124395696,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Link List Submission Form Link List Submission Form link list submission form Collaboration/PostForm','000001000001000008000019'),('PBtmpl0000000000000115','Linked Image with Caption','','linked_image_with_caption',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Linked Image with Caption Linked Image with Caption linked image with caption Article','000001000001000004000003'),('PBtmpl0000000000000098','Job','','job',1124395696,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Job Job job Collaboration/Thread','000001000001000008000021'),('PBtmpl0000000000000077','Job Listing','','job_listing',1124395696,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Job Listing Job Listing job listing Collaboration','000001000001000008000020'),('PBtmpl0000000000000122','Job Submission Form','','job_submission_form',1124395696,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Job Submission Form Job Submission Form job submission form Collaboration/PostForm','000001000001000008000022'),('PBtmpl0000000000000103','Article With Image','','article-with-image',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Article With Image Article With Image article with image Article','000001000001000004000001'),('PBtmpl0000000000000092','Horizontal Login Box','','horizontal_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',0,'Horizontal Login Box Horizontal Login Box horizontal login box Macro/L_loginBox','000001000001000021000009000001'),('PBtmpl0000000000000108','horizontalMenu','','horizontalmenu',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'horizontalMenu horizontalMenu horizontalmenu Navigation','000001000001000025000002'),('PBtmpl0000000000000088','Image','','image',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Image Image image ImageAsset','000001000001000017000001'),('IOB0000000000000000002','Default InOutBoard Report Template','','iob-report-template',1133743239,1166019641,'3','7','12','WebGUI::Asset::Template',0,'Default InOutBoard Report Template Default InOutBoard Report Template iob report template InOutBoard/Report','000001000001000018000001'),('IOB0000000000000000001','Default InOutBoard Template','','iob-template',1133743239,1169795123,'3','7','12','WebGUI::Asset::Template',0,'Default InOutBoard Template Default InOutBoard Template iob template InOutBoard','000001000001000018000002'),('PBtmpl0000000000000123','Item','','item',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Item Item item Article','000001000001000004000004'),('PBtmpl0000000000000024','File','','file',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'File File file FileAsset','000001000001000013000001'),('PBtmpl0000000000000078','File Folder','','file_folder',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'File Folder File Folder file folder Folder','000001000001000014000001'),('PBtmpl0000000000000107','File with size','','file_with_size',1124395696,1147642420,'3','7','12','WebGUI::Asset::Template',0,'File with size File with size file with size Macro/File','000001000001000021000004000003'),('PBtmpl0000000000000133','Guest Book','','guest_book',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Guest Book Guest Book guest book Collaboration','000001000001000008000012'),('PBtmpl0000000000000117','DropMenu','','dropmenu',1124395696,1259133274,'3','7','12','WebGUI::Asset::Template',0,'DropMenu DropMenu dropmenu Navigation','000001000001000025000003'),('PBtmpl0000000000000130','Tree Navigation','','root/import/navigation/tree-navigation',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Tree Navigation Tree Navigation root import navigation tree navigation Navigation','000001000001000025000005'),('PBtmpl0000000000000060','Fail Safe','','fail_safe',1124395696,1258524916,'3','7','12','WebGUI::Asset::Template',0,'Fail Safe Fail Safe fail safe style','000001000001000043000001'),('PBtmpl0000000000000080','FAQ','','faqtemplate',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'FAQ FAQ faqtemplate Collaboration','000001000001000008000002'),('PBtmpl0000000000000099','FAQ Submission Form','','faq_submission_form',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'FAQ Submission Form FAQ Submission Form faq submission form Collaboration/PostForm','000001000001000008000018'),('PBtmpl0000000000000010','Default WebGUI Account Display Template','','default_webgui_account_display_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Account Display Template Default WebGUI Account Display Template default webgui account display template Auth/WebGUI/Account','000001000001000005000004000001'),('PBtmpl0000000000000013','Default WebGUI Login Template','','default_webgui_login_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Login Template Default WebGUI Login Template default webgui login template Auth/WebGUI/Login','000001000001000005000007000001'),('PBtmpl0000000000000012','Default WebGUI Password Reset Template','','default_webgui_password_reset_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Password Reset Template Default WebGUI Password Reset Template default webgui password reset template Auth/WebGUI/Expired','000001000001000005000006000001'),('PBtmpl0000000000000057','Default WebGUI Yes/No Prompt','','default_webgui_yes/no_prompt',1124395696,1147642418,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Yes/No Prompt Default WebGUI Yes/No Prompt default webgui yes no prompt prompt','000001000001000032000001'),('PBtmpl0000000000000066','Default USS','','default_uss',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default USS Default USS default uss Collaboration','000001000001000008000001'),('TimeTrackingTMPL000001','Default Time Tracking User View','','default-tt-template-user',1147642417,1201205738,'3','7','12','WebGUI::Asset::Template',0,'Default Time Tracking User View Default Time Tracking User View default tt template user TimeTracking_user','000001000001000048000003000001'),('TimeTrackingTMPL000003','Default Time Tracking Row Template','','default-tt-template-row',1147642417,1229311434,'3','7','12','WebGUI::Asset::Template',0,'Default Time Tracking Row Template Default Time Tracking Row Template default tt template row TimeTracking_row','000001000001000048000002000001'),('TimeTrackingTMPL000002','Default Time Tracking Manager View','','default-tt-template-manager',1147642417,1147642417,'3','7','12','WebGUI::Asset::Template',0,'Default Time Tracking Manager View Default Time Tracking Manager View default tt template manager TimeTracking_manager','000001000001000048000001000001'),('X7DrzUcj8pOKFa_6k9D5iw','Newsletter','','root/import/newsletter',1185754569,1222804045,'3','12','3','WebGUI::Asset::Wobject::Folder',1,'Newsletter Newsletter root import newsletter','000001000001000026'),('PBtmpl0000000000000065','Default Syndicated Content','','default_syndicated_content',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Default Syndicated Content Default Syndicated Content default syndicated content SyndicatedContent','000001000001000045000001'),('CxMpE_UPauZA3p8jdrOABw','Default Questions','','root/import/survey/default-questions',1227556536,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Questions Default Questions root import survey default questions Survey/Take','000001000001000044000006'),('PBtmpl0000000000000059','Default SQL Report','','default_sql_report',1124395696,1229907401,'3','7','12','WebGUI::Asset::Template',0,'Default SQL Report Default SQL Report default sql report SQLReport','000001000001000040000001'),('PBtmpl0000000000000067','Default Submission','','default_submission',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default Submission Default Submission default submission Collaboration/Thread','000001000001000008000006'),('PBtmpl0000000000000068','Default Submission Form','','default_submission_form',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default Submission Form Default Submission Form default submission form Collaboration/PostForm','000001000001000008000017'),('ProjectManagerTMPL0003','Default Project Manager Gantt Chart','','default-pm-template-gantt-chart',1147642415,1159989349,'3','7','12','WebGUI::Asset::Template',0,'Default Project Manager Gantt Chart Default Project Manager Gantt Chart default pm template gantt chart ProjectManager_gantt','000001000001000031000003000001'),('ProjectManagerTMPL0001','Default Project Management System Dashboard','','default-pm-template-dashboard',1147642415,1229579830,'3','7','12','WebGUI::Asset::Template',0,'Default Project Management System Dashboard Default Project Management System Dashboard default pm template dashboard ProjectManager_dashboard','000001000001000031000001000001'),('PBtmpl0000000000000055','Default Poll','','default_poll',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Default Poll Default Poll default poll Poll','000001000001000027000001'),('PBtmpl0000000000000029','Default Post Form','','default_post_form',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default Post Form Default Post Form default post form Collaboration/PostForm','000001000001000008000013'),('PBtmpl0000000000000056','Default Product','','default_product',1124395696,1248729559,'3','7','12','WebGUI::Asset::Template',0,'Default Product Default Product default product Product','000001000001000028000001'),('PBtmpl0000000000000033','Default HTTP Proxy','','default_http_proxy',1124395696,1230159454,'3','7','12','WebGUI::Asset::Template',0,'Default HTTP Proxy Default HTTP Proxy default http proxy HttpProxy','000001000001000016000001'),('PBtmpl0000000000000004','Default LDAP Account Display Template','','default_ldap_account_display_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default LDAP Account Display Template Default LDAP Account Display Template default ldap account display template Auth/LDAP/Account','000001000001000005000001000001'),('PBtmpl0000000000000006','Default LDAP Login Template','','default_ldap_login_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default LDAP Login Template Default LDAP Login Template default ldap login template Auth/LDAP/Login','000001000001000005000003000001'),('PBtmpl0000000000000044','Default Login Box','','default_login_box',1124395696,1148579524,'3','7','12','WebGUI::Asset::Template',0,'Default Login Box Default Login Box default login box Macro/L_loginBox','000001000001000021000009000002'),('PBtmpl0000000000000047','Default Message Board','','default_message_board',1124395696,1147642414,'3','7','12','WebGUI::Asset::Template',0,'Default Message Board Default Message Board default message board MessageBoard','000001000001000023000001'),('PBtmpl0000000000000054','Default Page','','default_page',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Default Page Default Page default page Layout','000001000001000019000003'),('Q4uX_C557arTp6D_jwB1jQ','Wiki','','root/import/wiki',1165460175,1273032720,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'Wiki Wiki root import wiki','000001000001000054'),('BmLaN4rmAANkCglXUViEbg','Resource','','root/import/projectmanager/resource',1157679165,1222803871,'3','12','12','WebGUI::Asset::Wobject::Folder',1,'Resource Resource root import projectmanager resource','000001000001000031000005'),('PBtmpl0000000000000039','Default File Macro','','default_file_macro',1124395696,1154535073,'3','7','12','WebGUI::Asset::Template',0,'Default File Macro Default File Macro default file macro Macro/File','000001000001000021000004000001'),('PBtmpl0000000000000026','Default Forum','','default_forum',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default Forum Default Forum default forum Collaboration','000001000001000008000007'),('PBtmpl0000000000000031','Default Forum Search','','default_forum_search',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default Forum Search Default Forum Search default forum search Collaboration/Search','000001000001000008000016'),('PBtmpl0000000000000093','crumbTrail','','crumbtrail2',1124395696,1259133274,'3','7','12','WebGUI::Asset::Template',0,'crumbTrail crumbTrail crumbtrail2 Navigation','000001000001000025000001'),('DashboardViewTmpl00001','Dashboard Default View','','dashboard-default-view-template',1133743239,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Dashboard Default View Dashboard Default View dashboard default view template Dashboard','000001000001000009000001'),('PBtmpl0000000000000021','Data List','','data_list',1124395696,1280279759,'3','7','12','WebGUI::Asset::Template',0,'Data List Data List data list DataForm/List','000001000001000010000004'),('PBtmpl0000000000000104','Default Acknowledgement','','default_acknowledgement',1124395696,1257311888,'3','7','12','WebGUI::Asset::Template',0,'Default Acknowledgement Default Acknowledgement default acknowledgement DataForm','000001000001000010000003'),('PBtmpl0000000000000002','Default Article','','default_article',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Default Article Default Article default article Article','000001000001000004000002'),('PBtmpl0000000000000141','Default DataForm','','pbtmpl0000000000000141',1124395696,1257311888,'3','7','12','WebGUI::Asset::Template',0,'Default DataForm Default DataForm pbtmpl0000000000000141 DataForm','000001000001000010000006'),('WikiRCTmpl000000000001','Default Recent Changes','','default-wiki-recent-changes',1165460175,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Default Recent Changes Default Recent Changes default wiki recent changes WikiMaster_recentChanges','000001000001000054000001'),('PBtmpl0000000000000128','Classifieds','','classifieds',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Classifieds Classifieds classifieds Collaboration','000001000001000008000008'),('PBtmpl0000000000000134','Hierarchical Top Nav','','import/hierarchical-top-nav',1124395696,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Hierarchical Top Nav Hierarchical Top Nav import hierarchical top nav Navigation','000001000001000025000006'),('PBtmplHelp000000000001','Help','','root/import/adminconsole/help',1124395706,1147642410,'3','7','12','WebGUI::Asset::Template',0,'Help Help root import adminconsole help AdminConsole','000001000001000003000002'),('PBtmpl0000000000000208','Request Tracker','','request-tracker-template',1147642410,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Request Tracker Request Tracker request tracker template Collaboration','000001000001000008000026'),('wAc4azJViVTpo-2NYOXWvg','Default Question Edit','','root/import/survey/default-question-edit',1226009650,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Question Edit Default Question Edit root import survey default question edit Survey/Edit','000001000001000044000008'),('1z9J1O08n_7gVVlBwSRBJQ','Auth','','root/import/auth',1222803099,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Auth Auth root import auth','000001000001000005'),('zyWi26q9na-iiZqL4yedog','Macro','','root/import/macro',1222803114,1222803114,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Macro Macro root import macro','000001000001000021'),('PBtmpl0000000000000209','Request Tracker Thread','','request-tracker-post-template',1147642410,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Request Tracker Thread Request Tracker Thread request tracker post template Collaboration/Thread','000001000001000008000027'),('PBtmpl0000000000000109','One Over Three','','one_over_three',1124395696,1259133276,'3','7','12','WebGUI::Asset::Template',0,'One Over Three One Over Three one over three Layout','000001000001000019000004'),('PBtmpl0000000000000001','Admin Console','','admin_console2',1124395696,1247535846,'3','7','12','WebGUI::Asset::Template',0,'Admin Console Admin Console admin console2 AdminConsole','000001000001000003000001'),('LBuiKzg2mWwmOPS9AgV3bg','Get Translated','Let our team of professional translators bring your site to new customers by translating your content into additional languages. Our translation services are never machine automated. They\'re always done by professional translators that have years of exper','yns/translated',1147642517,1271348789,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Translated Get Translated yns translated Let our team of professional translators bring your site to new customers by translating your content into additional languages Our translation services are never machine automated They\'re always done by professional translators that have years of experience reading writing and speaking many languages  ','000001000002000002000005'),('jTNggl7AoVSUc_ZzrvuCmw','Get Promoted','Now that you have a brilliant WebGUI site, you need to get people to visit it. We can help there too. Our marketing specialists can work with you to develop and execute the right combination of search engine placement, advertising buys, and affilliate pro','yns/promotion',1147642517,1271348789,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Promoted Get Promoted yns promotion Now that you have a brilliant WebGUI site you need to get people to visit it We can help there too Our marketing specialists can work with you to develop and execute the right combination of search engine placement advertising buys and affilliate programs to ensure your site gets the traffic it needs  ','000001000002000002000006'),('Vzv1pWpg_w6R_o-b0rM2qQ','Ad','','home/ad2',1147642515,1147642515,'3','7','4','WebGUI::Asset::File',1,'Ad Ad home ad2','000001000002000001000002'),('NK8bqlwVRILJknqeCDPBHg','Getting Started (part 2)','\nTo begin managing content, you should log in and click the Turn Admin On! link. The default username is \"admin\" and the default password is \"123qwe\", but you probably customized both of those when you visited this site for the very first time.\n \n\nNow tha','getting_started/getting-started-part2',1147642515,1278013933,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting Started part 2 Getting Started part 2 getting started getting started part2 To begin managing content you should log in and click the Turn Admin On link The default username is admin and the default password is 123qwe but you probably customized both of those when you visited this site for the very first time Now that you\'re logged in we recommend that you add a new user for yourself with admin privileges just in case you forget the login information for your primary admin account Don\'t worry if you lock yourself out you can always contact Plain Black® support to get instructions to get back in NOTE If you appear to be get logged out while moving between pages this is most likely your browser displaying a cached version of the page Click on your browser\'s refresh button to correct the problem For more information about services related to WebGUI click here Enjoy your new WebGUI site  ','000001000002000001000003'),('IWFxZDyGhQ3-SLZhELa3qw','Benefits','\n\n\n\nRich User Interface\n \n\nPowerful API\n \n\n\n\nWebGUI has a rich user experience that allows users to place their \ncontent\nthrough a drag-n-drop interface; helps users pick dates, colors, and\nmore; and has a highly customizable rich editor to allow users to','home/key-benefits',1147642514,1277737686,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Benefits Benefits home key benefits Rich User Interface Powerful API WebGUI has a rich user experience that allows users to place their content through a drag-n-drop interface helps users pick dates colors and more and has a highly customizable rich editor to allow users to quickly and easily format content WebGUI allows developers to quickly plug-in new functionality to get the most from a site In addition WebGUI\'s standardized plug-in points maintain the upgrade path even with customizations Short Friendly URLs Internationalization Never worry about ugly numeric ID\'s or other things in URL\'s that make it hard for search engines and people to use a site Users can work in an interface in their native language and content can be published in as many languages as necessary Personalization Easy To Install Users see their own view of the site through dynamically generated navigation and content In addition content can be displayed based upon users viewing habits With the use of the WebGUI Runtime Environment Unix Mac OS X Linux BSD and VMWare Appliance Windows setup takes minutes rather than hours  ','000001000002000007'),('OhdaFLE7sXOzo_SIP2ZUgA','Welcome','The WebGUI Content Engine&reg; is a powerful, easy to use web application framework and content management system. WebGUI contains dozens of built-in features, and allows for full customization through its rich API. It\'s easy enough for the average busine','home/welcome',1147642513,1271445348,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Welcome Welcome home welcome The WebGUI Content Engine® is a powerful easy to use web application framework and content management system WebGUI contains dozens of built-in features and allows for full customization through its rich API It\'s easy enough for the average business user to use but powerful enough for any large enterprise WebGUI serves thousands of small and large businesses schools universities governments associations churches projects and communities throughout the world For examples of who is using WebGUI visit the WebGUI Sightings page Shouldn\'t your site be on this list If you\'re new to WebGUI visit the Getting Started section Once you feel comfortable explore some of the professional services available for your new WebGUI site No matter what level you\'re at tell your friends about WebGUI  ','000001000002000006'),('7-0-style0000000000071','wg.jpg','','style3/wg.jpg',1147642511,1147642511,'3','7','12','WebGUI::Asset::File::Image',1,'wg.jpg wg.jpg style3 wg.jpg','000001000001000053000022'),('7-0-style0000000000068','spacer.gif','','style3/spacer.gif',1147642510,1147642510,'3','7','12','WebGUI::Asset::File::Image',1,'spacer.gif spacer.gif style3 spacer.gif','000001000001000053000019'),('7-0-style0000000000070','Style3 Coolmenu','','style3_coolmenu',1147642510,1147642510,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Style3 Coolmenu Style3 Coolmenu style3 coolmenu','000001000001000053000021'),('7-0-style0000000000066','nav_bg_on.jpg','','style3/nav_bg_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg_on.jpg nav_bg_on.jpg style3 nav bg on.jpg','000001000001000053000017'),('7-0-style0000000000064','nav_bg2.jpg','','style3/nav_bg2.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2.jpg nav_bg2.jpg style3 nav bg2.jpg','000001000001000053000015'),('7-0-style0000000000065','nav_bg2_on.jpg','','style3/nav_bg2_on.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg2_on.jpg nav_bg2_on.jpg style3 nav bg2 on.jpg','000001000001000053000016'),('7-0-style0000000000067','pb.jpg','','style3/pb.jpg',1147642509,1147642509,'3','7','12','WebGUI::Asset::File::Image',1,'pb.jpg pb.jpg style3 pb.jpg','000001000001000053000018'),('7-0-style0000000000063','nav_bg1_on.jpg','','style3/nav_bg1_on.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1_on.jpg nav_bg1_on.jpg style3 nav bg1 on.jpg','000001000001000053000014'),('7-0-style0000000000060','main_top_bg.jpg','','style3/main_top_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'main_top_bg.jpg main_top_bg.jpg style3 main top bg.jpg','000001000001000053000011'),('7-0-style0000000000062','nav_bg1.jpg','','style3/nav_bg1.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg1.jpg nav_bg1.jpg style3 nav bg1.jpg','000001000001000053000013'),('7-0-style0000000000061','nav_bg.jpg','','style3/nav_bg.jpg',1147642508,1147642508,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg.jpg nav_bg.jpg style3 nav bg.jpg','000001000001000053000012'),('7-0-style0000000000059','main_top.jpg','','style3/main_top.jpg',1147642507,1213386091,'3','7','12','WebGUI::Asset::File::Image',1,'main_top.jpg main_top.jpg style3 main top.jpg','000001000001000053000010'),('7-0-style0000000000057','main_bg.jpg','','style3/main_bg.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.jpg main_bg.jpg style3 main bg.jpg','000001000001000053000008'),('7-0-style0000000000058','main_bottom.jpg','','style3/main_bottom.jpg',1147642507,1147642507,'3','7','12','WebGUI::Asset::File::Image',1,'main_bottom.jpg main_bottom.jpg style3 main bottom.jpg','000001000001000053000009'),('7-0-style0000000000055','header_left.jpg','','style3/header_left.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_left.jpg header_left.jpg style3 header left.jpg','000001000001000053000006'),('7-0-style0000000000056','header_right.jpg','','style3/header_right.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_right.jpg header_right.jpg style3 header right.jpg','000001000001000053000007'),('7-0-style0000000000054','header_bg.jpg','','style3/header_bg.jpg',1147642506,1147642506,'3','7','12','WebGUI::Asset::File::Image',1,'header_bg.jpg header_bg.jpg style3 header bg.jpg','000001000001000053000005'),('7-0-style0000000000052','footer_bg.jpg','','style3/footer_bg.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_bg.jpg footer_bg.jpg style3 footer bg.jpg','000001000001000053000003'),('7-0-style0000000000053','footer_right.jpg','','style3/footer_right.jpg',1147642505,1147642505,'3','7','12','WebGUI::Asset::File::Image',1,'footer_right.jpg footer_right.jpg style3 footer right.jpg','000001000001000053000004'),('7-0-style0000000000046','rightCol_bg.jpg','','style2/rightcol_bg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'rightCol_bg.jpg rightCol_bg.jpg style2 rightcol bg.jpg','000001000001000052000015'),('7-0-style0000000000049','WebGUI 7 Style 3','','root/import/webgui-7-style-3',1147642504,1224117144,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI 7 Style 3 WebGUI 7 Style 3 root import webgui 7 style 3','000001000001000053'),('7-0-style0000000000048','wg.jpg','','style2/wg.jpg',1147642504,1147642504,'3','7','12','WebGUI::Asset::File::Image',1,'wg.jpg wg.jpg style2 wg.jpg','000001000001000052000017'),('7-0-style0000000000045','pb_wg_bg.jpg','','style2/pb_wg_bg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg_bg.jpg pb_wg_bg.jpg style2 pb wg bg.jpg','000001000001000052000014'),('7-0-style0000000000044','pb_wg.jpg','','style2/pb_wg.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb_wg.jpg pb_wg.jpg style2 pb wg.jpg','000001000001000052000013'),('7-0-style0000000000043','pb.jpg','','style2/pb.jpg',1147642503,1147642503,'3','7','12','WebGUI::Asset::File::Image',1,'pb.jpg pb.jpg style2 pb.jpg','000001000001000052000012'),('7-0-style0000000000042','page_title_bg.jpg','','style2/page_title_bg.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title_bg.jpg page_title_bg.jpg style2 page title bg.jpg','000001000001000052000011'),('7-0-style0000000000041','page_title.jpg','','style2/page_title.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'page_title.jpg page_title.jpg style2 page title.jpg','000001000001000052000010'),('7-0-style0000000000040','navbar_right.jpg','','style2/navbar_right.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_right.jpg navbar_right.jpg style2 navbar right.jpg','000001000001000052000009'),('7-0-style0000000000039','navbar_left.jpg','','style2/navbar_left.jpg',1147642502,1147642502,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_left.jpg navbar_left.jpg style2 navbar left.jpg','000001000001000052000008'),('7-0-style0000000000036','main_bg.jpg','','style2/main_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.jpg main_bg.jpg style2 main bg.jpg','000001000001000052000005'),('7-0-style0000000000038','navbar_bg.jpg','','style2/navbar_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'navbar_bg.jpg navbar_bg.jpg style2 navbar bg.jpg','000001000001000052000007'),('7-0-style0000000000035','leftCol_header02.jpg','','style2/leftcol_header02.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header02.jpg leftCol_header02.jpg style2 leftcol header02.jpg','000001000001000052000004'),('7-0-style0000000000037','nav_bg.jpg','','style2/nav_bg.jpg',1147642501,1147642501,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg.jpg nav_bg.jpg style2 nav bg.jpg','000001000001000052000006'),('7-0-style0000000000032','context_bg.jpg','','style2/context_bg.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'context_bg.jpg context_bg.jpg style2 context bg.jpg','000001000001000052000001'),('7-0-style0000000000031','WebGUI 7 Style 2','','root/import/webgui-7-style-2',1147642500,1147642500,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI 7 Style 2 WebGUI 7 Style 2 root import webgui 7 style 2','000001000001000052'),('7-0-style0000000000033','css02.css','','style2/css02.css',1147642500,1147642500,'3','7','12','WebGUI::Asset::Snippet',0,'css02.css css02.css style2 css02.css body html  height:100  body  background:#7c9ab0 url(\'^FileUrl(style2/main_bg.jpg repeat-y right margin:0px  rightColumn  width:20 height:100 background eeeeee url(\'^FileUrl(style2/rightCol_bg.jpg repeat-y right text-align:center  rightColumn pb_wg_bg  background url(\'^FileUrl(style2/pb_wg_bg.jpg repeat-x width:100 text-align:left  rightColumn pb_wg  background url(\'^FileUrl(style2/pb_wg.jpg left no-repeat height:53px  leftColumn  width:80 background white url(\'^FileUrl(style2/context_bg.jpg repeat-y right  leftColumn header  width:100 background:#7c9ab0 url(\'^FileUrl(style2/leftCol_header.jpg right no-repeat height:86px position:relative  leftColumn header title leftColumn header title_bg  color:white font-size:36pt font-weight:bold font-family:arial font-variant:small-caps letter-spacing:12px top:15px left:5px position:absolute z-index:10  leftColumn header title a  color:white text-decoration:none  leftColumn header title_bg  color:black z-index:5 top:17px left:7px  leftColumn context  background fff url(\'^FileUrl(style2/context_bg.jpg repeat-y right  width:95 font-family:verdana font-size:9pt color:#242424 moz-box-sizing:border-box position:relative padding-left:1 padding-right:1 padding-bottom:15px  leftColumn context a  color:#7C9AB0 font-weight:bold  leftColumn context a:hover  text-decoration:none  leftColumn pageTitleBG  background url(\'^FileUrl(style2/page_title_bg.jpg repeat-x width:100  leftColumn pageTitleBG pageTitle  background url(\'^FileUrl(style2/page_title.jpg right no-repeat width:100 height:50px  leftColumn pageTitleBG pageTitle h2  font-size:14pt color:#696969 font-family:arial font-weight:normal margin:0px padding-top:2px padding-left:25px letter-spacing:3px  rightColumn nav  width:85 background b5b5b5 url(\'^FileUrl(style2/nav_bg.jpg repeat-x top border-right:solid 848484 1px margin-left:auto margin-right:auto text-align:left padding-left:3px padding-top:7px padding-bottom:7px  rightColumn nav a  color:white font-size:8pt font-weight:bold text-decoration:none font-family:arial line-height:8pt  rightColumn nav selectedMenuItem  color:yellow  loginStyles  font-size:8pt font-family:arial padding-bottom:25px  loginStyles a  color:#89ACCF font-weight:bold border-bottom:solid transparent 2px text-decoration:none  loginStyles a:hover  border-bottom:dotted B2C9D9 2px  copyright  border-top:solid silver 3px background-color:gray font-family:arial font-size:9pt color:silver text-align:center ','000001000001000052000002'),('7-0-style0000000000034','leftCol_header.jpg','','style2/leftcol_header.jpg',1147642500,1147642500,'3','7','12','WebGUI::Asset::File::Image',1,'leftCol_header.jpg leftCol_header.jpg style2 leftcol header.jpg','000001000001000052000003'),('stevenav00000000000001','Style 01 Nav','','style1_nav',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',0,'Style 01 Nav Style 01 Nav style1 nav Navigation','000001000001000051000027'),('PBnav000000style01lvl2','Style 01 Nav lvl2','','style1_nav_lvl2',1147642499,1147642499,'3','7','12','WebGUI::Asset::Template',0,'Style 01 Nav lvl2 untitled style1 nav lvl2 Navigation','000001000001000051000028'),('7-0-style0000000000030','webgui_btn.jpg','','style1/webgui_btn.jpg',1147642499,1147642499,'3','7','12','WebGUI::Asset::File::Image',1,'webgui_btn.jpg webgui_btn.jpg style1 webgui btn.jpg','000001000001000051000029'),('7-0-style0000000000026','RootTab Level 1','','roottab_level1',1147642499,1147642499,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab Level 1 RootTab Level 1 roottab level1','000001000001000051000025'),('7-0-style0000000000024','orange_left01.jpg','','style1/orange_left01.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'orange_left01.jpg orange_left01.jpg style1 orange left01.jpg','000001000001000051000023'),('7-0-style0000000000023','nav_on.jpg','','style1/nav_on.jpg',1147642498,1147642498,'3','7','12','WebGUI::Asset::File::Image',1,'nav_on.jpg nav_on.jpg style1 nav on.jpg','000001000001000051000022'),('7-0-style0000000000025','RootTab Level 0','','roottab_level0',1147642498,1147642498,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab Level 0 RootTab Level 0 roottab level0','000001000001000051000024'),('7-0-style0000000000019','nav2_off_right.jpg','','style1/nav2_off_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_right.jpg nav2_off_right.jpg style1 nav2 off right.jpg','000001000001000051000018'),('7-0-style0000000000020','nav2_on_left.jpg','','style1/nav2_on_left.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_left.jpg nav2_on_left.jpg style1 nav2 on left.jpg','000001000001000051000019'),('7-0-style0000000000022','nav_bg.jpg','','style1/nav_bg.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav_bg.jpg nav_bg.jpg style1 nav bg.jpg','000001000001000051000021'),('7-0-style0000000000021','nav2_on_right.jpg','','style1/nav2_on_right.jpg',1147642497,1147642497,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_on_right.jpg nav2_on_right.jpg style1 nav2 on right.jpg','000001000001000051000020'),('7-0-style0000000000017','nav2_off_center.jpg','','style1/nav2_off_center.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_center.jpg nav2_off_center.jpg style1 nav2 off center.jpg','000001000001000051000016'),('7-0-style0000000000016','nav2_center_on.jpg','','style1/nav2_center_on.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_center_on.jpg nav2_center_on.jpg style1 nav2 center on.jpg','000001000001000051000015'),('7-0-style0000000000018','nav2_off_left.jpg','','style1/nav2_off_left.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav2_off_left.jpg nav2_off_left.jpg style1 nav2 off left.jpg','000001000001000051000017'),('7-0-style0000000000015','nav1_on_right.jpg','','style1/nav1_on_right.jpg',1147642496,1147642496,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_right.jpg nav1_on_right.jpg style1 nav1 on right.jpg','000001000001000051000014'),('7-0-style0000000000014','nav1_on_left.jpg','','style1/nav1_on_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on_left.jpg nav1_on_left.jpg style1 nav1 on left.jpg','000001000001000051000013'),('7-0-style0000000000013','nav1_on.jpg','','style1/nav1_on.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_on.jpg nav1_on.jpg style1 nav1 on.jpg','000001000001000051000012'),('7-0-style0000000000011','nav1_off_left.jpg','','style1/nav1_off_left.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_left.jpg nav1_off_left.jpg style1 nav1 off left.jpg','000001000001000051000010'),('7-0-style0000000000012','nav1_off_right.jpg','','style1/nav1_off_right.jpg',1147642495,1147642495,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_right.jpg nav1_off_right.jpg style1 nav1 off right.jpg','000001000001000051000011'),('7-0-style0000000000009','nav1_off.jpg','','style1/nav1_off.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off.jpg nav1_off.jpg style1 nav1 off.jpg','000001000001000051000008'),('7-0-style0000000000010','nav1_off_center.jpg','','style1/nav1_off_center.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_off_center.jpg nav1_off_center.jpg style1 nav1 off center.jpg','000001000001000051000009'),('7-0-style0000000000008','nav1_center_on.jpg','','style1/nav1_center_on.jpg',1147642494,1147642494,'3','7','12','WebGUI::Asset::File::Image',1,'nav1_center_on.jpg nav1_center_on.jpg style1 nav1 center on.jpg','000001000001000051000007'),('7-0-style0000000000006','main_bg.gif','','style1/main_bg.gif',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.gif main_bg.gif style1 main bg.gif','000001000001000051000005'),('7-0-style0000000000007','main_bg.jpg','','style1/main_bg.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'main_bg.jpg main_bg.jpg style1 main bg.jpg','000001000001000051000006'),('7-0-style0000000000004','gui_bottom.jpg','','style1/gui_bottom.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'gui_bottom.jpg gui_bottom.jpg style1 gui bottom.jpg','000001000001000051000003'),('7-0-style0000000000005','header.jpg','','style1/header.jpg',1147642493,1147642493,'3','7','12','WebGUI::Asset::File::Image',1,'header.jpg header.jpg style1 header.jpg','000001000001000051000004'),('7-0-style0000000000001','WebGUI 7 Style 1','','root/import/webgui-7-style-1',1147642492,1147642492,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI 7 Style 1 WebGUI 7 Style 1 root import webgui 7 style 1','000001000001000051'),('7-0-style0000000000002','body_bg.jpg','','style1/body_bg.jpg',1147642492,1147642492,'3','7','12','WebGUI::Asset::File::Image',1,'body_bg.jpg body_bg.jpg style1 body bg.jpg','000001000001000051000001'),('7-0-style0000000000003','css01.css','','style1/css01.css',1147642492,1147642492,'3','7','12','WebGUI::Asset::Snippet',0,'css01.css css01.css style1 css01.css body html  text-align:center margin:0px height:100 background-color:#494949  main  width:800px background url(\'^FileUrl(style1/main_bg.jpg repeat-y height:100 margin-left:auto margin-right:auto margin-top:0px margin-bottom:0px position:relative  body > main  height:auto min-height:100  main mainHeader  width:800px height:133px background url(\'^FileUrl(style1/header.jpg top left no-repeat margin-bottom:0px position:relative  main mainHeader title  position:absolute top:23px left:145px font-size:32pt font-family:arial color:white font-weight:bold  main mainHeader title a  color:white text-decoration:none  main mainContent  background url(\'^FileUrl(style1/orange_left01.jpg left top no-repeat width:100 height:100 margin-top:0px text-align:left border:solid red 0px  main > mainContent  margin-top:0px min-height:500px  main > mainContent > p  margin-top:0px  main mainContent mainText a:link  color:#FF7F23  main mainContent mainText a:visited  color:#D25900   LEVEL 1 AND 2 NAVIGATION  main mainNav_1 main mainNav_2  border-bottom:dashed DADADA 1px width:621px height:25px text-align:left position:relative margin-left:137px clear:both  main mainNav_1 a:link main mainNav_1 a:visited main mainNav_2 a:link main mainNav_2 a:visited  color:white text-decoration:none top:5px position:relative moz-box-sizing:border-box  main mainNav_1 a:hover,#main mainNav_2 a:hover  color:black  main mainNav_1 div left main mainNav_2 div left  width:12px height:25px display:block float:left background url(\'^FileUrl(style1/nav1_off_left.jpg no-repeat top left  main mainNav_2 div left  background url(\'^FileUrl(style1/nav2_off_left.jpg no-repeat top left  main mainNav_1 div center main mainNav_2 div center  height:25px display:block float:left background url(\'^FileUrl(style1/nav1_off_center.jpg repeat-x top left color:white font-family:arial verdana font-size:8pt  main mainNav_2 div center  background url(\'^FileUrl(style1/nav2_off_center.jpg repeat-x top left  main mainNav_1 div right main mainNav_2 div right  width:10px height:25px display:block float:left background url(\'^FileUrl(style1/nav1_off_right.jpg no-repeat top left  main mainNav_2 div right  background url(\'^FileUrl(style1/nav2_off_right.jpg no-repeat top left  main mainNav_1 div.navOn left  background url(\'^FileUrl(style1/nav1_on_left.jpg no-repeat top left  main mainNav_1 div.navOn center  background url(\'^FileUrl(style1/nav1_center_on.jpg repeat-x top left  main mainNav_1 div.navOn right  background url(\'^FileUrl(style1/nav1_on_right.jpg no-repeat top left  main mainNav_2 div.navOn left  background url(\'^FileUrl(style1/nav2_on_left.jpg no-repeat top left  main mainNav_2 div.navOn center  background url(\'^FileUrl(style1/nav2_center_on.jpg repeat-x top left  main mainNav_2 div.navOn right  background url(\'^FileUrl(style1/nav2_on_right.jpg no-repeat top left  main mainNav_1 div.navOn a:link main mainNav_1 div.navOn a:visited main mainNav_2 div.navOn a:link main mainNav_2 div.navOn a:visited  color:black   ENDOF LEVEL 1 AND 2 NAVIGATION  main crumbTrail  margin-left:177px margin-bottom:0px color:gray font-size:8pt font-weight:bold  main crumbTrail a.crumbTrail:visited main crumbTrail a.crumbTrail:link  color:silver font-size:8pt font-family:arial text-decoration:none font-weight:normal  main crumbTrail a.crumbTrail:hover  color:gray  main mainText  padding-left:150px font-family:verdana font-size:9pt width:600px margin-top:0px  main gui  bottom:0px left:0px position:absolute width:135px font-size:8pt color:black font-family:arial text-align:right  main gui loginBox  padding-right:12px moz-box-sizing:border-box width:100px float:right margin-bottom:10px  main gui loginBox loginBoxField  width:75px  main gui loginBox loginBoxButton  background-color:#D65501 color:white border:solid white 2px margin-top:4px font-variant:small-caps  main gui a  color:white  copyright  color:#fff position:absolute top:110px right:40px font-family:verdana font-size:8pt font-weight:bold background-color:#2D2D2D opacity:0.4 moz-opacity:0.4 khtml-opacity:0.4 padding:2px   html copyright  background transparent ','000001000001000051000002'),('7F-BuEHi7t9bPi008H8xZQ','Default Survey Summary','','root/import/survey/default-survey-summary',1239248021,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Summary Default Survey Summary root import survey default survey summary Survey/Summary','000001000001000044000012'),('CSN-ZON7Uwv8kxf3F1fh5Q','ZipArchiveAsset','','root/import/ziparchiveasset',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ZipArchiveAsset ZipArchiveAsset root import ziparchiveasset','000001000001000055'),('TCtybxdqmdwdvRn555zpCQ','RichEdit','','root/import/richedit',1147642484,1147642484,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'RichEdit RichEdit root import richedit','000001000001000034'),('NywJYmGWe1f6EBXJnWg9Xg','Profile','','root/import/profile',1222803606,1222803638,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Profile Profile root import profile','000001000001000030'),('9wKWdum0_8z-OhhquWLtSQ','WeatherData','','root/import/weatherdata',1147642483,1147642483,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WeatherData WeatherData root import weatherdata','000001000001000050'),('AgyFhx3eXlfZXNp2MkrsiQ','Edit','','root/import/profile/edit',1147642477,1222803665,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Edit Edit root import profile edit','000001000001000030000001'),('F7MAQ-cpuvQ1KuC7J4P5zQ','View','','root/import/profile/view',1147642477,1222803673,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'View View root import profile view','000001000001000030000002'),('oGfxez5sksyB_PcaAsEm_Q','SyndicatedContent','','root/import/syndicatedcontent',1147642482,1247053097,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SyndicatedContent SyndicatedContent root import syndicatedcontent','000001000001000045'),('5bnNzteN7w3NnK9mF4XiCg','Survey','','root/import/survey',1147642481,1250243000,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Survey Survey root import survey','000001000001000044'),('Efe2W0UgrSRDltNJ87jlfg','StockData','','root/import/stockdata',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'StockData StockData root import stockdata','000001000001000041'),('bbiA9Zq5Gy2oCFBlILO3QA','SQLReport','','root/import/sqlreport',1147642480,1147642480,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'SQLReport SQLReport root import sqlreport','000001000001000040'),('RrV4aAPnn4dM0ZcU3OXnlw','style','','root/import/style',1147642480,1286941427,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'style style root import style','000001000001000043'),('Ik9HHky10DIyFTKehUD1dw','Prompt','','root/import/prompt',1147642479,1222803478,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Prompt Prompt root import prompt','000001000001000032'),('f_tn9FfoSfKWX43F83v_3w','Search','','root/import/search',1147642479,1247053009,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Search Search root import search','000001000001000036'),('Da6KWn805L4B5e4HFgQRQA','Shortcut','','root/import/shortcut',1147642479,1147642479,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shortcut Shortcut root import shortcut','000001000001000039'),('TYo2Bwl7aafzTtdHlS-arQ','Product','','root/import/product',1147642478,1211664878,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Product Product root import product','000001000001000028'),('VZK3CRgiMb8r4dBjUmCTgQ','Poll','','root/import/poll',1147642477,1247046242,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Poll Poll root import poll','000001000001000027'),('jEz8iTGNWEt2I05IhVV19Q','Operation/RedeemSubscription','','root/import/operation/redeemsubscription',1147642477,1289360563,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Operation/RedeemSubscription Operation/RedeemSubscription root import operation redeemsubscription','000001000001000038000016'),('BFfNj5wA9bDw8H3cnr8pTw','Navigation','','root/import/navigation',1147642475,1247046273,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Navigation Navigation root import navigation','000001000001000025'),('bBzO4CWjqU_ile3gf5Iypw','MultiSearch','','root/import/multisearch',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MultiSearch MultiSearch root import multisearch','000001000001000024'),('cj2y4papTVGZRFdwTI-_fw','MessageBoard','','root/import/messageboard',1147642475,1147642475,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'MessageBoard MessageBoard root import messageboard','000001000001000023'),('3womoo7Teyy2YKFa25-MZg','Address Book (Default)','','shopping-cart-collateral-items/address-book-default',1212098997,1289360562,'3','7','3','WebGUI::Asset::Template',0,'Address Book Default Address Book Default shopping cart collateral items address book default Shop/AddressBook','000001000001000038000013'),('g8W53Pd71uHB9pxaXhWf_A','My Purchases Detail (Default)','','shopping-cart-collateral-items/my-purchases-detail-default',1213184121,1289360563,'3','7','3','WebGUI::Asset::Template',0,'My Purchases Detail Default My Purchases Detail Default shopping cart collateral items my purchases detail default Shop/MyPurchasesDetail','000001000001000038000015'),('-WM2dt0ZGpDasuL2wWocxg','ProjectManager','','root/import/projectmanager',1222803056,1222803056,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ProjectManager ProjectManager root import projectmanager','000001000001000031'),('LdiozcIUciWuvt3Z-na5Ww','Matrix','','root/import/matrix',1147642474,1281501162,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Matrix Matrix root import matrix','000001000001000022'),('default_post_received1','Default Post Received','','default_post_received',1222708029,1277868922,'3','7','4','WebGUI::Asset::Template',0,'Default Post Received Default Post Received default post received Collaboration/PostReceived','000001000001000008000029'),('aNNC62qLAS6TB-0_MCYjsw','Layout','','root/import/layout',1147642471,1246969327,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Layout Layout root import layout','000001000001000019'),('GYaFxnMu9UsEG8oanwB6TA','Folder','','root/import/folder',1147642470,1246965871,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Folder Folder root import folder','000001000001000014'),('N13SD1Fpqk00UgBt1Z8ivQ','HttpProxy','','root/import/httpproxy',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'HttpProxy HttpProxy root import httpproxy','000001000001000016'),('tPagC0AQErZXjLFZQ6OI1g','ImageAsset','','root/import/imageasset',1147642470,1246966459,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ImageAsset ImageAsset root import imageasset','000001000001000017'),('3uuBf8cYuj1sew2OJXl9tg','InOutBoard','','root/import/inoutboard',1147642470,1147642470,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'InOutBoard InOutBoard root import inoutboard','000001000001000018'),('PBtmpl0000000000000005','Default LDAP Anonymous Registration Template','','default_ldap_anonymous_registration_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default LDAP Anonymous Registration Template Default LDAP Anonymous Registration Template default ldap anonymous registration template Auth/LDAP/Create','000001000001000005000002000001'),('PBtmpl0000000000000011','Default WebGUI Anonymous Registration Template','','default_webgui_anonymous_registration_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Anonymous Registration Template Default WebGUI Anonymous Registration Template default webgui anonymous registration template Auth/WebGUI/Create','000001000001000005000005000001'),('tXwf1zaOXTvsqPn6yu-GSw','FileAsset','','root/import/fileasset',1147642469,1246965607,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'FileAsset FileAsset root import fileasset','000001000001000013'),('S1A9iAwKcQQ6P20uTqw-Ew','Dashboard','','root/import/dashboard',1147642468,1147642468,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Dashboard Dashboard root import dashboard','000001000001000009'),('-K8Hj45mbelljN9-0CXZxg','DataForm','  ','root/import/dataform',1147642468,1257311887,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'DataForm DataForm root import dataform','000001000001000010'),('GNOAsX98vCsl0JRwfwL-gg','Collaboration','','root/import/collaboration',1147642466,1277868921,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Collaboration Collaboration root import collaboration','000001000001000008'),('pbproto000000000000002','Request Tracker','','request-tracker-prototype',1147642465,1163019036,'3','7','12','WebGUI::Asset::Wobject::Collaboration',1,'Request Tracker Request Tracker request tracker prototype','000001000001000033'),('pbtmpl0000000000000220','Flash Style 3 Template','','flash-style-3-template',1147642465,1247488979,'3','7','12','WebGUI::Asset::Template',0,'Flash Style 3 Template Flash Style 3 Template flash style 3 template FileAsset','000001000001000013000002'),('pbtmpl0000000000000221','Flash Tutorial Template','','flash-tutorial-template',1147642465,1247487940,'3','7','12','WebGUI::Asset::Template',0,'Flash Tutorial Template Flash Tutorial Template flash tutorial template FileAsset','000001000001000013000003'),('nbSrhXZQuxIjhWFaFPSuVA','AdminConsole','','root/import/adminconsole',1147642465,1147642465,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'AdminConsole AdminConsole root import adminconsole','000001000001000003'),('TvOZs8U1kRXLtwtmyW75pg','Article','','root/import/article',1147642465,1256092368,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Article Article root import article','000001000001000004'),('PBtmpl0000000000000027','Default Forum Notification','','default_forum_notification',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default Forum Notification Default Forum Notification default forum notification Collaboration/Notification','000001000001000008000015'),('-PkdI8l1idu-8gDX3iOdcw','One Over Two','','one_over_two',1247482172,1259133274,'3','7','12','WebGUI::Asset::Template',0,'One Over Two One Over Two one over two Layout','000001000001000019000007'),('FEDP3dk8J3Chw_gyr7_XEQ','navigation.css','','navigation.css',1246278679,1246278679,'3','7','12','WebGUI::Asset::Snippet',0,'navigation.css navigation.css navigation.css Horizontal Menu styles horizontalMenu ul.menu  padding 0 margin 0 0 1em list-style none width 100 clear floated li elements overflow auto clear floated li elements  horizontalMenu ul.menu li  float left  horizontalMenu ul.menu li a  float left padding 4px 8px margin-right 1px background ddd color 000 text-decoration none  horizontalMenu ul.menu li.current a  background:#eee  horizontalMenu ul.menu li a:hover  background:#fff  Tabs tabbed navigation styles tabsMenu ul.menu  margin 0 0 1em  tabsMenu ul.menu li  display inline  tabsMenu ul.menu li a  border 1px solid 999 border-bottom 0 padding 5px 10px 2px color 777 text-decoration:none  tabsMenu ul.menu li.current a tabsMenu ul.menu li a:hover  border 1px solid 000 border-bottom 0 color 000  Indent Nav styles indentMenu a.level0  margin-left:0px display:block  indentMenu a.level1  margin-left:15px display:block  indentMenu a.level2  margin-left:30px display:block  indentMenu a.level3  margin-left:45px display:block  indentMenu a.level4  margin-left:60px display:block ','000001000001000025000028'),('PBnav00000000indentnav','Indent Nav','','indent_nav',1148579525,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Indent Nav Indent Nav indent nav Navigation','000001000001000025000027'),('PBtmpl0000000000000085','Default Email','','default_email',1124395696,1288142105,'3','7','12','WebGUI::Asset::Template',0,'Default Email Default Email default email DataForm','000001000001000010000002'),('PBnav00000000000bullet','Bulleted List','','bulleted_list',1148579524,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Bulleted List Bulleted List bulleted list Navigation','000001000001000025000026'),('StockDataTMPL000000002','StockData Default Display','','stockdatatmpl000000002',1133743239,1229494994,'3','7','12','WebGUI::Asset::Template',0,'StockData Default Display StockData Default Display stockdatatmpl000000002 StockData/Display','000001000001000041000001'),('2OcUWHVsu_L1sDFzIMWYqw','TimeTracking','','root/import/timetracking',1222803070,1222803070,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'TimeTracking TimeTracking root import timetracking','000001000001000048'),('PBtmpl0000000000000014','Default WebGUI Password Recovery Template','','default_webgui_password_recovery_template',1124395696,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Password Recovery Template Default WebGUI Password Recovery Template default webgui password recovery template Auth/WebGUI/Recovery2','000001000001000005000008000001'),('ProjectManagerTMPL0006','Default Resource List','','default-pm-resource-list',1157679165,1157679165,'3','7','12','WebGUI::Asset::Template',0,'Default Resource List Default Resource List default pm resource list ProjectManager_resourceList','000001000001000031000005000001'),('ProjectManagerTMPL0005','Default Resource Popup','','default-pm-resource-popup',1157679165,1229579830,'3','7','12','WebGUI::Asset::Template',0,'Default Resource Popup Default Resource Popup default pm resource popup ProjectManager_resourcePopup','000001000001000031000005000002'),('PBtmpl0000000000000032','Default Thread','','default_thread',1124395696,1277868921,'3','7','12','WebGUI::Asset::Template',0,'Default Thread Default Thread default thread Collaboration/Thread','000001000001000008000014'),('WeatherDataTmpl0000001','WeatherData Default View','','weatherdatatmpl0000001',1133743239,1210711353,'3','7','12','WebGUI::Asset::Template',0,'WeatherData Default View WeatherData Default View weatherdatatmpl0000001 WeatherData','000001000001000050000001'),('PBasset000000000000001','Root','','root',1124395696,1124395696,'3','7','3','WebGUI::Asset',0,'Root Root root','000001'),('PBrichedit000000000001','Content Manager\'s Rich Edit','','content_managers_rich_edit',1124395696,1256092369,'3','7','12','WebGUI::Asset::RichEdit',0,'Content Manager\'s Rich Edit Content Manager\'s Rich Edit content managers rich edit','000001000001000034000001'),('PBrichedit000000000002','Forum Rich Edit','','forum_rich_edit',1124395696,1124395696,'3','7','12','WebGUI::Asset::RichEdit',0,'Forum Rich Edit Forum Rich Edit forum rich edit','000001000001000034000002'),('SynConXSLT000000000001','RSS 0.9 XSLT Stylesheet','','xslt/rss0.9.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 0.9 XSLT Stylesheet RSS 0.9 XSLT xslt rss0.9.xsl You\'re viewing an RSS version 0.9 feed Please use an RSS feed reader to view this content as intended','000001000001000045000003'),('SynConXSLT000000000002','RSS 0.91 XSLT Stylesheet','','xslt/rss0.91.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 0.91 XSLT Stylesheet RSS 0.91 XSLT xslt rss0.91.xsl You\'re viewing an RSS version 0.91 feed Please use an RSS feed reader to view this content as intended','000001000001000045000004'),('SynConXSLT000000000003','RSS 1.0 XSLT Stylesheet','','xslt/rss1.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 1.0 XSLT Stylesheet RSS 1.0 XSLT xslt rss1.0.xsl You\'re viewing an RSS version 1.0 feed Please use an RSS feed reader to view this content as intended  ','000001000001000045000005'),('SynConXSLT000000000004','RSS 2.0 XSLT Stylesheet','','xslt/rss2.0.xsl',1124395707,1124395707,'3','7','12','WebGUI::Asset::Snippet',0,'RSS 2.0 XSLT Stylesheet RSS 2.0 XSLT xslt rss2.0.xsl You\'re viewing an RSS version 2.0 feed Please use an RSS feed reader to view this content as intended ','000001000001000045000006'),('vrKXEtluIhbmAS9xmPukDA','Donation (Default)','','root/import/default-donation-template',1212092352,1289360562,'3','7','12','WebGUI::Asset::Template',0,'Donation Default Donation Default root import default donation template Donation','000001000001000038000010'),('eqb9sWjFEVq0yHunGV8IGw','Subscription (Default)','','root/import/subscription-default',1213182595,1289360562,'3','7','12','WebGUI::Asset::Template',0,'Subscription Default Subscription Default root import subscription default Subscription','000001000001000038000012'),('PBtmpl0000000000000036','Default Admin Toggle Macro','','default_admin_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Admin Toggle Macro Default Admin Toggle Macro default admin toggle macro Macro/AdminToggle','000001000001000021000001000001'),('PBtmpl0000000000000037','Default Account Macro','','default_account_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Account Macro Default Account Macro default account macro Macro/a_account','000001000001000021000002000001'),('PBtmpl0000000000000038','Default Editable Toggle Macro','','default_editable_toggle_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Editable Toggle Macro Default Editable Toggle Macro default editable toggle macro Macro/EditableToggle','000001000001000021000003000001'),('PBtmpl0000000000000040','Default Group Add Macro','','default_group_add_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Group Add Macro Default Group Add Macro default group add macro Macro/GroupAdd','000001000001000021000005000001'),('PBtmpl0000000000000041','Default Group Delete Macro','','default_group_delete_macro',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Group Delete Macro Default Group Delete Macro default group delete macro Macro/GroupDelete','000001000001000021000006000001'),('PBtmpl0000000000000042','Default Homelink','','default_homelink',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Homelink Default Homelink default homelink Macro/H_homeLink','000001000001000021000007000001'),('PBtmpl0000000000000043','Default LoginToggle','','default_logintoggle',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default LoginToggle Default LoginToggle default logintoggle Macro/LoginToggle','000001000001000021000008000001'),('PBtmpl0000000000000045','Default Make Printable','','default_make_printable',1124395696,1129049186,'3','7','12','WebGUI::Asset::Template',0,'Default Make Printable Default Make Printable default make printable Macro/r_printable','000001000001000021000011000001'),('PBtmpl0000000000000091','File no icon','','file_no_icon',1124395696,1129049189,'3','7','12','WebGUI::Asset::Template',0,'File no icon File no icon file no icon Macro/File','000001000001000021000004000002'),('MK4fCNoyrx5SE8eyDfOpxg','Flash File','','flash-file',1247489252,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Flash File Flash File flash file FileAsset','000001000001000013000004'),('PBtmpl0000000000000132','Empty','','empty',1124395696,1258524916,'3','7','12','WebGUI::Asset::Template',0,'Empty Empty empty style','000001000001000043000004'),('PBtmpl0000000000000140','Default Shortcut','','pbtmpl0000000000000140',1124395696,1129573244,'3','7','12','WebGUI::Asset::Template',0,'Default Shortcut Default Shortcut pbtmpl0000000000000140 Shortcut','000001000001000039000001'),('hkj6WeChxFyqfP85UlRP8w','matrix.css','','new-matrix/matrix.css',1232664229,1281501163,'3','7','12','WebGUI::Asset::Snippet',0,'matrix.css matrix.css new matrix matrix.css wg-clear  display inline clear both font-size:0px line-height:0px   COLUMN STYLES  matrixLeft  float:left width:65 padding:1 min-height:1 background-color:#d2d2d2 moz-border-radius:4px webkit-border-radius 4px  matrixRight  float:left width:25 padding:0px min-height:1 moz-border-radius:4px webkit-border-radius 4px border solid silver 1px background-color:white margin-left:5px   DROPSHADOW BUTTONS  matrixLeft buttons span  background-color:#888 position:relative padding:5px 0px 0px 0px moz-border-radius:4px webkit-border-radius 4px  matrixLeft buttons button matrixLeft buttons a#return  border:solid 2f495e 2px position:relative background-color:#e1e1e1 padding:auto 3px margin:0px font-size:11px line-height:13px position:relative top:-6px left:-2px height:22px cursor:pointer moz-border-radius:4px webkit-border-radius 4px font-weight:bold text-decoration:none color:#333  matrixLeft buttons a#return  font-size:10px padding:3px 10px 2px 10px  matrixLeft buttons button:hover matrixLeft buttons a#return:hover  border-color:black color:white background-color:#444   WHITE AREA FOR THE LISTING OF OBJECTS TO COMPARE  matrixLeft matrixListing  background-color:white height:300px min-height:300px moz-border-radius:4px webkit-border-radius 4px margin:10px 2px 20px 2px padding:auto 10px  matrixLeft matrixListing table  border-collapse:collapse margin:0px padding:0px display:block  matrixLeft matrixListing table a:link  font-size:12px color:#111  matrixLeft matrixListing table a:visited  color:#333 font-size:12px text-decoration:none  matrixLeft matrixListing table a:hover  text-decoration:none   GRAY BAR THAT HOLDS THE SORT BUTTONS  matrixLeft matrixListing sortButtons  background-color:#f1f1f1 border:solid silver 1px moz-border-radius-topLeft:4px moz-border-radius-topRight:4px webkit-border-radius-topLeft 4px webkit-border-radius-topRight 4px border-bottom:solid D2D2D2 2px display:block   STYLES TO OVERRIDE THE SORT BUTTON CSS BUILT INTO THE PERL CODE  sortByViews-button sortByCompares-button sortByUpdated-button sortByClicks-button sortByName-button  background none white-space:nowrap border-style:none cursor:pointer padding-bottom:4px border-style:none background-color:transparent border-right:solid silver 1px color:#555  sortByViews-button:hover sortByCompares-button:hover sortByUpdated-button:hover sortByClicks-button:hover sortByName-button:hover  color:black   MATRIX STATISTICS  matrixRight mainTitle  font-size:20px padding:5px 10px border-bottom solid gray 1px background-color:#d2d2d2  matrixRight textBox  border-top:solid silver 1px padding:10px 5px  matrixStatistics  padding:10px  matrixStatistics title  font-weight:bold background-color:#f1f1f1 padding:2px 5px font-size:11px moz-border-radius:4px border:solid d2d2d2 1px  matrixStatistics statistics  margin-bottom:15px  matrixStatistics label  text-align:right width:100px font-size:10px  matrixStatistics data  font-size:10px  matrixStatistics data a  color:#111  matrixStatistics data a:hover  text-decoration:none   LINKS TO CONTROL ADMIN FUNCTIONS  adminLinks  background-color:#f1f1f1  adminLinks a:link adminLinks a:visited  display:block text-align:center text-decoration:none color:#555 font-weight:normal font-size:10px padding:2px 5px border-top:solid silver 1px  adminLinks a:hover  color:black  adminLinks a.newLink:link adminLinks a.newLink:visited  background-color:#3498d1 color:white display:block  adminLinks a.newLink:hover  background-color:#39a6e5   STYLE FOR THE DETAILED LISTING  matrixDetail  min-width:1000px  matrixDetail editBtns  font-size:9px line-height:11px vertical-align:middle font-weight:normal margin-left:10px  matrixDetail editBtns a  color:black text-decoration:underline  matrixDetail editBtns a:hover  text-decoration:none  matrixDetail stats screenshot  float:left margin-right:20px  matrixDetail commentsMail strong.title  margin-bottom:0px margin-top:20px display:block background-color:#d2d2d2 padding:2px 10px border:solid 1px gray border-bottom-color:silver moz-border-radius-topLeft:4px moz-border-radius-topRight:4px  matrixDetail assetAspectComments  margin:0px 0px 20px 0px border:solid gray 1px background-color:#f1f1f1 moz-border-radius-bottomLeft:4px moz-border-radius-bottomRight:4px  matrixDetail assetAspectComments assetAspectComment  border-top:solid silver 1px border-bottom:solid gray 1px padding:3px background-color:#f5f5f5  matrixDetail assetAspectComments assetAspectCommentForm  border-top:solid d2d2d2 5px padding:20px  matrixDetail stats ul matrixDetail stats ul li  list-style-type:none margin:0px padding:0px  matrixDetail stats ul li  display:block line-height:20px margin:4px 0px  matrixDetail stats ul li strong  display:block float:left width:130px text-align:right background-color:#f1f1f1 padding-right:5px margin-right:5px moz-border-radius:4px webkit-border-radius:3px font-size:11px border:solid d2d2d2 1px  showLink  background-color:#e1e1e1 border:2px solid 2F495E moz-border-radius:4px webkit-border-radius:4px padding:3px 10px text-decoration:none color:black  showLink:hover hideLink:hover  background-color:#555 color:white  hideLink  background-color:#f1f1f1 border:2px solid 2F495E border-bottom-style:none moz-border-radius-topLeft:4px moz-border-radius-topRight:4px webkit-border-radius-topLeft:4px webkit-border-radius-topRight:4px padding:3px 10px text-decoration:none color:black  matrixMail  background-color:#f1f1f1 padding:15px border:2px solid 2F495E moz-border-radius:4px moz-border-radius-topLeft:0px webkit-border-radius:4px webkit-border-radius-topLeft:0px margin-top:1px  matrixMail  tableData  padding:5px margin:0px  matrixMail  input  padding:0px margin:0px  matrixMail  formDescription  text-align:right vertical-align:middle padding-right:10px font-weight:bold  matrixMail form  img  margin-top:-18px  matrixMail verify_formId  height:45px line-height:45px font-size:35px padding:0px margin:0px margin-right:20px  matrixRatings  width:264px position:relative left:-2px top:12px  matrixRatings table  margin-left:0px  matrixRatings td  overflow:hidden  matrixRatings formDescription  text-align:right background-color:#97BCD1 border:solid 4D606B 1px padding:2px 5px font-weight:bold font-size:10x moz-border-radius:4px webkit-border-radius:4px color:#333  matrixRatings formDescription a:before  text-decoration:none  matrixRatings formDescription a  display:block color:red text-decoration:none  matrixRatings formDescription a:hover  text-decoration:underline  matrixAttributes  float:left width:40 min-width:20 max-width:45 margin-right:20px  rightDetails  float:left width:20 min-width:20 max-width:45  attributes  border:solid d2d2d2 1px background-color:#f1f1f1 margin-top:10px moz-border-radius:4px webkit-border-radius:4px padding:10px  attributes table  border-collapse:collapse padding:0px margin:0px  attributes table  td  padding:2px margin:0px  yui-dt0-col-value  font-weight:bold font-size:14px padding:3px white-space:no-wrap   COMPARISON STYLES  compareList table  border-collapse:collapse border:solid silver 1px margin-top:5px  compareList table  th a  color:black padding:1px 5px  compareList table  td  background-color:#f1f1f1 border-top:solid gray 1px border-bottom:solid silver 1px  compareList yui-dt-liner  color:#39A6E5  compareList yui-dt-col-name yui-dt-liner  font-style:italic font-size:10px color:#555  compareList yui-dt-col-name yui-dt-liner b  font-size:15px font-style:normal padding-right:25px color:black ','000001000001000022000006'),('ZipArchiveTMPL00000001','Default Zip Archive Template','','zip-archive-template',1133743240,1169738426,'3','7','12','WebGUI::Asset::Template',0,'Default Zip Archive Template Default Zip Archive Template zip archive template ZipArchiveAsset','000001000001000055000001'),('PBasset000000000000002','Import Node','','root/import',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Import Node Import root import','000001000001'),('_iHetEvMQUOoxS-T2CM0sQ','Getting Started','','getting_started',1124395696,1273172789,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Getting Started Getting Started getting started','000001000002000001'),('x3OFY6OJh_qsXkZfPwug4A','Site Map','','site_map',1124395696,1271348790,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Site Map Site Map site map','000001000002000005'),('PBnav00000000000000001','crumbTrail','','crumbtrail',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'crumbTrail crumbTrail crumbtrail','000001000001000025000008'),('PBnav00000000000000002','SpecificSubMenuVertical','','specificsubmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuVertical SpecificSubMenuVertical specificsubmenuvertical','000001000001000025000017'),('PBnav00000000000000006','SpecificSubMenuHorizontal','','specificsubmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificSubMenuHorizontal SpecificSubMenuHorizontal specificsubmenuhorizontal','000001000001000025000018'),('PBnav00000000000000007','TopLevelMenuVertical','','toplevelmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuVertical TopLevelMenuVertical toplevelmenuvertical','000001000001000025000019'),('PBnav00000000000000008','TopLevelMenuHorizontal','','toplevelmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopLevelMenuHorizontal TopLevelMenuHorizontal toplevelmenuhorizontal','000001000001000025000020'),('PBnav00000000000000009','RootTab','','roottab',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'RootTab RootTab roottab','000001000001000025000021'),('PBnav00000000000000010','TopDropMenu','','topdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'TopDropMenu TopDropMenu topdropmenu','000001000001000025000022'),('PBnav00000000000000011','dtree','','dtree',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'dtree dtree dtree','000001000001000025000023'),('PBnav00000000000000012','coolmenu','','coolmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'coolmenu coolmenu coolmenu','000001000001000025000024'),('PBnav00000000000000013','Synopsis','','synopsis',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Synopsis Synopsis synopsis','000001000001000025000025'),('PBnav00000000000000014','FlexMenu','','flexmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'FlexMenu FlexMenu flexmenu','000001000001000025000009'),('PBnav00000000000000015','currentMenuVertical','','currentmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuVertical currentMenuVertical currentmenuvertical','000001000001000025000010'),('PBnav00000000000000016','currentMenuHorizontal','','currentmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'currentMenuHorizontal currentMenuHorizontal currentmenuhorizontal','000001000001000025000011'),('PBnav00000000000000017','PreviousDropMenu','','previousdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'PreviousDropMenu PreviousDropMenu previousdropmenu','000001000001000025000012'),('PBnav00000000000000018','previousMenuVertical','','previousmenuvertical',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuVertical previousMenuVertical previousmenuvertical','000001000001000025000013'),('PBnav00000000000000019','previousMenuHorizontal','','previousmenuhorizontal',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'previousMenuHorizontal previousMenuHorizontal previousmenuhorizontal','000001000001000025000014'),('PBnav00000000000000020','rootmenu','','rootmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'rootmenu rootmenu rootmenu','000001000001000025000015'),('PBnav00000000000000021','SpecificDropMenu','','specificdropmenu',1124395696,1124395696,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'SpecificDropMenu SpecificDropMenu specificdropmenu','000001000001000025000016'),('pJd5TLAjfWMVXD6sCRLwUg','Site Map','','site_map/site_map',1124395696,1271348790,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'Site Map Site Map site map site map','000001000002000005000001'),('fK-HMSboA3uu0c1KYkYspA','The Latest News','This is the latest news from Plain Black and WebGUI pulled directly from the site every hour.','the_latest_news/the_latest_news',1124395696,1124395696,'3','7','3','WebGUI::Asset::Wobject::SyndicatedContent',1,'The Latest News The Latest News the latest news the latest news This is the latest news from Plain Black and WebGUI pulled directly from the site every hour','000001000002000004000001'),('WikiFrontTmpl000000001','Default Wiki Front Page','','default-wiki-front-page',1165460175,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Front Page Default Wiki Front Page default wiki front page WikiMaster_front','000001000001000054000002'),('WikiSearchTmpl00000001','Default Wiki Search','','default-wiki-search',1165460175,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Search Default Wiki Search default wiki search WikiMaster_search','000001000001000054000003'),('WikiPHTmpl000000000001','Default Page History','','default-wiki-page-history',1165460175,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Default Page History Default Page History default wiki page history WikiPage_pageHistory','000001000001000054000004'),('WikiPageTmpl0000000001','Default Wiki Page','','default-wiki-page',1165460175,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Page Default Wiki Page default wiki page WikiPage','000001000001000054000005'),('WikiPageEditTmpl000001','Default Wiki Page Edit','','default-wiki-page-edit',1165460175,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Default Wiki Page Edit Default Wiki Page Edit default wiki page edit WikiPage_edit','000001000001000054000006'),('WikiMPTmpl000000000001','Default Most Popular','','default-wiki-most-popular',1165460175,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Default Most Popular Default Most Popular default wiki most popular WikiMaster_mostPopular','000001000001000054000007'),('SQLReportDownload00001','SQLReport Download Default Template','','SQLReportDownload0001',1171466654,1171466654,'3','7','12','WebGUI::Asset::Template',0,'SQLReport Download Default Template untitled SQLReportDownload0001 SQLReport/Download','000001000001000040000002'),('newsletter000000000001',' Summary Newsletter (default)','','newsletterdefaulttemplate',1185754569,1185754569,'3','7','3','WebGUI::Asset::Template',0,'Summary Newsletter default Summary Newsletter newsletterdefaulttemplate newsletter','000001000001000026000001'),('newslettersubscrip0001','My Subscriptions (default)','','newslettermysubscriptionstemplate',1185754569,1221692339,'3','7','3','WebGUI::Asset::Template',0,'My Subscriptions default My Subscriptions newslettermysubscriptionstemplate newsletter/mysubscriptions','000001000001000026000003'),('AjhlNO3wZvN5k4i4qioWcg','Default Answer Edit','','root/import/survey/default-answer-edit',1226009658,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Answer Edit Default Answer Edit root import survey default answer edit Survey/Edit','000001000001000044000009'),('QHn6T9rU7KsnS3Y70KCNTg','Account','','root/import/account',1227080251,1233173545,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Account Account root import account','000001000001000002'),('HPDOcsj4gBme8D4svHodBw','Profile','','root/import/account/profile',1225404573,1285733367,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Profile Profile root import account profile','000001000001000002000001'),('WikiKeyword00000000001',' Wiki Pages By Keyword (default)','','wiki-master-by-keyword-template.tmpl',1185754571,1274238756,'3','7','3','WebGUI::Asset::Template',0,'Wiki Pages By Keyword default Wiki Pages By Keyword wiki master by keyword template.tmpl WikiMaster_byKeyword','000001000001000054000008'),('tempspace0000000000000','Tempspace','','tempspace',1185754574,1185754574,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Tempspace Tempspace tempspace','000001000004'),('QpmlAiYZz6VsKBM-_0wXaw','UsersOnline Macro','  ','users-online-macro-templates',1224616691,1224616691,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'UsersOnline Macro UsersOnline Macro users online macro templates','000001000001000021000012'),('h_T2xtOxGRQ9QJOR6ebLpQ','UsersOnline Default View','','users-online-macro-templates/usersonline-default-view',1224616545,1224616545,'3','7','3','WebGUI::Asset::Template',0,'UsersOnline Default View UsersOnline Default View users online macro templates usersonline default view Macro/UsersOnline','000001000001000021000012000001'),('4Ekp0kJoJllRRRo_J1Rj6w','UsersOnline Detailed View','','users-online-macro-templates/usersonline-detailed-view',1224616672,1224616672,'3','7','3','WebGUI::Asset::Template',0,'UsersOnline Detailed View UsersOnline Detailed View users online macro templates usersonline detailed view Macro/UsersOnline','000001000001000021000012000002'),('THQhn1C-ooj-TLlEP7aIJQ','gallery-ie.css','','root/import/gallery-templates/gallery-ie.css',1225313951,1284523760,'3','7','3','WebGUI::Asset::Snippet',0,'gallery-ie.css gallery-ie.css root import gallery templates gallery ie.css wgPicture  float:left  wgAlbum  float:left  wgGallery pagination li wgGallery pagination a  float:left  wgGallery container  display:inline-block ','000001000001000015000025'),('itransact_credentials1','ITransact Credentials (Default)','','shopping-cart-collateral-items/itransact-credentials',1228953856,1289360563,'3','7','4','WebGUI::Asset::Template',0,'ITransact Credentials Default ITransact Credentials Default shopping cart collateral items itransact credentials Shop/Credentials','000001000001000038000018'),('1oBRscNIcFOI-pETrCOspA','Default Section Edit','','root/import/survey/default-section-edit',1226009642,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Section Edit Default Section Edit root import survey default section edit Survey/Edit','000001000001000044000007'),('gI_TxK-5S4DNuv42wpImmw','Gallery Templates','  ','root/import/gallery-templates',1197330678,1284523756,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Gallery Templates Gallery Templates root import gallery templates','000001000001000015'),('jME5BEDYVDlBZ8jIQA9-jQ','Default Gallery Search','','root/import/gallery-templates/default-gallery-search',1197927169,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Search Default Gallery Search root import gallery templates default gallery search Gallery/Search','000001000001000015000001'),('azCqD0IjdQSlM3ar29k5Sg','Default Gallery List Albums View','','root/import/gallery-templates/default-gallery-list-albums-view',1197881748,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Albums View Default Gallery List Albums View root import gallery templates default gallery list albums view Gallery/ListAlbums','000001000001000015000002'),('05FpjceLYhq4csF1Kww1KQ','Default Gallery View Album','','root/import/gallery-templates/default-gallery-view-album',1197879361,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album Default Gallery View Album root import gallery templates default gallery view album GalleryAlbum/View','000001000001000015000003'),('KAMdiUdJykjN02CPHpyZOw','Default Gallery View Album Slideshow','','root/import/gallery-templates/default-gallery-view-album-slideshow',1197825787,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album Slideshow Default Gallery View Album Slideshow root import gallery templates default gallery view album slideshow GalleryAlbum/ViewSlideshow','000001000001000015000005'),('OkphOEdaSGTXnFGhK4GT5A','Default Gallery List Files For User','','root/import/gallery-templates/default-gallery-list-files-for-user',1197825794,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Files For User Default Gallery List Files For User root import gallery templates default gallery list files for user Gallery/ListFilesForUser','000001000001000015000006'),('TEId5V-jEvUULsZA0wuRuA','Default Gallery View Photo','','root/import/gallery-templates/default-gallery-view-photo',1197989443,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Photo Default Gallery View Photo root import gallery templates default gallery view photo GalleryFile/View','000001000001000015000007'),('6X-7Twabn5KKO_AbgK3PEw','Default Gallery Edit Album','','root/import/gallery-templates/default-gallery-edit-album',1197987780,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Edit Album Default Gallery Edit Album root import gallery templates default gallery edit album GalleryAlbum/Edit','000001000001000015000008'),('7JCTAiu1U_bT9ldr655Blw','Default Gallery Edit Photo','','root/import/gallery-templates/default-gallery-edit-photo',1197825824,1284523757,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Edit Photo Default Gallery Edit Photo root import gallery templates default gallery edit photo GalleryFile/Edit','000001000001000015000009'),('0X4Q3tBWUb_thsVbsYz9xQ','Default Gallery Add Archive','','root/import/gallery-templates/default-gallery-add-archive',1197987372,1284523757,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Add Archive Default Gallery Add Archive root import gallery templates default gallery add archive GalleryAlbum/AddArchive','000001000001000015000010'),('m3IbBavqzuKDd2PGGhKPlA','Default Gallery Make Shortcut','','root/import/gallery-templates/default-gallery-make-shortcut',1197825845,1284523757,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Make Shortcut Default Gallery Make Shortcut root import gallery templates default gallery make shortcut GalleryFile/MakeShortcut','000001000001000015000011'),('UTNFeV7B_aSCRmmaFCq4Vw','Default Gallery Delete Album','','root/import/gallery-templates/default-gallery-delete-album',1197825856,1284523757,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Delete Album Default Gallery Delete Album root import gallery templates default gallery delete album GalleryAlbum/Delete','000001000001000015000012'),('zcX-wIUct0S_np14xxOA-A','Default Gallery Delete File','','root/import/gallery-templates/default-gallery-delete-file',1197825866,1284523757,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Delete File Default Gallery Delete File root import gallery templates default gallery delete file GalleryFile/Delete','000001000001000015000013'),('MBZK_LPVzqhb4TV4mMRTJg','admin_ie7.css','','root/import/gallery-templates/admin_ie7.css',1197330678,1284523757,'3','7','3','WebGUI::Asset::Snippet',0,'admin_ie7.css admin_ie7.css root import gallery templates admin ie7.css input.captionEnter  margin-left 5px width 92px ','000001000001000015000014'),('bANo8aiAPA7aY_oQZKxIWw','rss.gif','','root/import/gallery-templates/images/rss.gif',1197330678,1284523757,'3','7','3','WebGUI::Asset::File::Image',1,'rss.gif rss.gif root import gallery templates images rss.gif','000001000001000015000017000001'),('2ci_v2d4x4uvyjTRlC49OA','moveDown.gif','','root/import/gallery-templates/images/movedown.gif',1197330678,1284523757,'3','7','3','WebGUI::Asset::File::Image',1,'moveDown.gif moveDown.gif root import gallery templates images movedown.gif','000001000001000015000017000002'),('O-EsSzKgAk1KolFT-x_KsA','moveUp.gif','','root/import/gallery-templates/images/moveup.gif',1197330678,1284523757,'3','7','3','WebGUI::Asset::File::Image',1,'moveUp.gif moveUp.gif root import gallery templates images moveup.gif','000001000001000015000017000003'),('fdd8tGExyVwHyrB8RBbKXg','next.gif','','root/import/gallery-templates/images/next.gif',1197330839,1284523757,'3','7','3','WebGUI::Asset::File::Image',1,'next.gif next.gif root import gallery templates images next.gif','000001000001000015000017000004'),('BpisgHl4ZDcSECJp6oib1w','play.gif','','root/import/gallery-templates/images/play.gif',1197330840,1284523757,'3','7','3','WebGUI::Asset::File::Image',1,'play.gif play.gif root import gallery templates images play.gif','000001000001000015000017000005'),('zshreRgPAXtnF0DtVbQ1Yg','previous.gif','','root/import/gallery-templates/images/previous.gif',1197330840,1284523757,'3','7','3','WebGUI::Asset::File::Image',1,'previous.gif previous.gif root import gallery templates images previous.gif','000001000001000015000017000006'),('mM3bjP_iG9sv5nQb4S17tQ','Default Gallery View Album RSS','','root/import/gallery-templates/default-gallery-album-rss',1197879662,1284523759,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album RSS Default Gallery View Album RSS root import gallery templates default gallery album rss GalleryAlbum/ViewRss','000001000001000015000018'),('ilu5BrM-VGaOsec9Lm7M6Q','Default Gallery List Albums RSS','','root/import/gallery-templates/default-gallery-list-albums-rss',1197878780,1284523759,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Albums RSS Default Gallery List Albums RSS root import gallery templates default gallery list albums rss Gallery/ListAlbumsRss','000001000001000015000019'),('-ANLpoTEP-n4POAdRxCzRw','Default Gallery List Files For User RSS','','root/import/gallery-templates/default-gallery-list-files-for-user-rss',1197880641,1284523759,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery List Files For User RSS Default Gallery List Files For User RSS root import gallery templates default gallery list files for user rss Gallery/ListFilesForUserRss','000001000001000015000020'),('OxJWQgnGsgyGohP2L3zJPQ','Default Gallery Edit Comment','','root/import/gallery-templates/default-gallery-edit-comment',1204663962,1284523760,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery Edit Comment Default Gallery Edit Comment root import gallery templates default gallery edit comment GalleryFile/EditComment','000001000001000015000021'),('Tsg7xmPYv782j6IVz7yHFg','Calendar Templates','','root/import/calendar-templates',1204890713,1213244777,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Calendar Templates Calendar Templates root import calendar templates','000001000001000006'),('kj3b-X3i6zRKnhLb4ZiCLw','Default Calendar List View','','root/import/calendar-templates/default-calendar-list-view',1204890713,1243445504,'3','7','3','WebGUI::Asset::Template',0,'Default Calendar List View Default Calendar List View root import calendar templates default calendar list view Calendar/List','000001000001000006000001'),('uRL9qtk7Rb0YRJ41LmHOJw','Default Calendar Print List View','','root/import/calendar-templates/default-calendar-print-list-view',1204890713,1229311072,'3','7','3','WebGUI::Asset::Template',0,'Default Calendar Print List View Default Calendar Print List View root import calendar templates default calendar print list view Calendar/Print/List','000001000001000006000002'),('CalendarWeek0000000001','Default Calendar Week','','root/import/calendar-templates/default-calendar-week',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Week Default Calendar Week root import calendar templates default calendar week Calendar/Week','000001000001000006000003'),('CalendarDay00000000001','Default Calendar Day','','root/import/calendar-templates/default-calendar-day',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Day Default Calendar Day root import calendar templates default calendar day Calendar/Day','000001000001000006000004'),('CalendarEvent000000001','Default Calendar Event','','root/import/calendar-templates/default-calendar-event',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Event Default Calendar Event root import calendar templates default calendar event Calendar/Event','000001000001000006000005'),('CalendarEventEdit00001','Default Calendar Event Edit','','root/import/calendar-templates/default-calendar-event-edit',1205160982,1269401468,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Event Edit Default Calendar Event Edit root import calendar templates default calendar event edit Calendar/EventEdit','000001000001000006000006'),('CalendarSearch00000001','Default Calendar Search','','root/import/calendar-templates/default-calendar-search',1204890713,1230358389,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Search Default Calendar Search root import calendar templates default calendar search Calendar/Search','000001000001000006000008'),('CalendarPrintEvent0001','Default Calendar Print Event','','root/import/calendar-templates/default-calendar-print-event',1204890714,1215396964,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Event Default Calendar Print Event root import calendar templates default calendar print event Calendar/Print/Event','000001000001000006000009'),('CalendarPrintMonth0001','Default Calendar Print Month','','root/import/calendar-templates/default-calendar-print-month',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Month Default Calendar Print Month root import calendar templates default calendar print month Calendar/Print/Month','000001000001000006000010'),('CalendarPrintWeek00001','Default Calendar Print Week','','root/import/calendar-templates/default-calendar-print-week',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Week Default Calendar Print Week root import calendar templates default calendar print week Calendar/Print/Week','000001000001000006000011'),('CalendarPrintDay000001','Default Calendar Print Day','','root/import/calendar-templates/default-calendar-print-day',1204890714,1204890714,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Print Day Default Calendar Print Day root import calendar templates default calendar print day Calendar/Print/Day','000001000001000006000012'),('jnYdqDkUR8x7Pv2eGR1qTA','Thingy Templates','','root/import/thingy-templates',1205431513,1216250666,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Thingy Templates Thingy Templates root import thingy templates','000001000001000046'),('ThingyTmpl000000000001','Default Thingy','','templates/thingy-default',1205003608,1237914005,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy Default Thingy templates thingy default Thingy','000001000001000046000001'),('ThingyTmpl000000000002','Default Thingy View Thing','','templates/thingy-default-view-thing',1205003676,1222574693,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy View Thing Default Thingy View Thing templates thingy default view thing Thingy/ViewThing','000001000001000046000002'),('ThingyTmpl000000000003','Default Thingy Edit Thing','','templates/thingy-default-edit-thing',1205003711,1224518002,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy Edit Thing Default Thingy Edit Thing templates thingy default edit thing Thingy/EditThing','000001000001000046000003'),('ThingyTmpl000000000004','Default Thingy Search Thing','','templates/thingy-default-search-thing',1205158717,1277868920,'3','7','12','WebGUI::Asset::Template',0,'Default Thingy Search Thing Default Thingy Search Thing templates thingy default search thing Thingy/SearchThing','000001000001000046000004'),('7fE8md51vTCcuJFOvxNaGA','thumbnails.js','','root/import/gallery-templates/thumbnails.js',1205443600,1284523760,'3','7','3','WebGUI::Asset::Snippet',0,'thumbnails.js thumbnails.js root import gallery templates thumbnails.js  Depends on BrowserDetect.js  Make the thumbnails a little bigger while the mouse is over them function scaleThumbUp  e anchor    IE6 doesn\'t like to do the right thing with the CSS stuff below exclude it if  BrowserDetect   if  BrowserDetect.browser == Explorer  BrowserDetect.version < 7   return    Make a new image with the same image src as the anchor var oldImage = anchor.getElementsByTagName(\"img\")[0 var newContainer = document.createElement(\"div newContainer.className = thumb-popup newContainer.style.position = absolute newContainer.style.zIndex = 1 var newWidth = oldImage.offsetWidth  3 var newHeight = oldImage.offsetHeight  3 var newLeft =   anchor.offsetLeft +  anchor.offsetWidth  2     newWidth  2   var newTop =   anchor.offsetTop +  anchor.offsetHeight  2     newHeight  2   newContainer.style.left = newLeft + px newContainer.style.top = newTop + px newContainer.style.width = newWidth + px newContainer.style.height = newHeight + px var newImage = document.createElement(\"img newImage.src = oldImage.src newImage.style.width = 100 newImage.style.height = 100 newContainer.appendChild newImage   Make some text for the caption var caption = document.createElement(\"div caption.appendChild document.createTextNode anchor.title   caption.className = caption newContainer.appendChild caption  var newBox = document.createElement(\"a newBox.href = anchor.href newBox.style.display = block newBox.style.position = absolute newBox.style.zIndex = 10 newBox.style.left =  anchor.offsetLeft  + px newBox.style.top =  anchor.offsetTop  + px newBox.style.height =  anchor.offsetHeight  + px newBox.style.width =  anchor.offsetWidth  + px newBox.style.border = 1px solid transparent anchor.parentNode.appendChild newContainer  anchor.parentNode.appendChild newBox  YAHOO.util.Event.addListener newBox click function   window.location.href = anchor.href   YAHOO.util.Event.addListener newContainer mouseout scaleThumbDown  newBox newContainer caption   YAHOO.util.Event.addListener newBox mouseout scaleThumbDown  newBox newContainer caption    function scaleThumbDown  e elements   for  var i = 0 i < elements.length i++   elements[i].parentNode.removeChild elements[i    var anchorTimeout function enterAnchor  e anchor   if  typeof anchorTimeout = undefined   clearTimeout anchorTimeout   anchorTimeout = setTimeout function  scaleThumbUp e anchor   150   function leaveAnchor  e anchor   if  typeof anchorTimeout = undefined   clearTimeout anchorTimeout    function initThumb   var anchors = YAHOO.util.Dom.getElementsByClassName thumb  for  var i = 0 i < anchors.length i++   YAHOO.util.Event.addListener anchors[i mouseover enterAnchor anchors[i  YAHOO.util.Event.addListener anchors[i mouseout leaveAnchor anchors[i    YAHOO.util.Event.onDOMReady initThumb ','000001000001000015000022'),('1oGhfj00KkCzP1ez01AfKA','slideshow.js','','root/import/gallery-templates/slideshow.js',1205635970,1284523760,'3','7','3','WebGUI::Asset::Snippet',0,'slideshow.js slideshow.js root import gallery templates slideshow.js if  typeof WebGUI == undefined   WebGUI =    WebGUI.Slideshow  config  Configure and return a new Slideshow object config is an object with the following properties containerId  The ID of the element that contains the Slideshow items Defaults to slideshow-container currentIndex  The index of the first item in the Slideshow Defaults to 0 isPlaying  If true the slideshow will begin immediately itemClassName  The class name of the slideshow items Defaults to slideshow-item nextButtonId  The id of the button to go to the next item pauseImageSrc  The URL to the pause button image playDelay  The delay in milliseconds between slides Defaults to 5000 playImageSrc  The URL to the play button image playPauseButtonId  The id of the button to toggle between play and pause previousButtonId  The id of the button to go to the previous item wrap  If true the slideshow will wrap around  Control the slideshow To control the slideshow you can use the following methods next  Pause the slideshow and go to the next slide previous  Pause the slideshow and go to the previous slide play  Play the slideshow pause  Pause the slideshow togglePlay  If it\'s playing pause it If it\'s paused play it  WebGUI.Slideshow = function  config   this.containerId = config  config.containerId  config.containerId  slideshow-container this.currentIndex = config  config.currentIndex  config.currentIndex  0 this.isPlaying = config  config.isPlaying  config.isPlaying  false this.itemClassName = config  config.itemClassName  config.itemClassName  slideshow-item this.nextButtonId = config  config.nextButtonId  undefined this.pauseImageSrc = config  config.pauseImageSrc  undefined this.playDelay = config  config.playDelay  config.playDelay  5000 this.playImageSrc = config  config.playImageSrc  undefined this.playPauseButtonId = config  config.playPauseButtonId  undefined this.previousButtonId = config  config.previousButtonId  undefined this.wrap = config  config.wrap  config.wrap  false YAHOO.util.Event.onDOMReady this.init this true    clearPlayTimeout   Clears the timeout to move to the next slide  WebGUI.Slideshow.prototype.clearPlayTimeout = function   clearTimeout this.playTimeout  this.playTimeout = undefined   doPlayTick  self  Performs the action to move to the next slide and start a new timeout self is a new reference to the object to get around the scoping issues with setTimeout  WebGUI.Slideshow.prototype.doPlayTick = function self  self.showNext self.setPlayTimeout   getSlideshowContainer   Returns the HTMLElement for the Slideshow container  WebGUI.Slideshow.prototype.getSlideshowContainer = function   return document.getElementById this.containerId    getSlideshowItems   Returns an array of HTMLElements for the Slideshow\'s items  WebGUI.Slideshow.prototype.getSlideshowItems = function   var items = YAHOO.util.Dom.getElementsByClassName this.itemClassName undefined this.getSlideshowContainer  return items   init   Initialize the slideshow Performed after the DOM is ready  WebGUI.Slideshow.prototype.init = function    Add handlers to buttons if  this.playPauseButtonId   YAHOO.util.Event.addListener this.playPauseButtonId click this.togglePlay this true   if  this.nextButtonId   YAHOO.util.Event.addListener this.nextButtonId click this.next this true   if  this.previousButtonId   YAHOO.util.Event.addListener this.previousButtonId click this.previous this true    Hide all but the currentIndex var items = this.getSlideshowItems for  var i = 0 i < items.length i++   if  i = this.currentIndex   items i style.display = none  else  items i style.display = block    Start it off if necessary if  this.isPlaying   this.setPlayTimeout this.updatePlayPauseButton    next   Pause the slideshow and go to the next slide  WebGUI.Slideshow.prototype.next = function   this.pause this.showNext   play   Start the slideshow  WebGUI.Slideshow.prototype.play = function   if  this.isPlaying   this.isPlaying = true this.setPlayTimeout this.updatePlayPauseButton    previous   Pause the slideshow and show the previous slide  WebGUI.Slideshow.prototype.previous = function   this.pause this.showPrevious   pause   Pause the slideshow  WebGUI.Slideshow.prototype.pause = function   if  this.isPlaying   this.isPlaying = false this.clearPlayTimeout this.updatePlayPauseButton    setPlayTimeout   Sets the timeout to move to the next slide  WebGUI.Slideshow.prototype.setPlayTimeout = function   var self = this this.playTimeout = setTimeout function   self.doPlayTick(self  this.playDelay    showNext   Show the next slide  WebGUI.Slideshow.prototype.showNext = function   var items = this.getSlideshowItems var hideIndex = this.currentIndex var showIndex = this.currentIndex + 1  Wrap around if  this.wrap  showIndex >= items.length   showIndex = 0   Don\'t allow going past the last item else if  showIndex >= items.length   return   Do the switch if  items hideIndex   items hideIndex style.display = none if  items showIndex    items showIndex style.display = block this.currentIndex = showIndex    showPrevious   Show the previous slide  WebGUI.Slideshow.prototype.showPrevious = function   var items = this.getSlideshowItems var hideIndex = this.currentIndex var showIndex = this.currentIndex  1  Wrap around if  this.wrap  showIndex < 0   showIndex = items.length  1   Don\'t allow going past the last item else if  showIndex < 0   return   Do the switch items hideIndex style.display = none items showIndex style.display = block this.currentIndex = showIndex   togglePlay   If it\'s paused play it If it\'s playing pause it Return true if the slideshow is now playing  WebGUI.Slideshow.prototype.togglePlay = function   if  this.isPlaying == false   this.play return true  else  this.pause    updatePlayPauseButton   Update the Play/Pause button to have the correct image  WebGUI.Slideshow.prototype.updatePlayPauseButton = function   if  this.playPauseButtonId   if  this.isPlaying  this.playImageSrc   document.getElementById this.playPauseButtonId src = this.pauseImageSrc  else if  this.pauseImageSrc   document.getElementById this.playPauseButtonId src = this.playImageSrc   ','000001000001000015000023'),('3qiVYhNTXMVC5hfsumVHgg','browserdetect.js','','root/import/gallery-templates/browserdetect.js',1206743306,1284523760,'3','7','3','WebGUI::Asset::Snippet',0,'browserdetect.js browserdetect.js root import gallery templates browserdetect.js var BrowserDetect =  init function   this.browser = this.searchString(this.dataBrowser || An unknown browser this.version = this.searchVersion(navigator.userAgent || this.searchVersion(navigator.appVersion || an unknown version this.OS = this.searchString(this.dataOS || an unknown OS  searchString function data  for var i=0;i','000001000001000015000024'),('usuxw9V3jN4d4pujRiEYxg','css03-ie.css','','style3/css03-ie.css',1209494150,1209494150,'3','7','12','WebGUI::Asset::Snippet',0,'css03-ie.css css03-ie.css style3 css03 ie.css contentArea  height:500px padding-bottom:300px ','000001000001000053000023'),('POVcY79vIqAHR8OfGt36aw','pagination_button.jpg','','root/import/gallery-templates/images/pagination_button.jpg',1209499189,1284523757,'3','7','12','WebGUI::Asset::File::Image',1,'pagination_button.jpg pagination_button.jpg root import gallery templates images pagination button.jpg','000001000001000015000017000007'),('hIB-z34r8Xl-vYVYCkKr-w','bar-btn-r.jpg','','root/import/gallery-templates/images/bar-btn-r.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'bar-btn-r.jpg bar-btn-r.jpg root import gallery templates images bar btn r.jpg','000001000001000015000017000008'),('-mPUoFlYcjqjPUPRLAlxNQ','search-field-r.jpg','','root/import/gallery-templates/images/search-field-r.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'search-field-r.jpg search-field-r.jpg root import gallery templates images search field r.jpg','000001000001000015000017000009'),('MDpUOR-N8KMyt1J7Hh_h4w','bar-btn.jpg','','root/import/gallery-templates/images/bar-btn.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'bar-btn.jpg bar-btn.jpg root import gallery templates images bar btn.jpg','000001000001000015000017000010'),('YfXKByTwDZVituMc4h13Dg','pagination_bg.jpg','','root/import/gallery-templates/images/pagination_bg.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'pagination_bg.jpg pagination_bg.jpg root import gallery templates images pagination bg.jpg','000001000001000015000017000011'),('esko_HSU0Gh-uJZ1h3xRmQ','search-field-l.jpg','','root/import/gallery-templates/images/search-field-l.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'search-field-l.jpg search-field-l.jpg root import gallery templates images search field l.jpg','000001000001000015000017000012'),('oSqpGswzpBG_ErdfYwIO8A','top_bg.jpg','','root/import/gallery-templates/images/top_bg.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'top_bg.jpg top_bg.jpg root import gallery templates images top bg.jpg','000001000001000015000017000013'),('MXJklShZvLLB_DSnZQmXrQ','title_bg.jpg','','root/import/gallery-templates/images/title_bg.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'title_bg.jpg title_bg.jpg root import gallery templates images title bg.jpg','000001000001000015000017000014'),('BthxD5oJ0idmsyI3ioA2FA','bar-btn-l.jpg','','root/import/gallery-templates/images/bar-btn-l.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'bar-btn-l.jpg bar-btn-l.jpg root import gallery templates images bar btn l.jpg','000001000001000015000017000015'),('aZ-1HYQamkRHYXvzAra8WQ','search-field.jpg','','root/import/gallery-templates/images/search-field.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'search-field.jpg search-field.jpg root import gallery templates images search field.jpg','000001000001000015000017000016'),('eRkb94OYcS5AdcrrerOP5Q','rss.gif','','root/import/gallery-templates/images/rss2.gif',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'rss.gif rss.gif root import gallery templates images rss2.gif','000001000001000015000017000017'),('TbnkjAJQEASORXIpYqDkcA','blank-image.jpg','','root/import/gallery-templates/images/blank-image.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'blank-image.jpg blank-image.jpg root import gallery templates images blank image.jpg','000001000001000015000017000018'),('er-3faBjY-hhlDcc5aKqdQ','top_bg.jpg','','root/import/gallery-templates/images/top_bg2.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'top_bg.jpg top_bg.jpg root import gallery templates images top bg2.jpg','000001000001000015000017000019'),('8bFsu2FJUqHRUiHcozcVFw','sub-btn-l.jpg','','root/import/gallery-templates/images/sub-btn-l.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'sub-btn-l.jpg sub-btn-l.jpg root import gallery templates images sub btn l.jpg','000001000001000015000017000020'),('34Aayx5eA320D8VfhdfDBw','sub-btn-r.jpg','','root/import/gallery-templates/images/sub-btn-r.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'sub-btn-r.jpg sub-btn-r.jpg root import gallery templates images sub btn r.jpg','000001000001000015000017000021'),('TlhKOVmWblZOsAdqmhEpeg','sub-btn.jpg','','root/import/gallery-templates/images/sub-btn.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'sub-btn.jpg sub-btn.jpg root import gallery templates images sub btn.jpg','000001000001000015000017000022'),('Nx0ypjO3cN6QdZUBUEE0lA','pic-title-bg.jpg','','root/import/gallery-templates/images/pic-title-bg.jpg',1209499189,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'pic-title-bg.jpg pic-title-bg.jpg root import gallery templates images pic title bg.jpg','000001000001000015000017000023'),('CmFZLN7iPS7XXvUEsxKPKA','row-2.jpg','','root/import/gallery-templates/images/row-2.jpg',1209499190,1284523758,'3','7','12','WebGUI::Asset::File::Image',1,'row-2.jpg row-2.jpg root import gallery templates images row 2.jpg','000001000001000015000017000024'),('v_XBgwwZqgW1D5s4y05qfg','addtl-info.gif','','root/import/gallery-templates/images/addtl-info.gif',1209499190,1284523759,'3','7','12','WebGUI::Asset::File::Image',1,'addtl-info.gif addtl-info.gif root import gallery templates images addtl info.gif','000001000001000015000017000025'),('4TdAkKoQbSCvI7QWcW889A','row-1.jpg','','root/import/gallery-templates/images/row-1.jpg',1209499190,1284523759,'3','7','12','WebGUI::Asset::File::Image',1,'row-1.jpg row-1.jpg root import gallery templates images row 1.jpg','000001000001000015000017000026'),('SAgK6eDPCG1cgkJ59WapHQ','prev-btn.gif','','root/import/gallery-templates/images/prev-btn.gif',1209499190,1284523759,'3','7','12','WebGUI::Asset::File::Image',1,'prev-btn.gif prev-btn.gif root import gallery templates images prev btn.gif','000001000001000015000017000027'),('XJYLuvGy9ubF7JNKyINtpA','play-btn.gif','','root/import/gallery-templates/images/play-btn.gif',1209499190,1284523759,'3','7','12','WebGUI::Asset::File::Image',1,'play-btn.gif play-btn.gif root import gallery templates images play btn.gif','000001000001000015000017000028'),('RWj7hyv2SpZuXxwj1Wocug','next-btn.gif','','root/import/gallery-templates/images/next-btn.gif',1209499190,1284523759,'3','7','12','WebGUI::Asset::File::Image',1,'next-btn.gif next-btn.gif root import gallery templates images next btn.gif','000001000001000015000017000029'),('aq8QElnlm3YufAoxRz9Pcg','data-bg.jpg','','root/import/gallery-templates/images/data-bg.jpg',1209499190,1284523759,'3','7','12','WebGUI::Asset::File::Image',1,'data-bg.jpg data-bg.jpg root import gallery templates images data bg.jpg','000001000001000015000017000030'),('6D4Z-oruXPS6OlH_Kx8pBg','images','','root/import/thingy-templates/images',1209509389,1209509389,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images images root import thingy templates images','000001000001000046000005'),('hQ7z33_jOYkQ8WNX5xy9Sw','style-button.gif','','root/import/thingy-templates/images/style-button.gif',1209509455,1209509455,'3','7','12','WebGUI::Asset::File::Image',1,'style-button.gif style-button.gif root import thingy templates images style button.gif','000001000001000046000005000001'),('vWW_DcHiYSrKZOkkIfEfcQ','row-2.jpg','','root/import/thingy-templates/images/row-2.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'row-2.jpg row-2.jpg root import thingy templates images row 2.jpg','000001000001000046000005000002'),('_bPYzRA87NTAUIKlfrJMHg','row-1.jpg','','root/import/thingy-templates/images/row-1.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'row-1.jpg row-1.jpg root import thingy templates images row 1.jpg','000001000001000046000005000003'),('nJjZHRwdDs5MAZYsAyioHw','title-bg.jpg','','root/import/thingy-templates/images/title-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'title-bg.jpg title-bg.jpg root import thingy templates images title bg.jpg','000001000001000046000005000004'),('8hxfkrJPeFVRWF5piCNJ1A','field-bg.jpg','','root/import/thingy-templates/images/field-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'field-bg.jpg field-bg.jpg root import thingy templates images field bg.jpg','000001000001000046000005000005'),('Osx7WN52iIKHZFT4vqUBHQ','search-btn.gif','','root/import/thingy-templates/images/search-btn.gif',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'search-btn.gif search-btn.gif root import thingy templates images search btn.gif','000001000001000046000005000006'),('oWff8fGzRdHPyq5VNREe9Q','top-bg.jpg','','root/import/thingy-templates/images/top-bg.jpg',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'top-bg.jpg top-bg.jpg root import thingy templates images top bg.jpg','000001000001000046000005000007'),('uqbkvb1b9443VvfkyRz95w','save-button.gif','','root/import/thingy-templates/images/save-button.gif',1209509433,1209509433,'3','7','12','WebGUI::Asset::File::Image',1,'save-button.gif save-button.gif root import thingy templates images save button.gif','000001000001000046000005000008'),('8YiMkcz32xalkAn3WBLpag','go-btn.gif','','root/import/thingy-templates/images/go-btn.gif',1210181860,1210181860,'3','7','12','WebGUI::Asset::File::Image',1,'go-btn.gif go-btn.gif root import thingy templates images go btn.gif','000001000001000046000005000009'),('3n3H85BsdeRQ0I08WmvlOg','thingy.css','','root/import/thingy-templates/thingy.css',1212091492,1245107956,'3','7','12','WebGUI::Asset::Snippet',0,'thingy.css thingy.css root import thingy templates thingy.css wgThingy  margin:5px  wgThingy  styleButton  color:black margin:0px 5px display:block float:left  wgThingy  spacerOne  padding-left:15px  wgThingy  rowOne wgThingy  tr.rowOne td  background EEEEEE margin:1px border:solid CDCDCD 1px color:#000 padding:2px  wgThingy  rowTwo wgThingy  tr.rowTwo td  background DBDBDB margin:1px border:solid DDDDDD 1px color:#000 padding:2px  wgThingsWrapper img  display:block vertical-align:middle float:left  wgThingsWrapper label  font-weight:bold padding-left:15px  wgThingy h2.title  background 000 height:42px color:white font-size:18px font-weight:bold letter-spacing:1px line-height:42px padding-left:15px margin-bottom:0px  wgThingy  span.smaller  font-size:13px color:white  wgThingy controls  line-height:35px height:35px background f1f1f1 margin-top:0px margin-bottom:20px padding:0px  wgThingy  label  background:black color:white padding:2px 5px font-family:arial font-size:11px font-weight:bold vertical-align:middle  wgThingy label a  color:white  searchTable  input editThing  input  background white border:solid 555 1px  editThing  margin-top:15px  thingyList thingyList   margin:0px padding:0px  thingyList  position:relative float:left  thingyList goButton:link thingyList goButton:visited  padding:2px 25px 2px 2px background F1F1F1 url(^FileUrl(root/import/thingy-templates/images/go-btn.gif no-repeat right line-height:20px border:solid a2a2a2 1px color:#a2a2a2 text-decoration:none font-family:verdana arial font-size:10px font-weight:bold margin-left:20px letter-spacing:0px  thingyList goButton:hover  background-color:white  thingyList things  padding:0px margin:0px width:300px z-index:5000 position:absolute top:27px left:20px border:solid a2a2a2 1px border-top-style:none  thingyList things a:link thingyList things a:visited  display:block background-color:#f1f1f1 border-top:solid a2a2a2 1px border-bottom:solid 727272 1px line-height:12px font-size:10px height:12px padding:2px 5px text-decoration:none font-weight:bold color:#a2a2a2  thingyList things a:hover  background-color:white ','000001000001000046000006'),('5m5I7__l40C4hhv4ydqAHQ','thingy-ie.css','','root/import/thingy-templates/thingy-ie.css',1210181698,1216227786,'3','7','12','WebGUI::Asset::Snippet',0,'thingy-ie.css thingy-ie.css root import thingy templates thingy ie.css thingyList things  padding:0px margin:0px width:200px z-index:5000 position:absolute top:27px left:20px border:solid a2a2a2 1px border-top-style:none  thingyList things a:link thingyList things a:visited  display:block background-color:#f1f1f1 border-top:solid a2a2a2 1px border-bottom:solid 727272 1px line-height:12px font-size:10px height:12px padding:2px 5px text-decoration:none font-weight:bold color:#a2a2a2 width:190px  thingyList things a:hover  background-color:white ','000001000001000046000007'),('2rC4ErZ3c77OJzJm7O5s3w','EMS Badge Listing (default)','','root/import/ems/ems-badge-listing-default',1208721232,1289360563,'3','7','12','WebGUI::Asset::Template',0,'EMS Badge Listing default EMS Badge Listing default root import ems ems badge listing default EMS','000001000001000012000003'),('PsFn7dJt4wMwBa8hiE3hOA','Print Badge (Default)','','root/import/ems/print-badge-default',1208558071,1257311886,'3','7','12','WebGUI::Asset::Template',0,'Print Badge Default Print Badge Default root import ems print badge default EMS/PrintBadge','000001000001000012000004'),('yBwydfooiLvhEFawJb0VTQ','Print Ticket (Default)','','root/import/ems/print-ticket-default',1208629936,1257311887,'3','7','12','WebGUI::Asset::Template',0,'Print Ticket Default Print Ticket Default root import ems print ticket default EMS/PrintTicket','000001000001000012000005'),('63ix2-hU0FchXGIWkG3tow','Flat Discount (Default)','','root/import/flat-discount-default',1209588387,1289360562,'3','7','12','WebGUI::Asset::Template',0,'Flat Discount Default Flat Discount Default root import flat discount default FlatDiscount','000001000001000038000011'),('gbnRhcWNk1iQe32LFEB5eQ','Shelf','','root/import/shelf2',1210779723,1212086102,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shelf Shelf root import shelf2','000001000001000037'),('1XOJDcg_ITRYwVM-QnIcPw','shelf.css','','root/import/shelf2/shelf.css',1210779441,1219175575,'3','7','12','WebGUI::Asset::Snippet',0,'shelf.css shelf.css root import shelf2 shelf.css wgShelf  font-size:12px font-family:arial verdana margin:15px 0px  wgShelf h2  background black padding:5px padding-left:15px line-height:32px color:white margin:0px height:32px  wgShelf wgShelves  background F1F1F1 height:29px padding:3px line-height:29px padding-left:30px  wgShelf product  margin:15px margin-left:0px text-align:left background-color:#f1f1f1 border:solid e1e1e1 1px width 200px display moz-inline-box  Moz  display inline-block  Op Saf IE  vertical-align top  IE Mac non capisce e a volte crea extra v space   wgShelf product thumbnail  display:block text-align:left margin:3px float:left  wgShelf product link  background e1e1e1 height:30px padding:3px line-height:24px margin-bottom:5px text-align:left display:block  wgShelf product link a:link wgShelf product link a:visited  color:#000 display:block  wgShelf product link a:hover  text-decoration:underline  wgShelf product price  display:block text-align:right font-size:18px font-weight:bold ','000001000001000037000003'),('C5fPz-Wg85vkYRvCdl-Xqw','UserList','','root/import/userlist',1212160830,1212160830,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'UserList UserList root import userlist','000001000001000049'),('aNmgn0cd6tldmC1FpW4KbA','Shop','','shopping-cart-collateral-items',1213122695,1289360562,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Shop Shop shopping cart collateral items','000001000001000038'),('2q5fxatSFLgIhXaUX-oSvg','bottom-left.jpg','','shopping-cart-collateral-items/bottom-left.jpg',1204149033,1289360562,'3','7','3','WebGUI::Asset::File::Image',1,'bottom-left.jpg bottom-left.jpg shopping cart collateral items bottom left.jpg','000001000001000038000001'),('_d5WTkKjnwct-_Dk7gZHvQ','bottom-right.jpg','','shopping-cart-collateral-items/bottom-right.jpg',1204149033,1289360562,'3','7','3','WebGUI::Asset::File::Image',1,'bottom-right.jpg bottom-right.jpg shopping cart collateral items bottom right.jpg','000001000001000038000002'),('Iz2mUR3jCPKyemwAea4b2g','input_bg.jpg','','shopping-cart-collateral-items/input_bg.jpg',1204149033,1289360562,'3','7','3','WebGUI::Asset::File::Image',1,'input_bg.jpg input_bg.jpg shopping cart collateral items input bg.jpg','000001000001000038000003'),('JU9bjsLRoWj7GVHs__prig','top-left.jpg','','shopping-cart-collateral-items/top-left.jpg',1204149033,1289360562,'3','7','3','WebGUI::Asset::File::Image',1,'top-left.jpg top-left.jpg shopping cart collateral items top left.jpg','000001000001000038000004'),('noOlnjQGexHg8c4bGVUo9g','top-right.jpg','','shopping-cart-collateral-items/top-right.jpg',1204149033,1289360562,'3','7','3','WebGUI::Asset::File::Image',1,'top-right.jpg top-right.jpg shopping cart collateral items top right.jpg','000001000001000038000005'),('aIpCmr9Hi__vgdZnDTz1jw','Cart (Default)','','default-shopping-cart-template',1209921197,1289360562,'3','7','3','WebGUI::Asset::Template',0,'Cart Default Cart Default default shopping cart template Shop/Cart','000001000001000038000006'),('4e-_rNs6mSWedZhQ_V5kJA','shelf-ie.css','','root/import/shelf2/shelf-ie.css',1210779672,1210779672,'3','7','12','WebGUI::Asset::Snippet',0,'shelf-ie.css shelf-ie.css root import shelf2 shelf ie.css wgShelf product  margin:15px margin-left:0px float:left text-align:left background-color:#f1f1f1 border:solid e1e1e1 1px min-height:100px min-width:200px width:200px height:100px  wgShelf product link  background url(^FileUrl(root/import/shelf2/images/shelf-titles.jpg no-repeat top right height:30px padding:3px line-height:24px margin-bottom:5px text-align:left display:block ','000001000001000037000004'),('2gtFt7c0qAFNU3BG_uvNvg','My Purchases (Default)','','shopping-cart-collateral-items/my-purchases-default',1211824430,1289360562,'3','7','3','WebGUI::Asset::Template',0,'My Purchases Default My Purchases Default shopping cart collateral items my purchases default Shop/MyPurchases','000001000001000038000008'),('bPz1yk6Y9uwMDMBcmMsSCg','Email Receipt (Default)','','shopping-cart-collateral-items/email-receipt-default',1211829604,1289360562,'3','7','3','WebGUI::Asset::Template',0,'Email Receipt Default Email Receipt Default shopping cart collateral items email receipt default Shop/EmailReceipt','000001000001000038000009'),('EBlxJpZQ9o-8VBOaGQbChA','MiniCart','','shopping-cart-collateral-items/minicart',1212093746,1289360562,'3','7','3','WebGUI::Asset::Template',0,'MiniCart MiniCart shopping cart collateral items minicart Shop/MiniCart','000001000001000038000014'),('PBtmpl0000000000000053','Subscription code redemption','','subscription_code_redemption',1124395696,1289360563,'3','7','12','WebGUI::Asset::Template',0,'Subscription code redemption Subscription code redemption subscription code redemption Operation/RedeemSubscription','000001000001000038000017'),('6tK47xsaIH-ELw0IBo0uRQ','images','','root/import/shelf2/images',1210777115,1210777115,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images images root import shelf2 images','000001000001000037000001'),('XNd7a_g_cTvJVYrVHcx2Mw','Address (Default)','','shopping-cart-collateral-items/address-default',1212099009,1289360562,'3','7','3','WebGUI::Asset::Template',0,'Address Default Address Default shopping cart collateral items address default Shop/Address','000001000001000038000007'),('_bZJ9LA_KNekZiFPaP2SeQ','shelf-titles.jpg','','root/import/shelf2/images/shelf-titles.jpg',1210777868,1210777868,'3','7','12','WebGUI::Asset::File::Image',1,'shelf-titles.jpg shelf-titles.jpg root import shelf2 images shelf titles.jpg','000001000001000037000001000001'),('nFen0xjkZn8WkpM93C9ceQ','Shelf (Default)','','root/import/shelf-default',1210779326,1247864696,'3','7','12','WebGUI::Asset::Template',0,'Shelf Default Shelf Default root import shelf default Shelf','000001000001000037000002'),('mTOiwwk3q4k9g5-XykXhPA','Documentation','With any large system, having the right documentation to get you started is mandatory. The good news is that WebGUI has abundant documentation. ','documentation',1215717999,1271349647,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Documentation Documentation documentation With any large system having the right documentation to get you started is mandatory The good news is that WebGUI has abundant documentation','000001000002000003'),('j_1qEqM6iLfQLiR6VKy0aA','Free Documentation','There are hundreds of pages of free documentation available for WebGUI, provided by both Plain Black and the community at large. The following list is by no means comprehensive, but it should get you started in the right direction. \n  \n\nPrimer - A downloa','documentation/free-documentation',1215718151,1271349878,'3','7','3','WebGUI::Asset::Wobject::Article',1,'Free Documentation Free Documentation documentation free documentation There are hundreds of pages of free documentation available for WebGUI provided by both Plain Black and the community at large The following list is by no means comprehensive but it should get you started in the right direction Primer  A downloadable PDF that shows you the basics of publishing content in WebGUI Wiki  Hundreds of pages of WebGUI community contributed content featuring a variety of tutorials Worldwide  A collection of WebGUI related web sites from all over the world that have documentation and other resources for WebGUI API Docs  The documentation of all of the WebGUI source code Template Help  The documentation of all of WebGUI\'s template variables  ','000001000002000003000001'),('o_pq_e4vRyhMOKFzs61eag','book-covers.jpg','','documentation/book-covers.jpg',1215714957,1215714957,'3','7','3','WebGUI::Asset::File::Image',1,'book-covers.jpg book-covers.jpg documentation book covers.jpg','000001000002000003000002'),('PBEmsBadgeTemplate0000','Default EMS Badge Template','','default_emsbadge',1221077977,1257311887,'3','7','4','WebGUI::Asset::Template',0,'Default EMS Badge Template Default EMS Badge Template default emsbadge EMSBadge','000001000001000012000006'),('9A-mg2gwWmaYi9o_1C7ArQ','dashboard','','root/import/projectmanager/dashboard',1147642478,1222803338,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'dashboard dashboard root import projectmanager dashboard','000001000001000031000001'),('yD1SMHelczihzjEmx6eXBA','editTask','','root/import/projectmanager/edittask',1147642478,1222803342,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'editTask editTask root import projectmanager edittask','000001000001000031000002'),('pV7GnZdpjR3XpZaSINIoeg','gantt','','root/import/projectmanager/gantt',1147642478,1222803347,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'gantt gantt root import projectmanager gantt','000001000001000031000003'),('71e17KeduiXgODLMlUxiow','project','','root/import/projectmanager/project',1147642479,1222803352,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'project project root import projectmanager project','000001000001000031000004'),('vTymIDYL2YqEh6PV50F7ew','manager','','root/import/timetracking/manager',1147642482,1222803302,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'manager manager root import timetracking manager','000001000001000048000001'),('lo1ac3BsoJx3ijGQ3gR-bQ','row','','root/import/timetracking/row',1147642482,1222803309,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'row row root import timetracking row','000001000001000048000002'),('huASapWvFDzqwOSbcN-JFQ','user','','root/import/timetracking/user',1147642483,1222803313,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'user user root import timetracking user','000001000001000048000003'),('xSmREZO3GNzK3M5PaueOOQ','LDAP/Account','','root/import/auth/ldap/account',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP/Account LDAP/Account root import auth ldap account','000001000001000005000001'),('0bx-xoL8TSXXubFuqKAoVQ','LDAP/Create','','root/import/auth/ldap/create',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP/Create LDAP/Create root import auth ldap create','000001000001000005000002'),('taX2UYkFF21ALpFZY2rhMw','LDAP/Login','','root/import/auth/ldap/login',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP/Login LDAP/Login root import auth ldap login','000001000001000005000003'),('K0q_N885Httqev1VCqUWxg','WebGUI/Account','','root/import/auth/webgui/account',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Account WebGUI/Account root import auth webgui account','000001000001000005000004'),('fq1ZkYhH24R5tb96kuT10Q','WebGUI/Create','','root/import/auth/webgui/create',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Create WebGUI/Create root import auth webgui create','000001000001000005000005'),('oHk7fAFhEEkB7dHzi0QOQA','WebGUI/Expired','','root/import/auth/webgui/expired',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Expired WebGUI/Expired root import auth webgui expired','000001000001000005000006'),('9M-lrlPQWeeNWfvnDnK_Xg','WebGUI/Login','','root/import/auth/webgui/login',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Login WebGUI/Login root import auth webgui login','000001000001000005000007'),('_gBYAdTcbkiyamnqi2Xskg','WebGUI/Recovery','','root/import/auth/webgui/recovery',1147642466,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Recovery WebGUI/Recovery root import auth webgui recovery','000001000001000005000008'),('tBL7BWiQRZFed2Y-Zjo9tQ','AdminToggle','','root/import/macro/admintoggle',1147642471,1222803200,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'AdminToggle AdminToggle root import macro admintoggle','000001000001000021000001'),('GdkQpvjRtJqtzOUbwIIQRA','a_account','','root/import/macro/a_account',1147642471,1222803205,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'a_account a_account root import macro a account','000001000001000021000002'),('tnc5iYyynX2hfdEs9D3P8w','EditableToggle','','root/import/macro/editabletoggle',1147642472,1222803213,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EditableToggle EditableToggle root import macro editabletoggle','000001000001000021000003'),('vgXdBcFTqU7h4wBG1ewdBw','File','','root/import/macro/file',1147642472,1222803217,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'File File root import macro file','000001000001000021000004'),('hcFlqnXlsmC1ujN6Id0F0A','GroupAdd','','root/import/macro/groupadd',1147642473,1222803234,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'GroupAdd GroupAdd root import macro groupadd','000001000001000021000005'),('eRJR52fvlaxfetv3DQkQYw','GroupDelete','','root/import/macro/groupdelete',1147642473,1222803238,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'GroupDelete GroupDelete root import macro groupdelete','000001000001000021000006'),('5HIDHq5lAWHV5gpYGS0zLg','H_homeLink','','root/import/macro/h_homelink',1147642473,1222803244,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'H_homeLink H_homeLink root import macro h homelink','000001000001000021000007'),('rYEFwXXo0tkGhQTcbDibvg','LoginToggle','','root/import/macro/logintoggle',1147642473,1222803249,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LoginToggle LoginToggle root import macro logintoggle','000001000001000021000008'),('V3l5S5TtI7wMm1WpIMhvOA','L_loginBox','','root/import/macro/l_loginbox',1147642473,1222803253,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'L_loginBox L_loginBox root import macro l loginbox','000001000001000021000009'),('nqNbSUAhk9Vd1zda2SCz9A','RandomThread','','root/import/macro/randomthread',1147642474,1222803258,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'RandomThread RandomThread root import macro randomthread','000001000001000021000010'),('y8XkRdxIperLKkJ3bL5sSQ','r_printable','','root/import/macro/r_printable',1147642474,1222803264,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'r_printable r_printable root import macro r printable','000001000001000021000011'),('UserListTmpl0000000002','UserList with search field selection','','root/import/userlist/userlist-with-search-field-selection',1212000800,1228125752,'3','7','12','WebGUI::Asset::Template',0,'UserList with search field selection UserList with search field selection root import userlist userlist with search field selection UserList','000001000001000049000002'),('UserListTmpl0000000003','UserList with multiple search keywords','','root/import/userlist/userlist-with-multiple-search-keywords',1212001437,1228125758,'3','7','12','WebGUI::Asset::Template',0,'UserList with multiple search keywords UserList with multiple search keywords root import userlist userlist with multiple search keywords UserList','000001000001000049000003'),('UserListTmpl0000000001','Default UserList','','root/import/userlist/default-userlist',1212159641,1228125743,'3','7','12','WebGUI::Asset::Template',0,'Default UserList Default UserList root import userlist default userlist UserList','000001000001000049000001'),('BMybD3cEnmXVk2wQ_qEsRQ','Badge Builder (Default)','','root/import/ems/badge-builder-default',1208530113,1263962529,'3','7','12','WebGUI::Asset::Template',0,'Badge Builder Default Badge Builder Default root import ems badge builder default EMS/BadgeBuilder','000001000001000012000001'),('OOyMH33plAy6oCj_QWrxtg','Lookup Registrant (Default)','','root/import/ems/lookup-registrant-default',1207951375,1257311886,'3','7','12','WebGUI::Asset::Template',0,'Lookup Registrant Default Lookup Registrant Default root import ems lookup registrant default EMS/LookupRegistrant','000001000001000012000002'),('stevecoolmenu000000001','Site Nav','','webgui7/style3/hierarchical-top-nav',1147642505,1224116942,'3','7','12','WebGUI::Asset::Template',0,'Site Nav Site Nav webgui7 style3 hierarchical top nav Navigation','000001000001000053000001'),('7-0-style0000000000051','css03.css','','style3/css03.css',1147642505,1224117026,'3','7','12','WebGUI::Asset::Snippet',0,'css03.css css03.css style3 css03.css body html  margin:0px background-color:#b53018 padding:0px  body a  color:#EE963E;font-weight:bold letter-spacing:1px font-size:8pt  main  width:98 min-width:790px margin:0px padding:0px padding-top:20px padding-bottom:20px position:relative  header  background url(\'^FileUrl(style3/header_bg.jpg repeat-x width:100 margin:0px height:115px  headerTitle  background url(\'^FileUrl(style3/header_left.jpg no-repeat left top height:100 width:100  headerRight  background url(\'^FileUrl(style3/header_right.jpg no-repeat right top width:100 height:100 text-align:right position:relative  headerRight title  position:absolute top:25px left:20px font-family:arial text-align:left  title h1  text-transform:uppercase margin-bottom:0px font-weight:normal font-size:26pt margin-top:0px color:white  title h1 a  color:white text-decoration:none font-size 26pt font-weight normal  title h2  margin:0px font-size:12pt color:#bebebe padding-left:20px  title img  z-index:5  login  position:absolute font-size:8pt top:45 right:150px color:white z-index:6 font-family:arial  login a  color:white font-weight normal letter-spacing 0px  loginBox  font-size:8pt margin:0px display:inline  loginBox input  font-size:8pt  mainBody  width:100 margin:0px height:500px background fff position:relative z-index:0  main > mainBody  height:auto min-height:500px  contentArea  z-index:2 position:relative padding-top:10px padding-left:10px padding-right:20px padding-bottom:20px moz-box-sizing:border-box font-family:verdana font-size:9pt min-height:500px  html main mainBody contentArea  height:1  topCorner  width:100 height:214px position:absolute top:0px left:0px background url(^FileUrl(/style3/main_top.jpg no-repeat z-index:1  bottomCorner  width:100 height:211px position:absolute bottom:59px right:0px background url(\'^FileUrl(style3/main_bottom.jpg no-repeat right z-index:1   html bottomCorner  bottom:58px  footer  width:100 margin:0px background:#000 url(\'^FileUrl(style3/footer_right.jpg no-repeat right top height:57px border-top:solid B53018 2px text-align:right position:relative z-index:0  footer copyright  color:#3b3b3b font-family:arial position:absolute top:20px left:30px font-size:8pt  main yui-skin-sam  font-family:verdana font-size:9pt font-weight:normal ','000001000001000053000002'),('jVKLVakT_iA2010_oEuAwg','Style3 Coolmenu','','department_nav',1224116526,1224116526,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'Style3 Coolmenu Style3 Coolmenu department nav','000001000001000053000024'),('UL-ItI4L1Z6-WSuhuXVvsQ','DataTable','','root/import/datatable',1225139673,1225139673,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'DataTable DataTable root import datatable','000001000001000011'),('3rjnBVJRO6ZSkxlFkYh_ug','Default DataTable Template (YUI)','','root/import/datatable/default-datatable-template-yui',1225139643,1233861835,'3','7','3','WebGUI::Asset::Template',0,'Default DataTable Template YUI Default DataTable Template YUI root import datatable default datatable template yui DataTable','000001000001000011000001'),('TuYPpHx7TUyk08639Pc8Bg','Default DataTable Template (HTML)','','root/import/datatable/default-datatable-template-html',1225139643,1233861621,'3','7','3','WebGUI::Asset::Template',0,'Default DataTable Template HTML Default DataTable Template HTML root import datatable default datatable template html DataTable','000001000001000011000002'),('IZkrow_zwvbf4FCH-taVTQ','Inbox','','root/import/account/inbox',1226011853,1226011853,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Inbox Inbox root import account inbox','000001000001000002000002'),('K0YjxqOqr7RupSo6sIdcAg','Friends','','root/import/account/friends',1227074310,1227074310,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Friends Friends root import account friends','000001000001000002000003'),('_ilRXNR3s8F2vGJ_k9ePcg','User','','root/import/account/user',1226643205,1226643205,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'User User root import account user','000001000001000002000004'),('AOjPG2NHgfL9Cq6dDJ7mew','Shop','','root/import/account/shop',1226659753,1236960881,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Shop Shop root import account shop','000001000001000002000005'),('qaVcU0FFzzraMX_bzELqzw','Contributions','','root/import/account/contributions',1227074362,1227074362,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Contributions Contributions root import account contributions','000001000001000002000006'),('matrixtmpl000000000004','Matrix Default Edit Listing','','default-matrix-edit-listing-template',1133743239,1281501163,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Edit Listing Matrix Default Edit Listing default matrix edit listing template Matrix/EditListing','000001000001000022000004'),('kJf77eCr9GAMiEzWrzsBTA','matrix-ie.css','','new-matrix/matrix-ie.css',1229639255,1281501163,'3','7','12','WebGUI::Asset::Snippet',0,'matrix-ie.css matrix-ie.css new matrix matrix ie.css matrixLeft buttons span matrixRight buttons span  padding:0px 0px 0px 0px  matrixLeft buttons button matrixRight buttons a  top:-3px left:-2px height:22px  matrixRight buttons a  color:black text-decoration:none padding:1px 3px ','000001000001000022000007'),('4LQT4-bGW4FkiEQLSY5gvQ','show-hide.js','','new-matrix/show-hide.js',1232400287,1281501163,'3','7','12','WebGUI::Asset::Snippet',0,'show-hide.js show-hide.js new matrix show hide.js function showHide(theLink,theId  var theId = document.getElementById(theId var theLink = document.getElementById(theLink if(theId.style.display == block  theId.style.display = none theLink.innerHTML = Send Creator a Message theLink.className = showLink  else  theId.style.display = block theLink.innerHTML = Hide theLink.className = hideLink  ','000001000001000022000008'),('Vch1Ww7G_JpBhOhXX07RDg','matrx-nav','','new-matrix/matrix-nav',1232664082,1281501163,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'matrx-nav matrix-nav new matrix matrix nav','000001000001000022000010'),('PBtmpl0000000000000063','Default Overview Report','','root/import/survey/default-overview-report',1124395696,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Overview Report Default Overview Report root import survey default overview report Survey/Overview','000001000001000044000001'),('HW-sPoDDZR8wBZ0YgFgPtg','images','','root/import/account/images',1227634350,1227634350,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'images images root import account images','000001000001000002000009'),('hBpisL-_URyZnh9clR5ohA','no_photo.gif','','root/import/account/images/no_photo.gif',1227634417,1227634417,'3','7','12','WebGUI::Asset::File::Image',1,'no_photo.gif no_photo.gif root import account images no photo.gif','000001000001000002000009000001'),('FOBV6KkifreXa4GmEAUU4A','no_photo_sm.gif','','root/import/account/images/no_photo_sm.gif',1227634447,1227634447,'3','7','12','WebGUI::Asset::File::Image',1,'no_photo_sm.gif no_photo_sm.gif root import account images no photo sm.gif','000001000001000002000009000002'),('PBtmpl0000000000000061','Default Survey','','root/import/survey/default-survey',1124395696,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Default Survey root import survey default survey Survey','000001000001000044000003'),('S2_LsvVa95OSqc66ITAoig','EMS Schedule Listing (default)','','root/import/ems/ems-schedule-listing-default2',1242730712,1257311887,'3','7','12','WebGUI::Asset::Template',0,'EMS Schedule Listing default EMS Schedule Listing default root import ems ems schedule listing default2 EMS/Schedule','000001000001000012000007'),('VyCINX2KixKYr2pzQGX9Mg','layout.css','','layout.css',1246968584,1254881103,'3','7','12','WebGUI::Asset::Snippet',0,'layout.css layout.css layout.css  styles for the layout asset  wg-left  float left  wg-right  float right  wg-clear  clear both  sidebyside wg-content-position oneovertwo wg-content-position  width 49  oneovertwo wg-top  width 100  oneoverthree wg-first-column oneoverthree wg-second-column oneoverthree wg-third-column threeColumns wg-first-column threeColumns wg-second-column threeColumns wg-third-column  width 32  oneoverthree wg-first-column threeColumns wg-first-column  margin-right:2  rightcolumn wg-first-column  width 65  rightcolumn wg-second-column  width 33 ','000001000001000019000006'),('XdlKhCDvArs40uqBhvzR3w','Article With Pagination','','article-with-pagination',1254881103,1259133275,'3','7','12','WebGUI::Asset::Template',0,'Article With Pagination Article With Pagination article with pagination Article','000001000001000057'),('VCFhB9WOsDsH2Apj3c6DpQ','Three Columns','','three-columns',1254881103,1259133276,'3','7','12','WebGUI::Asset::Template',0,'Three Columns Three Columns three columns Layout','000001000001000058'),('jmlI9IK-lV8n2WMYmmPhAA','Ad Sku','','root/import/ad-sku',1238106173,1238106173,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Ad Sku Ad Sku root import ad sku','000001000001000001'),('AldPGu0u-jm_5xK13atCSQ','Default Purchase Ad Sku Template','','root/import/ad-sku/default-purchase-ad-sku-template',1238106805,1251419124,'3','7','12','WebGUI::Asset::Template',0,'Default Purchase Ad Sku Template Default Purchase Ad Sku Template root import ad sku default purchase ad sku template AdSku/Purchase','000001000001000001000001'),('ohjyzab5i-yW6GOWTeDUHg','Default Manage Ad Sku Template','','root/import/ad-sku/default-manage-ad-sku-template',1238106805,1251425384,'3','7','12','WebGUI::Asset::Template',0,'Default Manage Ad Sku Template Default Manage Ad Sku Template root import ad sku default manage ad sku template AdSku/Manage','000001000001000001000002'),('PBtmpl0000000000000015','Default WebGUI Welcome Message Template','','root/import/auth/webgui/create/default-webgui-welcome-message-template',1237647040,1288142106,'3','7','12','WebGUI::Asset::Template',0,'Default WebGUI Welcome Message Template Default WebGUI Welcome Message Template root import auth webgui create default webgui welcome message template Auth/WebGUI/Welcome','000001000001000005000005000002'),('PBtmpl0000000000000016','Default WebGUI Account Activation Template','','root/import/auth/webgui/create/default-webgui-account-activation-template',1237407798,1288142106,'3','7','3','WebGUI::Asset::Template',0,'Default WebGUI Account Activation Template Default WebGUI Account Activation Template root import auth webgui create default webgui account activation template Auth/WebGUI/Activation','000001000001000005000005000003'),('wrq7hMxb1ewQqZ46xmd8Gg','equal-cols.js','','matrix/equal-cols.js',1235706620,1281501163,'3','7','12','WebGUI::Asset::Snippet',0,'equal-cols.js equal-cols.js matrix equal cols.js function equalCol  var colOne = document.getElementById(\'compareForm var colTwo = document.getElementById(\'matrixRight var colOneH = colOne.offsetHeight var colTwoH = colTwo.offsetHeight alert(colOneH +   + colTwoH colOne.style.overflow = scroll colOne.style.height = colTwoH  150 + px ','000001000001000022000011'),('matrixtmpl000000000007','Matrix Default Screenshots Config','','matrix-default-screenshots-config',1236594030,1281501163,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Screenshots Config Matrix Default Screenshots Config matrix default screenshots config Matrix/ScreenshotsConfig','000001000001000022000012'),('matrixtmpl000000000006','Matrix Default Screenshots','','matrix-default-screenshots',1236889702,1281501163,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Screenshots Matrix Default Screenshots matrix default screenshots Matrix/Screenshots','000001000001000022000013'),('RSAMkc6WQmfRE3TOr1_3Mw','ExpireIncompleteSurveyResponses','','root/import/expireincompletesurveyresponses',1234828062,1250243000,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'ExpireIncompleteSurveyResponses ExpireIncompleteSurveyResponses root import expireincompletesurveyresponses','000001000001000044000011'),('ExpireIncResptmpl00001','ExpireIncompleteSurveyResponses','','root/import/expireincompletesurveyresponses/expireincompletesurveyresponses',1236752721,1250243000,'3','7','12','WebGUI::Asset::Template',0,'ExpireIncompleteSurveyResponses ExpireIncompleteSurveyResponses root import expireincompletesurveyresponses expireincompletesurveyresponses ExpireIncompleteSurveyResponses','000001000001000044000011000001'),('NBVSVNLp9X_bV7WrCprtCA','Annotate Image','','image3',1237842096,1237842096,'3','7','12','WebGUI::Asset::Template',0,'Annotate Image Annotate Image image3 ImageAsset','000001000001000017000002'),('qsG6B24a0SC5KrhQjmdZBw','survey.css','','survey.css',1233860274,1288142107,'3','7','12','WebGUI::Asset::Snippet',0,'survey.css survey.css survey.css body  margin 0 background-repeat repeat-y background-position 0px 0px  survey-header  width 80 height 20px margin-left 80px  survey  margin-left 80px width 85  div.dateanswer  overflow auto  div.slider-bg  position relative background:url(/extras/wobject/Survey/bg-fader-500.gif 5px 0 no-repeat height:68px width:529px  div.slider-thumb  cursor:default position absolute top 30px left 4px  div.slider-min-thumb  cursor:default position absolute top 4px  div.slider-max-thumb  cursor:default position absolute top 4px  headertitle  display none  headertext  display none  questions  display none  input.mcbutton font-size 10px font-weight bold text-decoration none background-color CCCCCC background-repeat repeat-x text-align center display block margin 0.5em padding 8em min-width 60px font-family Verdana Arial Helvetica sans-serif color 000000 background-image url(/extras/wobject/Survey/gradient-glossy.png  input.mcbutton:hover background-color B6D2F1 font-family Verdana Arial Helvetica sans-serif font-size 10px color 000000  input.mcbutton-selected background-color 172D9D background-repeat repeat-x color FFFFFF font-family Verdana Arial Helvetica sans-serif font-size 10px margin 0.5em padding 8em width 60px text-align center display block font-weight bold background-image url(/extras/wobject/Survey/gradient-glossy.png background-position 0px 0px   By default the marker for invalid required fields is a red   survey-invalid-marker  color FF0000  survey  font-family Verdana Arial Helvetica sans-serif font-size 10px border 3px solid 1e1e1e  survey survey-header  background-color cfcfcf padding-top 1px  survey headertitle  padding-left 5px  survey progress  position relative top 26px right 5px text-align right font-style italic  survey progress:before  content Progress   survey headertext  border-bottom 2px solid 1e1e1e padding 5px  survey questions   survey question  background-color dfdfdf padding 10px 5px 10px 5px  survey question p:before  content Q   survey scale:before  content A   survey submitbutton  margin-left 5px  restartMessage  color FF0000  chart  float left width 200px height 113px ','000001000001000044000010'),('6uvSLY-ak_w4p_wS8q33cA','Carousel','','root/import/carousel',1239213092,1239213092,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Carousel Carousel root import carousel','000001000001000007'),('CarouselTmpl0000000001','Default Carousel','','root/import/carousel/carousel-default',1239290719,1286941427,'3','7','12','WebGUI::Asset::Template',0,'Default Carousel Default Carousel root import carousel carousel default Carousel','000001000001000007000001'),('CarouselTmpl0000000002','Carousel hidden textareas','','root/import/carousel/carousel-hidden-textareas',1238878995,1239475937,'3','7','12','WebGUI::Asset::Template',0,'Carousel hidden textareas Carousel hidden textareas root import carousel carousel hidden textareas Carousel','000001000001000007000002'),('GaBAW-2iVhLMJaZQzVLE5A','ThingyRecord Templates','','root/import/thingyrecord-templates',1240103565,1240103565,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'ThingyRecord Templates ThingyRecord Templates root import thingyrecord templates','000001000001000047'),('TKmhv8boP3TD2xwSwUBq0g','Default ThingyRecord View','','home/thinyrecord-templates/default-thingyrecord-view',1240103436,1250243000,'3','7','3','WebGUI::Asset::Template',0,'Default ThingyRecord View Default ThingyRecord View home thinyrecord templates default thingyrecord view ThingyRecord/View','000001000001000047000001'),('fowHfgOkJtAxdst7rugTog','Story Manager','','root/import/storymanager',1236184911,1252595993,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Story Manager Story Manager root import storymanager','000001000001000042'),('3QpYtHrq_jmAk1FNutQM5A','Story Template','','root/import/storymanager/storytemplate',1239237827,1253636379,'3','7','4','WebGUI::Asset::Template',0,'Story Template Story Template root import storymanager storytemplate Story','000001000001000042000001'),('yxD5ka7XHebPLD-LXBwJqw','StoryArchive','','root/import/storymanager/storyarchive',1239918573,1253635396,'3','7','4','WebGUI::Asset::Template',0,'StoryArchive StoryArchive root import storymanager storyarchive StoryArchive','000001000001000042000002'),('A16v-YjWAShXWvSACsraeg','StoryTopic','','root/import/storymanager/storytopic',1239918710,1284523755,'3','7','4','WebGUI::Asset::Template',0,'StoryTopic StoryTopic root import storymanager storytopic StoryTopic','000001000001000042000005'),('0EAJ9EYb9ap2XwfrcXfdLQ','Story Archive Asset List','','root/import/storymanager/keywordlist',1240262820,1250243000,'3','7','4','WebGUI::Asset::Template',0,'Story Archive Asset List Story Archive Asset List root import storymanager keywordlist StoryArchive/KeywordList','000001000001000042000006'),('9j0_Z1j3Jd0QBbY2akb6qw','Default Map View','','home/map/map-templates/default-map-view',1238053232,1257311887,'3','7','3','WebGUI::Asset::Template',0,'Default Map View Default Map View home map map templates default map view Map/View','000001000001000020000001'),('oHh0UqAJeY7u2n--WD-BAA','Default Edit Map Point','','home/map/map-templates/default-edit-map-point',1238040667,1271820952,'3','7','3','WebGUI::Asset::Template',0,'Default Edit Map Point Default Edit Map Point home map map templates default edit map point MapPoint/Edit','000001000001000020000002'),('u9vfx33XDk5la1-QC5FK7g','Default Map Point View','','home/map/map-templates/default-map-point-view',1238048383,1271820953,'3','7','3','WebGUI::Asset::Template',0,'Default Map Point View Default Map Point View home map map templates default map point view MapPoint/View','000001000001000020000003'),('kwTL1SWCk0GlpiJ5zAAEPQ','surveyedit.css','','root/import/survey/surveyedit.css',1244488512,1288142107,'3','7','12','WebGUI::Asset::Snippet',0,'surveyedit.css surveyedit.css root import survey surveyedit.css editor_container  visibility hidden z-index 100  loading-mask  position absolute left 0 top 0 width 100 height 100 z-index 20000 background-color white opacity:0.6 filter:alpha(opacity=60  loading  position absolute left 50 top 50 padding 2px z-index 20001 height auto margin 35px 0 0 30px  loading loading-indicator  background url(^Extras(\"wobject/Survey/rel_interstitial_loading.gif no-repeat color 555 font bold 13px tahoma,arial,helvetica padding 18px 80px margin 0 text-align center height auto z-index 20002  div.testarea  width 200px height 100px z-index 999 border 1px solid gray background f7f7f7 position absolute top 5 left:5  div.trashcan  border 1px solid gray width 175px height 50px  div.editarea  margin-top:40px padding:10px float:left border 1px solid gray  div.editquestion  padding:10px float:left  div.editanswer  padding:10px float:left  submitbutton  padding:20px  div.entry  padding-bottom:10px padding-left:10px  ul.draglist  list-style none margin:0 padding:0  ul.draglist li  margin 1px  ul.questionList  position relative background f7f7f7 border 1px solid gray list-style none margin:0 padding:0 min-height 40px  li.section  background-color CCCCFF border:1px solid 7EA6B2 cursor move min-height 10px  li.question  background-color D1E6EC border:1px solid 7EA6B2 cursor move padding-left:10px min-height 10px  li.answer  background-color F1FFB8 border:1px solid 7EA6B2 cursor move padding-left:15px min-height 10px  sections-panel li.selected  background-image url(^Extras(\"toolbar/bullet/moveRight.gif background-position:99 center background-repeat no-repeat font-weight:bold  goto-yui-ac  width:15em margin-top:0.5em  wGwarning  background-color:#FF6666 border:1px solid red margin:5px padding:10px  warning  padding 5px  sections-panel bd  overflow auto background-color:#fff padding:10px  buttons  height 30px  sections-panel_c yui-resize yui-resize-handle-r  right 6px  make room for the scroll-bars   sections-panel div.ft  font-size 100 ','000001000001000044000014'),('YP9WaMPJHvCJl-YwrLVcPw','Progress Bar','','admin_progress_bar',1245376837,1245376837,'3','7','12','WebGUI::Asset::Template',0,'Progress Bar Progress Bar admin progress bar AdminConsole/ProgressBar','000001000001000029'),('i5kt5aodVs_oepNEkE7Okw','poll.css','','poll.css',1242312883,1242312883,'3','7','12','WebGUI::Asset::Snippet',0,'poll.css poll.css poll.css styles for the poll asset pollColor  background-color:#808080  pollOptions pollSubmit  border:0 margin:0 padding:0 ','000001000001000027000002'),('uCn31PzislTZlgt_79j7cQ','style.css','','css/style.css',1258524916,1258524916,'3','7','12','WebGUI::Asset::Snippet',0,'style.css style.css css style.css  fail safe  topWrapper  font:82.5%/1.3 helvetica,arial,sans-serif width:98 overflow:hidden margin:0 auto 2em  nav  float:left width:20 margin:1em 0 2em  nav menu  list-style:none margin:0 padding:0  contentArea  float:right width:77 margin:1em 0 2em padding:5px 1 border:1px solid ccc  adminControls  margin:1em 0 padding:1em 0 0 border-top:1px dotted ccc ','000001000001000043000006'),('FJbUTvZ2nUTn65LpW6gjsA','Profile Account Layout','','root/import/account/profile/profile-account-layout',1227070381,1285733367,'3','7','12','WebGUI::Asset::Template',0,'Profile Account Layout Profile Account Layout root import account profile profile account layout Account/Layout','000001000001000002000001000001'),('75CmQgpcCSkdsL-oawdn3Q','Default Edit Profile Template','','root/import/account/profile/default-edit-profile-template',1227052575,1285733367,'3','7','12','WebGUI::Asset::Template',0,'Default Edit Profile Template Default Edit Profile Template root import account profile default edit profile template Account/Profile/Edit','000001000001000002000001000002'),('2CS-BErrjMmESOtGT90qOg','Default View Profile Template','','root/import/account/profile/default-view-profile-template',1227070888,1285733367,'3','7','12','WebGUI::Asset::Template',0,'Default View Profile Template Default View Profile Template root import account profile default view profile template Account/Profile/View','000001000001000002000001000003'),('MBmWlA_YEA2I6D29OMGtRg','Default Profile Error Template','','root/import/account/profile/default-profile-error-template',1226542675,1285733367,'3','7','12','WebGUI::Asset::Template',0,'Default Profile Error Template Default Profile Error Template root import account profile default profile error template Account/Profile/Error','000001000001000002000001000004'),('gfZOwaTWYjbSoVaQtHBBEw','Inbox Account Layout','','root/import/account/inbox-account-layout',1226974679,1249407461,'3','7','12','WebGUI::Asset::Template',0,'Inbox Account Layout Inbox Account Layout root import account inbox account layout Account/Layout','000001000001000002000002000001'),('c8xrwVuu5QE0XtF9DiVzLw','Default Inbox View Template','','root/import/account/inbox/default-inbox-view-template',1226894351,1273032723,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox View Template Default Inbox View Template root import account inbox default inbox view template Account/Inbox/View','000001000001000002000002000002'),('0n4HtbXaWa_XJHkFjetnLQ','Default Inbox View Message Template','','root/import/account/inbox/default-inbox-view-message-template',1226894994,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox View Message Template Default Inbox View Message Template root import account inbox default inbox view message template Account/Inbox/ViewMessage','000001000001000002000002000003'),('ErEzulFiEKDkaCDVmxUavw','Default Inbox Error Template','','root/import/account/inbox/default-inbox-error-template',1226895484,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox Error Template Default Inbox Error Template root import account inbox default inbox error template Account/Inbox/Error','000001000001000002000002000004'),('6uQEULvXFgCYlRWnYzZsuA','Default Inbox Send Message Template','','root/import/account/inbox/default-inbox-send-message-template',1226896682,1279073450,'3','7','12','WebGUI::Asset::Template',0,'Default Inbox Send Message Template Default Inbox Send Message Template root import account inbox default inbox send message template Account/Inbox/SendMessage','000001000001000002000002000005'),('DUoxlTBXhVS-Zl3CFDpt9g','Default Message Confirm Template','','root/import/account/inbox/default-message-confirm-template',1226896802,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Message Confirm Template Default Message Confirm Template root import account inbox default message confirm template Account/Inbox/Confirm','000001000001000002000002000006'),('1Q4Je3hKCJzeo0ZBB5YB8g','Default Manage Invitations Template','','root/import/account/inbox/default-manage-invitations-template',1226898445,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Manage Invitations Template Default Manage Invitations Template root import account inbox default manage invitations template Account/Inbox/ManageInvitations','000001000001000002000002000007'),('5A8Hd9zXvByTDy4x-H28qw','Default Invitation Confirmation Template','','root/import/account/inbox/default-invitation-confirmation-template',1226899462,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invitation Confirmation Template Default Invitation Confirmation Template root import account inbox default invitation confirmation template Account/Inbox/Confirm','000001000001000002000002000008'),('VBkY05f-E3WJS50WpdKd1Q','Default View Invitation Template','','root/import/account/inbox/default-view-invitation-template',1226899241,1248549087,'3','7','12','WebGUI::Asset::Template',0,'Default View Invitation Template Default View Invitation Template root import account inbox default view invitation template Account/Inbox/ViewInvitation','000001000001000002000002000009'),('XgcsoDrbC0duVla7N7JAdw','Default Invite User Email Template','','root/import/account/inbox/default-invite-user-email-template',1226973330,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invite User Email Template Default Invite User Email Template root import account inbox default invite user email template Account/Inbox/InviteUserMessage','000001000001000002000002000010'),('cR0UFm7I1qUI2Wbpj--08Q','Default Invite User Form Template','','root/import/account/inbox/default-invite-user-form-template',1226964738,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invite User Form Template Default Invite User Form Template root import account inbox default invite user form template Account/Inbox/InviteUser','000001000001000002000002000011'),('SVIhz68689hwUGgcDM-gWw','Default Invite User Confirm Template','','root/import/account/inbox/default-invite-user-confirm-template',1226973314,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Invite User Confirm Template Default Invite User Confirm Template root import account inbox default invite user confirm template Account/Inbox/InviteUserConfirm','000001000001000002000002000012'),('zrNpGbT3odfIkg6nFSUy8Q','Friends Layout Template','','root/import/account/friends/friends-layout-template',1226994016,1249407461,'3','7','12','WebGUI::Asset::Template',0,'Friends Layout Template Friends Layout Template root import account friends friends layout template Account/Layout','000001000001000002000003000001'),('1Yn_zE_dSiNuaBGNLPbxtw','Default Friends View Template','','root/import/account/friends/default-friends-view-template',1226994422,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends View Template Default Friends View Template root import account friends default friends view template Account/Friends/View','000001000001000002000003000002'),('AZFU33p0jpPJ-E6qLSWZng','Default Friends Edit Template','','root/import/account/friends/default-friends-edit-template',1226994865,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends Edit Template Default Friends Edit Template root import account friends default friends edit template Account/Friends/Edit','000001000001000002000003000003'),('AGJBGviWGAwjnwziiPjvDg','Default Send Request Template','','root/import/account/friends/default-send-request-template',1226995497,1248549087,'3','7','12','WebGUI::Asset::Template',0,'Default Send Request Template Default Send Request Template root import account friends default send request template Account/Friends/SendRequest','000001000001000002000003000004'),('7Ijdd8SW32lVgg2H8R-Aqw','Default Friends Error Template','','root/import/account/friends/default-friends-error-template',1226995714,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends Error Template Default Friends Error Template root import account friends default friends error template Account/Friends/Error','000001000001000002000003000005'),('K8F0j_cq_jgo8dvWY_26Ag','Default Friends Confirmation Template','','root/import/account/friends/default-friends-confirmation-template',1226995643,1248549086,'3','7','12','WebGUI::Asset::Template',0,'Default Friends Confirmation Template Default Friends Confirmation Template root import account friends default friends confirmation template Account/Friends/Confirm','000001000001000002000003000006'),('G5V6neXIDiFXN05oL-U3AQ','Default Remove Friends Confirmation Template','','root/import/account/friends/default-remove-friends-confirmation-template',1226995768,1248549087,'3','7','12','WebGUI::Asset::Template',0,'Default Remove Friends Confirmation Template Default Remove Friends Confirmation Template root import account friends default remove friends confirmation template Account/Friends/Confirm','000001000001000002000003000007'),('9ThW278DWLV0-Svf68ljFQ','Account Layout','','root/import/account/user/account-layout',1226647187,1249407460,'3','7','12','WebGUI::Asset::Template',0,'Account Layout Account Layout root import account user account layout Account/Layout','000001000001000002000004000001'),('aUDsJ-vB9RgP-AYvPOy8FQ','Shop Account Layout','','root/import/account/shop/shop-account-layout',1226660439,1263962529,'3','7','12','WebGUI::Asset::Template',0,'Shop Account Layout Shop Account Layout root import account shop shop account layout Account/Layout','000001000001000002000005000001'),('-zxyB-O50W8YnL39Ouoc4Q','Default My Sales Template','','root/import/default-my-sales-template',1236959717,1248563425,'3','7','12','WebGUI::Asset::Template',0,'Default My Sales Template Default My Sales Template root import default my sales template Shop/MySales','000001000001000002000005000002'),('b4n3VyUIsAHyIvT-W-jziA','Contributions Layout','','root/import/account/contributions/contributions-layout',1227074747,1249407461,'3','7','12','WebGUI::Asset::Template',0,'Contributions Layout Contributions Layout root import account contributions contributions layout Account/Layout','000001000001000002000006000001'),('1IzRpX0tgW7iuCfaU2Kk0A','Default Contributions View','','root/import/account/contributions/default-contributions-view',1227079721,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Contributions View Default Contributions View root import account contributions default contributions view Account/Contrib/View','000001000001000002000006000002'),('N716tpSna0iIQTKxS4gTWA','Default Account Layout','','root/import/account/default-account-layout2',1226604666,1281501163,'3','7','12','WebGUI::Asset::Template',0,'Default Account Layout Default Account Layout root import account default account layout2 Account/Layout','000001000001000002000007'),('CalendarMonth000000001','Default Calendar Month','','root/import/calendar-templates/default-calendar-month',1204890713,1279073449,'3','7','12','WebGUI::Asset::Template',0,'Default Calendar Month Default Calendar Month root import calendar templates default calendar month Calendar/Month','000001000001000006000007'),('q5O62aH4pjUXsrQR3Pq4lw','Default Gallery View Album Thumbnails','','root/import/gallery-templates/default-gallery-view-album-thumbnails',1197825772,1284523756,'3','7','3','WebGUI::Asset::Template',0,'Default Gallery View Album Thumbnails Default Gallery View Album Thumbnails root import gallery templates default gallery view album thumbnails GalleryAlbum/ViewThumbnails','000001000001000015000004'),('kaPRSaf8UKiskiGEgJgLAw','images','','root/import/gallery-templates/images',1197330678,1284523757,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'images images root import gallery templates images','000001000001000015000017'),('matrixtmpl000000000001','Matrix Default View','','matrix-default-view-template',1133743238,1281501162,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default View Matrix Default View matrix default view template Matrix','000001000001000022000002'),('matrixtmpl000000000003','Matrix Default Detailed Listing','','matrix-default-detailed-listing',1133743238,1281501163,'3','7','12','WebGUI::Asset::Template',0,'Matrix Default Detailed Listing Matrix Default Detailed Listing matrix default detailed listing Matrix/Detail','000001000001000022000003'),('alraubvBu-YJJ614jAHD5w','matrix-nav-tmpl','','new-matrix/matrix-nav-tmpl',1232664015,1281501163,'3','7','12','WebGUI::Asset::Template',0,'matrix-nav-tmpl matrix-nav-tmpl new matrix matrix nav tmpl Navigation','000001000001000022000009'),('PBtmpl0000000000000062','Default Gradebook Report','','root/import/survey/default-gradebook-report',1124395696,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Gradebook Report Default Gradebook Report root import survey default gradebook report Survey/Gradebook','000001000001000044000002'),('d8jMMMRddSQ7twP4l1ZSIw','Default Survey Take','','root/import/survey/default-survey-take',1227248175,1253555614,'3','7','12','WebGUI::Asset::Template',0,'Default Survey Take Default Survey Take root import survey default survey take Survey/Take','000001000001000044000005'),('E3tzZjzhmYoNlAyP2VW33Q','Edit Story','','root/import/storymanager/editstory',1239236292,1253635296,'3','7','4','WebGUI::Asset::Template',0,'Edit Story Edit Story root import storymanager editstory Story/Edit','000001000001000042000003'),('TbDcVLbbznPi0I0rxQf2CQ','Story Template Topic','','root/import/storymanager/storytemplatetopic',1237524306,1253636379,'3','7','4','WebGUI::Asset::Template',0,'Story Template Topic Story Template Topic root import storymanager storytemplatetopic Story','000001000001000042000004'),('brxm_faNdZX5tRo3p50g3g','Map Templates','','home/map/map-templates',1238054297,1256092368,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Map Templates Map Templates home map map templates','000001000001000020'),('i9-G00ALhJOr0gMh-vHbKA','Inbox SMS Notification','','root/import/inbox-sms-notification',1250408924,1250408924,'3','7','4','WebGUI::Asset::Template',0,'Inbox SMS Notification Inbox SMS Notification root import inbox sms notification Account/Inbox/Notification','000001000001000002000002000014'),('S3zpVitAmhy58CAioH359Q','Default Test Results','','root/import/survey/default-test-results',1242893798,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Test Results Default Test Results root import survey default test results Survey/TestResults','000001000001000044000013'),('b1316COmd9xRv4fCI3LLGA','Inbox Notification','','inbox_notification',1236956475,1236956475,'3','7','4','WebGUI::Asset::Template',0,'Inbox Notification Inbox Notification inbox notification Account/Inbox/Notification','000001000001000002000002000013'),('nWNVoMLrMo059mDRmfOp9g','Default Feedback','','root/import/survey/default-feedback',1242259265,1250243000,'3','7','12','WebGUI::Asset::Template',0,'Default Feedback Default Feedback root import survey default feedback Survey/Feedback','000001000001000044000015'),('N7uMnnicbyTEulcuRi1sSg','PDFs','','media/pdfs',1284523698,1284523698,'3','7','4','WebGUI::Asset::Wobject::Folder',1,'PDFs PDFs media pdfs','000001000003000001'),('bCGr7FRtZt-XYlBVUEJBjw','Getting_Started_doc.pdf','','media/pdfs/getting_started_doc.pdf',1278013724,1278013724,'3','7','4','WebGUI::Asset::File::Image',1,'Getting_Started_doc.pdf Getting_Started_doc.pdf media pdfs getting started doc.pdf','000001000003000001000001'),('D6cJpRcey35aSkh9Q_FPUQ','Default EU User Screen','','root/import/default-eu-user-screen',1242407725,1289360563,'3','7','12','WebGUI::Asset::Template',0,'Default EU User Screen Default EU User Screen root import default eu user screen TaxDriver/EU/User','000001000001000038000019'),('lo1rpxn3t8YPyKGers5eQg','Friend Manager','Templates for the Friend Manager ','root/import/account/friendmanager',1238625621,1238625621,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Friend Manager Friend Manager root import account friendmanager Templates for the Friend Manager','000001000001000002000010'),('64tqS80D53Z0JoAs2cX2VQ','FriendManager View Template','','root/import/account/friendmanager/view',1239400975,1239400975,'3','7','4','WebGUI::Asset::Template',0,'FriendManager View Template FriendManager View Template root import account friendmanager view Account/FriendManager/View','000001000001000002000010000001'),('lG2exkH9FeYvn4pA63idNg','Friend Manager Edit Friends','','root/import/account/friendmanager/edit',1239383808,1239383808,'3','7','4','WebGUI::Asset::Template',0,'Friend Manager Edit Friends Friend Manager Edit Friends root import account friendmanager edit Account/FriendManager/Edit','000001000001000002000010000002'),('newslettercs0000000001','Newsletter Manager (default)','','newslettercstemplate',1185754569,1252682678,'3','7','3','WebGUI::Asset::Template',0,'Newsletter Manager default Newsletter Manager newslettercstemplate Collaboration','000001000001000026000002'),('iCM9pRY5yYyjufROgaCDlg','storyManager.css','','storymanager.css',1253305659,1253305659,'3','7','12','WebGUI::Asset::Snippet',0,'storyManager.css storyManager.css storymanager.css editStory  width 100  editStory legend  font-size 1.8em border-bottom 2px solid  editStory tbody  width 943px  editStory td  padding 5px  editStory story  float:left  editStory story label editStory photo label  display block width 100 text-align right editStory photoContainer  border 1px solid float:left margin 10px 0 0 20px  editStory photoContainer photoHeader  font-size 1.2em font-weight bold  editStory buttons  clear both text-align right padding 10px 0  editStory story_formId_tbl  width 100 important  editStory fieldset  border none  storyArchive  width 100  storyArchive h3  border-bottom 2px solid margin-bottom 10px  storyArchive storyList  list-style-type none padding-left 0  storyArchive storyList li  padding-left 10px margin-bottom 10px  storyArchive pagination  float left list-style-type none  storyArchive keywords  width 100 clear both  storyArchive img  border none  storyArchive controls a  margin-right 10px  viewStory storyTitle viewStory storyUpdated viewStoryTopic storyTitle viewStoryTopic storyUpdated  float left  viewStory storyTitle viewStoryTopic storyTitle  font-size 1.5em width 100  viewStory storyHighlights viewStoryTopic storyHighlights  float:right margin-top 1.5em  viewStory storyPhoto viewStoryTopic storyPhoto  float left margin 0 10px 10px 0  viewStory photoCaption viewStoryTopic photoCaption  width 496px padding 5px display:block  viewStory clear viewStoryTopic clear  clear both  storyTopic  width 100  storyTopic h3 border-bottom 2px solid  storyTopic topStory  width 340px float left  storyTopic storyList  width 250px float left  storyTopic storyListBig  width 100 float left  htmltagcloud wg-clear  clear:both ','000001000001000042000007'),('limMkk80fMB3fqNZVf162w','Default Asset Subscription','','root/import/default-asset-subscription',1253507213,1281501163,'3','7','3','WebGUI::Asset::Template',0,'Default Asset Subscription Default Asset Subscription root import default asset subscription AssetAspect/Subscribable','000001000001000056'),('zb_OPKNqcTuIjdvvbEkRjw','article.css','','article.css',1247484073,1256092368,'3','7','12','WebGUI::Asset::Snippet',0,'article.css article.css article.css  styles for the article asset  withImage articleContent linkedImage articleContent  width:100 overflow:hidden  withImage articleImage linkedImage articleImage  float:right margin:0 0 10px 10px  linkedImage caption  display:block ','000001000001000004000005'),('PBtmpl0000000000000210','Request Tracker Post Form','','request-tracker-template2',1147642410,1277868922,'3','7','12','WebGUI::Asset::Template',0,'Request Tracker Post Form Request Tracker Post Form request tracker template2 Collaboration/PostForm','000001000001000008000028'),('pbrobot000000000000001','robots.txt','','robots.txt',1147642511,1256092369,'3','7','12','WebGUI::Asset::Snippet',0,'robots.txt robots.txt robots.txt User-agent  Disallow op=auth Disallow op=account Disallow op=ajaxGetI18N Disallow op=makePrintable Disallow op=viewHelp Disallow op=viewHelpIndex','000001000001000035'),('4qh0kIsFUdd4Ox-Iu1JZgg','EMS','','root/import/ems',1208725439,1257311886,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'EMS EMS root import ems','000001000001000012'),('hreA_bgxiTX-EzWCSZCZJw','Print Remaining Tickets Template (default)','','root/import/ems/default-print-remaining-tickets-template',1257311887,1257311887,'3','7','12','WebGUI::Asset::Template',0,'Print Remaining Tickets Template default Print Remaining Tickets Template default root import ems default print remaining tickets template EMS/PrintRemainingTickets','000001000001000012000008'),('2GxjjkRuRkdUg_PccRPjpA','Select Gateway (Default)','','shopping-cart-collateral-items/select-gateway-default',1257311888,1289360563,'3','7','3','WebGUI::Asset::Template',0,'Select Gateway Default Select Gateway Default shopping cart collateral items select gateway default Shop/selectGateway','000001000001000059'),('_aE16Rr1-bXBf8SIaLZjCg','picklanguage','','media/picklanguage',1257311888,1257311888,'3','7','12','WebGUI::Asset::Template',0,'picklanguage picklanguage media picklanguage Macro/PickLanguage','000001000001000060'),('P_4uog81vSUK4KxuW_4GUA','css','','css',1258524916,1258524916,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'css css css','000001000001000061'),('H_-8zjtWsO1FUpQqNtkxNQ','wg-base.css','','css/wg-base.css',1258524916,1258524916,'3','7','12','WebGUI::Asset::Snippet',0,'wg-base.css wg-base.css css wg base.css  In this stylesheet you can find the styles that are used in more than one template For example file/attachment icons pagination etc   Elements that are styled with this stylesheet have a classname that starts with wg   general  wg-icon  border:0px none vertical-align middle  wg-clear  clear:both   inline list pagination  wg-inline  margin:0 0 1em padding:0  wg-inline li  display:inline margin:0 padding:0  wg-inline li.active  font-weight:bold   forms  wg-captchaImage  border:0 none vertical-align:middle margin-left:5px ','000001000001000061000001'),('8tqyQx-LwYUHIWOlKPjJrA','EMS Event Submission Template','','root/import/ems/ems-event-submission',1258524917,1279073449,'3','7','12','WebGUI::Asset::Template',0,'EMS Event Submission Template EMS Event Submission Template root import ems ems event submission EMS/Submission','000001000001000062'),('DoVNijm6lMDE0cYrtvEbDQ','EMS Event Submission Main Template','','root/import/ems/ems-event-submission-main',1258524917,1279073449,'3','7','12','WebGUI::Asset::Template',0,'EMS Event Submission Main Template EMS Event Submission Main Template root import ems ems event submission main EMS/SubmissionMain','000001000001000063'),('ktSvKU8riGimhcsxXwqvPQ','EMS Event Submission Queue','','root/import/ems/ems-event-submission-queue',1258524917,1279073450,'3','7','12','WebGUI::Asset::Template',0,'EMS Event Submission Queue EMS Event Submission Queue root import ems ems event submission queue EMS/SubmissionQueue','000001000001000064'),('mRtqRuVikSe82BQsYBlD0A','Bare Image','','bare_image',1263962529,1263962529,'3','7','12','WebGUI::Asset::Template',0,'Bare Image Bare Image bare image ImageAsset','000001000001000065'),('0iMMbGN3BevuCBHjjLiQNA','WebGUI/Deactivate','','root/import/auth/webgui/deactivate',1269401469,1288142106,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'WebGUI/Deactivate WebGUI/Deactivate root import auth webgui deactivate','000001000001000005000009'),('zaHUYsE_PgKk8hnVd8ffEQ','WebGUI Deactivate Account Template','','default_webgui_deactivate_account_template',1269401469,1288142107,'3','7','12','WebGUI::Asset::Template',0,'WebGUI Deactivate Account Template WebGUI Deactivate Account Template default webgui deactivate account template Auth/WebGUI/Deactivate','000001000001000005000009000001'),('6A4yIjWwJfIE0Ep-I0jutg','LDAP/Deactivate','','root/import/auth/ldap/deactivate',1269401469,1288142107,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'LDAP/Deactivate LDAP/Deactivate root import auth ldap deactivate','000001000001000005000010'),('_P4PMiraGsLTfOjK4fYQPQ','LDAP Deactivate Account Template','','default_ldap_deactivate_account_template',1269401469,1288142107,'3','7','12','WebGUI::Asset::Template',0,'LDAP Deactivate Account Template LDAP Deactivate Account Template default ldap deactivate account template Auth/LDAP/Deactivate','000001000001000005000010000001'),('_XfvgNH__bY1ykMiKYSobQ','account.css','','root/import/account/account.css',1233168041,1281501163,'3','7','12','WebGUI::Asset::Snippet',0,'account.css account.css root import account account.css  general  WGsubContent WGsubContent a WGsubContent a:link  color:#000000 important  WGbutton  float:right padding-right:10px  centered  text-align center  WGaccount_message  background-color white border solid BECEF8 1px height 300px margin-bottom 10px margin-left 60px margin-top 20px overflow:-moz-scrollbars-vertical overflow-x:hidden overflow-y:scroll padding:10px text-align left vertical-align:top width 90  WGprofileMember  font-size:9px margin-right:20px text-align:right  WGmember  color:#3e4f77 font 9px Verdana Arial Helvetica sans-serif text-align:center  WGphotostyle  border:solid 3e4f77 2px margin-bottom:5px margin-top:5px  rightalign  float right  WGsend  float:right padding-right 75px   bio addtonetwork network  WGbordered  border-bottom dashed BECEF8 2px padding-bottom 10px  WGfriendpic  border solid BECEF8 1px  WGinvitemsg  width 600px height 150px  ol.WGProfile_interests  color:#0B2259 font-size:15px font-weight:bold list-style-type:none margin:0px padding:0px padding:5px 5px  ol.WGProfile_interests li  margin-bottom:15px  ol.WGProfile_interests span  font-size:12px font-weight:normal color:black  WGpBio  border-bottom:solid DDE6FB 1px margin:0px margin-bottom:5px padding-bottom:5px  WGpBio div  background-color:#DDE6FB padding:2px 5px margin-bottom:2px  WGprogram  font-size 9px   contributions  WGContribCount  font-size:12px text-align:left padding:3px  WGContribTitle  background-color:#f2f5fa border solid d8dee8 1px color:#0B2259 font-size:12px font-weight:bold min-height:25px padding:3px text-align:center text-decoration underline  WGContribTitleLeft  background-color:#f2f5fa border solid d8dee8 1px color:#0B2259 font-size:12px font-weight:bold min-height:25px padding:3px text-align:center text-decoration underline  WGContribEntry  text-align:center padding:3px  WGContribEntryLeft  text-align:left padding:3px   edit box  WGeditBox  background:white url(images/edit_box_bg.jpg no-repeat bottom left border:solid 8DABF1 2px display:block font-family:verdana font-size:9px font-weight:bold left:100px moz-box-sizing:border-box padding:5px position:absolute top:100px width:590px z-index:100  WGeditBox input WGeditBox select  font-size:9px   friends  WGfriends_name  font-weight:bold width:90  WGfriends_photo  font-weight:bold width:10  WGfriends_photo img  height 50px width 50px  WGfriends_private  float:right padding-bottom 5px width 50  WGfriends_ninety  vertical-align:top width 90  WGfriends_seventy  vertical-align:top width 70  WGfriends_ten  width 10  WGfriends_ten img  height 50px width 50px  WGfriends_twenty  width 20  WGaccepts  padding-bottom 5px   inbox  WGProfile_msgcontainer  padding:2px  WGinbox_count  font-size:12px font-weight:bold padding:3px text-align:left  WGinbox_errors  font-weight:bold color:red text-align:center  WG_inbox_InviteLabel  width:50px text-align:right  WG_inbox_InviteLabelView  font-weight:bold width:120px  WGmsgcontainer  padding:6px display:block margin-bottom:6px   inbox contacts  WGdatacells  border-bottom dashed BECEF8 1px  WGinbox_contactsTbl  background-color:#EEF2FD font-family:arial font-size:9pt width:100  contacts  height 275px overflow auto   inbox forms  WGbuttons_left  float left  WGbuttons_right  float right  WGinbox_from  color black font-weight normal text-decoration none  WGinbox_subject  width 530px  WGinbox_messageTo  background-color white border solid BECEF8 1px height 50px overflow:-moz-scrollbars-vertical overflow-x:hidden overflow-y:scroll width 530px   inbox pagination  WGinbox_buttons  display:inline float:left font-size:10px text-align:left width:70  WGinbox_pagination  display:inline text-align:right width:20  WGinbox_messagerpp  font-size:10px display:inline text-align:right width:20  WGmessage  display:inline float:left font-size:10px text-align:left width:70  WGmessagerpp  font-size:10px display:inline text-align:right float right  WG-previous-next  float right   inbox threads  WGevenThread  background-color e1e8fb border-bottom 1px solid bfcef9 padding 8px text-align:center  WGoddThread  background-color eef2fd border-bottom 1px solid bfcef9 padding 8px text-align center   pagination  WGProfile_pagination  font-size:10px text-align:right width:20  WGProfile_messagerpp  font-size:10px display:inline text-align:right width:20  WGProfile_paginationLeft  font-size:10px text-align:left width:20  WGProfile_paginationCenter  font-size:10px text-align:center width:20  WGProfile_pagination a  background-color:#f2f5fa border:solid bfc8dc 1px font-size:10px font-weight:bold padding:1px 5px text-decoration:none  WGProfile_pagination a:hover  background-color:#d8dee8 color:white  WGProfile_pagination prevNext  background-color transparent border none color black  WGProfile_pagination prevNext:hover  background-color transparent border none color black  WGProfile_pagination active  background-color:#d8dee8 border:solid bfc8dc 1px color:white font-size:10px font-weight:bold padding:1px 5px text-decoration:none  WGProfile_pagination img  vertical-align:middle margin-top:2px border:none   profile  WGProfile_registration  background:none border:none font-size:9pt font-family:arial margin:0 padding:0 width:100  WGProfile_registration header  background-color:#818997 color:#3e4f77 font-size:10px font-weight:bold text-align:left  WGProfile_registration header a  color:white text-decoration:none  WGProfile_registration help a  font-weight:bold text-decoration:none  WGProfile_registration inputText  font-size:10px margin-right:1px  WGProfile_registration label  font-size:9pt font-weight:bold text-align:right white-space:nowrap width:1  WGProfile_registration labelLeft  font-size:9pt font-weight:bold white-space:nowrap width:1 text-align left vertical-align top  WGProfile_registration smallLabel  font-size:8px text-align:center  WGProfile_registration smallText  font-size:9px  WGinboxTbl  display:block margin 4px padding 2px  WGProfile_registration bar WGProfile_registration barRight  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold margin:10px 0px 10px 0px min-height:25px padding:4px 4px 0px 4px vertical-align:middle  WGProfile_registration bar  text-align center  WGProfile_registration barRight  text-align right  WGProfile_registration bar a  color:#0B2259 font-size:10px font-weight:bold  WGProfile_registration barFive  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold text-align:center margin-right:3px min-height:25px padding:2px width:4.3  WGProfile_registration barTen  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold min-height:25px padding:2px text-align:center width:7.2  WGProfile_registration barFifteen  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold margin-right:3px min-height:25px padding:2px text-align:center width:15  WGProfile_registration barFifty  background-color:#f2f5fa border solid d8dee8 1px color:#3e4f77 font-size:14px font-weight:bold margin-right:3px min-height:25px padding:2px text-align:center width:50  WGbarContainer  display:block margin:10px 0px 10px 0px width:100   profile edit  WGfields  padding 2px  WGfields_left  padding:2px vertical-align:top width 15  WGfields_right  display:inline float:right padding:2px text-align:right width:80 vertical-align top  WGProfile  display:table margin 0 padding 0 width:100  WGProfileFields  border:0 padding 0 margin:0 width 100  WGProfileFields ol  display inline list-style-type none  WGProfileFields ul  list-style-type none display inline  WGProfileFields ul li  display inline-block display inline zoom 1   profile view  WGProfile_accepts  text-align:right background-color:gray padding:4px width:100  WGviewContainer  margin:0 padding:0 width:90  WGinternational  background-color:red color:white display:inline font-weight:bold padding:4px text-align:center  WGcategoryLabel  vertical-align:top width:90  WGprivateMessage  background-color:gray padding:4px text-align:right  WGprofileAlert  background-color:red color:white font-weight:bold padding:4px text-align:center width:100  WGprofilePhoto  vertical-align:top   profile errors  WGprofileErrors  background-color ff0000 color ffffff font-weight bold text-align center  WGprofilefield_required_off   WGprofilefield_required  background-color ffd6bb  WGprofilefield_error  background-color FF9494  WGerrorMsg  font-weight:bold color:red text-align:center   user  WGuserInvite_subject  background-color white border solid BECEF8 1px height 25px text-align left width 500px margin-left 50px margin-bottom 20px overflow:-moz-scrollbars-vertical overflow-x:hidden overflow-y:scroll   view profile  WGprofile_canEdit  text-align:center background-color:red padding:4px color:white font-weight:bold  WGprofile_fieldLabel  background DDE6FB padding:2px width:200px  WGprofile_fieldData  margin-left 5px  WGprofile_fieldStatus  padding:4px color:white font-weight:bold    TABS    TABS  outer  WGbottombutton  float:right padding-right:2px padding-top 2px position relative  WGcontent  padding:10px  WGcleartab  clear both height:0  WGsubContent   color setting for border under outer tabs that surrounds inner tabs  border solid d8dee8 6px  WGtopbutton  float:right clear:both padding-right:2px padding-top 2px position relative  ul.WGtopTabs ul.WGtopTabs li  list-style-type:none margin:10px 0px 0px 0px padding:0px position:relative width:auto Xposition:relative zoom:1  ul.WGtopTabs li  display:block float:left margin-right 3px  ul.WGtopTabs li b  background-color eef2fd border-top:solid d8dee8 1px display:block padding:4px 8px position:relative top:-1px  ul.WGtopTabs a   non-selected tabs color settings  display:block color:#9ea0bb important font-size:12px font-family Arial Helvetica sans-serif text-decoration:none background-color:#f2f5fa border-left solid d8dee8 1px border-right solid d8dee8 1px  ul.WGtopTabs a:hover ul.WGtopTabs a:hover b ul.WGtopTabs a.selected ul.WGtopTabs a.selected b   selected tab color settings  background-color:#d8dee8 color:#3e4f77  text-align right  TABS  YUI  WGcleardiv  clear both margin 0px 0px 0px 0px padding 0px  WGviewProfile wgView  border none font bold 10px Verdana color 3e4f77 text-decoration:none  WGview  position absolute right 4px top:4px  WGprofile_displayView  x-system-font:none border:medium none color:#0B2258 display:inline float:right font-family:Verdana font-size:10px font-size-adjust:none font-stretch:normal font-style:normal font-variant:normal font-weight:bold line-height:normal padding-right:8px padding-top:3px text-decoration none  WGprofile_displaySubContent   border around friends tab content  border solid d8dee8 6px border-top solid d8dee8 18px   Copyright c 2008 Yahoo Inc All rights reserved Code licensed under the BSD License http://developer.yahoo.net/yui/license.txt version 2.6.0   yui tabs color settings below   yui-navset defaults to yui-navset-top  WGsubContent yui-skin-sam yui-navset yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav   protect nested tabviews from other orientations  border:solid eef2fd  color between tab list and content  border-width:0 0 5px Xposition:relative zoom:1  WGsubContent yui-skin-sam yui-navset yui-nav a WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav a  background:#ffffff  tab background  border:solid ffffff border-width:0 1px color:#bfccdd position:relative text-decoration:none font-size:12px font-family Arial Helvetica sans-serif font-weight bold  WGsubContent yui-skin-sam yui-navset yui-nav a em WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav a em  border:solid eef2fd border-width:1px 0 0 cursor:hand padding:0.25em 75em left:0 right 0 bottom 0  protect from other orientations  top:-1px  for 1px rounded corners  position:relative  WGsubContent yui-skin-sam yui-navset yui-nav selected a WGsubContent yui-skin-sam yui-navset yui-nav selected a:focus  no focus effect for selected  WGsubContent yui-skin-sam yui-navset yui-nav selected a:hover   no hover effect for selected  background eef2fd  selected tab background  color 3e4f77 font-size:12px font-family Arial Helvetica sans-serif text-decoration:none font-weight bold  WGsubContent yui-skin-sam yui-navset yui-nav selected a WGsubContent yui-skin-sam yui-navset yui-nav selected a em  border-color:#eef2fd  selected tab border color   WGsubContent yui-skin-sam yui-navset yui-nav a:hover WGsubContent yui-skin-sam yui-navset yui-nav a:focus  background eef2fd  hover tab background  color 3e4f77 outline:0 font-size:12px font-family Arial Helvetica sans-serif text-decoration:none font-weight bold  WGsubContent yui-skin-sam yui-navset yui-content  background eef2fd  content background color   WGsubContent yui-skin-sam yui-navset yui-content WGsubContent yui-skin-sam yui-navset yui-navset-top yui-content  border:5px solid eef2fd  content border  padding:0.75em 1em  content padding    left and right orientations  WGsubContent yui-skin-sam yui-navset-left yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav WGsubContent yui-skin-sam yui-navset-right yui-nav  border-width:0 5px 0 0 Xposition:absolute  from tabview-core have to reiterate for skin-sam due to pos:rel on skin-sam yui-nav  top:0 bottom:0  stretch to fill content height   WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav WGsubContent yui-skin-sam yui-navset-right yui-nav  border-width:0 0 0 5px  WGsubContent yui-skin-sam yui-navset-left yui-nav li WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav li WGsubContent yui-skin-sam yui-navset-right yui-nav li  margin:0 0 0.3em  space between tabs  padding:0 0 0 1px  gecko make room for overflow   WGsubContent yui-skin-sam yui-navset-right yui-nav li  padding:0 1px 0 0  gecko make room for overflow   WGsubContent yui-skin-sam yui-navset-left yui-nav selected WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav selected  margin:0 1px 0.16em 0  WGsubContent yui-skin-sam yui-navset-right yui-nav selected  margin:0 0 0.16em 1px  WGsubContent yui-skin-sam yui-navset-left yui-nav a WGsubContent yui-skin-sam yui-navset-right yui-nav a  border-width:1px 0  WGsubContent yui-skin-sam yui-navset-left yui-nav a em WGsubContent yui-skin-sam yui-navset yui-navset-left yui-nav a em WGsubContent yui-skin-sam yui-navset-right yui-nav a em  border-width:0 0 0 1px padding:0.2em 75em top:auto left:-1px  for 1px rounded corners   WGsubContent yui-skin-sam yui-navset-right yui-nav a em  border-width:0 1px 0 0 left:auto right:-1px  for 1px rounded corners   WGsubContent yui-skin-sam yui-navset-left yui-nav a WGsubContent yui-skin-sam yui-navset-left yui-nav selected a WGsubContent yui-skin-sam yui-navset-left yui-nav a:hover WGsubContent yui-skin-sam yui-navset-right yui-nav a WGsubContent yui-skin-sam yui-navset-right yui-nav selected a WGsubContent yui-skin-sam yui-navset-right yui-nav a:hover WGsubContent yui-skin-sam yui-navset-bottom yui-nav a WGsubContent yui-skin-sam yui-navset-bottom yui-nav selected a WGsubContent yui-skin-sam yui-navset-bottom yui-nav a:hover  background-image:none  no left-right or bottom-top gradient   WGsubContent yui-skin-sam yui-navset-left yui-content  border:1px solid d8dee8  content border    bottom orientation  WGsubContent yui-skin-sam yui-navset-bottom yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav  border-width:5px 0 0  color between tab list and content   WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav selected WGsubContent yui-skin-sam yui-navset-bottom yui-nav selected  margin:-1px 0.3em 0 0  for overlap   WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav li WGsubContent yui-skin-sam yui-navset-bottom yui-nav li  padding:0 0 1px 0  gecko make room for overflow  vertical-align:top  WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav li a WGsubContent yui-skin-sam yui-navset-bottom yui-nav li a   WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav a em WGsubContent yui-skin-sam yui-navset-bottom yui-nav a em  border-width:0 0 1px top:auto bottom:-1px  for 1px rounded corners   WGsubContent yui-skin-sam yui-navset-bottom yui-content WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-content  border:1px solid f2f5fa  content border   WGsubContent yui-skin-sam  background-color d8dee8 padding 10px 5 5 5px display:block   yui tab placement settings below  WGsubContent yui-skin-sam yui-navset yui-nav li WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav li  margin:0 0.3em 0 0  space between tabs  padding:5px 0 0  gecko make room for overflow  zoom:1  WGsubContent yui-skin-sam yui-navset yui-nav selected WGsubContent yui-skin-sam yui-navset yui-navset-top yui-nav selected  margin:0 0.3em 1px 0  for overlap   WGsubContent yui-navset yui-nav li,.yui-navset yui-navset-top yui-nav li WGsubContent yui-navset yui-navset-bottom yui-nav li  margin:0 0.5em 0 0  WGsubContent yui-navset-left yui-nav li,.yui-navset-right yui-nav li  margin:0 0 0.5em  WGsubContent yui-navset yui-content yui-hidden  display:none  WGsubContent yui-navset yui-navset-left yui-nav,.yui-navset yui-navset-right yui-nav WGsubContent yui-navset-left yui-nav,.yui-navset-right yui-nav  width:6em  WGsubContent yui-navset-top yui-nav,.yui-navset-bottom yui-nav  width:auto  WGsubContent yui-navset yui-navset-left,.yui-navset-left  padding:0 0 0 6em  WGsubContent yui-navset-right  padding:0 6em 0 0  WGsubContent yui-navset-top,.yui-navset-bottom  padding:auto  WGsubContent yui-nav,.yui-nav li  list-style:none margin:0 padding:0  WGsubContent yui-navset li em  font-style:normal  WGsubContent yui-navset  position:relative zoom:1  WGsubContent yui-navset yui-content  zoom:1  WGsubContent yui-navset yui-nav li,.yui-navset yui-navset-top yui-nav li WGsubContent yui-navset yui-navset-bottom yui-nav li  display:inline-block display:-moz-inline-stack display:inline vertical-align:bottom cursor:pointer zoom:1  WGsubContent yui-navset-left yui-nav li,.yui-navset-right yui-nav li  display:block  WGsubContent yui-navset yui-nav a  position:relative  WGsubContent yui-navset yui-nav li a,.yui-navset-top yui-nav li a WGsubContent yui-navset-bottom yui-nav li a  display:block display:inline-block vertical-align:bottom zoom:1  WGsubContent yui-navset-left yui-nav li a,.yui-navset-right yui-nav li a  display:block  WGsubContent yui-navset-bottom yui-nav li a  vertical-align:text-top  WGsubContent yui-navset yui-nav li a em,.yui-navset-top yui-nav li a em WGsubContent yui-navset-bottom yui-nav li a em  display:block  WGsubContent yui-navset yui-navset-left yui-nav,.yui-navset yui-navset-right yui-nav WGsubContent yui-navset-left yui-nav,.yui-navset-right yui-nav  position:absolute z-index:1  WGsubContent yui-navset-top yui-nav,.yui-navset-bottom yui-nav  position:static  WGsubContent yui-navset yui-navset-left yui-nav,.yui-navset-left yui-nav  left:0 right:auto  WGsubContent yui-navset yui-navset-right yui-nav,.yui-navset-right yui-nav  left:auto right:0  WGsubContent yui-skin-sam yui-navset yui-nav selected a em  padding:0.35em 0.75em  WGsubContent yui-skin-sam yui-navset-left yui-nav,.yui-skin-sam yui-navset yui-navset-left yui-nav WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav,.yui-skin-sam yui-navset-right yui-nav  border-width:0 5px 0 0 bottom:0 top:0 Xposition:absolute  WGsubContent yui-skin-sam yui-navset yui-navset-right yui-nav,.yui-skin-sam yui-navset-right yui-nav  border-width:0 0 0 5px  WGsubContent yui-skin-sam yui-navset-left yui-nav li,.yui-skin-sam yui-navset yui-navset-left yui-nav li WGsubContent yui-skin-sam yui-navset-right yui-nav li  margin:0 0 0.16em padding:0 0 0 1px  WGsubContent yui-skin-sam yui-navset-right yui-nav li  padding:0 1px 0 0  WGsubContent yui-skin-sam yui-navset-left yui-nav a,.yui-skin-sam yui-navset-right yui-nav a  border-width:1px 0  WGsubContent yui-skin-sam yui-navset-left yui-nav a em,.yui-skin-sam yui-navset yui-navset-left yui-nav a em,.yui-skin-sam yui-navset-right yui-nav a em  border-width:0 0 0 1px left:-1px padding:0.2em 75em top:auto  WGsubContent yui-skin-sam yui-navset-right yui-nav a em  border-width:0 1px 0 0 left:auto right:-1px  WGsubContent yui-skin-sam yui-navset-left yui-nav a,.yui-skin-sam yui-navset-left yui-nav selected a,.yui-skin-sam yui-navset-left yui-nav a:hover WGsubContent yui-skin-sam yui-navset-right yui-nav a,.yui-skin-sam yui-navset-right yui-nav selected a,.yui-skin-sam yui-navset-right yui-nav a:hover WGsubContent yui-skin-sam yui-navset-bottom yui-nav a,.yui-skin-sam yui-navset-bottom yui-nav selected a WGsubContent yui-skin-sam yui-navset-bottom yui-nav a:hover  background-image:none  WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav selected WGsubContent yui-skin-sam yui-navset-bottom yui-nav selected  margin:-1px 0.16em 0 0  WGsubContent yui-skin-sam yui-navset yui-navset-bottom yui-nav li WGsubContent yui-skin-sam yui-navset-bottom yui-nav li  padding:0 0 1px 0 vertical-align:top ','000001000001000002000008'),('_9_eiaPgxzF_x_upt6-PNQ','gallery.css','','root/import/gallery-templates/gallery.css',1197988920,1284523757,'3','7','3','WebGUI::Asset::Snippet',0,'gallery.css gallery.css root import gallery templates gallery.css  FIXES FLOAT ISSUES WITHOUT THIS FLOATS GET ALL NUTSY ESPECIALLY IN OPERA AND SAFARI  clearfix:after  content  display block height 0 clear both visibility hidden  clearfix display inline-block  END FLOAT FIX  wgGallery  font-family:verdana arial text-align:left  firstBar  background black color:white font-size:18px font-weight:bold  firstBar title  margin-left:20px line-height:42px  firstBar title a  font-size:18px font-weight:bold color:white  firstBar buttons  float:right  firstBar buttons a  display:block float:left height:42px line-height:42px font-size:10px color:white font-weight:bold text-align:center padding:0px 5px  firstBar buttons rss  display:block height:29px position:relative background:transparent padding-top:13px  secondBar  background F1F1F1 text-align:left border-top:solid 8B8B8B 5px color black overflow hidden  secondBar author  font-size:10px  secondBar desc p  margin-left 20px margin-top 0 color black  pictures   searchArea  float:right  searchArea   float:left  searchArea input.searchText  border:solid black 1px width:100px margin:0px padding:2px margin-top:5px font-size:10px height:15px margin-right:10px  searchArea input.searchBtn  border:solid black 1px margin:0px padding:3px margin-top:5px font-size:10px vertical-align:middle cursor:pointer height:21px  searchArea a:link searchArea a:visited secondBar author a:link secondBar author a:visited  font-size:11px color:black  searchArea current  font-weight:bold text-transform:uppercase text-decoration:none font-size:10px  wgAlbum   display moz-inline-box Although this works in later versions of FireFox it does not work in 2.x  display:block float:left display inline-block  Op Saf IE  vertical-align top  IE Mac non capisce e a volte crea extra v space  width:250px margin:10px  wgAlbum albumTitle  background black color:white font-size:12px font-weight:bold padding:10px padding-right:50px border:solid 475f6f 1px border-bottom:solid 8B8B8B 5px text-align:left display:block  wgAlbum albumImage  background F1F1F1 border-left solid black 1px border-right solid black 1px padding-top:15px height:135px  wgAlbum albumImage a  height:135px width:200px overflow:hidden display:block margin:0px 23px  wgAlbum albumImage img  border-style:none display:block width:200px height:auto border:solid black 1px  wgAlbum albumDesc  background F1F1F1 border-left solid black 1px border-right solid black 1px border-bottom solid black 1px text-align:center padding 5px 23px  wgAlbum description  font-size:10px height:40px overflow:auto text-align:left border:solid silver 1px padding:5px background-color fff color:#222  albumDesc description   margin:2px 0px   PAGINATION STYLES  wgGallery paginationContainer  text-align:center background black height:42px  wgGallery container  clear:both text-align:center  wgGallery pagination  margin:0px auto 20px auto display:table list-style-type:none white-space:nowrap padding:0px height:42px  wgGallery pagination li  display:table-cell  wgGallery pagination a  display:block width:50px line-height:42px color:white font-size:10px text-align:center  wgPicture a:link wgPicture a:visited  color:black  wgPicture  width:250px margin:10px display moz-inline-box This does not work in earlier versions of Firefox  display:block float:left display inline-block  Op Saf IE  vertical-align top  IE Mac non capisce e a volte crea extra v space   wgPicture title  background:#e0e0e0 display:block font-size:12px text-align:center padding:2px 5px border:solid black 1px border-bottom:solid 8B8B8B 4px  wgPicture title a  font-size:12px  wgPicture thumbnail  text-align:center background F1F1F1 padding:15px 23px 15px 23px margin:0px border-left:solid black 1px border-right:solid black 1px  wgPicture thumbnail a  display:block width:200px height:120px overflow:hidden border:solid black 1px  wgPicture thumbnail img  border-style:none width:200px height:auto  wgPicture pictureDesc  padding:0px border-top:solid e1e1e1 1px border-bottom:solid gray 1px border-left:solid black 1px border-right:solid black 1px background:#F1F1F1 margin:0px  wgPicture pictureDesc description  margin:0px padding:5px font-size:10px  wgPicture details  background:#e0e0e0 border:solid 999 1px border-top:solid aaa 1px font-size:9px padding:1px 3px  wgPicture details date  float:right  wgPicture details comments  float:left  wgPicture details a  font-size:9px    BEGIN STYLES FOR PHOTO VIEW   The Photo view uses some/all of the above classes plus those in this section  wgSnapshot  float:left margin:10px max-width:250px width:25  wgSnapshot fieldset  background-color:#fefefe border:solid 555 2px padding:10px background-color:#f9f9f9 text-align:center  navigation  width 100 text-align center font-weight bold color navy  wgSnapshot p  max-width:230px  wgSnapshot navigation  width:100 margin:5px 0 0 text-align:center  wgSnapshot navigation img  border none  wgSnapshot legend  color:#333 font-size:15px font-weight:bold max-width:250px  wgSnapshot a.thumbnail img  width:200px height:auto border:solid 555 2px  wgSnapshot description  font-size:9px border:solid 555555 2px padding:5px width:190px margin:0px auto background-color:#fff height:50px overflow:auto text-align:left overflow:auto  wgSnapshot a.fullSize  margin:0px auto  wgPictureDetails  float:left width:70 margin:10px overflow hidden  wgPictureDetails a:link wgPictureDetails a:visited  color:black  wgPictureDetails fieldset  background-color:#fefefe border:solid 555 2px padding:10px background-color:#f9f9f9 margin-bottom:10px  wgPictureDetails legend  color:#333 font-size:15px font-weight:bold  rowOne rowTwo  margin:1px color:black padding:3px  rowOne  background EFEFEF border:solid CDCDCD 1px  rowTwo  background DCDCDC border:solid DDDDDD 1px  rowOne label rowTwo label  margin-left:15px text-align:left font-weight:bold font-size:11px  rowOne data rowTwo data  font-size:10px margin-left:5px  a.fullSize:link a.fullSize:visited  color:black display:block text-align:center font-weight:bold font-size:10px  wgComments  font-size:9px margin:10px width:90  wgComments title  font-size:14px font-weight:bold color:#333 border-bottom:solid 555555 2px padding-bottom:2px  wgComments title a  color:navy text-decoration:none  wgComments comment wgComments commentAlt  position:relative padding:5px  wgComments comment  background-color:#e1e1e1 border-top:solid F7F7F7 1px border-bottom:solid C9C9C9 1px  wgComments commentAlt  background-color:#f0f0f0 border-bottom:solid CDCDCD 1px border-top:solid FBFBFB 1px  wgComments number  float:left font-size:30px color:silver margin:5px 10px 5px 5px  wgComments posted  font-style:italic padding-top:3px font-size:9px color:gray  wgComments posted a  color:navy text-decoration:underline    BEGIN STYLES FOR THUMBNAIL VIEW   The Thumbnail view uses some/all of the above classes plus those in this section  thumbView  width:400px height:auto  thumbView thumbnail a  display:block width:350px height:auto border:solid black 1px  thumbView thumbnail img  border-style:none width:350px height:auto  thumb  width:100px height:65px overflow:hidden display:block float:left border:solid black 2px margin:10px z-index 0 position relative  thumb:hover  background-color transparent z-index 50 overflow visible  thumb img  width:100px height:auto border-style:none  thumb:hover img  bottom 65px left 75px position absolute width 250px    BEGIN STYLES FOR SLIDESHOW VIEW   The Slideshow view uses some/all of the above classes plus those in this section  wgSlideshow controls  background url(^FileUrl(root/import/gallery-templates/images/pagination_bg.jpg repeat-x width:500px height:42px margin:0px auto border:solid black 2px  wgSlideshow  text-align:center  slideshow-container  width:500px height:auto margin:0px auto text-align:center border:solid black 2px position:relative z-index:0  slideshow-container slideshow-item img  width:100 height:auto border-style:none display:block  slideshow-container slideshow-item title  background-color:black padding:3px color:white border-top:solid white 1px border-bottom:solid white 1px  slideshow-container slideshow-item title a  color:white font-size:11px font-weight:bold  slideshow-container slideshow-item counter  background-color:black padding:3px color:white font-size:11px font-weight:bold  slideshow-container slideshow-item synopsis  width:494px background-color:white padding:3px color:black font-size:11px font-weight:bold border-top:solid black 1px text-align:left    BEGIN STYLES FOR SEARCH VIEW   The Search view uses some/all of the above classes plus those in this section  adminWrapper  margin-top:20px  adminWrapper label  background:black font-weight:bold font-size:10px color:white  adminWrapper td.data input  background f1f1f1 vertical-align:middle  adminWrapper td.radio input  border-style:none background:none  adminWrapper forwardButton  cursor:pointer float:rigbt  adminWrapper forwardButton:hover  color:gold ','000001000001000015000016'),('i6-BofrJJYozovlzFBByXg','first-photo-button.png','','root/import/gallery-templates/images/first-photo-button.png',1270612331,1284523759,'3','7','3','WebGUI::Asset::File::Image',1,'first-photo-button.png first-photo-button.png root import gallery templates images first photo button.png','000001000001000015000017000031'),('fU_OZCmtdFNJ8a6bMve8ng','previous-photo-button.png','','root/import/gallery-templates/images/previous-photo-button.png',1270612331,1284523759,'3','7','3','WebGUI::Asset::File::Image',1,'previous-photo-button.png previous-photo-button.png root import gallery templates images previous photo button.png','000001000001000015000017000032'),('YXCtusAxb4vzZ5sTnUA5DA','next-photo-button.png','','root/import/gallery-templates/images/next-photo-button.png',1270612331,1284523759,'3','7','3','WebGUI::Asset::File::Image',1,'next-photo-button.png next-photo-button.png root import gallery templates images next photo button.png','000001000001000015000017000033'),('k_xuE82wwp8gFVl9aaaG8g','last-photo-button.png','','root/import/gallery-templates/images/last-photo-button.png',1270612331,1284523759,'3','7','3','WebGUI::Asset::File::Image',1,'last-photo-button.png last-photo-button.png root import gallery templates images last photo button.png','000001000001000015000017000034'),('NPM_WItpM5IzLWBhWjYfCA','photo-navigation-spacer.png','','root/import/gallery-templates/images/photo-navigation-spacer.png',1270612331,1284523759,'3','7','3','WebGUI::Asset::File::Image',1,'photo-navigation-spacer.png photo-navigation-spacer.png root import gallery templates images photo navigation spacer.png','000001000001000015000017000035'),('30h5rHxzE_Q0CyI3Gg7EJw','Cash Summary Screen (Default)','','shopping-cart-collateral-items/cash-summary',1273032715,1289360563,'3','7','4','WebGUI::Asset::Template',0,'Cash Summary Screen Default Cash Summary Screen Default shopping cart collateral items cash summary Shop/Credentials','000001000001000038000020'),('jysVZeUR0Bx2NfrKs5sulg','Ogone Summary Screen (Default)','','shopping-cart-collateral-items/ogone-summary',1273032715,1289360563,'3','7','4','WebGUI::Asset::Template',0,'Ogone Summary Screen Default Ogone Summary Screen Default shopping cart collateral items ogone summary Shop/Credentials','000001000001000038000021'),('300AozDaeveAjB_KN0ljlQ','PayPal Standard Summary Screen (Default)','','shopping-cart-collateral-items/paypal-std-summary',1273032715,1289360563,'3','7','4','WebGUI::Asset::Template',0,'PayPal Standard Summary Screen Default PayPal Standard Summary Screen Default shopping cart collateral items paypal std summary Shop/Credentials','000001000001000038000022'),('GqnZPB0gLoZmqQzYFaq7bg','PayPal Express Checkout Summary Screen (Default)','','shopping-cart-collateral-items/paypal-express-summary',1273032716,1289360563,'3','7','4','WebGUI::Asset::Template',0,'PayPal Express Checkout Summary Screen Default PayPal Express Checkout Summary Screen Default shopping cart collateral items paypal express summary Shop/Credentials','000001000001000038000023'),('stevestyle000000000001','Style 01','by Steve from Plain Black http://plainblack.com\r\n\r\nThe first of the WebGUI 7 styles','style_01',1147642499,1273032722,'3','7','12','WebGUI::Asset::Template',0,'Style 01 Style 01 by Steve from Plain Black http://plainblack.com The first of the WebGUI 7 styles style 01 style','000001000001000051000026'),('stevestyle000000000002','Style 02','by Steve from Plain Black http://plainblack.com\r\n\r\nThe second of the WebGUI 7 styles','style_02',1147642504,1273032718,'3','7','12','WebGUI::Asset::Template',0,'Style 02 Style 02 by Steve from Plain Black http://plainblack.com The second of the WebGUI 7 styles style 02 style','000001000001000052000016'),('stevestyle000000000003','Style 03','by Steve from Plain Black http://plainblack.com\r\n\r\nThe last of the WebGUI 7 style templates.','style_03',1147642510,1273032720,'3','7','12','WebGUI::Asset::Template',0,'Style 03 Style 03 by Steve from Plain Black http://plainblack.com The last of the WebGUI 7 style templates style 03 style','000001000001000053000020'),('t87D1138NhPHhA23-hozBA','CrystalX','','crystalx',1273032716,1273032716,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'CrystalX CrystalX crystalx','000001000001000067'),('QtBumey5ffc-xffRp1-7Aw','img','','crystalx/img',1273032716,1273032716,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'img img crystalx img','000001000001000067000001'),('-0sK2rX1cwQt1ipUSqsiQQ','bg.gif','','crystalx/img/bg.gif',1273032716,1273032716,'3','7','3','WebGUI::Asset::File::Image',1,'bg.gif bg.gif crystalx img bg.gif','000001000001000067000001000001'),('hS_eOaVz9Qb5ixndK9EXAw','header.jpg','','crystalx/img/header.jpg',1273032716,1273032716,'3','7','3','WebGUI::Asset::File::Image',1,'header.jpg header.jpg crystalx img header.jpg','000001000001000067000001000002'),('k2p-Be8C98pf2cRq7E-JHg','tab_link.gif','','crystalx/img/tab_link.gif',1273032716,1273032716,'3','7','3','WebGUI::Asset::File::Image',1,'tab_link.gif tab_link.gif crystalx img tab link.gif','000001000001000067000001000003'),('aYG4fjbMPbC4LCuuMp4gGA','tab_hover.gif','','crystalx/img/tab_hover.gif',1273032716,1273032716,'3','7','3','WebGUI::Asset::File::Image',1,'tab_hover.gif tab_hover.gif crystalx img tab hover.gif','000001000001000067000001000004'),('F122Ey0NtVAw6Lfv1M6G_Q','ico_archive.gif','','crystalx/img/ico_archive.gif',1273032716,1273032716,'3','7','3','WebGUI::Asset::File::Image',1,'ico_archive.gif ico_archive.gif crystalx img ico archive.gif','000001000001000067000001000005'),('qmXHKrQ6EDLSOGkrEKRUDA','bg_page_in.jpg','','crystalx/img/bg_page_in.jpg',1273032716,1273032716,'3','7','3','WebGUI::Asset::File::Image',1,'bg_page_in.jpg bg_page_in.jpg crystalx img bg page in.jpg','000001000001000067000001000006'),('4qZgXjPPO4fwV879yu5XUg','bg_page.JPG','','crystalx/img/bg_page.jpg',1273032716,1273032716,'3','7','3','WebGUI::Asset::File::Image',1,'bg_page.JPG bg_page.JPG crystalx img bg page.jpg','000001000001000067000001000007'),('mb-xeAugm5GJdvu-Wh0MtQ','search_submit.gif','','crystalx/img/search_submit.gif',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'search_submit.gif search_submit.gif crystalx img search submit.gif','000001000001000067000001000008'),('84Y9CwgzP6eNU7wZnk019Q','ico_date.gif','','crystalx/img/ico_date.gif',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'ico_date.gif ico_date.gif crystalx img ico date.gif','000001000001000067000001000009'),('ikXTtJKZfHVxqw-47E4AQA','ico_user.gif','','crystalx/img/ico_user.gif',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'ico_user.gif ico_user.gif crystalx img ico user.gif','000001000001000067000001000010'),('DhRWPTgzhvju_-TbMN3CwA','ico_comments.gif','','crystalx/img/ico_comments.gif',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'ico_comments.gif ico_comments.gif crystalx img ico comments.gif','000001000001000067000001000011'),('6njI-pZz2bwsjWh-Q1_11g','ico_list.gif','','crystalx/img/ico_list2.gif',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'ico_list.gif ico_list.gif crystalx img ico list2.gif','000001000001000067000001000012'),('_Hz1Gnd3yEnJzVS7l7nJMQ','content_all_bg.PNG','','crystalx/img/content_all_bg.png',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'content_all_bg.PNG content_all_bg.PNG crystalx img content all bg.png','000001000001000067000001000013'),('VOOrXK5dFnkGih7aTkuDWA','search.PNG','','crystalx/img/search.png',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'search.PNG search.PNG crystalx img search.png','000001000001000067000001000014'),('ruf-QejOkUHDRtfgakHlbA','col_title_bg_long.GIF','','crystalx/img/col_title_bg_long.gif',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'col_title_bg_long.GIF col_title_bg_long.GIF crystalx img col title bg long.gif','000001000001000067000001000015'),('FSHy5KjQjkt599PHS41seA','footer.jpg','','crystalx/img/footer.jpg',1273032717,1273032717,'3','7','3','WebGUI::Asset::File::Image',1,'footer.jpg footer.jpg crystalx img footer.jpg','000001000001000067000001000016'),('nuYYXAz4KNNxgfumfnpo_g','ico_top.gif','','crystalx/img/ico_top.gif',1273032718,1273032718,'3','7','3','WebGUI::Asset::File::Image',1,'ico_top.gif ico_top.gif crystalx img ico top.gif','000001000001000067000001000017'),('Mr7ljjoy6n4fZojpQWajKQ','ico_links.gif','','crystalx/img/ico_links.gif',1273032718,1273032718,'3','7','3','WebGUI::Asset::File::Image',1,'ico_links.gif ico_links.gif crystalx img ico links.gif','000001000001000067000001000018'),('ApkqpDOrJDxK3QrWBGSRIg','ico_archive2.gif','','crystalx/img/ico_archive2.gif',1273032718,1273032718,'3','7','3','WebGUI::Asset::File::Image',1,'ico_archive2.gif ico_archive2.gif crystalx img ico archive2.gif','000001000001000067000001000019'),('AzzTY0Lay1f_YGeQJFnQCA','ico_list.gif','','crystalx/img/ico_list.gif',1273032718,1273032718,'3','7','3','WebGUI::Asset::File::Image',1,'ico_list.gif ico_list.gif crystalx img ico list.gif','000001000001000067000001000020'),('OiJNwP1gAlcva8_yOtL4gA','CrystalX_style','by Ning from Pluton -- http://pluton.nl\n\nCrystalX gives your site a crystal-ish look and a strictly formal style. Feel free to download and apply it to your own site.\n\nOriginally designed by \"Nuvio Webdesign\" and collected by Open Source Web Design, converted to WebGUI theme by Ning.','crystalx_style',1273032718,1273032718,'3','7','3','WebGUI::Asset::Template',0,'CrystalX_style CrystalX_style by Ning from Pluton  http://pluton.nl CrystalX gives your site a crystal-ish look and a strictly formal style Feel free to download and apply it to your own site Originally designed by Nuvio Webdesign and collected by Open Source Web Design converted to WebGUI theme by Ning crystalx style style','000001000001000067000002'),('JOuCU4x5BJfVHfkfMkVQdQ','crystalx.css','','crystalx/crystalx.css',1273032718,1273032718,'3','7','3','WebGUI::Asset::Snippet',0,'crystalx.css crystalx.css crystalx crystalx.css  Project CrystalX URL http://www.nuvio.cz Output device screen projection Author Vit Dlouhy vit.dlouhy@nuvio.cz Nuvio www.nuvio.cz Last revision 2006-12-05 12:00 GMT+1 Structure display | position | float | overflow | width | height | border | margin | padding | background | align | font   min-height:1px body border:0 margin:0 padding:0 background:#F2F5FE url(\'^FileUrl(/crystalx/img/bg.gif 0 0 repeat-x font:70%/160 verdana\",sans-serif color:#192666 text-align:center a color:#192666 a:hover color:#4F6AD7 p border:0 margin:15px 0 padding:0 div display:block border:0 margin:0 padding:0 overflow:hidden h1 h2 h3 h4 h5 border:0 margin:15px 0 10px 0 padding:0 font-weight:bold h1 font-size:260 line-height:100 font-family:\"georgia\",serif font-weight:normal h2 font-size:180 line-height:100 font-family:\"georgia\",serif font-weight:normal h3 font-size:120 line-height:100 font-weight:bold h4 font-size:120 h5 font-size:100 table display:table border-collapse:collapse margin:15px 1px padding:0 border:1px solid B7CAF6 font-size:100 tr display:table-row th td display table-cell border:1px solid B7CAF6 margin:0 padding:5px vertical-align:top text-align:left th background:#E7ECFD text-align:center color:#192666 font-weight:bold ul ol display:block border:0 margin:15px 0 15px 40px padding:0 ol list-style-type:decimal li display:list-item border:0 margin:0 padding:0 min-height:1px ul ul ul ol ol ol ol ul margin 0 0 0 20px dl border-bottom:1px solid E0E8FA margin:0 padding:5px 10px background:#CEDBF9 dt border:0 margin:0 padding:0 font-weight:bold dd border:0 margin:0 0 0 30px padding:0 form border:0 margin:0 padding:0 fieldset border:1px solid ccc margin:15px 0 padding:10px legend margin-left:10px font-size:100 font-weight:bold color:#008 hr height:1px width:724px margin 5px 23px padding 0 background:#CCC border:0 solid CCC color:#CCC a img span border:0 margin:0 padding:0 overflow:hidden abbr acronym border-bottom:1px dotted CCC cursor:help del through text-decoration:line-through strong strong font-weight:bold cite em q var font-style:italic code kbd samp font-family:monospace font-size:110 box min-height:1px box:after content display:block line-height:0px font-size:0px visibility:hidden clear:both nom margin:0 noscreen display:none    main width:770px margin:0 auto text-align:left  Top empty space for the background img to fit  main topspace position:relative top:0 left:0 height:50px margin:0 padding:0  Header  header position:relative width:770px height:100px margin:0 padding:0 background:#233C9B url(\'^FileUrl(/crystalx/img/header.jpg 0 0 no-repeat color:#FFFFFF  Header  logo  header logo position:absolute top:35px left:35px margin:0 header logo a font-size:260 line-height:100 font-family:\"georgia\",serif font-weight:bold color:#FFF header logo a:hover color:#B5C4E3 text-decoration:none  Header  Search  header search form position:absolute top:35px right:20px height:30px header search formContents position:absolute top:0 right:0px width:200px height:28px margin:0 padding:0 border:0 background:url(\'^FileUrl(/crystalx/img/search.png 0 0 no-repeat font:bold 90%/100 verdana\",sans-serif color:#192666 header search input#keywords_formId width:140px margin:5px 8px padding:3px 0 border:0 background:#FFF font:bold 100%/100 verdana\",sans-serif color:#192666 header search search_form position:absolute top:0 right:0px width:41px height:28px cursor:point margin:0 padding:0  Search Result header search search_result position:absolute top:220px header search home_link header search no_result header search pagination visibility:hidden page page-in pagination color:#6182D1 font-weight:bold padding:5px text-align:right page page-in pagination a color:#6182D1 page page-in pagination a:hover color:#192666 page page-in home_link padding:5px 5px 15px color:#6182D1 font-weight:bold text-align:right page page-in home_link a color:#6182D1 page page-in home_link a:hover color:#192666 search_result margin:10px 0 dl#odd background:#A0B9F3 page page-in no_result margin:0 10px color:#192666 font-weight:bold  Main menu tabs  menu background:#192666 margin:0 5px padding:10px 10px 0 height:32px overflow:hidden menu a cursor:pointer font-size:11px  Page dynamic  page width:770px background:#FFFFFF url(\'^FileUrl(/crystalx/img/bg_page.jpg 0 0 repeat-y page-in min-height:400px background:url(\'^FileUrl(/crystalx/img/bg_page_in.jpg 0 0 no-repeat padding:10px 0 0  Strip  strip position:relative clear:both padding:3px 20px 10px 20px color:#6182D1  Strip  Location  strip location float left background:url(\'^FileUrl(/crystalx/img/ico_comments.gif 0 50 no-repeat padding 0 15px strip location a color:#6182D1 strip location a:hover color:#192666 strip location a#currentpage font-weight:bold text-decoration:none  Strip  DateTime  strip datetime float:right background:url(\'^FileUrl(/crystalx/img/ico_date.gif 0 50 no-repeat padding 0 10px 0 15px  Content Container  contentContainer margin:0 padding:0 20px width:730px overflow:hidden  Contents  contentContainer content clear:both margin:10px 10px 0 0 padding:20px max-width:710px background:url(\'^FileUrl(/crystalx/img/content_all_bg.png 0 0 no-repeat overflow:hidden contentContainer content h2 margin:0 10px padding:10px 25px color:#192666 background:url(\'^FileUrl(/crystalx/img/ico_list.gif 0 50 no-repeat contentContainer content p text-align:justify  Utility  utility background FFFFFF url(\'^FileUrl(/crystalx/img/bg_page.jpg 0 0 repeat-y padding 10px 0 15px  Utility  Toggles  toggles font-size:10px font-weight:bold text-align:left margin-left:42px toggles a margin:0 10px padding:2px 0 text-decoration:none border-bottom:1px dashed color:#6182D1 toggles a:hover border-bottom:1px solid color:#4F6AD7 toggles span.userAcc background:url(\'^FileUrl(/crystalx/img/ico_user.gif 0 50 no-repeat margin 0 0 0 8px  Footer  footer position:relative clear:both width:770px height:80px margin-bottom:30px background:url(\'^FileUrl(/crystalx/img/footer.jpg 0 0 no-repeat color:#6685CC footer a color:#6685CC footer a:hover color:#192666  Footer  back on top  top position:absolute top:55px left:550px top p position:relative width:30px height:25px margin:0 overflow:hidden top p a display:block position:absolute left:0 top:0 z-index:1 width:30px height:25px background:url(\'^FileUrl(/crystalx/img/ico_top.gif 0 0 no-repeat cursor:pointer top a:hover background:url(\'^FileUrl(/crystalx/img/ico_top.gif 30px 0 no-repeat  Footer  copyright  footer p#copyright position:absolute top:10px left:40px margin:0  Footer  created by  createdby position:absolute top:10px left:562px margin:0 color:#8CA3D8 createdby a color:#8CA3D8','000001000001000067000003'),('Am1J-meNBmhqFfEIWy6Gag','crystalX_Navigation','','crystalx/crystalx_navigation',1273032718,1286941531,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'crystalX_Navigation crystalX_Navigation crystalx crystalx navigation','000001000001000067000004'),('gaIOm5cr2TkT9Fk6QmZWug','crystalX_navi','','crystalx/crystalx_navi',1273032718,1273032718,'3','7','3','WebGUI::Asset::Template',0,'crystalX_navi crystalX_navi crystalx crystalx navi Navigation','000001000001000067000005'),('w0QifHLhsrzeOpFKl-DX-Q','crystalx_navi.css','','crystalx/crystalx_navi.css',1273032718,1273032718,'3','7','3','WebGUI::Asset::Snippet',0,'crystalx_navi.css crystalx_navi.css crystalx crystalx navi.css ','000001000001000067000006'),('x_hiUi1XZloBvV47Obnu8Q','crystalX_NavigationTrail','','crystalx/crystalx_navigationtrail',1273032718,1273032718,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'crystalX_NavigationTrail crystalX_NavigationTrail crystalx crystalx navigationtrail','000001000001000067000007'),('hpCk0B3vQzgc-QJhSol41w','crystalX_navitrail','','crystalx/crystalx_navitrail',1273032718,1273032718,'3','7','12','WebGUI::Asset::Template',0,'crystalX_navitrail crystalX_navitrail crystalx crystalx navitrail Navigation','000001000001000067000008'),('UUwEL6hLEPdrnkZnKRzFYQ','Site Search','','crystalx/site-search',1273032718,1273032718,'3','7','3','WebGUI::Asset::Wobject::Search',1,'Site Search Site Search crystalx site search','000001000001000067000009'),('OfKbvK7CrfMnfc8WDoF4Rg','crystalx_search','','crystalx/crystalx_search',1273032718,1273032718,'3','7','3','WebGUI::Asset::Template',0,'crystalx_search crystalx_search crystalx crystalx search Search','000001000001000067000010'),('CQp-RFA2pMh5lFSggPPPYg','[Style] Underground','Templates and images for the \"Underground\" style from StyleShout.com ','style-underground',1273032719,1273032719,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Style Underground Style Underground style underground Templates and images for the Underground style from StyleShout.com','000001000001000068'),('_Mi_NTd3x8UB96LWezWHnw','Images','','style-underground/images',1273032719,1273032719,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Images Images style underground images','000001000001000068000001'),('A_5LVQQWR73QZR8FFbny_w','bg.gif','','style-underground/images/bg.gif',1273032719,1273032719,'3','7','3','WebGUI::Asset::File::Image',1,'bg.gif bg.gif style underground images bg.gif','000001000001000068000001000001'),('wywIfa_VuTsq0c5Ed-W-MA','bullet.gif','','style-underground/images/bullet.gif',1273032719,1273032719,'3','7','3','WebGUI::Asset::File::Image',1,'bullet.gif bullet.gif style underground images bullet.gif','000001000001000068000001000002'),('xmykMFjri1O2NrYHbeToVQ','footerbg.gif','','style-underground/images/footerbg.gif',1273032719,1273032719,'3','7','3','WebGUI::Asset::File::Image',1,'footerbg.gif footerbg.gif style underground images footerbg.gif','000001000001000068000001000003'),('0IIGNBs_-INzqBC5VLeJgw','headerbg.gif','','style-underground/images/headerbg.gif',1273032719,1273032719,'3','7','3','WebGUI::Asset::File::Image',1,'headerbg.gif headerbg.gif style underground images headerbg.gif','000001000001000068000001000004'),('FXmePdyS0YKuZ1VCGGpK9w','quote.gif','','style-underground/images/quote.gif',1273032719,1273032719,'3','7','3','WebGUI::Asset::File::Image',1,'quote.gif quote.gif style underground images quote.gif','000001000001000068000001000005'),('66qCywiE_fiL9u5YIaJhgw','tableft.gif','','style-underground/images/tableft.gif',1273032719,1273032719,'3','7','3','WebGUI::Asset::File::Image',1,'tableft.gif tableft.gif style underground images tableft.gif','000001000001000068000001000006'),('n5VpG4lFsOG1elaWDQbilw','tabright.gif','','style-underground/images/tabright.gif',1273032719,1273032719,'3','7','3','WebGUI::Asset::File::Image',1,'tabright.gif tabright.gif style underground images tabright.gif','000001000001000068000001000007'),('g3JH1PRq6m6Bj_PnGpcrSQ','CSS','','style-underground/css',1273032719,1273032719,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'CSS CSS style underground css','000001000001000068000002'),('egpnaaFqWmJwYTZ5CvFH9g','Underground.css','','style-underground/css/underground.css',1273032719,1273032719,'3','7','3','WebGUI::Asset::Snippet',0,'Underground.css Underground.css style underground css underground.css  AUTHOR Erwin Aligam WEBSITE http://www.styleshout.com TEMPLATE NAME Underground TEMPLATE CODE S-0006 VERSION 1.1 Changes for WebGUI by Doug Bell Preaction doug@plainblack.com   HTML ELEMENTS   top elements    margin 0 padding 0  body  margin 0 padding 0 font 70%/1.5 Verdana Tahoma Arial Helvetica sans-serif color 333 background FFF url(^FileUrl(style-underground/images/bg.gif repeat-x   links  a  color 003366 background-color inherit text-decoration none  a:hover  color CC0001 background-color inherit   headers  h1 h2 h3  font-family Arial Trebuchet MS Sans-Serif font-weight bold color 333  h1  font-size 120 letter-spacing 5px  h2  font-size 115 text-transform uppercase  h3  font-size 115 color 003366   images  img  border 2px solid CCC  img.float-right  margin 5px 0px 10px 10px  img.float-left  margin 5px 10px 10px 0px  h1 h2 h3 p  padding 0 margin 10px  ul ol  margin 10px 20px padding 0 20px  code  margin 10px 0 padding 10px text-align left display block overflow auto font 500 1em/1.5em Lucida Console courier new monospace  white-space pre  background FAFAFA border 1px solid f2f2f2 border-left 4px solid CC0000  acronym  cursor help border-bottom 1px solid 777  blockquote  margin 10px padding 0 0 0 32px background FAFAFA url(^FileUrl(style-underground/images/quote.gif no-repeat 5px 10px important background-position 8px 10px border 1px solid f2f2f2 border-left 4px solid CC0000 font-weight bold   form elements  form  margin:10px padding 0 5px border 1px solid f2f2f2 background-color FAFAFA  label  display:block font-weight:bold margin:5px 0  input  padding 2px border:1px solid eee font normal 1em Verdana sans-serif color:#777  textarea  width:400px padding:2px font normal 1em Verdana sans-serif border:1px solid eee height:100px display:block color:#777  input.button  margin 0 font bolder 12px Arial Sans-serif border 1px solid CCC padding 1px background FFF color CC0000   search form  form.search  position absolute top 5px right 5px padding 0 margin 0 border none background-color transparent  form.search input.textbox  margin 0 width 120px border 1px solid CCC background FFF color 333  form.search input.searchbutton  margin 0 font-size 100 font-family Arial Sans-serif border 1px solid CCC background FFFFFF url(^FileUrl(style-underground/images/headerbg.gif repeat-x bottom left padding 1px font-weight bold height 23px color 333 width 60px   LAYOUT  wrap  margin 0 auto width 90   header  header  position relative margin 0 padding 0 height 60px  header span#slogan  z-index 3 position absolute left 3px bottom 7px font bold 1.2em Verdana Arial Tahoma Sans-serif color FFF  header-logo  position relative clear both height 50px margin 0 padding 0  header-logo logo  position absolute top 3px left 5px font bold 30px trebuchet MS Arial Tahoma Sans-Serif margin 0 padding 0 letter-spacing 1px color 000   navigation tabs  header ul  position absolute margin:0 list-style:none right:-18px  bottom 3px font bold 13px Trebuchet MS Arial Sans-serif  header li  display:inline margin:0 padding:0  header a  float:left background url(^FileUrl(style-underground/images/tableft.gif no-repeat left top margin:0 padding:0 0 0 4px text-decoration:none  header a span  float:left display:block background url(^FileUrl(style-underground/images/tabright.gif no-repeat right top padding:5px 15px 4px 6px color:#FFF   Commented Backslash Hack hides rule from IE5-Mac  header a span float:none  End IE5-Mac hack  header a:hover span  color:#FFF  header a:hover  background-position:0 42px  header a:hover span  background-position:100 42px  header current a  background-position:0 42px  header current a span  background-position:100 42px   main column  main  float right margin 0 padding 0 width 78  main h1  margin 10px 0 padding 4px 0 4px 8px font-size 105 color FFF text-transform uppercase background-color CC0000 letter-spacing 5px   sidebar  sidebar  float left width 20 margin 0 padding 0 background-color FFFFFF  sidebar h1  margin 10px 0 0 0 padding 4px 0 4px 8px font bold 105 Arial Sans-Serif color FFF text-transform uppercase background 333 letter-spacing 1px  sidebar left-box  border 1px solid EBEBEB margin 0 0 5px 0 background FFF  sidebar ul.sidemenu  list-style none text-align left margin 3px 0px 8px 0 padding 0 text-decoration none  sidebar ul.sidemenu li  border-bottom 1px solid f2f2f2 background url(^FileUrl(style-underground/images/bullet.gif no-repeat 3px 2px padding 3px 5px 3px 25px margin 0  sidebar ul.sidemenu a  font-weight bolder padding 3px 0px background none   footer  footer  clear both border-top 1px solid f2f2f2 background FFF url(^FileUrl(style-underground/images/footerbg.gif repeat-x padding 2px 0 10px 0 text-align center line-height 1.5em font-size 95  footer a  text-decoration none font-weight bold   alignment classes  float-left  float left  float-right  float right  align-left  text-align left  align-right  text-align right   display and additional classes  clear  clear both  red  color CC0000  comments  margin 20px 10px 5px 10px padding 3px 0 border-bottom 1px dashed EFF0F1 border-top 1px dashed EFF0F1 ','000001000001000068000002000001'),('BBpxqoSseIor5C9ei9JEFQ','Underground WebGUI.css','','style-underground/css/underground-webgui.css',1273032719,1273032719,'3','7','3','WebGUI::Asset::Snippet',0,'Underground WebGUI.css Underground WebGUI.css style underground css underground webgui.css wg-toolbar p  margin 0px  img.wg-toolbar-icon  border 0px none  toolbarIcon  margin 0px ','000001000001000068000002000002'),('G0hl4VilbFKipToyxKqFrg','Prototypes','This folder holds prototype WebGUI assets with the correct templates pre-selected. ','style-underground/prototypes',1273032719,1273032719,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Prototypes Prototypes style underground prototypes This folder holds prototype WebGUI assets with the correct templates pre-selected','000001000001000068000003'),('GWU2qZqe6yEuAKG-5HtBdg','Templates','','style-underground/templates',1273032719,1273032719,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Templates Templates style underground templates','000001000001000068000004'),('Qk24uXao2yowR6zxbVJ0xA','[style] Underground','by Doug from Plain Black http://plainblack.com\r\n\r\nThis is the Underground style from http://www.styleshout.com/ made into a WebGUI package. A simple, functional style.','style-underground/style-underground',1273032719,1285733565,'3','7','3','WebGUI::Asset::Template',0,'style Underground style Underground by Doug from Plain Black http://plainblack.com This is the Underground style from http://www.styleshout.com made into a WebGUI package A simple functional style style underground style underground style','000001000001000068000004000001'),('39KNX53B4nYJAyIE1lu8ZQ','[nav] Underground Top Navigation','','style-underground/nav-underground-top-navigation',1273032720,1273032720,'3','7','3','WebGUI::Asset::Template',0,'nav Underground Top Navigation nav Underground Top Navigation style underground nav underground top navigation Navigation','000001000001000068000004000002'),('ztfi__vHJLsQDsMenrEn-w','[nav] Underground Side Navigation','','style-underground/nav-underground-side-navigation',1273032720,1273032720,'3','7','3','WebGUI::Asset::Template',0,'nav Underground Side Navigation nav Underground Side Navigation style underground nav underground side navigation Navigation','000001000001000068000004000003'),('8qyrDCNeggB4dzKiOoRuiQ','[admintoggle] Underground Admin Toggle','','style-underground/templates/admintoggle-underground-admin-toggle',1273032720,1273032720,'3','7','3','WebGUI::Asset::Template',0,'admintoggle Underground Admin Toggle admintoggle Underground Admin Toggle style underground templates admintoggle underground admin toggle AdminToggle','000001000001000068000004000004'),('M1NyNeS5jpdIsiIWFiJprw','View My Account','','style-underground/templates/view-my-account',1273032720,1273032720,'3','7','3','WebGUI::Asset::Template',0,'View My Account View My Account style underground templates view my account Macro/a_account','000001000001000068000004000005'),('AsfpsOpsGzZCb9m7MyxPuw','Navigation','','style-underground/navigation',1273032720,1273032720,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Navigation Navigation style underground navigation','000001000001000068000005'),('n-Vr_wgxOkwiHGt1nJto9w','Top Navigation','','style-underground/top-navigation',1273032720,1273032720,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'Top Navigation Top Navigation style underground top navigation','000001000001000068000005000001'),('jmqLxnoWb6p92Cr12lf1hw','Side Navigation','','style-underground/side-navigation',1273032720,1273032720,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'Side Navigation Side Navigation style underground side navigation','000001000001000068000005000002'),('8E2UOnj_XPEghTj7nfVM0g','Search','','style-underground/search',1273032720,1273032720,'3','7','3','WebGUI::Asset::Wobject::Search',1,'Search Search style underground search','000001000001000068000006'),('1qFjOEiILIwr1xB5_ebppQ','Greenportal','','greenportal',1273032721,1273032721,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Greenportal Greenportal greenportal','000001000001000069'),('xD76UfQ_JnSgTLBNvytcpQ','greenportal_image','','greenportal_image',1273032721,1273032721,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'greenportal_image greenportal_image greenportal image','000001000001000069000001'),('pAXR7Kby4O-dSxOwLp1GaA','menu_top.png','','greenportal_image/menu_top.png',1273032721,1273032721,'3','7','12','WebGUI::Asset::File::Image',1,'menu_top.png menu_top.png greenportal image menu top.png','000001000001000069000001000001'),('TthzMLO4n3qxy59QZ5YBHg','menu_dark.png','','greenportal_image/menu_dark.png',1273032721,1273032721,'3','7','12','WebGUI::Asset::File::Image',1,'menu_dark.png menu_dark.png greenportal image menu dark.png','000001000001000069000001000002'),('3n31SQjYa150TBrRBgMPhA','menu_light.png','','greenportal_image/menu_light.png',1273032721,1273032721,'3','7','12','WebGUI::Asset::File::Image',1,'menu_light.png menu_light.png greenportal image menu light.png','000001000001000069000001000003'),('R4RxDufGbbIzEmpcoEcLrw','logo.jpg','','greenportal_image/logo.jpg',1273032721,1273032721,'3','7','12','WebGUI::Asset::File::Image',1,'logo.jpg logo.jpg greenportal image logo.jpg','000001000001000069000001000004'),('xyyn5mz3xGyvrcI1rY8C-w','greenportal.css','','greenportal.css',1273032721,1273032721,'3','7','12','WebGUI::Asset::Snippet',0,'greenportal.css greenportal.css greenportal.css  CSS Document  body,html  text-align:center height 100  margin 3px 3px 3px 3px font-family Verdana Sans-Serif line-height 125 color:#CCCCCC background 222625  h1,h2,h3,h4,h5,h6{font-weight:bold h1{font-size:18px h2{font-size:16px h3{font-size:14px h4{font-size:12px h5{font-size:11px h6{font-size:10px main  width:80 height:100 margin-left:auto margin-right:auto position:relative  body > main  height:auto min-height:100 font-size:10px  main mainHeader  width:100 height:125px background url(\'^FileUrl(/greenportal_image/logo.jpg top center no-repeat margin-bottom:5px position:relative  main mainHeader title  position:absolute top:55px left:180px font-size:36pt font-family Edwardian Script ITC Arial Sans-Serif  font-variant small-caps   font-style italic  color:#CCCCCC font-weight bold overflow visible padding 20px  main mainHeader title a  color:#CCCCCC text-decoration:none  main mainHeader title a:hover  color:#FFFFFF text-decoration:none font-size:37pt  main mainMenu  width:186px position:absolute top:125px left:0px  main mainMenu li  list-style none font-size 9pt text-align:left  main mainMenu menuTop  color:#99CC33 background url(\'^FileUrl(/greenportal_image/menu_top.png no-repeat margin-left:-3px padding:2px 0px 3px 26px width:162px  186px-24px font-size:10pt font-weight bold  main mainMenu indent1  margin-left:0px width:186px  main mainMenu indent2  margin-left:17px width:168px  186-17px  main mainMenu a  display:block height:24px font-weight:bold text-decoration:none color:#CCCCCC background url(\'^FileUrl(/greenportal_image/menu_dark.png no-repeat padding:2px 0px 0px 24px  main mainMenu a:hover,active  display:block height:24px font-weight:bold text-decoration:none color:#FFFFFF background url(\'^FileUrl(/greenportal_image/menu_light.png no-repeat padding:2px 0px 0px 24px  main mainContent   width:75 height:100 margin-top:5px margin-left:215px text-align:left border 1px solid CCCCCC  main > mainContent  margin-top:0px  min-height:500px  main > mainContent > p  margin-top:0px  main mainContent topMenu margin-right 10px text-align right font-size 8pt font-weight bold  main mainContent topMenu a color 99CC33 text-decoration none  main mainContent topMenu a:hover text-decoration:underline  main mainContent mainText  margin 10px 5px 5px 10px font-size:8pt padding 5px min-height 423px text-align left  main mainContent mainText a color:#FFFFFF text-decoration none font-weight bold  main mainContent mainText a:hover  color:#FFFF00 text-decoration none font-weight bold  main mainFooter  text-align:left padding:10px margin:5px 0px 5px 200px  width:75 font-size:9px background:url(^FileUrl(/greenportal_image/logo.jpg no-repeat  main mainFooter a  color:#CCCCCC font-weight:bold text-decoration:none  main mainFooter a:hover  color:#FFFFFF font-weight:bold text-decoration:none ','000001000001000069000002'),('KKt0VB_eoQxw9xEsHsAhag','Greenportal_style','by Ning from PlutonIT http://pluton.nl\n\nA Joomla! Open Source design released under the GNU/GPL License. Enhanced and converted into WebGUI theme by Ning. The original PHP and CSS file can be downloaded following the author\'s link: http://www.studentsdesign.de/','greenportal_style',1273032721,1273032721,'3','7','12','WebGUI::Asset::Template',0,'Greenportal_style Greenportal_style by Ning from PlutonIT http://pluton.nl A Joomla Open Source design released under the GNU/GPL License Enhanced and converted into WebGUI theme by Ning The original PHP and CSS file can be downloaded following the author\'s link http://www.studentsdesign.de greenportal style style','000001000001000069000003'),('h0bOzz7WvdaVZXsjpwtkww','greenportal_Navigation','','greenportal_navigation',1273032721,1273032721,'3','7','3','WebGUI::Asset::Wobject::Navigation',1,'greenportal_Navigation greenportal_Navigation greenportal navigation','000001000001000069000004'),('_z3ukLCqvoaUygfsbbkBzw','Greenportal_menu','','greenportal_menu',1273032721,1273032721,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_menu Greenportal_menu greenportal menu Navigation','000001000001000069000005'),('qFOfW1sKyOTnGNcP6BXbwg','greenportal_NavigationTop','','greenportal_navigationtop',1273032721,1273032721,'3','7','12','WebGUI::Asset::Wobject::Navigation',1,'greenportal_NavigationTop greenportal_NavigationTop greenportal navigationtop','000001000001000069000006'),('Pt38T5_MWSue2e1N36MLdw','Greenportal_menuTop','','greenportal_menutop',1273032721,1273032721,'3','7','12','WebGUI::Asset::Template',0,'Greenportal_menuTop Greenportal_menuTop greenportal menutop Navigation','000001000001000069000007'),('LDcM1Iop17nF2MoSa7zo_Q','Greenportal_dataform','','greenportal_dataform',1273032721,1273032721,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_dataform Greenportal_dataform greenportal dataform DataForm','000001000001000069000008'),('hVF1taXj4bfd7DuL4XDMYg','Greenportal_datalist','','greenportal_datalist',1273032721,1273032721,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_datalist Greenportal_datalist greenportal datalist DataForm/List','000001000001000069000009'),('x4-2QYRSrIB_BJfnSKKj4w','Greenportal_acknowledgement','','greenportal_acknowledgement',1273032721,1273032721,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_acknowledgement Greenportal_acknowledgement greenportal acknowledgement DataForm','000001000001000069000010'),('423R4Y6XIt3wUzlnLo-chg','Greenportal_forum','','greenportal_forum',1273032721,1273032721,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_forum Greenportal_forum greenportal forum Collaboration','000001000001000069000011'),('oZ1Mk-zExYUyD-JsjTvaHg','Greenportal_thread','','greenportal_thread',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_thread Greenportal_thread greenportal thread Collaboration/Thread','000001000001000069000012'),('mYwS8CZaOLMt0raaKXGZcQ','Greenportal_postform','','greenportal_postform',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_postform Greenportal_postform greenportal postform Collaboration/PostForm','000001000001000069000013'),('kSGR4OHsKmhLQTuLkisOww','Greenportal_search','','greenportal_search',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_search Greenportal_search greenportal search Collaboration/Search','000001000001000069000014'),('G5DgNizuG3jXkjPp6UaGrA','Greenportal_Calendar','','greenportal_calendar',1273032722,1273032722,'3','7','3','WebGUI::Asset::Wobject::Folder',1,'Greenportal_Calendar Greenportal_Calendar greenportal calendar','000001000001000069000015'),('U78V5IJHVljvRTb6ydsTHg','Greenportal_calendarMonth','','greenportal_calendar/greenportal_calendarmonth',1273032722,1279073449,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_calendarMonth Greenportal_calendarMonth greenportal calendar greenportal calendarmonth Calendar/Month','000001000001000069000015000001'),('Xqc3qPUXoFE8dt9qocdWig','Greenportal_calendarWeek','','greenportal_calendar/greenportal_calendarweek',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_calendarWeek Greenportal_calendarWeek greenportal calendar greenportal calendarweek Calendar/Week','000001000001000069000015000002'),('IBTb7wllSt7RxFmmvm9pkQ','Greenportal_calendarDay','','greenportal_calendar/greenportal_calendarday',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_calendarDay Greenportal_calendarDay greenportal calendar greenportal calendarday Calendar/Day','000001000001000069000015000003'),('Z1EM7JMI_4SkyfaZffSElw','Greenportal_calendarEvent','','greenportal_calendar/greenportal_calendarevent',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_calendarEvent Greenportal_calendarEvent greenportal calendar greenportal calendarevent Calendar/Event','000001000001000069000015000004'),('fJg7SKpGZwzSNx3_ebki1A','Greenportal_calendarEventEdit','','greenportal_calendar/greenportal_calendareventedit',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_calendarEventEdit Greenportal_calendarEventEdit greenportal calendar greenportal calendareventedit Calendar/EventEdit','000001000001000069000015000005'),('ihf4Rx6p72xn_nVKaIeOaw','Greenportal_calendarSearch','','greenportal_calendar/greenportal_calendarsearch',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_calendarSearch Greenportal_calendarSearch greenportal calendar greenportal calendarsearch Calendar/Search','000001000001000069000015000006'),('jrWJ6nHXkqgFbml7BZ9chw','Greenportal_submission','','greenportal_submission',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_submission Greenportal_submission greenportal submission Collaboration/Thread','000001000001000069000016'),('Ys6f3vpe0y1uRcaCJ2TlFw','Greenportal_messageboard','','greenportal_messageboard',1273032722,1273032722,'3','7','3','WebGUI::Asset::Template',0,'Greenportal_messageboard Greenportal_messageboard greenportal messageboard MessageBoard','000001000001000069000017'),('default_CS_unsubscribe','Default Collaboration System Unsubscribe','','collaboration_unsubscribe',1274238758,1277868922,'3','7','4','WebGUI::Asset::Template',0,'Default Collaboration System Unsubscribe Default Collaboration System Unsubscribe collaboration unsubscribe Collaboration/Unsubscribe','000001000001000008000030'),('_hELmIJfgbAyXFNqPyApxQ','admin.css','','root/import/gallery-templates/admin.css',1197330678,1284523757,'3','7','3','WebGUI::Asset::Snippet',0,'admin.css admin.css root import gallery templates admin.css adminWrapper  text-align:left font-family:arial font-size:11px position relative z-index 2  h2  font-size:15px  messageStyle  font-weight:bold font-family:arial font-size:10px margin-bottom:8px  adminButton  border:solid silver 1px background-color:#e0e0e0 font-weight:bold font-size:10px color:#333 cursor:pointer padding 0.5em 1em  adminTable  border:solid silver 1px background-color:#F0F0F0 color black width:320px padding:5px  adminTable select adminTable input adminTable textarea border:solid gray 1px font-size:10px padding-left:5px  label  white-space:nowrap text-align:right padding-right:10px font-weight:bold width:1px vertical-align:top  galleryOrg  list-style-type:none display:block width:95 margin-top:3px padding-top:10px margin-left:5px border:gray solid 1px text-align:center font-family:verdana,arial font-size:9pt background-color:#dedede  galleryOrgList  margin 0px padding 0px  galleryOrg left  float left width 36  galleryOrg right  width 63  galleryOrg img  display:block height:150px margin:0px auto border none  galleryOrg select galleryOrg input galleryOrg textarea  border:solid gray 1px font-size:10px padding-left:5px  promote  margin-left:3px  promote img  height:14px width:16px  demote  margin-right:3px  demote img  height:14px width:16px  delete img  height 14px  numbering  position:absolute top:0px left:0px padding:1px background-color:black color:white moz-border-radius-bottomRight:5px  input.captionEnter  width:93px clear:both margin-bottom:3px  galleryOrg button  border-style:none background:none  galleryOrg button img  width:16px height:auto  galleryOrg synopsis input  width:80px ','000001000001000015000015'),('mfHGkp6t9gdclmzN33OEnw','Default Twitter Choose Username','','root/import/auth/twitter/chooseusername/default-twitter-choose-username',1277868927,1277868927,'3','7','12','WebGUI::Asset::Template',0,'Default Twitter Choose Username Default Twitter Choose Username root import auth twitter chooseusername default twitter choose username Auth/Twitter/ChooseUsername','000001000001000070'),('68sKwDgf9cGH58-NZcU4lg','Welcome','','home',1124395696,1271355027,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Welcome Home home','000001000002'),('bX5rYxb6tZ9docY6sUhBlw','Getting Started','\nCongratulations on successfully installing the WebGUI Content Engine&reg;. If you used the Site Starter to select a set of default pages, you will see those pages in the site navigation. You will also notice that a number of additional pages appear, such','getting_started/getting-started',1147642514,1278013772,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Getting Started Getting Started getting started getting started Congratulations on successfully installing the WebGUI Content Engine® If you used the Site Starter to select a set of default pages you will see those pages in the site navigation You will also notice that a number of additional pages appear such as this page These are default pages added for your convenience to help you get started with WebGUI and find the resources you need Feel free to remove these extra pages whenever you are ready To get started managing content download the PDF document below This document provides a basic introduction to the WebGUI user interface WebGUI Basics PDF Once you have read this document you may want to head over to the Documentation section where you can find more WebGUI resources  ','000001000002000001000001'),('8Bb8gu-me2mhL3ljFyiWLg','Talk to the Experts','Plain Black&reg; created the WebGUI Content Engine&reg; and is here to answer \nyour questions and provide you with services to make sure your WebGUI \nimplementation is entirely successful. We bend over backwards to make \nsure you\'re a success. Contact us ','your_next_step',1124395696,1271359194,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Talk to the Experts Your Next Step your next step Plain Black® created the WebGUI Content Engine® and is here to answer your questions and provide you with services to make sure your WebGUI implementation is entirely successful We bend over backwards to make sure you\'re a success Contact us today to see how we can help you','000001000002000002'),('ix1p0AbwKAz8QWB-T-HHfg','Get Support','Plain Black provides support packages to fit any budget or need. Start out with online support which costs only $500 per year, or work with Plain Black to build a custom support package tailored to your specific needs. No matter what level of support you ','yns/support',1147642516,1271359087,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Support Get Support yns support Plain Black provides support packages to fit any budget or need Start out with online support which costs only $500 per year or work with Plain Black to build a custom support package tailored to your specific needs No matter what level of support you purchase you will get personalized and friendly service in a timely manner  ','000001000002000002000001'),('iCYOjohB9SKvAPr6bXElKA','Get Hosting','Plain Black\'s professionally trained WebGUI experts can handle the task\nof hosting your web site, intranet, or extranet. Let us deal with upgrades, security, and server management so you focus on building your WebGUI site, which is where your time and exp','yns/hosting',1147642516,1271445525,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Hosting Get Hosting yns hosting Plain Black\'s professionally trained WebGUI experts can handle the task of hosting your web site intranet or extranet Let us deal with upgrades security and server management so you focus on building your WebGUI site which is where your time and expertise should be spent And when you sign up with hosting online support is included  ','000001000002000002000002'),('4Yfz9hqBqM8OYMGuQK8oLw','Get Features','WebGUI\'s robust API allows for easy customization. Plain Black\'s team of developers can create any features you need for your site. We\'ve built hundreds of custom applications for people. From simple macros, to custom single sign on systems, to applicatio','yns/features',1147642516,1271352537,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Features Get Features yns features WebGUI\'s robust API allows for easy customization Plain Black\'s team of developers can create any features you need for your site We\'ve built hundreds of custom applications for people From simple macros to custom single sign on systems to applications that will manage your entire company our team will leverage the power of WebGUI to your advantage  ','000001000002000002000003'),('Wl8WZ43g2rK5AYr9o4zY7w','Get Style','Branding and visual appeal are powerful marketing tools. Don\'t let your site become a wallflower. Plain Black\'s professional design team can create a custom design to make your site stand out. Our team is fast, easy to work with, and can even migrate your','yns/style',1147642516,1271445539,'3','7','4','WebGUI::Asset::Wobject::Article',1,'Get Style Get Style yns style Branding and visual appeal are powerful marketing tools Don\'t let your site become a wallflower Plain Black\'s professional design team can create a custom design to make your site stand out Our team is fast easy to work with and can even migrate your existing content into your new WebGUI site  ','000001000002000002000004'),('2TqQc4OISddWCZmRY1_m8A','Join Us','The WebGUI project community is a diverse and talented group. If you \nwould like to contribute back to the project there are many ways to \nbecome involved. ','join_us',1124395696,1271357565,'3','7','3','WebGUI::Asset::Wobject::Layout',1,'Join Us Join Us join us The WebGUI project community is a diverse and talented group If you would like to contribute back to the project there are many ways to become involved','000001000002000004'),('k2Qj03FrAOXYra8kDJYYXw','IRC (Internet Relay Chat)','You can find members of the community on the #webgui chat channel on the Freenode IRC network. If you\'re not \nfamiliar with IRC, it\'s essentially like a chat room. A few things you\'ll need to know: \n\n\n\nYou need an IRC client program. There are many availa','join_us/irc',1271357513,1271357513,'3','7','3','WebGUI::Asset::Wobject::Article',1,'IRC Internet Relay Chat IRC join us irc You can find members of the community on the webgui chat channel on the Freenode IRC network If you\'re not familiar with IRC it\'s essentially like a chat room A few things you\'ll need to know You need an IRC client program There are many available that can be downloaded free of charge The IRC network we use is Freenode Our channel is webgui Channel operators have an  next to their name All channel operators in webgui are Plain Black employees Someone with a + next to their name is a recognized contributor in the WebGUI community People who have been recognized as one of the People Behind WebGUI are often given this designation If you\'re looking for a mentor recognized contributors are a good place to start  ','000001000002000004000003'),('ksSfkZdsr0uC62NwIk6hFQ','WebGUI Users Conference','An annual event, this is the one time a year when WebGUI users and Plain\n Black\'s staff come together to do all things WebGUI.  This is by far \nthe best way to get involved with the community as nothing can replace \nface to face interaction and mentoring.','join_us/wuc',1271356973,1271356973,'3','7','3','WebGUI::Asset::Wobject::Article',1,'WebGUI Users Conference WUC join us wuc An annual event this is the one time a year when WebGUI users and Plain Black\'s staff come together to do all things WebGUI This is by far the best way to get involved with the community as nothing can replace face to face interaction and mentoring The conference is usually held in the fall of each year and more information on attending can be found on the WebGUI Users Conference website as details become available  ','000001000002000004000004'),('nWxS5jnA3o3DgPEwBeR7yQ','The Forums','WebGUI \nForums are available for WebGUI related\n discussion and community support. Bounce around ideas, discuss \nimportant issues, and ask community members for help and advice. WebGUI \nForums are broken up into: \n\nEt Cetera: general WebGUI discussion \nWe','join_us/forums',1271357239,1271357239,'3','7','3','WebGUI::Asset::Wobject::Article',1,'The Forums forums join us forums WebGUI Forums are available for WebGUI related discussion and community support Bounce around ideas discuss important issues and ask community members for help and advice WebGUI Forums are broken up into Et Cetera general WebGUI discussion Web Design Templates and Themes discuss making your site look pretty Admin Forum get your questions answered about everything from security to configuration Install/Upgrade Help get answers to your installation and upgrade questions WebGUI Dev a place to discuss WebGUI and WRE core development as well as writing your own custom modules  ','000001000002000004000005'),('diZvW4bSgZWwyyGP3qXi1g','Commercial Documentation','Plain Black has created a line of commercial books which total over 1500 pages of detailed documentation about WebGUI. Both black and white and full color editions of these books are available. Visit the book store today to stock your WebGUI library. Othe','documentation/commercial-documentation',1215717972,1271349814,'3','7','3','WebGUI::Asset::Wobject::Article',1,'Commercial Documentation Commercial Documentation documentation commercial documentation Plain Black has created a line of commercial books which total over 1500 pages of detailed documentation about WebGUI Both black and white and full color editions of these books are available Visit the book store today to stock your WebGUI library Other than hands on training there is no better way to hone your WebGUI skills No matter what your need Plain Black has created a book that\'s right for you and is creating new books each year These books are available for WebGUI version 7.7 and earlier For later documentation see the free resources available on the WebGUI project website  ','000001000002000003000003'),('AssetReportFolder00001','Asset Report','','asset_report',1281501163,1281501163,'3','3','4','WebGUI::Asset::Wobject::Folder',1,'Asset Report Asset Report asset report','000001000001000071'),('sJtcUCfn0CVbKdb4QM61Yw','Asset Report Default Template','','asset-report/asset-report-default-template',1281501163,1284523755,'3','3','4','WebGUI::Asset::Template',0,'Asset Report Default Template Asset Report Default Template asset report asset report default template AssetReport','000001000001000071000001'),('qxd0WpRGqDPWP8WBicYvEA','dragdropsorting.js','','root/import/gallery-templates/dragdropsorting.js',1271820952,1284523760,'3','7','12','WebGUI::Asset::Snippet',0,'dragdropsorting.js dragdropsorting.js root import gallery templates dragdropsorting.js  Create our own namespace For the moment we leave this here since  there are no other JS modules for the gallery if typeof Gallery == undefined  Gallery =  Gallery.DDSorting =    Configure the drag\'n\'drop sorting app Gallery.DDSorting.parentId = photos  Element Id of the container element Gallery.DDSorting.draggableNodeTags = li  Type of tag used for draggable items Gallery.DDSorting.idPrefix = photoId  Prefix used in Ids of draggable items  Create some shortcuts var Dom = YAHOO.util.Dom var Event = YAHOO.util.Event var DDM = YAHOO.util.DragDropMgr   Drag\'n\'drop sorting app for the gallery  Gallery.DDSorting.init = function   Make list element containing photos a drop target new YAHOO.util.DDTarget(this.parentId  Get all items within list of photos var items = document.getElementById(this.parentId).getElementsByTagName(this.draggableNodeTags  Initialize DDList object for all list items for i=0 i < items.length i=i+1  new Gallery.DDList(this items[i].id gallery     Custom drag and drop implementation  Gallery.DDList = function(app id sGroup config  Gallery.DDList.superclass.constructor.call(this id sGroup config var el = this.getDragEl Dom.setStyle(el opacity 0.67  The proxy is slightly transparent  Assign reference to application object this.app = app  Init variables for direction and replacement tracking this.goingUp = false this.goingLeft = false this.lastY = 0 this.lastX = 0 this.before = false this.lastReplaced = null  YAHOO.extend(Gallery.DDList YAHOO.util.DDProxy  startDrag function(x y   Make the proxy look like the source element var dragEl = this.getDragEl var clickEl = this.getEl Dom.setStyle(clickEl visibility hidden  Copy source element to proxy and set class dragEl.className = clickEl.className dragEl.innerHTML = clickEl.innerHTML  endDrag function(e  var srcEl = this.getEl var proxy = this.getDragEl  Show the proxy element and animate it to the src element\'s location Dom.setStyle(proxy visibility  var a = new YAHOO.util.Motion proxy  points  to Dom.getXY(srcEl   0.2 YAHOO.util.Easing.easeOut  var proxyid = proxy.id var thisid = this.id  Hide the proxy and show the source element when finished with the animation a.onComplete.subscribe(function  Dom.setStyle(proxyid visibility hidden Dom.setStyle(thisid visibility   a.animate  Do nothing more if no element has been replaced if this.lastReplaced == null return  Get assed ids of the target to move and the last photo replaced var target = srcEl.id.replace(this.app.idPrefix  var dest = this.lastReplaced.id.replace(this.app.idPrefix   Prepare call to ajax service of the gallery asset We need  to set the action argument to moveFile provide the asset  id of the target photo in target and the asset id of the  photo replaced in before or after depending on order var args =  args.action = moveFile args.target = target if this.before  args.before = dest  else  args.after = dest   Callback function for asynchronous request This is  required for error handling var callback =  success function o   Parse answer from ajax service result = YAHOO.lang.JSON.parse(o.responseText  Check for errors if result.err   Display error message alert(\'Failed to move photo  + result.errMessage  Request a reload of the page so we are back in sync location.reload   failure function o   Display generic error message alert(\'AJAX service for moving photos is currently not available Failed to move photo  Request a reload of the page so we are back in sync location.reload    Convert args object to JSON string var postData = func=ajax;args= + encodeURI(YAHOO.lang.JSON.stringify(args  Make asynchronous call to gallery asset YAHOO.util.Connect.asyncRequest(\"POST this.app.url callback postData  onDrag function(e   Keep track of the direction of the drag for use during onDragOver var y = Event.getPageY(e var x = Event.getPageX(e  Check in vertical direction if y < this.lastY  this.goingUp = true  else if y > this.lastY  this.goingUp = false   Check in horizontal direction if x < this.lastX  this.goingLeft = true  else if x > this.lastX  this.goingLeft = false  this.lastY = y this.lastX = x  onDragOver function(e id  var srcEl = this.getEl var destEl = Dom.get(id  We are only concerned with list items we ignore the dragover  notifications for the list if destEl.nodeName.toLowerCase == this.app.draggableNodeTags  var orig_p = srcEl.parentNode var p = destEl.parentNode if this.goingUp || this.goingLeft   Insert above/before p.insertBefore(srcEl destEl  Keep track of where we moved this.lastReplaced = destEl this.before = true  else   Insert below/after p.insertBefore(srcEl destEl.nextSibling  Keep track of where we moved this.lastReplaced = destEl this.before = false  DDM.refreshCache     Start application after DOM is ready Event.onDOMReady(Gallery.DDSorting.init Gallery.DDSorting true','000001000001000066'),('l0guT3vTR3B8cL6vtP-g3A','Contribute','You don\'t have to be a developer to become a project contributor. Examples of how you can contribute include:\n \n\nTranslators - Visit i18n.webgui.org\n and either help translate a few items in an existing language, or \ncreate a new translation. \nGraphic Des','contribute',1271445611,1285733528,'3','7','3','WebGUI::Asset::Wobject::Article',1,'Contribute contribute contribute You don\'t have to be a developer to become a project contributor Examples of how you can contribute include Translators  Visit i18n.webgui.org and either help translate a few items in an existing language or create a new translation Graphic Designers  Create WebGUI style themes icons or fix UI bugs You can contribute your items to WebGUI\'s Addons and Plugins for others to download and use Usability Experts  Help make WebGUI more accessable and easier to use by submitting RFEs Even better submit an RFE that\'s ready to implement by including the code Doc Writers  Write documents in WebGUI\'s wiki help out on the boards improve WebGUI\'s built in documentation Testers  Validate WebGUI\'s features against its documentation search for errors and report bugs Test writers  If you have some Perl abilities you can help develop unit tests to make sure the WebGUI API is behaving as documented Developers  Write a new feature for WebGUI like a macro asset wobject auth module or workflow activity and contribute it to the Addons and Plugins area If you\'re interested in developing for WebGUI be sure to check out the Development Best Practices wiki article Bug Fixers  Cruise the bug list and submit patches to correct the problem Core Developers  Becoming a core developer is a privilege To earn it you have to demonstrate through bug fixes and/or contributions that you can make sound programming decisions without the need for someone to scrutinize everything you check in WebGUI is a very large and complex application so getting to this level can take some time Core developers are developers with commit privileges to the subversion repository Advocate  Spread the word about WebGUI tell people about how you use it and how it\'s helped you.Encourage people to try it out Marketing and Promotion  If you have a talent for marketing advertising or promotion you can be a super advocate Have a marketing idea Contact tavis AT plainblack DOT com Make a WebGUI banner or print ad and contribute it Maybe you have a design for a cool wallpaper or t-shirt anything to get the word out  ','000001000002000004000002'),('A3T7jpTBKLYws1h5mJ0t8A','makepageprintable.css','','makepageprintable.css',1286941427,1286941427,'3','7','12','WebGUI::Asset::Snippet',0,'makepageprintable.css makepageprintable.css makepageprintable.css  This is the stylesheet for the Make Page Printable Style template  reset html body div span applet object iframe h1 h2 h3 h4 h5 h6 p blockquote pre a abbr acronym address big cite code del dfn em font img ins kbd q s samp small strike strong sub sup tt var b u i center dl dt dd ol ul li fieldset form label legend table caption tbody tfoot thead tr th td  margin:0 padding:0 border:0 outline:0 font-size:100 vertical-align:baseline background:transparent text-decoration:none font-weight:normal font-style:normal  basic formatting body  font:12px/18px Georgia,\"Bitstream Charter\",\"Liberation Serif\",\"Times New Roman\",Times,serif color:#000  h1 h2 h3 h4 h5 h6  font:12px/18px Helvetica,Arial,\"Liberation Sans\",sans-serif  code  font:11px/18px Lucida Console\",\"Courier New\",\"Liberation Mono\",monospace  h1 h2  font-size:18px line-height:24px margin:24px 0 12px  h3  font-size:14px margin:0 0 12px  h4  margin:0 0 6px font-weight:bold  h5  margin:0 0 6px  h6  font-style:italic margin:0 0 6px  p ul ol dl blockquote table form fieldset  margin:0 0 18px  a:link a:visited  text-decoration:underline color:#000  a:hover a:active  text-decoration:none color:#000  ol ul blockquote  padding:0 0 0 27px  ol ol ol ul ul ul ul ol  margin:0  dd  margin:0 0 3px  blockquote  font-style:italic font-size:15px quotes:none  blockquote p  font-style:italic margin:0 0 9px  q  quotes:none font-style:italic  blockquote:before blockquote:after q:before q:after  content content:none  b strong dt  font-weight:bold  cite dfn i em ins  font-style:italic  abbr acronym  text-transform:lowercase font-variant:small-caps  del  text-decoration:line-through  sub  vertical-align:sub font-size:8px  sup  vertical-align:super font-size:8px  hr  border-color:#aaa border-style:dotted border-width:1px 0 0 color:#fff background:#fff margin:18px 0 padding:0 width:100  legend  font-weight:bold  label  display:block  table  border-collapse:collapse border-spacing:0  caption  font-style:italic margin:0 0 6px  tr  border-bottom:1px dotted ccc  thead tr  border-top:1px solid ccc border-bottom:1px solid ccc  th td  padding:5px 9px 4px  th  font-variant:small-caps  very basic positioning  design header  border-top:1px dotted aaa border-bottom:1px dotted aaa padding:17px 6px color:#666  header h1  font-weight:bold margin:0 text-transform:uppercase  header a  text-decoration:none font-style:italic color:#666 font-size:11px  content  padding:0 6px margin:18px 0 36px  content a  font-weight:bold  content img  margin:0 0 18px  footer  border-top:1px dotted aaa border-bottom:1px dotted aaa padding:17px 6px color:#666 ','000001000001000043000007'),('sK_0zVw4kwdJ1sqREIsSzA','WebGUI Auth Password Recovery Email Template','','root/import/auth/webgui/recoveryemail',1288142107,1288142107,'3','7','4','WebGUI::Asset::Template',0,'WebGUI Auth Password Recovery Email Template Password Recovery Email root import auth webgui recoveryemail Auth/WebGUI/RecoveryEmail','000001000001000005000011'),('_cD6DLM_Fs5IlrLeWUjrjg','Workflow Activity Templates','Folder for holding Workflow Activity templates. ','root/import/workflow-activity-templates',1288142107,1288142107,'3','7','12','WebGUI::Asset::Wobject::Folder',1,'Workflow Activity Templates Workflow Activity Templates root import workflow activity templates Folder for holding Workflow Activity templates','000001000001000072'),('lYhMheuuLROK_iNjaQuPKg','Notify About Version Tag','','root/import/workflow-activity-templates/notify-about-version-tag',1288142107,1288142107,'3','7','12','WebGUI::Asset::Template',0,'Notify About Version Tag Notify About Version Tag root import workflow activity templates notify about version tag NotifyAboutVersionTag','000001000001000072000001');
ALTER TABLE `assetIndex` ENABLE KEYS;
ALTER TABLE `assetVersionTag` DISABLE KEYS;
INSERT INTO `assetVersionTag` VALUES ('pbversion0000000000001','Base 7.9.18 Install',1,1289360566,'3',1289360566,'3',0,'','3','',NULL,NULL,NULL,NULL,0);
ALTER TABLE `assetVersionTag` ENABLE KEYS;
ALTER TABLE `authentication` DISABLE KEYS;
INSERT INTO `authentication` VALUES ('1','LDAP','ldapUrl',NULL),('3','LDAP','ldapUrl',''),('1','LDAP','connectDN',NULL),('3','LDAP','connectDN',''),('1','WebGUI','identifier','No Login'),('3','WebGUI','identifier','RvlMjeFPs2aAhQdo/xt/Kg'),('1','WebGUI','passwordLastUpdated','1078704037'),('1','WebGUI','passwordTimeout','3122064000'),('1','WebGUI','changeUsername','1'),('1','WebGUI','changePassword','1'),('3','WebGUI','passwordLastUpdated','1078704037'),('3','WebGUI','passwordTimeout','3122064000'),('3','WebGUI','changeUsername','1'),('3','WebGUI','changePassword','1');
ALTER TABLE `authentication` ENABLE KEYS;
ALTER TABLE `databaseLink` DISABLE KEYS;
INSERT INTO `databaseLink` VALUES ('0',NULL,NULL,NULL,NULL,NULL,1,'');
ALTER TABLE `databaseLink` ENABLE KEYS;
ALTER TABLE `groupGroupings` DISABLE KEYS;
INSERT INTO `groupGroupings` VALUES ('11','12'),('3','11'),('3','12'),('3','13'),('3','2'),('3','4'),('3','6'),('3','7'),('3','8'),('3','pbgroup000000000000015'),('3','pbgroup000000000000016'),('3','pbgroup000000000000017'),('4','12'),('6','12'),('8','12');
ALTER TABLE `groupGroupings` ENABLE KEYS;
ALTER TABLE `groupings` DISABLE KEYS;
INSERT INTO `groupings` VALUES ('1','1',2114402400,0),('3','3',2114402400,0),('7','1',1599019965,0),('7','3',2114402400,0),('2','3',2114402400,0);
ALTER TABLE `groupings` ENABLE KEYS;
ALTER TABLE `groups` DISABLE KEYS;
INSERT INTO `groups` VALUES ('1','Visitors','This is the public group that has no privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('2','Registered Users','All registered users belong to this group automatically. There are no associated privileges other than that the user has an account and is logged in.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('3','Admins','Anyone who belongs to this group has privileges to do anything and everything.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('4','Content Managers','Users that have privileges to edit content on this site. The user still needs to be added to a group that has editing privileges on specific pages.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('6','Package Managers','Users that have privileges to add, edit, and delete packages of wobjects and pages to deploy.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('7','Everyone','A group that automatically includes all users including Visitors.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,1,NULL,NULL,NULL,NULL,NULL,0),('8','Template Managers','Users that have privileges to edit templates for this site.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('13','Export Managers','Users in this group can export pages to disk.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('11','Secondary Admins','Users that have limited administrative privileges.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('12','Turn Admin On','These users can enable admin mode.',314496000,1000000000,NULL,997938000,997938000,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000015','Workflow Managers','People who can create, edit, and delete workflows.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000016','Version Tag Managers','People who can create, edit, and delete special version tags.',314496000,1000000000,NULL,1147642408,1147642408,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('pbgroup000000000000017','Ad Manager','These users will be able to manage advertisements.',314496000,1000000000,NULL,1147642437,1147642437,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,1,1,NULL,NULL,NULL,NULL,NULL,0),('Fwa7nt7HAQkelbjCRrtqKQ','Admin Friends','Friends of user 3',1892160000,1000000000,NULL,1251850059,1251850059,14,-14,NULL,0,NULL,0,0,'0',3600,NULL,0,0,NULL,NULL,NULL,NULL,NULL,0);
ALTER TABLE `groups` ENABLE KEYS;
ALTER TABLE `imageColor` DISABLE KEYS;
INSERT INTO `imageColor` VALUES ('UVL-iDSq7VTks3RCH2FEWg','Green','#31ca31','99','#31ca31','00'),('3Tf0W_tkAjR902FJcGZxCg','Blue','#007dff','99','#007dff','00'),('fuFripVJ4es4bUBPOq3ENQ','Yellow','#ffda08','99','#ffda08','00'),('n3yfk8JGilmChSer2xuZ0w','Orange','#FF8000','99','#FF8000','00'),('W683fO6r8uHgZ-Z-VodY7w','Red','#FF2000','99','#FF2000','00'),('pSnxDIInB9r0n06q6kKV3w','Purple','#FF00B0','99','#FF00B0','00');
ALTER TABLE `imageColor` ENABLE KEYS;
ALTER TABLE `imageFont` DISABLE KEYS;
INSERT INTO `imageFont` VALUES ('defaultFont','WebGUI default font',NULL,'default.ttf');
ALTER TABLE `imageFont` ENABLE KEYS;
ALTER TABLE `imagePalette` DISABLE KEYS;
INSERT INTO `imagePalette` VALUES ('defaultPalette','Default palette');
ALTER TABLE `imagePalette` ENABLE KEYS;
ALTER TABLE `imagePaletteColors` DISABLE KEYS;
INSERT INTO `imagePaletteColors` VALUES ('defaultPalette','UVL-iDSq7VTks3RCH2FEWg',1),('defaultPalette','3Tf0W_tkAjR902FJcGZxCg',2),('defaultPalette','fuFripVJ4es4bUBPOq3ENQ',3),('defaultPalette','n3yfk8JGilmChSer2xuZ0w',4),('defaultPalette','W683fO6r8uHgZ-Z-VodY7w',5),('defaultPalette','pSnxDIInB9r0n06q6kKV3w',6);
ALTER TABLE `imagePaletteColors` ENABLE KEYS;
ALTER TABLE `incrementer` DISABLE KEYS;
INSERT INTO `incrementer` VALUES ('submissionId',1);
ALTER TABLE `incrementer` ENABLE KEYS;
ALTER TABLE `karmaLog` DISABLE KEYS;
INSERT INTO `karmaLog` VALUES ('9P1zGicVGAb_MzaPqIR2MQ',0,'testCode','testable karma, dude',1284523965),('5JNpgbJ5rL5VSyuCBwzr-A',5,'testCode','testable karma, dude',1284523965),('cSaeKBbQpCrmaHNpsuMYcw',10,'testCode','testable karma, dude',1284523965),('_LfAsfNGRxX-QflP0QkWBg',15,'testCode','testable karma, dude',1284523965);
ALTER TABLE `karmaLog` ENABLE KEYS;
ALTER TABLE `ldapLink` DISABLE KEYS;
INSERT INTO `ldapLink` VALUES ('1uBbhUm686mkFZ1ghv7Lag','Default LDAP Connection','ldap://ldap.mycompany.com:389/o=MyCompany','','','cn','shortname','LDAP Shortname','LDAP Password','0','Welcome to our site.','PBtmpl0000000000000004','PBtmpl0000000000000005','PBtmpl0000000000000006',NULL,'_P4PMiraGsLTfOjK4fYQPQ'),('00000000000000testlink','Test LDAP Link','ldaps://smoke.plainblack.com/o=shawshank','cn=Warden,o=shawshank','gooey','dn','uid',NULL,NULL,NULL,NULL,'','','',NULL,'');
ALTER TABLE `ldapLink` ENABLE KEYS;
ALTER TABLE `passiveAnalyticsStatus` DISABLE KEYS;
INSERT INTO `passiveAnalyticsStatus` VALUES (NULL,NULL,0,'3');
ALTER TABLE `passiveAnalyticsStatus` ENABLE KEYS;
ALTER TABLE `paymentGateway` DISABLE KEYS;
INSERT INTO `paymentGateway` VALUES ('gzUxkEZJxREF9JpylOg2zw','WebGUI::Shop::PayDriver::Cash','{\"summaryTemplateId\":\"30h5rHxzE_Q0CyI3Gg7EJw\",\"groupToUse\":7,\"label\":\"Cash\",\"enabled\":1}'),('BaSs55o1bnOlAj4F0hHYag','WebGUI::Shop::PayDriver::ITransact','{\"credentialsTemplateId\":\"itransact_credentials1\",\"groupToUse\":7,\"label\":\"ITransact\",\"enabled\":1}');
ALTER TABLE `paymentGateway` ENABLE KEYS;
ALTER TABLE `replacements` DISABLE KEYS;
INSERT INTO `replacements` VALUES ('1','[quote]','<blockquote><i>'),('2','[/quote]','</i></blockquote>'),('3','[image]','<img src=\"'),('4','[/image]','\" border=\"0\" / >'),('5','shit','crap'),('6','fuck','farg'),('7','asshole','icehole'),('8','nigger','guy');
ALTER TABLE `replacements` ENABLE KEYS;
ALTER TABLE `search` DISABLE KEYS;
INSERT INTO `search` VALUES ('UUwEL6hLEPdrnkZnKRzFYQ',1273032718,'WebGUI::Asset\nWebGUI::Asset::Event\nWebGUI::Asset::File\nWebGUI::Asset::File::Image\nWebGUI::Asset::Post\nWebGUI::Asset::Post::Thread\nWebGUI::Asset::RichEdit\nWebGUI::Asset::RSSFromParent\nWebGUI::Asset::Snippet\nWebGUI::Asset::Template\nWebGUI::Asset::Wobject::Article\nWebGUI::Asset::Wobject::Calendar\nWebGUI::Asset::Wobject::Collaboration\nWebGUI::Asset::Wobject::DataForm\nWebGUI::Asset::Wobject::Folder\nWebGUI::Asset::Wobject::MessageBoard\nWebGUI::Asset::Wobject::Navigation\nWebGUI::Asset::Wobject::SyndicatedContent\nWebGUI::Asset::Wobject::Thingy','68sKwDgf9cGH58-NZcU4lg','OfKbvK7CrfMnfc8WDoF4Rg',1,10),('8E2UOnj_XPEghTj7nfVM0g',1273032720,NULL,'68sKwDgf9cGH58-NZcU4lg','PBtmpl0000000000000200',0,25);
ALTER TABLE `search` ENABLE KEYS;
ALTER TABLE `settings` DISABLE KEYS;
INSERT INTO `settings` VALUES ('maxAttachmentSize','100000'),('sessionTimeout','7200'),('smtpServer','localhost'),('companyEmail','info@mycompany.com'),('companyName','My Company'),('companyURL','http://www.mycompany.com'),('authMethod','WebGUI'),('anonymousRegistration','0'),('notFoundPage','68sKwDgf9cGH58-NZcU4lg'),('webguiRecoverPasswordEmail','Someone (probably you) requested your account information be sent. Your password has been reset. The following represents your new account information:'),('profileName','1'),('profileExtraContact','1'),('profileMisc','1'),('profileHome','0'),('profileWork','0'),('preventProxyCache','0'),('thumbnailSize','50'),('textBoxSize','30'),('defaultPage','68sKwDgf9cGH58-NZcU4lg'),('defaultVersionTagWorkflow','pbworkflow000000000003'),('useKarma','0'),('karmaPerLogin','1'),('runOnRegistration',''),('maxImageSize','100000'),('showDebug','0'),('richEditor','PBrichedit000000000001'),('selfDeactivation','1'),('snippetsPreviewLength','30'),('mailFooter','^c;\n^e;\n^u;\n'),('webguiSendWelcomeMessage','0'),('webguiWelcomeMessage','<p>Welcome to our site.</p>'),('encryptLogin','0'),('hostToUse','HTTP_HOST'),('webguiExpirePasswordOnCreation','0'),('webguiPasswordLength','0'),('webguiPasswordRecovery',''),('webguiPasswordTimeout','3122064000'),('webguiChangePassword','1'),('webguiChangeUsername','1'),('metaDataEnabled','0'),('passiveProfilingEnabled','0'),('urlExtension',''),('AdminConsoleTemplate','PBtmpl0000000000000001'),('userFunctionStyleId','Qk24uXao2yowR6zxbVJ0xA'),('webguiValidateEmail','0'),('webguiUseCaptcha','1'),('webguiAccountTemplate','PBtmpl0000000000000010'),('webguiCreateAccountTemplate','PBtmpl0000000000000011'),('webguiExpiredPasswordTemplate','PBtmpl0000000000000012'),('webguiLoginTemplate','PBtmpl0000000000000013'),('webguiPasswordRecoveryTemplate','PBtmpl0000000000000014'),('ldapConnection','1uBbhUm686mkFZ1ghv7Lag'),('debugIp',''),('showPerformanceIndicators','0'),('mailReturnPath',NULL),('webguiNonWordCharacters','0'),('webguiRequiredMixedCase','0'),('webguiRequiredDigits','0'),('automaticLDAPRegistration','0'),('trashWorkflow',''),('purgeWorkflow',''),('changeUrlWorkflow',''),('webguiPasswordRecoveryRequireUsername','1'),('groupIdCashier','3'),('skipCommitComments','1'),('groupIdAdminCache','3'),('groupIdAdminSpectre','3'),('groupIdAdminAdSpace','3'),('groupIdAdminWorkflow','pbgroup000000000000015'),('groupIdAdminGroupAdmin','11'),('groupIdAdminProfileSettings','3'),('groupIdAdminDatabaseLink','3'),('groupIdAdminActiveSessions','3'),('groupIdAdminLDAPLink','3'),('groupIdAdminStatistics','3'),('groupIdAdminHelp','7'),('groupIdAdminCommerce','3'),('groupIdAdminWorkflowRun','3'),('groupIdAdminUserAdd','11'),('groupIdAdminUser','3'),('groupIdAdminVersionTag','12'),('groupIdAdminGraphics','3'),('groupIdAdminGroup','3'),('groupIdAdminCron','3'),('groupIdAdminLoginHistory','3'),('groupIdAdminReplacements','3'),('runOnAdminCreateUser',''),('runOnAdminUpdateUser',''),('shopCartTemplateId','aIpCmr9Hi__vgdZnDTz1jw'),('shopAddressBookTemplateId','3womoo7Teyy2YKFa25-MZg'),('shopAddressTemplateId','XNd7a_g_cTvJVYrVHcx2Mw'),('shopMyPurchasesTemplateId','2gtFt7c0qAFNU3BG_uvNvg'),('shopMyPurchasesDetailTemplateId','g8W53Pd71uHB9pxaXhWf_A'),('showMessageOnLoginTimes','0'),('showMessageOnLogin','0'),('showMessageOnLoginBody',''),('versionTagMode','autoCommit'),('profileStyleTemplateId','stevestyle000000000003'),('profileLayoutTemplateId','FJbUTvZ2nUTn65LpW6gjsA'),('profileEditTemplateId','75CmQgpcCSkdsL-oawdn3Q'),('inboxStyleTemplateId','stevestyle000000000003'),('inboxViewTemplateId','c8xrwVuu5QE0XtF9DiVzLw'),('inboxViewMessageTemplateId','0n4HtbXaWa_XJHkFjetnLQ'),('inboxSendMessageTemplateId','6uQEULvXFgCYlRWnYzZsuA'),('inboxErrorTemplateId','ErEzulFiEKDkaCDVmxUavw'),('inboxMessageConfirmationTemplateId','DUoxlTBXhVS-Zl3CFDpt9g'),('inboxManageInvitationsTemplateId','1Q4Je3hKCJzeo0ZBB5YB8g'),('inboxViewInvitationTemplateId','VBkY05f-E3WJS50WpdKd1Q'),('inboxInvitationConfirmTemplateId','5A8Hd9zXvByTDy4x-H28qw'),('inboxInviteUserEnabled','0'),('inboxInviteUserRestrictSubject','0'),('inboxInviteUserSubject','^International(invite subject,Account_Inbox,^u;);'),('inboxInviteUserRestrictMessage','0'),('inboxInviteUserMessage','^International(invite message,Account_Inbox);'),('inboxInviteUserMessageTemplateId','XgcsoDrbC0duVla7N7JAdw'),('inboxInviteUserTemplateId','cR0UFm7I1qUI2Wbpj--08Q'),('inboxInviteUserConfirmTemplateId','SVIhz68689hwUGgcDM-gWw'),('friendsStyleTemplateId','stevestyle000000000003'),('friendsViewTemplateId','1Yn_zE_dSiNuaBGNLPbxtw'),('friendsEditTemplateId','AZFU33p0jpPJ-E6qLSWZng'),('friendsSendRequestTemplateId','AGJBGviWGAwjnwziiPjvDg'),('friendsErrorTemplateId','7Ijdd8SW32lVgg2H8R-Aqw'),('friendsConfirmTemplateId','K8F0j_cq_jgo8dvWY_26Ag'),('friendsRemoveConfirmTemplateId','G5V6neXIDiFXN05oL-U3AQ'),('userAccountStyleTemplateId','stevestyle000000000003'),('userAccountLayoutTemplateId','9ThW278DWLV0-Svf68ljFQ'),('shopStyleTemplateId','stevestyle000000000003'),('shopLayoutTemplateId','aUDsJ-vB9RgP-AYvPOy8FQ'),('contribStyleTemplateId','stevestyle000000000003'),('contribLayoutTemplateId','b4n3VyUIsAHyIvT-W-jziA'),('contribViewTemplateId','1IzRpX0tgW7iuCfaU2Kk0A'),('profileViewTemplateId','2CS-BErrjMmESOtGT90qOg'),('profileErrorTemplateId','MBmWlA_YEA2I6D29OMGtRg'),('inboxLayoutTemplateId','gfZOwaTWYjbSoVaQtHBBEw'),('friendsLayoutTemplateId','zrNpGbT3odfIkg6nFSUy8Q'),('inboxRichEditId','PBrichedit000000000001'),('useRecaptcha','0'),('recaptchaPublicKey',''),('recaptchaPrivateKey',''),('webguiAccountActivationTemplate','PBtmpl0000000000000016'),('groupIdAdminHistory','12'),('shopCartCheckoutMinimum','0.00'),('passiveAnalyticsInterval','300'),('passiveAnalyticsDeleteDelta','0'),('passiveAnalyticsEnabled','0'),('shopMySalesTemplateId','-zxyB-O50W8YnL39Ouoc4Q'),('webguiWelcomeMessageTemplate','PBtmpl0000000000000015'),('activeTaxPlugin','WebGUI::Shop::TaxDriver::Generic'),('globalHeadTags',''),('useMobileStyle','0'),('inboxCopySender','0'),('sendInboxNotificationsOnly','0'),('inboxNotificationTemplateId','b1316COmd9xRv4fCI3LLGA'),('smsGateway',''),('groupIdAdminFriends','3'),('fmViewTemplateId','64tqS80D53Z0JoAs2cX2VQ'),('fmEditTemplateId','lG2exkH9FeYvn4pA63idNg'),('groupsToManageFriends','2'),('overrideAbleToBeFriend','0'),('webguiUseEmailAsUsername','0'),('redirectAfterLoginUrl',''),('groupIdAdminFilePump','8'),('fmStyleTemplateId','stevestyle000000000003'),('fmLayoutTemplateId','N716tpSna0iIQTKxS4gTWA'),('smsGatewaySubject',''),('inboxNotificationsSubject',''),('inboxSmsNotificationTemplateId','i9-G00ALhJOr0gMh-vHbKA'),('shopSaleNotificationGroupId','3'),('shopReceiptEmailTemplateId','bPz1yk6Y9uwMDMBcmMsSCg'),('selectGatewayTemplateId','2GxjjkRuRkdUg_PccRPjpA'),('groupIdAdminClipboard','3'),('groupIdAdminTrash','3'),('maxCacheTimeout','86400'),('webguiDeactivateAccountTemplate','zaHUYsE_PgKk8hnVd8ffEQ'),('sendRejectNotice','1'),('twitterEnabled','0'),('twitterTemplateIdChooseUsername','mfHGkp6t9gdclmzN33OEnw'),('showMessageOnLoginReset','0'),('profileDisplayLayoutTemplateId',''),('specialState','init');
ALTER TABLE `settings` ENABLE KEYS;
ALTER TABLE `shipper` DISABLE KEYS;
INSERT INTO `shipper` VALUES ('defaultfreeshipping000','WebGUI::Shop::ShipDriver::FlatRate','{\"groupToUse\":7,\"label\":\"Free Shipping\",\"enabled\":1}');
ALTER TABLE `shipper` ENABLE KEYS;
ALTER TABLE `snippet` DISABLE KEYS;
INSERT INTO `snippet` VALUES ('SynConXSLT000000000001','<?xml version=\"1.0\"?>\n<!--\n  Based on XSLT stylesheets originally designed by Rich Manalang (http://manalang.com)\n  This XSLT sheet will convert any valid RSS 0.9 feed into basic HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:foo=\"http://my.netscape.com/rdf/simple/0.9/\">\n  <xsl:output method=\"html\"/>\n  <xsl:template match=\"/\">\n    <style>\n      <xsl:comment>\n        .syndication-content-area {\n        }\n        .syndication-title {\n        font-size: 1.1em;\n        font-weight: bold;\n        }\n        .syndication-description {\n        font-size: .9em;\n        margin: 0 0 10px 0;\n        }\n        .syndication-list {\n        font-size: .8em;\n        margin:0 0 0 20px;\n        }\n        .syndication-list-item {\n        margin: 0 0 5px 0;\n        }\n        .syndication-list-item a,\n        .syndication-list-item a:link {\n        color: blue;\n        }\n        .syndication-list-item a:active,\n        .syndication-list-item a:hover {\n        color: red;\n        }\n        li.syndication-list-item{\n        padding-bottom: .2em;\n        background-color: #e4e4e4;\n        }\n        .syndication-list-item a:visited {\n        color: black;\n        text-decoration: none;\n        }\n        .syndication-list-item-date {\n        font-size: .8em;\n        }\n        .syndication-list-item-description {\n        font-size: .9em;\n        }\n      </xsl:comment>\n    </style>\n    <xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:channel\">\nYou\'re viewing an <a href=\"http://www.purplepages.ie/RSS/netscape/rss0.90.html\">RSS version 0.9 feed</a>. Please use an RSS feed reader to view this content as intended.\n    <div class=\"syndication-content-area\">\n      <div class=\"syndication-title\">\n        <xsl:value-of select=\"foo:title\"/>\n      </div>\n      <div class=\"syndication-description\">\n        <xsl:value-of select=\"foo:description\"/>\n      </div>\n      <ul class=\"syndication-list\">\n        <xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n      </ul>\n    </div>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:item\">\n    <li class=\"syndication-list-item\">\n      <a href=\"{foo:link}\" title=\"{foo:description}\">\n        <xsl:value-of select=\"foo:title\"/>\n      </a>\n    </li>\n  </xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600,'<?xml version=\"1.0\"?>\n<!--\n  Based on XSLT stylesheets originally designed by Rich Manalang (http://manalang.com)\n  This XSLT sheet will convert any valid RSS 0.9 feed into basic HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n  xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n  xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n  xmlns:foo=\"http://my.netscape.com/rdf/simple/0.9/\">\n  <xsl:output method=\"html\"/>\n  <xsl:template match=\"/\">\n    <style>\n      <xsl:comment>\n        .syndication-content-area {\n        }\n        .syndication-title {\n        font-size: 1.1em;\n        font-weight: bold;\n        }\n        .syndication-description {\n        font-size: .9em;\n        margin: 0 0 10px 0;\n        }\n        .syndication-list {\n        font-size: .8em;\n        margin:0 0 0 20px;\n        }\n        .syndication-list-item {\n        margin: 0 0 5px 0;\n        }\n        .syndication-list-item a,\n        .syndication-list-item a:link {\n        color: blue;\n        }\n        .syndication-list-item a:active,\n        .syndication-list-item a:hover {\n        color: red;\n        }\n        li.syndication-list-item{\n        padding-bottom: .2em;\n        background-color: #e4e4e4;\n        }\n        .syndication-list-item a:visited {\n        color: black;\n        text-decoration: none;\n        }\n        .syndication-list-item-date {\n        font-size: .8em;\n        }\n        .syndication-list-item-description {\n        font-size: .9em;\n        }\n      </xsl:comment>\n    </style>\n    <xsl:apply-templates select=\"/rdf:RDF/foo:channel\"/>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:channel\">\nYou\'re viewing an <a href=\"http://www.purplepages.ie/RSS/netscape/rss0.90.html\">RSS version 0.9 feed</a>. Please use an RSS feed reader to view this content as intended.\n    <div class=\"syndication-content-area\">\n      <div class=\"syndication-title\">\n        <xsl:value-of select=\"foo:title\"/>\n      </div>\n      <div class=\"syndication-description\">\n        <xsl:value-of select=\"foo:description\"/>\n      </div>\n      <ul class=\"syndication-list\">\n        <xsl:apply-templates select=\"/rdf:RDF/foo:item\"/>\n      </ul>\n    </div>\n  </xsl:template>\n  <xsl:template match=\"/rdf:RDF/foo:item\">\n    <li class=\"syndication-list-item\">\n      <a href=\"{foo:link}\" title=\"{foo:description}\">\n        <xsl:value-of select=\"foo:title\"/>\n      </a>\n    </li>\n  </xsl:template>\n</xsl:stylesheet>',0),('SynConXSLT000000000002','<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 0.91, 0.92, 0.93 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 0.91, 0.92, or 0.93 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;\n				margin:0 0 0 20px;\n			}\n                        li.syndication-list-item{\n                        padding-bottom: .2em;\n                        background-color: #e4e4e4;\n                        }\n			.syndication-list-item {\n				margin: 0 0 5px 0;\n			}\n			.syndication-list-item a,\n			.syndication-list-item a:link {\n				color: blue;\n			}\n			.syndication-list-item a:active,\n			.syndication-list-item a:hover {\n				color: red;\n			}\n			.syndication-list-item a:visited {\n				color: black;\n				text-decoration: none;\n			}\n			.syndication-list-item-date {\n				font-size: .8em;\n			}\n			.syndication-list-item-description {\n				font-size: .9em;\n			}\n			</xsl:comment>\n		</style>\n		<xsl:apply-templates select=\"/rss/channel\"/>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel\">\n		<div class=\"syndication-content-area\">\nYou\'re viewing an <a href=\"http://backend.userland.com/rss091\">RSS version 0.91 feed</a>. Please use an RSS feed reader to view this content as intended.\n			<div class=\"syndication-title\">\n				<xsl:value-of select=\"title\"/>\n			</div>\n			<div class=\"syndication-description\">\n				<xsl:value-of select=\"description\"/>\n			</div>\n			<ul class=\"syndication-list\">\n				<xsl:apply-templates select=\"item\"/>\n			</ul>\n\n		</div>\n	</xsl:template>\n	<xsl:template match=\"/rss/channel/item\">\n		<li class=\"syndication-list-item\">\n			<a href=\"{link}\" title=\"{description}\">\n				<xsl:value-of select=\"title\"/>\n			</a>\n			<div class=\"syndication-list-item-description\">\n				<xsl:value-of select=\"description\"/>\n\n			</div>\n		</li>\n	</xsl:template>\n</xsl:stylesheet>',0,'application/xml',1124395707,3600,'<?xml version=\"1.0\"?>\n<!--\n  Title: RSS 0.91, 0.92, 0.93 XSL Template\n  Author: Rich Manalang (http://manalang.com)\n  Description: This sample XSLT will convert any valid RSS 0.91, 0.92, or 0.93 feed to HTML.\n-->\n<xsl:stylesheet version=\"1.0\"\n xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\"\n xmlns:wfw=\"http://wellformedweb.org/CommentAPI/\">\n 	<xsl:output method=\"html\"/>\n	<xsl:template match=\"/\">\n		<style>\n			<xsl:comment>\n			.syndication-content-area {\n			}\n			.syndication-title {\n				font-size: 1.1em;\n				font-weight: bold;\n			}\n			.syndication-description {\n				font-size: .9em;\n				margin: 0 0 10px 0;\n			}\n			.syndication-list {\n				font-size: .8em;