/**************************************************************************
* Simple XML-based UI builder for Qt 4
* Copyright (C) 2007 Michał Męciński
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef XMLUI_NODE_H
#define XMLUI_NODE_H

#include <QString>
#include <QList>

namespace XmlUi
{

enum NodeType
{
    Unknown,
    Root,
    MenuBar,
    Menu,
    ToolBar,
    Group,
    Action,
    Separator,
    Merge
};

class Node
{
public:
    Node() : m_type( Unknown )
    {
    }

    Node( NodeType type ) : m_type( type )
    {
    }

public:
    void setType( NodeType type ) { m_type = type; }

    NodeType type() const { return m_type; }

    void setId( const QString& id ) { m_id = id; }

    const QString& id() const { return m_id; }

    void setChildren( const QList<Node>& children ) { m_children = children; }

    const QList<Node>& children() const { return m_children; }

    void addChild( const Node& node ) { m_children.append( node ); }

private:
    NodeType m_type;
    QString m_id;

    QList<Node> m_children;
};

}

#endif
