/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef PREVIEWDIALOG_H
#define PREVIEWDIALOG_H

#include <QDialog>

class QPrinter;
class QTextDocument;
class QToolButton;
class QLabel;
class QComboBox;

class PreviewPrinter;
class PreviewWidget;
class PreviewLineEdit;

/**
* Dialog for showing preview of the report.
*/
class PreviewDialog : public QDialog
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param printer The printer used by the dialog.
    * @param document The document containing the report.
    * @param parent The parent widget.
    */
    PreviewDialog( PreviewPrinter* printer, QTextDocument* document, QWidget* parent );

    /**
    * Destructor.
    */
    ~PreviewDialog();

private slots:
    void paintRequested( QPrinter* printer );

    void previewChanged();

    void pageEdited();
    void zoomEdited();

    void pageFirst();
    void pagePrevious();
    void pageNext();
    void pageLast();

    void zoomIn();
    void zoomOut();

    void fitWidth();
    void fitPage();

    void pageSetup();
    void print();

private:
    PreviewPrinter* m_printer;

    QTextDocument* m_document;

    PreviewWidget* m_preview;

    QToolButton* m_firstButton;
    QToolButton* m_previousButton;
    QToolButton* m_nextButton;
    QToolButton* m_lastButton;
    QToolButton* m_singleButton;
    QToolButton* m_facingButton;
    QToolButton* m_allButton;
    QToolButton* m_zoomInButton;
    QToolButton* m_zoomOutButton;
    QToolButton* m_fitWidthButton;
    QToolButton* m_fitPageButton;
    QToolButton* m_portraitButton;
    QToolButton* m_landscapeButton;

    PreviewLineEdit* m_pageEdit;
    QLabel* m_pageLabel;
    QComboBox* m_zoomCombo;
    PreviewLineEdit* m_zoomEdit;
};

#endif
