/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef ISSUEVIEW_H
#define ISSUEVIEW_H

#include <QTextDocument>

#include "view.h"
#include "rdb/tableitemmodel.h"
#include "configdata.h"

class QTabWidget;
class QTextBrowser;
class QTreeView;
class QModelIndex;
class QUrl;

class PropertyPanel;
class PopEditPanel;
class PopEditBox;
class RowIndex;
class FindBar;

/**
* View for displaying details of an issue.
*/
class IssueView : public View
{
    Q_OBJECT
public:
    /**
    * Constructor.
    *
    * @param parent The parent object.
    *
    * @param parentWidget The parent widget of the view's main widget.
    */
    IssueView( QObject* parent, QWidget* parentWidget );

    /**
    * Destructor.
    */
    ~IssueView();

public:
    /**
    * Navigate to the given comment, attachment or change.
    */
    void gotoItem( int itemId );

public: // overrides
    void initialUpdate();

protected: // overrides
    void enableView();
    void disableView();

    void updateEvent( UpdateEvent* e );

    void viewEvent( ViewEvent* e );

private slots:
    void tabChanged( int index );
    void updateCaption();
    void updateActions();

    void updateIssue();
    void addComment();
    void addAttachment();
    void editRename();
    void setValue( int attributeId );

    void copy();
    void selectAll();

    void find();
    void findNext();
    void findPrevious();

    void configureAttributes();
    void applyAttributes();

    void openAttachment();
    void saveAttachment();
    void openLink();
    void copyLink();

    void printReport();
    void exportHtml();
    void exportPdf();

    void linkContextMenu( const QString& link, const QPoint& pos );
    void historyContextMenu( const QPoint& pos );
    void attachmentsContextMenu( const QPoint& pos );

    void activated( const QModelIndex& index );

    void linkClicked( const QString& link );
    void anchorClicked( const QUrl& url );

    void findText( const QString& text );

private:
    Access checkDataAccess();

    void initialUpdateIssue();

    void populateProperties();
    void updateProperties();

    void populateAttributes();
    void updateAttributes();

    void populateComments();

    void findItem( int itemId );

    void findText( const QString& text, int from, QTextDocument::FindFlags flags );

    void handleAttachment( int attachmentId );
    void handleAttachment( int attachmentId, AttachmentAction action );

    QModelIndex selectedIndex();

private:
    QTabWidget* m_tabWidget;
    PopEditBox* m_nameEdit;
    PropertyPanel* m_propertyPanel;
    PopEditPanel* m_attributePanel;

    QTextBrowser* m_browser;

    QTreeView* m_list;
    RDB::TableItemModel* m_model;

    FindBar* m_findBar;

    int m_gotoItemId;

    int m_folderId;
    int m_typeId;

    QString m_actionLink;

    int m_currentPage;

    int m_selectedAttachmentId;

    bool m_isFindEnabled;
};

#endif
