/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef METADATADIALOGFACTORY_H
#define METADATADIALOGFACTORY_H

#include "definitioninfo.h"

class MetadataDialogBase;

/**
* Function for creating a metadata dialog for given attribute type.
*/
class MetadataDialogFactory
{
public:
    /**
    * Create a metadata dialog for given attribute type.
    *
    * @param type The attribute type.
    *
    * @param parent The parent widget.
    *
    * @return The created metadata dialog or \c NULL if the type is incorrect.
    */
    static MetadataDialogBase* createMetadataDialog( DefinitionInfo::Type type, QWidget* parent );
};

#endif
