/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "connectioninfo.h"

#include <QRegExp>

ConnectionInfo::ConnectionInfo() :
    m_userId( 0 ),
    m_access( NoAccess )
{
}

ConnectionInfo::~ConnectionInfo()
{
}

bool ConnectionInfo::checkVersion( const QString& version ) const
{
    return parseVersion( m_serverVersion ) >= parseVersion( version );
}

int ConnectionInfo::parseVersion( const QString& version )
{
    QRegExp versionRegExp( "(\\d+)\\.(\\d+)\\.(\\d+).*" );

    if ( !versionRegExp.exactMatch( version ) )
        return -1;

    int major = versionRegExp.cap( 1 ).toInt();
    int minor = versionRegExp.cap( 2 ).toInt();
    int patch = versionRegExp.cap( 3 ).toInt();

    return ( major << 16 ) + ( minor << 8 ) + patch;
}

bool ConnectionInfo::checkFeature( const QString& feature ) const
{
    return m_features.contains( feature );
}
