/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2009 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#ifndef CSVREPORTGENERATOR_H
#define CSVREPORTGENERATOR_H

#include <QStringList>

class CsvReportWriter;

/**
* Class for generating CSV reports.
*
* This class exctracts the information about a folder or an issue and
* outputs it to the CsvReportWriter.
*/
class CsvReportGenerator
{
public:
    /**
    * Type of the table included in the report.
    */
    enum Table
    {
        /** No table. */
        NoTable,
        /** Table with currently configured columns. */
        CurrentTable,
        /** Table with all available system and user columns. */
        FullTable
    };

public:
    /**
    * Default constructor.
    */
    CsvReportGenerator();

    /**
    * Destructor.
    */
    ~CsvReportGenerator();

public:
    /**
    * Set the list of issues used in the report.
    */
    void setFolder( int folderId, const QList<int>& issues );

    /**
    * Set the type of generated table.
    */
    void setTable( Table table );

    /**
    * Write the report to the CSV file.
    */
    void write( CsvReportWriter* writer );

private:
    void writeIssuesTable( const QList<int>& columns );

private:
    int m_folderId;
    QList<int> m_issues;

    Table m_table;

    CsvReportWriter* m_writer;
};

#endif
