#!/usr/local/bin/perl
# refresh.cgi
# Reload the list of packages from all managed hosts

require './cluster-software-lib.pl';
&header($text{'refresh_title'}, "");
print "<hr>\n";
$| = 1;

# Setup error handler for down hosts
sub ref_error
{
$ref_error_msg = join("", @_);
}
&remote_error_setup(\&ref_error);

print "<b>$text{'refresh_header'}</b><p>\n";
@hosts = &list_software_hosts();
@servers = &list_servers();
$p = 0;
foreach $h (@hosts) {
	local ($s) = grep { $_->{'id'} == $h->{'id'} } @servers;

	local ($rh = "READ$p", $wh = "WRITE$p");
	pipe($rh, $wh);
	if (!fork()) {
		close($rh);
		if ($s) {
			# Refresh the list
			&remote_foreign_require($s->{'host'}, "software",
						"software-lib.pl");
			if ($ref_error_msg) {
				# Host is down ..
				print $wh &serialise_variable($ref_error_msg);
				exit;
				}
			local $gconfig = &remote_foreign_config($s->{'host'}, undef);
			foreach $g ('os_type', 'os_version',
				    'real_os_type', 'real_os_version') {
				$h->{$g} = $gconfig->{$g};
				}
			local @old = map { $_->{'name'} } @{$h->{'packages'}};
			undef($h->{'packages'});
			local $n = &remote_foreign_call($s->{'host'}, "software",
							"list_packages");
			local $packages = &remote_eval($s->{'host'}, "software",
						       "\\%packages");
			local @added;
			for($i=0; $i<$n; $i++) {
				push(@{$h->{'packages'}},
				     { 'name' => $packages->{$i,'name'},
				       'class' => $packages->{$i,'class'},
				       'desc' => $packages->{$i,'desc'} });
				$idx = &indexof($packages->{$i,'name'}, @old);
				if ($idx < 0) {
					push(@added, $packages->{$i,'name'});
					}
				else {
					splice(@old, $idx, 1);
					}
				}
			&save_software_host($h);
			$rv = [ \@added, \@old ];
			}
		else {
			# remove from managed list
			&delete_software_host($h);
			$rv = undef;
			}
		print $wh &serialise_variable($rv);
		close($wh);
		exit;
		}
	close($wh);
	$p++;
	}

# Read back results
$p = 0;
foreach $h (@hosts) {
	local ($s) = grep { $_->{'id'} == $h->{'id'} } @servers;
	local $d = $s->{'desc'} ? $s->{'desc'} : $s->{'host'};
	local $rh = "READ$p";
	local $line = <$rh>;
	local $rv = &unserialise_variable($line);
	close($rh);

	if ($rv && ref($rv)) {
		@added = @{$rv->[0]};
		@old = @{$rv->[1]};
		if (@added && @old) {
			print &text('refresh_1', $d,
				    join(" ", @added),join(" ", @old)),"<br>\n";
			}
		elsif (@added) {
			print &text('refresh_2', $d,
				    join(" ", @added)),"<br>\n";
			}
		elsif (@old) {
			print &text('refresh_3', $d, join(" ", @old)),"<br>\n";
			}
		else {
			print &text('refresh_4', $d),"<br>\n";
			}
		}
	elsif ($rv) {
		print &text('refresh_failed', $d, $rv),"<br>\n";
		}
	else {
		print &text('refresh_del', $h->{'id'}),"<br>\n";
		}

	$p++;
	}

print "<p><b>$text{'refresh_done'}</b><p>\n";

&remote_finished();
print "<hr>\n";
&footer("", $text{'index_return'});

