#!/usr/local/bin/perl
# cron.pl
# Run a command on multiple servers at once

$no_acl_check++;
require './cluster-copy-lib.pl';

$copy = &get_copy($ARGV[0]);
$copy || die "Copy ID $ARGV[0] does not exist!";
$ENV{'SERVER_ROOT'} = $root_directory;	# hack to make 'this server' work
$status = "succeeded";
&run_cluster_job($copy, \&callback);

if ($copy->{'email'}) {
	# Email off status message
	&foreign_require("mailboxes", "mailboxes-lib.pl");

	# Construct and send the email
	local $from = $config{'from'} || "webmin\@".&get_system_hostname();
	local @files = split(/\t+/, $copy->{'files'});
	local $subject = "Cluster copy of ".join(", ", @files)." ".$status;
	local $mail = { 'headers' =>
			[ [ 'From', $from ],
			  [ 'To', $copy->{'email'} ],
			  [ 'Subject', $subject ] ],
			'attach' =>
			[ { 'headers' => [ [ 'Content-type', 'text/plain' ] ],
			    'data' => &entities_to_ascii($results) } ] };
	&mailboxes::send_mail($mail);
	}

# callback(error, &server, message, dirs, command-output)
sub callback
{
local $d = $_[1]->{'desc'} || $_[1]->{'host'};
if (!$_[0]) {
	# Failed - show error
	$results .= "Failed to run on $d : $_[2]\n\n";
	$status = "failed";
	}
else {
	if (@{$_[4]}) {
		# Show created directories
		$results .= "Created the following directories on $d :\n";
		foreach $f (@{$_[4]}) {
			$results .= "    $f\n";
			}
		$results .= "\n";
		}
	if (!@{$_[2]}) {
		# Nothing copied
		$results .= "No files were successfully copied to $d.\n";
		}
	else {
		# Show output if any
		$results .= "Copied the following files to $d :\n";
		foreach $f (@{$_[2]}) {
			$results .= "    $f\n";
			}
		$results .= "\n";
		}
	if (@{$_[3]}) {
		# Show error files
		$results .= "Failed to copy the following files to $d :\n";
		foreach $f (@{$_[3]}) {
			$results .= "    $f->[0] : $f->[1]\n";
			}
		$results .= "\n";
		}
	if ($_[5]) {
		# Show command output
		$results .= "Post-copy command output on $d :\n";
		$results .= $_[5];
		$results .= "\n";
		}
	}
}

