# cluster-software-lib.pl
# common functions for installing packages across a cluster

do '../web-lib.pl';
&init_config();
require '../ui-lib.pl';
&foreign_require("servers", "servers-lib.pl");

# list_software_hosts()
# Returns a list of all hosts whose software is being managed by this module
sub list_software_hosts
{
local @rv;
local $hdir = "$module_config_directory/hosts";
opendir(DIR, $hdir);
foreach $h (readdir(DIR)) {
	next if ($h =~ /\.host$/ || $h eq '.' || $h eq '..');
	local %host = ( 'id', $h );
	opendir(PDIR, "$hdir/$h") || next;
	foreach $p (readdir(PDIR)) {
		next if ($p eq "." || $p eq "..");
		local %pkg;
		&read_file("$hdir/$h/$p", \%pkg);
		push(@{$host{'packages'}}, \%pkg);
		}
	closedir(PDIR);
	&read_file("$hdir/$h.host", \%host);
	push(@rv, \%host);
	}
closedir(DIR);
return @rv;
}

# save_software_host(&host)
# Add or update a managed host with it's package list
sub save_software_host
{
local $hdir = "$module_config_directory/hosts";
mkdir($hdir, 0700);
if (-d "$hdir/$_[0]->{'id'}") {
	opendir(DIR, "$hdir/$_[0]->{'id'}");
	foreach $f (readdir(DIR)) {
		unlink("$hdir/$_[0]->{'id'}/$f");
		}
	closedir(DIR);
	}
else {
	mkdir("$hdir/$_[0]->{'id'}", 0700);
	}
foreach $p (@{$_[0]->{'packages'}}) {
	&write_file("$hdir/$_[0]->{'id'}/$p->{'name'}", $p);
	}
local %h = %{$_[0]};
delete($h{'packages'});
&write_file("$hdir/$_[0]->{'id'}.host", \%h);
}

# delete_software_host(&host)
sub delete_software_host
{
unlink("$module_config_directory/hosts/$_[0]->{'id'}.host");
system("rm -rf '$module_config_directory/hosts/$_[0]->{'id'}'");
}

# list_servers()
# Returns a list of all servers from the webmin servers module that can be
# managed, plus this server
sub list_servers
{
local @servers = &servers::list_servers();
return ( &servers::this_server(), grep { $_->{'user'} } @servers );
}

# server_name(&server)
sub server_name
{
return $_[0]->{'desc'} ? $_[0]->{'desc'} : $_[0]->{'host'};
}

# get_heiropen(hostid)
# Returns an array of open categories
sub get_heiropen
{
open(HEIROPEN, "$module_config_directory/heiropen.$_[0]");
local @heiropen = <HEIROPEN>;
chop(@heiropen);
close(HEIROPEN);
return @heiropen;
}

# save_heiropen(&heir, hostid)
sub save_heiropen
{
&open_tempfile(HEIR, ">$module_config_directory/heiropen.$_[1]");
foreach $h (@{$_[0]}) {
	&print_tempfile(HEIR, $h,"\n");
	}
&close_tempfile(HEIR);
}

# create_on_input(desc, [no-donthave], [no-have])
sub create_on_input
{
local @hosts = &list_software_hosts();
local @servers = &list_servers();
if ($_[0]) {
	print "<tr> <td><b>$_[0]</b></td>\n";
	print "<td>\n";
	}
print "<select name=server>\n";
print "<option value=-1>$text{'edit_all'}\n";
print "<option value=-2>$text{'edit_donthave'}\n" if (!$_[1]);
print "<option value=-3>$text{'edit_have'}\n" if (!$_[2]);
local @groups = &servers::list_all_groups(\@servers);
local $h;
foreach $h (@hosts) {
        local ($s) = grep { $_->{'id'} == $h->{'id'} } @servers;
	if ($s) {
		print "<option value='$s->{'id'}'>",
			$s->{'desc'} ? $s->{'desc'} : $s->{'host'},"\n";
		$gothost{$s->{'host'}}++;
		}
        }
local $g;
foreach $g (@groups) {
        local ($found, $m);
        foreach $m (@{$g->{'members'}}) {
                ($found++, last) if ($gothost{$m});
                }
        print "<option value='group_$g->{'name'}'>",
                &text('edit_group', $g->{'name'}),"\n" if ($found);
        }
print "</select>\n";
if ($_[0]) {
	print "</td> </tr>\n";
	}
}

# create_on_parse(prefix, &already, name)
sub create_on_parse
{
local @hosts = &list_software_hosts();
local @servers = &list_servers();
if ($in{'server'} == -2) {
	# Install on hosts that don't have it
	local %already = map { $_->{'id'}, 1 } @{$_[1]};
	@hosts = grep { !$already{$_->{'id'}} } @hosts;
        print "<b>",&text($_[0].'3', $_[2]),"</b><p>\n";
        }
elsif ($in{'server'} == -3) {
	# Install on hosts that do have it
	local %already = map { $_->{'id'}, 1 } @{$_[1]};
	@hosts = grep { $already{$_->{'id'}} } @hosts;
        print "<b>",&text($_[0].'6', $_[2]),"</b><p>\n";
        }
elsif ($in{'server'} =~ /^group_(.*)/) {
        # Install on members of some group
        local ($group) = grep { $_->{'name'} eq $1 }
                              &servers::list_all_groups(\@servers);
        @hosts = grep { local $hid = $_->{'id'};
                        local ($s) = grep { $_->{'id'} == $hid } @servers;
                        &indexof($s->{'host'}, @{$group->{'members'}}) >= 0 }
                      @hosts;
        print "<b>",&text($_[0].'4', $_[2], $group->{'name'}),
              "</b><p>\n";
        }
elsif ($in{'server'} != -1) {
        # Just install on one host
        @hosts = grep { $_->{'id'} == $in{'server'} } @hosts;
        local ($s) = grep { $_->{'id'} == $hosts[0]->{'id'} } @servers;
        print "<b>",&text($_[0].'5', $_[2],
                          &server_name($s)),"</b><p>\n";
        }
else {
        # Installing on every host
        print "<b>",&text($_[0], join(" ", @names)),"</b><p>\n";
        }
return @hosts;
}



1;

