#!/usr/local/bin/perl
# index.cgi
# Display usermin configuration categories

require './usermin-lib.pl';

if (!-r "$config{'usermin_dir'}/miniserv.conf") {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1);
	print "<p>",&text('index_econfig', "<tt>$config{'usermin_dir'}</tt>",
			  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";
	if ($config{'usermin_dir'} eq $standard_usermin_dir) {
		local $rpm;
		if (&foreign_check("software")) {
			local %sconfig = &foreign_config("software");
			$rpm++ if ($sconfig{'package_system'} eq 'rpm');
			}
		print "$text{'index_install'}<br>\n";
		print "<center><form action=upgrade.cgi method=post enctype=multipart/form-data>\n";
		print "<input type=hidden name=install value=1>\n";
		print "<input type=hidden name=source value=2>\n";
		print "<input type=hidden name=mode value=rpm>\n" if ($rpm);
		print "<input type=submit value='",
			$rpm ? $text{'index_rpm'} : $text{'index_tgz'},"'>\n";
		print "</form></center>\n";
		}
	&ui_print_footer("/", $text{'index'});
	exit;
	}
elsif (&same_file($config{'usermin_dir'}, $config_directory)) {
	&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1);

	print "<p>",&text('index_esame', "<tt>$config{'usermin_dir'}</tt>",
		  "$gconfig{'webprefix'}/config.cgi?$module_name"),"<p>\n";

	&ui_print_footer("/", $text{'index'});
	exit;
	}

$ver = &get_usermin_version();
&ui_print_header(undef, $text{'index_title'}, "", undef, 1, 1, 0,
	&help_search_link("usermin", "google"), undef, undef,
	&text('index_version', $ver));

@links = ( "edit_access.cgi", "edit_bind.cgi", "edit_ui.cgi", "edit_mods.cgi",
	   "edit_os.cgi", "edit_lang.cgi", "edit_upgrade.cgi",
	   "edit_session.cgi", "edit_assignment.cgi", "edit_categories.cgi",
	   "edit_themes.cgi", "edit_ssl.cgi", "list_configs.cgi",
	   "edit_acl.cgi", $ver < 0.942 ? ( ) : ( "list_restrict.cgi" ),
	   $ver < 0.76 ? ( ) : ( "edit_users.cgi", "edit_defacl.cgi" ) );
@titles = map { /_(\S+).cgi/; $text{"${1}_title"} } @links;
@icons = map { /_(\S+).cgi/; "images/$1.gif" } @links;
for($i=0; $i<@links; $i++) {
	$links[$i] =~ /_(\S+).cgi/;
	if (!$access{$1}) {
		splice(@links, $i, 1);
		splice(@titles, $i, 1);
		splice(@icons, $i, 1);
		}
	}
&icons_table(\@links, \@titles, \@icons);

$init = &foreign_check("init") && $access{'bootup'};
print "<hr>\n" if ($init || $access{'stop'});
print "<table width=100%>\n";

if ($access{'stop'}) {
	print "<tr>\n";
	&get_usermin_miniserv_config(\%miniserv);
	if (open(PID, $miniserv{'pidfile'}) && ($pid = int(<PID>)) &&
	    kill(0, $pid)) {
		close(PID);
		print "<form action=stop.cgi>\n";
		print "<td><input type=submit ",
		      "value='$text{'index_stop'}'></td>\n";
		print "<td>$text{'index_stopmsg'}</td></form>\n";
		}
	else {
		print "<form action=start.cgi>\n";
		print "<td><input type=submit ",
		      "value='$text{'index_start'}'></td>\n";
		print "<td>$text{'index_startmsg'}</td></form>\n";
		}
	print "</tr>\n";
	}

if ($init) {
	print "<tr>\n";
	&foreign_require("init", "init-lib.pl");
	$starting = &init::action_status("usermin");
	print "<form action=bootup.cgi>\n";
	print "<input type=hidden name=starting value='$starting'>\n";
	print "<td nowrap><input type=submit value='$text{'index_boot'}'>\n";
	printf "<input type=radio name=boot value=1 %s> %s\n",
		$starting == 2 ? "checked" : "", $text{'yes'};
	printf "<input type=radio name=boot value=0 %s> %s</td>\n",
		$starting == 2 ? "" : "checked", $text{'no'};
	print "<td>$text{'index_bootmsg'}</td>\n";
	print "</form></tr>\n";
	}
print "</table>\n";

&ui_print_footer("/", $text{'index'});
