#!/usr/local/bin/perl
# Show hosts in BIND cluster

require './bind8-lib.pl';
$access{'slaves'} || &error($text{'slaves_ecannot'});
&foreign_require("servers", "servers-lib.pl");
&ReadParse();
&ui_print_header(undef, $text{'slaves_title'}, "");

# Show existing servers
@servers = &list_slave_servers();
if (@servers) {
	print "<form action=slave_delete.cgi>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td width=10><br></td> ",
	      "<td><b>$text{'slaves_host'}</b></td> ",
	      "<td><b>$text{'slaves_view'}</b></td> ",
	      "<td><b>$text{'slaves_desc'}</b></td> ",
	      "<td><b>$text{'slaves_os'}</b></td> </tr>\n";
	foreach $s (@servers) {
		print "<tr $cb>\n";
		print "<td width=10><input type=checkbox name=d value=$s->{'id'}></td>\n";
		print "<td>",$s->{'host'},"</td>\n";
		print "<td>",$s->{'bind8_view'} ||
			     "<i>$text{'slaves_noview'}</i>","</td>\n";
		print "<td>",$s->{'desc'} || "<br>","</td>\n";
		foreach $t (@servers::server_types) {
			if ($t->[0] eq $s->{'type'}) {
				print "<td>$t->[1]</td>\n";
				}
			}
		print "</tr>\n";
		}
	print "</table>\n";
	print "<input type=submit value='$text{'slaves_delete'}'></form>\n";
	}
else {
	print "<b>$text{'slaves_none'}</b><p>\n";
	}

# Show buttons to add
@allservers = grep { $_->{'user'} } &servers::list_servers();
if (@allservers) {
	print "<form action=slave_add.cgi>\n";
	print "<table width=100%><tr>\n";
	%gothost = map { $_->{'id'}, 1 } @servers;
	@addservers = grep { !$gothost{$_->{'id'}} } @allservers;
	if (@addservers) {
		print "<td><input type=submit name=add value='$text{'slaves_add'}'>\n";
		print "<select name=server>\n";
		foreach $s (@addservers) {
			print "<option value=$s->{'id'}>",
				$s->{'desc'} ? $s->{'desc'} : $s->{'host'},"\n";
			}
		print "</select>\n";
		print "</td>\n";
		}
	@groups = &servers::list_all_groups(\@allservers);
	if (@groups) {
		print "<td align=right><input type=submit name=gadd ",
		      "value='$text{'slaves_gadd'}'>\n";
		print "<select name=group>\n";
		foreach $g (@groups) {
			print "<option>$g->{'name'}\n";
			}
		print "</select></td>\n";
		}
	print "</tr></table>\n";

	# Show inputs for view
	print "<table><tr>\n";
	print "<tr> <td><b>$text{'slaves_toview'}</b></td>\n";
	print "<td>",&ui_opt_textbox("view", undef, 15, $text{'slaves_noview2'},
			      $text{'slaves_inview'}),"</td> </tr>\n";

	print "<tr> <td><b>$text{'slaves_sync'}</b></td>\n";
	print "<td>",&ui_yesno_radio("sync", 0),"</td> </tr>\n";
	print "</table></form>\n";
	}
else {
	print "<b>$text{'slaves_need'}</b><p>\n";
	}

&ui_print_footer("", $text{'index_return'});

