#!/usr/local/bin/perl
# mailq.cgi
# Display messages currently in the queue.

require './postfix-lib.pl';
require './boxes-lib.pl';
&ReadParse();

$access{'mailq'} || &error($text{'mailq_ecannot'});
&ui_print_header(undef, $text{'mailq_title'}, "");

@qfiles = &list_queue();
if ($config{'mailq_sort'} == 0) {
	@qfiles = sort { $a->{'id'} cmp $b->{'id'} } @qfiles;
	}
elsif ($config{'mailq_sort'} == 1) {
	@qfiles = sort { lc($a->{'from'}) cmp lc($b->{'from'}) } @qfiles;
	}
elsif ($config{'mailq_sort'} == 2) {
	@qfiles = sort { lc($a->{'to'}) cmp lc($b->{'to'}) } @qfiles;
	}
elsif ($config{'mailq_sort'} == 4) {
	@qfiles = sort { lc($a->{'status'}) cmp lc($b->{'status'}) } @qfiles;
	}
elsif ($config{'mailq_sort'} == 5) {
	@qfiles = sort { $b->{'size'} <=> $a->{'size'} } @qfiles;
	}

if (@qfiles) {
	if (@qfiles > $config{'perpage'}) {
		# Need to show arrows
		print "<center>\n";
		$s = int($in{'start'});
		$e = $in{'start'} + $config{'perpage'} - 1;
		$e = @qfiles-1 if ($e >= @qfiles);
		if ($s) {
			printf "<a href='mailq.cgi?start=%d'>%s</a>\n",
			    $s - $config{'perpage'},
			    "<img src=/images/left.gif border=0 align=middle>";
			}
		print "<font size=+1>",&text('mail_pos', $s+1, $e+1,
					     scalar(@qfiles)),"</font>\n";
		if ($e < @qfiles-1) {
			printf "<a href='mailq.cgi?start=%d'>%s</a>\n",
			    $s + $config{'perpage'},
			    "<img src=/images/right.gif border=0 align=middle>";
			}
		print "</center>\n";
		}
	else {
		# Can show them all
		$s = 0;
		$e = @qfiles - 1;
		}

	# Show queued messages
	print "<form action=delete_queues.cgi>\n";
	print &select_all_link("file", 0, $text{'mailq_all'}),"&nbsp;\n";
	print &select_invert_link("file", 0, $text{'mailq_invert'}),"<br>\n";
	print "<table border width=100%>\n";
	print "<tr $tb> <td><br></td> <td><b>$text{'mailq_id'}</b></td> ",
	      "<td><b>$text{'mailq_date'}</b></td> ",
	      "<td><b>$text{'mailq_from'}</b></td> ",
	      "<td><b>$text{'mailq_to'}</b></td> ",
	      "<td><b>$text{'mailq_size'}</b></td> ",
	      "<td><b>$text{'mailq_status'}</b></td> </tr>\n";
	for($i=$s; $i<=$e; $i++) {
		$q = $qfiles[$i];
		print "<tr $cb>\n";
		print "<td><input type=checkbox name=file value=$q->{'id'}></td>\n";
		print "<td><a href='view_mailq.cgi?id=$q->{'id'}'>$q->{'id'}</a></td>\n";
		local $size = $q->{'size'} > 1000000 ?
				int($q->{'size'} / 1000000)." MB" :
			      $q->{'size'} > 1000 ?
				int($q->{'size'} / 1000)." kB" :
				$q->{'size'}." b";
		print "<td><font size=1>$q->{'date'}</td>\n";
		print "<td><font size=1>",&html_escape($q->{'from'}),
		      "</font></td>\n";
		print "<td><font size=1>",&html_escape($q->{'to'}),
		      "</font></td>\n";
		print "<td><font size=1>$size</font></td>\n";
		print "<td><font size=1>",&html_escape($q->{'status'}),
		      "</font></td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	print &select_all_link("file", 0, $text{'mailq_all'}),"&nbsp;\n";
	print &select_invert_link("file", 0, $text{'mailq_invert'}),"<p>\n";
	print "<input type=submit value='$text{'mailq_delete'}'><p>\n";
	print "</form>\n";

	# Show queue search form
	print "<form action=mailq_search.cgi>\n";
	print "<b>$text{'mailq_search'}</b>\n";
	print "<select name=field>\n";
	foreach $f ('from', 'to', 'date', 'size', '',
	    	    '!from', '!to', '!date', '!size') {
		printf "<option value='%s'>%s\n", $f, $text{"match_$f"};
		}
	print "</select>\n";
	print "<input name=match size=20>\n";
	print "&nbsp;<input type=submit value='$text{'mail_ok'}'>\n";
	print "</form><p>\n";

	# Show flush button, if the needed command is installed
	if (&has_command($config{'postfix_queue_command'})) {
		print "<hr>\n";
		print "<table width=100%><tr><form action=flushq.cgi>\n";
		print "<td><input type=submit ",
		      "value='$text{'mailq_flush'}'></td>\n";
		print "<td>$text{'mailq_flushdesc'}</td>\n";
		print "</form></tr></table>\n";
		}
	}
else {
	print "<b>$text{'mailq_none'}</b> <p>\n";
	}

&ui_print_footer("", $text{'index_return'});


