# access-lib.pl
# Functions for the access_db table

# access_dbm(&config)
# Returns the filename and type of the access database, or undef if none
sub access_dbm
{
foreach $f (&find_type("K", $_[0])) {
        if ($f->{'value'} =~ /^access\s+(\S+)[^\/]+(\S+)$/) {
		return ($2, $1);
                }
	}
return undef;
}

# access_file(&config)
# Returns the filename of the text access file, or undef if none
sub access_file
{
return &find_textfile($config{'access_file'}, &access_dbm($_[0]));
}

# list_access(textfile)
sub list_access
{
local($lnum, @rv);
$lnum = 0;
open(ACC, $_[0]);
while(<ACC>) {
	s/\r|\n//g;     # remove newlines
	s/#.*$//g;	# remove comments
	if (/^(\S+)\s+(.*)/) {
		local(%acc);
		$acc{'from'} = $1;
		$acc{'action'} = $2;
		$acc{'line'} = $lnum;
		$acc{'num'} = scalar(@rv);
		if ($acc{'from'} =~ /^(Connect|From|To):(.*)/i) {
			$acc{'tag'} = $1;
			$acc{'from'} = $2;
			}
		push(@rv, \%acc);
		}
	$lnum++;
	}
close(ACC);
return @rv;
}

# create_access(&details, textfile, dbmfile, dbmtype)
# Create a new access database entry
sub create_access
{
local(%acc);
local $from = $_[0]->{'tag'} ? "$_[0]->{'tag'}:$_[0]->{'from'}"
			     : $_[0]->{'from'};
&open_tempfile(ACC, ">> $_[1]");
&print_tempfile(ACC, "$from\t$_[0]->{'action'}\n");
&close_tempfile(ACC);
if ($_[3] eq "dbm") {
	dbmopen(%acc, $_[2], 0644);
	$acc{$from} = $_[0]->{'action'};
	dbmclose(%acc);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# delete_access(&details, textfile, dbmfile, dbmtype)
# Delete an existing access entry
sub delete_access
{
local(@acc, %acc);
local $from = $_[0]->{'tag'} ? "$_[0]->{'tag'}:$_[0]->{'from'}"
			     : $_[0]->{'from'};
open(ACC, $_[1]);
@acc = <ACC>;
close(ACC);
splice(@acc, $_[0]->{'line'}, 1);
&open_tempfile(ACC, "> $_[1]");
&print_tempfile(ACC, @acc);
&close_tempfile(ACC);
if ($_[3] eq "dbm") {
	dbmopen(%acc, $_[2], 0644);
	delete($acc{$from});
	dbmclose(%acc);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# modify_access(&old, &details, textfile, dbmfile, dbmtype)
# Change an existing access entry
sub modify_access
{
local(@acc, %acc);
local $oldfrom = $_[0]->{'tag'} ? "$_[0]->{'tag'}:$_[0]->{'from'}"
			     : $_[0]->{'from'};
local $from = $_[1]->{'tag'} ? "$_[1]->{'tag'}:$_[1]->{'from'}"
			     : $_[1]->{'from'};
open(ACC, $_[2]);
@acc = <ACC>;
close(ACC);
splice(@acc, $_[0]->{'line'}, 1, "$from\t$_[1]->{'action'}\n");
&open_tempfile(ACC, "> $_[2]");
&print_tempfile(ACC, @acc);
&close_tempfile(ACC);
if ($_[4] eq "dbm") {
	dbmopen(%acc, $_[3], 0644);
	delete($acc{$oldfrom});
	$acc{$from} = $_[1]->{'action'};
	dbmclose(%acc);
	}
else { &run_makemap($_[2], $_[3], $_[4]); }
}

# access_form([&details])
sub access_form
{
local($v, $mode, $addr);
$v = $_[0];
print "<form action=save_access.cgi>\n";
if ($_[0]) { print "<input type=hidden name=num value=$v->{'num'}>\n"; }
else { print "<input type=hidden name=new value=1>\n"; }
print "<table border>\n";
print "<tr $tb> <td><b>",$v ? $text{'sform_edit'} : $text{'sform_create'},
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

local $src = $v->{'from'} =~ /^\S+\@\S+$/ ? 0 :
	     $v->{'from'} =~ /^[0-9\.]+$/ ? 1 :
	     $v->{'from'} =~ /^\S+\@$/ ? 2 :
	     $v->{'from'} =~ /^[A-z0-9\-\.]+$/ ? 3 : 0;
print "<tr> <td><b>$text{'sform_source'}</b></td>\n";
print "<td colspan=2><select name=from_type>\n";
for($i=0; $i<4; $i++) {
	printf "<option value=$i %s>%s\n",
		$i == $src ? "selected" : "", $text{"sform_type$i"};
	}
print "</select>\n";
$v->{'from'} =~ s/\@$//g if ($src == 2);
print "<input name=from size=25 value=\"$v->{'from'}\"></td> </tr>\n";

local $ver = &get_sendmail_version();
if ($v->{'tag'} || $ver >= 8.10) {
	print "<tr> <td><b>$text{'sform_tag'}</b></td>\n";
	print "<td colspan=2><select name=tag>\n";
	local $t;
	foreach $t ("", "From", "To", "Connect", "Spam") {
		printf "<option value='%s' %s>%s\n",
			$t, lc($t) eq lc($v->{'tag'}) ? "selected" : "",
			$text{'sform_tag_'.lc($t)};
		}
	print "</select></td> </tr>\n";
	}

print "<tr> <td><b>$text{'sform_action'}</b></td>\n";
printf "<td><input type=radio name=action value=OK %s> $text{'sform_ok'}</td>\n", $v->{'action'} eq "OK" || !$v->{'action'} ? "checked" : "";
printf "<td><input type=radio name=action value=RELAY %s> $text{'sform_relay'}</td> </tr>\n", $v->{'action'} eq "RELAY" ? "checked" : "";
print "<tr> <td></td>\n";
printf "<td><input type=radio name=action value=REJECT %s> $text{'sform_reject'}</td>\n", $v->{'action'} eq "REJECT" ? "checked" : "";
printf "<td><input type=radio name=action value=DISCARD %s> $text{'sform_discard'}</td> </tr>\n", $v->{'action'} eq "DISCARD" ? "checked" : "";
if ($v->{'action'} =~ /(\d+)\s*(.*)$/) { $err = $1; $msg = $2; }
print "<tr> <td></td>\n";
printf "<td colspan=2><input type=radio name=action value=0 %s> $text{'sform_err'}\n",
	$err ? "checked" : "";
print "<input name=err size=4 value=\"$err\"> $text{'sform_msg'}\n";
print "<input name=msg size=20 value=\"$msg\"></td> </tr>\n";

print "<tr> <td colspan=3 align=right>\n";
if ($_[0]) {
        print "<input type=submit value='$text{'save'}'>\n";
        print "<input type=submit name=delete value='$text{'delete'}'>\n";
        }
else { print "<input type=submit value='$text{'create'}'>\n"; }
print "</td> </tr>\n";
print "</table></td></tr></table></form>\n";
}

1;

