#!/usr/local/bin/perl
# del_mailqs.cgi
# Delete some mail messages from the queue

require './sendmail-lib.pl';
require './boxes-lib.pl';
&ReadParse();
&error_setup($text{'delq_err'});
$access{'mailq'} == 2 || &error($text{'delq_ecannot'});
$in{'file'} || &error($text{'delq_enone'});
&ui_print_header(undef, $text{'delq_titles'}, "");

$count = 0;
$conf = &get_sendmailcf();
foreach $file (split(/\0/, $in{'file'})) {
	print &text('delq_file', "<tt>$file</tt>"),"&nbsp;&nbsp;&nbsp;\n";

	local $ok;
	foreach $mqueue (&mailq_dir($conf)) {
		$ok++ if ($file =~ /^$mqueue\//);
		}
	if (!$ok) {
		print $text{'delq_efile'},"<br>\n";
		next;
		}

	if ($file =~ /\.\./) {
		print $text{'delq_efile'},"<br>\n";
		next;
		}
	if (!-r $file) {
		print $text{'delq_egone'},"<br>\n";
		next;
		}

	$mail = &mail_from_queue($file, "auto");
	if (!&can_view_qfile($mail)) {
		print $text{'delq_ecannot'},"<br>\n";
		next;
		}

	if (-r $mail->{'lfile'} && !$in{'locked'}) {
		print $text{'delq_elocked'},"<br>\n";
		next;
		}

	unlink($mail->{'file'}, $mail->{'dfile'}, $mail->{'lfile'});
	print $text{'delq_ok'},"<br>\n";
	$count++;
	}
&webmin_log("delmailq", undef, undef, { 'count' => $count }) if ($count);
&ui_print_footer("list_mailq.cgi", $text{'mailq_return'});

