# domain-lib.pl
# Functions for the domains table

# domains_dbm(&config)
# Returns the filename and type of the domains database, or undef if none
sub domains_dbm
{
foreach $f (&find_type("K", $_[0])) {
        if ($f->{'value'} =~ /^domaintable\s+(\S+)[^\/]+(\S+)$/) {
		return ($2, $1);
                }
	}
return undef;
}

# domains_file(&config)
# Returns the filename of the text domains file, or undef if none
sub domains_file
{
return &find_textfile($config{'domains_file'}, &domains_dbm($_[0]));
}

# list_domains(textfile)
sub list_domains
{
local($lnum, @rv);
$lnum = 0;
open(DOM, $_[0]);
while(<DOM>) {
	s/\r|\n//g;     # remove newlines
	s/#.*$//g;	# remove comments
	if (/^(\S+)\s+(.*)/) {
		local(%dom);
		$dom{'from'} = $1;
		$dom{'to'} = $2;
		$dom{'line'} = $lnum;
		$dom{'num'} = scalar(@rv);
		push(@rv, \%dom);
		}
	$lnum++;
	}
close(DOM);
return @rv;
}

# create_domain(&details, textfile, dbmfile, dbmtype)
# Create a new domain mapping
sub create_domain
{
local(%dom);
&open_tempfile(DOM, ">> $_[1]");
&print_tempfile(DOM, "$_[0]->{'from'}\t$_[0]->{'to'}\n");
&close_tempfile(DOM);
if ($_[3] eq "dbm") {
	dbmopen(%dom, $_[2], 0644);
	$dom{$_[0]->{'from'}} = $_[0]->{'to'};
	dbmclose(%dom);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# delete_domain(&details, textfile, dbmfile, dbmtype)
# Delete an existing domain mapping
sub delete_domain
{
local(@dom, %dom);
open(DOM, $_[1]);
@dom = <DOM>;
close(DOM);
splice(@dom, $_[0]->{'line'}, 1);
&open_tempfile(DOM, "> $_[1]");
&print_tempfile(DOM, @dom);
&close_tempfile(DOM);
if ($_[3] eq "dbm") {
	dbmopen(%dom, $_[2], 0644);
	delete($dom{$_[0]->{'from'}});
	dbmclose(%dom);
	}
else { &run_makemap($_[1], $_[2], $_[3]); }
}

# modify_domain(&old, &details, textfile, dbmfile, dbmtype)
# Change an existing domain
sub modify_domain
{
local(@dom, %dom);
open(DOM, $_[2]);
@dom = <DOM>;
close(DOM);
splice(@dom, $_[0]->{'line'}, 1, "$_[1]->{'from'}\t$_[1]->{'to'}\n");
&open_tempfile(DOM, "> $_[2]");
&print_tempfile(DOM, @dom);
&close_tempfile(DOM);
if ($_[4] eq "dbm") {
	dbmopen(%dom, $_[3], 0644);
	delete($dom{$_[0]->{'from'}});
	$dom{$_[1]->{'from'}} = $_[1]->{'to'};
	dbmclose(%dom);
	}
else { &run_makemap($_[2], $_[3], $_[4]); }
}

# domain_form([&details])
sub domain_form
{
local $v = $_[0];
print "<form action=save_domain.cgi>\n";
if ($_[0]) { print "<input type=hidden name=num value=$v->{'num'}>\n"; }
else { print "<input type=hidden name=new value=1>\n"; }
print "<table border>\n";
print "<tr $tb> <td><b>",$v ? $text{'dform_edit'} : $text{'dform_create'},
      "</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

print "<tr> <td><b>From domain</b></td>\n";
print "<td><input name=from size=25 value=\"$v->{'from'}\"></td> </tr>\n";

print "<tr> <td><b>To domain</b></td>\n";
print "<td><input name=to size=25 value=\"$v->{'to'}\"></td> </tr>\n";

print "<tr> <td colspan=3 align=right>\n";
if ($_[0]) {
        print "<input type=submit value=\"$text{'save'}\">\n";
        print "<input type=submit name=delete value=\"$text{'delete'}\">\n";
        }
else { print "<input type=submit value=\"$text{'create'}\"\n"; }
print "</td> </tr>\n";
print "</table></td></tr></table></form>\n";
}

1;

