#!/usr/local/bin/perl
# burner-lib.pl
# Common functions for managing the CD burning profiles

do '../web-lib.pl';
&init_config();

# list_profiles()
# Returns a list of all burn profiles available for use.
# Each profile can be for an ISO, a list of directory mappings, or a list of
# audio track files
sub list_profiles
{
local @rv;
opendir(DIR, $module_config_directory);
foreach $f (sort { $a cmp $b } readdir(DIR)) {
	next if ($f !~ /^(\S+)\.burn$/);
	push(@rv, &get_profile($1));
	}
closedir(DIR);
return @rv;
}

# get_profile(id)
sub get_profile
{
local %burn;
&read_file("$module_config_directory/$_[0].burn", \%burn);
$burn{'id'} = $_[0];
return \%burn;
}

# save_profile(&profile)
sub save_profile
{
$_[0]->{'id'} = time() if (!$_[0]->{'id'});
&write_file("$module_config_directory/$_[0]->{'id'}.burn", $_[0]);
}

# delete_profile(&profile)
sub delete_profile
{
unlink("$module_config_directory/$_[0]->{'id'}.burn");
}

# list_cdrecord_devices()
# Returns a list of all possible CD burner devices
sub list_cdrecord_devices
{
local @rv;
open(SCAN, "$config{'cdrecord'} -scanbus 2>/dev/null |");
while(<SCAN>) {
	if (/^\s+(\S+)\s+\d+\)\s+'(.*)'\s+'(.*)'\s+'(.*)'\s+(.*)/) {
		push(@rv, { 'dev' => $1,
			    'name' => "$2$3$4",
			    'type' => $5 });
		}
	}
close(SCAN);
return @rv;
}

@cdr_drivers = ( 'cdd2600', 'plextor', 'plextor-scan', 'generic-mmc',
		 'generic-mmc-raw', 'ricoh-mp6200', 'yamaha-cdr10x',
		 'teac-cdr55', 'sony-cdu920', 'sony-cdu948', 'taiyo-yuden',
		 'toshiba' );

1;

