#!/usr/local/bin/perl
# edit_mod.cgi
# Display the details and documentation of a perl module

require './cpan-lib.pl';
&ReadParse();
@mods = &list_perl_modules();
$mod = $mods[$in{'idx'}];
$midx = $in{'midx'} ? $in{'midx'} : 0;

&header($text{'edit_title'}, "");
print "<hr>\n";

print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'edit_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table width=100%>\n";

@m = @{$mod->{'mods'}};
($desc, $ver) = &module_desc($mod, $midx);
print "<tr> <td><b>$text{'edit_mod'}</b></td>\n";
print "<td>$m[$midx] $ver</td>\n";

print "<td><b>$text{'edit_desc'}</b></td>\n";
print "<td>",$desc ? &html_escape($desc) : $text{'edit_none'},"</td> </tr>\n";

print "<tr> <td><b>$text{'edit_date'}</b></td>\n";
print "<td nowrap>$mod->{'date'}</td>\n";

print "<td><b>$text{'edit_file'}</b></td>\n";
print "<td>$mod->{'files'}->[$midx]</td> </tr>\n";

if ($midx == $mod->{'master'} && @m > 1) {
	print "<tr> <td valign=top><b>$text{'edit_subs'}</b></td>\n";
	print "<td colspan=3>";
	for($i=0; $i<@m; $i++) {
		print "<a href='edit_mod.cgi?idx=$in{'idx'}&midx=$i'>",
		      "$m[$i]</a>&nbsp;&nbsp;\n" if ($i != $mod->{'master'});
		}
	print "</td> </tr>\n";
	}

print "</table></td></tr></table>\n";

if ($midx == $mod->{'master'} && !$mod->{'noremove'}) {
	print "<table width=100%> <tr>\n";
	print "<form action=uninstall.cgi><td>\n";
	print "<input type=hidden name=idx value='$in{'idx'}'>\n";
	print "<input type=submit value='$text{'edit_uninstall'}'>\n";
	print "</td></form>\n";

	print "<form action=download.cgi><td align=right>\n";
	print "<input type=hidden name=cpan value='$mod->{'mods'}->[0]'>\n";
	print "<input type=hidden name=source value=3>\n";
	print "<input type=submit value='$text{'edit_upgrade'}'>\n";
	print "</td></form>\n";
	print "</table>\n";
	}

open(DOC, "$perl_doc -t '$m[$midx]' 2>/dev/null |");
while(<DOC>) { $doc .= $_; }
close(DOC);
if ($doc =~ /\S/) {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'edit_header2'}</b></td> </tr>\n";
	print "<tr $cb> <td><pre>";
	print &html_escape($doc);
	print "</pre></td></tr></table><p>\n";
	}

print "<hr>\n";
&footer($midx > 0 ? ( "edit_mod.cgi?idx=$in{'idx'}", $text{'edit_return'} )
		  : ( ),
	"", $text{'index_return'});

