#!/usr/local/bin/perl
# search_group.cgi
# Ask the LDAP server to return groups matching some query

require './ldap-useradmin-lib.pl';
&ReadParse();

# Do the search
$ldap = &ldap_connect();
$base = &get_group_base();
if ($in{'match'} == 0) {
	$search = "($in{'field'}=$in{'what'})";
	}
elsif ($in{'match'} == 1) {
	$search = "($in{'field'}=*$in{'what'}*)";
	}
elsif ($in{'match'} == 2) {
	$search = "(!($in{'field'}=$in{'what'}))";
	}
elsif ($in{'match'} == 3) {
	$search = "(!($in{'field'}=*$in{'what'}*))";
	}
$rv = $ldap->search(base => $base,
		    filter => "(&(objectClass=posixGroup)$search)");
if ($rv->code) {
	&error(&text('search_err', "<tt>$search</tt>",
		     "<tt>$base</tt>", $rv->error));
	}
@groups = $rv->all_entries;

&header($text{'search_title'}, "");
print "<hr>\n";
if (@groups == 0) {
	print "<p><b>$text{'search_gnotfound'}</b>.<p>\n";
	}
else {
	print "<table border width=100%>\n";
	print "<tr $tb> <td><b>$text{'gedit_group'}</b></td> ",
	      "<td><b>$text{'gedit_gid'}</b></td> ",
	      "<td><b>$text{'gedit_members'}</b></td> </tr>\n";
	foreach $g (sort { lc($a->dn()) cmp lc($b->dn()) } @groups) {
		print "<tr $cb>\n";
		print "<td><a href='edit_group.cgi?dn=",
			&urlize($g->dn()),"'>",
			$g->get_value('cn'),"</a></td>\n";
		print "<td>",$g->get_value('gidNumber'),"</td>\n";
		print "<td>",(join(" ", $g->get_value("memberUid")) ||
			      "<br>"),"</td>\n";
		print "</tr>\n";
		}
	print "</table>\n";
	}
print "<hr>\n";
&footer("", $text{'index_return'});

