#!/usr/local/bin/perl
# list_hosts.cgi
# Display host access records

require './postgresql-lib.pl';
$access{'users'} || &error($text{'host_ecannot'});
&header($text{'host_title'}, "", "list_hosts");
print "<hr>\n";

print "$text{'host_desc'}<p>\n";

$v = &get_postgresql_version();
@hosts = &get_hba_config($v);
print "<a href='edit_host.cgi?new=1'>$text{'host_add'}</a><br>\n";
print "<table border width=100%>\n";
print "<tr $tb> <td width=33%><b>$text{'host_address'}</b></td> ",
      "<td width=33%><b>$text{'host_db'}</b></td> ",
      ($v >= 7.3 ? "<td width=33%><b>$text{'host_user'}</b></td> " : ""),
      "<td width=33%><b>$text{'host_auth'}</b></td> ",
      "<td><b>$text{'host_move'}</b></td> </tr>\n";
foreach $h (@hosts) {
	print "<tr $cb>\n";
	local $ssl = $h->{'type'} eq 'hostssl' ? " ($text{'host_viassl'})" : "";
	print "<td><a href='edit_host.cgi?idx=$h->{'index'}'>",
	   &html_escape(
	      $h->{'type'} eq 'local' ? $text{'host_local'} :
	      $h->{'netmask'} eq '255.255.255.255' ? $h->{'address'}.$ssl :
	      $h->{'netmask'} eq '255.255.255.255' ? $text{'host_any'}.$ssl :
	      $h->{'address'}.'/'.$h->{'netmask'}.$ssl),"</a></td>\n";
	print "<td>",$h->{'db'} eq 'all' ? $text{'host_all'} :
		     $h->{'db'} eq 'sameuser' ? $text{'host_same'} :
					        $h->{'db'},"</td>\n";
	if ($v >= 7.3) {
		print "<td>",$h->{'user'} eq 'all' ? $text{'host_uall'}
						   : $h->{'user'},"</td>\n";
		}
	print "<td>",$text{"host_$h->{'auth'}"} || $h->{'auth'},"</td>\n";
	print "<td>";
	if ($h eq $hosts[@hosts-1]) {
		print "<img src=images/gap.gif>";
		}
	else {
		print "<a href='down.cgi?idx=$h->{'index'}'>",
		      "<img src=images/down.gif border=0></a>";
		}
	if ($h eq $hosts[0]) {
		print "<img src=images/gap.gif>";
		}
	else {
		print "<a href='up.cgi?idx=$h->{'index'}'>",
		      "<img src=images/up.gif border=0></a>";
		}
	print "</td> </tr>\n";
	}
print "</table>\n";
print "<a href='edit_host.cgi?new=1'>$text{'host_add'}</a><p>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

