#!/usr/local/bin/perl
# index.cgi
# Display a menu of different kinds of options

require './squid-lib.pl';

# Check for squid config file
if (!-r $config{'squid_conf'}) {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>";
	print &text('index_msgnoconfig',$config{'squid_conf'},
		$module_name);
	print "\n<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

# Check for the squid executable
if (!&has_command($config{'squid_path'})) {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>";
	print &text('index_msgnoexe',$config{'squid_path'},
		$module_name);
	print "\n<p>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

# Check the version number
$fullver = $ver = `$config{'squid_path'} -v 2>&1`;
if ($ver =~ /version\s+(\S+)/i) {
	$ver = $1;
	}
if ($ver =~ /(1\.1)\.\d+/ || $ver =~ /(1)\.NOVM/ ||
    $ver =~ /(2\.0)\./ || $ver =~ /(2\.1)\./ || $ver =~ /(2\.2)\./ ||
    $ver =~ /(2\.3)\./ || $ver =~ /(2\.4)\./ || $ver =~ /(2\.5)\./ ||
    $ver =~ /(3\.0)/) {
	# Save version number
	open(VERSION, ">$module_config_directory/version");
	print VERSION $1,"\n";
	close(VERSION);
	$squid_version = $1;
	}
else {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p>";
	print &text('index_msgnosupported2', "<tt>1.1</tt>", "<tt>2.5</tt>"),
	      "<p>\n";
	print &text('index_squidver', "$config{'squid_path'} -v"),"\n";
	print "<pre>$fullver</pre>\n";
	print "<hr>\n";
	&footer("/", $text{'index_return'});
	exit;
	}

# Check for the cache directory
$conf = &get_config();
if (!&check_cache($conf, \@caches)) {
	&header($text{'index_header'}, "", undef, 1, 1);
	print "<hr>\n";
	print "<p><center>\n";
	if (@caches > 1) {
		print &text('index_msgnodir1', join(", ", @caches));
		}
	else {
		print &text('index_msgnodir2', $caches[0]);
		}
	print $text{'index_msgnodir3'},"<br>\n";
	print "<form action=init_cache.cgi>\n";
	print "<input type=submit value=\"$text{'index_buttinit'}\">\n";
	local $def = defined(getpwnam("squid")) ? "squid" :
		     defined(getpwnam("httpd")) ? "httpd" : undef;
	if (!&find_config("cache_effective_user", $conf)) {
		print $text{'index_asuser'}," ",&unix_user_input("user", $def),
			"<p>\n";
		}
	else {
		print "<input type=hidden name=nouser value=1>\n";
		}
	print "<input type=hidden name=caches value=\"",
		join(" ",@caches),"\">\n";
	print "</form></center>\n";
	print "<hr>\n";
	}
else {
	&header($text{'index_header'}, "", "intro",
		1, 1, 0, &restart_button()."<br>".
			 &help_search_link("squid", "doc", "google"),
		undef, undef, &text('index_version', $squid_version));
	print "<hr>\n";
	}

if ($squid_version < 2) {
	$auth = 1;
	}
else {
	local $file = &get_auth_file($conf);
	if ($file) {
		open(AUTH, $file);
		local $line = <AUTH>;
		close(AUTH);
		if (!$line || $line =~ /^(\S+):(\S+)/) {
			$auth = 2;
			}
		}
	}
$calamaris = &has_command($config{'calamaris'});
$delay = $squid_version >= 2.3;
$authparam = $squid_version >= 2;

@otitles = ( 'portsnets', 'othercaches', 'musage', 'logging',
	     'copts', 'hprogs', 'actrl', 'admopts',
	     ($auth ? ( 'proxyauth' ) : ( ) ),
	     ($authparam ? ( 'authparam' ) : ( ) ),
	     $delay ? ( 'delay' ) : ( ), 'miscopt', 'cms',
	     'rebuild', $calamaris ? ( 'calamaris' ) : ( ) );
@olinks =  ( "edit_ports.cgi", "edit_icp.cgi", "edit_mem.cgi",
	     "edit_logs.cgi", "edit_cache.cgi", "edit_progs.cgi",
	     "edit_acl.cgi", "edit_admin.cgi",
	     ($auth == 1 ? ( "edit_auth.cgi" ) :
	      $auth == 2 ? ( "edit_nauth.cgi" ) : ( ) ),
	     $authparam ? ( "edit_authparam.cgi" ) : ( ),
	     $delay ? ( 'edit_delay.cgi' ) : ( ),
	     "edit_misc.cgi", "cachemgr.cgi", "clear.cgi",
	     $calamaris ? ( "calamaris.cgi" ) : ( ) );
for($i=0; $i<@otitles; $i++) {
	if (!$access{$otitles[$i]}) {
		splice(@otitles, $i, 1);
		splice(@olinks, $i, 1);
		$i--;
		}
	else {
		$otitles[$i] = $text{'index_'.$otitles[$i]};
		}
	}
@oicons =  map { $t=$_; $t=~s/cgi/gif/; $t=~s/edit_//; "images/$t" } @olinks;
&icons_table(\@olinks, \@otitles, \@oicons);

print "<hr>\n";
&footer("/", $text{'index_return'});

